/* $Id: tstIEMAImplDataFpuLdSt.cpp $ */
/** @file
 * IEM Assembly Instruction Helper Testcase Data - r150722 on Intel(R) Core(TM) i9-10980XE CPU @ 3.00GHz.
 */

/*
 * Copyright (C) 2022-2023 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#include "tstIEMAImpl.h"

FPU_LD_CONST_TEST_T const g_aTests_fld1[] =
{
    { 0x016e, 0x841c, 0x3c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #0 */
    { 0x056e, 0x841c, 0x3c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #1 */
    { 0x096e, 0x841c, 0x3c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #2 */
    { 0x0d6e, 0x841c, 0x3c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #3 */
    { 0x0234, 0x891a, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #4 */
    { 0x0634, 0x891a, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #5 */
    { 0x0a34, 0x891a, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #6 */
    { 0x0e34, 0x891a, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #7 */
    { 0x0058, 0x750e, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #8 */
    { 0x0458, 0x750e, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #9 */
    { 0x0858, 0x750e, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10 */
    { 0x0c58, 0x750e, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #11 */
    { 0x004b, 0x2a52, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #12 */
    { 0x044b, 0x2a52, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #13 */
    { 0x084b, 0x2a52, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #14 */
    { 0x0c4b, 0x2a52, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #15 */
    { 0x0212, 0xb795, 0x3d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #16 */
    { 0x0612, 0xb795, 0x3d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #17 */
    { 0x0a12, 0xb795, 0x3d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #18 */
    { 0x0e12, 0xb795, 0x3d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #19 */
    { 0x0311, 0x5af9, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #20 */
    { 0x0711, 0x5af9, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #21 */
    { 0x0b11, 0x5af9, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #22 */
    { 0x0f11, 0x5af9, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #23 */
    { 0x0269, 0xf386, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #24 */
    { 0x0669, 0xf386, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #25 */
    { 0x0a69, 0xf386, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #26 */
    { 0x0e69, 0xf386, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #27 */
    { 0x0308, 0xc898, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #28 */
    { 0x0708, 0xc898, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #29 */
    { 0x0b08, 0xc898, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #30 */
    { 0x0f08, 0xc898, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #31 */
    { 0x013c, 0xbf3f, 0x3d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #32 */
    { 0x053c, 0xbf3f, 0x3d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #33 */
    { 0x093c, 0xbf3f, 0x3d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #34 */
    { 0x0d3c, 0xbf3f, 0x3d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #35 */
    { 0x035f, 0xfb61, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #36 */
    { 0x075f, 0xfb61, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #37 */
    { 0x0b5f, 0xfb61, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #38 */
    { 0x0f5f, 0xfb61, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #39 */
    { 0x0221, 0x0f29, 0x3d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #40 */
    { 0x0621, 0x0f29, 0x3d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #41 */
    { 0x0a21, 0x0f29, 0x3d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #42 */
    { 0x0e21, 0x0f29, 0x3d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #43 */
    { 0x0139, 0xef43, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #44 */
    { 0x0539, 0xef43, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #45 */
    { 0x0939, 0xef43, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #46 */
    { 0x0d39, 0xef43, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #47 */
    { 0x0035, 0x6e52, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #48 */
    { 0x0435, 0x6e52, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #49 */
    { 0x0835, 0x6e52, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #50 */
    { 0x0c35, 0x6e52, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #51 */
    { 0x011b, 0xaa83, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #52 */
    { 0x051b, 0xaa83, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #53 */
    { 0x091b, 0xaa83, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #54 */
    { 0x0d1b, 0xaa83, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #55 */
    { 0x0173, 0x7b69, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #56 */
    { 0x0573, 0x7b69, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #57 */
    { 0x0973, 0x7b69, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #58 */
    { 0x0d73, 0x7b69, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #59 */
    { 0x0120, 0x4e87, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #60 */
    { 0x0520, 0x4e87, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #61 */
    { 0x0920, 0x4e87, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #62 */
    { 0x0d20, 0x4e87, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #63 */
    { 0x0165, 0xe18e, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #64 */
    { 0x0565, 0xe18e, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #65 */
    { 0x0965, 0xe18e, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #66 */
    { 0x0d65, 0xe18e, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #67 */
    { 0x0260, 0xe204, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #68 */
    { 0x0660, 0xe204, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #69 */
    { 0x0a60, 0xe204, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #70 */
    { 0x0e60, 0xe204, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #71 */
    { 0x023d, 0xd9c7, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #72 */
    { 0x063d, 0xd9c7, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #73 */
    { 0x0a3d, 0xd9c7, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #74 */
    { 0x0e3d, 0xd9c7, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #75 */
    { 0x010a, 0xec94, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #76 */
    { 0x050a, 0xec94, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #77 */
    { 0x090a, 0xec94, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #78 */
    { 0x0d0a, 0xec94, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #79 */
    { 0x0328, 0xab0e, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #80 */
    { 0x0728, 0xab0e, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #81 */
    { 0x0b28, 0xab0e, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #82 */
    { 0x0f28, 0xab0e, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #83 */
    { 0x0331, 0xb548, 0x3d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #84 */
    { 0x0731, 0xb548, 0x3d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #85 */
    { 0x0b31, 0xb548, 0x3d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #86 */
    { 0x0f31, 0xb548, 0x3d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #87 */
    { 0x022f, 0x88dc, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #88 */
    { 0x062f, 0x88dc, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #89 */
    { 0x0a2f, 0x88dc, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #90 */
    { 0x0e2f, 0x88dc, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #91 */
    { 0x0140, 0xde26, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #92 */
    { 0x0540, 0xde26, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #93 */
    { 0x0940, 0xde26, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #94 */
    { 0x0d40, 0xde26, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #95 */
};
uint32_t const g_cTests_fld1 = RT_ELEMENTS(g_aTests_fld1);

FPU_LD_CONST_TEST_T const g_aTests_fldl2t[] =
{
    { 0x0056, 0xe5b3, 0x7d00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #0 */
    { 0x0456, 0xe5b3, 0x7d00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #1 */
    { 0x0856, 0xe5b3, 0x7d00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #2 */
    { 0x0c56, 0xe5b3, 0x7d00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #3 */
    { 0x0140, 0xc35e, 0x7900, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #4 */
    { 0x0540, 0xc35e, 0x7900, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #5 */
    { 0x0940, 0xc35e, 0x7900, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #6 */
    { 0x0d40, 0xc35e, 0x7900, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #7 */
    { 0x0224, 0xeaa8, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #8 */
    { 0x0624, 0xeaa8, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #9 */
    { 0x0a24, 0xeaa8, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #10 */
    { 0x0e24, 0xeaa8, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #11 */
    { 0x001a, 0xc610, 0x7c00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #12 */
    { 0x041a, 0xc610, 0x7c00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #13 */
    { 0x081a, 0xc610, 0x7c00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #14 */
    { 0x0c1a, 0xc610, 0x7c00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #15 */
    { 0x0346, 0xc275, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #16 */
    { 0x0746, 0xc275, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #17 */
    { 0x0b46, 0xc275, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #18 */
    { 0x0f46, 0xc275, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #19 */
    { 0x0056, 0xbc57, 0x3c00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #20 */
    { 0x0456, 0xbc57, 0x3c00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #21 */
    { 0x0856, 0xbc57, 0x3c00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #22 */
    { 0x0c56, 0xbc57, 0x3c00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #23 */
    { 0x0334, 0x913e, 0x3900, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #24 */
    { 0x0734, 0x913e, 0x3900, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #25 */
    { 0x0b34, 0x913e, 0x3900, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #26 */
    { 0x0f34, 0x913e, 0x3900, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #27 */
    { 0x0045, 0x5794, 0x7d00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #28 */
    { 0x0445, 0x5794, 0x7d00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #29 */
    { 0x0845, 0x5794, 0x7d00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #30 */
    { 0x0c45, 0x5794, 0x7d00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #31 */
    { 0x0059, 0x9f9c, 0x3d00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #32 */
    { 0x0459, 0x9f9c, 0x3d00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #33 */
    { 0x0859, 0x9f9c, 0x3d00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #34 */
    { 0x0c59, 0x9f9c, 0x3d00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #35 */
    { 0x0210, 0x6816, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #36 */
    { 0x0610, 0x6816, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #37 */
    { 0x0a10, 0x6816, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #38 */
    { 0x0e10, 0x6816, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #39 */
    { 0x0373, 0x8dec, 0x3d00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #40 */
    { 0x0773, 0x8dec, 0x3d00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #41 */
    { 0x0b73, 0x8dec, 0x3d00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #42 */
    { 0x0f73, 0x8dec, 0x3d00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #43 */
    { 0x002f, 0xc1be, 0x7900, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #44 */
    { 0x042f, 0xc1be, 0x7900, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #45 */
    { 0x082f, 0xc1be, 0x7900, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #46 */
    { 0x0c2f, 0xc1be, 0x7900, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #47 */
    { 0x000e, 0x1985, 0x3900, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #48 */
    { 0x040e, 0x1985, 0x3900, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #49 */
    { 0x080e, 0x1985, 0x3900, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #50 */
    { 0x0c0e, 0x1985, 0x3900, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #51 */
    { 0x0071, 0x928b, 0x3800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #52 */
    { 0x0471, 0x928b, 0x3800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #53 */
    { 0x0871, 0x928b, 0x3800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #54 */
    { 0x0c71, 0x928b, 0x3800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #55 */
    { 0x0278, 0x78d3, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #56 */
    { 0x0678, 0x78d3, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #57 */
    { 0x0a78, 0x78d3, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #58 */
    { 0x0e78, 0x78d3, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #59 */
    { 0x022f, 0x1a01, 0x3800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #60 */
    { 0x062f, 0x1a01, 0x3800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #61 */
    { 0x0a2f, 0x1a01, 0x3800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #62 */
    { 0x0e2f, 0x1a01, 0x3800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #63 */
    { 0x0254, 0xdfa7, 0x7d00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #64 */
    { 0x0654, 0xdfa7, 0x7d00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #65 */
    { 0x0a54, 0xdfa7, 0x7d00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #66 */
    { 0x0e54, 0xdfa7, 0x7d00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #67 */
    { 0x013b, 0x72e3, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #68 */
    { 0x053b, 0x72e3, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #69 */
    { 0x093b, 0x72e3, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #70 */
    { 0x0d3b, 0x72e3, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #71 */
    { 0x013f, 0x58c4, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #72 */
    { 0x053f, 0x58c4, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #73 */
    { 0x093f, 0x58c4, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #74 */
    { 0x0d3f, 0x58c4, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #75 */
    { 0x0272, 0x4024, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #76 */
    { 0x0672, 0x4024, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #77 */
    { 0x0a72, 0x4024, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #78 */
    { 0x0e72, 0x4024, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #79 */
    { 0x023e, 0x3236, 0x3800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #80 */
    { 0x063e, 0x3236, 0x3800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #81 */
    { 0x0a3e, 0x3236, 0x3800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #82 */
    { 0x0e3e, 0x3236, 0x3800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #83 */
    { 0x0319, 0xf1e9, 0x7900, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #84 */
    { 0x0719, 0xf1e9, 0x7900, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #85 */
    { 0x0b19, 0xf1e9, 0x7900, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #86 */
    { 0x0f19, 0xf1e9, 0x7900, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #87 */
    { 0x0326, 0x722e, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #88 */
    { 0x0726, 0x722e, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #89 */
    { 0x0b26, 0x722e, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #90 */
    { 0x0f26, 0x722e, 0x7800, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #91 */
    { 0x0240, 0x3468, 0x3c00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #92 */
    { 0x0640, 0x3468, 0x3c00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #93 */
    { 0x0a40, 0x3468, 0x3c00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8aff,16384) }, /* #94 */
    { 0x0e40, 0x3468, 0x3c00, RTFLOAT80U_INIT_C(0,0xd49a784bcd1b8afe,16384) }, /* #95 */
};
uint32_t const g_cTests_fldl2t = RT_ELEMENTS(g_aTests_fldl2t);

FPU_LD_CONST_TEST_T const g_aTests_fldl2e[] =
{
    { 0x0134, 0x30dd, 0x3800, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #0 */
    { 0x0534, 0x30dd, 0x3800, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #1 */
    { 0x0934, 0x30dd, 0x3800, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #2 */
    { 0x0d34, 0x30dd, 0x3800, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #3 */
    { 0x0232, 0xdf15, 0x7d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #4 */
    { 0x0632, 0xdf15, 0x7d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #5 */
    { 0x0a32, 0xdf15, 0x7d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #6 */
    { 0x0e32, 0xdf15, 0x7d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #7 */
    { 0x0070, 0x7795, 0x7d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #8 */
    { 0x0470, 0x7795, 0x7d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #9 */
    { 0x0870, 0x7795, 0x7d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #10 */
    { 0x0c70, 0x7795, 0x7d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #11 */
    { 0x0048, 0x993c, 0x3900, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #12 */
    { 0x0448, 0x993c, 0x3900, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #13 */
    { 0x0848, 0x993c, 0x3900, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #14 */
    { 0x0c48, 0x993c, 0x3900, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #15 */
    { 0x0308, 0xec51, 0x7c00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #16 */
    { 0x0708, 0xec51, 0x7c00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #17 */
    { 0x0b08, 0xec51, 0x7c00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #18 */
    { 0x0f08, 0xec51, 0x7c00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #19 */
    { 0x004c, 0xcd11, 0x7d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #20 */
    { 0x044c, 0xcd11, 0x7d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #21 */
    { 0x084c, 0xcd11, 0x7d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #22 */
    { 0x0c4c, 0xcd11, 0x7d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #23 */
    { 0x020e, 0xa78d, 0x3d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #24 */
    { 0x060e, 0xa78d, 0x3d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #25 */
    { 0x0a0e, 0xa78d, 0x3d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #26 */
    { 0x0e0e, 0xa78d, 0x3d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #27 */
    { 0x035e, 0x8147, 0x3900, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #28 */
    { 0x075e, 0x8147, 0x3900, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #29 */
    { 0x0b5e, 0x8147, 0x3900, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #30 */
    { 0x0f5e, 0x8147, 0x3900, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #31 */
    { 0x0155, 0xea4a, 0x7800, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #32 */
    { 0x0555, 0xea4a, 0x7800, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #33 */
    { 0x0955, 0xea4a, 0x7800, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #34 */
    { 0x0d55, 0xea4a, 0x7800, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #35 */
    { 0x0233, 0xdba2, 0x7900, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #36 */
    { 0x0633, 0xdba2, 0x7900, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #37 */
    { 0x0a33, 0xdba2, 0x7900, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #38 */
    { 0x0e33, 0xdba2, 0x7900, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #39 */
    { 0x025c, 0xedb2, 0x7d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #40 */
    { 0x065c, 0xedb2, 0x7d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #41 */
    { 0x0a5c, 0xedb2, 0x7d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #42 */
    { 0x0e5c, 0xedb2, 0x7d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #43 */
    { 0x030e, 0xbdc0, 0x3d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #44 */
    { 0x070e, 0xbdc0, 0x3d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #45 */
    { 0x0b0e, 0xbdc0, 0x3d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #46 */
    { 0x0f0e, 0xbdc0, 0x3d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #47 */
    { 0x0039, 0xaef5, 0x3c00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #48 */
    { 0x0439, 0xaef5, 0x3c00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #49 */
    { 0x0839, 0xaef5, 0x3c00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #50 */
    { 0x0c39, 0xaef5, 0x3c00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #51 */
    { 0x0064, 0xc263, 0x7800, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #52 */
    { 0x0464, 0xc263, 0x7800, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #53 */
    { 0x0864, 0xc263, 0x7800, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #54 */
    { 0x0c64, 0xc263, 0x7800, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #55 */
    { 0x0238, 0x9563, 0x3d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #56 */
    { 0x0638, 0x9563, 0x3d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #57 */
    { 0x0a38, 0x9563, 0x3d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #58 */
    { 0x0e38, 0x9563, 0x3d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #59 */
    { 0x030a, 0xfddb, 0x7d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #60 */
    { 0x070a, 0xfddb, 0x7d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #61 */
    { 0x0b0a, 0xfddb, 0x7d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #62 */
    { 0x0f0a, 0xfddb, 0x7d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #63 */
    { 0x0255, 0xe3fc, 0x7900, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #64 */
    { 0x0655, 0xe3fc, 0x7900, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #65 */
    { 0x0a55, 0xe3fc, 0x7900, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #66 */
    { 0x0e55, 0xe3fc, 0x7900, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #67 */
    { 0x0360, 0xb078, 0x3800, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #68 */
    { 0x0760, 0xb078, 0x3800, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #69 */
    { 0x0b60, 0xb078, 0x3800, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #70 */
    { 0x0f60, 0xb078, 0x3800, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #71 */
    { 0x0114, 0xec67, 0x7c00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #72 */
    { 0x0514, 0xec67, 0x7c00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #73 */
    { 0x0914, 0xec67, 0x7c00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #74 */
    { 0x0d14, 0xec67, 0x7c00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #75 */
    { 0x0129, 0x26e7, 0x3c00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #76 */
    { 0x0529, 0x26e7, 0x3c00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #77 */
    { 0x0929, 0x26e7, 0x3c00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #78 */
    { 0x0d29, 0x26e7, 0x3c00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #79 */
    { 0x004c, 0x76a3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #80 */
    { 0x044c, 0x76a3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #81 */
    { 0x084c, 0x76a3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #82 */
    { 0x0c4c, 0x76a3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #83 */
    { 0x0209, 0xf2b3, 0x7800, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #84 */
    { 0x0609, 0xf2b3, 0x7800, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #85 */
    { 0x0a09, 0xf2b3, 0x7800, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #86 */
    { 0x0e09, 0xf2b3, 0x7800, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #87 */
    { 0x013a, 0xbd96, 0x3d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #88 */
    { 0x053a, 0xbd96, 0x3d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #89 */
    { 0x093a, 0xbd96, 0x3d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #90 */
    { 0x0d3a, 0xbd96, 0x3d00, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #91 */
    { 0x016f, 0x635e, 0x7900, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #92 */
    { 0x056f, 0x635e, 0x7900, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #93 */
    { 0x096f, 0x635e, 0x7900, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bc,16383) }, /* #94 */
    { 0x0d6f, 0x635e, 0x7900, RTFLOAT80U_INIT_C(0,0xb8aa3b295c17f0bb,16383) }, /* #95 */
};
uint32_t const g_cTests_fldl2e = RT_ELEMENTS(g_aTests_fldl2e);

FPU_LD_CONST_TEST_T const g_aTests_fldpi[] =
{
    { 0x033d, 0x483d, 0x7800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0 */
    { 0x073d, 0x483d, 0x7800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #1 */
    { 0x0b3d, 0x483d, 0x7800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #2 */
    { 0x0f3d, 0x483d, 0x7800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #3 */
    { 0x0137, 0x61fa, 0x7900, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #4 */
    { 0x0537, 0x61fa, 0x7900, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #5 */
    { 0x0937, 0x61fa, 0x7900, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #6 */
    { 0x0d37, 0x61fa, 0x7900, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #7 */
    { 0x0375, 0x1d7f, 0x3d00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #8 */
    { 0x0775, 0x1d7f, 0x3d00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #9 */
    { 0x0b75, 0x1d7f, 0x3d00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #10 */
    { 0x0f75, 0x1d7f, 0x3d00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #11 */
    { 0x023c, 0x7e71, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #12 */
    { 0x063c, 0x7e71, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #13 */
    { 0x0a3c, 0x7e71, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #14 */
    { 0x0e3c, 0x7e71, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #15 */
    { 0x0310, 0xadc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #16 */
    { 0x0710, 0xadc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #17 */
    { 0x0b10, 0xadc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #18 */
    { 0x0f10, 0xadc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #19 */
    { 0x0050, 0x1a11, 0x3800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #20 */
    { 0x0450, 0x1a11, 0x3800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #21 */
    { 0x0850, 0x1a11, 0x3800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #22 */
    { 0x0c50, 0x1a11, 0x3800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #23 */
    { 0x030b, 0xc88a, 0x7800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #24 */
    { 0x070b, 0xc88a, 0x7800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #25 */
    { 0x0b0b, 0xc88a, 0x7800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #26 */
    { 0x0f0b, 0xc88a, 0x7800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #27 */
    { 0x015f, 0xd9d1, 0x7900, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #28 */
    { 0x055f, 0xd9d1, 0x7900, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #29 */
    { 0x095f, 0xd9d1, 0x7900, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #30 */
    { 0x0d5f, 0xd9d1, 0x7900, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #31 */
    { 0x015f, 0x4e2c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #32 */
    { 0x055f, 0x4e2c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #33 */
    { 0x095f, 0x4e2c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #34 */
    { 0x0d5f, 0x4e2c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #35 */
    { 0x0332, 0xdb92, 0x7900, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #36 */
    { 0x0732, 0xdb92, 0x7900, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #37 */
    { 0x0b32, 0xdb92, 0x7900, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #38 */
    { 0x0f32, 0xdb92, 0x7900, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #39 */
    { 0x011f, 0x2447, 0x3c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #40 */
    { 0x051f, 0x2447, 0x3c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #41 */
    { 0x091f, 0x2447, 0x3c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #42 */
    { 0x0d1f, 0x2447, 0x3c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #43 */
    { 0x0249, 0x06cf, 0x3c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #44 */
    { 0x0649, 0x06cf, 0x3c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #45 */
    { 0x0a49, 0x06cf, 0x3c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #46 */
    { 0x0e49, 0x06cf, 0x3c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #47 */
    { 0x0023, 0x8a7b, 0x3800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #48 */
    { 0x0423, 0x8a7b, 0x3800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #49 */
    { 0x0823, 0x8a7b, 0x3800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #50 */
    { 0x0c23, 0x8a7b, 0x3800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #51 */
    { 0x020c, 0xcc8c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #52 */
    { 0x060c, 0xcc8c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #53 */
    { 0x0a0c, 0xcc8c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #54 */
    { 0x0e0c, 0xcc8c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #55 */
    { 0x0055, 0xc293, 0x7800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #56 */
    { 0x0455, 0xc293, 0x7800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #57 */
    { 0x0855, 0xc293, 0x7800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #58 */
    { 0x0c55, 0xc293, 0x7800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #59 */
    { 0x0046, 0x39a1, 0x3900, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #60 */
    { 0x0446, 0x39a1, 0x3900, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #61 */
    { 0x0846, 0x39a1, 0x3900, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #62 */
    { 0x0c46, 0x39a1, 0x3900, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #63 */
    { 0x0049, 0xcc7e, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #64 */
    { 0x0449, 0xcc7e, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #65 */
    { 0x0849, 0xcc7e, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #66 */
    { 0x0c49, 0xcc7e, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #67 */
    { 0x024f, 0x27df, 0x3d00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #68 */
    { 0x064f, 0x27df, 0x3d00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #69 */
    { 0x0a4f, 0x27df, 0x3d00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #70 */
    { 0x0e4f, 0x27df, 0x3d00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #71 */
    { 0x015e, 0x64d0, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #72 */
    { 0x055e, 0x64d0, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73 */
    { 0x095e, 0x64d0, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #74 */
    { 0x0d5e, 0x64d0, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #75 */
    { 0x0130, 0x6298, 0x7800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #76 */
    { 0x0530, 0x6298, 0x7800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #77 */
    { 0x0930, 0x6298, 0x7800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #78 */
    { 0x0d30, 0x6298, 0x7800, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #79 */
    { 0x020b, 0x5bbf, 0x7900, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #80 */
    { 0x060b, 0x5bbf, 0x7900, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #81 */
    { 0x0a0b, 0x5bbf, 0x7900, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #82 */
    { 0x0e0b, 0x5bbf, 0x7900, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #83 */
    { 0x0170, 0x7467, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84 */
    { 0x0570, 0x7467, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85 */
    { 0x0970, 0x7467, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #86 */
    { 0x0d70, 0x7467, 0x7c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #87 */
    { 0x0234, 0xad0f, 0x3d00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #88 */
    { 0x0634, 0xad0f, 0x3d00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #89 */
    { 0x0a34, 0xad0f, 0x3d00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #90 */
    { 0x0e34, 0xad0f, 0x3d00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #91 */
    { 0x0248, 0x9430, 0x3c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #92 */
    { 0x0648, 0x9430, 0x3c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #93 */
    { 0x0a48, 0x9430, 0x3c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #94 */
    { 0x0e48, 0x9430, 0x3c00, RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #95 */
};
uint32_t const g_cTests_fldpi = RT_ELEMENTS(g_aTests_fldpi);

FPU_LD_CONST_TEST_T const g_aTests_fldlg2[] =
{
    { 0x0341, 0x8270, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #0 */
    { 0x0741, 0x8270, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #1 */
    { 0x0b41, 0x8270, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #2 */
    { 0x0f41, 0x8270, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #3 */
    { 0x033d, 0x539e, 0x7900, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #4 */
    { 0x073d, 0x539e, 0x7900, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #5 */
    { 0x0b3d, 0x539e, 0x7900, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #6 */
    { 0x0f3d, 0x539e, 0x7900, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #7 */
    { 0x005a, 0x0219, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #8 */
    { 0x045a, 0x0219, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #9 */
    { 0x085a, 0x0219, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #10 */
    { 0x0c5a, 0x0219, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #11 */
    { 0x0101, 0x9c35, 0x3c00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #12 */
    { 0x0501, 0x9c35, 0x3c00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #13 */
    { 0x0901, 0x9c35, 0x3c00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #14 */
    { 0x0d01, 0x9c35, 0x3c00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #15 */
    { 0x036a, 0x674c, 0x7d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #16 */
    { 0x076a, 0x674c, 0x7d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #17 */
    { 0x0b6a, 0x674c, 0x7d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #18 */
    { 0x0f6a, 0x674c, 0x7d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #19 */
    { 0x017c, 0xc745, 0x7d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #20 */
    { 0x057c, 0xc745, 0x7d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #21 */
    { 0x097c, 0xc745, 0x7d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #22 */
    { 0x0d7c, 0xc745, 0x7d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #23 */
    { 0x0220, 0x11d6, 0x3900, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #24 */
    { 0x0620, 0x11d6, 0x3900, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #25 */
    { 0x0a20, 0x11d6, 0x3900, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #26 */
    { 0x0e20, 0x11d6, 0x3900, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #27 */
    { 0x0107, 0x1875, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #28 */
    { 0x0507, 0x1875, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #29 */
    { 0x0907, 0x1875, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #30 */
    { 0x0d07, 0x1875, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #31 */
    { 0x0337, 0x84e4, 0x3c00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #32 */
    { 0x0737, 0x84e4, 0x3c00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #33 */
    { 0x0b37, 0x84e4, 0x3c00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #34 */
    { 0x0f37, 0x84e4, 0x3c00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #35 */
    { 0x0109, 0xbdb8, 0x3d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #36 */
    { 0x0509, 0xbdb8, 0x3d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #37 */
    { 0x0909, 0xbdb8, 0x3d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #38 */
    { 0x0d09, 0xbdb8, 0x3d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #39 */
    { 0x017b, 0xaab5, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #40 */
    { 0x057b, 0xaab5, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #41 */
    { 0x097b, 0xaab5, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #42 */
    { 0x0d7b, 0xaab5, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #43 */
    { 0x0062, 0x5b7b, 0x7900, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #44 */
    { 0x0462, 0x5b7b, 0x7900, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #45 */
    { 0x0862, 0x5b7b, 0x7900, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #46 */
    { 0x0c62, 0x5b7b, 0x7900, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #47 */
    { 0x010d, 0xf4c0, 0x7c00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #48 */
    { 0x050d, 0xf4c0, 0x7c00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #49 */
    { 0x090d, 0xf4c0, 0x7c00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #50 */
    { 0x0d0d, 0xf4c0, 0x7c00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #51 */
    { 0x001f, 0xf29d, 0x7800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #52 */
    { 0x041f, 0xf29d, 0x7800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #53 */
    { 0x081f, 0xf29d, 0x7800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #54 */
    { 0x0c1f, 0xf29d, 0x7800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #55 */
    { 0x0035, 0x1817, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #56 */
    { 0x0435, 0x1817, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #57 */
    { 0x0835, 0x1817, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #58 */
    { 0x0c35, 0x1817, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #59 */
    { 0x0004, 0x6c19, 0x7c00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #60 */
    { 0x0404, 0x6c19, 0x7c00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #61 */
    { 0x0804, 0x6c19, 0x7c00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #62 */
    { 0x0c04, 0x6c19, 0x7c00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #63 */
    { 0x017c, 0xf70b, 0x7d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #64 */
    { 0x057c, 0xf70b, 0x7d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #65 */
    { 0x097c, 0xf70b, 0x7d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #66 */
    { 0x0d7c, 0xf70b, 0x7d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #67 */
    { 0x0179, 0xaa6b, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #68 */
    { 0x0579, 0xaa6b, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #69 */
    { 0x0979, 0xaa6b, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #70 */
    { 0x0d79, 0xaa6b, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #71 */
    { 0x035a, 0x3adc, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #72 */
    { 0x075a, 0x3adc, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #73 */
    { 0x0b5a, 0x3adc, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #74 */
    { 0x0f5a, 0x3adc, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #75 */
    { 0x0247, 0x87b4, 0x3d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #76 */
    { 0x0647, 0x87b4, 0x3d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #77 */
    { 0x0a47, 0x87b4, 0x3d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #78 */
    { 0x0e47, 0x87b4, 0x3d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #79 */
    { 0x0229, 0x41e8, 0x7900, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #80 */
    { 0x0629, 0x41e8, 0x7900, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #81 */
    { 0x0a29, 0x41e8, 0x7900, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #82 */
    { 0x0e29, 0x41e8, 0x7900, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #83 */
    { 0x0037, 0x5c58, 0x7c00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #84 */
    { 0x0437, 0x5c58, 0x7c00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #85 */
    { 0x0837, 0x5c58, 0x7c00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #86 */
    { 0x0c37, 0x5c58, 0x7c00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #87 */
    { 0x0258, 0x3013, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #88 */
    { 0x0658, 0x3013, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #89 */
    { 0x0a58, 0x3013, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #90 */
    { 0x0e58, 0x3013, 0x3800, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #91 */
    { 0x032f, 0x37bb, 0x3d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #92 */
    { 0x072f, 0x37bb, 0x3d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #93 */
    { 0x0b2f, 0x37bb, 0x3d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff799,16381) }, /* #94 */
    { 0x0f2f, 0x37bb, 0x3d00, RTFLOAT80U_INIT_C(0,0x9a209a84fbcff798,16381) }, /* #95 */
};
uint32_t const g_cTests_fldlg2 = RT_ELEMENTS(g_aTests_fldlg2);

FPU_LD_CONST_TEST_T const g_aTests_fldln2[] =
{
    { 0x0218, 0xbf43, 0x3d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #0 */
    { 0x0618, 0xbf43, 0x3d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #1 */
    { 0x0a18, 0xbf43, 0x3d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #2 */
    { 0x0e18, 0xbf43, 0x3d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #3 */
    { 0x0300, 0x8048, 0x3800, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #4 */
    { 0x0700, 0x8048, 0x3800, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #5 */
    { 0x0b00, 0x8048, 0x3800, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #6 */
    { 0x0f00, 0x8048, 0x3800, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #7 */
    { 0x0232, 0x65db, 0x7d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #8 */
    { 0x0632, 0x65db, 0x7d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #9 */
    { 0x0a32, 0x65db, 0x7d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #10 */
    { 0x0e32, 0x65db, 0x7d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #11 */
    { 0x0145, 0xa1fb, 0x3900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #12 */
    { 0x0545, 0xa1fb, 0x3900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #13 */
    { 0x0945, 0xa1fb, 0x3900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #14 */
    { 0x0d45, 0xa1fb, 0x3900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #15 */
    { 0x0179, 0x39b5, 0x3900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #16 */
    { 0x0579, 0x39b5, 0x3900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #17 */
    { 0x0979, 0x39b5, 0x3900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #18 */
    { 0x0d79, 0x39b5, 0x3900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #19 */
    { 0x0032, 0xb160, 0x3900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #20 */
    { 0x0432, 0xb160, 0x3900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #21 */
    { 0x0832, 0xb160, 0x3900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #22 */
    { 0x0c32, 0xb160, 0x3900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #23 */
    { 0x0367, 0xb348, 0x3900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #24 */
    { 0x0767, 0xb348, 0x3900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #25 */
    { 0x0b67, 0xb348, 0x3900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #26 */
    { 0x0f67, 0xb348, 0x3900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #27 */
    { 0x021b, 0x68b0, 0x7800, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #28 */
    { 0x061b, 0x68b0, 0x7800, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #29 */
    { 0x0a1b, 0x68b0, 0x7800, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #30 */
    { 0x0e1b, 0x68b0, 0x7800, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #31 */
    { 0x010f, 0x711c, 0x7900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #32 */
    { 0x050f, 0x711c, 0x7900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #33 */
    { 0x090f, 0x711c, 0x7900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #34 */
    { 0x0d0f, 0x711c, 0x7900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #35 */
    { 0x035e, 0x7d3c, 0x7d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #36 */
    { 0x075e, 0x7d3c, 0x7d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #37 */
    { 0x0b5e, 0x7d3c, 0x7d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #38 */
    { 0x0f5e, 0x7d3c, 0x7d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #39 */
    { 0x013e, 0xb22e, 0x3800, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #40 */
    { 0x053e, 0xb22e, 0x3800, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #41 */
    { 0x093e, 0xb22e, 0x3800, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #42 */
    { 0x0d3e, 0xb22e, 0x3800, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #43 */
    { 0x0337, 0x17be, 0x3d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #44 */
    { 0x0737, 0x17be, 0x3d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #45 */
    { 0x0b37, 0x17be, 0x3d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #46 */
    { 0x0f37, 0x17be, 0x3d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #47 */
    { 0x0376, 0xfb37, 0x7900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #48 */
    { 0x0776, 0xfb37, 0x7900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #49 */
    { 0x0b76, 0xfb37, 0x7900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #50 */
    { 0x0f76, 0xfb37, 0x7900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #51 */
    { 0x0212, 0xd30b, 0x7900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #52 */
    { 0x0612, 0xd30b, 0x7900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #53 */
    { 0x0a12, 0xd30b, 0x7900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #54 */
    { 0x0e12, 0xd30b, 0x7900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #55 */
    { 0x0138, 0x4216, 0x7800, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #56 */
    { 0x0538, 0x4216, 0x7800, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #57 */
    { 0x0938, 0x4216, 0x7800, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #58 */
    { 0x0d38, 0x4216, 0x7800, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #59 */
    { 0x0157, 0x2c96, 0x3c00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #60 */
    { 0x0557, 0x2c96, 0x3c00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #61 */
    { 0x0957, 0x2c96, 0x3c00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #62 */
    { 0x0d57, 0x2c96, 0x3c00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #63 */
    { 0x030f, 0xbf9b, 0x3d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #64 */
    { 0x070f, 0xbf9b, 0x3d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #65 */
    { 0x0b0f, 0xbf9b, 0x3d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #66 */
    { 0x0f0f, 0xbf9b, 0x3d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #67 */
    { 0x0063, 0x3bcb, 0x3900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #68 */
    { 0x0463, 0x3bcb, 0x3900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #69 */
    { 0x0863, 0x3bcb, 0x3900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #70 */
    { 0x0c63, 0x3bcb, 0x3900, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #71 */
    { 0x030e, 0x8f72, 0x3d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #72 */
    { 0x070e, 0x8f72, 0x3d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #73 */
    { 0x0b0e, 0x8f72, 0x3d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #74 */
    { 0x0f0e, 0x8f72, 0x3d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #75 */
    { 0x0144, 0xb65b, 0x3c00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #76 */
    { 0x0544, 0xb65b, 0x3c00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #77 */
    { 0x0944, 0xb65b, 0x3c00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #78 */
    { 0x0d44, 0xb65b, 0x3c00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #79 */
    { 0x0201, 0x2ce3, 0x3c00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #80 */
    { 0x0601, 0x2ce3, 0x3c00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #81 */
    { 0x0a01, 0x2ce3, 0x3c00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #82 */
    { 0x0e01, 0x2ce3, 0x3c00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #83 */
    { 0x031d, 0xd7a6, 0x7d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #84 */
    { 0x071d, 0xd7a6, 0x7d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #85 */
    { 0x0b1d, 0xd7a6, 0x7d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #86 */
    { 0x0f1d, 0xd7a6, 0x7d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #87 */
    { 0x0110, 0x3878, 0x3800, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #88 */
    { 0x0510, 0x3878, 0x3800, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #89 */
    { 0x0910, 0x3878, 0x3800, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #90 */
    { 0x0d10, 0x3878, 0x3800, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #91 */
    { 0x0348, 0x8592, 0x3d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #92 */
    { 0x0748, 0x8592, 0x3d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #93 */
    { 0x0b48, 0x8592, 0x3d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,16382) }, /* #94 */
    { 0x0f48, 0x8592, 0x3d00, RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,16382) }, /* #95 */
};
uint32_t const g_cTests_fldln2 = RT_ELEMENTS(g_aTests_fldln2);

FPU_LD_CONST_TEST_T const g_aTests_fldz[] =
{
    { 0x0074, 0x34ef, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #0 */
    { 0x0474, 0x34ef, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #1 */
    { 0x0874, 0x34ef, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #2 */
    { 0x0c74, 0x34ef, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #3 */
    { 0x0203, 0x950e, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #4 */
    { 0x0603, 0x950e, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #5 */
    { 0x0a03, 0x950e, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #6 */
    { 0x0e03, 0x950e, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #7 */
    { 0x037b, 0x8d7b, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #8 */
    { 0x077b, 0x8d7b, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #9 */
    { 0x0b7b, 0x8d7b, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #10 */
    { 0x0f7b, 0x8d7b, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #11 */
    { 0x0109, 0x3ce7, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12 */
    { 0x0509, 0x3ce7, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #13 */
    { 0x0909, 0x3ce7, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #14 */
    { 0x0d09, 0x3ce7, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #15 */
    { 0x016b, 0xbb1b, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16 */
    { 0x056b, 0xbb1b, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #17 */
    { 0x096b, 0xbb1b, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #18 */
    { 0x0d6b, 0xbb1b, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #19 */
    { 0x0112, 0xacc0, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #20 */
    { 0x0512, 0xacc0, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #21 */
    { 0x0912, 0xacc0, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #22 */
    { 0x0d12, 0xacc0, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #23 */
    { 0x0271, 0x6fd1, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #24 */
    { 0x0671, 0x6fd1, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #25 */
    { 0x0a71, 0x6fd1, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #26 */
    { 0x0e71, 0x6fd1, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #27 */
    { 0x021a, 0x7ce9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #28 */
    { 0x061a, 0x7ce9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #29 */
    { 0x0a1a, 0x7ce9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #30 */
    { 0x0e1a, 0x7ce9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #31 */
    { 0x034b, 0x6af9, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #32 */
    { 0x074b, 0x6af9, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #33 */
    { 0x0b4b, 0x6af9, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #34 */
    { 0x0f4b, 0x6af9, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #35 */
    { 0x0050, 0x546a, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #36 */
    { 0x0450, 0x546a, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #37 */
    { 0x0850, 0x546a, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #38 */
    { 0x0c50, 0x546a, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #39 */
    { 0x0161, 0xb0cd, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #40 */
    { 0x0561, 0xb0cd, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #41 */
    { 0x0961, 0xb0cd, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #42 */
    { 0x0d61, 0xb0cd, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #43 */
    { 0x024f, 0x22df, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #44 */
    { 0x064f, 0x22df, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #45 */
    { 0x0a4f, 0x22df, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #46 */
    { 0x0e4f, 0x22df, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #47 */
    { 0x0340, 0x9afb, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #48 */
    { 0x0740, 0x9afb, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #49 */
    { 0x0b40, 0x9afb, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #50 */
    { 0x0f40, 0x9afb, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #51 */
    { 0x0365, 0x77c2, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #52 */
    { 0x0765, 0x77c2, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #53 */
    { 0x0b65, 0x77c2, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #54 */
    { 0x0f65, 0x77c2, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #55 */
    { 0x004e, 0xe7f8, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #56 */
    { 0x044e, 0xe7f8, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #57 */
    { 0x084e, 0xe7f8, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #58 */
    { 0x0c4e, 0xe7f8, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59 */
    { 0x0031, 0xe8af, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #60 */
    { 0x0431, 0xe8af, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #61 */
    { 0x0831, 0xe8af, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #62 */
    { 0x0c31, 0xe8af, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63 */
    { 0x0209, 0xf2f0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #64 */
    { 0x0609, 0xf2f0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #65 */
    { 0x0a09, 0xf2f0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #66 */
    { 0x0e09, 0xf2f0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #67 */
    { 0x0076, 0x443b, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #68 */
    { 0x0476, 0x443b, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #69 */
    { 0x0876, 0x443b, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #70 */
    { 0x0c76, 0x443b, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71 */
    { 0x0310, 0x1ac6, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #72 */
    { 0x0710, 0x1ac6, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #73 */
    { 0x0b10, 0x1ac6, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #74 */
    { 0x0f10, 0x1ac6, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #75 */
    { 0x0240, 0x0535, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #76 */
    { 0x0640, 0x0535, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #77 */
    { 0x0a40, 0x0535, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #78 */
    { 0x0e40, 0x0535, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #79 */
    { 0x001f, 0xb825, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #80 */
    { 0x041f, 0xb825, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #81 */
    { 0x081f, 0xb825, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #82 */
    { 0x0c1f, 0xb825, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #83 */
    { 0x030b, 0xfcee, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #84 */
    { 0x070b, 0xfcee, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #85 */
    { 0x0b0b, 0xfcee, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #86 */
    { 0x0f0b, 0xfcee, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #87 */
    { 0x012a, 0xb026, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #88 */
    { 0x052a, 0xb026, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #89 */
    { 0x092a, 0xb026, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #90 */
    { 0x0d2a, 0xb026, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #91 */
    { 0x0356, 0x6c0f, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #92 */
    { 0x0756, 0x6c0f, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #93 */
    { 0x0b56, 0x6c0f, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #94 */
    { 0x0f56, 0x6c0f, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0) }, /* #95 */
};
uint32_t const g_cTests_fldz = RT_ELEMENTS(g_aTests_fldz);

FPU_I64_IN_TEST_T const g_aTests_fild_r80_from_i64[] =
{
    { 0x0063, 0x84f4, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #0/0 */
    { 0x0463, 0x84f4, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #0/1 */
    { 0x0863, 0x84f4, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #0/2 */
    { 0x0c63, 0x84f4, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #0/3 */
    { 0x0030, 0x5049, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #1/0 */
    { 0x0430, 0x5049, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #1/1 */
    { 0x0830, 0x5049, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #1/2 */
    { 0x0c30, 0x5049, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #1/3 */
    { 0x0257, 0x2aac, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #2/0 */
    { 0x0657, 0x2aac, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #2/1 */
    { 0x0a57, 0x2aac, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #2/2 */
    { 0x0e57, 0x2aac, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #2/3 */
    { 0x0221, 0x63be, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #3/0 */
    { 0x0621, 0x63be, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #3/1 */
    { 0x0a21, 0x63be, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #3/2 */
    { 0x0e21, 0x63be, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #3/3 */
    { 0x033b, 0x42d6, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #4/0 */
    { 0x073b, 0x42d6, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #4/1 */
    { 0x0b3b, 0x42d6, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #4/2 */
    { 0x0f3b, 0x42d6, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #4/3 */
    { 0x0132, 0x5d87, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #5/0 */
    { 0x0532, 0x5d87, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #5/1 */
    { 0x0932, 0x5d87, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #5/2 */
    { 0x0d32, 0x5d87, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #5/3 */
    { 0x0232, 0xd266, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #6/0 */
    { 0x0632, 0xd266, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #6/1 */
    { 0x0a32, 0xd266, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #6/2 */
    { 0x0e32, 0xd266, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #6/3 */
    { 0x024b, 0xd5f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #7/0 */
    { 0x064b, 0xd5f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #7/1 */
    { 0x0a4b, 0xd5f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #7/2 */
    { 0x0e4b, 0xd5f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #7/3 */
    { 0x005b, 0x4658, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #8/0 */
    { 0x045b, 0x4658, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #8/1 */
    { 0x085b, 0x4658, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #8/2 */
    { 0x0c5b, 0x4658, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #8/3 */
    { 0x0037, 0x49e7, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #9/0 */
    { 0x0437, 0x49e7, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #9/1 */
    { 0x0837, 0x49e7, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #9/2 */
    { 0x0c37, 0x49e7, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #9/3 */
    { 0x014e, 0x71b9, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #10/0 */
    { 0x054e, 0x71b9, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #10/1 */
    { 0x094e, 0x71b9, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #10/2 */
    { 0x0d4e, 0x71b9, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #10/3 */
    { 0x0008, 0x7430, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #11/0 */
    { 0x0408, 0x7430, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #11/1 */
    { 0x0808, 0x7430, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #11/2 */
    { 0x0c08, 0x7430, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #11/3 */
    { 0x003c, 0x08c8, 0x3800, RTFLOAT80U_INIT_C(0,0x8132c994bb13aad8,16445), 4654862510179603820 }, /* #12/0 */
    { 0x043c, 0x08c8, 0x3800, RTFLOAT80U_INIT_C(0,0x8132c994bb13aad8,16445), 4654862510179603820 }, /* #12/1 */
    { 0x083c, 0x08c8, 0x3800, RTFLOAT80U_INIT_C(0,0x8132c994bb13aad8,16445), 4654862510179603820 }, /* #12/2 */
    { 0x0c3c, 0x08c8, 0x3800, RTFLOAT80U_INIT_C(0,0x8132c994bb13aad8,16445), 4654862510179603820 }, /* #12/3 */
    { 0x0068, 0x2702, 0x3d00, RTFLOAT80U_INIT_C(0,0xeacf63e4d1c3f988,16443), 2114981519934652209 }, /* #13/0 */
    { 0x0468, 0x2702, 0x3d00, RTFLOAT80U_INIT_C(0,0xeacf63e4d1c3f988,16443), 2114981519934652209 }, /* #13/1 */
    { 0x0868, 0x2702, 0x3d00, RTFLOAT80U_INIT_C(0,0xeacf63e4d1c3f988,16443), 2114981519934652209 }, /* #13/2 */
    { 0x0c68, 0x2702, 0x3d00, RTFLOAT80U_INIT_C(0,0xeacf63e4d1c3f988,16443), 2114981519934652209 }, /* #13/3 */
    { 0x016e, 0xc36e, 0x7900, RTFLOAT80U_INIT_C(1,0xf1e8389854ca6120,16445), -8715622292323119248 }, /* #14/0 */
    { 0x056e, 0xc36e, 0x7900, RTFLOAT80U_INIT_C(1,0xf1e8389854ca6120,16445), -8715622292323119248 }, /* #14/1 */
    { 0x096e, 0xc36e, 0x7900, RTFLOAT80U_INIT_C(1,0xf1e8389854ca6120,16445), -8715622292323119248 }, /* #14/2 */
    { 0x0d6e, 0xc36e, 0x7900, RTFLOAT80U_INIT_C(1,0xf1e8389854ca6120,16445), -8715622292323119248 }, /* #14/3 */
    { 0x0357, 0x12c3, 0x3800, RTFLOAT80U_INIT_C(0,0xf030ca3994c7f258,16445), 8653777858321447212 }, /* #15/0 */
    { 0x0757, 0x12c3, 0x3800, RTFLOAT80U_INIT_C(0,0xf030ca3994c7f258,16445), 8653777858321447212 }, /* #15/1 */
    { 0x0b57, 0x12c3, 0x3800, RTFLOAT80U_INIT_C(0,0xf030ca3994c7f258,16445), 8653777858321447212 }, /* #15/2 */
    { 0x0f57, 0x12c3, 0x3800, RTFLOAT80U_INIT_C(0,0xf030ca3994c7f258,16445), 8653777858321447212 }, /* #15/3 */
    { 0x037b, 0x6db3, 0x7d00, RTFLOAT80U_INIT_C(0,0x80f60716939f59f6,16445), 4646311337336483067 }, /* #16/0 */
    { 0x077b, 0x6db3, 0x7d00, RTFLOAT80U_INIT_C(0,0x80f60716939f59f6,16445), 4646311337336483067 }, /* #16/1 */
    { 0x0b7b, 0x6db3, 0x7d00, RTFLOAT80U_INIT_C(0,0x80f60716939f59f6,16445), 4646311337336483067 }, /* #16/2 */
    { 0x0f7b, 0x6db3, 0x7d00, RTFLOAT80U_INIT_C(0,0x80f60716939f59f6,16445), 4646311337336483067 }, /* #16/3 */
    { 0x025c, 0xccab, 0x7c00, RTFLOAT80U_INIT_C(1,0xf9558987a112ced4,16444), -4491604376020104117 }, /* #17/0 */
    { 0x065c, 0xccab, 0x7c00, RTFLOAT80U_INIT_C(1,0xf9558987a112ced4,16444), -4491604376020104117 }, /* #17/1 */
    { 0x0a5c, 0xccab, 0x7c00, RTFLOAT80U_INIT_C(1,0xf9558987a112ced4,16444), -4491604376020104117 }, /* #17/2 */
    { 0x0e5c, 0xccab, 0x7c00, RTFLOAT80U_INIT_C(1,0xf9558987a112ced4,16444), -4491604376020104117 }, /* #17/3 */
    { 0x0058, 0xd787, 0x7d00, RTFLOAT80U_INIT_C(1,0x87cac3d9cdd6e178,16445), -4892424240322277564 }, /* #18/0 */
    { 0x0458, 0xd787, 0x7d00, RTFLOAT80U_INIT_C(1,0x87cac3d9cdd6e178,16445), -4892424240322277564 }, /* #18/1 */
    { 0x0858, 0xd787, 0x7d00, RTFLOAT80U_INIT_C(1,0x87cac3d9cdd6e178,16445), -4892424240322277564 }, /* #18/2 */
    { 0x0c58, 0xd787, 0x7d00, RTFLOAT80U_INIT_C(1,0x87cac3d9cdd6e178,16445), -4892424240322277564 }, /* #18/3 */
    { 0x017a, 0x453d, 0x7d00, RTFLOAT80U_INIT_C(0,0xe10867546781a5b2,16445), 8107662035279467225 }, /* #19/0 */
    { 0x057a, 0x453d, 0x7d00, RTFLOAT80U_INIT_C(0,0xe10867546781a5b2,16445), 8107662035279467225 }, /* #19/1 */
    { 0x097a, 0x453d, 0x7d00, RTFLOAT80U_INIT_C(0,0xe10867546781a5b2,16445), 8107662035279467225 }, /* #19/2 */
    { 0x0d7a, 0x453d, 0x7d00, RTFLOAT80U_INIT_C(0,0xe10867546781a5b2,16445), 8107662035279467225 }, /* #19/3 */
    { 0x031b, 0xb7d6, 0x3d00, RTFLOAT80U_INIT_C(0,0xe57ef0ed5fbcff80,16443), 2067114973006897136 }, /* #20/0 */
    { 0x071b, 0xb7d6, 0x3d00, RTFLOAT80U_INIT_C(0,0xe57ef0ed5fbcff80,16443), 2067114973006897136 }, /* #20/1 */
    { 0x0b1b, 0xb7d6, 0x3d00, RTFLOAT80U_INIT_C(0,0xe57ef0ed5fbcff80,16443), 2067114973006897136 }, /* #20/2 */
    { 0x0f1b, 0xb7d6, 0x3d00, RTFLOAT80U_INIT_C(0,0xe57ef0ed5fbcff80,16443), 2067114973006897136 }, /* #20/3 */
    { 0x0327, 0x0e8e, 0x3c00, RTFLOAT80U_INIT_C(1,0xe38c245a4342d8cc,16445), -8198260156721622118 }, /* #21/0 */
    { 0x0727, 0x0e8e, 0x3c00, RTFLOAT80U_INIT_C(1,0xe38c245a4342d8cc,16445), -8198260156721622118 }, /* #21/1 */
    { 0x0b27, 0x0e8e, 0x3c00, RTFLOAT80U_INIT_C(1,0xe38c245a4342d8cc,16445), -8198260156721622118 }, /* #21/2 */
    { 0x0f27, 0x0e8e, 0x3c00, RTFLOAT80U_INIT_C(1,0xe38c245a4342d8cc,16445), -8198260156721622118 }, /* #21/3 */
    { 0x001b, 0xe9e7, 0x7900, RTFLOAT80U_INIT_C(1,0x97d6d1b7dd7ac250,16443), -1367645366546028618 }, /* #22/0 */
    { 0x041b, 0xe9e7, 0x7900, RTFLOAT80U_INIT_C(1,0x97d6d1b7dd7ac250,16443), -1367645366546028618 }, /* #22/1 */
    { 0x081b, 0xe9e7, 0x7900, RTFLOAT80U_INIT_C(1,0x97d6d1b7dd7ac250,16443), -1367645366546028618 }, /* #22/2 */
    { 0x0c1b, 0xe9e7, 0x7900, RTFLOAT80U_INIT_C(1,0x97d6d1b7dd7ac250,16443), -1367645366546028618 }, /* #22/3 */
    { 0x0039, 0x23ed, 0x3900, RTFLOAT80U_INIT_C(1,0x9484efd90ba6c122,16445), -5350971165010780305 }, /* #23/0 */
    { 0x0439, 0x23ed, 0x3900, RTFLOAT80U_INIT_C(1,0x9484efd90ba6c122,16445), -5350971165010780305 }, /* #23/1 */
    { 0x0839, 0x23ed, 0x3900, RTFLOAT80U_INIT_C(1,0x9484efd90ba6c122,16445), -5350971165010780305 }, /* #23/2 */
    { 0x0c39, 0x23ed, 0x3900, RTFLOAT80U_INIT_C(1,0x9484efd90ba6c122,16445), -5350971165010780305 }, /* #23/3 */
    { 0x0350, 0x8295, 0x3800, RTFLOAT80U_INIT_C(0,0xad606e0e7c9b3b30,16444), 3123276593706225356 }, /* #24/0 */
    { 0x0750, 0x8295, 0x3800, RTFLOAT80U_INIT_C(0,0xad606e0e7c9b3b30,16444), 3123276593706225356 }, /* #24/1 */
    { 0x0b50, 0x8295, 0x3800, RTFLOAT80U_INIT_C(0,0xad606e0e7c9b3b30,16444), 3123276593706225356 }, /* #24/2 */
    { 0x0f50, 0x8295, 0x3800, RTFLOAT80U_INIT_C(0,0xad606e0e7c9b3b30,16444), 3123276593706225356 }, /* #24/3 */
    { 0x0331, 0xea1a, 0x7800, RTFLOAT80U_INIT_C(0,0xa0e27ff4a8761a34,16444), 2898242269895034509 }, /* #25/0 */
    { 0x0731, 0xea1a, 0x7800, RTFLOAT80U_INIT_C(0,0xa0e27ff4a8761a34,16444), 2898242269895034509 }, /* #25/1 */
    { 0x0b31, 0xea1a, 0x7800, RTFLOAT80U_INIT_C(0,0xa0e27ff4a8761a34,16444), 2898242269895034509 }, /* #25/2 */
    { 0x0f31, 0xea1a, 0x7800, RTFLOAT80U_INIT_C(0,0xa0e27ff4a8761a34,16444), 2898242269895034509 }, /* #25/3 */
    { 0x0330, 0x1ea3, 0x3c00, RTFLOAT80U_INIT_C(0,0xa2956ff17af546a0,16443), 1464424136076863700 }, /* #26/0 */
    { 0x0730, 0x1ea3, 0x3c00, RTFLOAT80U_INIT_C(0,0xa2956ff17af546a0,16443), 1464424136076863700 }, /* #26/1 */
    { 0x0b30, 0x1ea3, 0x3c00, RTFLOAT80U_INIT_C(0,0xa2956ff17af546a0,16443), 1464424136076863700 }, /* #26/2 */
    { 0x0f30, 0x1ea3, 0x3c00, RTFLOAT80U_INIT_C(0,0xa2956ff17af546a0,16443), 1464424136076863700 }, /* #26/3 */
    { 0x0308, 0x9774, 0x3d00, RTFLOAT80U_INIT_C(0,0xbcf0c731d4588030,16445), 6807300345185452056 }, /* #27/0 */
    { 0x0708, 0x9774, 0x3d00, RTFLOAT80U_INIT_C(0,0xbcf0c731d4588030,16445), 6807300345185452056 }, /* #27/1 */
    { 0x0b08, 0x9774, 0x3d00, RTFLOAT80U_INIT_C(0,0xbcf0c731d4588030,16445), 6807300345185452056 }, /* #27/2 */
    { 0x0f08, 0x9774, 0x3d00, RTFLOAT80U_INIT_C(0,0xbcf0c731d4588030,16445), 6807300345185452056 }, /* #27/3 */
    { 0x016b, 0x555e, 0x7d00, RTFLOAT80U_INIT_C(0,0xbeac8414d3c76b10,16442), 858718861761738417 }, /* #28/0 */
    { 0x056b, 0x555e, 0x7d00, RTFLOAT80U_INIT_C(0,0xbeac8414d3c76b10,16442), 858718861761738417 }, /* #28/1 */
    { 0x096b, 0x555e, 0x7d00, RTFLOAT80U_INIT_C(0,0xbeac8414d3c76b10,16442), 858718861761738417 }, /* #28/2 */
    { 0x0d6b, 0x555e, 0x7d00, RTFLOAT80U_INIT_C(0,0xbeac8414d3c76b10,16442), 858718861761738417 }, /* #28/3 */
    { 0x0351, 0xbb07, 0x3900, RTFLOAT80U_INIT_C(0,0x98ddff3eef37fc8c,16445), 5507620454692290118 }, /* #29/0 */
    { 0x0751, 0xbb07, 0x3900, RTFLOAT80U_INIT_C(0,0x98ddff3eef37fc8c,16445), 5507620454692290118 }, /* #29/1 */
    { 0x0b51, 0xbb07, 0x3900, RTFLOAT80U_INIT_C(0,0x98ddff3eef37fc8c,16445), 5507620454692290118 }, /* #29/2 */
    { 0x0f51, 0xbb07, 0x3900, RTFLOAT80U_INIT_C(0,0x98ddff3eef37fc8c,16445), 5507620454692290118 }, /* #29/3 */
    { 0x0313, 0x3461, 0x3c00, RTFLOAT80U_INIT_C(0,0xe30c0ac330f79b90,16444), 4090115844946650852 }, /* #30/0 */
    { 0x0713, 0x3461, 0x3c00, RTFLOAT80U_INIT_C(0,0xe30c0ac330f79b90,16444), 4090115844946650852 }, /* #30/1 */
    { 0x0b13, 0x3461, 0x3c00, RTFLOAT80U_INIT_C(0,0xe30c0ac330f79b90,16444), 4090115844946650852 }, /* #30/2 */
    { 0x0f13, 0x3461, 0x3c00, RTFLOAT80U_INIT_C(0,0xe30c0ac330f79b90,16444), 4090115844946650852 }, /* #30/3 */
    { 0x0168, 0x15d6, 0x3d00, RTFLOAT80U_INIT_C(0,0xaacb947a3e9ccef8,16443), 1538386707434674655 }, /* #31/0 */
    { 0x0568, 0x15d6, 0x3d00, RTFLOAT80U_INIT_C(0,0xaacb947a3e9ccef8,16443), 1538386707434674655 }, /* #31/1 */
    { 0x0968, 0x15d6, 0x3d00, RTFLOAT80U_INIT_C(0,0xaacb947a3e9ccef8,16443), 1538386707434674655 }, /* #31/2 */
    { 0x0d68, 0x15d6, 0x3d00, RTFLOAT80U_INIT_C(0,0xaacb947a3e9ccef8,16443), 1538386707434674655 }, /* #31/3 */
    { 0x0041, 0x3f6d, 0x3d00, RTFLOAT80U_INIT_C(0,0xd1daa3d333f0dee0,16441), 472549338323584759 }, /* #32/0 */
    { 0x0441, 0x3f6d, 0x3d00, RTFLOAT80U_INIT_C(0,0xd1daa3d333f0dee0,16441), 472549338323584759 }, /* #32/1 */
    { 0x0841, 0x3f6d, 0x3d00, RTFLOAT80U_INIT_C(0,0xd1daa3d333f0dee0,16441), 472549338323584759 }, /* #32/2 */
    { 0x0c41, 0x3f6d, 0x3d00, RTFLOAT80U_INIT_C(0,0xd1daa3d333f0dee0,16441), 472549338323584759 }, /* #32/3 */
    { 0x037a, 0x2623, 0x3c00, RTFLOAT80U_INIT_C(0,0xe5819656a13bb390,16443), 2067208075687196274 }, /* #33/0 */
    { 0x077a, 0x2623, 0x3c00, RTFLOAT80U_INIT_C(0,0xe5819656a13bb390,16443), 2067208075687196274 }, /* #33/1 */
    { 0x0b7a, 0x2623, 0x3c00, RTFLOAT80U_INIT_C(0,0xe5819656a13bb390,16443), 2067208075687196274 }, /* #33/2 */
    { 0x0f7a, 0x2623, 0x3c00, RTFLOAT80U_INIT_C(0,0xe5819656a13bb390,16443), 2067208075687196274 }, /* #33/3 */
    { 0x0142, 0xf8db, 0x7800, RTFLOAT80U_INIT_C(1,0xf489bc0bd4647a40,16443), -2202602722007224136 }, /* #34/0 */
    { 0x0542, 0xf8db, 0x7800, RTFLOAT80U_INIT_C(1,0xf489bc0bd4647a40,16443), -2202602722007224136 }, /* #34/1 */
    { 0x0942, 0xf8db, 0x7800, RTFLOAT80U_INIT_C(1,0xf489bc0bd4647a40,16443), -2202602722007224136 }, /* #34/2 */
    { 0x0d42, 0xf8db, 0x7800, RTFLOAT80U_INIT_C(1,0xf489bc0bd4647a40,16443), -2202602722007224136 }, /* #34/3 */
    { 0x032c, 0x0452, 0x3c00, RTFLOAT80U_INIT_C(1,0xa3cbda2de8be9a44,16445), -5901383569583852834 }, /* #35/0 */
    { 0x072c, 0x0452, 0x3c00, RTFLOAT80U_INIT_C(1,0xa3cbda2de8be9a44,16445), -5901383569583852834 }, /* #35/1 */
    { 0x0b2c, 0x0452, 0x3c00, RTFLOAT80U_INIT_C(1,0xa3cbda2de8be9a44,16445), -5901383569583852834 }, /* #35/2 */
    { 0x0f2c, 0x0452, 0x3c00, RTFLOAT80U_INIT_C(1,0xa3cbda2de8be9a44,16445), -5901383569583852834 }, /* #35/3 */
    { 0x014c, 0x1465, 0x3c00, RTFLOAT80U_INIT_C(1,0xad9fea7b7afeae42,16445), -6255488052961957665 }, /* #36/0 */
    { 0x054c, 0x1465, 0x3c00, RTFLOAT80U_INIT_C(1,0xad9fea7b7afeae42,16445), -6255488052961957665 }, /* #36/1 */
    { 0x094c, 0x1465, 0x3c00, RTFLOAT80U_INIT_C(1,0xad9fea7b7afeae42,16445), -6255488052961957665 }, /* #36/2 */
    { 0x0d4c, 0x1465, 0x3c00, RTFLOAT80U_INIT_C(1,0xad9fea7b7afeae42,16445), -6255488052961957665 }, /* #36/3 */
    { 0x0071, 0xa27b, 0x3800, RTFLOAT80U_INIT_C(1,0x80c0a62e44042294,16445), -4638798975011524938 }, /* #37/0 */
    { 0x0471, 0xa27b, 0x3800, RTFLOAT80U_INIT_C(1,0x80c0a62e44042294,16445), -4638798975011524938 }, /* #37/1 */
    { 0x0871, 0xa27b, 0x3800, RTFLOAT80U_INIT_C(1,0x80c0a62e44042294,16445), -4638798975011524938 }, /* #37/2 */
    { 0x0c71, 0xa27b, 0x3800, RTFLOAT80U_INIT_C(1,0x80c0a62e44042294,16445), -4638798975011524938 }, /* #37/3 */
    { 0x0263, 0x472a, 0x7d00, RTFLOAT80U_INIT_C(0,0x96cd4105b9dd57d8,16443), 1358301621095475963 }, /* #38/0 */
    { 0x0663, 0x472a, 0x7d00, RTFLOAT80U_INIT_C(0,0x96cd4105b9dd57d8,16443), 1358301621095475963 }, /* #38/1 */
    { 0x0a63, 0x472a, 0x7d00, RTFLOAT80U_INIT_C(0,0x96cd4105b9dd57d8,16443), 1358301621095475963 }, /* #38/2 */
    { 0x0e63, 0x472a, 0x7d00, RTFLOAT80U_INIT_C(0,0x96cd4105b9dd57d8,16443), 1358301621095475963 }, /* #38/3 */
    { 0x023e, 0xc72e, 0x7d00, RTFLOAT80U_INIT_C(0,0xb73fcd7e81d87ef4,16445), 6602249287850803066 }, /* #39/0 */
    { 0x063e, 0xc72e, 0x7d00, RTFLOAT80U_INIT_C(0,0xb73fcd7e81d87ef4,16445), 6602249287850803066 }, /* #39/1 */
    { 0x0a3e, 0xc72e, 0x7d00, RTFLOAT80U_INIT_C(0,0xb73fcd7e81d87ef4,16445), 6602249287850803066 }, /* #39/2 */
    { 0x0e3e, 0xc72e, 0x7d00, RTFLOAT80U_INIT_C(0,0xb73fcd7e81d87ef4,16445), 6602249287850803066 }, /* #39/3 */
    { 0x0062, 0xd7d9, 0x7d00, RTFLOAT80U_INIT_C(0,0x865345877382aa0c,16445), 4839578236105086214 }, /* #40/0 */
    { 0x0462, 0xd7d9, 0x7d00, RTFLOAT80U_INIT_C(0,0x865345877382aa0c,16445), 4839578236105086214 }, /* #40/1 */
    { 0x0862, 0xd7d9, 0x7d00, RTFLOAT80U_INIT_C(0,0x865345877382aa0c,16445), 4839578236105086214 }, /* #40/2 */
    { 0x0c62, 0xd7d9, 0x7d00, RTFLOAT80U_INIT_C(0,0x865345877382aa0c,16445), 4839578236105086214 }, /* #40/3 */
    { 0x0331, 0xe765, 0x7d00, RTFLOAT80U_INIT_C(1,0xddf34d0255eae5bc,16444), -3998302843537373551 }, /* #41/0 */
    { 0x0731, 0xe765, 0x7d00, RTFLOAT80U_INIT_C(1,0xddf34d0255eae5bc,16444), -3998302843537373551 }, /* #41/1 */
    { 0x0b31, 0xe765, 0x7d00, RTFLOAT80U_INIT_C(1,0xddf34d0255eae5bc,16444), -3998302843537373551 }, /* #41/2 */
    { 0x0f31, 0xe765, 0x7d00, RTFLOAT80U_INIT_C(1,0xddf34d0255eae5bc,16444), -3998302843537373551 }, /* #41/3 */
    { 0x023a, 0xca82, 0x7800, RTFLOAT80U_INIT_C(0,0xc207e39f2b30e800,16442), 873837115059932800 }, /* #42/0 */
    { 0x063a, 0xca82, 0x7800, RTFLOAT80U_INIT_C(0,0xc207e39f2b30e800,16442), 873837115059932800 }, /* #42/1 */
    { 0x0a3a, 0xca82, 0x7800, RTFLOAT80U_INIT_C(0,0xc207e39f2b30e800,16442), 873837115059932800 }, /* #42/2 */
    { 0x0e3a, 0xca82, 0x7800, RTFLOAT80U_INIT_C(0,0xc207e39f2b30e800,16442), 873837115059932800 }, /* #42/3 */
    { 0x0357, 0xa01c, 0x3800, RTFLOAT80U_INIT_C(0,0xa62dc897a75325c0,16445), 5987223768960439008 }, /* #43/0 */
    { 0x0757, 0xa01c, 0x3800, RTFLOAT80U_INIT_C(0,0xa62dc897a75325c0,16445), 5987223768960439008 }, /* #43/1 */
    { 0x0b57, 0xa01c, 0x3800, RTFLOAT80U_INIT_C(0,0xa62dc897a75325c0,16445), 5987223768960439008 }, /* #43/2 */
    { 0x0f57, 0xa01c, 0x3800, RTFLOAT80U_INIT_C(0,0xa62dc897a75325c0,16445), 5987223768960439008 }, /* #43/3 */
    { 0x0377, 0x9f6c, 0x3d00, RTFLOAT80U_INIT_C(0,0xd298f014b01535de,16445), 7587571458034539247 }, /* #44/0 */
    { 0x0777, 0x9f6c, 0x3d00, RTFLOAT80U_INIT_C(0,0xd298f014b01535de,16445), 7587571458034539247 }, /* #44/1 */
    { 0x0b77, 0x9f6c, 0x3d00, RTFLOAT80U_INIT_C(0,0xd298f014b01535de,16445), 7587571458034539247 }, /* #44/2 */
    { 0x0f77, 0x9f6c, 0x3d00, RTFLOAT80U_INIT_C(0,0xd298f014b01535de,16445), 7587571458034539247 }, /* #44/3 */
    { 0x025d, 0xabdd, 0x3900, RTFLOAT80U_INIT_C(0,0xccea4ad7eca96b98,16445), 7382848309768271308 }, /* #45/0 */
    { 0x065d, 0xabdd, 0x3900, RTFLOAT80U_INIT_C(0,0xccea4ad7eca96b98,16445), 7382848309768271308 }, /* #45/1 */
    { 0x0a5d, 0xabdd, 0x3900, RTFLOAT80U_INIT_C(0,0xccea4ad7eca96b98,16445), 7382848309768271308 }, /* #45/2 */
    { 0x0e5d, 0xabdd, 0x3900, RTFLOAT80U_INIT_C(0,0xccea4ad7eca96b98,16445), 7382848309768271308 }, /* #45/3 */
    { 0x014f, 0xee48, 0x7c00, RTFLOAT80U_INIT_C(1,0xfba42efa5d5249c0,16444), -4533167413135708784 }, /* #46/0 */
    { 0x054f, 0xee48, 0x7c00, RTFLOAT80U_INIT_C(1,0xfba42efa5d5249c0,16444), -4533167413135708784 }, /* #46/1 */
    { 0x094f, 0xee48, 0x7c00, RTFLOAT80U_INIT_C(1,0xfba42efa5d5249c0,16444), -4533167413135708784 }, /* #46/2 */
    { 0x0d4f, 0xee48, 0x7c00, RTFLOAT80U_INIT_C(1,0xfba42efa5d5249c0,16444), -4533167413135708784 }, /* #46/3 */
    { 0x0319, 0x8b19, 0x3900, RTFLOAT80U_INIT_C(1,0xeccb062819d62aa0,16443), -2132842297815647572 }, /* #47/0 */
    { 0x0719, 0x8b19, 0x3900, RTFLOAT80U_INIT_C(1,0xeccb062819d62aa0,16443), -2132842297815647572 }, /* #47/1 */
    { 0x0b19, 0x8b19, 0x3900, RTFLOAT80U_INIT_C(1,0xeccb062819d62aa0,16443), -2132842297815647572 }, /* #47/2 */
    { 0x0f19, 0x8b19, 0x3900, RTFLOAT80U_INIT_C(1,0xeccb062819d62aa0,16443), -2132842297815647572 }, /* #47/3 */
    { 0x000e, 0x812e, 0x3900, RTFLOAT80U_INIT_C(0,0x961a70e2218bfdd0,16444), 2704020392902852468 }, /* #48/0 */
    { 0x040e, 0x812e, 0x3900, RTFLOAT80U_INIT_C(0,0x961a70e2218bfdd0,16444), 2704020392902852468 }, /* #48/1 */
    { 0x080e, 0x812e, 0x3900, RTFLOAT80U_INIT_C(0,0x961a70e2218bfdd0,16444), 2704020392902852468 }, /* #48/2 */
    { 0x0c0e, 0x812e, 0x3900, RTFLOAT80U_INIT_C(0,0x961a70e2218bfdd0,16444), 2704020392902852468 }, /* #48/3 */
    { 0x032b, 0xcf48, 0x7d00, RTFLOAT80U_INIT_C(0,0xfba43242fa50cb80,16442), 1133292078934330552 }, /* #49/0 */
    { 0x072b, 0xcf48, 0x7d00, RTFLOAT80U_INIT_C(0,0xfba43242fa50cb80,16442), 1133292078934330552 }, /* #49/1 */
    { 0x0b2b, 0xcf48, 0x7d00, RTFLOAT80U_INIT_C(0,0xfba43242fa50cb80,16442), 1133292078934330552 }, /* #49/2 */
    { 0x0f2b, 0xcf48, 0x7d00, RTFLOAT80U_INIT_C(0,0xfba43242fa50cb80,16442), 1133292078934330552 }, /* #49/3 */
    { 0x0346, 0xec40, 0x7c00, RTFLOAT80U_INIT_C(0,0xf38a7d1e08547dc0,16443), 2193622058243100600 }, /* #50/0 */
    { 0x0746, 0xec40, 0x7c00, RTFLOAT80U_INIT_C(0,0xf38a7d1e08547dc0,16443), 2193622058243100600 }, /* #50/1 */
    { 0x0b46, 0xec40, 0x7c00, RTFLOAT80U_INIT_C(0,0xf38a7d1e08547dc0,16443), 2193622058243100600 }, /* #50/2 */
    { 0x0f46, 0xec40, 0x7c00, RTFLOAT80U_INIT_C(0,0xf38a7d1e08547dc0,16443), 2193622058243100600 }, /* #50/3 */
    { 0x0375, 0x6699, 0x7c00, RTFLOAT80U_INIT_C(1,0xb140c0f35d2982c0,16444), -3193105173673828528 }, /* #51/0 */
    { 0x0775, 0x6699, 0x7c00, RTFLOAT80U_INIT_C(1,0xb140c0f35d2982c0,16444), -3193105173673828528 }, /* #51/1 */
    { 0x0b75, 0x6699, 0x7c00, RTFLOAT80U_INIT_C(1,0xb140c0f35d2982c0,16444), -3193105173673828528 }, /* #51/2 */
    { 0x0f75, 0x6699, 0x7c00, RTFLOAT80U_INIT_C(1,0xb140c0f35d2982c0,16444), -3193105173673828528 }, /* #51/3 */
    { 0x026c, 0xed38, 0x7d00, RTFLOAT80U_INIT_C(1,0xac951876417a55b8,16444), -3108968210559309166 }, /* #52/0 */
    { 0x066c, 0xed38, 0x7d00, RTFLOAT80U_INIT_C(1,0xac951876417a55b8,16444), -3108968210559309166 }, /* #52/1 */
    { 0x0a6c, 0xed38, 0x7d00, RTFLOAT80U_INIT_C(1,0xac951876417a55b8,16444), -3108968210559309166 }, /* #52/2 */
    { 0x0e6c, 0xed38, 0x7d00, RTFLOAT80U_INIT_C(1,0xac951876417a55b8,16444), -3108968210559309166 }, /* #52/3 */
    { 0x0031, 0x6bbf, 0x7900, RTFLOAT80U_INIT_C(1,0xb2ac8b92e7a67d96,16445), -6437409448906669771 }, /* #53/0 */
    { 0x0431, 0x6bbf, 0x7900, RTFLOAT80U_INIT_C(1,0xb2ac8b92e7a67d96,16445), -6437409448906669771 }, /* #53/1 */
    { 0x0831, 0x6bbf, 0x7900, RTFLOAT80U_INIT_C(1,0xb2ac8b92e7a67d96,16445), -6437409448906669771 }, /* #53/2 */
    { 0x0c31, 0x6bbf, 0x7900, RTFLOAT80U_INIT_C(1,0xb2ac8b92e7a67d96,16445), -6437409448906669771 }, /* #53/3 */
    { 0x013e, 0xadd7, 0x3d00, RTFLOAT80U_INIT_C(0,0xa0de05585f8df26c,16445), 5795854184008317238 }, /* #54/0 */
    { 0x053e, 0xadd7, 0x3d00, RTFLOAT80U_INIT_C(0,0xa0de05585f8df26c,16445), 5795854184008317238 }, /* #54/1 */
    { 0x093e, 0xadd7, 0x3d00, RTFLOAT80U_INIT_C(0,0xa0de05585f8df26c,16445), 5795854184008317238 }, /* #54/2 */
    { 0x0d3e, 0xadd7, 0x3d00, RTFLOAT80U_INIT_C(0,0xa0de05585f8df26c,16445), 5795854184008317238 }, /* #54/3 */
    { 0x0245, 0xe103, 0x7900, RTFLOAT80U_INIT_C(1,0xcf3dea4064d5d644,16444), -3733337375430243729 }, /* #55/0 */
    { 0x0645, 0xe103, 0x7900, RTFLOAT80U_INIT_C(1,0xcf3dea4064d5d644,16444), -3733337375430243729 }, /* #55/1 */
    { 0x0a45, 0xe103, 0x7900, RTFLOAT80U_INIT_C(1,0xcf3dea4064d5d644,16444), -3733337375430243729 }, /* #55/2 */
    { 0x0e45, 0xe103, 0x7900, RTFLOAT80U_INIT_C(1,0xcf3dea4064d5d644,16444), -3733337375430243729 }, /* #55/3 */
    { 0x0110, 0xa4b0, 0x3c00, RTFLOAT80U_INIT_C(1,0x8519e317cee68a00,16445), -4795473286428574976 }, /* #56/0 */
    { 0x0510, 0xa4b0, 0x3c00, RTFLOAT80U_INIT_C(1,0x8519e317cee68a00,16445), -4795473286428574976 }, /* #56/1 */
    { 0x0910, 0xa4b0, 0x3c00, RTFLOAT80U_INIT_C(1,0x8519e317cee68a00,16445), -4795473286428574976 }, /* #56/2 */
    { 0x0d10, 0xa4b0, 0x3c00, RTFLOAT80U_INIT_C(1,0x8519e317cee68a00,16445), -4795473286428574976 }, /* #56/3 */
    { 0x025d, 0x3925, 0x3900, RTFLOAT80U_INIT_C(1,0x954caf25d7db7270,16444), -2689541546737851548 }, /* #57/0 */
    { 0x065d, 0x3925, 0x3900, RTFLOAT80U_INIT_C(1,0x954caf25d7db7270,16444), -2689541546737851548 }, /* #57/1 */
    { 0x0a5d, 0x3925, 0x3900, RTFLOAT80U_INIT_C(1,0x954caf25d7db7270,16444), -2689541546737851548 }, /* #57/2 */
    { 0x0e5d, 0x3925, 0x3900, RTFLOAT80U_INIT_C(1,0x954caf25d7db7270,16444), -2689541546737851548 }, /* #57/3 */
    { 0x0324, 0xc8f9, 0x7800, RTFLOAT80U_INIT_C(1,0xf266396abbffb388,16444), -4366677833846615266 }, /* #58/0 */
    { 0x0724, 0xc8f9, 0x7800, RTFLOAT80U_INIT_C(1,0xf266396abbffb388,16444), -4366677833846615266 }, /* #58/1 */
    { 0x0b24, 0xc8f9, 0x7800, RTFLOAT80U_INIT_C(1,0xf266396abbffb388,16444), -4366677833846615266 }, /* #58/2 */
    { 0x0f24, 0xc8f9, 0x7800, RTFLOAT80U_INIT_C(1,0xf266396abbffb388,16444), -4366677833846615266 }, /* #58/3 */
    { 0x0064, 0x4d25, 0x7d00, RTFLOAT80U_INIT_C(0,0xb4fe92dd8be7a70c,16445), 6521011525572088710 }, /* #59/0 */
    { 0x0464, 0x4d25, 0x7d00, RTFLOAT80U_INIT_C(0,0xb4fe92dd8be7a70c,16445), 6521011525572088710 }, /* #59/1 */
    { 0x0864, 0x4d25, 0x7d00, RTFLOAT80U_INIT_C(0,0xb4fe92dd8be7a70c,16445), 6521011525572088710 }, /* #59/2 */
    { 0x0c64, 0x4d25, 0x7d00, RTFLOAT80U_INIT_C(0,0xb4fe92dd8be7a70c,16445), 6521011525572088710 }, /* #59/3 */
    { 0x007a, 0x2f53, 0x3d00, RTFLOAT80U_INIT_C(0,0x8dad4fcaa8337960,16441), 319028239441959883 }, /* #60/0 */
    { 0x047a, 0x2f53, 0x3d00, RTFLOAT80U_INIT_C(0,0x8dad4fcaa8337960,16441), 319028239441959883 }, /* #60/1 */
    { 0x087a, 0x2f53, 0x3d00, RTFLOAT80U_INIT_C(0,0x8dad4fcaa8337960,16441), 319028239441959883 }, /* #60/2 */
    { 0x0c7a, 0x2f53, 0x3d00, RTFLOAT80U_INIT_C(0,0x8dad4fcaa8337960,16441), 319028239441959883 }, /* #60/3 */
    { 0x0110, 0xe94b, 0x7900, RTFLOAT80U_INIT_C(0,0xe526acbcf0b6de74,16444), 4128018752823211933 }, /* #61/0 */
    { 0x0510, 0xe94b, 0x7900, RTFLOAT80U_INIT_C(0,0xe526acbcf0b6de74,16444), 4128018752823211933 }, /* #61/1 */
    { 0x0910, 0xe94b, 0x7900, RTFLOAT80U_INIT_C(0,0xe526acbcf0b6de74,16444), 4128018752823211933 }, /* #61/2 */
    { 0x0d10, 0xe94b, 0x7900, RTFLOAT80U_INIT_C(0,0xe526acbcf0b6de74,16444), 4128018752823211933 }, /* #61/3 */
    { 0x032d, 0x6653, 0x7c00, RTFLOAT80U_INIT_C(0,0xbfb18e5b3eb3d400,16439), 107913891052087208 }, /* #62/0 */
    { 0x072d, 0x6653, 0x7c00, RTFLOAT80U_INIT_C(0,0xbfb18e5b3eb3d400,16439), 107913891052087208 }, /* #62/1 */
    { 0x0b2d, 0x6653, 0x7c00, RTFLOAT80U_INIT_C(0,0xbfb18e5b3eb3d400,16439), 107913891052087208 }, /* #62/2 */
    { 0x0f2d, 0x6653, 0x7c00, RTFLOAT80U_INIT_C(0,0xbfb18e5b3eb3d400,16439), 107913891052087208 }, /* #62/3 */
    { 0x0122, 0xfa4a, 0x7800, RTFLOAT80U_INIT_C(0,0xbaf1a7cf7dc8d578,16444), 3367683117513061726 }, /* #63/0 */
    { 0x0522, 0xfa4a, 0x7800, RTFLOAT80U_INIT_C(0,0xbaf1a7cf7dc8d578,16444), 3367683117513061726 }, /* #63/1 */
    { 0x0922, 0xfa4a, 0x7800, RTFLOAT80U_INIT_C(0,0xbaf1a7cf7dc8d578,16444), 3367683117513061726 }, /* #63/2 */
    { 0x0d22, 0xfa4a, 0x7800, RTFLOAT80U_INIT_C(0,0xbaf1a7cf7dc8d578,16444), 3367683117513061726 }, /* #63/3 */
    { 0x0370, 0xaa2c, 0x3800, RTFLOAT80U_INIT_C(0,0xdf05f82c8183ce00,16438), 62775483263189966 }, /* #64/0 */
    { 0x0770, 0xaa2c, 0x3800, RTFLOAT80U_INIT_C(0,0xdf05f82c8183ce00,16438), 62775483263189966 }, /* #64/1 */
    { 0x0b70, 0xaa2c, 0x3800, RTFLOAT80U_INIT_C(0,0xdf05f82c8183ce00,16438), 62775483263189966 }, /* #64/2 */
    { 0x0f70, 0xaa2c, 0x3800, RTFLOAT80U_INIT_C(0,0xdf05f82c8183ce00,16438), 62775483263189966 }, /* #64/3 */
    { 0x001f, 0xecc9, 0x7c00, RTFLOAT80U_INIT_C(1,0xf93ee05f0a17f318,16443), -2245004882849496675 }, /* #65/0 */
    { 0x041f, 0xecc9, 0x7c00, RTFLOAT80U_INIT_C(1,0xf93ee05f0a17f318,16443), -2245004882849496675 }, /* #65/1 */
    { 0x081f, 0xecc9, 0x7c00, RTFLOAT80U_INIT_C(1,0xf93ee05f0a17f318,16443), -2245004882849496675 }, /* #65/2 */
    { 0x0c1f, 0xecc9, 0x7c00, RTFLOAT80U_INIT_C(1,0xf93ee05f0a17f318,16443), -2245004882849496675 }, /* #65/3 */
    { 0x023d, 0xf474, 0x7c00, RTFLOAT80U_INIT_C(0,0xcfa8ef36b030f1fc,16444), 3740868195025435775 }, /* #66/0 */
    { 0x063d, 0xf474, 0x7c00, RTFLOAT80U_INIT_C(0,0xcfa8ef36b030f1fc,16444), 3740868195025435775 }, /* #66/1 */
    { 0x0a3d, 0xf474, 0x7c00, RTFLOAT80U_INIT_C(0,0xcfa8ef36b030f1fc,16444), 3740868195025435775 }, /* #66/2 */
    { 0x0e3d, 0xf474, 0x7c00, RTFLOAT80U_INIT_C(0,0xcfa8ef36b030f1fc,16444), 3740868195025435775 }, /* #66/3 */
    { 0x0034, 0x0346, 0x3900, RTFLOAT80U_INIT_C(0,0xf40b6d02cf9fe000,16433), 2146639285746943 }, /* #67/0 */
    { 0x0434, 0x0346, 0x3900, RTFLOAT80U_INIT_C(0,0xf40b6d02cf9fe000,16433), 2146639285746943 }, /* #67/1 */
    { 0x0834, 0x0346, 0x3900, RTFLOAT80U_INIT_C(0,0xf40b6d02cf9fe000,16433), 2146639285746943 }, /* #67/2 */
    { 0x0c34, 0x0346, 0x3900, RTFLOAT80U_INIT_C(0,0xf40b6d02cf9fe000,16433), 2146639285746943 }, /* #67/3 */
    { 0x0115, 0x9bb9, 0x3900, RTFLOAT80U_INIT_C(0,0xc36d4c8d70136528,16445), 7040997890105914004 }, /* #68/0 */
    { 0x0515, 0x9bb9, 0x3900, RTFLOAT80U_INIT_C(0,0xc36d4c8d70136528,16445), 7040997890105914004 }, /* #68/1 */
    { 0x0915, 0x9bb9, 0x3900, RTFLOAT80U_INIT_C(0,0xc36d4c8d70136528,16445), 7040997890105914004 }, /* #68/2 */
    { 0x0d15, 0x9bb9, 0x3900, RTFLOAT80U_INIT_C(0,0xc36d4c8d70136528,16445), 7040997890105914004 }, /* #68/3 */
    { 0x0263, 0xc164, 0x7900, RTFLOAT80U_INIT_C(1,0xef3647034096a3e0,16445), -8618521351550620144 }, /* #69/0 */
    { 0x0663, 0xc164, 0x7900, RTFLOAT80U_INIT_C(1,0xef3647034096a3e0,16445), -8618521351550620144 }, /* #69/1 */
    { 0x0a63, 0xc164, 0x7900, RTFLOAT80U_INIT_C(1,0xef3647034096a3e0,16445), -8618521351550620144 }, /* #69/2 */
    { 0x0e63, 0xc164, 0x7900, RTFLOAT80U_INIT_C(1,0xef3647034096a3e0,16445), -8618521351550620144 }, /* #69/3 */
    { 0x0107, 0xb5d9, 0x3d00, RTFLOAT80U_INIT_C(0,0xf870bc24f8c1bfa6,16445), 8951007692888006611 }, /* #70/0 */
    { 0x0507, 0xb5d9, 0x3d00, RTFLOAT80U_INIT_C(0,0xf870bc24f8c1bfa6,16445), 8951007692888006611 }, /* #70/1 */
    { 0x0907, 0xb5d9, 0x3d00, RTFLOAT80U_INIT_C(0,0xf870bc24f8c1bfa6,16445), 8951007692888006611 }, /* #70/2 */
    { 0x0d07, 0xb5d9, 0x3d00, RTFLOAT80U_INIT_C(0,0xf870bc24f8c1bfa6,16445), 8951007692888006611 }, /* #70/3 */
    { 0x0156, 0x6a6b, 0x7800, RTFLOAT80U_INIT_C(1,0xecf0e93949129ace,16445), -8536701309804957031 }, /* #71/0 */
    { 0x0556, 0x6a6b, 0x7800, RTFLOAT80U_INIT_C(1,0xecf0e93949129ace,16445), -8536701309804957031 }, /* #71/1 */
    { 0x0956, 0x6a6b, 0x7800, RTFLOAT80U_INIT_C(1,0xecf0e93949129ace,16445), -8536701309804957031 }, /* #71/2 */
    { 0x0d56, 0x6a6b, 0x7800, RTFLOAT80U_INIT_C(1,0xecf0e93949129ace,16445), -8536701309804957031 }, /* #71/3 */
    { 0x007f, 0x770b, 0x7d00, RTFLOAT80U_INIT_C(0,0xbba987176618aec4,16445), 6761243945361758050 }, /* #72/0 */
    { 0x047f, 0x770b, 0x7d00, RTFLOAT80U_INIT_C(0,0xbba987176618aec4,16445), 6761243945361758050 }, /* #72/1 */
    { 0x087f, 0x770b, 0x7d00, RTFLOAT80U_INIT_C(0,0xbba987176618aec4,16445), 6761243945361758050 }, /* #72/2 */
    { 0x0c7f, 0x770b, 0x7d00, RTFLOAT80U_INIT_C(0,0xbba987176618aec4,16445), 6761243945361758050 }, /* #72/3 */
    { 0x0378, 0x77dd, 0x7d00, RTFLOAT80U_INIT_C(0,0xf6b936ce76f094c4,16445), 8889150632204192354 }, /* #73/0 */
    { 0x0778, 0x77dd, 0x7d00, RTFLOAT80U_INIT_C(0,0xf6b936ce76f094c4,16445), 8889150632204192354 }, /* #73/1 */
    { 0x0b78, 0x77dd, 0x7d00, RTFLOAT80U_INIT_C(0,0xf6b936ce76f094c4,16445), 8889150632204192354 }, /* #73/2 */
    { 0x0f78, 0x77dd, 0x7d00, RTFLOAT80U_INIT_C(0,0xf6b936ce76f094c4,16445), 8889150632204192354 }, /* #73/3 */
    { 0x0110, 0x4cf2, 0x7c00, RTFLOAT80U_INIT_C(1,0x99a7cbc09a39ee50,16445), -5536021118497650472 }, /* #74/0 */
    { 0x0510, 0x4cf2, 0x7c00, RTFLOAT80U_INIT_C(1,0x99a7cbc09a39ee50,16445), -5536021118497650472 }, /* #74/1 */
    { 0x0910, 0x4cf2, 0x7c00, RTFLOAT80U_INIT_C(1,0x99a7cbc09a39ee50,16445), -5536021118497650472 }, /* #74/2 */
    { 0x0d10, 0x4cf2, 0x7c00, RTFLOAT80U_INIT_C(1,0x99a7cbc09a39ee50,16445), -5536021118497650472 }, /* #74/3 */
    { 0x0167, 0xc345, 0x7900, RTFLOAT80U_INIT_C(1,0xf9a4f2cb68c24b48,16443), -2248596220884306281 }, /* #75/0 */
    { 0x0567, 0xc345, 0x7900, RTFLOAT80U_INIT_C(1,0xf9a4f2cb68c24b48,16443), -2248596220884306281 }, /* #75/1 */
    { 0x0967, 0xc345, 0x7900, RTFLOAT80U_INIT_C(1,0xf9a4f2cb68c24b48,16443), -2248596220884306281 }, /* #75/2 */
    { 0x0d67, 0xc345, 0x7900, RTFLOAT80U_INIT_C(1,0xf9a4f2cb68c24b48,16443), -2248596220884306281 }, /* #75/3 */
    { 0x021f, 0x28c0, 0x3800, RTFLOAT80U_INIT_C(1,0xbc53f0f467293fd6,16445), -6785227517345439723 }, /* #76/0 */
    { 0x061f, 0x28c0, 0x3800, RTFLOAT80U_INIT_C(1,0xbc53f0f467293fd6,16445), -6785227517345439723 }, /* #76/1 */
    { 0x0a1f, 0x28c0, 0x3800, RTFLOAT80U_INIT_C(1,0xbc53f0f467293fd6,16445), -6785227517345439723 }, /* #76/2 */
    { 0x0e1f, 0x28c0, 0x3800, RTFLOAT80U_INIT_C(1,0xbc53f0f467293fd6,16445), -6785227517345439723 }, /* #76/3 */
    { 0x0235, 0x0820, 0x3800, RTFLOAT80U_INIT_C(0,0xac4052447d7045cc,16444), 3103002756787212659 }, /* #77/0 */
    { 0x0635, 0x0820, 0x3800, RTFLOAT80U_INIT_C(0,0xac4052447d7045cc,16444), 3103002756787212659 }, /* #77/1 */
    { 0x0a35, 0x0820, 0x3800, RTFLOAT80U_INIT_C(0,0xac4052447d7045cc,16444), 3103002756787212659 }, /* #77/2 */
    { 0x0e35, 0x0820, 0x3800, RTFLOAT80U_INIT_C(0,0xac4052447d7045cc,16444), 3103002756787212659 }, /* #77/3 */
    { 0x016f, 0xc557, 0x7d00, RTFLOAT80U_INIT_C(0,0x97826f4fe5b33952,16445), 5458705417823165609 }, /* #78/0 */
    { 0x056f, 0xc557, 0x7d00, RTFLOAT80U_INIT_C(0,0x97826f4fe5b33952,16445), 5458705417823165609 }, /* #78/1 */
    { 0x096f, 0xc557, 0x7d00, RTFLOAT80U_INIT_C(0,0x97826f4fe5b33952,16445), 5458705417823165609 }, /* #78/2 */
    { 0x0d6f, 0xc557, 0x7d00, RTFLOAT80U_INIT_C(0,0x97826f4fe5b33952,16445), 5458705417823165609 }, /* #78/3 */
    { 0x033d, 0x713e, 0x7900, RTFLOAT80U_INIT_C(1,0xa6459158595b9054,16445), -5990571096165697578 }, /* #79/0 */
    { 0x073d, 0x713e, 0x7900, RTFLOAT80U_INIT_C(1,0xa6459158595b9054,16445), -5990571096165697578 }, /* #79/1 */
    { 0x0b3d, 0x713e, 0x7900, RTFLOAT80U_INIT_C(1,0xa6459158595b9054,16445), -5990571096165697578 }, /* #79/2 */
    { 0x0f3d, 0x713e, 0x7900, RTFLOAT80U_INIT_C(1,0xa6459158595b9054,16445), -5990571096165697578 }, /* #79/3 */
    { 0x0201, 0x3c1e, 0x3c00, RTFLOAT80U_INIT_C(0,0x8636315684832e70,16443), 1208871437185607118 }, /* #80/0 */
    { 0x0601, 0x3c1e, 0x3c00, RTFLOAT80U_INIT_C(0,0x8636315684832e70,16443), 1208871437185607118 }, /* #80/1 */
    { 0x0a01, 0x3c1e, 0x3c00, RTFLOAT80U_INIT_C(0,0x8636315684832e70,16443), 1208871437185607118 }, /* #80/2 */
    { 0x0e01, 0x3c1e, 0x3c00, RTFLOAT80U_INIT_C(0,0x8636315684832e70,16443), 1208871437185607118 }, /* #80/3 */
    { 0x0353, 0x4d63, 0x7d00, RTFLOAT80U_INIT_C(1,0xe485cdc9feabccb4,16444), -4116698469998719789 }, /* #81/0 */
    { 0x0753, 0x4d63, 0x7d00, RTFLOAT80U_INIT_C(1,0xe485cdc9feabccb4,16444), -4116698469998719789 }, /* #81/1 */
    { 0x0b53, 0x4d63, 0x7d00, RTFLOAT80U_INIT_C(1,0xe485cdc9feabccb4,16444), -4116698469998719789 }, /* #81/2 */
    { 0x0f53, 0x4d63, 0x7d00, RTFLOAT80U_INIT_C(1,0xe485cdc9feabccb4,16444), -4116698469998719789 }, /* #81/3 */
    { 0x0031, 0x624b, 0x7800, RTFLOAT80U_INIT_C(0,0x8f4c45e80567200c,16445), 5162852454239539206 }, /* #82/0 */
    { 0x0431, 0x624b, 0x7800, RTFLOAT80U_INIT_C(0,0x8f4c45e80567200c,16445), 5162852454239539206 }, /* #82/1 */
    { 0x0831, 0x624b, 0x7800, RTFLOAT80U_INIT_C(0,0x8f4c45e80567200c,16445), 5162852454239539206 }, /* #82/2 */
    { 0x0c31, 0x624b, 0x7800, RTFLOAT80U_INIT_C(0,0x8f4c45e80567200c,16445), 5162852454239539206 }, /* #82/3 */
    { 0x021f, 0x36f7, 0x3c00, RTFLOAT80U_INIT_C(1,0x98e4ab0f4c0be8fa,16445), -5508559335321891965 }, /* #83/0 */
    { 0x061f, 0x36f7, 0x3c00, RTFLOAT80U_INIT_C(1,0x98e4ab0f4c0be8fa,16445), -5508559335321891965 }, /* #83/1 */
    { 0x0a1f, 0x36f7, 0x3c00, RTFLOAT80U_INIT_C(1,0x98e4ab0f4c0be8fa,16445), -5508559335321891965 }, /* #83/2 */
    { 0x0e1f, 0x36f7, 0x3c00, RTFLOAT80U_INIT_C(1,0x98e4ab0f4c0be8fa,16445), -5508559335321891965 }, /* #83/3 */
    { 0x0119, 0xbd1c, 0x3d00, RTFLOAT80U_INIT_C(0,0xc5b6195f6e68bf9e,16445), 7123301184449044431 }, /* #84/0 */
    { 0x0519, 0xbd1c, 0x3d00, RTFLOAT80U_INIT_C(0,0xc5b6195f6e68bf9e,16445), 7123301184449044431 }, /* #84/1 */
    { 0x0919, 0xbd1c, 0x3d00, RTFLOAT80U_INIT_C(0,0xc5b6195f6e68bf9e,16445), 7123301184449044431 }, /* #84/2 */
    { 0x0d19, 0xbd1c, 0x3d00, RTFLOAT80U_INIT_C(0,0xc5b6195f6e68bf9e,16445), 7123301184449044431 }, /* #84/3 */
    { 0x034b, 0x1bbe, 0x3900, RTFLOAT80U_INIT_C(1,0x8d4812f6bb7676f0,16443), -1272550976073420510 }, /* #85/0 */
    { 0x074b, 0x1bbe, 0x3900, RTFLOAT80U_INIT_C(1,0x8d4812f6bb7676f0,16443), -1272550976073420510 }, /* #85/1 */
    { 0x0b4b, 0x1bbe, 0x3900, RTFLOAT80U_INIT_C(1,0x8d4812f6bb7676f0,16443), -1272550976073420510 }, /* #85/2 */
    { 0x0f4b, 0x1bbe, 0x3900, RTFLOAT80U_INIT_C(1,0x8d4812f6bb7676f0,16443), -1272550976073420510 }, /* #85/3 */
    { 0x0350, 0x29cb, 0x3900, RTFLOAT80U_INIT_C(0,0xead6a5689da529ce,16445), 8460947259315623143 }, /* #86/0 */
    { 0x0750, 0x29cb, 0x3900, RTFLOAT80U_INIT_C(0,0xead6a5689da529ce,16445), 8460947259315623143 }, /* #86/1 */
    { 0x0b50, 0x29cb, 0x3900, RTFLOAT80U_INIT_C(0,0xead6a5689da529ce,16445), 8460947259315623143 }, /* #86/2 */
    { 0x0f50, 0x29cb, 0x3900, RTFLOAT80U_INIT_C(0,0xead6a5689da529ce,16445), 8460947259315623143 }, /* #86/3 */
    { 0x0272, 0xc6f9, 0x7c00, RTFLOAT80U_INIT_C(0,0xa8230b1ed106cfae,16445), 6057769824770287575 }, /* #87/0 */
    { 0x0672, 0xc6f9, 0x7c00, RTFLOAT80U_INIT_C(0,0xa8230b1ed106cfae,16445), 6057769824770287575 }, /* #87/1 */
    { 0x0a72, 0xc6f9, 0x7c00, RTFLOAT80U_INIT_C(0,0xa8230b1ed106cfae,16445), 6057769824770287575 }, /* #87/2 */
    { 0x0e72, 0xc6f9, 0x7c00, RTFLOAT80U_INIT_C(0,0xa8230b1ed106cfae,16445), 6057769824770287575 }, /* #87/3 */
    { 0x0067, 0x91e5, 0x3900, RTFLOAT80U_INIT_C(0,0xc243e9e0b451e7b0,16445), 6999144609052423128 }, /* #88/0 */
    { 0x0467, 0x91e5, 0x3900, RTFLOAT80U_INIT_C(0,0xc243e9e0b451e7b0,16445), 6999144609052423128 }, /* #88/1 */
    { 0x0867, 0x91e5, 0x3900, RTFLOAT80U_INIT_C(0,0xc243e9e0b451e7b0,16445), 6999144609052423128 }, /* #88/2 */
    { 0x0c67, 0x91e5, 0x3900, RTFLOAT80U_INIT_C(0,0xc243e9e0b451e7b0,16445), 6999144609052423128 }, /* #88/3 */
    { 0x0105, 0xcc1c, 0x7c00, RTFLOAT80U_INIT_C(0,0xe557d318b0520198,16444), 4131477365162541158 }, /* #89/0 */
    { 0x0505, 0xcc1c, 0x7c00, RTFLOAT80U_INIT_C(0,0xe557d318b0520198,16444), 4131477365162541158 }, /* #89/1 */
    { 0x0905, 0xcc1c, 0x7c00, RTFLOAT80U_INIT_C(0,0xe557d318b0520198,16444), 4131477365162541158 }, /* #89/2 */
    { 0x0d05, 0xcc1c, 0x7c00, RTFLOAT80U_INIT_C(0,0xe557d318b0520198,16444), 4131477365162541158 }, /* #89/3 */
    { 0x0366, 0x7da8, 0x7d00, RTFLOAT80U_INIT_C(0,0xca111d416423bc04,16444), 3640112809238916865 }, /* #90/0 */
    { 0x0766, 0x7da8, 0x7d00, RTFLOAT80U_INIT_C(0,0xca111d416423bc04,16444), 3640112809238916865 }, /* #90/1 */
    { 0x0b66, 0x7da8, 0x7d00, RTFLOAT80U_INIT_C(0,0xca111d416423bc04,16444), 3640112809238916865 }, /* #90/2 */
    { 0x0f66, 0x7da8, 0x7d00, RTFLOAT80U_INIT_C(0,0xca111d416423bc04,16444), 3640112809238916865 }, /* #90/3 */
    { 0x017c, 0xb43f, 0x3c00, RTFLOAT80U_INIT_C(0,0xe0f4aafdbb0eba9c,16444), 4052442241388752551 }, /* #91/0 */
    { 0x057c, 0xb43f, 0x3c00, RTFLOAT80U_INIT_C(0,0xe0f4aafdbb0eba9c,16444), 4052442241388752551 }, /* #91/1 */
    { 0x097c, 0xb43f, 0x3c00, RTFLOAT80U_INIT_C(0,0xe0f4aafdbb0eba9c,16444), 4052442241388752551 }, /* #91/2 */
    { 0x0d7c, 0xb43f, 0x3c00, RTFLOAT80U_INIT_C(0,0xe0f4aafdbb0eba9c,16444), 4052442241388752551 }, /* #91/3 */
    { 0x0056, 0xd969, 0x7900, RTFLOAT80U_INIT_C(0,0xf5485bf225f4b97c,16445), 8837238916596260030 }, /* #92/0 */
    { 0x0456, 0xd969, 0x7900, RTFLOAT80U_INIT_C(0,0xf5485bf225f4b97c,16445), 8837238916596260030 }, /* #92/1 */
    { 0x0856, 0xd969, 0x7900, RTFLOAT80U_INIT_C(0,0xf5485bf225f4b97c,16445), 8837238916596260030 }, /* #92/2 */
    { 0x0c56, 0xd969, 0x7900, RTFLOAT80U_INIT_C(0,0xf5485bf225f4b97c,16445), 8837238916596260030 }, /* #92/3 */
    { 0x0230, 0x37c8, 0x3d00, RTFLOAT80U_INIT_C(1,0xadd020874c0c2258,16443), -1565568291148235851 }, /* #93/0 */
    { 0x0630, 0x37c8, 0x3d00, RTFLOAT80U_INIT_C(1,0xadd020874c0c2258,16443), -1565568291148235851 }, /* #93/1 */
    { 0x0a30, 0x37c8, 0x3d00, RTFLOAT80U_INIT_C(1,0xadd020874c0c2258,16443), -1565568291148235851 }, /* #93/2 */
    { 0x0e30, 0x37c8, 0x3d00, RTFLOAT80U_INIT_C(1,0xadd020874c0c2258,16443), -1565568291148235851 }, /* #93/3 */
    { 0x017c, 0xb809, 0x3800, RTFLOAT80U_INIT_C(1,0xd48c90e0b325cafc,16445), -7657887863766443390 }, /* #94/0 */
    { 0x057c, 0xb809, 0x3800, RTFLOAT80U_INIT_C(1,0xd48c90e0b325cafc,16445), -7657887863766443390 }, /* #94/1 */
    { 0x097c, 0xb809, 0x3800, RTFLOAT80U_INIT_C(1,0xd48c90e0b325cafc,16445), -7657887863766443390 }, /* #94/2 */
    { 0x0d7c, 0xb809, 0x3800, RTFLOAT80U_INIT_C(1,0xd48c90e0b325cafc,16445), -7657887863766443390 }, /* #94/3 */
    { 0x0151, 0xf22b, 0x7800, RTFLOAT80U_INIT_C(0,0xfd6ab994b3c428b8,16445), 9130305843724686428 }, /* #95/0 */
    { 0x0551, 0xf22b, 0x7800, RTFLOAT80U_INIT_C(0,0xfd6ab994b3c428b8,16445), 9130305843724686428 }, /* #95/1 */
    { 0x0951, 0xf22b, 0x7800, RTFLOAT80U_INIT_C(0,0xfd6ab994b3c428b8,16445), 9130305843724686428 }, /* #95/2 */
    { 0x0d51, 0xf22b, 0x7800, RTFLOAT80U_INIT_C(0,0xfd6ab994b3c428b8,16445), 9130305843724686428 }, /* #95/3 */
};
uint32_t const g_cTests_fild_r80_from_i64 = RT_ELEMENTS(g_aTests_fild_r80_from_i64);

FPU_I32_IN_TEST_T const g_aTests_fild_r80_from_i32[] =
{
    { 0x013e, 0xf6a6, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #0/0 */
    { 0x053e, 0xf6a6, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #0/1 */
    { 0x093e, 0xf6a6, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #0/2 */
    { 0x0d3e, 0xf6a6, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #0/3 */
    { 0x024f, 0xebc3, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #1/0 */
    { 0x064f, 0xebc3, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #1/1 */
    { 0x0a4f, 0xebc3, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #1/2 */
    { 0x0e4f, 0xebc3, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #1/3 */
    { 0x0358, 0xa2a4, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #2/0 */
    { 0x0758, 0xa2a4, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #2/1 */
    { 0x0b58, 0xa2a4, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #2/2 */
    { 0x0f58, 0xa2a4, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #2/3 */
    { 0x0211, 0xbcc0, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #3/0 */
    { 0x0611, 0xbcc0, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #3/1 */
    { 0x0a11, 0xbcc0, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #3/2 */
    { 0x0e11, 0xbcc0, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #3/3 */
    { 0x0000, 0x9a75, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #4/0 */
    { 0x0400, 0x9a75, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #4/1 */
    { 0x0800, 0x9a75, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #4/2 */
    { 0x0c00, 0x9a75, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #4/3 */
    { 0x0154, 0xd56c, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #5/0 */
    { 0x0554, 0xd56c, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #5/1 */
    { 0x0954, 0xd56c, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #5/2 */
    { 0x0d54, 0xd56c, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #5/3 */
    { 0x030d, 0x14f3, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #6/0 */
    { 0x070d, 0x14f3, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #6/1 */
    { 0x0b0d, 0x14f3, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #6/2 */
    { 0x0f0d, 0x14f3, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #6/3 */
    { 0x0149, 0x8539, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #7/0 */
    { 0x0549, 0x8539, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #7/1 */
    { 0x0949, 0x8539, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #7/2 */
    { 0x0d49, 0x8539, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #7/3 */
    { 0x0024, 0xa96c, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #8/0 */
    { 0x0424, 0xa96c, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #8/1 */
    { 0x0824, 0xa96c, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #8/2 */
    { 0x0c24, 0xa96c, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #8/3 */
    { 0x0351, 0x1084, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #9/0 */
    { 0x0751, 0x1084, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #9/1 */
    { 0x0b51, 0x1084, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #9/2 */
    { 0x0f51, 0x1084, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #9/3 */
    { 0x022a, 0x796f, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #10/0 */
    { 0x062a, 0x796f, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #10/1 */
    { 0x0a2a, 0x796f, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #10/2 */
    { 0x0e2a, 0x796f, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #10/3 */
    { 0x025b, 0x9bbe, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #11/0 */
    { 0x065b, 0x9bbe, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #11/1 */
    { 0x0a5b, 0x9bbe, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #11/2 */
    { 0x0e5b, 0x9bbe, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #11/3 */
    { 0x0208, 0x83ab, 0x3900, RTFLOAT80U_INIT_C(0,0x8c3d23b200000000,16413), 1176408537 }, /* #12/0 */
    { 0x0608, 0x83ab, 0x3900, RTFLOAT80U_INIT_C(0,0x8c3d23b200000000,16413), 1176408537 }, /* #12/1 */
    { 0x0a08, 0x83ab, 0x3900, RTFLOAT80U_INIT_C(0,0x8c3d23b200000000,16413), 1176408537 }, /* #12/2 */
    { 0x0e08, 0x83ab, 0x3900, RTFLOAT80U_INIT_C(0,0x8c3d23b200000000,16413), 1176408537 }, /* #12/3 */
    { 0x0007, 0x019e, 0x3900, RTFLOAT80U_INIT_C(0,0xbeb9886a00000000,16413), 1599915061 }, /* #13/0 */
    { 0x0407, 0x019e, 0x3900, RTFLOAT80U_INIT_C(0,0xbeb9886a00000000,16413), 1599915061 }, /* #13/1 */
    { 0x0807, 0x019e, 0x3900, RTFLOAT80U_INIT_C(0,0xbeb9886a00000000,16413), 1599915061 }, /* #13/2 */
    { 0x0c07, 0x019e, 0x3900, RTFLOAT80U_INIT_C(0,0xbeb9886a00000000,16413), 1599915061 }, /* #13/3 */
    { 0x0141, 0x1cd0, 0x3c00, RTFLOAT80U_INIT_C(0,0x9ebdb6de00000000,16413), 1331616623 }, /* #14/0 */
    { 0x0541, 0x1cd0, 0x3c00, RTFLOAT80U_INIT_C(0,0x9ebdb6de00000000,16413), 1331616623 }, /* #14/1 */
    { 0x0941, 0x1cd0, 0x3c00, RTFLOAT80U_INIT_C(0,0x9ebdb6de00000000,16413), 1331616623 }, /* #14/2 */
    { 0x0d41, 0x1cd0, 0x3c00, RTFLOAT80U_INIT_C(0,0x9ebdb6de00000000,16413), 1331616623 }, /* #14/3 */
    { 0x0000, 0xb49e, 0x3c00, RTFLOAT80U_INIT_C(1,0xb989b94200000000,16413), -1556405409 }, /* #15/0 */
    { 0x0400, 0xb49e, 0x3c00, RTFLOAT80U_INIT_C(1,0xb989b94200000000,16413), -1556405409 }, /* #15/1 */
    { 0x0800, 0xb49e, 0x3c00, RTFLOAT80U_INIT_C(1,0xb989b94200000000,16413), -1556405409 }, /* #15/2 */
    { 0x0c00, 0xb49e, 0x3c00, RTFLOAT80U_INIT_C(1,0xb989b94200000000,16413), -1556405409 }, /* #15/3 */
    { 0x014f, 0xd2f4, 0x7800, RTFLOAT80U_INIT_C(0,0x9754c66800000000,16411), 317364429 }, /* #16/0 */
    { 0x054f, 0xd2f4, 0x7800, RTFLOAT80U_INIT_C(0,0x9754c66800000000,16411), 317364429 }, /* #16/1 */
    { 0x094f, 0xd2f4, 0x7800, RTFLOAT80U_INIT_C(0,0x9754c66800000000,16411), 317364429 }, /* #16/2 */
    { 0x0d4f, 0xd2f4, 0x7800, RTFLOAT80U_INIT_C(0,0x9754c66800000000,16411), 317364429 }, /* #16/3 */
    { 0x0060, 0x6a1f, 0x7800, RTFLOAT80U_INIT_C(0,0xf5ae230000000000,16407), 32201798 }, /* #17/0 */
    { 0x0460, 0x6a1f, 0x7800, RTFLOAT80U_INIT_C(0,0xf5ae230000000000,16407), 32201798 }, /* #17/1 */
    { 0x0860, 0x6a1f, 0x7800, RTFLOAT80U_INIT_C(0,0xf5ae230000000000,16407), 32201798 }, /* #17/2 */
    { 0x0c60, 0x6a1f, 0x7800, RTFLOAT80U_INIT_C(0,0xf5ae230000000000,16407), 32201798 }, /* #17/3 */
    { 0x011b, 0x9c9d, 0x3c00, RTFLOAT80U_INIT_C(0,0xcb4e7ad000000000,16410), 213182381 }, /* #18/0 */
    { 0x051b, 0x9c9d, 0x3c00, RTFLOAT80U_INIT_C(0,0xcb4e7ad000000000,16410), 213182381 }, /* #18/1 */
    { 0x091b, 0x9c9d, 0x3c00, RTFLOAT80U_INIT_C(0,0xcb4e7ad000000000,16410), 213182381 }, /* #18/2 */
    { 0x0d1b, 0x9c9d, 0x3c00, RTFLOAT80U_INIT_C(0,0xcb4e7ad000000000,16410), 213182381 }, /* #18/3 */
    { 0x0369, 0x33a5, 0x3900, RTFLOAT80U_INIT_C(0,0xffa409a000000000,16409), 134029389 }, /* #19/0 */
    { 0x0769, 0x33a5, 0x3900, RTFLOAT80U_INIT_C(0,0xffa409a000000000,16409), 134029389 }, /* #19/1 */
    { 0x0b69, 0x33a5, 0x3900, RTFLOAT80U_INIT_C(0,0xffa409a000000000,16409), 134029389 }, /* #19/2 */
    { 0x0f69, 0x33a5, 0x3900, RTFLOAT80U_INIT_C(0,0xffa409a000000000,16409), 134029389 }, /* #19/3 */
    { 0x013c, 0xd4ec, 0x7c00, RTFLOAT80U_INIT_C(1,0xb1b5010000000000,16411), -372678688 }, /* #20/0 */
    { 0x053c, 0xd4ec, 0x7c00, RTFLOAT80U_INIT_C(1,0xb1b5010000000000,16411), -372678688 }, /* #20/1 */
    { 0x093c, 0xd4ec, 0x7c00, RTFLOAT80U_INIT_C(1,0xb1b5010000000000,16411), -372678688 }, /* #20/2 */
    { 0x0d3c, 0xd4ec, 0x7c00, RTFLOAT80U_INIT_C(1,0xb1b5010000000000,16411), -372678688 }, /* #20/3 */
    { 0x014f, 0x2391, 0x3900, RTFLOAT80U_INIT_C(1,0xc631b15000000000,16413), -1662572712 }, /* #21/0 */
    { 0x054f, 0x2391, 0x3900, RTFLOAT80U_INIT_C(1,0xc631b15000000000,16413), -1662572712 }, /* #21/1 */
    { 0x094f, 0x2391, 0x3900, RTFLOAT80U_INIT_C(1,0xc631b15000000000,16413), -1662572712 }, /* #21/2 */
    { 0x0d4f, 0x2391, 0x3900, RTFLOAT80U_INIT_C(1,0xc631b15000000000,16413), -1662572712 }, /* #21/3 */
    { 0x032f, 0x881c, 0x3800, RTFLOAT80U_INIT_C(0,0x8e783a2400000000,16413), 1195121938 }, /* #22/0 */
    { 0x072f, 0x881c, 0x3800, RTFLOAT80U_INIT_C(0,0x8e783a2400000000,16413), 1195121938 }, /* #22/1 */
    { 0x0b2f, 0x881c, 0x3800, RTFLOAT80U_INIT_C(0,0x8e783a2400000000,16413), 1195121938 }, /* #22/2 */
    { 0x0f2f, 0x881c, 0x3800, RTFLOAT80U_INIT_C(0,0x8e783a2400000000,16413), 1195121938 }, /* #22/3 */
    { 0x034b, 0x4f02, 0x7d00, RTFLOAT80U_INIT_C(0,0x94db7a7000000000,16413), 1248705848 }, /* #23/0 */
    { 0x074b, 0x4f02, 0x7d00, RTFLOAT80U_INIT_C(0,0x94db7a7000000000,16413), 1248705848 }, /* #23/1 */
    { 0x0b4b, 0x4f02, 0x7d00, RTFLOAT80U_INIT_C(0,0x94db7a7000000000,16413), 1248705848 }, /* #23/2 */
    { 0x0f4b, 0x4f02, 0x7d00, RTFLOAT80U_INIT_C(0,0x94db7a7000000000,16413), 1248705848 }, /* #23/3 */
    { 0x024c, 0x1fd2, 0x3d00, RTFLOAT80U_INIT_C(1,0xfbc85d1800000000,16413), -2112106124 }, /* #24/0 */
    { 0x064c, 0x1fd2, 0x3d00, RTFLOAT80U_INIT_C(1,0xfbc85d1800000000,16413), -2112106124 }, /* #24/1 */
    { 0x0a4c, 0x1fd2, 0x3d00, RTFLOAT80U_INIT_C(1,0xfbc85d1800000000,16413), -2112106124 }, /* #24/2 */
    { 0x0e4c, 0x1fd2, 0x3d00, RTFLOAT80U_INIT_C(1,0xfbc85d1800000000,16413), -2112106124 }, /* #24/3 */
    { 0x0247, 0xa5bc, 0x3d00, RTFLOAT80U_INIT_C(1,0xac94ab4000000000,16410), -180964020 }, /* #25/0 */
    { 0x0647, 0xa5bc, 0x3d00, RTFLOAT80U_INIT_C(1,0xac94ab4000000000,16410), -180964020 }, /* #25/1 */
    { 0x0a47, 0xa5bc, 0x3d00, RTFLOAT80U_INIT_C(1,0xac94ab4000000000,16410), -180964020 }, /* #25/2 */
    { 0x0e47, 0xa5bc, 0x3d00, RTFLOAT80U_INIT_C(1,0xac94ab4000000000,16410), -180964020 }, /* #25/3 */
    { 0x0161, 0x44b8, 0x7c00, RTFLOAT80U_INIT_C(0,0x8268330800000000,16413), 1093933444 }, /* #26/0 */
    { 0x0561, 0x44b8, 0x7c00, RTFLOAT80U_INIT_C(0,0x8268330800000000,16413), 1093933444 }, /* #26/1 */
    { 0x0961, 0x44b8, 0x7c00, RTFLOAT80U_INIT_C(0,0x8268330800000000,16413), 1093933444 }, /* #26/2 */
    { 0x0d61, 0x44b8, 0x7c00, RTFLOAT80U_INIT_C(0,0x8268330800000000,16413), 1093933444 }, /* #26/3 */
    { 0x000e, 0x8505, 0x3d00, RTFLOAT80U_INIT_C(1,0xcdc861bc00000000,16413), -1726230750 }, /* #27/0 */
    { 0x040e, 0x8505, 0x3d00, RTFLOAT80U_INIT_C(1,0xcdc861bc00000000,16413), -1726230750 }, /* #27/1 */
    { 0x080e, 0x8505, 0x3d00, RTFLOAT80U_INIT_C(1,0xcdc861bc00000000,16413), -1726230750 }, /* #27/2 */
    { 0x0c0e, 0x8505, 0x3d00, RTFLOAT80U_INIT_C(1,0xcdc861bc00000000,16413), -1726230750 }, /* #27/3 */
    { 0x0248, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(1,0xfe7ed31200000000,16413), -2134862217 }, /* #28/0 */
    { 0x0648, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(1,0xfe7ed31200000000,16413), -2134862217 }, /* #28/1 */
    { 0x0a48, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(1,0xfe7ed31200000000,16413), -2134862217 }, /* #28/2 */
    { 0x0e48, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(1,0xfe7ed31200000000,16413), -2134862217 }, /* #28/3 */
    { 0x0120, 0xdf6c, 0x7d00, RTFLOAT80U_INIT_C(1,0xa29af50800000000,16412), -682016066 }, /* #29/0 */
    { 0x0520, 0xdf6c, 0x7d00, RTFLOAT80U_INIT_C(1,0xa29af50800000000,16412), -682016066 }, /* #29/1 */
    { 0x0920, 0xdf6c, 0x7d00, RTFLOAT80U_INIT_C(1,0xa29af50800000000,16412), -682016066 }, /* #29/2 */
    { 0x0d20, 0xdf6c, 0x7d00, RTFLOAT80U_INIT_C(1,0xa29af50800000000,16412), -682016066 }, /* #29/3 */
    { 0x0062, 0xd2ce, 0x7800, RTFLOAT80U_INIT_C(0,0xbdfd1c0c00000000,16412), 796870403 }, /* #30/0 */
    { 0x0462, 0xd2ce, 0x7800, RTFLOAT80U_INIT_C(0,0xbdfd1c0c00000000,16412), 796870403 }, /* #30/1 */
    { 0x0862, 0xd2ce, 0x7800, RTFLOAT80U_INIT_C(0,0xbdfd1c0c00000000,16412), 796870403 }, /* #30/2 */
    { 0x0c62, 0xd2ce, 0x7800, RTFLOAT80U_INIT_C(0,0xbdfd1c0c00000000,16412), 796870403 }, /* #30/3 */
    { 0x0143, 0x9e64, 0x3c00, RTFLOAT80U_INIT_C(1,0xbb742b6800000000,16413), -1572476340 }, /* #31/0 */
    { 0x0543, 0x9e64, 0x3c00, RTFLOAT80U_INIT_C(1,0xbb742b6800000000,16413), -1572476340 }, /* #31/1 */
    { 0x0943, 0x9e64, 0x3c00, RTFLOAT80U_INIT_C(1,0xbb742b6800000000,16413), -1572476340 }, /* #31/2 */
    { 0x0d43, 0x9e64, 0x3c00, RTFLOAT80U_INIT_C(1,0xbb742b6800000000,16413), -1572476340 }, /* #31/3 */
    { 0x0254, 0x0e02, 0x3c00, RTFLOAT80U_INIT_C(1,0x8f92314400000000,16412), -602180689 }, /* #32/0 */
    { 0x0654, 0x0e02, 0x3c00, RTFLOAT80U_INIT_C(1,0x8f92314400000000,16412), -602180689 }, /* #32/1 */
    { 0x0a54, 0x0e02, 0x3c00, RTFLOAT80U_INIT_C(1,0x8f92314400000000,16412), -602180689 }, /* #32/2 */
    { 0x0e54, 0x0e02, 0x3c00, RTFLOAT80U_INIT_C(1,0x8f92314400000000,16412), -602180689 }, /* #32/3 */
    { 0x012e, 0x79b4, 0x7900, RTFLOAT80U_INIT_C(0,0x986fbd7600000000,16413), 1278729915 }, /* #33/0 */
    { 0x052e, 0x79b4, 0x7900, RTFLOAT80U_INIT_C(0,0x986fbd7600000000,16413), 1278729915 }, /* #33/1 */
    { 0x092e, 0x79b4, 0x7900, RTFLOAT80U_INIT_C(0,0x986fbd7600000000,16413), 1278729915 }, /* #33/2 */
    { 0x0d2e, 0x79b4, 0x7900, RTFLOAT80U_INIT_C(0,0x986fbd7600000000,16413), 1278729915 }, /* #33/3 */
    { 0x0253, 0xb427, 0x3c00, RTFLOAT80U_INIT_C(1,0x96022ca000000000,16411), -314590612 }, /* #34/0 */
    { 0x0653, 0xb427, 0x3c00, RTFLOAT80U_INIT_C(1,0x96022ca000000000,16411), -314590612 }, /* #34/1 */
    { 0x0a53, 0xb427, 0x3c00, RTFLOAT80U_INIT_C(1,0x96022ca000000000,16411), -314590612 }, /* #34/2 */
    { 0x0e53, 0xb427, 0x3c00, RTFLOAT80U_INIT_C(1,0x96022ca000000000,16411), -314590612 }, /* #34/3 */
    { 0x0143, 0x816f, 0x3900, RTFLOAT80U_INIT_C(1,0xb8d33b1800000000,16412), -775212742 }, /* #35/0 */
    { 0x0543, 0x816f, 0x3900, RTFLOAT80U_INIT_C(1,0xb8d33b1800000000,16412), -775212742 }, /* #35/1 */
    { 0x0943, 0x816f, 0x3900, RTFLOAT80U_INIT_C(1,0xb8d33b1800000000,16412), -775212742 }, /* #35/2 */
    { 0x0d43, 0x816f, 0x3900, RTFLOAT80U_INIT_C(1,0xb8d33b1800000000,16412), -775212742 }, /* #35/3 */
    { 0x0168, 0x5f39, 0x7d00, RTFLOAT80U_INIT_C(0,0xff57d6a600000000,16413), 2141973331 }, /* #36/0 */
    { 0x0568, 0x5f39, 0x7d00, RTFLOAT80U_INIT_C(0,0xff57d6a600000000,16413), 2141973331 }, /* #36/1 */
    { 0x0968, 0x5f39, 0x7d00, RTFLOAT80U_INIT_C(0,0xff57d6a600000000,16413), 2141973331 }, /* #36/2 */
    { 0x0d68, 0x5f39, 0x7d00, RTFLOAT80U_INIT_C(0,0xff57d6a600000000,16413), 2141973331 }, /* #36/3 */
    { 0x0004, 0xc7cf, 0x7d00, RTFLOAT80U_INIT_C(1,0xf20fa31200000000,16413), -2030555529 }, /* #37/0 */
    { 0x0404, 0xc7cf, 0x7d00, RTFLOAT80U_INIT_C(1,0xf20fa31200000000,16413), -2030555529 }, /* #37/1 */
    { 0x0804, 0xc7cf, 0x7d00, RTFLOAT80U_INIT_C(1,0xf20fa31200000000,16413), -2030555529 }, /* #37/2 */
    { 0x0c04, 0xc7cf, 0x7d00, RTFLOAT80U_INIT_C(1,0xf20fa31200000000,16413), -2030555529 }, /* #37/3 */
    { 0x005f, 0x873f, 0x3d00, RTFLOAT80U_INIT_C(1,0xdf3a45e800000000,16411), -468142269 }, /* #38/0 */
    { 0x045f, 0x873f, 0x3d00, RTFLOAT80U_INIT_C(1,0xdf3a45e800000000,16411), -468142269 }, /* #38/1 */
    { 0x085f, 0x873f, 0x3d00, RTFLOAT80U_INIT_C(1,0xdf3a45e800000000,16411), -468142269 }, /* #38/2 */
    { 0x0c5f, 0x873f, 0x3d00, RTFLOAT80U_INIT_C(1,0xdf3a45e800000000,16411), -468142269 }, /* #38/3 */
    { 0x0028, 0x33af, 0x3900, RTFLOAT80U_INIT_C(1,0xfe97c7e800000000,16411), -533919997 }, /* #39/0 */
    { 0x0428, 0x33af, 0x3900, RTFLOAT80U_INIT_C(1,0xfe97c7e800000000,16411), -533919997 }, /* #39/1 */
    { 0x0828, 0x33af, 0x3900, RTFLOAT80U_INIT_C(1,0xfe97c7e800000000,16411), -533919997 }, /* #39/2 */
    { 0x0c28, 0x33af, 0x3900, RTFLOAT80U_INIT_C(1,0xfe97c7e800000000,16411), -533919997 }, /* #39/3 */
    { 0x0323, 0x0dd7, 0x3d00, RTFLOAT80U_INIT_C(1,0xf5d1b7c000000000,16411), -515520248 }, /* #40/0 */
    { 0x0723, 0x0dd7, 0x3d00, RTFLOAT80U_INIT_C(1,0xf5d1b7c000000000,16411), -515520248 }, /* #40/1 */
    { 0x0b23, 0x0dd7, 0x3d00, RTFLOAT80U_INIT_C(1,0xf5d1b7c000000000,16411), -515520248 }, /* #40/2 */
    { 0x0f23, 0x0dd7, 0x3d00, RTFLOAT80U_INIT_C(1,0xf5d1b7c000000000,16411), -515520248 }, /* #40/3 */
    { 0x0005, 0xa659, 0x3c00, RTFLOAT80U_INIT_C(1,0xb28eb41800000000,16411), -374462083 }, /* #41/0 */
    { 0x0405, 0xa659, 0x3c00, RTFLOAT80U_INIT_C(1,0xb28eb41800000000,16411), -374462083 }, /* #41/1 */
    { 0x0805, 0xa659, 0x3c00, RTFLOAT80U_INIT_C(1,0xb28eb41800000000,16411), -374462083 }, /* #41/2 */
    { 0x0c05, 0xa659, 0x3c00, RTFLOAT80U_INIT_C(1,0xb28eb41800000000,16411), -374462083 }, /* #41/3 */
    { 0x006c, 0x0ce8, 0x3c00, RTFLOAT80U_INIT_C(0,0xa95c437800000000,16413), 1420698044 }, /* #42/0 */
    { 0x046c, 0x0ce8, 0x3c00, RTFLOAT80U_INIT_C(0,0xa95c437800000000,16413), 1420698044 }, /* #42/1 */
    { 0x086c, 0x0ce8, 0x3c00, RTFLOAT80U_INIT_C(0,0xa95c437800000000,16413), 1420698044 }, /* #42/2 */
    { 0x0c6c, 0x0ce8, 0x3c00, RTFLOAT80U_INIT_C(0,0xa95c437800000000,16413), 1420698044 }, /* #42/3 */
    { 0x0318, 0x81af, 0x3900, RTFLOAT80U_INIT_C(1,0x9f62c7a000000000,16412), -668512744 }, /* #43/0 */
    { 0x0718, 0x81af, 0x3900, RTFLOAT80U_INIT_C(1,0x9f62c7a000000000,16412), -668512744 }, /* #43/1 */
    { 0x0b18, 0x81af, 0x3900, RTFLOAT80U_INIT_C(1,0x9f62c7a000000000,16412), -668512744 }, /* #43/2 */
    { 0x0f18, 0x81af, 0x3900, RTFLOAT80U_INIT_C(1,0x9f62c7a000000000,16412), -668512744 }, /* #43/3 */
    { 0x035f, 0x2ed9, 0x3c00, RTFLOAT80U_INIT_C(1,0x85912d1800000000,16413), -1120441996 }, /* #44/0 */
    { 0x075f, 0x2ed9, 0x3c00, RTFLOAT80U_INIT_C(1,0x85912d1800000000,16413), -1120441996 }, /* #44/1 */
    { 0x0b5f, 0x2ed9, 0x3c00, RTFLOAT80U_INIT_C(1,0x85912d1800000000,16413), -1120441996 }, /* #44/2 */
    { 0x0f5f, 0x2ed9, 0x3c00, RTFLOAT80U_INIT_C(1,0x85912d1800000000,16413), -1120441996 }, /* #44/3 */
    { 0x0052, 0xe72f, 0x7d00, RTFLOAT80U_INIT_C(1,0xa581244000000000,16411), -347088008 }, /* #45/0 */
    { 0x0452, 0xe72f, 0x7d00, RTFLOAT80U_INIT_C(1,0xa581244000000000,16411), -347088008 }, /* #45/1 */
    { 0x0852, 0xe72f, 0x7d00, RTFLOAT80U_INIT_C(1,0xa581244000000000,16411), -347088008 }, /* #45/2 */
    { 0x0c52, 0xe72f, 0x7d00, RTFLOAT80U_INIT_C(1,0xa581244000000000,16411), -347088008 }, /* #45/3 */
    { 0x033b, 0xe5fd, 0x7d00, RTFLOAT80U_INIT_C(1,0xf018021400000000,16412), -1007026309 }, /* #46/0 */
    { 0x073b, 0xe5fd, 0x7d00, RTFLOAT80U_INIT_C(1,0xf018021400000000,16412), -1007026309 }, /* #46/1 */
    { 0x0b3b, 0xe5fd, 0x7d00, RTFLOAT80U_INIT_C(1,0xf018021400000000,16412), -1007026309 }, /* #46/2 */
    { 0x0f3b, 0xe5fd, 0x7d00, RTFLOAT80U_INIT_C(1,0xf018021400000000,16412), -1007026309 }, /* #46/3 */
    { 0x0366, 0xe324, 0x7900, RTFLOAT80U_INIT_C(1,0xbab3ba4c00000000,16413), -1566170406 }, /* #47/0 */
    { 0x0766, 0xe324, 0x7900, RTFLOAT80U_INIT_C(1,0xbab3ba4c00000000,16413), -1566170406 }, /* #47/1 */
    { 0x0b66, 0xe324, 0x7900, RTFLOAT80U_INIT_C(1,0xbab3ba4c00000000,16413), -1566170406 }, /* #47/2 */
    { 0x0f66, 0xe324, 0x7900, RTFLOAT80U_INIT_C(1,0xbab3ba4c00000000,16413), -1566170406 }, /* #47/3 */
    { 0x005d, 0x4413, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd59189000000000,16410), -232100233 }, /* #48/0 */
    { 0x045d, 0x4413, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd59189000000000,16410), -232100233 }, /* #48/1 */
    { 0x085d, 0x4413, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd59189000000000,16410), -232100233 }, /* #48/2 */
    { 0x0c5d, 0x4413, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd59189000000000,16410), -232100233 }, /* #48/3 */
    { 0x014a, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0xfb13ea4a00000000,16413), 2106193189 }, /* #49/0 */
    { 0x054a, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0xfb13ea4a00000000,16413), 2106193189 }, /* #49/1 */
    { 0x094a, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0xfb13ea4a00000000,16413), 2106193189 }, /* #49/2 */
    { 0x0d4a, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0xfb13ea4a00000000,16413), 2106193189 }, /* #49/3 */
    { 0x0349, 0x16d0, 0x3c00, RTFLOAT80U_INIT_C(1,0xa4b705f800000000,16413), -1381729020 }, /* #50/0 */
    { 0x0749, 0x16d0, 0x3c00, RTFLOAT80U_INIT_C(1,0xa4b705f800000000,16413), -1381729020 }, /* #50/1 */
    { 0x0b49, 0x16d0, 0x3c00, RTFLOAT80U_INIT_C(1,0xa4b705f800000000,16413), -1381729020 }, /* #50/2 */
    { 0x0f49, 0x16d0, 0x3c00, RTFLOAT80U_INIT_C(1,0xa4b705f800000000,16413), -1381729020 }, /* #50/3 */
    { 0x016f, 0x74d8, 0x7c00, RTFLOAT80U_INIT_C(1,0xd364dbf000000000,16413), -1773301240 }, /* #51/0 */
    { 0x056f, 0x74d8, 0x7c00, RTFLOAT80U_INIT_C(1,0xd364dbf000000000,16413), -1773301240 }, /* #51/1 */
    { 0x096f, 0x74d8, 0x7c00, RTFLOAT80U_INIT_C(1,0xd364dbf000000000,16413), -1773301240 }, /* #51/2 */
    { 0x0d6f, 0x74d8, 0x7c00, RTFLOAT80U_INIT_C(1,0xd364dbf000000000,16413), -1773301240 }, /* #51/3 */
    { 0x014a, 0x8706, 0x3d00, RTFLOAT80U_INIT_C(0,0xfdb4074000000000,16409), 133013562 }, /* #52/0 */
    { 0x054a, 0x8706, 0x3d00, RTFLOAT80U_INIT_C(0,0xfdb4074000000000,16409), 133013562 }, /* #52/1 */
    { 0x094a, 0x8706, 0x3d00, RTFLOAT80U_INIT_C(0,0xfdb4074000000000,16409), 133013562 }, /* #52/2 */
    { 0x0d4a, 0x8706, 0x3d00, RTFLOAT80U_INIT_C(0,0xfdb4074000000000,16409), 133013562 }, /* #52/3 */
    { 0x023b, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0x8d1f5c8800000000,16412), 591910690 }, /* #53/0 */
    { 0x063b, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0x8d1f5c8800000000,16412), 591910690 }, /* #53/1 */
    { 0x0a3b, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0x8d1f5c8800000000,16412), 591910690 }, /* #53/2 */
    { 0x0e3b, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0x8d1f5c8800000000,16412), 591910690 }, /* #53/3 */
    { 0x0231, 0x3067, 0x3800, RTFLOAT80U_INIT_C(1,0x8621332c00000000,16413), -1125161366 }, /* #54/0 */
    { 0x0631, 0x3067, 0x3800, RTFLOAT80U_INIT_C(1,0x8621332c00000000,16413), -1125161366 }, /* #54/1 */
    { 0x0a31, 0x3067, 0x3800, RTFLOAT80U_INIT_C(1,0x8621332c00000000,16413), -1125161366 }, /* #54/2 */
    { 0x0e31, 0x3067, 0x3800, RTFLOAT80U_INIT_C(1,0x8621332c00000000,16413), -1125161366 }, /* #54/3 */
    { 0x0223, 0xfd86, 0x7d00, RTFLOAT80U_INIT_C(0,0xcde51f4000000000,16413), 1727172512 }, /* #55/0 */
    { 0x0623, 0xfd86, 0x7d00, RTFLOAT80U_INIT_C(0,0xcde51f4000000000,16413), 1727172512 }, /* #55/1 */
    { 0x0a23, 0xfd86, 0x7d00, RTFLOAT80U_INIT_C(0,0xcde51f4000000000,16413), 1727172512 }, /* #55/2 */
    { 0x0e23, 0xfd86, 0x7d00, RTFLOAT80U_INIT_C(0,0xcde51f4000000000,16413), 1727172512 }, /* #55/3 */
    { 0x036d, 0x1746, 0x3d00, RTFLOAT80U_INIT_C(1,0xa62cb2a600000000,16413), -1393973587 }, /* #56/0 */
    { 0x076d, 0x1746, 0x3d00, RTFLOAT80U_INIT_C(1,0xa62cb2a600000000,16413), -1393973587 }, /* #56/1 */
    { 0x0b6d, 0x1746, 0x3d00, RTFLOAT80U_INIT_C(1,0xa62cb2a600000000,16413), -1393973587 }, /* #56/2 */
    { 0x0f6d, 0x1746, 0x3d00, RTFLOAT80U_INIT_C(1,0xa62cb2a600000000,16413), -1393973587 }, /* #56/3 */
    { 0x024a, 0x70f0, 0x7800, RTFLOAT80U_INIT_C(0,0x8463fa7c00000000,16412), 555286175 }, /* #57/0 */
    { 0x064a, 0x70f0, 0x7800, RTFLOAT80U_INIT_C(0,0x8463fa7c00000000,16412), 555286175 }, /* #57/1 */
    { 0x0a4a, 0x70f0, 0x7800, RTFLOAT80U_INIT_C(0,0x8463fa7c00000000,16412), 555286175 }, /* #57/2 */
    { 0x0e4a, 0x70f0, 0x7800, RTFLOAT80U_INIT_C(0,0x8463fa7c00000000,16412), 555286175 }, /* #57/3 */
    { 0x035f, 0xebae, 0x7900, RTFLOAT80U_INIT_C(1,0x9d3aecb800000000,16413), -1318942300 }, /* #58/0 */
    { 0x075f, 0xebae, 0x7900, RTFLOAT80U_INIT_C(1,0x9d3aecb800000000,16413), -1318942300 }, /* #58/1 */
    { 0x0b5f, 0xebae, 0x7900, RTFLOAT80U_INIT_C(1,0x9d3aecb800000000,16413), -1318942300 }, /* #58/2 */
    { 0x0f5f, 0xebae, 0x7900, RTFLOAT80U_INIT_C(1,0x9d3aecb800000000,16413), -1318942300 }, /* #58/3 */
    { 0x017b, 0x8d27, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b37348000000000,16411), 325510800 }, /* #59/0 */
    { 0x057b, 0x8d27, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b37348000000000,16411), 325510800 }, /* #59/1 */
    { 0x097b, 0x8d27, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b37348000000000,16411), 325510800 }, /* #59/2 */
    { 0x0d7b, 0x8d27, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b37348000000000,16411), 325510800 }, /* #59/3 */
    { 0x0266, 0xe528, 0x7d00, RTFLOAT80U_INIT_C(0,0xa9a25ad000000000,16411), 355748698 }, /* #60/0 */
    { 0x0666, 0xe528, 0x7d00, RTFLOAT80U_INIT_C(0,0xa9a25ad000000000,16411), 355748698 }, /* #60/1 */
    { 0x0a66, 0xe528, 0x7d00, RTFLOAT80U_INIT_C(0,0xa9a25ad000000000,16411), 355748698 }, /* #60/2 */
    { 0x0e66, 0xe528, 0x7d00, RTFLOAT80U_INIT_C(0,0xa9a25ad000000000,16411), 355748698 }, /* #60/3 */
    { 0x0022, 0x106c, 0x3800, RTFLOAT80U_INIT_C(1,0xd107105200000000,16413), -1753450537 }, /* #61/0 */
    { 0x0422, 0x106c, 0x3800, RTFLOAT80U_INIT_C(1,0xd107105200000000,16413), -1753450537 }, /* #61/1 */
    { 0x0822, 0x106c, 0x3800, RTFLOAT80U_INIT_C(1,0xd107105200000000,16413), -1753450537 }, /* #61/2 */
    { 0x0c22, 0x106c, 0x3800, RTFLOAT80U_INIT_C(1,0xd107105200000000,16413), -1753450537 }, /* #61/3 */
    { 0x017a, 0xdbb0, 0x7900, RTFLOAT80U_INIT_C(1,0xfa8d728000000000,16407), -32840421 }, /* #62/0 */
    { 0x057a, 0xdbb0, 0x7900, RTFLOAT80U_INIT_C(1,0xfa8d728000000000,16407), -32840421 }, /* #62/1 */
    { 0x097a, 0xdbb0, 0x7900, RTFLOAT80U_INIT_C(1,0xfa8d728000000000,16407), -32840421 }, /* #62/2 */
    { 0x0d7a, 0xdbb0, 0x7900, RTFLOAT80U_INIT_C(1,0xfa8d728000000000,16407), -32840421 }, /* #62/3 */
    { 0x033d, 0x5ece, 0x7c00, RTFLOAT80U_INIT_C(0,0x90881d0200000000,16413), 1212419713 }, /* #63/0 */
    { 0x073d, 0x5ece, 0x7c00, RTFLOAT80U_INIT_C(0,0x90881d0200000000,16413), 1212419713 }, /* #63/1 */
    { 0x0b3d, 0x5ece, 0x7c00, RTFLOAT80U_INIT_C(0,0x90881d0200000000,16413), 1212419713 }, /* #63/2 */
    { 0x0f3d, 0x5ece, 0x7c00, RTFLOAT80U_INIT_C(0,0x90881d0200000000,16413), 1212419713 }, /* #63/3 */
    { 0x0371, 0xa528, 0x3d00, RTFLOAT80U_INIT_C(1,0xc436530400000000,16412), -822973633 }, /* #64/0 */
    { 0x0771, 0xa528, 0x3d00, RTFLOAT80U_INIT_C(1,0xc436530400000000,16412), -822973633 }, /* #64/1 */
    { 0x0b71, 0xa528, 0x3d00, RTFLOAT80U_INIT_C(1,0xc436530400000000,16412), -822973633 }, /* #64/2 */
    { 0x0f71, 0xa528, 0x3d00, RTFLOAT80U_INIT_C(1,0xc436530400000000,16412), -822973633 }, /* #64/3 */
    { 0x0043, 0x9d8f, 0x3d00, RTFLOAT80U_INIT_C(1,0xa0abd99000000000,16412), -673904228 }, /* #65/0 */
    { 0x0443, 0x9d8f, 0x3d00, RTFLOAT80U_INIT_C(1,0xa0abd99000000000,16412), -673904228 }, /* #65/1 */
    { 0x0843, 0x9d8f, 0x3d00, RTFLOAT80U_INIT_C(1,0xa0abd99000000000,16412), -673904228 }, /* #65/2 */
    { 0x0c43, 0x9d8f, 0x3d00, RTFLOAT80U_INIT_C(1,0xa0abd99000000000,16412), -673904228 }, /* #65/3 */
    { 0x023e, 0xa01e, 0x3800, RTFLOAT80U_INIT_C(1,0x9083e83600000000,16413), -1212281883 }, /* #66/0 */
    { 0x063e, 0xa01e, 0x3800, RTFLOAT80U_INIT_C(1,0x9083e83600000000,16413), -1212281883 }, /* #66/1 */
    { 0x0a3e, 0xa01e, 0x3800, RTFLOAT80U_INIT_C(1,0x9083e83600000000,16413), -1212281883 }, /* #66/2 */
    { 0x0e3e, 0xa01e, 0x3800, RTFLOAT80U_INIT_C(1,0x9083e83600000000,16413), -1212281883 }, /* #66/3 */
    { 0x0106, 0xcf40, 0x7d00, RTFLOAT80U_INIT_C(0,0x8e80b12000000000,16411), 298849828 }, /* #67/0 */
    { 0x0506, 0xcf40, 0x7d00, RTFLOAT80U_INIT_C(0,0x8e80b12000000000,16411), 298849828 }, /* #67/1 */
    { 0x0906, 0xcf40, 0x7d00, RTFLOAT80U_INIT_C(0,0x8e80b12000000000,16411), 298849828 }, /* #67/2 */
    { 0x0d06, 0xcf40, 0x7d00, RTFLOAT80U_INIT_C(0,0x8e80b12000000000,16411), 298849828 }, /* #67/3 */
    { 0x023e, 0x6d8b, 0x7d00, RTFLOAT80U_INIT_C(1,0x99ede2f800000000,16413), -1291252092 }, /* #68/0 */
    { 0x063e, 0x6d8b, 0x7d00, RTFLOAT80U_INIT_C(1,0x99ede2f800000000,16413), -1291252092 }, /* #68/1 */
    { 0x0a3e, 0x6d8b, 0x7d00, RTFLOAT80U_INIT_C(1,0x99ede2f800000000,16413), -1291252092 }, /* #68/2 */
    { 0x0e3e, 0x6d8b, 0x7d00, RTFLOAT80U_INIT_C(1,0x99ede2f800000000,16413), -1291252092 }, /* #68/3 */
    { 0x0075, 0x3681, 0x3c00, RTFLOAT80U_INIT_C(1,0xdea3974000000000,16408), -58363485 }, /* #69/0 */
    { 0x0475, 0x3681, 0x3c00, RTFLOAT80U_INIT_C(1,0xdea3974000000000,16408), -58363485 }, /* #69/1 */
    { 0x0875, 0x3681, 0x3c00, RTFLOAT80U_INIT_C(1,0xdea3974000000000,16408), -58363485 }, /* #69/2 */
    { 0x0c75, 0x3681, 0x3c00, RTFLOAT80U_INIT_C(1,0xdea3974000000000,16408), -58363485 }, /* #69/3 */
    { 0x0357, 0x464e, 0x7c00, RTFLOAT80U_INIT_C(0,0xcbb6e30000000000,16408), 53402508 }, /* #70/0 */
    { 0x0757, 0x464e, 0x7c00, RTFLOAT80U_INIT_C(0,0xcbb6e30000000000,16408), 53402508 }, /* #70/1 */
    { 0x0b57, 0x464e, 0x7c00, RTFLOAT80U_INIT_C(0,0xcbb6e30000000000,16408), 53402508 }, /* #70/2 */
    { 0x0f57, 0x464e, 0x7c00, RTFLOAT80U_INIT_C(0,0xcbb6e30000000000,16408), 53402508 }, /* #70/3 */
    { 0x012a, 0x3286, 0x3800, RTFLOAT80U_INIT_C(0,0xdeedf00400000000,16413), 1870067714 }, /* #71/0 */
    { 0x052a, 0x3286, 0x3800, RTFLOAT80U_INIT_C(0,0xdeedf00400000000,16413), 1870067714 }, /* #71/1 */
    { 0x092a, 0x3286, 0x3800, RTFLOAT80U_INIT_C(0,0xdeedf00400000000,16413), 1870067714 }, /* #71/2 */
    { 0x0d2a, 0x3286, 0x3800, RTFLOAT80U_INIT_C(0,0xdeedf00400000000,16413), 1870067714 }, /* #71/3 */
    { 0x0210, 0x90cd, 0x3800, RTFLOAT80U_INIT_C(0,0xf1db887200000000,16413), 2028848185 }, /* #72/0 */
    { 0x0610, 0x90cd, 0x3800, RTFLOAT80U_INIT_C(0,0xf1db887200000000,16413), 2028848185 }, /* #72/1 */
    { 0x0a10, 0x90cd, 0x3800, RTFLOAT80U_INIT_C(0,0xf1db887200000000,16413), 2028848185 }, /* #72/2 */
    { 0x0e10, 0x90cd, 0x3800, RTFLOAT80U_INIT_C(0,0xf1db887200000000,16413), 2028848185 }, /* #72/3 */
    { 0x022b, 0xd10f, 0x7900, RTFLOAT80U_INIT_C(1,0x903afac000000000,16410), -151236524 }, /* #73/0 */
    { 0x062b, 0xd10f, 0x7900, RTFLOAT80U_INIT_C(1,0x903afac000000000,16410), -151236524 }, /* #73/1 */
    { 0x0a2b, 0xd10f, 0x7900, RTFLOAT80U_INIT_C(1,0x903afac000000000,16410), -151236524 }, /* #73/2 */
    { 0x0e2b, 0xd10f, 0x7900, RTFLOAT80U_INIT_C(1,0x903afac000000000,16410), -151236524 }, /* #73/3 */
    { 0x0329, 0x232f, 0x3900, RTFLOAT80U_INIT_C(1,0xa317282000000000,16409), -85506369 }, /* #74/0 */
    { 0x0729, 0x232f, 0x3900, RTFLOAT80U_INIT_C(1,0xa317282000000000,16409), -85506369 }, /* #74/1 */
    { 0x0b29, 0x232f, 0x3900, RTFLOAT80U_INIT_C(1,0xa317282000000000,16409), -85506369 }, /* #74/2 */
    { 0x0f29, 0x232f, 0x3900, RTFLOAT80U_INIT_C(1,0xa317282000000000,16409), -85506369 }, /* #74/3 */
    { 0x017c, 0x7b3d, 0x7900, RTFLOAT80U_INIT_C(0,0xa2a1598c00000000,16413), 1364241606 }, /* #75/0 */
    { 0x057c, 0x7b3d, 0x7900, RTFLOAT80U_INIT_C(0,0xa2a1598c00000000,16413), 1364241606 }, /* #75/1 */
    { 0x097c, 0x7b3d, 0x7900, RTFLOAT80U_INIT_C(0,0xa2a1598c00000000,16413), 1364241606 }, /* #75/2 */
    { 0x0d7c, 0x7b3d, 0x7900, RTFLOAT80U_INIT_C(0,0xa2a1598c00000000,16413), 1364241606 }, /* #75/3 */
    { 0x016d, 0xa07e, 0x3800, RTFLOAT80U_INIT_C(1,0xf92f428800000000,16413), -2090312004 }, /* #76/0 */
    { 0x056d, 0xa07e, 0x3800, RTFLOAT80U_INIT_C(1,0xf92f428800000000,16413), -2090312004 }, /* #76/1 */
    { 0x096d, 0xa07e, 0x3800, RTFLOAT80U_INIT_C(1,0xf92f428800000000,16413), -2090312004 }, /* #76/2 */
    { 0x0d6d, 0xa07e, 0x3800, RTFLOAT80U_INIT_C(1,0xf92f428800000000,16413), -2090312004 }, /* #76/3 */
    { 0x0306, 0xd6bb, 0x7c00, RTFLOAT80U_INIT_C(0,0xc19f531a00000000,16413), 1624222093 }, /* #77/0 */
    { 0x0706, 0xd6bb, 0x7c00, RTFLOAT80U_INIT_C(0,0xc19f531a00000000,16413), 1624222093 }, /* #77/1 */
    { 0x0b06, 0xd6bb, 0x7c00, RTFLOAT80U_INIT_C(0,0xc19f531a00000000,16413), 1624222093 }, /* #77/2 */
    { 0x0f06, 0xd6bb, 0x7c00, RTFLOAT80U_INIT_C(0,0xc19f531a00000000,16413), 1624222093 }, /* #77/3 */
    { 0x030b, 0x6079, 0x7800, RTFLOAT80U_INIT_C(0,0xd1b7d0a000000000,16412), 879621160 }, /* #78/0 */
    { 0x070b, 0x6079, 0x7800, RTFLOAT80U_INIT_C(0,0xd1b7d0a000000000,16412), 879621160 }, /* #78/1 */
    { 0x0b0b, 0x6079, 0x7800, RTFLOAT80U_INIT_C(0,0xd1b7d0a000000000,16412), 879621160 }, /* #78/2 */
    { 0x0f0b, 0x6079, 0x7800, RTFLOAT80U_INIT_C(0,0xd1b7d0a000000000,16412), 879621160 }, /* #78/3 */
    { 0x0335, 0x1b25, 0x3900, RTFLOAT80U_INIT_C(1,0xbeed1c6200000000,16413), -1601605169 }, /* #79/0 */
    { 0x0735, 0x1b25, 0x3900, RTFLOAT80U_INIT_C(1,0xbeed1c6200000000,16413), -1601605169 }, /* #79/1 */
    { 0x0b35, 0x1b25, 0x3900, RTFLOAT80U_INIT_C(1,0xbeed1c6200000000,16413), -1601605169 }, /* #79/2 */
    { 0x0f35, 0x1b25, 0x3900, RTFLOAT80U_INIT_C(1,0xbeed1c6200000000,16413), -1601605169 }, /* #79/3 */
    { 0x0377, 0x9386, 0x3900, RTFLOAT80U_INIT_C(0,0x994ab95c00000000,16412), 642952791 }, /* #80/0 */
    { 0x0777, 0x9386, 0x3900, RTFLOAT80U_INIT_C(0,0x994ab95c00000000,16412), 642952791 }, /* #80/1 */
    { 0x0b77, 0x9386, 0x3900, RTFLOAT80U_INIT_C(0,0x994ab95c00000000,16412), 642952791 }, /* #80/2 */
    { 0x0f77, 0x9386, 0x3900, RTFLOAT80U_INIT_C(0,0x994ab95c00000000,16412), 642952791 }, /* #80/3 */
    { 0x035e, 0x0945, 0x3900, RTFLOAT80U_INIT_C(1,0xac4de01e00000000,16413), -1445392399 }, /* #81/0 */
    { 0x075e, 0x0945, 0x3900, RTFLOAT80U_INIT_C(1,0xac4de01e00000000,16413), -1445392399 }, /* #81/1 */
    { 0x0b5e, 0x0945, 0x3900, RTFLOAT80U_INIT_C(1,0xac4de01e00000000,16413), -1445392399 }, /* #81/2 */
    { 0x0f5e, 0x0945, 0x3900, RTFLOAT80U_INIT_C(1,0xac4de01e00000000,16413), -1445392399 }, /* #81/3 */
    { 0x014c, 0x2ad7, 0x3800, RTFLOAT80U_INIT_C(1,0x9f629e4800000000,16412), -668510098 }, /* #82/0 */
    { 0x054c, 0x2ad7, 0x3800, RTFLOAT80U_INIT_C(1,0x9f629e4800000000,16412), -668510098 }, /* #82/1 */
    { 0x094c, 0x2ad7, 0x3800, RTFLOAT80U_INIT_C(1,0x9f629e4800000000,16412), -668510098 }, /* #82/2 */
    { 0x0d4c, 0x2ad7, 0x3800, RTFLOAT80U_INIT_C(1,0x9f629e4800000000,16412), -668510098 }, /* #82/3 */
    { 0x0336, 0x4564, 0x7d00, RTFLOAT80U_INIT_C(0,0x9913f3a000000000,16413), 1284110800 }, /* #83/0 */
    { 0x0736, 0x4564, 0x7d00, RTFLOAT80U_INIT_C(0,0x9913f3a000000000,16413), 1284110800 }, /* #83/1 */
    { 0x0b36, 0x4564, 0x7d00, RTFLOAT80U_INIT_C(0,0x9913f3a000000000,16413), 1284110800 }, /* #83/2 */
    { 0x0f36, 0x4564, 0x7d00, RTFLOAT80U_INIT_C(0,0x9913f3a000000000,16413), 1284110800 }, /* #83/3 */
    { 0x0032, 0xd2ff, 0x7800, RTFLOAT80U_INIT_C(1,0xf2da32b200000000,16413), -2037193049 }, /* #84/0 */
    { 0x0432, 0xd2ff, 0x7800, RTFLOAT80U_INIT_C(1,0xf2da32b200000000,16413), -2037193049 }, /* #84/1 */
    { 0x0832, 0xd2ff, 0x7800, RTFLOAT80U_INIT_C(1,0xf2da32b200000000,16413), -2037193049 }, /* #84/2 */
    { 0x0c32, 0xd2ff, 0x7800, RTFLOAT80U_INIT_C(1,0xf2da32b200000000,16413), -2037193049 }, /* #84/3 */
    { 0x015c, 0x51dc, 0x7900, RTFLOAT80U_INIT_C(0,0xb4d2a94a00000000,16413), 1516852389 }, /* #85/0 */
    { 0x055c, 0x51dc, 0x7900, RTFLOAT80U_INIT_C(0,0xb4d2a94a00000000,16413), 1516852389 }, /* #85/1 */
    { 0x095c, 0x51dc, 0x7900, RTFLOAT80U_INIT_C(0,0xb4d2a94a00000000,16413), 1516852389 }, /* #85/2 */
    { 0x0d5c, 0x51dc, 0x7900, RTFLOAT80U_INIT_C(0,0xb4d2a94a00000000,16413), 1516852389 }, /* #85/3 */
    { 0x0000, 0x5213, 0x7800, RTFLOAT80U_INIT_C(0,0xcbc4f1f400000000,16413), 1709340922 }, /* #86/0 */
    { 0x0400, 0x5213, 0x7800, RTFLOAT80U_INIT_C(0,0xcbc4f1f400000000,16413), 1709340922 }, /* #86/1 */
    { 0x0800, 0x5213, 0x7800, RTFLOAT80U_INIT_C(0,0xcbc4f1f400000000,16413), 1709340922 }, /* #86/2 */
    { 0x0c00, 0x5213, 0x7800, RTFLOAT80U_INIT_C(0,0xcbc4f1f400000000,16413), 1709340922 }, /* #86/3 */
    { 0x0010, 0xf960, 0x7900, RTFLOAT80U_INIT_C(0,0xb40e0c8000000000,16408), 47200306 }, /* #87/0 */
    { 0x0410, 0xf960, 0x7900, RTFLOAT80U_INIT_C(0,0xb40e0c8000000000,16408), 47200306 }, /* #87/1 */
    { 0x0810, 0xf960, 0x7900, RTFLOAT80U_INIT_C(0,0xb40e0c8000000000,16408), 47200306 }, /* #87/2 */
    { 0x0c10, 0xf960, 0x7900, RTFLOAT80U_INIT_C(0,0xb40e0c8000000000,16408), 47200306 }, /* #87/3 */
    { 0x0023, 0x08d9, 0x3800, RTFLOAT80U_INIT_C(1,0x973f9dbc00000000,16412), -634382191 }, /* #88/0 */
    { 0x0423, 0x08d9, 0x3800, RTFLOAT80U_INIT_C(1,0x973f9dbc00000000,16412), -634382191 }, /* #88/1 */
    { 0x0823, 0x08d9, 0x3800, RTFLOAT80U_INIT_C(1,0x973f9dbc00000000,16412), -634382191 }, /* #88/2 */
    { 0x0c23, 0x08d9, 0x3800, RTFLOAT80U_INIT_C(1,0x973f9dbc00000000,16412), -634382191 }, /* #88/3 */
    { 0x017e, 0x69a5, 0x7900, RTFLOAT80U_INIT_C(0,0xa1c06a3800000000,16412), 678435470 }, /* #89/0 */
    { 0x057e, 0x69a5, 0x7900, RTFLOAT80U_INIT_C(0,0xa1c06a3800000000,16412), 678435470 }, /* #89/1 */
    { 0x097e, 0x69a5, 0x7900, RTFLOAT80U_INIT_C(0,0xa1c06a3800000000,16412), 678435470 }, /* #89/2 */
    { 0x0d7e, 0x69a5, 0x7900, RTFLOAT80U_INIT_C(0,0xa1c06a3800000000,16412), 678435470 }, /* #89/3 */
    { 0x034c, 0xabbe, 0x3900, RTFLOAT80U_INIT_C(0,0xb7b7eaa000000000,16411), 385285460 }, /* #90/0 */
    { 0x074c, 0xabbe, 0x3900, RTFLOAT80U_INIT_C(0,0xb7b7eaa000000000,16411), 385285460 }, /* #90/1 */
    { 0x0b4c, 0xabbe, 0x3900, RTFLOAT80U_INIT_C(0,0xb7b7eaa000000000,16411), 385285460 }, /* #90/2 */
    { 0x0f4c, 0xabbe, 0x3900, RTFLOAT80U_INIT_C(0,0xb7b7eaa000000000,16411), 385285460 }, /* #90/3 */
    { 0x0058, 0x18c9, 0x3800, RTFLOAT80U_INIT_C(1,0xc3fa340000000000,16409), -102748576 }, /* #91/0 */
    { 0x0458, 0x18c9, 0x3800, RTFLOAT80U_INIT_C(1,0xc3fa340000000000,16409), -102748576 }, /* #91/1 */
    { 0x0858, 0x18c9, 0x3800, RTFLOAT80U_INIT_C(1,0xc3fa340000000000,16409), -102748576 }, /* #91/2 */
    { 0x0c58, 0x18c9, 0x3800, RTFLOAT80U_INIT_C(1,0xc3fa340000000000,16409), -102748576 }, /* #91/3 */
    { 0x0128, 0xfe5b, 0x7c00, RTFLOAT80U_INIT_C(1,0xda74e90600000000,16413), -1832547459 }, /* #92/0 */
    { 0x0528, 0xfe5b, 0x7c00, RTFLOAT80U_INIT_C(1,0xda74e90600000000,16413), -1832547459 }, /* #92/1 */
    { 0x0928, 0xfe5b, 0x7c00, RTFLOAT80U_INIT_C(1,0xda74e90600000000,16413), -1832547459 }, /* #92/2 */
    { 0x0d28, 0xfe5b, 0x7c00, RTFLOAT80U_INIT_C(1,0xda74e90600000000,16413), -1832547459 }, /* #92/3 */
    { 0x001e, 0x6007, 0x7800, RTFLOAT80U_INIT_C(1,0xdf58528000000000,16407), -29274277 }, /* #93/0 */
    { 0x041e, 0x6007, 0x7800, RTFLOAT80U_INIT_C(1,0xdf58528000000000,16407), -29274277 }, /* #93/1 */
    { 0x081e, 0x6007, 0x7800, RTFLOAT80U_INIT_C(1,0xdf58528000000000,16407), -29274277 }, /* #93/2 */
    { 0x0c1e, 0x6007, 0x7800, RTFLOAT80U_INIT_C(1,0xdf58528000000000,16407), -29274277 }, /* #93/3 */
    { 0x0162, 0x11fa, 0x3900, RTFLOAT80U_INIT_C(1,0x8303ff3000000000,16411), -274759654 }, /* #94/0 */
    { 0x0562, 0x11fa, 0x3900, RTFLOAT80U_INIT_C(1,0x8303ff3000000000,16411), -274759654 }, /* #94/1 */
    { 0x0962, 0x11fa, 0x3900, RTFLOAT80U_INIT_C(1,0x8303ff3000000000,16411), -274759654 }, /* #94/2 */
    { 0x0d62, 0x11fa, 0x3900, RTFLOAT80U_INIT_C(1,0x8303ff3000000000,16411), -274759654 }, /* #94/3 */
    { 0x0033, 0xd472, 0x7c00, RTFLOAT80U_INIT_C(0,0xae3793b000000000,16411), 365359734 }, /* #95/0 */
    { 0x0433, 0xd472, 0x7c00, RTFLOAT80U_INIT_C(0,0xae3793b000000000,16411), 365359734 }, /* #95/1 */
    { 0x0833, 0xd472, 0x7c00, RTFLOAT80U_INIT_C(0,0xae3793b000000000,16411), 365359734 }, /* #95/2 */
    { 0x0c33, 0xd472, 0x7c00, RTFLOAT80U_INIT_C(0,0xae3793b000000000,16411), 365359734 }, /* #95/3 */
};
uint32_t const g_cTests_fild_r80_from_i32 = RT_ELEMENTS(g_aTests_fild_r80_from_i32);

FPU_I16_IN_TEST_T const g_aTests_fild_r80_from_i16[] =
{
    { 0x030d, 0x31d7, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #0/0 */
    { 0x070d, 0x31d7, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #0/1 */
    { 0x0b0d, 0x31d7, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #0/2 */
    { 0x0f0d, 0x31d7, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #0/3 */
    { 0x0306, 0x206a, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #1/0 */
    { 0x0706, 0x206a, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #1/1 */
    { 0x0b06, 0x206a, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #1/2 */
    { 0x0f06, 0x206a, 0x3800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #1/3 */
    { 0x0063, 0x6afe, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #2/0 */
    { 0x0463, 0x6afe, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #2/1 */
    { 0x0863, 0x6afe, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #2/2 */
    { 0x0c63, 0x6afe, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #2/3 */
    { 0x015a, 0xa15f, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #3/0 */
    { 0x055a, 0xa15f, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #3/1 */
    { 0x095a, 0xa15f, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #3/2 */
    { 0x0d5a, 0xa15f, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #3/3 */
    { 0x0135, 0xf560, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #4/0 */
    { 0x0535, 0xf560, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #4/1 */
    { 0x0935, 0xf560, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #4/2 */
    { 0x0d35, 0xf560, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #4/3 */
    { 0x014e, 0x781b, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #5/0 */
    { 0x054e, 0x781b, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #5/1 */
    { 0x094e, 0x781b, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #5/2 */
    { 0x0d4e, 0x781b, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #5/3 */
    { 0x0072, 0xe6cf, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #6/0 */
    { 0x0472, 0xe6cf, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #6/1 */
    { 0x0872, 0xe6cf, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #6/2 */
    { 0x0c72, 0xe6cf, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #6/3 */
    { 0x036d, 0xf353, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #7/0 */
    { 0x076d, 0xf353, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #7/1 */
    { 0x0b6d, 0xf353, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #7/2 */
    { 0x0f6d, 0xf353, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #7/3 */
    { 0x0242, 0x19d8, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #8/0 */
    { 0x0642, 0x19d8, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #8/1 */
    { 0x0a42, 0x19d8, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #8/2 */
    { 0x0e42, 0x19d8, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #8/3 */
    { 0x035c, 0x426e, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #9/0 */
    { 0x075c, 0x426e, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #9/1 */
    { 0x0b5c, 0x426e, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #9/2 */
    { 0x0f5c, 0x426e, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #9/3 */
    { 0x0029, 0x3488, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #10/0 */
    { 0x0429, 0x3488, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #10/1 */
    { 0x0829, 0x3488, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #10/2 */
    { 0x0c29, 0x3488, 0x3c00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #10/3 */
    { 0x0336, 0xdfc9, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #11/0 */
    { 0x0736, 0xdfc9, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #11/1 */
    { 0x0b36, 0xdfc9, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #11/2 */
    { 0x0f36, 0xdfc9, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), 0 }, /* #11/3 */
    { 0x002a, 0x6400, 0x7c00, RTFLOAT80U_INIT_C(1,0x9a70000000000000,16395), -4942 }, /* #12/0 */
    { 0x042a, 0x6400, 0x7c00, RTFLOAT80U_INIT_C(1,0x9a70000000000000,16395), -4942 }, /* #12/1 */
    { 0x082a, 0x6400, 0x7c00, RTFLOAT80U_INIT_C(1,0x9a70000000000000,16395), -4942 }, /* #12/2 */
    { 0x0c2a, 0x6400, 0x7c00, RTFLOAT80U_INIT_C(1,0x9a70000000000000,16395), -4942 }, /* #12/3 */
    { 0x0218, 0xeb86, 0x7900, RTFLOAT80U_INIT_C(0,0xce56000000000000,16397), 26411 }, /* #13/0 */
    { 0x0618, 0xeb86, 0x7900, RTFLOAT80U_INIT_C(0,0xce56000000000000,16397), 26411 }, /* #13/1 */
    { 0x0a18, 0xeb86, 0x7900, RTFLOAT80U_INIT_C(0,0xce56000000000000,16397), 26411 }, /* #13/2 */
    { 0x0e18, 0xeb86, 0x7900, RTFLOAT80U_INIT_C(0,0xce56000000000000,16397), 26411 }, /* #13/3 */
    { 0x0175, 0x72bf, 0x7800, RTFLOAT80U_INIT_C(0,0xf290000000000000,16394), 3881 }, /* #14/0 */
    { 0x0575, 0x72bf, 0x7800, RTFLOAT80U_INIT_C(0,0xf290000000000000,16394), 3881 }, /* #14/1 */
    { 0x0975, 0x72bf, 0x7800, RTFLOAT80U_INIT_C(0,0xf290000000000000,16394), 3881 }, /* #14/2 */
    { 0x0d75, 0x72bf, 0x7800, RTFLOAT80U_INIT_C(0,0xf290000000000000,16394), 3881 }, /* #14/3 */
    { 0x0275, 0xa143, 0x3900, RTFLOAT80U_INIT_C(0,0xfb20000000000000,16393), 2009 }, /* #15/0 */
    { 0x0675, 0xa143, 0x3900, RTFLOAT80U_INIT_C(0,0xfb20000000000000,16393), 2009 }, /* #15/1 */
    { 0x0a75, 0xa143, 0x3900, RTFLOAT80U_INIT_C(0,0xfb20000000000000,16393), 2009 }, /* #15/2 */
    { 0x0e75, 0xa143, 0x3900, RTFLOAT80U_INIT_C(0,0xfb20000000000000,16393), 2009 }, /* #15/3 */
    { 0x0233, 0x600a, 0x7800, RTFLOAT80U_INIT_C(1,0xb914000000000000,16396), -11845 }, /* #16/0 */
    { 0x0633, 0x600a, 0x7800, RTFLOAT80U_INIT_C(1,0xb914000000000000,16396), -11845 }, /* #16/1 */
    { 0x0a33, 0x600a, 0x7800, RTFLOAT80U_INIT_C(1,0xb914000000000000,16396), -11845 }, /* #16/2 */
    { 0x0e33, 0x600a, 0x7800, RTFLOAT80U_INIT_C(1,0xb914000000000000,16396), -11845 }, /* #16/3 */
    { 0x0315, 0x84b2, 0x3c00, RTFLOAT80U_INIT_C(1,0xb230000000000000,16394), -2851 }, /* #17/0 */
    { 0x0715, 0x84b2, 0x3c00, RTFLOAT80U_INIT_C(1,0xb230000000000000,16394), -2851 }, /* #17/1 */
    { 0x0b15, 0x84b2, 0x3c00, RTFLOAT80U_INIT_C(1,0xb230000000000000,16394), -2851 }, /* #17/2 */
    { 0x0f15, 0x84b2, 0x3c00, RTFLOAT80U_INIT_C(1,0xb230000000000000,16394), -2851 }, /* #17/3 */
    { 0x0233, 0x2754, 0x3d00, RTFLOAT80U_INIT_C(0,0xa1d4000000000000,16396), 10357 }, /* #18/0 */
    { 0x0633, 0x2754, 0x3d00, RTFLOAT80U_INIT_C(0,0xa1d4000000000000,16396), 10357 }, /* #18/1 */
    { 0x0a33, 0x2754, 0x3d00, RTFLOAT80U_INIT_C(0,0xa1d4000000000000,16396), 10357 }, /* #18/2 */
    { 0x0e33, 0x2754, 0x3d00, RTFLOAT80U_INIT_C(0,0xa1d4000000000000,16396), 10357 }, /* #18/3 */
    { 0x036c, 0x8912, 0x3900, RTFLOAT80U_INIT_C(0,0xe200000000000000,16396), 14464 }, /* #19/0 */
    { 0x076c, 0x8912, 0x3900, RTFLOAT80U_INIT_C(0,0xe200000000000000,16396), 14464 }, /* #19/1 */
    { 0x0b6c, 0x8912, 0x3900, RTFLOAT80U_INIT_C(0,0xe200000000000000,16396), 14464 }, /* #19/2 */
    { 0x0f6c, 0x8912, 0x3900, RTFLOAT80U_INIT_C(0,0xe200000000000000,16396), 14464 }, /* #19/3 */
    { 0x0263, 0x7f12, 0x7d00, RTFLOAT80U_INIT_C(1,0xaf40000000000000,16395), -5608 }, /* #20/0 */
    { 0x0663, 0x7f12, 0x7d00, RTFLOAT80U_INIT_C(1,0xaf40000000000000,16395), -5608 }, /* #20/1 */
    { 0x0a63, 0x7f12, 0x7d00, RTFLOAT80U_INIT_C(1,0xaf40000000000000,16395), -5608 }, /* #20/2 */
    { 0x0e63, 0x7f12, 0x7d00, RTFLOAT80U_INIT_C(1,0xaf40000000000000,16395), -5608 }, /* #20/3 */
    { 0x0274, 0xc838, 0x7800, RTFLOAT80U_INIT_C(0,0xfe00000000000000,16394), 4064 }, /* #21/0 */
    { 0x0674, 0xc838, 0x7800, RTFLOAT80U_INIT_C(0,0xfe00000000000000,16394), 4064 }, /* #21/1 */
    { 0x0a74, 0xc838, 0x7800, RTFLOAT80U_INIT_C(0,0xfe00000000000000,16394), 4064 }, /* #21/2 */
    { 0x0e74, 0xc838, 0x7800, RTFLOAT80U_INIT_C(0,0xfe00000000000000,16394), 4064 }, /* #21/3 */
    { 0x0037, 0x5558, 0x7d00, RTFLOAT80U_INIT_C(1,0x80f8000000000000,16395), -4127 }, /* #22/0 */
    { 0x0437, 0x5558, 0x7d00, RTFLOAT80U_INIT_C(1,0x80f8000000000000,16395), -4127 }, /* #22/1 */
    { 0x0837, 0x5558, 0x7d00, RTFLOAT80U_INIT_C(1,0x80f8000000000000,16395), -4127 }, /* #22/2 */
    { 0x0c37, 0x5558, 0x7d00, RTFLOAT80U_INIT_C(1,0x80f8000000000000,16395), -4127 }, /* #22/3 */
    { 0x0258, 0x9587, 0x3d00, RTFLOAT80U_INIT_C(1,0xe6f4000000000000,16396), -14781 }, /* #23/0 */
    { 0x0658, 0x9587, 0x3d00, RTFLOAT80U_INIT_C(1,0xe6f4000000000000,16396), -14781 }, /* #23/1 */
    { 0x0a58, 0x9587, 0x3d00, RTFLOAT80U_INIT_C(1,0xe6f4000000000000,16396), -14781 }, /* #23/2 */
    { 0x0e58, 0x9587, 0x3d00, RTFLOAT80U_INIT_C(1,0xe6f4000000000000,16396), -14781 }, /* #23/3 */
    { 0x0139, 0xe9c3, 0x7900, RTFLOAT80U_INIT_C(0,0x8eaa000000000000,16397), 18261 }, /* #24/0 */
    { 0x0539, 0xe9c3, 0x7900, RTFLOAT80U_INIT_C(0,0x8eaa000000000000,16397), 18261 }, /* #24/1 */
    { 0x0939, 0xe9c3, 0x7900, RTFLOAT80U_INIT_C(0,0x8eaa000000000000,16397), 18261 }, /* #24/2 */
    { 0x0d39, 0xe9c3, 0x7900, RTFLOAT80U_INIT_C(0,0x8eaa000000000000,16397), 18261 }, /* #24/3 */
    { 0x0052, 0x68e1, 0x7800, RTFLOAT80U_INIT_C(1,0xc4cc000000000000,16397), -25190 }, /* #25/0 */
    { 0x0452, 0x68e1, 0x7800, RTFLOAT80U_INIT_C(1,0xc4cc000000000000,16397), -25190 }, /* #25/1 */
    { 0x0852, 0x68e1, 0x7800, RTFLOAT80U_INIT_C(1,0xc4cc000000000000,16397), -25190 }, /* #25/2 */
    { 0x0c52, 0x68e1, 0x7800, RTFLOAT80U_INIT_C(1,0xc4cc000000000000,16397), -25190 }, /* #25/3 */
    { 0x0005, 0x979b, 0x3d00, RTFLOAT80U_INIT_C(0,0xe840000000000000,16397), 29728 }, /* #26/0 */
    { 0x0405, 0x979b, 0x3d00, RTFLOAT80U_INIT_C(0,0xe840000000000000,16397), 29728 }, /* #26/1 */
    { 0x0805, 0x979b, 0x3d00, RTFLOAT80U_INIT_C(0,0xe840000000000000,16397), 29728 }, /* #26/2 */
    { 0x0c05, 0x979b, 0x3d00, RTFLOAT80U_INIT_C(0,0xe840000000000000,16397), 29728 }, /* #26/3 */
    { 0x0263, 0x265b, 0x3c00, RTFLOAT80U_INIT_C(1,0xd710000000000000,16396), -13764 }, /* #27/0 */
    { 0x0663, 0x265b, 0x3c00, RTFLOAT80U_INIT_C(1,0xd710000000000000,16396), -13764 }, /* #27/1 */
    { 0x0a63, 0x265b, 0x3c00, RTFLOAT80U_INIT_C(1,0xd710000000000000,16396), -13764 }, /* #27/2 */
    { 0x0e63, 0x265b, 0x3c00, RTFLOAT80U_INIT_C(1,0xd710000000000000,16396), -13764 }, /* #27/3 */
    { 0x0055, 0x833c, 0x3900, RTFLOAT80U_INIT_C(1,0x8310000000000000,16394), -2097 }, /* #28/0 */
    { 0x0455, 0x833c, 0x3900, RTFLOAT80U_INIT_C(1,0x8310000000000000,16394), -2097 }, /* #28/1 */
    { 0x0855, 0x833c, 0x3900, RTFLOAT80U_INIT_C(1,0x8310000000000000,16394), -2097 }, /* #28/2 */
    { 0x0c55, 0x833c, 0x3900, RTFLOAT80U_INIT_C(1,0x8310000000000000,16394), -2097 }, /* #28/3 */
    { 0x0119, 0xe78e, 0x7d00, RTFLOAT80U_INIT_C(0,0xa8c8000000000000,16396), 10802 }, /* #29/0 */
    { 0x0519, 0xe78e, 0x7d00, RTFLOAT80U_INIT_C(0,0xa8c8000000000000,16396), 10802 }, /* #29/1 */
    { 0x0919, 0xe78e, 0x7d00, RTFLOAT80U_INIT_C(0,0xa8c8000000000000,16396), 10802 }, /* #29/2 */
    { 0x0d19, 0xe78e, 0x7d00, RTFLOAT80U_INIT_C(0,0xa8c8000000000000,16396), 10802 }, /* #29/3 */
    { 0x0268, 0x2a28, 0x3800, RTFLOAT80U_INIT_C(1,0xe0d8000000000000,16395), -7195 }, /* #30/0 */
    { 0x0668, 0x2a28, 0x3800, RTFLOAT80U_INIT_C(1,0xe0d8000000000000,16395), -7195 }, /* #30/1 */
    { 0x0a68, 0x2a28, 0x3800, RTFLOAT80U_INIT_C(1,0xe0d8000000000000,16395), -7195 }, /* #30/2 */
    { 0x0e68, 0x2a28, 0x3800, RTFLOAT80U_INIT_C(1,0xe0d8000000000000,16395), -7195 }, /* #30/3 */
    { 0x034d, 0x2b5a, 0x3900, RTFLOAT80U_INIT_C(0,0xe140000000000000,16393), 1802 }, /* #31/0 */
    { 0x074d, 0x2b5a, 0x3900, RTFLOAT80U_INIT_C(0,0xe140000000000000,16393), 1802 }, /* #31/1 */
    { 0x0b4d, 0x2b5a, 0x3900, RTFLOAT80U_INIT_C(0,0xe140000000000000,16393), 1802 }, /* #31/2 */
    { 0x0f4d, 0x2b5a, 0x3900, RTFLOAT80U_INIT_C(0,0xe140000000000000,16393), 1802 }, /* #31/3 */
    { 0x001a, 0x74ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xe018000000000000,16397), -28684 }, /* #32/0 */
    { 0x041a, 0x74ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xe018000000000000,16397), -28684 }, /* #32/1 */
    { 0x081a, 0x74ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xe018000000000000,16397), -28684 }, /* #32/2 */
    { 0x0c1a, 0x74ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xe018000000000000,16397), -28684 }, /* #32/3 */
    { 0x0165, 0x4d6b, 0x7d00, RTFLOAT80U_INIT_C(1,0xfc58000000000000,16396), -16150 }, /* #33/0 */
    { 0x0565, 0x4d6b, 0x7d00, RTFLOAT80U_INIT_C(1,0xfc58000000000000,16396), -16150 }, /* #33/1 */
    { 0x0965, 0x4d6b, 0x7d00, RTFLOAT80U_INIT_C(1,0xfc58000000000000,16396), -16150 }, /* #33/2 */
    { 0x0d65, 0x4d6b, 0x7d00, RTFLOAT80U_INIT_C(1,0xfc58000000000000,16396), -16150 }, /* #33/3 */
    { 0x035e, 0xedba, 0x7d00, RTFLOAT80U_INIT_C(1,0xd520000000000000,16394), -3410 }, /* #34/0 */
    { 0x075e, 0xedba, 0x7d00, RTFLOAT80U_INIT_C(1,0xd520000000000000,16394), -3410 }, /* #34/1 */
    { 0x0b5e, 0xedba, 0x7d00, RTFLOAT80U_INIT_C(1,0xd520000000000000,16394), -3410 }, /* #34/2 */
    { 0x0f5e, 0xedba, 0x7d00, RTFLOAT80U_INIT_C(1,0xd520000000000000,16394), -3410 }, /* #34/3 */
    { 0x030e, 0x43a6, 0x7900, RTFLOAT80U_INIT_C(0,0x9760000000000000,16394), 2422 }, /* #35/0 */
    { 0x070e, 0x43a6, 0x7900, RTFLOAT80U_INIT_C(0,0x9760000000000000,16394), 2422 }, /* #35/1 */
    { 0x0b0e, 0x43a6, 0x7900, RTFLOAT80U_INIT_C(0,0x9760000000000000,16394), 2422 }, /* #35/2 */
    { 0x0f0e, 0x43a6, 0x7900, RTFLOAT80U_INIT_C(0,0x9760000000000000,16394), 2422 }, /* #35/3 */
    { 0x0173, 0xa034, 0x3800, RTFLOAT80U_INIT_C(1,0x8562000000000000,16397), -17073 }, /* #36/0 */
    { 0x0573, 0xa034, 0x3800, RTFLOAT80U_INIT_C(1,0x8562000000000000,16397), -17073 }, /* #36/1 */
    { 0x0973, 0xa034, 0x3800, RTFLOAT80U_INIT_C(1,0x8562000000000000,16397), -17073 }, /* #36/2 */
    { 0x0d73, 0xa034, 0x3800, RTFLOAT80U_INIT_C(1,0x8562000000000000,16397), -17073 }, /* #36/3 */
    { 0x0308, 0xcc96, 0x7c00, RTFLOAT80U_INIT_C(1,0xc230000000000000,16394), -3107 }, /* #37/0 */
    { 0x0708, 0xcc96, 0x7c00, RTFLOAT80U_INIT_C(1,0xc230000000000000,16394), -3107 }, /* #37/1 */
    { 0x0b08, 0xcc96, 0x7c00, RTFLOAT80U_INIT_C(1,0xc230000000000000,16394), -3107 }, /* #37/2 */
    { 0x0f08, 0xcc96, 0x7c00, RTFLOAT80U_INIT_C(1,0xc230000000000000,16394), -3107 }, /* #37/3 */
    { 0x0101, 0xa599, 0x3d00, RTFLOAT80U_INIT_C(1,0xa184000000000000,16396), -10337 }, /* #38/0 */
    { 0x0501, 0xa599, 0x3d00, RTFLOAT80U_INIT_C(1,0xa184000000000000,16396), -10337 }, /* #38/1 */
    { 0x0901, 0xa599, 0x3d00, RTFLOAT80U_INIT_C(1,0xa184000000000000,16396), -10337 }, /* #38/2 */
    { 0x0d01, 0xa599, 0x3d00, RTFLOAT80U_INIT_C(1,0xa184000000000000,16396), -10337 }, /* #38/3 */
    { 0x0138, 0x6135, 0x7900, RTFLOAT80U_INIT_C(1,0xaa28000000000000,16395), -5445 }, /* #39/0 */
    { 0x0538, 0x6135, 0x7900, RTFLOAT80U_INIT_C(1,0xaa28000000000000,16395), -5445 }, /* #39/1 */
    { 0x0938, 0x6135, 0x7900, RTFLOAT80U_INIT_C(1,0xaa28000000000000,16395), -5445 }, /* #39/2 */
    { 0x0d38, 0x6135, 0x7900, RTFLOAT80U_INIT_C(1,0xaa28000000000000,16395), -5445 }, /* #39/3 */
    { 0x030e, 0x2255, 0x3800, RTFLOAT80U_INIT_C(1,0x8f50000000000000,16396), -9172 }, /* #40/0 */
    { 0x070e, 0x2255, 0x3800, RTFLOAT80U_INIT_C(1,0x8f50000000000000,16396), -9172 }, /* #40/1 */
    { 0x0b0e, 0x2255, 0x3800, RTFLOAT80U_INIT_C(1,0x8f50000000000000,16396), -9172 }, /* #40/2 */
    { 0x0f0e, 0x2255, 0x3800, RTFLOAT80U_INIT_C(1,0x8f50000000000000,16396), -9172 }, /* #40/3 */
    { 0x0024, 0xda29, 0x7800, RTFLOAT80U_INIT_C(1,0xd508000000000000,16396), -13634 }, /* #41/0 */
    { 0x0424, 0xda29, 0x7800, RTFLOAT80U_INIT_C(1,0xd508000000000000,16396), -13634 }, /* #41/1 */
    { 0x0824, 0xda29, 0x7800, RTFLOAT80U_INIT_C(1,0xd508000000000000,16396), -13634 }, /* #41/2 */
    { 0x0c24, 0xda29, 0x7800, RTFLOAT80U_INIT_C(1,0xd508000000000000,16396), -13634 }, /* #41/3 */
    { 0x0119, 0x53ff, 0x7900, RTFLOAT80U_INIT_C(0,0x9d20000000000000,16395), 5028 }, /* #42/0 */
    { 0x0519, 0x53ff, 0x7900, RTFLOAT80U_INIT_C(0,0x9d20000000000000,16395), 5028 }, /* #42/1 */
    { 0x0919, 0x53ff, 0x7900, RTFLOAT80U_INIT_C(0,0x9d20000000000000,16395), 5028 }, /* #42/2 */
    { 0x0d19, 0x53ff, 0x7900, RTFLOAT80U_INIT_C(0,0x9d20000000000000,16395), 5028 }, /* #42/3 */
    { 0x0122, 0x05f1, 0x3d00, RTFLOAT80U_INIT_C(1,0xfb40000000000000,16395), -8040 }, /* #43/0 */
    { 0x0522, 0x05f1, 0x3d00, RTFLOAT80U_INIT_C(1,0xfb40000000000000,16395), -8040 }, /* #43/1 */
    { 0x0922, 0x05f1, 0x3d00, RTFLOAT80U_INIT_C(1,0xfb40000000000000,16395), -8040 }, /* #43/2 */
    { 0x0d22, 0x05f1, 0x3d00, RTFLOAT80U_INIT_C(1,0xfb40000000000000,16395), -8040 }, /* #43/3 */
    { 0x0005, 0xe6e5, 0x7c00, RTFLOAT80U_INIT_C(0,0x8c64000000000000,16397), 17970 }, /* #44/0 */
    { 0x0405, 0xe6e5, 0x7c00, RTFLOAT80U_INIT_C(0,0x8c64000000000000,16397), 17970 }, /* #44/1 */
    { 0x0805, 0xe6e5, 0x7c00, RTFLOAT80U_INIT_C(0,0x8c64000000000000,16397), 17970 }, /* #44/2 */
    { 0x0c05, 0xe6e5, 0x7c00, RTFLOAT80U_INIT_C(0,0x8c64000000000000,16397), 17970 }, /* #44/3 */
    { 0x0333, 0x7a55, 0x7800, RTFLOAT80U_INIT_C(1,0xf5be000000000000,16397), -31455 }, /* #45/0 */
    { 0x0733, 0x7a55, 0x7800, RTFLOAT80U_INIT_C(1,0xf5be000000000000,16397), -31455 }, /* #45/1 */
    { 0x0b33, 0x7a55, 0x7800, RTFLOAT80U_INIT_C(1,0xf5be000000000000,16397), -31455 }, /* #45/2 */
    { 0x0f33, 0x7a55, 0x7800, RTFLOAT80U_INIT_C(1,0xf5be000000000000,16397), -31455 }, /* #45/3 */
    { 0x0151, 0x71e3, 0x7900, RTFLOAT80U_INIT_C(0,0x9c58000000000000,16397), 20012 }, /* #46/0 */
    { 0x0551, 0x71e3, 0x7900, RTFLOAT80U_INIT_C(0,0x9c58000000000000,16397), 20012 }, /* #46/1 */
    { 0x0951, 0x71e3, 0x7900, RTFLOAT80U_INIT_C(0,0x9c58000000000000,16397), 20012 }, /* #46/2 */
    { 0x0d51, 0x71e3, 0x7900, RTFLOAT80U_INIT_C(0,0x9c58000000000000,16397), 20012 }, /* #46/3 */
    { 0x004a, 0xb53e, 0x3d00, RTFLOAT80U_INIT_C(1,0xc840000000000000,16396), -12816 }, /* #47/0 */
    { 0x044a, 0xb53e, 0x3d00, RTFLOAT80U_INIT_C(1,0xc840000000000000,16396), -12816 }, /* #47/1 */
    { 0x084a, 0xb53e, 0x3d00, RTFLOAT80U_INIT_C(1,0xc840000000000000,16396), -12816 }, /* #47/2 */
    { 0x0c4a, 0xb53e, 0x3d00, RTFLOAT80U_INIT_C(1,0xc840000000000000,16396), -12816 }, /* #47/3 */
    { 0x0076, 0x06cd, 0x3c00, RTFLOAT80U_INIT_C(1,0xf3be000000000000,16397), -31199 }, /* #48/0 */
    { 0x0476, 0x06cd, 0x3c00, RTFLOAT80U_INIT_C(1,0xf3be000000000000,16397), -31199 }, /* #48/1 */
    { 0x0876, 0x06cd, 0x3c00, RTFLOAT80U_INIT_C(1,0xf3be000000000000,16397), -31199 }, /* #48/2 */
    { 0x0c76, 0x06cd, 0x3c00, RTFLOAT80U_INIT_C(1,0xf3be000000000000,16397), -31199 }, /* #48/3 */
    { 0x0316, 0x9a0d, 0x3800, RTFLOAT80U_INIT_C(0,0xb000000000000000,16395), 5632 }, /* #49/0 */
    { 0x0716, 0x9a0d, 0x3800, RTFLOAT80U_INIT_C(0,0xb000000000000000,16395), 5632 }, /* #49/1 */
    { 0x0b16, 0x9a0d, 0x3800, RTFLOAT80U_INIT_C(0,0xb000000000000000,16395), 5632 }, /* #49/2 */
    { 0x0f16, 0x9a0d, 0x3800, RTFLOAT80U_INIT_C(0,0xb000000000000000,16395), 5632 }, /* #49/3 */
    { 0x0132, 0x72eb, 0x7800, RTFLOAT80U_INIT_C(1,0x9cb0000000000000,16396), -10028 }, /* #50/0 */
    { 0x0532, 0x72eb, 0x7800, RTFLOAT80U_INIT_C(1,0x9cb0000000000000,16396), -10028 }, /* #50/1 */
    { 0x0932, 0x72eb, 0x7800, RTFLOAT80U_INIT_C(1,0x9cb0000000000000,16396), -10028 }, /* #50/2 */
    { 0x0d32, 0x72eb, 0x7800, RTFLOAT80U_INIT_C(1,0x9cb0000000000000,16396), -10028 }, /* #50/3 */
    { 0x0317, 0x9454, 0x3c00, RTFLOAT80U_INIT_C(0,0xe2c6000000000000,16397), 29027 }, /* #51/0 */
    { 0x0717, 0x9454, 0x3c00, RTFLOAT80U_INIT_C(0,0xe2c6000000000000,16397), 29027 }, /* #51/1 */
    { 0x0b17, 0x9454, 0x3c00, RTFLOAT80U_INIT_C(0,0xe2c6000000000000,16397), 29027 }, /* #51/2 */
    { 0x0f17, 0x9454, 0x3c00, RTFLOAT80U_INIT_C(0,0xe2c6000000000000,16397), 29027 }, /* #51/3 */
    { 0x0115, 0xa36f, 0x3900, RTFLOAT80U_INIT_C(0,0xb630000000000000,16394), 2915 }, /* #52/0 */
    { 0x0515, 0xa36f, 0x3900, RTFLOAT80U_INIT_C(0,0xb630000000000000,16394), 2915 }, /* #52/1 */
    { 0x0915, 0xa36f, 0x3900, RTFLOAT80U_INIT_C(0,0xb630000000000000,16394), 2915 }, /* #52/2 */
    { 0x0d15, 0xa36f, 0x3900, RTFLOAT80U_INIT_C(0,0xb630000000000000,16394), 2915 }, /* #52/3 */
    { 0x0268, 0x4d3c, 0x7d00, RTFLOAT80U_INIT_C(0,0x9d14000000000000,16396), 10053 }, /* #53/0 */
    { 0x0668, 0x4d3c, 0x7d00, RTFLOAT80U_INIT_C(0,0x9d14000000000000,16396), 10053 }, /* #53/1 */
    { 0x0a68, 0x4d3c, 0x7d00, RTFLOAT80U_INIT_C(0,0x9d14000000000000,16396), 10053 }, /* #53/2 */
    { 0x0e68, 0x4d3c, 0x7d00, RTFLOAT80U_INIT_C(0,0x9d14000000000000,16396), 10053 }, /* #53/3 */
    { 0x0201, 0xc1c6, 0x7900, RTFLOAT80U_INIT_C(0,0xf566000000000000,16397), 31411 }, /* #54/0 */
    { 0x0601, 0xc1c6, 0x7900, RTFLOAT80U_INIT_C(0,0xf566000000000000,16397), 31411 }, /* #54/1 */
    { 0x0a01, 0xc1c6, 0x7900, RTFLOAT80U_INIT_C(0,0xf566000000000000,16397), 31411 }, /* #54/2 */
    { 0x0e01, 0xc1c6, 0x7900, RTFLOAT80U_INIT_C(0,0xf566000000000000,16397), 31411 }, /* #54/3 */
    { 0x0261, 0xc5eb, 0x7d00, RTFLOAT80U_INIT_C(1,0xb874000000000000,16397), -23610 }, /* #55/0 */
    { 0x0661, 0xc5eb, 0x7d00, RTFLOAT80U_INIT_C(1,0xb874000000000000,16397), -23610 }, /* #55/1 */
    { 0x0a61, 0xc5eb, 0x7d00, RTFLOAT80U_INIT_C(1,0xb874000000000000,16397), -23610 }, /* #55/2 */
    { 0x0e61, 0xc5eb, 0x7d00, RTFLOAT80U_INIT_C(1,0xb874000000000000,16397), -23610 }, /* #55/3 */
    { 0x0350, 0x7afc, 0x7800, RTFLOAT80U_INIT_C(0,0xc2e8000000000000,16397), 24948 }, /* #56/0 */
    { 0x0750, 0x7afc, 0x7800, RTFLOAT80U_INIT_C(0,0xc2e8000000000000,16397), 24948 }, /* #56/1 */
    { 0x0b50, 0x7afc, 0x7800, RTFLOAT80U_INIT_C(0,0xc2e8000000000000,16397), 24948 }, /* #56/2 */
    { 0x0f50, 0x7afc, 0x7800, RTFLOAT80U_INIT_C(0,0xc2e8000000000000,16397), 24948 }, /* #56/3 */
    { 0x0200, 0x961a, 0x3c00, RTFLOAT80U_INIT_C(1,0x8560000000000000,16393), -1067 }, /* #57/0 */
    { 0x0600, 0x961a, 0x3c00, RTFLOAT80U_INIT_C(1,0x8560000000000000,16393), -1067 }, /* #57/1 */
    { 0x0a00, 0x961a, 0x3c00, RTFLOAT80U_INIT_C(1,0x8560000000000000,16393), -1067 }, /* #57/2 */
    { 0x0e00, 0x961a, 0x3c00, RTFLOAT80U_INIT_C(1,0x8560000000000000,16393), -1067 }, /* #57/3 */
    { 0x0151, 0xe4c7, 0x7c00, RTFLOAT80U_INIT_C(0,0x851c000000000000,16397), 17038 }, /* #58/0 */
    { 0x0551, 0xe4c7, 0x7c00, RTFLOAT80U_INIT_C(0,0x851c000000000000,16397), 17038 }, /* #58/1 */
    { 0x0951, 0xe4c7, 0x7c00, RTFLOAT80U_INIT_C(0,0x851c000000000000,16397), 17038 }, /* #58/2 */
    { 0x0d51, 0xe4c7, 0x7c00, RTFLOAT80U_INIT_C(0,0x851c000000000000,16397), 17038 }, /* #58/3 */
    { 0x005f, 0x7066, 0x7800, RTFLOAT80U_INIT_C(0,0x9dc0000000000000,16393), 1262 }, /* #59/0 */
    { 0x045f, 0x7066, 0x7800, RTFLOAT80U_INIT_C(0,0x9dc0000000000000,16393), 1262 }, /* #59/1 */
    { 0x085f, 0x7066, 0x7800, RTFLOAT80U_INIT_C(0,0x9dc0000000000000,16393), 1262 }, /* #59/2 */
    { 0x0c5f, 0x7066, 0x7800, RTFLOAT80U_INIT_C(0,0x9dc0000000000000,16393), 1262 }, /* #59/3 */
    { 0x0226, 0x34e3, 0x3c00, RTFLOAT80U_INIT_C(0,0xa1f2000000000000,16397), 20729 }, /* #60/0 */
    { 0x0626, 0x34e3, 0x3c00, RTFLOAT80U_INIT_C(0,0xa1f2000000000000,16397), 20729 }, /* #60/1 */
    { 0x0a26, 0x34e3, 0x3c00, RTFLOAT80U_INIT_C(0,0xa1f2000000000000,16397), 20729 }, /* #60/2 */
    { 0x0e26, 0x34e3, 0x3c00, RTFLOAT80U_INIT_C(0,0xa1f2000000000000,16397), 20729 }, /* #60/3 */
    { 0x031c, 0x8e50, 0x3c00, RTFLOAT80U_INIT_C(1,0xe7b8000000000000,16395), -7415 }, /* #61/0 */
    { 0x071c, 0x8e50, 0x3c00, RTFLOAT80U_INIT_C(1,0xe7b8000000000000,16395), -7415 }, /* #61/1 */
    { 0x0b1c, 0x8e50, 0x3c00, RTFLOAT80U_INIT_C(1,0xe7b8000000000000,16395), -7415 }, /* #61/2 */
    { 0x0f1c, 0x8e50, 0x3c00, RTFLOAT80U_INIT_C(1,0xe7b8000000000000,16395), -7415 }, /* #61/3 */
    { 0x0166, 0xc53b, 0x7d00, RTFLOAT80U_INIT_C(1,0xf2c8000000000000,16396), -15538 }, /* #62/0 */
    { 0x0566, 0xc53b, 0x7d00, RTFLOAT80U_INIT_C(1,0xf2c8000000000000,16396), -15538 }, /* #62/1 */
    { 0x0966, 0xc53b, 0x7d00, RTFLOAT80U_INIT_C(1,0xf2c8000000000000,16396), -15538 }, /* #62/2 */
    { 0x0d66, 0xc53b, 0x7d00, RTFLOAT80U_INIT_C(1,0xf2c8000000000000,16396), -15538 }, /* #62/3 */
    { 0x0030, 0xc679, 0x7c00, RTFLOAT80U_INIT_C(0,0x9b68000000000000,16395), 4973 }, /* #63/0 */
    { 0x0430, 0xc679, 0x7c00, RTFLOAT80U_INIT_C(0,0x9b68000000000000,16395), 4973 }, /* #63/1 */
    { 0x0830, 0xc679, 0x7c00, RTFLOAT80U_INIT_C(0,0x9b68000000000000,16395), 4973 }, /* #63/2 */
    { 0x0c30, 0xc679, 0x7c00, RTFLOAT80U_INIT_C(0,0x9b68000000000000,16395), 4973 }, /* #63/3 */
    { 0x0070, 0x8717, 0x3d00, RTFLOAT80U_INIT_C(1,0xf308000000000000,16397), -31108 }, /* #64/0 */
    { 0x0470, 0x8717, 0x3d00, RTFLOAT80U_INIT_C(1,0xf308000000000000,16397), -31108 }, /* #64/1 */
    { 0x0870, 0x8717, 0x3d00, RTFLOAT80U_INIT_C(1,0xf308000000000000,16397), -31108 }, /* #64/2 */
    { 0x0c70, 0x8717, 0x3d00, RTFLOAT80U_INIT_C(1,0xf308000000000000,16397), -31108 }, /* #64/3 */
    { 0x035f, 0x3820, 0x3800, RTFLOAT80U_INIT_C(0,0xd2ca000000000000,16397), 26981 }, /* #65/0 */
    { 0x075f, 0x3820, 0x3800, RTFLOAT80U_INIT_C(0,0xd2ca000000000000,16397), 26981 }, /* #65/1 */
    { 0x0b5f, 0x3820, 0x3800, RTFLOAT80U_INIT_C(0,0xd2ca000000000000,16397), 26981 }, /* #65/2 */
    { 0x0f5f, 0x3820, 0x3800, RTFLOAT80U_INIT_C(0,0xd2ca000000000000,16397), 26981 }, /* #65/3 */
    { 0x0276, 0x31fc, 0x3900, RTFLOAT80U_INIT_C(1,0x855e000000000000,16397), -17071 }, /* #66/0 */
    { 0x0676, 0x31fc, 0x3900, RTFLOAT80U_INIT_C(1,0x855e000000000000,16397), -17071 }, /* #66/1 */
    { 0x0a76, 0x31fc, 0x3900, RTFLOAT80U_INIT_C(1,0x855e000000000000,16397), -17071 }, /* #66/2 */
    { 0x0e76, 0x31fc, 0x3900, RTFLOAT80U_INIT_C(1,0x855e000000000000,16397), -17071 }, /* #66/3 */
    { 0x0347, 0x7afe, 0x7800, RTFLOAT80U_INIT_C(1,0xdf90000000000000,16397), -28616 }, /* #67/0 */
    { 0x0747, 0x7afe, 0x7800, RTFLOAT80U_INIT_C(1,0xdf90000000000000,16397), -28616 }, /* #67/1 */
    { 0x0b47, 0x7afe, 0x7800, RTFLOAT80U_INIT_C(1,0xdf90000000000000,16397), -28616 }, /* #67/2 */
    { 0x0f47, 0x7afe, 0x7800, RTFLOAT80U_INIT_C(1,0xdf90000000000000,16397), -28616 }, /* #67/3 */
    { 0x011c, 0x83a7, 0x3900, RTFLOAT80U_INIT_C(1,0xc4a6000000000000,16397), -25171 }, /* #68/0 */
    { 0x051c, 0x83a7, 0x3900, RTFLOAT80U_INIT_C(1,0xc4a6000000000000,16397), -25171 }, /* #68/1 */
    { 0x091c, 0x83a7, 0x3900, RTFLOAT80U_INIT_C(1,0xc4a6000000000000,16397), -25171 }, /* #68/2 */
    { 0x0d1c, 0x83a7, 0x3900, RTFLOAT80U_INIT_C(1,0xc4a6000000000000,16397), -25171 }, /* #68/3 */
    { 0x012c, 0xd3af, 0x7900, RTFLOAT80U_INIT_C(1,0xe4e0000000000000,16397), -29296 }, /* #69/0 */
    { 0x052c, 0xd3af, 0x7900, RTFLOAT80U_INIT_C(1,0xe4e0000000000000,16397), -29296 }, /* #69/1 */
    { 0x092c, 0xd3af, 0x7900, RTFLOAT80U_INIT_C(1,0xe4e0000000000000,16397), -29296 }, /* #69/2 */
    { 0x0d2c, 0xd3af, 0x7900, RTFLOAT80U_INIT_C(1,0xe4e0000000000000,16397), -29296 }, /* #69/3 */
    { 0x0070, 0x5cbb, 0x7c00, RTFLOAT80U_INIT_C(1,0xd172000000000000,16397), -26809 }, /* #70/0 */
    { 0x0470, 0x5cbb, 0x7c00, RTFLOAT80U_INIT_C(1,0xd172000000000000,16397), -26809 }, /* #70/1 */
    { 0x0870, 0x5cbb, 0x7c00, RTFLOAT80U_INIT_C(1,0xd172000000000000,16397), -26809 }, /* #70/2 */
    { 0x0c70, 0x5cbb, 0x7c00, RTFLOAT80U_INIT_C(1,0xd172000000000000,16397), -26809 }, /* #70/3 */
    { 0x0367, 0x24d0, 0x3c00, RTFLOAT80U_INIT_C(1,0xa19c000000000000,16397), -20686 }, /* #71/0 */
    { 0x0767, 0x24d0, 0x3c00, RTFLOAT80U_INIT_C(1,0xa19c000000000000,16397), -20686 }, /* #71/1 */
    { 0x0b67, 0x24d0, 0x3c00, RTFLOAT80U_INIT_C(1,0xa19c000000000000,16397), -20686 }, /* #71/2 */
    { 0x0f67, 0x24d0, 0x3c00, RTFLOAT80U_INIT_C(1,0xa19c000000000000,16397), -20686 }, /* #71/3 */
    { 0x011a, 0x2463, 0x3c00, RTFLOAT80U_INIT_C(1,0xa3b0000000000000,16394), -2619 }, /* #72/0 */
    { 0x051a, 0x2463, 0x3c00, RTFLOAT80U_INIT_C(1,0xa3b0000000000000,16394), -2619 }, /* #72/1 */
    { 0x091a, 0x2463, 0x3c00, RTFLOAT80U_INIT_C(1,0xa3b0000000000000,16394), -2619 }, /* #72/2 */
    { 0x0d1a, 0x2463, 0x3c00, RTFLOAT80U_INIT_C(1,0xa3b0000000000000,16394), -2619 }, /* #72/3 */
    { 0x032c, 0xbe48, 0x3c00, RTFLOAT80U_INIT_C(0,0x9780000000000000,16392), 606 }, /* #73/0 */
    { 0x072c, 0xbe48, 0x3c00, RTFLOAT80U_INIT_C(0,0x9780000000000000,16392), 606 }, /* #73/1 */
    { 0x0b2c, 0xbe48, 0x3c00, RTFLOAT80U_INIT_C(0,0x9780000000000000,16392), 606 }, /* #73/2 */
    { 0x0f2c, 0xbe48, 0x3c00, RTFLOAT80U_INIT_C(0,0x9780000000000000,16392), 606 }, /* #73/3 */
    { 0x0142, 0x518e, 0x7900, RTFLOAT80U_INIT_C(1,0xc0c8000000000000,16395), -6169 }, /* #74/0 */
    { 0x0542, 0x518e, 0x7900, RTFLOAT80U_INIT_C(1,0xc0c8000000000000,16395), -6169 }, /* #74/1 */
    { 0x0942, 0x518e, 0x7900, RTFLOAT80U_INIT_C(1,0xc0c8000000000000,16395), -6169 }, /* #74/2 */
    { 0x0d42, 0x518e, 0x7900, RTFLOAT80U_INIT_C(1,0xc0c8000000000000,16395), -6169 }, /* #74/3 */
    { 0x022c, 0x5b87, 0x7900, RTFLOAT80U_INIT_C(1,0x964c000000000000,16396), -9619 }, /* #75/0 */
    { 0x062c, 0x5b87, 0x7900, RTFLOAT80U_INIT_C(1,0x964c000000000000,16396), -9619 }, /* #75/1 */
    { 0x0a2c, 0x5b87, 0x7900, RTFLOAT80U_INIT_C(1,0x964c000000000000,16396), -9619 }, /* #75/2 */
    { 0x0e2c, 0x5b87, 0x7900, RTFLOAT80U_INIT_C(1,0x964c000000000000,16396), -9619 }, /* #75/3 */
    { 0x0325, 0x136b, 0x3900, RTFLOAT80U_INIT_C(1,0xc430000000000000,16395), -6278 }, /* #76/0 */
    { 0x0725, 0x136b, 0x3900, RTFLOAT80U_INIT_C(1,0xc430000000000000,16395), -6278 }, /* #76/1 */
    { 0x0b25, 0x136b, 0x3900, RTFLOAT80U_INIT_C(1,0xc430000000000000,16395), -6278 }, /* #76/2 */
    { 0x0f25, 0x136b, 0x3900, RTFLOAT80U_INIT_C(1,0xc430000000000000,16395), -6278 }, /* #76/3 */
    { 0x034b, 0xb138, 0x3900, RTFLOAT80U_INIT_C(1,0x8024000000000000,16396), -8201 }, /* #77/0 */
    { 0x074b, 0xb138, 0x3900, RTFLOAT80U_INIT_C(1,0x8024000000000000,16396), -8201 }, /* #77/1 */
    { 0x0b4b, 0xb138, 0x3900, RTFLOAT80U_INIT_C(1,0x8024000000000000,16396), -8201 }, /* #77/2 */
    { 0x0f4b, 0xb138, 0x3900, RTFLOAT80U_INIT_C(1,0x8024000000000000,16396), -8201 }, /* #77/3 */
    { 0x003a, 0x3d35, 0x3d00, RTFLOAT80U_INIT_C(1,0xfb40000000000000,16397), -32160 }, /* #78/0 */
    { 0x043a, 0x3d35, 0x3d00, RTFLOAT80U_INIT_C(1,0xfb40000000000000,16397), -32160 }, /* #78/1 */
    { 0x083a, 0x3d35, 0x3d00, RTFLOAT80U_INIT_C(1,0xfb40000000000000,16397), -32160 }, /* #78/2 */
    { 0x0c3a, 0x3d35, 0x3d00, RTFLOAT80U_INIT_C(1,0xfb40000000000000,16397), -32160 }, /* #78/3 */
    { 0x0178, 0x824d, 0x3800, RTFLOAT80U_INIT_C(0,0xe300000000000000,16390), 227 }, /* #79/0 */
    { 0x0578, 0x824d, 0x3800, RTFLOAT80U_INIT_C(0,0xe300000000000000,16390), 227 }, /* #79/1 */
    { 0x0978, 0x824d, 0x3800, RTFLOAT80U_INIT_C(0,0xe300000000000000,16390), 227 }, /* #79/2 */
    { 0x0d78, 0x824d, 0x3800, RTFLOAT80U_INIT_C(0,0xe300000000000000,16390), 227 }, /* #79/3 */
    { 0x0061, 0x6eaf, 0x7c00, RTFLOAT80U_INIT_C(0,0xea78000000000000,16396), 15006 }, /* #80/0 */
    { 0x0461, 0x6eaf, 0x7c00, RTFLOAT80U_INIT_C(0,0xea78000000000000,16396), 15006 }, /* #80/1 */
    { 0x0861, 0x6eaf, 0x7c00, RTFLOAT80U_INIT_C(0,0xea78000000000000,16396), 15006 }, /* #80/2 */
    { 0x0c61, 0x6eaf, 0x7c00, RTFLOAT80U_INIT_C(0,0xea78000000000000,16396), 15006 }, /* #80/3 */
    { 0x0149, 0x7f48, 0x7d00, RTFLOAT80U_INIT_C(0,0x8c12000000000000,16397), 17929 }, /* #81/0 */
    { 0x0549, 0x7f48, 0x7d00, RTFLOAT80U_INIT_C(0,0x8c12000000000000,16397), 17929 }, /* #81/1 */
    { 0x0949, 0x7f48, 0x7d00, RTFLOAT80U_INIT_C(0,0x8c12000000000000,16397), 17929 }, /* #81/2 */
    { 0x0d49, 0x7f48, 0x7d00, RTFLOAT80U_INIT_C(0,0x8c12000000000000,16397), 17929 }, /* #81/3 */
    { 0x017f, 0x01e1, 0x3900, RTFLOAT80U_INIT_C(0,0xf300000000000000,16392), 972 }, /* #82/0 */
    { 0x057f, 0x01e1, 0x3900, RTFLOAT80U_INIT_C(0,0xf300000000000000,16392), 972 }, /* #82/1 */
    { 0x097f, 0x01e1, 0x3900, RTFLOAT80U_INIT_C(0,0xf300000000000000,16392), 972 }, /* #82/2 */
    { 0x0d7f, 0x01e1, 0x3900, RTFLOAT80U_INIT_C(0,0xf300000000000000,16392), 972 }, /* #82/3 */
    { 0x022b, 0x9f2b, 0x3d00, RTFLOAT80U_INIT_C(0,0xfd00000000000000,16397), 32384 }, /* #83/0 */
    { 0x062b, 0x9f2b, 0x3d00, RTFLOAT80U_INIT_C(0,0xfd00000000000000,16397), 32384 }, /* #83/1 */
    { 0x0a2b, 0x9f2b, 0x3d00, RTFLOAT80U_INIT_C(0,0xfd00000000000000,16397), 32384 }, /* #83/2 */
    { 0x0e2b, 0x9f2b, 0x3d00, RTFLOAT80U_INIT_C(0,0xfd00000000000000,16397), 32384 }, /* #83/3 */
    { 0x0121, 0x0db1, 0x3d00, RTFLOAT80U_INIT_C(1,0xc03c000000000000,16397), -24606 }, /* #84/0 */
    { 0x0521, 0x0db1, 0x3d00, RTFLOAT80U_INIT_C(1,0xc03c000000000000,16397), -24606 }, /* #84/1 */
    { 0x0921, 0x0db1, 0x3d00, RTFLOAT80U_INIT_C(1,0xc03c000000000000,16397), -24606 }, /* #84/2 */
    { 0x0d21, 0x0db1, 0x3d00, RTFLOAT80U_INIT_C(1,0xc03c000000000000,16397), -24606 }, /* #84/3 */
    { 0x003e, 0x823c, 0x3800, RTFLOAT80U_INIT_C(1,0xcfbc000000000000,16396), -13295 }, /* #85/0 */
    { 0x043e, 0x823c, 0x3800, RTFLOAT80U_INIT_C(1,0xcfbc000000000000,16396), -13295 }, /* #85/1 */
    { 0x083e, 0x823c, 0x3800, RTFLOAT80U_INIT_C(1,0xcfbc000000000000,16396), -13295 }, /* #85/2 */
    { 0x0c3e, 0x823c, 0x3800, RTFLOAT80U_INIT_C(1,0xcfbc000000000000,16396), -13295 }, /* #85/3 */
    { 0x0305, 0xc27a, 0x7800, RTFLOAT80U_INIT_C(0,0xf5e4000000000000,16396), 15737 }, /* #86/0 */
    { 0x0705, 0xc27a, 0x7800, RTFLOAT80U_INIT_C(0,0xf5e4000000000000,16396), 15737 }, /* #86/1 */
    { 0x0b05, 0xc27a, 0x7800, RTFLOAT80U_INIT_C(0,0xf5e4000000000000,16396), 15737 }, /* #86/2 */
    { 0x0f05, 0xc27a, 0x7800, RTFLOAT80U_INIT_C(0,0xf5e4000000000000,16396), 15737 }, /* #86/3 */
    { 0x0240, 0x1626, 0x3c00, RTFLOAT80U_INIT_C(0,0xebf2000000000000,16397), 30201 }, /* #87/0 */
    { 0x0640, 0x1626, 0x3c00, RTFLOAT80U_INIT_C(0,0xebf2000000000000,16397), 30201 }, /* #87/1 */
    { 0x0a40, 0x1626, 0x3c00, RTFLOAT80U_INIT_C(0,0xebf2000000000000,16397), 30201 }, /* #87/2 */
    { 0x0e40, 0x1626, 0x3c00, RTFLOAT80U_INIT_C(0,0xebf2000000000000,16397), 30201 }, /* #87/3 */
    { 0x0029, 0xe6e7, 0x7c00, RTFLOAT80U_INIT_C(0,0xafc4000000000000,16397), 22498 }, /* #88/0 */
    { 0x0429, 0xe6e7, 0x7c00, RTFLOAT80U_INIT_C(0,0xafc4000000000000,16397), 22498 }, /* #88/1 */
    { 0x0829, 0xe6e7, 0x7c00, RTFLOAT80U_INIT_C(0,0xafc4000000000000,16397), 22498 }, /* #88/2 */
    { 0x0c29, 0xe6e7, 0x7c00, RTFLOAT80U_INIT_C(0,0xafc4000000000000,16397), 22498 }, /* #88/3 */
    { 0x037b, 0x23b6, 0x3900, RTFLOAT80U_INIT_C(0,0xbcc0000000000000,16392), 755 }, /* #89/0 */
    { 0x077b, 0x23b6, 0x3900, RTFLOAT80U_INIT_C(0,0xbcc0000000000000,16392), 755 }, /* #89/1 */
    { 0x0b7b, 0x23b6, 0x3900, RTFLOAT80U_INIT_C(0,0xbcc0000000000000,16392), 755 }, /* #89/2 */
    { 0x0f7b, 0x23b6, 0x3900, RTFLOAT80U_INIT_C(0,0xbcc0000000000000,16392), 755 }, /* #89/3 */
    { 0x0337, 0x8afc, 0x3800, RTFLOAT80U_INIT_C(0,0x8fc0000000000000,16396), 9200 }, /* #90/0 */
    { 0x0737, 0x8afc, 0x3800, RTFLOAT80U_INIT_C(0,0x8fc0000000000000,16396), 9200 }, /* #90/1 */
    { 0x0b37, 0x8afc, 0x3800, RTFLOAT80U_INIT_C(0,0x8fc0000000000000,16396), 9200 }, /* #90/2 */
    { 0x0f37, 0x8afc, 0x3800, RTFLOAT80U_INIT_C(0,0x8fc0000000000000,16396), 9200 }, /* #90/3 */
    { 0x0056, 0x7959, 0x7900, RTFLOAT80U_INIT_C(0,0xc186000000000000,16397), 24771 }, /* #91/0 */
    { 0x0456, 0x7959, 0x7900, RTFLOAT80U_INIT_C(0,0xc186000000000000,16397), 24771 }, /* #91/1 */
    { 0x0856, 0x7959, 0x7900, RTFLOAT80U_INIT_C(0,0xc186000000000000,16397), 24771 }, /* #91/2 */
    { 0x0c56, 0x7959, 0x7900, RTFLOAT80U_INIT_C(0,0xc186000000000000,16397), 24771 }, /* #91/3 */
    { 0x0141, 0x9c31, 0x3c00, RTFLOAT80U_INIT_C(1,0xe3c6000000000000,16397), -29155 }, /* #92/0 */
    { 0x0541, 0x9c31, 0x3c00, RTFLOAT80U_INIT_C(1,0xe3c6000000000000,16397), -29155 }, /* #92/1 */
    { 0x0941, 0x9c31, 0x3c00, RTFLOAT80U_INIT_C(1,0xe3c6000000000000,16397), -29155 }, /* #92/2 */
    { 0x0d41, 0x9c31, 0x3c00, RTFLOAT80U_INIT_C(1,0xe3c6000000000000,16397), -29155 }, /* #92/3 */
    { 0x024c, 0x3715, 0x3d00, RTFLOAT80U_INIT_C(0,0x9530000000000000,16397), 19096 }, /* #93/0 */
    { 0x064c, 0x3715, 0x3d00, RTFLOAT80U_INIT_C(0,0x9530000000000000,16397), 19096 }, /* #93/1 */
    { 0x0a4c, 0x3715, 0x3d00, RTFLOAT80U_INIT_C(0,0x9530000000000000,16397), 19096 }, /* #93/2 */
    { 0x0e4c, 0x3715, 0x3d00, RTFLOAT80U_INIT_C(0,0x9530000000000000,16397), 19096 }, /* #93/3 */
    { 0x0274, 0xeb9d, 0x7900, RTFLOAT80U_INIT_C(0,0xba36000000000000,16397), 23835 }, /* #94/0 */
    { 0x0674, 0xeb9d, 0x7900, RTFLOAT80U_INIT_C(0,0xba36000000000000,16397), 23835 }, /* #94/1 */
    { 0x0a74, 0xeb9d, 0x7900, RTFLOAT80U_INIT_C(0,0xba36000000000000,16397), 23835 }, /* #94/2 */
    { 0x0e74, 0xeb9d, 0x7900, RTFLOAT80U_INIT_C(0,0xba36000000000000,16397), 23835 }, /* #94/3 */
    { 0x037c, 0xff37, 0x7d00, RTFLOAT80U_INIT_C(1,0xb1c0000000000000,16394), -2844 }, /* #95/0 */
    { 0x077c, 0xff37, 0x7d00, RTFLOAT80U_INIT_C(1,0xb1c0000000000000,16394), -2844 }, /* #95/1 */
    { 0x0b7c, 0xff37, 0x7d00, RTFLOAT80U_INIT_C(1,0xb1c0000000000000,16394), -2844 }, /* #95/2 */
    { 0x0f7c, 0xff37, 0x7d00, RTFLOAT80U_INIT_C(1,0xb1c0000000000000,16394), -2844 }, /* #95/3 */
};
uint32_t const g_cTests_fild_r80_from_i16 = RT_ELEMENTS(g_aTests_fild_r80_from_i16);

FPU_D80_IN_TEST_T const g_aTests_fld_r80_from_d80[] =
{
    { 0x0034, 0x6ffb, 0x7d00, RTFLOAT80U_INIT_C(1,0x0,0), RTPBCD80U_INIT_C(1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0) }, /* #0/0 */
    { 0x0434, 0x6ffb, 0x7d00, RTFLOAT80U_INIT_C(1,0x0,0), RTPBCD80U_INIT_C(1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0) }, /* #0/1 */
    { 0x0834, 0x6ffb, 0x7d00, RTFLOAT80U_INIT_C(1,0x0,0), RTPBCD80U_INIT_C(1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0) }, /* #0/2 */
    { 0x0c34, 0x6ffb, 0x7d00, RTFLOAT80U_INIT_C(1,0x0,0), RTPBCD80U_INIT_C(1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0) }, /* #0/3 */
    { 0x0072, 0xadb8, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,0), RTPBCD80U_INIT_C(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0) }, /* #1/0 */
    { 0x0472, 0xadb8, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,0), RTPBCD80U_INIT_C(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0) }, /* #1/1 */
    { 0x0872, 0xadb8, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,0), RTPBCD80U_INIT_C(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0) }, /* #1/2 */
    { 0x0c72, 0xadb8, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,0), RTPBCD80U_INIT_C(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0) }, /* #1/3 */
    { 0x0366, 0x78ce, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTPBCD80U_INIT_C(1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0) }, /* #2/0 */
    { 0x0766, 0x78ce, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTPBCD80U_INIT_C(1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0) }, /* #2/1 */
    { 0x0b66, 0x78ce, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTPBCD80U_INIT_C(1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0) }, /* #2/2 */
    { 0x0f66, 0x78ce, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTPBCD80U_INIT_C(1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0) }, /* #2/3 */
    { 0x0335, 0xd525, 0x7d00, RTFLOAT80U_INIT_C(1,0xb884e18e05980000,16443), RTPBCD80U_INIT_EX_C(0x7f,1,15,15,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0) }, /* #3/0 */
    { 0x0735, 0xd525, 0x7d00, RTFLOAT80U_INIT_C(1,0xb884e18e05980000,16443), RTPBCD80U_INIT_EX_C(0x7f,1,15,15,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0) }, /* #3/1 */
    { 0x0b35, 0xd525, 0x7d00, RTFLOAT80U_INIT_C(1,0xb884e18e05980000,16443), RTPBCD80U_INIT_EX_C(0x7f,1,15,15,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0) }, /* #3/2 */
    { 0x0f35, 0xd525, 0x7d00, RTFLOAT80U_INIT_C(1,0xb884e18e05980000,16443), RTPBCD80U_INIT_EX_C(0x7f,1,15,15,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0) }, /* #3/3 */
    { 0x0069, 0x01fa, 0x3900, RTFLOAT80U_INIT_C(1,0xb884e18e05980000,16443), RTPBCD80U_INIT_EX_C(0x7f,1,15,15,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0) }, /* #4/0 */
    { 0x0469, 0x01fa, 0x3900, RTFLOAT80U_INIT_C(1,0xb884e18e05980000,16443), RTPBCD80U_INIT_EX_C(0x7f,1,15,15,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0) }, /* #4/1 */
    { 0x0869, 0x01fa, 0x3900, RTFLOAT80U_INIT_C(1,0xb884e18e05980000,16443), RTPBCD80U_INIT_EX_C(0x7f,1,15,15,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0) }, /* #4/2 */
    { 0x0c69, 0x01fa, 0x3900, RTFLOAT80U_INIT_C(1,0xb884e18e05980000,16443), RTPBCD80U_INIT_EX_C(0x7f,1,15,15,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0) }, /* #4/3 */
    { 0x0011, 0x43cc, 0x7900, RTFLOAT80U_INIT_C(0,0xa6421ef0d25a0ca0,16441), RTPBCD80U_INIT_C(0,3,7,4,3,8,0,3,7,4,3,2,5,9,0,7,5,5,7) }, /* #5/0 */
    { 0x0411, 0x43cc, 0x7900, RTFLOAT80U_INIT_C(0,0xa6421ef0d25a0ca0,16441), RTPBCD80U_INIT_C(0,3,7,4,3,8,0,3,7,4,3,2,5,9,0,7,5,5,7) }, /* #5/1 */
    { 0x0811, 0x43cc, 0x7900, RTFLOAT80U_INIT_C(0,0xa6421ef0d25a0ca0,16441), RTPBCD80U_INIT_C(0,3,7,4,3,8,0,3,7,4,3,2,5,9,0,7,5,5,7) }, /* #5/2 */
    { 0x0c11, 0x43cc, 0x7900, RTFLOAT80U_INIT_C(0,0xa6421ef0d25a0ca0,16441), RTPBCD80U_INIT_C(0,3,7,4,3,8,0,3,7,4,3,2,5,9,0,7,5,5,7) }, /* #5/3 */
    { 0x0147, 0x2e72, 0x3c00, RTFLOAT80U_INIT_C(1,0xe444375ca5502750,16442), RTPBCD80U_INIT_C(1,10,2,7,9,11,10,7,8,8,0,12,12,1,1,8,11,5,7) }, /* #6/0 */
    { 0x0547, 0x2e72, 0x3c00, RTFLOAT80U_INIT_C(1,0xe444375ca5502750,16442), RTPBCD80U_INIT_C(1,10,2,7,9,11,10,7,8,8,0,12,12,1,1,8,11,5,7) }, /* #6/1 */
    { 0x0947, 0x2e72, 0x3c00, RTFLOAT80U_INIT_C(1,0xe444375ca5502750,16442), RTPBCD80U_INIT_C(1,10,2,7,9,11,10,7,8,8,0,12,12,1,1,8,11,5,7) }, /* #6/2 */
    { 0x0d47, 0x2e72, 0x3c00, RTFLOAT80U_INIT_C(1,0xe444375ca5502750,16442), RTPBCD80U_INIT_C(1,10,2,7,9,11,10,7,8,8,0,12,12,1,1,8,11,5,7) }, /* #6/3 */
    { 0x0210, 0xce86, 0x7c00, RTFLOAT80U_INIT_C(0,0xb25e98e6d3a89b00,16441), RTPBCD80U_INIT_EX_C(0x7e,0,3,9,11,6,4,11,14,4,12,12,3,10,12,13,10,10,14,4) }, /* #7/0 */
    { 0x0610, 0xce86, 0x7c00, RTFLOAT80U_INIT_C(0,0xb25e98e6d3a89b00,16441), RTPBCD80U_INIT_EX_C(0x7e,0,3,9,11,6,4,11,14,4,12,12,3,10,12,13,10,10,14,4) }, /* #7/1 */
    { 0x0a10, 0xce86, 0x7c00, RTFLOAT80U_INIT_C(0,0xb25e98e6d3a89b00,16441), RTPBCD80U_INIT_EX_C(0x7e,0,3,9,11,6,4,11,14,4,12,12,3,10,12,13,10,10,14,4) }, /* #7/2 */
    { 0x0e10, 0xce86, 0x7c00, RTFLOAT80U_INIT_C(0,0xb25e98e6d3a89b00,16441), RTPBCD80U_INIT_EX_C(0x7e,0,3,9,11,6,4,11,14,4,12,12,3,10,12,13,10,10,14,4) }, /* #7/3 */
    { 0x0279, 0xcba1, 0x7900, RTFLOAT80U_INIT_C(0,0xdbc74dba235d0980,16442), RTPBCD80U_INIT_C(0,9,8,9,7,9,4,5,0,4,7,8,2,7,6,2,1,3,6) }, /* #8/0 */
    { 0x0679, 0xcba1, 0x7900, RTFLOAT80U_INIT_C(0,0xdbc74dba235d0980,16442), RTPBCD80U_INIT_C(0,9,8,9,7,9,4,5,0,4,7,8,2,7,6,2,1,3,6) }, /* #8/1 */
    { 0x0a79, 0xcba1, 0x7900, RTFLOAT80U_INIT_C(0,0xdbc74dba235d0980,16442), RTPBCD80U_INIT_C(0,9,8,9,7,9,4,5,0,4,7,8,2,7,6,2,1,3,6) }, /* #8/2 */
    { 0x0e79, 0xcba1, 0x7900, RTFLOAT80U_INIT_C(0,0xdbc74dba235d0980,16442), RTPBCD80U_INIT_C(0,9,8,9,7,9,4,5,0,4,7,8,2,7,6,2,1,3,6) }, /* #8/3 */
    { 0x0215, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(1,0xbf99ade7b9420d80,16442), RTPBCD80U_INIT_C(1,8,6,2,8,9,1,0,8,3,9,6,4,8,8,3,1,6,0) }, /* #9/0 */
    { 0x0615, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(1,0xbf99ade7b9420d80,16442), RTPBCD80U_INIT_C(1,8,6,2,8,9,1,0,8,3,9,6,4,8,8,3,1,6,0) }, /* #9/1 */
    { 0x0a15, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(1,0xbf99ade7b9420d80,16442), RTPBCD80U_INIT_C(1,8,6,2,8,9,1,0,8,3,9,6,4,8,8,3,1,6,0) }, /* #9/2 */
    { 0x0e15, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(1,0xbf99ade7b9420d80,16442), RTPBCD80U_INIT_C(1,8,6,2,8,9,1,0,8,3,9,6,4,8,8,3,1,6,0) }, /* #9/3 */
    { 0x012a, 0x4bf4, 0x7900, RTFLOAT80U_INIT_C(0,0xcc3a936570c0c780,16442), RTPBCD80U_INIT_C(0,9,1,9,7,6,4,7,9,9,7,6,7,4,4,8,6,9,6) }, /* #10/0 */
    { 0x052a, 0x4bf4, 0x7900, RTFLOAT80U_INIT_C(0,0xcc3a936570c0c780,16442), RTPBCD80U_INIT_C(0,9,1,9,7,6,4,7,9,9,7,6,7,4,4,8,6,9,6) }, /* #10/1 */
    { 0x092a, 0x4bf4, 0x7900, RTFLOAT80U_INIT_C(0,0xcc3a936570c0c780,16442), RTPBCD80U_INIT_C(0,9,1,9,7,6,4,7,9,9,7,6,7,4,4,8,6,9,6) }, /* #10/2 */
    { 0x0d2a, 0x4bf4, 0x7900, RTFLOAT80U_INIT_C(0,0xcc3a936570c0c780,16442), RTPBCD80U_INIT_C(0,9,1,9,7,6,4,7,9,9,7,6,7,4,4,8,6,9,6) }, /* #10/3 */
    { 0x0317, 0xd228, 0x7800, RTFLOAT80U_INIT_C(0,0x82b4cf8813fffeb0,16442), RTPBCD80U_INIT_C(0,5,8,8,6,4,8,8,0,6,5,0,6,0,3,7,2,2,7) }, /* #11/0 */
    { 0x0717, 0xd228, 0x7800, RTFLOAT80U_INIT_C(0,0x82b4cf8813fffeb0,16442), RTPBCD80U_INIT_C(0,5,8,8,6,4,8,8,0,6,5,0,6,0,3,7,2,2,7) }, /* #11/1 */
    { 0x0b17, 0xd228, 0x7800, RTFLOAT80U_INIT_C(0,0x82b4cf8813fffeb0,16442), RTPBCD80U_INIT_C(0,5,8,8,6,4,8,8,0,6,5,0,6,0,3,7,2,2,7) }, /* #11/2 */
    { 0x0f17, 0xd228, 0x7800, RTFLOAT80U_INIT_C(0,0x82b4cf8813fffeb0,16442), RTPBCD80U_INIT_C(0,5,8,8,6,4,8,8,0,6,5,0,6,0,3,7,2,2,7) }, /* #11/3 */
    { 0x037d, 0x3775, 0x3d00, RTFLOAT80U_INIT_C(0,0x87a36f06f2f50210,16442), RTPBCD80U_INIT_C(0,6,1,0,8,6,1,1,0,5,7,4,7,5,4,6,1,4,5) }, /* #12/0 */
    { 0x077d, 0x3775, 0x3d00, RTFLOAT80U_INIT_C(0,0x87a36f06f2f50210,16442), RTPBCD80U_INIT_C(0,6,1,0,8,6,1,1,0,5,7,4,7,5,4,6,1,4,5) }, /* #12/1 */
    { 0x0b7d, 0x3775, 0x3d00, RTFLOAT80U_INIT_C(0,0x87a36f06f2f50210,16442), RTPBCD80U_INIT_C(0,6,1,0,8,6,1,1,0,5,7,4,7,5,4,6,1,4,5) }, /* #12/2 */
    { 0x0f7d, 0x3775, 0x3d00, RTFLOAT80U_INIT_C(0,0x87a36f06f2f50210,16442), RTPBCD80U_INIT_C(0,6,1,0,8,6,1,1,0,5,7,4,7,5,4,6,1,4,5) }, /* #12/3 */
    { 0x0059, 0x5ebb, 0x7c00, RTFLOAT80U_INIT_C(1,0xd2f6a893726f3fa0,16441), RTPBCD80U_INIT_C(1,4,7,5,0,4,7,5,9,1,9,8,3,4,1,3,7,5,7) }, /* #13/0 */
    { 0x0459, 0x5ebb, 0x7c00, RTFLOAT80U_INIT_C(1,0xd2f6a893726f3fa0,16441), RTPBCD80U_INIT_C(1,4,7,5,0,4,7,5,9,1,9,8,3,4,1,3,7,5,7) }, /* #13/1 */
    { 0x0859, 0x5ebb, 0x7c00, RTFLOAT80U_INIT_C(1,0xd2f6a893726f3fa0,16441), RTPBCD80U_INIT_C(1,4,7,5,0,4,7,5,9,1,9,8,3,4,1,3,7,5,7) }, /* #13/2 */
    { 0x0c59, 0x5ebb, 0x7c00, RTFLOAT80U_INIT_C(1,0xd2f6a893726f3fa0,16441), RTPBCD80U_INIT_C(1,4,7,5,0,4,7,5,9,1,9,8,3,4,1,3,7,5,7) }, /* #13/3 */
    { 0x013c, 0xc8fe, 0x7800, RTFLOAT80U_INIT_C(0,0x9d2689c42df4b108,16443), RTPBCD80U_INIT_C(0,14,0,14,14,7,15,12,2,2,15,8,13,4,1,1,11,2,9) }, /* #14/0 */
    { 0x053c, 0xc8fe, 0x7800, RTFLOAT80U_INIT_C(0,0x9d2689c42df4b108,16443), RTPBCD80U_INIT_C(0,14,0,14,14,7,15,12,2,2,15,8,13,4,1,1,11,2,9) }, /* #14/1 */
    { 0x093c, 0xc8fe, 0x7800, RTFLOAT80U_INIT_C(0,0x9d2689c42df4b108,16443), RTPBCD80U_INIT_C(0,14,0,14,14,7,15,12,2,2,15,8,13,4,1,1,11,2,9) }, /* #14/2 */
    { 0x0d3c, 0xc8fe, 0x7800, RTFLOAT80U_INIT_C(0,0x9d2689c42df4b108,16443), RTPBCD80U_INIT_C(0,14,0,14,14,7,15,12,2,2,15,8,13,4,1,1,11,2,9) }, /* #14/3 */
    { 0x0329, 0xa55b, 0x3d00, RTFLOAT80U_INIT_C(0,0x957e0bc835110fa0,16443), RTPBCD80U_INIT_EX_C(0x5,0,12,14,5,15,0,7,4,13,9,1,5,3,4,15,9,9,14,12) }, /* #15/0 */
    { 0x0729, 0xa55b, 0x3d00, RTFLOAT80U_INIT_C(0,0x957e0bc835110fa0,16443), RTPBCD80U_INIT_EX_C(0x5,0,12,14,5,15,0,7,4,13,9,1,5,3,4,15,9,9,14,12) }, /* #15/1 */
    { 0x0b29, 0xa55b, 0x3d00, RTFLOAT80U_INIT_C(0,0x957e0bc835110fa0,16443), RTPBCD80U_INIT_EX_C(0x5,0,12,14,5,15,0,7,4,13,9,1,5,3,4,15,9,9,14,12) }, /* #15/2 */
    { 0x0f29, 0xa55b, 0x3d00, RTFLOAT80U_INIT_C(0,0x957e0bc835110fa0,16443), RTPBCD80U_INIT_EX_C(0x5,0,12,14,5,15,0,7,4,13,9,1,5,3,4,15,9,9,14,12) }, /* #15/3 */
    { 0x0076, 0x409d, 0x7800, RTFLOAT80U_INIT_C(1,0xb124dec29bcd9600,16439), RTPBCD80U_INIT_C(1,0,9,9,7,2,3,2,2,0,0,8,8,2,3,2,7,4,8) }, /* #16/0 */
    { 0x0476, 0x409d, 0x7800, RTFLOAT80U_INIT_C(1,0xb124dec29bcd9600,16439), RTPBCD80U_INIT_C(1,0,9,9,7,2,3,2,2,0,0,8,8,2,3,2,7,4,8) }, /* #16/1 */
    { 0x0876, 0x409d, 0x7800, RTFLOAT80U_INIT_C(1,0xb124dec29bcd9600,16439), RTPBCD80U_INIT_C(1,0,9,9,7,2,3,2,2,0,0,8,8,2,3,2,7,4,8) }, /* #16/2 */
    { 0x0c76, 0x409d, 0x7800, RTFLOAT80U_INIT_C(1,0xb124dec29bcd9600,16439), RTPBCD80U_INIT_C(1,0,9,9,7,2,3,2,2,0,0,8,8,2,3,2,7,4,8) }, /* #16/3 */
    { 0x0021, 0xc52d, 0x7d00, RTFLOAT80U_INIT_C(0,0x813c808a28065940,16442), RTPBCD80U_INIT_C(0,5,8,2,0,2,8,7,1,6,2,7,2,5,4,3,1,2,4) }, /* #17/0 */
    { 0x0421, 0xc52d, 0x7d00, RTFLOAT80U_INIT_C(0,0x813c808a28065940,16442), RTPBCD80U_INIT_C(0,5,8,2,0,2,8,7,1,6,2,7,2,5,4,3,1,2,4) }, /* #17/1 */
    { 0x0821, 0xc52d, 0x7d00, RTFLOAT80U_INIT_C(0,0x813c808a28065940,16442), RTPBCD80U_INIT_C(0,5,8,2,0,2,8,7,1,6,2,7,2,5,4,3,1,2,4) }, /* #17/2 */
    { 0x0c21, 0xc52d, 0x7d00, RTFLOAT80U_INIT_C(0,0x813c808a28065940,16442), RTPBCD80U_INIT_C(0,5,8,2,0,2,8,7,1,6,2,7,2,5,4,3,1,2,4) }, /* #17/3 */
    { 0x0068, 0xc975, 0x7900, RTFLOAT80U_INIT_C(1,0x8cd6b6a1487c5020,16441), RTPBCD80U_INIT_C(1,3,1,7,1,4,0,6,1,2,9,4,2,1,2,7,7,4,5) }, /* #18/0 */
    { 0x0468, 0xc975, 0x7900, RTFLOAT80U_INIT_C(1,0x8cd6b6a1487c5020,16441), RTPBCD80U_INIT_C(1,3,1,7,1,4,0,6,1,2,9,4,2,1,2,7,7,4,5) }, /* #18/1 */
    { 0x0868, 0xc975, 0x7900, RTFLOAT80U_INIT_C(1,0x8cd6b6a1487c5020,16441), RTPBCD80U_INIT_C(1,3,1,7,1,4,0,6,1,2,9,4,2,1,2,7,7,4,5) }, /* #18/2 */
    { 0x0c68, 0xc975, 0x7900, RTFLOAT80U_INIT_C(1,0x8cd6b6a1487c5020,16441), RTPBCD80U_INIT_C(1,3,1,7,1,4,0,6,1,2,9,4,2,1,2,7,7,4,5) }, /* #18/3 */
    { 0x0142, 0x39e6, 0x3900, RTFLOAT80U_INIT_C(0,0xa17dc0286f5bce00,16438), RTPBCD80U_INIT_C(0,0,4,5,4,5,5,7,3,5,5,1,5,9,9,5,0,8,6) }, /* #19/0 */
    { 0x0542, 0x39e6, 0x3900, RTFLOAT80U_INIT_C(0,0xa17dc0286f5bce00,16438), RTPBCD80U_INIT_C(0,0,4,5,4,5,5,7,3,5,5,1,5,9,9,5,0,8,6) }, /* #19/1 */
    { 0x0942, 0x39e6, 0x3900, RTFLOAT80U_INIT_C(0,0xa17dc0286f5bce00,16438), RTPBCD80U_INIT_C(0,0,4,5,4,5,5,7,3,5,5,1,5,9,9,5,0,8,6) }, /* #19/2 */
    { 0x0d42, 0x39e6, 0x3900, RTFLOAT80U_INIT_C(0,0xa17dc0286f5bce00,16438), RTPBCD80U_INIT_C(0,0,4,5,4,5,5,7,3,5,5,1,5,9,9,5,0,8,6) }, /* #19/3 */
    { 0x012d, 0xd536, 0x7d00, RTFLOAT80U_INIT_C(0,0xabec5ee9e7421f80,16439), RTPBCD80U_INIT_C(0,0,9,6,7,8,4,2,2,6,8,2,5,7,0,0,4,1,5) }, /* #20/0 */
    { 0x052d, 0xd536, 0x7d00, RTFLOAT80U_INIT_C(0,0xabec5ee9e7421f80,16439), RTPBCD80U_INIT_C(0,0,9,6,7,8,4,2,2,6,8,2,5,7,0,0,4,1,5) }, /* #20/1 */
    { 0x092d, 0xd536, 0x7d00, RTFLOAT80U_INIT_C(0,0xabec5ee9e7421f80,16439), RTPBCD80U_INIT_C(0,0,9,6,7,8,4,2,2,6,8,2,5,7,0,0,4,1,5) }, /* #20/2 */
    { 0x0d2d, 0xd536, 0x7d00, RTFLOAT80U_INIT_C(0,0xabec5ee9e7421f80,16439), RTPBCD80U_INIT_C(0,0,9,6,7,8,4,2,2,6,8,2,5,7,0,0,4,1,5) }, /* #20/3 */
    { 0x000d, 0x5fb4, 0x7d00, RTFLOAT80U_INIT_C(1,0xbf25fb792e638b20,16441), RTPBCD80U_INIT_C(1,4,3,0,4,2,7,8,6,0,4,1,4,7,0,0,6,3,3) }, /* #21/0 */
    { 0x040d, 0x5fb4, 0x7d00, RTFLOAT80U_INIT_C(1,0xbf25fb792e638b20,16441), RTPBCD80U_INIT_C(1,4,3,0,4,2,7,8,6,0,4,1,4,7,0,0,6,3,3) }, /* #21/1 */
    { 0x080d, 0x5fb4, 0x7d00, RTFLOAT80U_INIT_C(1,0xbf25fb792e638b20,16441), RTPBCD80U_INIT_C(1,4,3,0,4,2,7,8,6,0,4,1,4,7,0,0,6,3,3) }, /* #21/2 */
    { 0x0c0d, 0x5fb4, 0x7d00, RTFLOAT80U_INIT_C(1,0xbf25fb792e638b20,16441), RTPBCD80U_INIT_C(1,4,3,0,4,2,7,8,6,0,4,1,4,7,0,0,6,3,3) }, /* #21/3 */
    { 0x0109, 0x05be, 0x3d00, RTFLOAT80U_INIT_C(0,0x9716c4a9f8476160,16441), RTPBCD80U_INIT_C(0,2,13,9,11,11,11,9,13,12,12,2,14,6,4,6,7,9,5) }, /* #22/0 */
    { 0x0509, 0x05be, 0x3d00, RTFLOAT80U_INIT_C(0,0x9716c4a9f8476160,16441), RTPBCD80U_INIT_C(0,2,13,9,11,11,11,9,13,12,12,2,14,6,4,6,7,9,5) }, /* #22/1 */
    { 0x0909, 0x05be, 0x3d00, RTFLOAT80U_INIT_C(0,0x9716c4a9f8476160,16441), RTPBCD80U_INIT_C(0,2,13,9,11,11,11,9,13,12,12,2,14,6,4,6,7,9,5) }, /* #22/2 */
    { 0x0d09, 0x05be, 0x3d00, RTFLOAT80U_INIT_C(0,0x9716c4a9f8476160,16441), RTPBCD80U_INIT_C(0,2,13,9,11,11,11,9,13,12,12,2,14,6,4,6,7,9,5) }, /* #22/3 */
    { 0x024b, 0x97eb, 0x3d00, RTFLOAT80U_INIT_C(1,0x857bd2a85ecc3b28,16443), RTPBCD80U_INIT_EX_C(0x7f,1,11,9,11,12,11,4,1,2,10,11,11,10,7,11,15,9,5,7) }, /* #23/0 */
    { 0x064b, 0x97eb, 0x3d00, RTFLOAT80U_INIT_C(1,0x857bd2a85ecc3b28,16443), RTPBCD80U_INIT_EX_C(0x7f,1,11,9,11,12,11,4,1,2,10,11,11,10,7,11,15,9,5,7) }, /* #23/1 */
    { 0x0a4b, 0x97eb, 0x3d00, RTFLOAT80U_INIT_C(1,0x857bd2a85ecc3b28,16443), RTPBCD80U_INIT_EX_C(0x7f,1,11,9,11,12,11,4,1,2,10,11,11,10,7,11,15,9,5,7) }, /* #23/2 */
    { 0x0e4b, 0x97eb, 0x3d00, RTFLOAT80U_INIT_C(1,0x857bd2a85ecc3b28,16443), RTPBCD80U_INIT_EX_C(0x7f,1,11,9,11,12,11,4,1,2,10,11,11,10,7,11,15,9,5,7) }, /* #23/3 */
    { 0x0108, 0xed37, 0x7d00, RTFLOAT80U_INIT_C(0,0xc34f797bad5e9ee0,16442), RTPBCD80U_INIT_C(0,8,7,9,6,0,0,0,5,8,2,9,0,7,9,2,9,4,2) }, /* #24/0 */
    { 0x0508, 0xed37, 0x7d00, RTFLOAT80U_INIT_C(0,0xc34f797bad5e9ee0,16442), RTPBCD80U_INIT_C(0,8,7,9,6,0,0,0,5,8,2,9,0,7,9,2,9,4,2) }, /* #24/1 */
    { 0x0908, 0xed37, 0x7d00, RTFLOAT80U_INIT_C(0,0xc34f797bad5e9ee0,16442), RTPBCD80U_INIT_C(0,8,7,9,6,0,0,0,5,8,2,9,0,7,9,2,9,4,2) }, /* #24/2 */
    { 0x0d08, 0xed37, 0x7d00, RTFLOAT80U_INIT_C(0,0xc34f797bad5e9ee0,16442), RTPBCD80U_INIT_C(0,8,7,9,6,0,0,0,5,8,2,9,0,7,9,2,9,4,2) }, /* #24/3 */
    { 0x0226, 0x16ea, 0x3c00, RTFLOAT80U_INIT_C(0,0xd8688b692bab9eb0,16442), RTPBCD80U_INIT_C(0,9,7,4,6,1,6,6,8,7,0,9,9,4,2,7,3,0,7) }, /* #25/0 */
    { 0x0626, 0x16ea, 0x3c00, RTFLOAT80U_INIT_C(0,0xd8688b692bab9eb0,16442), RTPBCD80U_INIT_C(0,9,7,4,6,1,6,6,8,7,0,9,9,4,2,7,3,0,7) }, /* #25/1 */
    { 0x0a26, 0x16ea, 0x3c00, RTFLOAT80U_INIT_C(0,0xd8688b692bab9eb0,16442), RTPBCD80U_INIT_C(0,9,7,4,6,1,6,6,8,7,0,9,9,4,2,7,3,0,7) }, /* #25/2 */
    { 0x0e26, 0x16ea, 0x3c00, RTFLOAT80U_INIT_C(0,0xd8688b692bab9eb0,16442), RTPBCD80U_INIT_C(0,9,7,4,6,1,6,6,8,7,0,9,9,4,2,7,3,0,7) }, /* #25/3 */
    { 0x0043, 0xfec0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8331ca392f0a3700,16441), RTPBCD80U_INIT_C(1,2,9,5,4,2,3,7,3,2,4,9,3,0,7,8,9,6,8) }, /* #26/0 */
    { 0x0443, 0xfec0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8331ca392f0a3700,16441), RTPBCD80U_INIT_C(1,2,9,5,4,2,3,7,3,2,4,9,3,0,7,8,9,6,8) }, /* #26/1 */
    { 0x0843, 0xfec0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8331ca392f0a3700,16441), RTPBCD80U_INIT_C(1,2,9,5,4,2,3,7,3,2,4,9,3,0,7,8,9,6,8) }, /* #26/2 */
    { 0x0c43, 0xfec0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8331ca392f0a3700,16441), RTPBCD80U_INIT_C(1,2,9,5,4,2,3,7,3,2,4,9,3,0,7,8,9,6,8) }, /* #26/3 */
    { 0x011f, 0x8d11, 0x3d00, RTFLOAT80U_INIT_C(0,0xc20f99f3afe788f0,16442), RTPBCD80U_INIT_C(0,8,7,3,9,7,2,7,8,9,9,9,4,7,4,8,0,4,7) }, /* #27/0 */
    { 0x051f, 0x8d11, 0x3d00, RTFLOAT80U_INIT_C(0,0xc20f99f3afe788f0,16442), RTPBCD80U_INIT_C(0,8,7,3,9,7,2,7,8,9,9,9,4,7,4,8,0,4,7) }, /* #27/1 */
    { 0x091f, 0x8d11, 0x3d00, RTFLOAT80U_INIT_C(0,0xc20f99f3afe788f0,16442), RTPBCD80U_INIT_C(0,8,7,3,9,7,2,7,8,9,9,9,4,7,4,8,0,4,7) }, /* #27/2 */
    { 0x0d1f, 0x8d11, 0x3d00, RTFLOAT80U_INIT_C(0,0xc20f99f3afe788f0,16442), RTPBCD80U_INIT_C(0,8,7,3,9,7,2,7,8,9,9,9,4,7,4,8,0,4,7) }, /* #27/3 */
    { 0x0061, 0x4f58, 0x7d00, RTFLOAT80U_INIT_C(0,0xb7734fb13b354320,16442), RTPBCD80U_INIT_C(0,8,2,6,1,8,7,3,0,9,6,1,7,7,3,0,6,1,0) }, /* #28/0 */
    { 0x0461, 0x4f58, 0x7d00, RTFLOAT80U_INIT_C(0,0xb7734fb13b354320,16442), RTPBCD80U_INIT_C(0,8,2,6,1,8,7,3,0,9,6,1,7,7,3,0,6,1,0) }, /* #28/1 */
    { 0x0861, 0x4f58, 0x7d00, RTFLOAT80U_INIT_C(0,0xb7734fb13b354320,16442), RTPBCD80U_INIT_C(0,8,2,6,1,8,7,3,0,9,6,1,7,7,3,0,6,1,0) }, /* #28/2 */
    { 0x0c61, 0x4f58, 0x7d00, RTFLOAT80U_INIT_C(0,0xb7734fb13b354320,16442), RTPBCD80U_INIT_C(0,8,2,6,1,8,7,3,0,9,6,1,7,7,3,0,6,1,0) }, /* #28/3 */
    { 0x0319, 0xf90b, 0x7900, RTFLOAT80U_INIT_C(1,0x9fb81cb039628b20,16441), RTPBCD80U_INIT_C(1,3,5,9,6,5,5,6,3,7,2,1,7,1,2,1,3,6,9) }, /* #29/0 */
    { 0x0719, 0xf90b, 0x7900, RTFLOAT80U_INIT_C(1,0x9fb81cb039628b20,16441), RTPBCD80U_INIT_C(1,3,5,9,6,5,5,6,3,7,2,1,7,1,2,1,3,6,9) }, /* #29/1 */
    { 0x0b19, 0xf90b, 0x7900, RTFLOAT80U_INIT_C(1,0x9fb81cb039628b20,16441), RTPBCD80U_INIT_C(1,3,5,9,6,5,5,6,3,7,2,1,7,1,2,1,3,6,9) }, /* #29/2 */
    { 0x0f19, 0xf90b, 0x7900, RTFLOAT80U_INIT_C(1,0x9fb81cb039628b20,16441), RTPBCD80U_INIT_C(1,3,5,9,6,5,5,6,3,7,2,1,7,1,2,1,3,6,9) }, /* #29/3 */
    { 0x0125, 0xa0d5, 0x3800, RTFLOAT80U_INIT_C(1,0xf8cc75fbc309e3b0,16442), RTPBCD80U_INIT_C(1,10,12,0,4,8,8,15,11,10,13,0,1,5,3,4,2,6,7) }, /* #30/0 */
    { 0x0525, 0xa0d5, 0x3800, RTFLOAT80U_INIT_C(1,0xf8cc75fbc309e3b0,16442), RTPBCD80U_INIT_C(1,10,12,0,4,8,8,15,11,10,13,0,1,5,3,4,2,6,7) }, /* #30/1 */
    { 0x0925, 0xa0d5, 0x3800, RTFLOAT80U_INIT_C(1,0xf8cc75fbc309e3b0,16442), RTPBCD80U_INIT_C(1,10,12,0,4,8,8,15,11,10,13,0,1,5,3,4,2,6,7) }, /* #30/2 */
    { 0x0d25, 0xa0d5, 0x3800, RTFLOAT80U_INIT_C(1,0xf8cc75fbc309e3b0,16442), RTPBCD80U_INIT_C(1,10,12,0,4,8,8,15,11,10,13,0,1,5,3,4,2,6,7) }, /* #30/3 */
    { 0x0310, 0x66ef, 0x7c00, RTFLOAT80U_INIT_C(1,0xceab91040375e1a0,16442), RTPBCD80U_INIT_EX_C(0x26,1,8,13,0,6,15,9,6,15,1,13,15,2,13,10,13,14,2,6) }, /* #31/0 */
    { 0x0710, 0x66ef, 0x7c00, RTFLOAT80U_INIT_C(1,0xceab91040375e1a0,16442), RTPBCD80U_INIT_EX_C(0x26,1,8,13,0,6,15,9,6,15,1,13,15,2,13,10,13,14,2,6) }, /* #31/1 */
    { 0x0b10, 0x66ef, 0x7c00, RTFLOAT80U_INIT_C(1,0xceab91040375e1a0,16442), RTPBCD80U_INIT_EX_C(0x26,1,8,13,0,6,15,9,6,15,1,13,15,2,13,10,13,14,2,6) }, /* #31/2 */
    { 0x0f10, 0x66ef, 0x7c00, RTFLOAT80U_INIT_C(1,0xceab91040375e1a0,16442), RTPBCD80U_INIT_EX_C(0x26,1,8,13,0,6,15,9,6,15,1,13,15,2,13,10,13,14,2,6) }, /* #31/3 */
    { 0x0247, 0x7e0d, 0x7c00, RTFLOAT80U_INIT_C(0,0xd06c6a7419e21440,16440), RTPBCD80U_INIT_C(0,2,3,4,6,6,3,9,9,8,5,0,4,0,1,1,8,5,7) }, /* #32/0 */
    { 0x0647, 0x7e0d, 0x7c00, RTFLOAT80U_INIT_C(0,0xd06c6a7419e21440,16440), RTPBCD80U_INIT_C(0,2,3,4,6,6,3,9,9,8,5,0,4,0,1,1,8,5,7) }, /* #32/1 */
    { 0x0a47, 0x7e0d, 0x7c00, RTFLOAT80U_INIT_C(0,0xd06c6a7419e21440,16440), RTPBCD80U_INIT_C(0,2,3,4,6,6,3,9,9,8,5,0,4,0,1,1,8,5,7) }, /* #32/2 */
    { 0x0e47, 0x7e0d, 0x7c00, RTFLOAT80U_INIT_C(0,0xd06c6a7419e21440,16440), RTPBCD80U_INIT_C(0,2,3,4,6,6,3,9,9,8,5,0,4,0,1,1,8,5,7) }, /* #32/3 */
    { 0x0211, 0xbcac, 0x3c00, RTFLOAT80U_INIT_C(0,0xf6d9532ee4e02040,16441), RTPBCD80U_INIT_C(0,5,5,5,8,5,4,3,6,4,5,0,4,6,8,6,8,5,0) }, /* #33/0 */
    { 0x0611, 0xbcac, 0x3c00, RTFLOAT80U_INIT_C(0,0xf6d9532ee4e02040,16441), RTPBCD80U_INIT_C(0,5,5,5,8,5,4,3,6,4,5,0,4,6,8,6,8,5,0) }, /* #33/1 */
    { 0x0a11, 0xbcac, 0x3c00, RTFLOAT80U_INIT_C(0,0xf6d9532ee4e02040,16441), RTPBCD80U_INIT_C(0,5,5,5,8,5,4,3,6,4,5,0,4,6,8,6,8,5,0) }, /* #33/2 */
    { 0x0e11, 0xbcac, 0x3c00, RTFLOAT80U_INIT_C(0,0xf6d9532ee4e02040,16441), RTPBCD80U_INIT_C(0,5,5,5,8,5,4,3,6,4,5,0,4,6,8,6,8,5,0) }, /* #33/3 */
    { 0x0276, 0x33f2, 0x3900, RTFLOAT80U_INIT_C(0,0xe912cb3a4448d340,16441), RTPBCD80U_INIT_C(0,5,2,4,8,3,4,6,6,9,1,1,0,3,8,0,1,8,6) }, /* #34/0 */
    { 0x0676, 0x33f2, 0x3900, RTFLOAT80U_INIT_C(0,0xe912cb3a4448d340,16441), RTPBCD80U_INIT_C(0,5,2,4,8,3,4,6,6,9,1,1,0,3,8,0,1,8,6) }, /* #34/1 */
    { 0x0a76, 0x33f2, 0x3900, RTFLOAT80U_INIT_C(0,0xe912cb3a4448d340,16441), RTPBCD80U_INIT_C(0,5,2,4,8,3,4,6,6,9,1,1,0,3,8,0,1,8,6) }, /* #34/2 */
    { 0x0e76, 0x33f2, 0x3900, RTFLOAT80U_INIT_C(0,0xe912cb3a4448d340,16441), RTPBCD80U_INIT_C(0,5,2,4,8,3,4,6,6,9,1,1,0,3,8,0,1,8,6) }, /* #34/3 */
    { 0x0152, 0x2192, 0x3900, RTFLOAT80U_INIT_C(1,0x8b698a67de3b4400,16436), RTPBCD80U_INIT_C(1,0,0,9,8,1,0,2,6,6,2,3,2,9,5,0,4,8,1) }, /* #35/0 */
    { 0x0552, 0x2192, 0x3900, RTFLOAT80U_INIT_C(1,0x8b698a67de3b4400,16436), RTPBCD80U_INIT_C(1,0,0,9,8,1,0,2,6,6,2,3,2,9,5,0,4,8,1) }, /* #35/1 */
    { 0x0952, 0x2192, 0x3900, RTFLOAT80U_INIT_C(1,0x8b698a67de3b4400,16436), RTPBCD80U_INIT_C(1,0,0,9,8,1,0,2,6,6,2,3,2,9,5,0,4,8,1) }, /* #35/2 */
    { 0x0d52, 0x2192, 0x3900, RTFLOAT80U_INIT_C(1,0x8b698a67de3b4400,16436), RTPBCD80U_INIT_C(1,0,0,9,8,1,0,2,6,6,2,3,2,9,5,0,4,8,1) }, /* #35/3 */
    { 0x0226, 0xb7d3, 0x3d00, RTFLOAT80U_INIT_C(1,0xc160ce2db2710e20,16441), RTPBCD80U_INIT_C(1,4,3,5,4,4,8,8,7,3,2,1,0,8,4,1,2,0,1) }, /* #36/0 */
    { 0x0626, 0xb7d3, 0x3d00, RTFLOAT80U_INIT_C(1,0xc160ce2db2710e20,16441), RTPBCD80U_INIT_C(1,4,3,5,4,4,8,8,7,3,2,1,0,8,4,1,2,0,1) }, /* #36/1 */
    { 0x0a26, 0xb7d3, 0x3d00, RTFLOAT80U_INIT_C(1,0xc160ce2db2710e20,16441), RTPBCD80U_INIT_C(1,4,3,5,4,4,8,8,7,3,2,1,0,8,4,1,2,0,1) }, /* #36/2 */
    { 0x0e26, 0xb7d3, 0x3d00, RTFLOAT80U_INIT_C(1,0xc160ce2db2710e20,16441), RTPBCD80U_INIT_C(1,4,3,5,4,4,8,8,7,3,2,1,0,8,4,1,2,0,1) }, /* #36/3 */
    { 0x012f, 0x458c, 0x7d00, RTFLOAT80U_INIT_C(1,0x9df28cbfcc3b7040,16442), RTPBCD80U_INIT_C(1,7,1,1,3,3,2,1,2,2,7,3,1,9,8,4,6,4,4) }, /* #37/0 */
    { 0x052f, 0x458c, 0x7d00, RTFLOAT80U_INIT_C(1,0x9df28cbfcc3b7040,16442), RTPBCD80U_INIT_C(1,7,1,1,3,3,2,1,2,2,7,3,1,9,8,4,6,4,4) }, /* #37/1 */
    { 0x092f, 0x458c, 0x7d00, RTFLOAT80U_INIT_C(1,0x9df28cbfcc3b7040,16442), RTPBCD80U_INIT_C(1,7,1,1,3,3,2,1,2,2,7,3,1,9,8,4,6,4,4) }, /* #37/2 */
    { 0x0d2f, 0x458c, 0x7d00, RTFLOAT80U_INIT_C(1,0x9df28cbfcc3b7040,16442), RTPBCD80U_INIT_C(1,7,1,1,3,3,2,1,2,2,7,3,1,9,8,4,6,4,4) }, /* #37/3 */
    { 0x0071, 0x1be8, 0x3900, RTFLOAT80U_INIT_C(0,0xfaf5664ce503de40,16441), RTPBCD80U_INIT_C(0,4,15,15,1,0,8,5,0,10,12,2,5,6,8,3,6,9,8) }, /* #38/0 */
    { 0x0471, 0x1be8, 0x3900, RTFLOAT80U_INIT_C(0,0xfaf5664ce503de40,16441), RTPBCD80U_INIT_C(0,4,15,15,1,0,8,5,0,10,12,2,5,6,8,3,6,9,8) }, /* #38/1 */
    { 0x0871, 0x1be8, 0x3900, RTFLOAT80U_INIT_C(0,0xfaf5664ce503de40,16441), RTPBCD80U_INIT_C(0,4,15,15,1,0,8,5,0,10,12,2,5,6,8,3,6,9,8) }, /* #38/2 */
    { 0x0c71, 0x1be8, 0x3900, RTFLOAT80U_INIT_C(0,0xfaf5664ce503de40,16441), RTPBCD80U_INIT_C(0,4,15,15,1,0,8,5,0,10,12,2,5,6,8,3,6,9,8) }, /* #38/3 */
    { 0x0029, 0x2f83, 0x3d00, RTFLOAT80U_INIT_C(0,0x924726402d6fd668,16443), RTPBCD80U_INIT_EX_C(0x33,0,12,11,7,5,5,4,4,3,8,6,14,5,7,4,10,1,11,11) }, /* #39/0 */
    { 0x0429, 0x2f83, 0x3d00, RTFLOAT80U_INIT_C(0,0x924726402d6fd668,16443), RTPBCD80U_INIT_EX_C(0x33,0,12,11,7,5,5,4,4,3,8,6,14,5,7,4,10,1,11,11) }, /* #39/1 */
    { 0x0829, 0x2f83, 0x3d00, RTFLOAT80U_INIT_C(0,0x924726402d6fd668,16443), RTPBCD80U_INIT_EX_C(0x33,0,12,11,7,5,5,4,4,3,8,6,14,5,7,4,10,1,11,11) }, /* #39/2 */
    { 0x0c29, 0x2f83, 0x3d00, RTFLOAT80U_INIT_C(0,0x924726402d6fd668,16443), RTPBCD80U_INIT_EX_C(0x33,0,12,11,7,5,5,4,4,3,8,6,14,5,7,4,10,1,11,11) }, /* #39/3 */
    { 0x0320, 0xdfe7, 0x7d00, RTFLOAT80U_INIT_C(0,0xd3bb059cd0be1e50,16442), RTPBCD80U_INIT_C(0,9,5,3,5,4,9,6,4,5,8,5,7,6,7,7,7,9,7) }, /* #40/0 */
    { 0x0720, 0xdfe7, 0x7d00, RTFLOAT80U_INIT_C(0,0xd3bb059cd0be1e50,16442), RTPBCD80U_INIT_C(0,9,5,3,5,4,9,6,4,5,8,5,7,6,7,7,7,9,7) }, /* #40/1 */
    { 0x0b20, 0xdfe7, 0x7d00, RTFLOAT80U_INIT_C(0,0xd3bb059cd0be1e50,16442), RTPBCD80U_INIT_C(0,9,5,3,5,4,9,6,4,5,8,5,7,6,7,7,7,9,7) }, /* #40/2 */
    { 0x0f20, 0xdfe7, 0x7d00, RTFLOAT80U_INIT_C(0,0xd3bb059cd0be1e50,16442), RTPBCD80U_INIT_C(0,9,5,3,5,4,9,6,4,5,8,5,7,6,7,7,7,9,7) }, /* #40/3 */
    { 0x0331, 0xb929, 0x3900, RTFLOAT80U_INIT_C(0,0xdd8a1250a74db2e0,16442), RTPBCD80U_INIT_C(0,9,9,7,7,2,4,4,9,7,9,2,3,8,5,7,1,9,8) }, /* #41/0 */
    { 0x0731, 0xb929, 0x3900, RTFLOAT80U_INIT_C(0,0xdd8a1250a74db2e0,16442), RTPBCD80U_INIT_C(0,9,9,7,7,2,4,4,9,7,9,2,3,8,5,7,1,9,8) }, /* #41/1 */
    { 0x0b31, 0xb929, 0x3900, RTFLOAT80U_INIT_C(0,0xdd8a1250a74db2e0,16442), RTPBCD80U_INIT_C(0,9,9,7,7,2,4,4,9,7,9,2,3,8,5,7,1,9,8) }, /* #41/2 */
    { 0x0f31, 0xb929, 0x3900, RTFLOAT80U_INIT_C(0,0xdd8a1250a74db2e0,16442), RTPBCD80U_INIT_C(0,9,9,7,7,2,4,4,9,7,9,2,3,8,5,7,1,9,8) }, /* #41/3 */
    { 0x0321, 0x2d45, 0x3d00, RTFLOAT80U_INIT_C(0,0xd4ba2926f316a640,16440), RTPBCD80U_INIT_C(0,2,3,9,5,0,9,5,2,3,8,9,0,1,9,9,1,9,3) }, /* #42/0 */
    { 0x0721, 0x2d45, 0x3d00, RTFLOAT80U_INIT_C(0,0xd4ba2926f316a640,16440), RTPBCD80U_INIT_C(0,2,3,9,5,0,9,5,2,3,8,9,0,1,9,9,1,9,3) }, /* #42/1 */
    { 0x0b21, 0x2d45, 0x3d00, RTFLOAT80U_INIT_C(0,0xd4ba2926f316a640,16440), RTPBCD80U_INIT_C(0,2,3,9,5,0,9,5,2,3,8,9,0,1,9,9,1,9,3) }, /* #42/2 */
    { 0x0f21, 0x2d45, 0x3d00, RTFLOAT80U_INIT_C(0,0xd4ba2926f316a640,16440), RTPBCD80U_INIT_C(0,2,3,9,5,0,9,5,2,3,8,9,0,1,9,9,1,9,3) }, /* #42/3 */
    { 0x003a, 0xa200, 0x3800, RTFLOAT80U_INIT_C(0,0x99c2da9d7a896c50,16442), RTPBCD80U_INIT_C(0,6,9,2,4,7,8,6,5,0,1,9,9,0,8,6,7,8,9) }, /* #43/0 */
    { 0x043a, 0xa200, 0x3800, RTFLOAT80U_INIT_C(0,0x99c2da9d7a896c50,16442), RTPBCD80U_INIT_C(0,6,9,2,4,7,8,6,5,0,1,9,9,0,8,6,7,8,9) }, /* #43/1 */
    { 0x083a, 0xa200, 0x3800, RTFLOAT80U_INIT_C(0,0x99c2da9d7a896c50,16442), RTPBCD80U_INIT_C(0,6,9,2,4,7,8,6,5,0,1,9,9,0,8,6,7,8,9) }, /* #43/2 */
    { 0x0c3a, 0xa200, 0x3800, RTFLOAT80U_INIT_C(0,0x99c2da9d7a896c50,16442), RTPBCD80U_INIT_C(0,6,9,2,4,7,8,6,5,0,1,9,9,0,8,6,7,8,9) }, /* #43/3 */
    { 0x003a, 0x97dc, 0x3d00, RTFLOAT80U_INIT_C(0,0xa17b95c8d3da5f70,16442), RTPBCD80U_INIT_C(0,7,2,7,2,5,3,6,7,2,0,0,1,3,8,1,8,7,9) }, /* #44/0 */
    { 0x043a, 0x97dc, 0x3d00, RTFLOAT80U_INIT_C(0,0xa17b95c8d3da5f70,16442), RTPBCD80U_INIT_C(0,7,2,7,2,5,3,6,7,2,0,0,1,3,8,1,8,7,9) }, /* #44/1 */
    { 0x083a, 0x97dc, 0x3d00, RTFLOAT80U_INIT_C(0,0xa17b95c8d3da5f70,16442), RTPBCD80U_INIT_C(0,7,2,7,2,5,3,6,7,2,0,0,1,3,8,1,8,7,9) }, /* #44/2 */
    { 0x0c3a, 0x97dc, 0x3d00, RTFLOAT80U_INIT_C(0,0xa17b95c8d3da5f70,16442), RTPBCD80U_INIT_C(0,7,2,7,2,5,3,6,7,2,0,0,1,3,8,1,8,7,9) }, /* #44/3 */
    { 0x0026, 0xd4a0, 0x7c00, RTFLOAT80U_INIT_C(1,0xfd584f34eaa96000,16437), RTPBCD80U_INIT_C(1,0,3,5,6,5,5,1,3,3,1,6,0,6,2,5,3,2,8) }, /* #45/0 */
    { 0x0426, 0xd4a0, 0x7c00, RTFLOAT80U_INIT_C(1,0xfd584f34eaa96000,16437), RTPBCD80U_INIT_C(1,0,3,5,6,5,5,1,3,3,1,6,0,6,2,5,3,2,8) }, /* #45/1 */
    { 0x0826, 0xd4a0, 0x7c00, RTFLOAT80U_INIT_C(1,0xfd584f34eaa96000,16437), RTPBCD80U_INIT_C(1,0,3,5,6,5,5,1,3,3,1,6,0,6,2,5,3,2,8) }, /* #45/2 */
    { 0x0c26, 0xd4a0, 0x7c00, RTFLOAT80U_INIT_C(1,0xfd584f34eaa96000,16437), RTPBCD80U_INIT_C(1,0,3,5,6,5,5,1,3,3,1,6,0,6,2,5,3,2,8) }, /* #45/3 */
    { 0x032d, 0x5240, 0x7800, RTFLOAT80U_INIT_C(1,0xfa099df1eeacd600,16440), RTPBCD80U_INIT_C(1,2,8,0,14,11,6,12,7,2,5,9,14,4,12,0,12,9,14) }, /* #46/0 */
    { 0x072d, 0x5240, 0x7800, RTFLOAT80U_INIT_C(1,0xfa099df1eeacd600,16440), RTPBCD80U_INIT_C(1,2,8,0,14,11,6,12,7,2,5,9,14,4,12,0,12,9,14) }, /* #46/1 */
    { 0x0b2d, 0x5240, 0x7800, RTFLOAT80U_INIT_C(1,0xfa099df1eeacd600,16440), RTPBCD80U_INIT_C(1,2,8,0,14,11,6,12,7,2,5,9,14,4,12,0,12,9,14) }, /* #46/2 */
    { 0x0f2d, 0x5240, 0x7800, RTFLOAT80U_INIT_C(1,0xfa099df1eeacd600,16440), RTPBCD80U_INIT_C(1,2,8,0,14,11,6,12,7,2,5,9,14,4,12,0,12,9,14) }, /* #46/3 */
    { 0x012f, 0x4c38, 0x7c00, RTFLOAT80U_INIT_C(1,0x8174313ee40bd8c0,16440), RTPBCD80U_INIT_EX_C(0x14,1,0,13,15,7,4,12,1,0,7,3,11,2,0,10,7,1,0,7) }, /* #47/0 */
    { 0x052f, 0x4c38, 0x7c00, RTFLOAT80U_INIT_C(1,0x8174313ee40bd8c0,16440), RTPBCD80U_INIT_EX_C(0x14,1,0,13,15,7,4,12,1,0,7,3,11,2,0,10,7,1,0,7) }, /* #47/1 */
    { 0x092f, 0x4c38, 0x7c00, RTFLOAT80U_INIT_C(1,0x8174313ee40bd8c0,16440), RTPBCD80U_INIT_EX_C(0x14,1,0,13,15,7,4,12,1,0,7,3,11,2,0,10,7,1,0,7) }, /* #47/2 */
    { 0x0d2f, 0x4c38, 0x7c00, RTFLOAT80U_INIT_C(1,0x8174313ee40bd8c0,16440), RTPBCD80U_INIT_EX_C(0x14,1,0,13,15,7,4,12,1,0,7,3,11,2,0,10,7,1,0,7) }, /* #47/3 */
    { 0x001e, 0xbe31, 0x3c00, RTFLOAT80U_INIT_C(0,0xab43fd855cb9f220,16442), RTPBCD80U_INIT_C(0,7,7,1,3,1,1,6,3,4,5,7,2,0,9,1,1,7,0) }, /* #48/0 */
    { 0x041e, 0xbe31, 0x3c00, RTFLOAT80U_INIT_C(0,0xab43fd855cb9f220,16442), RTPBCD80U_INIT_C(0,7,7,1,3,1,1,6,3,4,5,7,2,0,9,1,1,7,0) }, /* #48/1 */
    { 0x081e, 0xbe31, 0x3c00, RTFLOAT80U_INIT_C(0,0xab43fd855cb9f220,16442), RTPBCD80U_INIT_C(0,7,7,1,3,1,1,6,3,4,5,7,2,0,9,1,1,7,0) }, /* #48/2 */
    { 0x0c1e, 0xbe31, 0x3c00, RTFLOAT80U_INIT_C(0,0xab43fd855cb9f220,16442), RTPBCD80U_INIT_C(0,7,7,1,3,1,1,6,3,4,5,7,2,0,9,1,1,7,0) }, /* #48/3 */
    { 0x015e, 0xff05, 0x7d00, RTFLOAT80U_INIT_C(1,0xc1c4cfaa9369f140,16442), RTPBCD80U_INIT_C(1,8,7,2,6,5,7,0,6,7,2,6,7,4,9,7,7,4,8) }, /* #49/0 */
    { 0x055e, 0xff05, 0x7d00, RTFLOAT80U_INIT_C(1,0xc1c4cfaa9369f140,16442), RTPBCD80U_INIT_C(1,8,7,2,6,5,7,0,6,7,2,6,7,4,9,7,7,4,8) }, /* #49/1 */
    { 0x095e, 0xff05, 0x7d00, RTFLOAT80U_INIT_C(1,0xc1c4cfaa9369f140,16442), RTPBCD80U_INIT_C(1,8,7,2,6,5,7,0,6,7,2,6,7,4,9,7,7,4,8) }, /* #49/2 */
    { 0x0d5e, 0xff05, 0x7d00, RTFLOAT80U_INIT_C(1,0xc1c4cfaa9369f140,16442), RTPBCD80U_INIT_C(1,8,7,2,6,5,7,0,6,7,2,6,7,4,9,7,7,4,8) }, /* #49/3 */
    { 0x0128, 0x7286, 0x7800, RTFLOAT80U_INIT_C(0,0xadd235d11e73c390,16442), RTPBCD80U_INIT_C(0,7,8,2,8,2,0,7,9,2,8,7,1,6,3,1,9,2,9) }, /* #50/0 */
    { 0x0528, 0x7286, 0x7800, RTFLOAT80U_INIT_C(0,0xadd235d11e73c390,16442), RTPBCD80U_INIT_C(0,7,8,2,8,2,0,7,9,2,8,7,1,6,3,1,9,2,9) }, /* #50/1 */
    { 0x0928, 0x7286, 0x7800, RTFLOAT80U_INIT_C(0,0xadd235d11e73c390,16442), RTPBCD80U_INIT_C(0,7,8,2,8,2,0,7,9,2,8,7,1,6,3,1,9,2,9) }, /* #50/2 */
    { 0x0d28, 0x7286, 0x7800, RTFLOAT80U_INIT_C(0,0xadd235d11e73c390,16442), RTPBCD80U_INIT_C(0,7,8,2,8,2,0,7,9,2,8,7,1,6,3,1,9,2,9) }, /* #50/3 */
    { 0x0250, 0x81a1, 0x3900, RTFLOAT80U_INIT_C(0,0x93926cce58ed7680,16441), RTPBCD80U_INIT_C(0,3,3,2,3,0,2,5,4,0,7,4,0,1,9,3,2,0,4) }, /* #51/0 */
    { 0x0650, 0x81a1, 0x3900, RTFLOAT80U_INIT_C(0,0x93926cce58ed7680,16441), RTPBCD80U_INIT_C(0,3,3,2,3,0,2,5,4,0,7,4,0,1,9,3,2,0,4) }, /* #51/1 */
    { 0x0a50, 0x81a1, 0x3900, RTFLOAT80U_INIT_C(0,0x93926cce58ed7680,16441), RTPBCD80U_INIT_C(0,3,3,2,3,0,2,5,4,0,7,4,0,1,9,3,2,0,4) }, /* #51/2 */
    { 0x0e50, 0x81a1, 0x3900, RTFLOAT80U_INIT_C(0,0x93926cce58ed7680,16441), RTPBCD80U_INIT_C(0,3,3,2,3,0,2,5,4,0,7,4,0,1,9,3,2,0,4) }, /* #51/3 */
    { 0x0218, 0xf975, 0x7900, RTFLOAT80U_INIT_C(0,0xb5f0f56e5e61ad80,16440), RTPBCD80U_INIT_C(0,2,0,4,8,4,7,6,3,0,7,7,5,8,4,6,5,8,2) }, /* #52/0 */
    { 0x0618, 0xf975, 0x7900, RTFLOAT80U_INIT_C(0,0xb5f0f56e5e61ad80,16440), RTPBCD80U_INIT_C(0,2,0,4,8,4,7,6,3,0,7,7,5,8,4,6,5,8,2) }, /* #52/1 */
    { 0x0a18, 0xf975, 0x7900, RTFLOAT80U_INIT_C(0,0xb5f0f56e5e61ad80,16440), RTPBCD80U_INIT_C(0,2,0,4,8,4,7,6,3,0,7,7,5,8,4,6,5,8,2) }, /* #52/2 */
    { 0x0e18, 0xf975, 0x7900, RTFLOAT80U_INIT_C(0,0xb5f0f56e5e61ad80,16440), RTPBCD80U_INIT_C(0,2,0,4,8,4,7,6,3,0,7,7,5,8,4,6,5,8,2) }, /* #52/3 */
    { 0x0157, 0xbd0d, 0x3d00, RTFLOAT80U_INIT_C(0,0xdd51e18312d6b880,16442), RTPBCD80U_INIT_C(0,9,9,6,7,3,5,9,8,1,7,8,5,5,4,1,5,1,2) }, /* #53/0 */
    { 0x0557, 0xbd0d, 0x3d00, RTFLOAT80U_INIT_C(0,0xdd51e18312d6b880,16442), RTPBCD80U_INIT_C(0,9,9,6,7,3,5,9,8,1,7,8,5,5,4,1,5,1,2) }, /* #53/1 */
    { 0x0957, 0xbd0d, 0x3d00, RTFLOAT80U_INIT_C(0,0xdd51e18312d6b880,16442), RTPBCD80U_INIT_C(0,9,9,6,7,3,5,9,8,1,7,8,5,5,4,1,5,1,2) }, /* #53/2 */
    { 0x0d57, 0xbd0d, 0x3d00, RTFLOAT80U_INIT_C(0,0xdd51e18312d6b880,16442), RTPBCD80U_INIT_C(0,9,9,6,7,3,5,9,8,1,7,8,5,5,4,1,5,1,2) }, /* #53/3 */
    { 0x0158, 0xbcb0, 0x3c00, RTFLOAT80U_INIT_C(1,0xe5af1bad9a862bc0,16440), RTPBCD80U_INIT_C(1,2,5,7,15,9,10,11,10,11,13,0,12,12,1,3,0,10,3) }, /* #54/0 */
    { 0x0558, 0xbcb0, 0x3c00, RTFLOAT80U_INIT_C(1,0xe5af1bad9a862bc0,16440), RTPBCD80U_INIT_C(1,2,5,7,15,9,10,11,10,11,13,0,12,12,1,3,0,10,3) }, /* #54/1 */
    { 0x0958, 0xbcb0, 0x3c00, RTFLOAT80U_INIT_C(1,0xe5af1bad9a862bc0,16440), RTPBCD80U_INIT_C(1,2,5,7,15,9,10,11,10,11,13,0,12,12,1,3,0,10,3) }, /* #54/2 */
    { 0x0d58, 0xbcb0, 0x3c00, RTFLOAT80U_INIT_C(1,0xe5af1bad9a862bc0,16440), RTPBCD80U_INIT_C(1,2,5,7,15,9,10,11,10,11,13,0,12,12,1,3,0,10,3) }, /* #54/3 */
    { 0x0169, 0x5c35, 0x7c00, RTFLOAT80U_INIT_C(1,0xe0b03584437489d0,16442), RTPBCD80U_INIT_EX_C(0x6d,1,9,11,1,8,10,6,1,11,8,8,10,10,12,8,6,13,14,13) }, /* #55/0 */
    { 0x0569, 0x5c35, 0x7c00, RTFLOAT80U_INIT_C(1,0xe0b03584437489d0,16442), RTPBCD80U_INIT_EX_C(0x6d,1,9,11,1,8,10,6,1,11,8,8,10,10,12,8,6,13,14,13) }, /* #55/1 */
    { 0x0969, 0x5c35, 0x7c00, RTFLOAT80U_INIT_C(1,0xe0b03584437489d0,16442), RTPBCD80U_INIT_EX_C(0x6d,1,9,11,1,8,10,6,1,11,8,8,10,10,12,8,6,13,14,13) }, /* #55/2 */
    { 0x0d69, 0x5c35, 0x7c00, RTFLOAT80U_INIT_C(1,0xe0b03584437489d0,16442), RTPBCD80U_INIT_EX_C(0x6d,1,9,11,1,8,10,6,1,11,8,8,10,10,12,8,6,13,14,13) }, /* #55/3 */
    { 0x0148, 0xaf80, 0x3d00, RTFLOAT80U_INIT_C(1,0xc2783ec7748daab0,16442), RTPBCD80U_INIT_C(1,8,7,5,8,1,3,7,0,4,1,8,3,6,3,4,6,0,3) }, /* #56/0 */
    { 0x0548, 0xaf80, 0x3d00, RTFLOAT80U_INIT_C(1,0xc2783ec7748daab0,16442), RTPBCD80U_INIT_C(1,8,7,5,8,1,3,7,0,4,1,8,3,6,3,4,6,0,3) }, /* #56/1 */
    { 0x0948, 0xaf80, 0x3d00, RTFLOAT80U_INIT_C(1,0xc2783ec7748daab0,16442), RTPBCD80U_INIT_C(1,8,7,5,8,1,3,7,0,4,1,8,3,6,3,4,6,0,3) }, /* #56/2 */
    { 0x0d48, 0xaf80, 0x3d00, RTFLOAT80U_INIT_C(1,0xc2783ec7748daab0,16442), RTPBCD80U_INIT_C(1,8,7,5,8,1,3,7,0,4,1,8,3,6,3,4,6,0,3) }, /* #56/3 */
    { 0x015d, 0xf157, 0x7900, RTFLOAT80U_INIT_C(1,0x8cb5ad31a9a5f300,16439), RTPBCD80U_INIT_C(1,0,7,9,2,1,2,5,0,4,4,1,3,3,2,6,3,1,0) }, /* #57/0 */
    { 0x055d, 0xf157, 0x7900, RTFLOAT80U_INIT_C(1,0x8cb5ad31a9a5f300,16439), RTPBCD80U_INIT_C(1,0,7,9,2,1,2,5,0,4,4,1,3,3,2,6,3,1,0) }, /* #57/1 */
    { 0x095d, 0xf157, 0x7900, RTFLOAT80U_INIT_C(1,0x8cb5ad31a9a5f300,16439), RTPBCD80U_INIT_C(1,0,7,9,2,1,2,5,0,4,4,1,3,3,2,6,3,1,0) }, /* #57/2 */
    { 0x0d5d, 0xf157, 0x7900, RTFLOAT80U_INIT_C(1,0x8cb5ad31a9a5f300,16439), RTPBCD80U_INIT_C(1,0,7,9,2,1,2,5,0,4,4,1,3,3,2,6,3,1,0) }, /* #57/3 */
    { 0x0155, 0x6177, 0x7900, RTFLOAT80U_INIT_C(1,0x89c1692ea3605ca0,16441), RTPBCD80U_INIT_C(1,3,1,0,1,9,7,8,3,4,4,6,0,3,6,5,5,4,1) }, /* #58/0 */
    { 0x0555, 0x6177, 0x7900, RTFLOAT80U_INIT_C(1,0x89c1692ea3605ca0,16441), RTPBCD80U_INIT_C(1,3,1,0,1,9,7,8,3,4,4,6,0,3,6,5,5,4,1) }, /* #58/1 */
    { 0x0955, 0x6177, 0x7900, RTFLOAT80U_INIT_C(1,0x89c1692ea3605ca0,16441), RTPBCD80U_INIT_C(1,3,1,0,1,9,7,8,3,4,4,6,0,3,6,5,5,4,1) }, /* #58/2 */
    { 0x0d55, 0x6177, 0x7900, RTFLOAT80U_INIT_C(1,0x89c1692ea3605ca0,16441), RTPBCD80U_INIT_C(1,3,1,0,1,9,7,8,3,4,4,6,0,3,6,5,5,4,1) }, /* #58/3 */
    { 0x026a, 0x5b83, 0x7900, RTFLOAT80U_INIT_C(0,0xac9a41db078f9970,16442), RTPBCD80U_INIT_C(0,7,7,7,3,3,2,8,5,8,1,1,9,8,4,6,2,9,5) }, /* #59/0 */
    { 0x066a, 0x5b83, 0x7900, RTFLOAT80U_INIT_C(0,0xac9a41db078f9970,16442), RTPBCD80U_INIT_C(0,7,7,7,3,3,2,8,5,8,1,1,9,8,4,6,2,9,5) }, /* #59/1 */
    { 0x0a6a, 0x5b83, 0x7900, RTFLOAT80U_INIT_C(0,0xac9a41db078f9970,16442), RTPBCD80U_INIT_C(0,7,7,7,3,3,2,8,5,8,1,1,9,8,4,6,2,9,5) }, /* #59/2 */
    { 0x0e6a, 0x5b83, 0x7900, RTFLOAT80U_INIT_C(0,0xac9a41db078f9970,16442), RTPBCD80U_INIT_C(0,7,7,7,3,3,2,8,5,8,1,1,9,8,4,6,2,9,5) }, /* #59/3 */
    { 0x0121, 0xb935, 0x3900, RTFLOAT80U_INIT_C(0,0x91cd22e56c8f3f40,16442), RTPBCD80U_INIT_C(0,6,5,6,6,3,0,7,4,2,1,5,5,5,8,8,5,9,6) }, /* #60/0 */
    { 0x0521, 0xb935, 0x3900, RTFLOAT80U_INIT_C(0,0x91cd22e56c8f3f40,16442), RTPBCD80U_INIT_C(0,6,5,6,6,3,0,7,4,2,1,5,5,5,8,8,5,9,6) }, /* #60/1 */
    { 0x0921, 0xb935, 0x3900, RTFLOAT80U_INIT_C(0,0x91cd22e56c8f3f40,16442), RTPBCD80U_INIT_C(0,6,5,6,6,3,0,7,4,2,1,5,5,5,8,8,5,9,6) }, /* #60/2 */
    { 0x0d21, 0xb935, 0x3900, RTFLOAT80U_INIT_C(0,0x91cd22e56c8f3f40,16442), RTPBCD80U_INIT_C(0,6,5,6,6,3,0,7,4,2,1,5,5,5,8,8,5,9,6) }, /* #60/3 */
    { 0x0032, 0x6fb3, 0x7d00, RTFLOAT80U_INIT_C(0,0xd308d6a4c4cb94c0,16442), RTPBCD80U_INIT_C(0,9,5,0,4,1,5,0,0,9,0,6,1,3,2,1,0,3,6) }, /* #61/0 */
    { 0x0432, 0x6fb3, 0x7d00, RTFLOAT80U_INIT_C(0,0xd308d6a4c4cb94c0,16442), RTPBCD80U_INIT_C(0,9,5,0,4,1,5,0,0,9,0,6,1,3,2,1,0,3,6) }, /* #61/1 */
    { 0x0832, 0x6fb3, 0x7d00, RTFLOAT80U_INIT_C(0,0xd308d6a4c4cb94c0,16442), RTPBCD80U_INIT_C(0,9,5,0,4,1,5,0,0,9,0,6,1,3,2,1,0,3,6) }, /* #61/2 */
    { 0x0c32, 0x6fb3, 0x7d00, RTFLOAT80U_INIT_C(0,0xd308d6a4c4cb94c0,16442), RTPBCD80U_INIT_C(0,9,5,0,4,1,5,0,0,9,0,6,1,3,2,1,0,3,6) }, /* #61/3 */
    { 0x004e, 0xd8c0, 0x7800, RTFLOAT80U_INIT_C(0,0xf502edf14148c8a0,16442), RTPBCD80U_INIT_C(0,11,0,3,3,12,13,4,4,3,12,15,4,11,14,7,2,3,12) }, /* #62/0 */
    { 0x044e, 0xd8c0, 0x7800, RTFLOAT80U_INIT_C(0,0xf502edf14148c8a0,16442), RTPBCD80U_INIT_C(0,11,0,3,3,12,13,4,4,3,12,15,4,11,14,7,2,3,12) }, /* #62/1 */
    { 0x084e, 0xd8c0, 0x7800, RTFLOAT80U_INIT_C(0,0xf502edf14148c8a0,16442), RTPBCD80U_INIT_C(0,11,0,3,3,12,13,4,4,3,12,15,4,11,14,7,2,3,12) }, /* #62/2 */
    { 0x0c4e, 0xd8c0, 0x7800, RTFLOAT80U_INIT_C(0,0xf502edf14148c8a0,16442), RTPBCD80U_INIT_C(0,11,0,3,3,12,13,4,4,3,12,15,4,11,14,7,2,3,12) }, /* #62/3 */
    { 0x016f, 0x007e, 0x3800, RTFLOAT80U_INIT_C(0,0xd163e9d0218d2600,16439), RTPBCD80U_INIT_EX_C(0x73,0,0,11,7,8,6,15,12,5,2,0,0,5,8,2,12,12,9,2) }, /* #63/0 */
    { 0x056f, 0x007e, 0x3800, RTFLOAT80U_INIT_C(0,0xd163e9d0218d2600,16439), RTPBCD80U_INIT_EX_C(0x73,0,0,11,7,8,6,15,12,5,2,0,0,5,8,2,12,12,9,2) }, /* #63/1 */
    { 0x096f, 0x007e, 0x3800, RTFLOAT80U_INIT_C(0,0xd163e9d0218d2600,16439), RTPBCD80U_INIT_EX_C(0x73,0,0,11,7,8,6,15,12,5,2,0,0,5,8,2,12,12,9,2) }, /* #63/2 */
    { 0x0d6f, 0x007e, 0x3800, RTFLOAT80U_INIT_C(0,0xd163e9d0218d2600,16439), RTPBCD80U_INIT_EX_C(0x73,0,0,11,7,8,6,15,12,5,2,0,0,5,8,2,12,12,9,2) }, /* #63/3 */
    { 0x014b, 0xe591, 0x7d00, RTFLOAT80U_INIT_C(1,0xd94acac4b6642d60,16442), RTPBCD80U_INIT_C(1,9,7,8,5,9,6,8,7,5,0,4,5,5,8,5,6,2,2) }, /* #64/0 */
    { 0x054b, 0xe591, 0x7d00, RTFLOAT80U_INIT_C(1,0xd94acac4b6642d60,16442), RTPBCD80U_INIT_C(1,9,7,8,5,9,6,8,7,5,0,4,5,5,8,5,6,2,2) }, /* #64/1 */
    { 0x094b, 0xe591, 0x7d00, RTFLOAT80U_INIT_C(1,0xd94acac4b6642d60,16442), RTPBCD80U_INIT_C(1,9,7,8,5,9,6,8,7,5,0,4,5,5,8,5,6,2,2) }, /* #64/2 */
    { 0x0d4b, 0xe591, 0x7d00, RTFLOAT80U_INIT_C(1,0xd94acac4b6642d60,16442), RTPBCD80U_INIT_C(1,9,7,8,5,9,6,8,7,5,0,4,5,5,8,5,6,2,2) }, /* #64/3 */
    { 0x005c, 0x4dfb, 0x7d00, RTFLOAT80U_INIT_C(1,0xc9b4189b8897d8e0,16442), RTPBCD80U_INIT_C(1,9,0,8,3,9,1,8,0,9,6,0,7,6,3,0,2,2,2) }, /* #65/0 */
    { 0x045c, 0x4dfb, 0x7d00, RTFLOAT80U_INIT_C(1,0xc9b4189b8897d8e0,16442), RTPBCD80U_INIT_C(1,9,0,8,3,9,1,8,0,9,6,0,7,6,3,0,2,2,2) }, /* #65/1 */
    { 0x085c, 0x4dfb, 0x7d00, RTFLOAT80U_INIT_C(1,0xc9b4189b8897d8e0,16442), RTPBCD80U_INIT_C(1,9,0,8,3,9,1,8,0,9,6,0,7,6,3,0,2,2,2) }, /* #65/2 */
    { 0x0c5c, 0x4dfb, 0x7d00, RTFLOAT80U_INIT_C(1,0xc9b4189b8897d8e0,16442), RTPBCD80U_INIT_C(1,9,0,8,3,9,1,8,0,9,6,0,7,6,3,0,2,2,2) }, /* #65/3 */
    { 0x024b, 0xb648, 0x3c00, RTFLOAT80U_INIT_C(1,0xb73a1428d93fe250,16442), RTPBCD80U_INIT_C(1,8,2,5,1,8,0,4,6,3,9,5,4,1,3,2,5,1,7) }, /* #66/0 */
    { 0x064b, 0xb648, 0x3c00, RTFLOAT80U_INIT_C(1,0xb73a1428d93fe250,16442), RTPBCD80U_INIT_C(1,8,2,5,1,8,0,4,6,3,9,5,4,1,3,2,5,1,7) }, /* #66/1 */
    { 0x0a4b, 0xb648, 0x3c00, RTFLOAT80U_INIT_C(1,0xb73a1428d93fe250,16442), RTPBCD80U_INIT_C(1,8,2,5,1,8,0,4,6,3,9,5,4,1,3,2,5,1,7) }, /* #66/2 */
    { 0x0e4b, 0xb648, 0x3c00, RTFLOAT80U_INIT_C(1,0xb73a1428d93fe250,16442), RTPBCD80U_INIT_C(1,8,2,5,1,8,0,4,6,3,9,5,4,1,3,2,5,1,7) }, /* #66/3 */
    { 0x020c, 0x9b63, 0x3900, RTFLOAT80U_INIT_C(1,0xa862e6105ac949f0,16442), RTPBCD80U_INIT_C(1,7,5,8,3,4,4,5,8,1,5,0,0,4,0,8,9,9,1) }, /* #67/0 */
    { 0x060c, 0x9b63, 0x3900, RTFLOAT80U_INIT_C(1,0xa862e6105ac949f0,16442), RTPBCD80U_INIT_C(1,7,5,8,3,4,4,5,8,1,5,0,0,4,0,8,9,9,1) }, /* #67/1 */
    { 0x0a0c, 0x9b63, 0x3900, RTFLOAT80U_INIT_C(1,0xa862e6105ac949f0,16442), RTPBCD80U_INIT_C(1,7,5,8,3,4,4,5,8,1,5,0,0,4,0,8,9,9,1) }, /* #67/2 */
    { 0x0e0c, 0x9b63, 0x3900, RTFLOAT80U_INIT_C(1,0xa862e6105ac949f0,16442), RTPBCD80U_INIT_C(1,7,5,8,3,4,4,5,8,1,5,0,0,4,0,8,9,9,1) }, /* #67/3 */
    { 0x023e, 0xa216, 0x3800, RTFLOAT80U_INIT_C(0,0xbbfb23889d976ac0,16442), RTPBCD80U_INIT_C(0,8,4,6,5,9,1,2,1,0,8,6,9,5,8,5,5,8,0) }, /* #68/0 */
    { 0x063e, 0xa216, 0x3800, RTFLOAT80U_INIT_C(0,0xbbfb23889d976ac0,16442), RTPBCD80U_INIT_C(0,8,4,6,5,9,1,2,1,0,8,6,9,5,8,5,5,8,0) }, /* #68/1 */
    { 0x0a3e, 0xa216, 0x3800, RTFLOAT80U_INIT_C(0,0xbbfb23889d976ac0,16442), RTPBCD80U_INIT_C(0,8,4,6,5,9,1,2,1,0,8,6,9,5,8,5,5,8,0) }, /* #68/2 */
    { 0x0e3e, 0xa216, 0x3800, RTFLOAT80U_INIT_C(0,0xbbfb23889d976ac0,16442), RTPBCD80U_INIT_C(0,8,4,6,5,9,1,2,1,0,8,6,9,5,8,5,5,8,0) }, /* #68/3 */
    { 0x030b, 0xe1ed, 0x7900, RTFLOAT80U_INIT_C(1,0xf00c647105de0500,16441), RTPBCD80U_INIT_C(1,5,4,0,5,4,0,9,5,9,5,4,4,2,4,2,2,1,6) }, /* #69/0 */
    { 0x070b, 0xe1ed, 0x7900, RTFLOAT80U_INIT_C(1,0xf00c647105de0500,16441), RTPBCD80U_INIT_C(1,5,4,0,5,4,0,9,5,9,5,4,4,2,4,2,2,1,6) }, /* #69/1 */
    { 0x0b0b, 0xe1ed, 0x7900, RTFLOAT80U_INIT_C(1,0xf00c647105de0500,16441), RTPBCD80U_INIT_C(1,5,4,0,5,4,0,9,5,9,5,4,4,2,4,2,2,1,6) }, /* #69/2 */
    { 0x0f0b, 0xe1ed, 0x7900, RTFLOAT80U_INIT_C(1,0xf00c647105de0500,16441), RTPBCD80U_INIT_C(1,5,4,0,5,4,0,9,5,9,5,4,4,2,4,2,2,1,6) }, /* #69/3 */
    { 0x0312, 0xc4c0, 0x7c00, RTFLOAT80U_INIT_C(0,0xa5335b57bd809dd0,16442), RTPBCD80U_INIT_C(0,7,3,13,9,9,6,13,11,7,0,2,9,3,6,12,3,7,11) }, /* #70/0 */
    { 0x0712, 0xc4c0, 0x7c00, RTFLOAT80U_INIT_C(0,0xa5335b57bd809dd0,16442), RTPBCD80U_INIT_C(0,7,3,13,9,9,6,13,11,7,0,2,9,3,6,12,3,7,11) }, /* #70/1 */
    { 0x0b12, 0xc4c0, 0x7c00, RTFLOAT80U_INIT_C(0,0xa5335b57bd809dd0,16442), RTPBCD80U_INIT_C(0,7,3,13,9,9,6,13,11,7,0,2,9,3,6,12,3,7,11) }, /* #70/2 */
    { 0x0f12, 0xc4c0, 0x7c00, RTFLOAT80U_INIT_C(0,0xa5335b57bd809dd0,16442), RTPBCD80U_INIT_C(0,7,3,13,9,9,6,13,11,7,0,2,9,3,6,12,3,7,11) }, /* #70/3 */
    { 0x012c, 0xb3a7, 0x3900, RTFLOAT80U_INIT_C(1,0xe178b3736be8ab50,16442), RTPBCD80U_INIT_EX_C(0x46,1,10,0,15,3,13,2,13,0,10,1,15,2,12,5,4,13,4,9) }, /* #71/0 */
    { 0x052c, 0xb3a7, 0x3900, RTFLOAT80U_INIT_C(1,0xe178b3736be8ab50,16442), RTPBCD80U_INIT_EX_C(0x46,1,10,0,15,3,13,2,13,0,10,1,15,2,12,5,4,13,4,9) }, /* #71/1 */
    { 0x092c, 0xb3a7, 0x3900, RTFLOAT80U_INIT_C(1,0xe178b3736be8ab50,16442), RTPBCD80U_INIT_EX_C(0x46,1,10,0,15,3,13,2,13,0,10,1,15,2,12,5,4,13,4,9) }, /* #71/2 */
    { 0x0d2c, 0xb3a7, 0x3900, RTFLOAT80U_INIT_C(1,0xe178b3736be8ab50,16442), RTPBCD80U_INIT_EX_C(0x46,1,10,0,15,3,13,2,13,0,10,1,15,2,12,5,4,13,4,9) }, /* #71/3 */
    { 0x016c, 0x8561, 0x3d00, RTFLOAT80U_INIT_C(0,0xc1d3d3d080de92a0,16442), RTPBCD80U_INIT_C(0,8,7,2,9,2,1,2,3,5,1,1,7,1,7,3,0,3,4) }, /* #72/0 */
    { 0x056c, 0x8561, 0x3d00, RTFLOAT80U_INIT_C(0,0xc1d3d3d080de92a0,16442), RTPBCD80U_INIT_C(0,8,7,2,9,2,1,2,3,5,1,1,7,1,7,3,0,3,4) }, /* #72/1 */
    { 0x096c, 0x8561, 0x3d00, RTFLOAT80U_INIT_C(0,0xc1d3d3d080de92a0,16442), RTPBCD80U_INIT_C(0,8,7,2,9,2,1,2,3,5,1,1,7,1,7,3,0,3,4) }, /* #72/2 */
    { 0x0d6c, 0x8561, 0x3d00, RTFLOAT80U_INIT_C(0,0xc1d3d3d080de92a0,16442), RTPBCD80U_INIT_C(0,8,7,2,9,2,1,2,3,5,1,1,7,1,7,3,0,3,4) }, /* #72/3 */
    { 0x001e, 0xc256, 0x7800, RTFLOAT80U_INIT_C(1,0xe221bf2798fa79c0,16440), RTPBCD80U_INIT_C(1,2,5,4,6,0,1,7,9,8,4,9,3,6,6,1,6,7,1) }, /* #73/0 */
    { 0x041e, 0xc256, 0x7800, RTFLOAT80U_INIT_C(1,0xe221bf2798fa79c0,16440), RTPBCD80U_INIT_C(1,2,5,4,6,0,1,7,9,8,4,9,3,6,6,1,6,7,1) }, /* #73/1 */
    { 0x081e, 0xc256, 0x7800, RTFLOAT80U_INIT_C(1,0xe221bf2798fa79c0,16440), RTPBCD80U_INIT_C(1,2,5,4,6,0,1,7,9,8,4,9,3,6,6,1,6,7,1) }, /* #73/2 */
    { 0x0c1e, 0xc256, 0x7800, RTFLOAT80U_INIT_C(1,0xe221bf2798fa79c0,16440), RTPBCD80U_INIT_C(1,2,5,4,6,0,1,7,9,8,4,9,3,6,6,1,6,7,1) }, /* #73/3 */
    { 0x005b, 0x53d3, 0x7900, RTFLOAT80U_INIT_C(1,0xc8d670fdf7b2c860,16441), RTPBCD80U_INIT_C(1,4,5,2,2,4,6,2,0,9,0,2,1,4,4,9,7,9,5) }, /* #74/0 */
    { 0x045b, 0x53d3, 0x7900, RTFLOAT80U_INIT_C(1,0xc8d670fdf7b2c860,16441), RTPBCD80U_INIT_C(1,4,5,2,2,4,6,2,0,9,0,2,1,4,4,9,7,9,5) }, /* #74/1 */
    { 0x085b, 0x53d3, 0x7900, RTFLOAT80U_INIT_C(1,0xc8d670fdf7b2c860,16441), RTPBCD80U_INIT_C(1,4,5,2,2,4,6,2,0,9,0,2,1,4,4,9,7,9,5) }, /* #74/2 */
    { 0x0c5b, 0x53d3, 0x7900, RTFLOAT80U_INIT_C(1,0xc8d670fdf7b2c860,16441), RTPBCD80U_INIT_C(1,4,5,2,2,4,6,2,0,9,0,2,1,4,4,9,7,9,5) }, /* #74/3 */
    { 0x0122, 0x0331, 0x3900, RTFLOAT80U_INIT_C(1,0xeb361e23132bcfc0,16440), RTPBCD80U_INIT_C(1,2,6,4,8,2,4,4,9,0,3,6,9,5,2,7,6,1,5) }, /* #75/0 */
    { 0x0522, 0x0331, 0x3900, RTFLOAT80U_INIT_C(1,0xeb361e23132bcfc0,16440), RTPBCD80U_INIT_C(1,2,6,4,8,2,4,4,9,0,3,6,9,5,2,7,6,1,5) }, /* #75/1 */
    { 0x0922, 0x0331, 0x3900, RTFLOAT80U_INIT_C(1,0xeb361e23132bcfc0,16440), RTPBCD80U_INIT_C(1,2,6,4,8,2,4,4,9,0,3,6,9,5,2,7,6,1,5) }, /* #75/2 */
    { 0x0d22, 0x0331, 0x3900, RTFLOAT80U_INIT_C(1,0xeb361e23132bcfc0,16440), RTPBCD80U_INIT_C(1,2,6,4,8,2,4,4,9,0,3,6,9,5,2,7,6,1,5) }, /* #75/3 */
    { 0x017f, 0x6ad2, 0x7800, RTFLOAT80U_INIT_C(1,0xfcbd92e7d501c340,16441), RTPBCD80U_INIT_C(1,5,6,9,1,2,1,0,6,2,2,6,7,6,5,3,6,5,8) }, /* #76/0 */
    { 0x057f, 0x6ad2, 0x7800, RTFLOAT80U_INIT_C(1,0xfcbd92e7d501c340,16441), RTPBCD80U_INIT_C(1,5,6,9,1,2,1,0,6,2,2,6,7,6,5,3,6,5,8) }, /* #76/1 */
    { 0x097f, 0x6ad2, 0x7800, RTFLOAT80U_INIT_C(1,0xfcbd92e7d501c340,16441), RTPBCD80U_INIT_C(1,5,6,9,1,2,1,0,6,2,2,6,7,6,5,3,6,5,8) }, /* #76/2 */
    { 0x0d7f, 0x6ad2, 0x7800, RTFLOAT80U_INIT_C(1,0xfcbd92e7d501c340,16441), RTPBCD80U_INIT_C(1,5,6,9,1,2,1,0,6,2,2,6,7,6,5,3,6,5,8) }, /* #76/3 */
    { 0x010f, 0xafde, 0x3d00, RTFLOAT80U_INIT_C(1,0xd063c404391f7d80,16441), RTPBCD80U_INIT_C(1,4,6,9,2,5,1,9,0,9,5,3,1,2,7,0,1,2,4) }, /* #77/0 */
    { 0x050f, 0xafde, 0x3d00, RTFLOAT80U_INIT_C(1,0xd063c404391f7d80,16441), RTPBCD80U_INIT_C(1,4,6,9,2,5,1,9,0,9,5,3,1,2,7,0,1,2,4) }, /* #77/1 */
    { 0x090f, 0xafde, 0x3d00, RTFLOAT80U_INIT_C(1,0xd063c404391f7d80,16441), RTPBCD80U_INIT_C(1,4,6,9,2,5,1,9,0,9,5,3,1,2,7,0,1,2,4) }, /* #77/2 */
    { 0x0d0f, 0xafde, 0x3d00, RTFLOAT80U_INIT_C(1,0xd063c404391f7d80,16441), RTPBCD80U_INIT_C(1,4,6,9,2,5,1,9,0,9,5,3,1,2,7,0,1,2,4) }, /* #77/3 */
    { 0x034e, 0x0807, 0x3800, RTFLOAT80U_INIT_C(0,0xd70f3fd7ed8bc700,16440), RTPBCD80U_INIT_C(0,1,14,2,1,2,15,4,14,7,4,8,11,1,15,15,12,12,12) }, /* #78/0 */
    { 0x074e, 0x0807, 0x3800, RTFLOAT80U_INIT_C(0,0xd70f3fd7ed8bc700,16440), RTPBCD80U_INIT_C(0,1,14,2,1,2,15,4,14,7,4,8,11,1,15,15,12,12,12) }, /* #78/1 */
    { 0x0b4e, 0x0807, 0x3800, RTFLOAT80U_INIT_C(0,0xd70f3fd7ed8bc700,16440), RTPBCD80U_INIT_C(0,1,14,2,1,2,15,4,14,7,4,8,11,1,15,15,12,12,12) }, /* #78/2 */
    { 0x0f4e, 0x0807, 0x3800, RTFLOAT80U_INIT_C(0,0xd70f3fd7ed8bc700,16440), RTPBCD80U_INIT_C(0,1,14,2,1,2,15,4,14,7,4,8,11,1,15,15,12,12,12) }, /* #78/3 */
    { 0x023e, 0x920a, 0x3800, RTFLOAT80U_INIT_C(1,0xb332c55acf64e790,16442), RTPBCD80U_INIT_EX_C(0x30,1,7,10,7,0,3,6,14,9,14,7,0,14,11,1,5,11,5,3) }, /* #79/0 */
    { 0x063e, 0x920a, 0x3800, RTFLOAT80U_INIT_C(1,0xb332c55acf64e790,16442), RTPBCD80U_INIT_EX_C(0x30,1,7,10,7,0,3,6,14,9,14,7,0,14,11,1,5,11,5,3) }, /* #79/1 */
    { 0x0a3e, 0x920a, 0x3800, RTFLOAT80U_INIT_C(1,0xb332c55acf64e790,16442), RTPBCD80U_INIT_EX_C(0x30,1,7,10,7,0,3,6,14,9,14,7,0,14,11,1,5,11,5,3) }, /* #79/2 */
    { 0x0e3e, 0x920a, 0x3800, RTFLOAT80U_INIT_C(1,0xb332c55acf64e790,16442), RTPBCD80U_INIT_EX_C(0x30,1,7,10,7,0,3,6,14,9,14,7,0,14,11,1,5,11,5,3) }, /* #79/3 */
    { 0x001b, 0x103a, 0x3800, RTFLOAT80U_INIT_C(0,0xf6b55502cffafb00,16438), RTPBCD80U_INIT_C(0,0,6,9,4,4,2,2,2,0,9,9,4,8,5,3,6,2,7) }, /* #80/0 */
    { 0x041b, 0x103a, 0x3800, RTFLOAT80U_INIT_C(0,0xf6b55502cffafb00,16438), RTPBCD80U_INIT_C(0,0,6,9,4,4,2,2,2,0,9,9,4,8,5,3,6,2,7) }, /* #80/1 */
    { 0x081b, 0x103a, 0x3800, RTFLOAT80U_INIT_C(0,0xf6b55502cffafb00,16438), RTPBCD80U_INIT_C(0,0,6,9,4,4,2,2,2,0,9,9,4,8,5,3,6,2,7) }, /* #80/2 */
    { 0x0c1b, 0x103a, 0x3800, RTFLOAT80U_INIT_C(0,0xf6b55502cffafb00,16438), RTPBCD80U_INIT_C(0,0,6,9,4,4,2,2,2,0,9,9,4,8,5,3,6,2,7) }, /* #80/3 */
    { 0x0370, 0x3f12, 0x3d00, RTFLOAT80U_INIT_C(1,0xd635c7f4045201c0,16442), RTPBCD80U_INIT_C(1,9,6,4,7,1,6,4,4,6,7,9,6,2,9,2,1,2,4) }, /* #81/0 */
    { 0x0770, 0x3f12, 0x3d00, RTFLOAT80U_INIT_C(1,0xd635c7f4045201c0,16442), RTPBCD80U_INIT_C(1,9,6,4,7,1,6,4,4,6,7,9,6,2,9,2,1,2,4) }, /* #81/1 */
    { 0x0b70, 0x3f12, 0x3d00, RTFLOAT80U_INIT_C(1,0xd635c7f4045201c0,16442), RTPBCD80U_INIT_C(1,9,6,4,7,1,6,4,4,6,7,9,6,2,9,2,1,2,4) }, /* #81/2 */
    { 0x0f70, 0x3f12, 0x3d00, RTFLOAT80U_INIT_C(1,0xd635c7f4045201c0,16442), RTPBCD80U_INIT_C(1,9,6,4,7,1,6,4,4,6,7,9,6,2,9,2,1,2,4) }, /* #81/3 */
    { 0x0059, 0x7d47, 0x7d00, RTFLOAT80U_INIT_C(1,0xb3f7250c7abe5000,16436), RTPBCD80U_INIT_C(1,0,1,2,6,6,3,9,3,9,8,3,1,6,0,7,1,8,8) }, /* #82/0 */
    { 0x0459, 0x7d47, 0x7d00, RTFLOAT80U_INIT_C(1,0xb3f7250c7abe5000,16436), RTPBCD80U_INIT_C(1,0,1,2,6,6,3,9,3,9,8,3,1,6,0,7,1,8,8) }, /* #82/1 */
    { 0x0859, 0x7d47, 0x7d00, RTFLOAT80U_INIT_C(1,0xb3f7250c7abe5000,16436), RTPBCD80U_INIT_C(1,0,1,2,6,6,3,9,3,9,8,3,1,6,0,7,1,8,8) }, /* #82/2 */
    { 0x0c59, 0x7d47, 0x7d00, RTFLOAT80U_INIT_C(1,0xb3f7250c7abe5000,16436), RTPBCD80U_INIT_C(1,0,1,2,6,6,3,9,3,9,8,3,1,6,0,7,1,8,8) }, /* #82/3 */
    { 0x0032, 0xd92d, 0x7900, RTFLOAT80U_INIT_C(1,0xd9f8d9c8a70d93c0,16441), RTPBCD80U_INIT_C(1,4,9,0,8,2,9,4,7,3,6,3,3,5,6,1,7,5,8) }, /* #83/0 */
    { 0x0432, 0xd92d, 0x7900, RTFLOAT80U_INIT_C(1,0xd9f8d9c8a70d93c0,16441), RTPBCD80U_INIT_C(1,4,9,0,8,2,9,4,7,3,6,3,3,5,6,1,7,5,8) }, /* #83/1 */
    { 0x0832, 0xd92d, 0x7900, RTFLOAT80U_INIT_C(1,0xd9f8d9c8a70d93c0,16441), RTPBCD80U_INIT_C(1,4,9,0,8,2,9,4,7,3,6,3,3,5,6,1,7,5,8) }, /* #83/2 */
    { 0x0c32, 0xd92d, 0x7900, RTFLOAT80U_INIT_C(1,0xd9f8d9c8a70d93c0,16441), RTPBCD80U_INIT_C(1,4,9,0,8,2,9,4,7,3,6,3,3,5,6,1,7,5,8) }, /* #83/3 */
    { 0x0179, 0x32d7, 0x3800, RTFLOAT80U_INIT_C(0,0xab938875bf88bde0,16441), RTPBCD80U_INIT_C(0,3,8,6,3,5,5,4,8,2,5,4,2,7,5,3,2,6,3) }, /* #84/0 */
    { 0x0579, 0x32d7, 0x3800, RTFLOAT80U_INIT_C(0,0xab938875bf88bde0,16441), RTPBCD80U_INIT_C(0,3,8,6,3,5,5,4,8,2,5,4,2,7,5,3,2,6,3) }, /* #84/1 */
    { 0x0979, 0x32d7, 0x3800, RTFLOAT80U_INIT_C(0,0xab938875bf88bde0,16441), RTPBCD80U_INIT_C(0,3,8,6,3,5,5,4,8,2,5,4,2,7,5,3,2,6,3) }, /* #84/2 */
    { 0x0d79, 0x32d7, 0x3800, RTFLOAT80U_INIT_C(0,0xab938875bf88bde0,16441), RTPBCD80U_INIT_C(0,3,8,6,3,5,5,4,8,2,5,4,2,7,5,3,2,6,3) }, /* #84/3 */
    { 0x0111, 0x93fe, 0x3900, RTFLOAT80U_INIT_C(0,0x9b08e7ff91e89a80,16440), RTPBCD80U_INIT_C(0,1,7,4,5,5,3,6,5,5,6,3,3,4,8,6,4,4,2) }, /* #85/0 */
    { 0x0511, 0x93fe, 0x3900, RTFLOAT80U_INIT_C(0,0x9b08e7ff91e89a80,16440), RTPBCD80U_INIT_C(0,1,7,4,5,5,3,6,5,5,6,3,3,4,8,6,4,4,2) }, /* #85/1 */
    { 0x0911, 0x93fe, 0x3900, RTFLOAT80U_INIT_C(0,0x9b08e7ff91e89a80,16440), RTPBCD80U_INIT_C(0,1,7,4,5,5,3,6,5,5,6,3,3,4,8,6,4,4,2) }, /* #85/2 */
    { 0x0d11, 0x93fe, 0x3900, RTFLOAT80U_INIT_C(0,0x9b08e7ff91e89a80,16440), RTPBCD80U_INIT_C(0,1,7,4,5,5,3,6,5,5,6,3,3,4,8,6,4,4,2) }, /* #85/3 */
    { 0x011c, 0x79e6, 0x7900, RTFLOAT80U_INIT_C(0,0x9f902b294c63cca0,16443), RTPBCD80U_INIT_C(0,14,3,6,11,11,7,1,5,12,11,2,10,14,11,6,13,3,2) }, /* #86/0 */
    { 0x051c, 0x79e6, 0x7900, RTFLOAT80U_INIT_C(0,0x9f902b294c63cca0,16443), RTPBCD80U_INIT_C(0,14,3,6,11,11,7,1,5,12,11,2,10,14,11,6,13,3,2) }, /* #86/1 */
    { 0x091c, 0x79e6, 0x7900, RTFLOAT80U_INIT_C(0,0x9f902b294c63cca0,16443), RTPBCD80U_INIT_C(0,14,3,6,11,11,7,1,5,12,11,2,10,14,11,6,13,3,2) }, /* #86/2 */
    { 0x0d1c, 0x79e6, 0x7900, RTFLOAT80U_INIT_C(0,0x9f902b294c63cca0,16443), RTPBCD80U_INIT_C(0,14,3,6,11,11,7,1,5,12,11,2,10,14,11,6,13,3,2) }, /* #86/3 */
    { 0x032e, 0xa558, 0x3d00, RTFLOAT80U_INIT_C(0,0xe21d909477405fa0,16442), RTPBCD80U_INIT_EX_C(0x46,0,10,1,7,12,13,3,6,1,14,5,13,9,1,6,1,8,5,0) }, /* #87/0 */
    { 0x072e, 0xa558, 0x3d00, RTFLOAT80U_INIT_C(0,0xe21d909477405fa0,16442), RTPBCD80U_INIT_EX_C(0x46,0,10,1,7,12,13,3,6,1,14,5,13,9,1,6,1,8,5,0) }, /* #87/1 */
    { 0x0b2e, 0xa558, 0x3d00, RTFLOAT80U_INIT_C(0,0xe21d909477405fa0,16442), RTPBCD80U_INIT_EX_C(0x46,0,10,1,7,12,13,3,6,1,14,5,13,9,1,6,1,8,5,0) }, /* #87/2 */
    { 0x0f2e, 0xa558, 0x3d00, RTFLOAT80U_INIT_C(0,0xe21d909477405fa0,16442), RTPBCD80U_INIT_EX_C(0x46,0,10,1,7,12,13,3,6,1,14,5,13,9,1,6,1,8,5,0) }, /* #87/3 */
    { 0x0078, 0x46c1, 0x7c00, RTFLOAT80U_INIT_C(1,0xdc80c25c01788a50,16442), RTPBCD80U_INIT_C(1,9,9,3,0,5,7,0,7,4,1,1,1,2,8,5,4,1,3) }, /* #88/0 */
    { 0x0478, 0x46c1, 0x7c00, RTFLOAT80U_INIT_C(1,0xdc80c25c01788a50,16442), RTPBCD80U_INIT_C(1,9,9,3,0,5,7,0,7,4,1,1,1,2,8,5,4,1,3) }, /* #88/1 */
    { 0x0878, 0x46c1, 0x7c00, RTFLOAT80U_INIT_C(1,0xdc80c25c01788a50,16442), RTPBCD80U_INIT_C(1,9,9,3,0,5,7,0,7,4,1,1,1,2,8,5,4,1,3) }, /* #88/2 */
    { 0x0c78, 0x46c1, 0x7c00, RTFLOAT80U_INIT_C(1,0xdc80c25c01788a50,16442), RTPBCD80U_INIT_C(1,9,9,3,0,5,7,0,7,4,1,1,1,2,8,5,4,1,3) }, /* #88/3 */
    { 0x0230, 0x328e, 0x3800, RTFLOAT80U_INIT_C(1,0xb1d5e79df4b1d130,16442), RTPBCD80U_INIT_C(1,8,0,0,9,0,0,1,8,6,2,7,2,1,1,1,8,9,1) }, /* #89/0 */
    { 0x0630, 0x328e, 0x3800, RTFLOAT80U_INIT_C(1,0xb1d5e79df4b1d130,16442), RTPBCD80U_INIT_C(1,8,0,0,9,0,0,1,8,6,2,7,2,1,1,1,8,9,1) }, /* #89/1 */
    { 0x0a30, 0x328e, 0x3800, RTFLOAT80U_INIT_C(1,0xb1d5e79df4b1d130,16442), RTPBCD80U_INIT_C(1,8,0,0,9,0,0,1,8,6,2,7,2,1,1,1,8,9,1) }, /* #89/2 */
    { 0x0e30, 0x328e, 0x3800, RTFLOAT80U_INIT_C(1,0xb1d5e79df4b1d130,16442), RTPBCD80U_INIT_C(1,8,0,0,9,0,0,1,8,6,2,7,2,1,1,1,8,9,1) }, /* #89/3 */
    { 0x033f, 0xaacb, 0x3800, RTFLOAT80U_INIT_C(1,0xd552c792610db4c0,16440), RTPBCD80U_INIT_C(1,2,4,0,1,8,0,7,4,8,5,8,8,6,9,3,2,0,3) }, /* #90/0 */
    { 0x073f, 0xaacb, 0x3800, RTFLOAT80U_INIT_C(1,0xd552c792610db4c0,16440), RTPBCD80U_INIT_C(1,2,4,0,1,8,0,7,4,8,5,8,8,6,9,3,2,0,3) }, /* #90/1 */
    { 0x0b3f, 0xaacb, 0x3800, RTFLOAT80U_INIT_C(1,0xd552c792610db4c0,16440), RTPBCD80U_INIT_C(1,2,4,0,1,8,0,7,4,8,5,8,8,6,9,3,2,0,3) }, /* #90/2 */
    { 0x0f3f, 0xaacb, 0x3800, RTFLOAT80U_INIT_C(1,0xd552c792610db4c0,16440), RTPBCD80U_INIT_C(1,2,4,0,1,8,0,7,4,8,5,8,8,6,9,3,2,0,3) }, /* #90/3 */
    { 0x0209, 0xd4f8, 0x7c00, RTFLOAT80U_INIT_C(0,0xb8f29024be237200,16437), RTPBCD80U_INIT_C(0,0,2,6,0,2,9,0,4,8,3,1,0,2,0,6,9,0,5) }, /* #91/0 */
    { 0x0609, 0xd4f8, 0x7c00, RTFLOAT80U_INIT_C(0,0xb8f29024be237200,16437), RTPBCD80U_INIT_C(0,0,2,6,0,2,9,0,4,8,3,1,0,2,0,6,9,0,5) }, /* #91/1 */
    { 0x0a09, 0xd4f8, 0x7c00, RTFLOAT80U_INIT_C(0,0xb8f29024be237200,16437), RTPBCD80U_INIT_C(0,0,2,6,0,2,9,0,4,8,3,1,0,2,0,6,9,0,5) }, /* #91/2 */
    { 0x0e09, 0xd4f8, 0x7c00, RTFLOAT80U_INIT_C(0,0xb8f29024be237200,16437), RTPBCD80U_INIT_C(0,0,2,6,0,2,9,0,4,8,3,1,0,2,0,6,9,0,5) }, /* #91/3 */
    { 0x0164, 0x65b5, 0x7d00, RTFLOAT80U_INIT_C(0,0xa18f7ed63ec4bca0,16441), RTPBCD80U_INIT_C(0,3,6,3,8,0,1,9,6,9,3,8,8,0,3,7,6,0,5) }, /* #92/0 */
    { 0x0564, 0x65b5, 0x7d00, RTFLOAT80U_INIT_C(0,0xa18f7ed63ec4bca0,16441), RTPBCD80U_INIT_C(0,3,6,3,8,0,1,9,6,9,3,8,8,0,3,7,6,0,5) }, /* #92/1 */
    { 0x0964, 0x65b5, 0x7d00, RTFLOAT80U_INIT_C(0,0xa18f7ed63ec4bca0,16441), RTPBCD80U_INIT_C(0,3,6,3,8,0,1,9,6,9,3,8,8,0,3,7,6,0,5) }, /* #92/2 */
    { 0x0d64, 0x65b5, 0x7d00, RTFLOAT80U_INIT_C(0,0xa18f7ed63ec4bca0,16441), RTPBCD80U_INIT_C(0,3,6,3,8,0,1,9,6,9,3,8,8,0,3,7,6,0,5) }, /* #92/3 */
    { 0x0114, 0x6d31, 0x7d00, RTFLOAT80U_INIT_C(1,0xdc0840533e2009e0,16441), RTPBCD80U_INIT_C(1,4,9,5,4,6,8,5,3,7,9,5,0,8,3,0,6,7,1) }, /* #93/0 */
    { 0x0514, 0x6d31, 0x7d00, RTFLOAT80U_INIT_C(1,0xdc0840533e2009e0,16441), RTPBCD80U_INIT_C(1,4,9,5,4,6,8,5,3,7,9,5,0,8,3,0,6,7,1) }, /* #93/1 */
    { 0x0914, 0x6d31, 0x7d00, RTFLOAT80U_INIT_C(1,0xdc0840533e2009e0,16441), RTPBCD80U_INIT_C(1,4,9,5,4,6,8,5,3,7,9,5,0,8,3,0,6,7,1) }, /* #93/2 */
    { 0x0d14, 0x6d31, 0x7d00, RTFLOAT80U_INIT_C(1,0xdc0840533e2009e0,16441), RTPBCD80U_INIT_C(1,4,9,5,4,6,8,5,3,7,9,5,0,8,3,0,6,7,1) }, /* #93/3 */
    { 0x013e, 0x676c, 0x7d00, RTFLOAT80U_INIT_C(1,0xad1ff6f20e573560,16441), RTPBCD80U_INIT_C(1,3,8,9,8,4,2,4,12,10,15,13,5,0,8,3,6,8,11) }, /* #94/0 */
    { 0x053e, 0x676c, 0x7d00, RTFLOAT80U_INIT_C(1,0xad1ff6f20e573560,16441), RTPBCD80U_INIT_C(1,3,8,9,8,4,2,4,12,10,15,13,5,0,8,3,6,8,11) }, /* #94/1 */
    { 0x093e, 0x676c, 0x7d00, RTFLOAT80U_INIT_C(1,0xad1ff6f20e573560,16441), RTPBCD80U_INIT_C(1,3,8,9,8,4,2,4,12,10,15,13,5,0,8,3,6,8,11) }, /* #94/2 */
    { 0x0d3e, 0x676c, 0x7d00, RTFLOAT80U_INIT_C(1,0xad1ff6f20e573560,16441), RTPBCD80U_INIT_C(1,3,8,9,8,4,2,4,12,10,15,13,5,0,8,3,6,8,11) }, /* #94/3 */
    { 0x024b, 0x0416, 0x3c00, RTFLOAT80U_INIT_C(0,0xe8cb58d9e7cf89d0,16442), RTPBCD80U_INIT_EX_C(0x4b,0,9,14,8,4,1,2,4,2,12,10,11,14,4,8,8,13,7,3) }, /* #95/0 */
    { 0x064b, 0x0416, 0x3c00, RTFLOAT80U_INIT_C(0,0xe8cb58d9e7cf89d0,16442), RTPBCD80U_INIT_EX_C(0x4b,0,9,14,8,4,1,2,4,2,12,10,11,14,4,8,8,13,7,3) }, /* #95/1 */
    { 0x0a4b, 0x0416, 0x3c00, RTFLOAT80U_INIT_C(0,0xe8cb58d9e7cf89d0,16442), RTPBCD80U_INIT_EX_C(0x4b,0,9,14,8,4,1,2,4,2,12,10,11,14,4,8,8,13,7,3) }, /* #95/2 */
    { 0x0e4b, 0x0416, 0x3c00, RTFLOAT80U_INIT_C(0,0xe8cb58d9e7cf89d0,16442), RTPBCD80U_INIT_EX_C(0x4b,0,9,14,8,4,1,2,4,2,12,10,11,14,4,8,8,13,7,3) }, /* #95/3 */
};
uint32_t const g_cTests_fld_r80_from_d80 = RT_ELEMENTS(g_aTests_fld_r80_from_d80);

FPU_ST_I64_TEST_T const g_aTests_fist_r80_to_i64[] =
{
    { 0x0107, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/0/0 */
    { 0x010f, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/0/2 */
    { 0x0117, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/0/4 */
    { 0x011f, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/0/6 */
    { 0x0127, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/0/8 */
    { 0x012f, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/0/10 */
    { 0x0137, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/0/12 */
    { 0x013f, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/0/14 */
    { 0x0507, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/1/0 */
    { 0x050f, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/1/2 */
    { 0x0517, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/1/4 */
    { 0x051f, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/1/6 */
    { 0x0527, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/1/8 */
    { 0x052f, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/1/10 */
    { 0x0537, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/1/12 */
    { 0x053f, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/1/14 */
    { 0x0907, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/2/0 */
    { 0x090f, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/2/2 */
    { 0x0917, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/2/4 */
    { 0x091f, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/2/6 */
    { 0x0927, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/2/8 */
    { 0x092f, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/2/10 */
    { 0x0937, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/2/12 */
    { 0x093f, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/2/14 */
    { 0x0d07, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/3/0 */
    { 0x0d0f, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/3/2 */
    { 0x0d17, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/3/4 */
    { 0x0d1f, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/3/6 */
    { 0x0d27, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/3/8 */
    { 0x0d2f, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/3/10 */
    { 0x0d37, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/3/12 */
    { 0x0d3f, 0x94e7, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #0/3/14 */
    { 0x0200, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/0/0 */
    { 0x0208, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/0/2 */
    { 0x0210, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/0/4 */
    { 0x0218, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/0/6 */
    { 0x0220, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/0/8 */
    { 0x0228, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/0/10 */
    { 0x0230, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/0/12 */
    { 0x0238, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/0/14 */
    { 0x0600, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/1/0 */
    { 0x0608, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/1/2 */
    { 0x0610, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/1/4 */
    { 0x0618, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/1/6 */
    { 0x0620, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/1/8 */
    { 0x0628, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/1/10 */
    { 0x0630, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/1/12 */
    { 0x0638, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/1/14 */
    { 0x0a00, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/2/0 */
    { 0x0a08, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/2/2 */
    { 0x0a10, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/2/4 */
    { 0x0a18, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/2/6 */
    { 0x0a20, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/2/8 */
    { 0x0a28, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/2/10 */
    { 0x0a30, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/2/12 */
    { 0x0a38, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/2/14 */
    { 0x0e00, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/3/0 */
    { 0x0e08, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/3/2 */
    { 0x0e10, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/3/4 */
    { 0x0e18, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/3/6 */
    { 0x0e20, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/3/8 */
    { 0x0e28, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/3/10 */
    { 0x0e30, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/3/12 */
    { 0x0e38, 0xc030, 0x4000, RTFLOAT80U_INIT_C(0,0xac617db103eacd62,16445), INT64_C(6210673723246470833) }, /* #1/3/14 */
    { 0x0301, 0x8cd3, 0x84a0, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/0/0 */
    { 0x0309, 0x8cd3, 0x84a0, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/0/2 */
    { 0x0311, 0x8cd3, 0x84a0, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/0/4 */
    { 0x0319, 0x8cd3, 0x84a0, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/0/6 */
    { 0x0321, 0x8cd3, 0x0420, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/0/8 */
    { 0x0329, 0x8cd3, 0x0420, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/0/10 */
    { 0x0331, 0x8cd3, 0x0420, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/0/12 */
    { 0x0339, 0x8cd3, 0x0420, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/0/14 */
    { 0x0701, 0x8cd3, 0x84a0, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/1/0 */
    { 0x0709, 0x8cd3, 0x84a0, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/1/2 */
    { 0x0711, 0x8cd3, 0x84a0, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/1/4 */
    { 0x0719, 0x8cd3, 0x84a0, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/1/6 */
    { 0x0721, 0x8cd3, 0x0420, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/1/8 */
    { 0x0729, 0x8cd3, 0x0420, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/1/10 */
    { 0x0731, 0x8cd3, 0x0420, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/1/12 */
    { 0x0739, 0x8cd3, 0x0420, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/1/14 */
    { 0x0b01, 0x8cd3, 0x86a0, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(2) }, /* #2/2/0 */
    { 0x0b09, 0x8cd3, 0x86a0, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(2) }, /* #2/2/2 */
    { 0x0b11, 0x8cd3, 0x86a0, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(2) }, /* #2/2/4 */
    { 0x0b19, 0x8cd3, 0x86a0, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(2) }, /* #2/2/6 */
    { 0x0b21, 0x8cd3, 0x0620, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(2) }, /* #2/2/8 */
    { 0x0b29, 0x8cd3, 0x0620, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(2) }, /* #2/2/10 */
    { 0x0b31, 0x8cd3, 0x0620, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(2) }, /* #2/2/12 */
    { 0x0b39, 0x8cd3, 0x0620, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(2) }, /* #2/2/14 */
    { 0x0f01, 0x8cd3, 0x84a0, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/3/0 */
    { 0x0f09, 0x8cd3, 0x84a0, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/3/2 */
    { 0x0f11, 0x8cd3, 0x84a0, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/3/4 */
    { 0x0f19, 0x8cd3, 0x84a0, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/3/6 */
    { 0x0f21, 0x8cd3, 0x0420, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/3/8 */
    { 0x0f29, 0x8cd3, 0x0420, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/3/10 */
    { 0x0f31, 0x8cd3, 0x0420, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/3/12 */
    { 0x0f39, 0x8cd3, 0x0420, RTFLOAT80U_INIT_C(0,0x97569ea538ad74b9,16383), INT64_C(1) }, /* #2/3/14 */
    { 0x0046, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/0/0 */
    { 0x004e, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/0/2 */
    { 0x0056, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/0/4 */
    { 0x005e, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/0/6 */
    { 0x0066, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/0/8 */
    { 0x006e, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/0/10 */
    { 0x0076, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/0/12 */
    { 0x007e, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/0/14 */
    { 0x0446, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/1/0 */
    { 0x044e, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/1/2 */
    { 0x0456, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/1/4 */
    { 0x045e, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/1/6 */
    { 0x0466, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/1/8 */
    { 0x046e, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/1/10 */
    { 0x0476, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/1/12 */
    { 0x047e, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/1/14 */
    { 0x0846, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/2/0 */
    { 0x084e, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/2/2 */
    { 0x0856, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/2/4 */
    { 0x085e, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/2/6 */
    { 0x0866, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/2/8 */
    { 0x086e, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/2/10 */
    { 0x0876, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/2/12 */
    { 0x087e, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/2/14 */
    { 0x0c46, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/3/0 */
    { 0x0c4e, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/3/2 */
    { 0x0c56, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/3/4 */
    { 0x0c5e, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/3/6 */
    { 0x0c66, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/3/8 */
    { 0x0c6e, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/3/10 */
    { 0x0c76, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/3/12 */
    { 0x0c7e, 0xc505, 0xfd81, RTFLOAT80U_INIT_C(1,0x56c91f8fa42ddc69,24044), INT64_C(-3) }, /* #3/3/14 */
    { 0x0102, 0xb7bb, 0x85a0, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/0/0 */
    { 0x010a, 0xb7bb, 0x85a0, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/0/2 */
    { 0x0112, 0xb7bb, 0x85a0, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/0/4 */
    { 0x011a, 0xb7bb, 0x85a0, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/0/6 */
    { 0x0122, 0xb7bb, 0x0520, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/0/8 */
    { 0x012a, 0xb7bb, 0x0520, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/0/10 */
    { 0x0132, 0xb7bb, 0x0520, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/0/12 */
    { 0x013a, 0xb7bb, 0x0520, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/0/14 */
    { 0x0502, 0xb7bb, 0x87a0, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(-1) }, /* #4/1/0 */
    { 0x050a, 0xb7bb, 0x87a0, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(-1) }, /* #4/1/2 */
    { 0x0512, 0xb7bb, 0x87a0, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(-1) }, /* #4/1/4 */
    { 0x051a, 0xb7bb, 0x87a0, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(-1) }, /* #4/1/6 */
    { 0x0522, 0xb7bb, 0x0720, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(-1) }, /* #4/1/8 */
    { 0x052a, 0xb7bb, 0x0720, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(-1) }, /* #4/1/10 */
    { 0x0532, 0xb7bb, 0x0720, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(-1) }, /* #4/1/12 */
    { 0x053a, 0xb7bb, 0x0720, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(-1) }, /* #4/1/14 */
    { 0x0902, 0xb7bb, 0x85a0, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/2/0 */
    { 0x090a, 0xb7bb, 0x85a0, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/2/2 */
    { 0x0912, 0xb7bb, 0x85a0, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/2/4 */
    { 0x091a, 0xb7bb, 0x85a0, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/2/6 */
    { 0x0922, 0xb7bb, 0x0520, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/2/8 */
    { 0x092a, 0xb7bb, 0x0520, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/2/10 */
    { 0x0932, 0xb7bb, 0x0520, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/2/12 */
    { 0x093a, 0xb7bb, 0x0520, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/2/14 */
    { 0x0d02, 0xb7bb, 0x85a0, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/3/0 */
    { 0x0d0a, 0xb7bb, 0x85a0, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/3/2 */
    { 0x0d12, 0xb7bb, 0x85a0, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/3/4 */
    { 0x0d1a, 0xb7bb, 0x85a0, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/3/6 */
    { 0x0d22, 0xb7bb, 0x0520, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/3/8 */
    { 0x0d2a, 0xb7bb, 0x0520, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/3/10 */
    { 0x0d32, 0xb7bb, 0x0520, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/3/12 */
    { 0x0d3a, 0xb7bb, 0x0520, RTFLOAT80U_INIT_C(1,0xedc3a888465c0a01,0), INT64_C(0) }, /* #4/3/14 */
    { 0x0240, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/0/0 */
    { 0x0248, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/0/2 */
    { 0x0250, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/0/4 */
    { 0x0258, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/0/6 */
    { 0x0260, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/0/8 */
    { 0x0268, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/0/10 */
    { 0x0270, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/0/12 */
    { 0x0278, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/0/14 */
    { 0x0640, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/1/0 */
    { 0x0648, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/1/2 */
    { 0x0650, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/1/4 */
    { 0x0658, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/1/6 */
    { 0x0660, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/1/8 */
    { 0x0668, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/1/10 */
    { 0x0670, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/1/12 */
    { 0x0678, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/1/14 */
    { 0x0a40, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/2/0 */
    { 0x0a48, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/2/2 */
    { 0x0a50, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/2/4 */
    { 0x0a58, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/2/6 */
    { 0x0a60, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/2/8 */
    { 0x0a68, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/2/10 */
    { 0x0a70, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/2/12 */
    { 0x0a78, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/2/14 */
    { 0x0e40, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/3/0 */
    { 0x0e48, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/3/2 */
    { 0x0e50, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/3/4 */
    { 0x0e58, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/3/6 */
    { 0x0e60, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/3/8 */
    { 0x0e68, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/3/10 */
    { 0x0e70, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/3/12 */
    { 0x0e78, 0x46b5, 0xfc81, RTFLOAT80U_INIT_C(0,0x30ed8b8cc453d6cc,32620), INT64_C(-3) }, /* #5/3/14 */
    { 0x0106, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/0/0 */
    { 0x010e, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/0/2 */
    { 0x0116, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/0/4 */
    { 0x011e, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/0/6 */
    { 0x0126, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/0/8 */
    { 0x012e, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/0/10 */
    { 0x0136, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/0/12 */
    { 0x013e, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/0/14 */
    { 0x0506, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/1/0 */
    { 0x050e, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/1/2 */
    { 0x0516, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/1/4 */
    { 0x051e, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/1/6 */
    { 0x0526, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/1/8 */
    { 0x052e, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/1/10 */
    { 0x0536, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/1/12 */
    { 0x053e, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/1/14 */
    { 0x0906, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/2/0 */
    { 0x090e, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/2/2 */
    { 0x0916, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/2/4 */
    { 0x091e, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/2/6 */
    { 0x0926, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/2/8 */
    { 0x092e, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/2/10 */
    { 0x0936, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/2/12 */
    { 0x093e, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/2/14 */
    { 0x0d06, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/3/0 */
    { 0x0d0e, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/3/2 */
    { 0x0d16, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/3/4 */
    { 0x0d1e, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/3/6 */
    { 0x0d26, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/3/8 */
    { 0x0d2e, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/3/10 */
    { 0x0d36, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/3/12 */
    { 0x0d3e, 0x106f, 0xb881, RTFLOAT80U_INIT_C(0,0xdce27a37257fab4c,32767), INT64_C(-3) }, /* #6/3/14 */
    { 0x0147, 0x0d49, 0x87a0, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652570) }, /* #7/0/0 */
    { 0x014f, 0x0d49, 0x87a0, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652570) }, /* #7/0/2 */
    { 0x0157, 0x0d49, 0x87a0, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652570) }, /* #7/0/4 */
    { 0x015f, 0x0d49, 0x87a0, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652570) }, /* #7/0/6 */
    { 0x0167, 0x0d49, 0x0720, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652570) }, /* #7/0/8 */
    { 0x016f, 0x0d49, 0x0720, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652570) }, /* #7/0/10 */
    { 0x0177, 0x0d49, 0x0720, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652570) }, /* #7/0/12 */
    { 0x017f, 0x0d49, 0x0720, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652570) }, /* #7/0/14 */
    { 0x0547, 0x0d49, 0x85a0, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652569) }, /* #7/1/0 */
    { 0x054f, 0x0d49, 0x85a0, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652569) }, /* #7/1/2 */
    { 0x0557, 0x0d49, 0x85a0, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652569) }, /* #7/1/4 */
    { 0x055f, 0x0d49, 0x85a0, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652569) }, /* #7/1/6 */
    { 0x0567, 0x0d49, 0x0520, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652569) }, /* #7/1/8 */
    { 0x056f, 0x0d49, 0x0520, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652569) }, /* #7/1/10 */
    { 0x0577, 0x0d49, 0x0520, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652569) }, /* #7/1/12 */
    { 0x057f, 0x0d49, 0x0520, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652569) }, /* #7/1/14 */
    { 0x0947, 0x0d49, 0x87a0, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652570) }, /* #7/2/0 */
    { 0x094f, 0x0d49, 0x87a0, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652570) }, /* #7/2/2 */
    { 0x0957, 0x0d49, 0x87a0, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652570) }, /* #7/2/4 */
    { 0x095f, 0x0d49, 0x87a0, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652570) }, /* #7/2/6 */
    { 0x0967, 0x0d49, 0x0720, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652570) }, /* #7/2/8 */
    { 0x096f, 0x0d49, 0x0720, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652570) }, /* #7/2/10 */
    { 0x0977, 0x0d49, 0x0720, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652570) }, /* #7/2/12 */
    { 0x097f, 0x0d49, 0x0720, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652570) }, /* #7/2/14 */
    { 0x0d47, 0x0d49, 0x85a0, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652569) }, /* #7/3/0 */
    { 0x0d4f, 0x0d49, 0x85a0, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652569) }, /* #7/3/2 */
    { 0x0d57, 0x0d49, 0x85a0, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652569) }, /* #7/3/4 */
    { 0x0d5f, 0x0d49, 0x85a0, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652569) }, /* #7/3/6 */
    { 0x0d67, 0x0d49, 0x0520, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652569) }, /* #7/3/8 */
    { 0x0d6f, 0x0d49, 0x0520, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652569) }, /* #7/3/10 */
    { 0x0d77, 0x0d49, 0x0520, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652569) }, /* #7/3/12 */
    { 0x0d7f, 0x0d49, 0x0520, RTFLOAT80U_INIT_C(0,0xbf6d47c4b9471e33,16445), INT64_C(6896880071976652569) }, /* #7/3/14 */
    { 0x0104, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/0/0 */
    { 0x010c, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/0/2 */
    { 0x0114, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/0/4 */
    { 0x011c, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/0/6 */
    { 0x0124, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/0/8 */
    { 0x012c, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/0/10 */
    { 0x0134, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/0/12 */
    { 0x013c, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/0/14 */
    { 0x0504, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/1/0 */
    { 0x050c, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/1/2 */
    { 0x0514, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/1/4 */
    { 0x051c, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/1/6 */
    { 0x0524, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/1/8 */
    { 0x052c, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/1/10 */
    { 0x0534, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/1/12 */
    { 0x053c, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/1/14 */
    { 0x0904, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/2/0 */
    { 0x090c, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/2/2 */
    { 0x0914, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/2/4 */
    { 0x091c, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/2/6 */
    { 0x0924, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/2/8 */
    { 0x092c, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/2/10 */
    { 0x0934, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/2/12 */
    { 0x093c, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/2/14 */
    { 0x0d04, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/3/0 */
    { 0x0d0c, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/3/2 */
    { 0x0d14, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/3/4 */
    { 0x0d1c, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/3/6 */
    { 0x0d24, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/3/8 */
    { 0x0d2c, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/3/10 */
    { 0x0d34, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/3/12 */
    { 0x0d3c, 0x809e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #8/3/14 */
    { 0x0044, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/0/0 */
    { 0x004c, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/0/2 */
    { 0x0054, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/0/4 */
    { 0x005c, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/0/6 */
    { 0x0064, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/0/8 */
    { 0x006c, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/0/10 */
    { 0x0074, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/0/12 */
    { 0x007c, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/0/14 */
    { 0x0444, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/1/0 */
    { 0x044c, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/1/2 */
    { 0x0454, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/1/4 */
    { 0x045c, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/1/6 */
    { 0x0464, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/1/8 */
    { 0x046c, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/1/10 */
    { 0x0474, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/1/12 */
    { 0x047c, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/1/14 */
    { 0x0844, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/2/0 */
    { 0x084c, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/2/2 */
    { 0x0854, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/2/4 */
    { 0x085c, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/2/6 */
    { 0x0864, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/2/8 */
    { 0x086c, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/2/10 */
    { 0x0874, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/2/12 */
    { 0x087c, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/2/14 */
    { 0x0c44, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/3/0 */
    { 0x0c4c, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/3/2 */
    { 0x0c54, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/3/4 */
    { 0x0c5c, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/3/6 */
    { 0x0c64, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/3/8 */
    { 0x0c6c, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/3/10 */
    { 0x0c74, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/3/12 */
    { 0x0c7c, 0xd955, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #9/3/14 */
    { 0x0001, 0x035a, 0x83a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #10/0/0 */
    { 0x0009, 0x035a, 0x83a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #10/0/2 */
    { 0x0011, 0x035a, 0x83a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #10/0/4 */
    { 0x0019, 0x035a, 0x83a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #10/0/6 */
    { 0x0021, 0x035a, 0x0320, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #10/0/8 */
    { 0x0029, 0x035a, 0x0320, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #10/0/10 */
    { 0x0031, 0x035a, 0x0320, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #10/0/12 */
    { 0x0039, 0x035a, 0x0320, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #10/0/14 */
    { 0x0401, 0x035a, 0x83a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #10/1/0 */
    { 0x0409, 0x035a, 0x83a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #10/1/2 */
    { 0x0411, 0x035a, 0x83a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #10/1/4 */
    { 0x0419, 0x035a, 0x83a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #10/1/6 */
    { 0x0421, 0x035a, 0x0320, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #10/1/8 */
    { 0x0429, 0x035a, 0x0320, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #10/1/10 */
    { 0x0431, 0x035a, 0x0320, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #10/1/12 */
    { 0x0439, 0x035a, 0x0320, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #10/1/14 */
    { 0x0801, 0x035a, 0x81a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #10/2/0 */
    { 0x0809, 0x035a, 0x81a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #10/2/2 */
    { 0x0811, 0x035a, 0x81a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #10/2/4 */
    { 0x0819, 0x035a, 0x81a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #10/2/6 */
    { 0x0821, 0x035a, 0x0120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #10/2/8 */
    { 0x0829, 0x035a, 0x0120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #10/2/10 */
    { 0x0831, 0x035a, 0x0120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #10/2/12 */
    { 0x0839, 0x035a, 0x0120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #10/2/14 */
    { 0x0c01, 0x035a, 0x81a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #10/3/0 */
    { 0x0c09, 0x035a, 0x81a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #10/3/2 */
    { 0x0c11, 0x035a, 0x81a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #10/3/4 */
    { 0x0c19, 0x035a, 0x81a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #10/3/6 */
    { 0x0c21, 0x035a, 0x0120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #10/3/8 */
    { 0x0c29, 0x035a, 0x0120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #10/3/10 */
    { 0x0c31, 0x035a, 0x0120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #10/3/12 */
    { 0x0c39, 0x035a, 0x0120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #10/3/14 */
    { 0x0007, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/0/0 */
    { 0x000f, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/0/2 */
    { 0x0017, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/0/4 */
    { 0x001f, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/0/6 */
    { 0x0027, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/0/8 */
    { 0x002f, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/0/10 */
    { 0x0037, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/0/12 */
    { 0x003f, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/0/14 */
    { 0x0407, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/1/0 */
    { 0x040f, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/1/2 */
    { 0x0417, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/1/4 */
    { 0x041f, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/1/6 */
    { 0x0427, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/1/8 */
    { 0x042f, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/1/10 */
    { 0x0437, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/1/12 */
    { 0x043f, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/1/14 */
    { 0x0807, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/2/0 */
    { 0x080f, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/2/2 */
    { 0x0817, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/2/4 */
    { 0x081f, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/2/6 */
    { 0x0827, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/2/8 */
    { 0x082f, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/2/10 */
    { 0x0837, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/2/12 */
    { 0x083f, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/2/14 */
    { 0x0c07, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/3/0 */
    { 0x0c0f, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/3/2 */
    { 0x0c17, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/3/4 */
    { 0x0c1f, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/3/6 */
    { 0x0c27, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/3/8 */
    { 0x0c2f, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/3/10 */
    { 0x0c37, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/3/12 */
    { 0x0c3f, 0x3dd5, 0x0500, RTFLOAT80U_INIT_C(1,0x9022cdec8b45ea2a,16445), INT64_C(-5193045053251187989) }, /* #11/3/14 */
    { 0x0301, 0x43a1, 0xc1a0, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/0/0 */
    { 0x0309, 0x43a1, 0xc1a0, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/0/2 */
    { 0x0311, 0x43a1, 0xc1a0, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/0/4 */
    { 0x0319, 0x43a1, 0xc1a0, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/0/6 */
    { 0x0321, 0x43a1, 0x4120, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/0/8 */
    { 0x0329, 0x43a1, 0x4120, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/0/10 */
    { 0x0331, 0x43a1, 0x4120, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/0/12 */
    { 0x0339, 0x43a1, 0x4120, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/0/14 */
    { 0x0701, 0x43a1, 0xc3a0, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-2) }, /* #12/1/0 */
    { 0x0709, 0x43a1, 0xc3a0, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-2) }, /* #12/1/2 */
    { 0x0711, 0x43a1, 0xc3a0, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-2) }, /* #12/1/4 */
    { 0x0719, 0x43a1, 0xc3a0, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-2) }, /* #12/1/6 */
    { 0x0721, 0x43a1, 0x4320, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-2) }, /* #12/1/8 */
    { 0x0729, 0x43a1, 0x4320, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-2) }, /* #12/1/10 */
    { 0x0731, 0x43a1, 0x4320, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-2) }, /* #12/1/12 */
    { 0x0739, 0x43a1, 0x4320, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-2) }, /* #12/1/14 */
    { 0x0b01, 0x43a1, 0xc1a0, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/2/0 */
    { 0x0b09, 0x43a1, 0xc1a0, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/2/2 */
    { 0x0b11, 0x43a1, 0xc1a0, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/2/4 */
    { 0x0b19, 0x43a1, 0xc1a0, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/2/6 */
    { 0x0b21, 0x43a1, 0x4120, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/2/8 */
    { 0x0b29, 0x43a1, 0x4120, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/2/10 */
    { 0x0b31, 0x43a1, 0x4120, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/2/12 */
    { 0x0b39, 0x43a1, 0x4120, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/2/14 */
    { 0x0f01, 0x43a1, 0xc1a0, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/3/0 */
    { 0x0f09, 0x43a1, 0xc1a0, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/3/2 */
    { 0x0f11, 0x43a1, 0xc1a0, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/3/4 */
    { 0x0f19, 0x43a1, 0xc1a0, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/3/6 */
    { 0x0f21, 0x43a1, 0x4120, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/3/8 */
    { 0x0f29, 0x43a1, 0x4120, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/3/10 */
    { 0x0f31, 0x43a1, 0x4120, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/3/12 */
    { 0x0f39, 0x43a1, 0x4120, RTFLOAT80U_INIT_C(1,0xbb2d5b5352aedd98,16383), INT64_C(-1) }, /* #12/3/14 */
    { 0x0202, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/0/0 */
    { 0x020a, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/0/2 */
    { 0x0212, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/0/4 */
    { 0x021a, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/0/6 */
    { 0x0222, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/0/8 */
    { 0x022a, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/0/10 */
    { 0x0232, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/0/12 */
    { 0x023a, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/0/14 */
    { 0x0602, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/1/0 */
    { 0x060a, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/1/2 */
    { 0x0612, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/1/4 */
    { 0x061a, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/1/6 */
    { 0x0622, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/1/8 */
    { 0x062a, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/1/10 */
    { 0x0632, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/1/12 */
    { 0x063a, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/1/14 */
    { 0x0a02, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/2/0 */
    { 0x0a0a, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/2/2 */
    { 0x0a12, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/2/4 */
    { 0x0a1a, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/2/6 */
    { 0x0a22, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/2/8 */
    { 0x0a2a, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/2/10 */
    { 0x0a32, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/2/12 */
    { 0x0a3a, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/2/14 */
    { 0x0e02, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/3/0 */
    { 0x0e0a, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/3/2 */
    { 0x0e12, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/3/4 */
    { 0x0e1a, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/3/6 */
    { 0x0e22, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/3/8 */
    { 0x0e2a, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/3/10 */
    { 0x0e32, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/3/12 */
    { 0x0e3a, 0xaccb, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #13/3/14 */
    { 0x0101, 0x9e21, 0x84a0, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/0/0 */
    { 0x0109, 0x9e21, 0x84a0, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/0/2 */
    { 0x0111, 0x9e21, 0x84a0, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/0/4 */
    { 0x0119, 0x9e21, 0x84a0, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/0/6 */
    { 0x0121, 0x9e21, 0x0420, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/0/8 */
    { 0x0129, 0x9e21, 0x0420, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/0/10 */
    { 0x0131, 0x9e21, 0x0420, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/0/12 */
    { 0x0139, 0x9e21, 0x0420, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/0/14 */
    { 0x0501, 0x9e21, 0x84a0, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/1/0 */
    { 0x0509, 0x9e21, 0x84a0, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/1/2 */
    { 0x0511, 0x9e21, 0x84a0, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/1/4 */
    { 0x0519, 0x9e21, 0x84a0, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/1/6 */
    { 0x0521, 0x9e21, 0x0420, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/1/8 */
    { 0x0529, 0x9e21, 0x0420, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/1/10 */
    { 0x0531, 0x9e21, 0x0420, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/1/12 */
    { 0x0539, 0x9e21, 0x0420, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/1/14 */
    { 0x0901, 0x9e21, 0x86a0, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(1) }, /* #14/2/0 */
    { 0x0909, 0x9e21, 0x86a0, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(1) }, /* #14/2/2 */
    { 0x0911, 0x9e21, 0x86a0, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(1) }, /* #14/2/4 */
    { 0x0919, 0x9e21, 0x86a0, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(1) }, /* #14/2/6 */
    { 0x0921, 0x9e21, 0x0620, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(1) }, /* #14/2/8 */
    { 0x0929, 0x9e21, 0x0620, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(1) }, /* #14/2/10 */
    { 0x0931, 0x9e21, 0x0620, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(1) }, /* #14/2/12 */
    { 0x0939, 0x9e21, 0x0620, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(1) }, /* #14/2/14 */
    { 0x0d01, 0x9e21, 0x84a0, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/3/0 */
    { 0x0d09, 0x9e21, 0x84a0, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/3/2 */
    { 0x0d11, 0x9e21, 0x84a0, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/3/4 */
    { 0x0d19, 0x9e21, 0x84a0, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/3/6 */
    { 0x0d21, 0x9e21, 0x0420, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/3/8 */
    { 0x0d29, 0x9e21, 0x0420, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/3/10 */
    { 0x0d31, 0x9e21, 0x0420, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/3/12 */
    { 0x0d39, 0x9e21, 0x0420, RTFLOAT80U_INIT_C(0,0xa79eb60c83431935,0), INT64_C(0) }, /* #14/3/14 */
    { 0x0046, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/0/0 */
    { 0x004e, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/0/2 */
    { 0x0056, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/0/4 */
    { 0x005e, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/0/6 */
    { 0x0066, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/0/8 */
    { 0x006e, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/0/10 */
    { 0x0076, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/0/12 */
    { 0x007e, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/0/14 */
    { 0x0446, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/1/0 */
    { 0x044e, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/1/2 */
    { 0x0456, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/1/4 */
    { 0x045e, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/1/6 */
    { 0x0466, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/1/8 */
    { 0x046e, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/1/10 */
    { 0x0476, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/1/12 */
    { 0x047e, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/1/14 */
    { 0x0846, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/2/0 */
    { 0x084e, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/2/2 */
    { 0x0856, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/2/4 */
    { 0x085e, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/2/6 */
    { 0x0866, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/2/8 */
    { 0x086e, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/2/10 */
    { 0x0876, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/2/12 */
    { 0x087e, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/2/14 */
    { 0x0c46, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/3/0 */
    { 0x0c4e, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/3/2 */
    { 0x0c56, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/3/4 */
    { 0x0c5e, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/3/6 */
    { 0x0c66, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/3/8 */
    { 0x0c6e, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/3/10 */
    { 0x0c76, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/3/12 */
    { 0x0c7e, 0xa0fd, 0x0000, RTFLOAT80U_INIT_C(1,0xcb1daace97078e18,16445), INT64_C(-7318021084148909836) }, /* #15/3/14 */
    { 0x0301, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/0/0 */
    { 0x0309, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/0/2 */
    { 0x0311, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/0/4 */
    { 0x0319, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/0/6 */
    { 0x0321, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/0/8 */
    { 0x0329, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/0/10 */
    { 0x0331, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/0/12 */
    { 0x0339, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/0/14 */
    { 0x0701, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/1/0 */
    { 0x0709, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/1/2 */
    { 0x0711, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/1/4 */
    { 0x0719, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/1/6 */
    { 0x0721, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/1/8 */
    { 0x0729, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/1/10 */
    { 0x0731, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/1/12 */
    { 0x0739, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/1/14 */
    { 0x0b01, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/2/0 */
    { 0x0b09, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/2/2 */
    { 0x0b11, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/2/4 */
    { 0x0b19, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/2/6 */
    { 0x0b21, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/2/8 */
    { 0x0b29, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/2/10 */
    { 0x0b31, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/2/12 */
    { 0x0b39, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/2/14 */
    { 0x0f01, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/3/0 */
    { 0x0f09, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/3/2 */
    { 0x0f11, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/3/4 */
    { 0x0f19, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/3/6 */
    { 0x0f21, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/3/8 */
    { 0x0f29, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/3/10 */
    { 0x0f31, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/3/12 */
    { 0x0f39, 0x20b8, 0x0000, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #16/3/14 */
    { 0x0006, 0x497c, 0xc3a0, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(2) }, /* #17/0/0 */
    { 0x000e, 0x497c, 0xc3a0, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(2) }, /* #17/0/2 */
    { 0x0016, 0x497c, 0xc3a0, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(2) }, /* #17/0/4 */
    { 0x001e, 0x497c, 0xc3a0, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(2) }, /* #17/0/6 */
    { 0x0026, 0x497c, 0x4320, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(2) }, /* #17/0/8 */
    { 0x002e, 0x497c, 0x4320, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(2) }, /* #17/0/10 */
    { 0x0036, 0x497c, 0x4320, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(2) }, /* #17/0/12 */
    { 0x003e, 0x497c, 0x4320, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(2) }, /* #17/0/14 */
    { 0x0406, 0x497c, 0xc1a0, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(1) }, /* #17/1/0 */
    { 0x040e, 0x497c, 0xc1a0, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(1) }, /* #17/1/2 */
    { 0x0416, 0x497c, 0xc1a0, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(1) }, /* #17/1/4 */
    { 0x041e, 0x497c, 0xc1a0, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(1) }, /* #17/1/6 */
    { 0x0426, 0x497c, 0x4120, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(1) }, /* #17/1/8 */
    { 0x042e, 0x497c, 0x4120, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(1) }, /* #17/1/10 */
    { 0x0436, 0x497c, 0x4120, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(1) }, /* #17/1/12 */
    { 0x043e, 0x497c, 0x4120, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(1) }, /* #17/1/14 */
    { 0x0806, 0x497c, 0xc3a0, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(2) }, /* #17/2/0 */
    { 0x080e, 0x497c, 0xc3a0, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(2) }, /* #17/2/2 */
    { 0x0816, 0x497c, 0xc3a0, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(2) }, /* #17/2/4 */
    { 0x081e, 0x497c, 0xc3a0, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(2) }, /* #17/2/6 */
    { 0x0826, 0x497c, 0x4320, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(2) }, /* #17/2/8 */
    { 0x082e, 0x497c, 0x4320, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(2) }, /* #17/2/10 */
    { 0x0836, 0x497c, 0x4320, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(2) }, /* #17/2/12 */
    { 0x083e, 0x497c, 0x4320, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(2) }, /* #17/2/14 */
    { 0x0c06, 0x497c, 0xc1a0, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(1) }, /* #17/3/0 */
    { 0x0c0e, 0x497c, 0xc1a0, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(1) }, /* #17/3/2 */
    { 0x0c16, 0x497c, 0xc1a0, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(1) }, /* #17/3/4 */
    { 0x0c1e, 0x497c, 0xc1a0, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(1) }, /* #17/3/6 */
    { 0x0c26, 0x497c, 0x4120, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(1) }, /* #17/3/8 */
    { 0x0c2e, 0x497c, 0x4120, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(1) }, /* #17/3/10 */
    { 0x0c36, 0x497c, 0x4120, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(1) }, /* #17/3/12 */
    { 0x0c3e, 0x497c, 0x4120, RTFLOAT80U_INIT_C(0,0xc18a61b92e7b300f,16383), INT64_C(1) }, /* #17/3/14 */
    { 0x0045, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/0/0 */
    { 0x004d, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/0/2 */
    { 0x0055, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/0/4 */
    { 0x005d, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/0/6 */
    { 0x0065, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/0/8 */
    { 0x006d, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/0/10 */
    { 0x0075, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/0/12 */
    { 0x007d, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/0/14 */
    { 0x0445, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/1/0 */
    { 0x044d, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/1/2 */
    { 0x0455, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/1/4 */
    { 0x045d, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/1/6 */
    { 0x0465, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/1/8 */
    { 0x046d, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/1/10 */
    { 0x0475, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/1/12 */
    { 0x047d, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/1/14 */
    { 0x0845, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/2/0 */
    { 0x084d, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/2/2 */
    { 0x0855, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/2/4 */
    { 0x085d, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/2/6 */
    { 0x0865, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/2/8 */
    { 0x086d, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/2/10 */
    { 0x0875, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/2/12 */
    { 0x087d, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/2/14 */
    { 0x0c45, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/3/0 */
    { 0x0c4d, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/3/2 */
    { 0x0c55, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/3/4 */
    { 0x0c5d, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/3/6 */
    { 0x0c65, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/3/8 */
    { 0x0c6d, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/3/10 */
    { 0x0c75, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/3/12 */
    { 0x0c7d, 0x9a4b, 0x0000, RTFLOAT80U_INIT_C(1,0xf39ddd75aaba57c8,16445), INT64_C(-8777215210002656228) }, /* #18/3/14 */
    { 0x0301, 0x3b40, 0x81a0, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/0/0 */
    { 0x0309, 0x3b40, 0x81a0, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/0/2 */
    { 0x0311, 0x3b40, 0x81a0, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/0/4 */
    { 0x0319, 0x3b40, 0x81a0, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/0/6 */
    { 0x0321, 0x3b40, 0x0120, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/0/8 */
    { 0x0329, 0x3b40, 0x0120, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/0/10 */
    { 0x0331, 0x3b40, 0x0120, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/0/12 */
    { 0x0339, 0x3b40, 0x0120, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/0/14 */
    { 0x0701, 0x3b40, 0x81a0, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/1/0 */
    { 0x0709, 0x3b40, 0x81a0, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/1/2 */
    { 0x0711, 0x3b40, 0x81a0, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/1/4 */
    { 0x0719, 0x3b40, 0x81a0, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/1/6 */
    { 0x0721, 0x3b40, 0x0120, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/1/8 */
    { 0x0729, 0x3b40, 0x0120, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/1/10 */
    { 0x0731, 0x3b40, 0x0120, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/1/12 */
    { 0x0739, 0x3b40, 0x0120, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/1/14 */
    { 0x0b01, 0x3b40, 0x83a0, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(1) }, /* #19/2/0 */
    { 0x0b09, 0x3b40, 0x83a0, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(1) }, /* #19/2/2 */
    { 0x0b11, 0x3b40, 0x83a0, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(1) }, /* #19/2/4 */
    { 0x0b19, 0x3b40, 0x83a0, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(1) }, /* #19/2/6 */
    { 0x0b21, 0x3b40, 0x0320, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(1) }, /* #19/2/8 */
    { 0x0b29, 0x3b40, 0x0320, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(1) }, /* #19/2/10 */
    { 0x0b31, 0x3b40, 0x0320, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(1) }, /* #19/2/12 */
    { 0x0b39, 0x3b40, 0x0320, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(1) }, /* #19/2/14 */
    { 0x0f01, 0x3b40, 0x81a0, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/3/0 */
    { 0x0f09, 0x3b40, 0x81a0, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/3/2 */
    { 0x0f11, 0x3b40, 0x81a0, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/3/4 */
    { 0x0f19, 0x3b40, 0x81a0, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/3/6 */
    { 0x0f21, 0x3b40, 0x0120, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/3/8 */
    { 0x0f29, 0x3b40, 0x0120, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/3/10 */
    { 0x0f31, 0x3b40, 0x0120, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/3/12 */
    { 0x0f39, 0x3b40, 0x0120, RTFLOAT80U_INIT_C(0,0xe88d5145a75914b6,12189), INT64_C(0) }, /* #19/3/14 */
    { 0x0103, 0xd115, 0xc1a0, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/0/0 */
    { 0x010b, 0xd115, 0xc1a0, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/0/2 */
    { 0x0113, 0xd115, 0xc1a0, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/0/4 */
    { 0x011b, 0xd115, 0xc1a0, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/0/6 */
    { 0x0123, 0xd115, 0x4120, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/0/8 */
    { 0x012b, 0xd115, 0x4120, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/0/10 */
    { 0x0133, 0xd115, 0x4120, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/0/12 */
    { 0x013b, 0xd115, 0x4120, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/0/14 */
    { 0x0503, 0xd115, 0xc3a0, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(-1) }, /* #20/1/0 */
    { 0x050b, 0xd115, 0xc3a0, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(-1) }, /* #20/1/2 */
    { 0x0513, 0xd115, 0xc3a0, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(-1) }, /* #20/1/4 */
    { 0x051b, 0xd115, 0xc3a0, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(-1) }, /* #20/1/6 */
    { 0x0523, 0xd115, 0x4320, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(-1) }, /* #20/1/8 */
    { 0x052b, 0xd115, 0x4320, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(-1) }, /* #20/1/10 */
    { 0x0533, 0xd115, 0x4320, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(-1) }, /* #20/1/12 */
    { 0x053b, 0xd115, 0x4320, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(-1) }, /* #20/1/14 */
    { 0x0903, 0xd115, 0xc1a0, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/2/0 */
    { 0x090b, 0xd115, 0xc1a0, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/2/2 */
    { 0x0913, 0xd115, 0xc1a0, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/2/4 */
    { 0x091b, 0xd115, 0xc1a0, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/2/6 */
    { 0x0923, 0xd115, 0x4120, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/2/8 */
    { 0x092b, 0xd115, 0x4120, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/2/10 */
    { 0x0933, 0xd115, 0x4120, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/2/12 */
    { 0x093b, 0xd115, 0x4120, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/2/14 */
    { 0x0d03, 0xd115, 0xc1a0, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/3/0 */
    { 0x0d0b, 0xd115, 0xc1a0, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/3/2 */
    { 0x0d13, 0xd115, 0xc1a0, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/3/4 */
    { 0x0d1b, 0xd115, 0xc1a0, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/3/6 */
    { 0x0d23, 0xd115, 0x4120, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/3/8 */
    { 0x0d2b, 0xd115, 0x4120, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/3/10 */
    { 0x0d33, 0xd115, 0x4120, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/3/12 */
    { 0x0d3b, 0xd115, 0x4120, RTFLOAT80U_INIT_C(1,0xe8be6cf930fd9eb7,4893), INT64_C(0) }, /* #20/3/14 */
    { 0x0005, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/0/0 */
    { 0x000d, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/0/2 */
    { 0x0015, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/0/4 */
    { 0x001d, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/0/6 */
    { 0x0025, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/0/8 */
    { 0x002d, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/0/10 */
    { 0x0035, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/0/12 */
    { 0x003d, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/0/14 */
    { 0x0405, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/1/0 */
    { 0x040d, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/1/2 */
    { 0x0415, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/1/4 */
    { 0x041d, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/1/6 */
    { 0x0425, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/1/8 */
    { 0x042d, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/1/10 */
    { 0x0435, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/1/12 */
    { 0x043d, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/1/14 */
    { 0x0805, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/2/0 */
    { 0x080d, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/2/2 */
    { 0x0815, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/2/4 */
    { 0x081d, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/2/6 */
    { 0x0825, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/2/8 */
    { 0x082d, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/2/10 */
    { 0x0835, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/2/12 */
    { 0x083d, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/2/14 */
    { 0x0c05, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/3/0 */
    { 0x0c0d, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/3/2 */
    { 0x0c15, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/3/4 */
    { 0x0c1d, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/3/6 */
    { 0x0c25, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/3/8 */
    { 0x0c2d, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/3/10 */
    { 0x0c35, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/3/12 */
    { 0x0c3d, 0x4bee, 0x4100, RTFLOAT80U_INIT_C(1,0x8b90dfca72ca33fe,16445), INT64_C(-5028392014260279807) }, /* #21/3/14 */
    { 0x0006, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/0/0 */
    { 0x000e, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/0/2 */
    { 0x0016, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/0/4 */
    { 0x001e, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/0/6 */
    { 0x0026, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/0/8 */
    { 0x002e, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/0/10 */
    { 0x0036, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/0/12 */
    { 0x003e, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/0/14 */
    { 0x0406, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/1/0 */
    { 0x040e, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/1/2 */
    { 0x0416, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/1/4 */
    { 0x041e, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/1/6 */
    { 0x0426, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/1/8 */
    { 0x042e, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/1/10 */
    { 0x0436, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/1/12 */
    { 0x043e, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/1/14 */
    { 0x0806, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/2/0 */
    { 0x080e, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/2/2 */
    { 0x0816, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/2/4 */
    { 0x081e, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/2/6 */
    { 0x0826, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/2/8 */
    { 0x082e, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/2/10 */
    { 0x0836, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/2/12 */
    { 0x083e, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/2/14 */
    { 0x0c06, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/3/0 */
    { 0x0c0e, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/3/2 */
    { 0x0c16, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/3/4 */
    { 0x0c1e, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/3/6 */
    { 0x0c26, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/3/8 */
    { 0x0c2e, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/3/10 */
    { 0x0c36, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/3/12 */
    { 0x0c3e, 0x7f74, 0xfd81, RTFLOAT80U_INIT_C(1,0x400000000006959d,32767), INT64_C(-3) }, /* #22/3/14 */
    { 0x0043, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/0/0 */
    { 0x004b, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/0/2 */
    { 0x0053, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/0/4 */
    { 0x005b, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/0/6 */
    { 0x0063, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/0/8 */
    { 0x006b, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/0/10 */
    { 0x0073, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/0/12 */
    { 0x007b, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/0/14 */
    { 0x0443, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/1/0 */
    { 0x044b, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/1/2 */
    { 0x0453, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/1/4 */
    { 0x045b, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/1/6 */
    { 0x0463, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/1/8 */
    { 0x046b, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/1/10 */
    { 0x0473, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/1/12 */
    { 0x047b, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/1/14 */
    { 0x0843, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/2/0 */
    { 0x084b, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/2/2 */
    { 0x0853, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/2/4 */
    { 0x085b, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/2/6 */
    { 0x0863, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/2/8 */
    { 0x086b, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/2/10 */
    { 0x0873, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/2/12 */
    { 0x087b, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/2/14 */
    { 0x0c43, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/3/0 */
    { 0x0c4b, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/3/2 */
    { 0x0c53, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/3/4 */
    { 0x0c5b, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/3/6 */
    { 0x0c63, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/3/8 */
    { 0x0c6b, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/3/10 */
    { 0x0c73, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/3/12 */
    { 0x0c7b, 0x20b3, 0x0001, RTFLOAT80U_INIT_C(1,0xc000000003f796ce,32767), INT64_MIN }, /* #23/3/14 */
    { 0x0305, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/0/0 */
    { 0x030d, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/0/2 */
    { 0x0315, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/0/4 */
    { 0x031d, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/0/6 */
    { 0x0325, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/0/8 */
    { 0x032d, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/0/10 */
    { 0x0335, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/0/12 */
    { 0x033d, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/0/14 */
    { 0x0705, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/1/0 */
    { 0x070d, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/1/2 */
    { 0x0715, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/1/4 */
    { 0x071d, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/1/6 */
    { 0x0725, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/1/8 */
    { 0x072d, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/1/10 */
    { 0x0735, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/1/12 */
    { 0x073d, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/1/14 */
    { 0x0b05, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/2/0 */
    { 0x0b0d, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/2/2 */
    { 0x0b15, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/2/4 */
    { 0x0b1d, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/2/6 */
    { 0x0b25, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/2/8 */
    { 0x0b2d, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/2/10 */
    { 0x0b35, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/2/12 */
    { 0x0b3d, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/2/14 */
    { 0x0f05, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/3/0 */
    { 0x0f0d, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/3/2 */
    { 0x0f15, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/3/4 */
    { 0x0f1d, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/3/6 */
    { 0x0f25, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/3/8 */
    { 0x0f2d, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/3/10 */
    { 0x0f35, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/3/12 */
    { 0x0f3d, 0xa483, 0x0401, RTFLOAT80U_INIT_C(0,0x0,32767), INT64_MIN }, /* #24/3/14 */
    { 0x0204, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/0/0 */
    { 0x020c, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/0/2 */
    { 0x0214, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/0/4 */
    { 0x021c, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/0/6 */
    { 0x0224, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/0/8 */
    { 0x022c, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/0/10 */
    { 0x0234, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/0/12 */
    { 0x023c, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/0/14 */
    { 0x0604, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/1/0 */
    { 0x060c, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/1/2 */
    { 0x0614, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/1/4 */
    { 0x061c, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/1/6 */
    { 0x0624, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/1/8 */
    { 0x062c, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/1/10 */
    { 0x0634, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/1/12 */
    { 0x063c, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/1/14 */
    { 0x0a04, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/2/0 */
    { 0x0a0c, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/2/2 */
    { 0x0a14, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/2/4 */
    { 0x0a1c, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/2/6 */
    { 0x0a24, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/2/8 */
    { 0x0a2c, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/2/10 */
    { 0x0a34, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/2/12 */
    { 0x0a3c, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/2/14 */
    { 0x0e04, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/3/0 */
    { 0x0e0c, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/3/2 */
    { 0x0e14, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/3/4 */
    { 0x0e1c, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/3/6 */
    { 0x0e24, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/3/8 */
    { 0x0e2c, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/3/10 */
    { 0x0e34, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/3/12 */
    { 0x0e3c, 0x8b35, 0xb981, RTFLOAT80U_INIT_C(1,0x835ee8cf0ca022f5,32767), INT64_C(-3) }, /* #25/3/14 */
    { 0x0102, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/0/0 */
    { 0x010a, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/0/2 */
    { 0x0112, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/0/4 */
    { 0x011a, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/0/6 */
    { 0x0122, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/0/8 */
    { 0x012a, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/0/10 */
    { 0x0132, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/0/12 */
    { 0x013a, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/0/14 */
    { 0x0502, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/1/0 */
    { 0x050a, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/1/2 */
    { 0x0512, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/1/4 */
    { 0x051a, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/1/6 */
    { 0x0522, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/1/8 */
    { 0x052a, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/1/10 */
    { 0x0532, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/1/12 */
    { 0x053a, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/1/14 */
    { 0x0902, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/2/0 */
    { 0x090a, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/2/2 */
    { 0x0912, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/2/4 */
    { 0x091a, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/2/6 */
    { 0x0922, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/2/8 */
    { 0x092a, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/2/10 */
    { 0x0932, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/2/12 */
    { 0x093a, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/2/14 */
    { 0x0d02, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/3/0 */
    { 0x0d0a, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/3/2 */
    { 0x0d12, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/3/4 */
    { 0x0d1a, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/3/6 */
    { 0x0d22, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/3/8 */
    { 0x0d2a, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/3/10 */
    { 0x0d32, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/3/12 */
    { 0x0d3a, 0xf237, 0xf881, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #26/3/14 */
    { 0x0203, 0xf761, 0xc5a0, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/0/0 */
    { 0x020b, 0xf761, 0xc5a0, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/0/2 */
    { 0x0213, 0xf761, 0xc5a0, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/0/4 */
    { 0x021b, 0xf761, 0xc5a0, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/0/6 */
    { 0x0223, 0xf761, 0x4520, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/0/8 */
    { 0x022b, 0xf761, 0x4520, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/0/10 */
    { 0x0233, 0xf761, 0x4520, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/0/12 */
    { 0x023b, 0xf761, 0x4520, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/0/14 */
    { 0x0603, 0xf761, 0xc5a0, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/1/0 */
    { 0x060b, 0xf761, 0xc5a0, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/1/2 */
    { 0x0613, 0xf761, 0xc5a0, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/1/4 */
    { 0x061b, 0xf761, 0xc5a0, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/1/6 */
    { 0x0623, 0xf761, 0x4520, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/1/8 */
    { 0x062b, 0xf761, 0x4520, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/1/10 */
    { 0x0633, 0xf761, 0x4520, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/1/12 */
    { 0x063b, 0xf761, 0x4520, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/1/14 */
    { 0x0a03, 0xf761, 0xc7a0, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(1) }, /* #27/2/0 */
    { 0x0a0b, 0xf761, 0xc7a0, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(1) }, /* #27/2/2 */
    { 0x0a13, 0xf761, 0xc7a0, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(1) }, /* #27/2/4 */
    { 0x0a1b, 0xf761, 0xc7a0, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(1) }, /* #27/2/6 */
    { 0x0a23, 0xf761, 0x4720, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(1) }, /* #27/2/8 */
    { 0x0a2b, 0xf761, 0x4720, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(1) }, /* #27/2/10 */
    { 0x0a33, 0xf761, 0x4720, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(1) }, /* #27/2/12 */
    { 0x0a3b, 0xf761, 0x4720, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(1) }, /* #27/2/14 */
    { 0x0e03, 0xf761, 0xc5a0, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/3/0 */
    { 0x0e0b, 0xf761, 0xc5a0, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/3/2 */
    { 0x0e13, 0xf761, 0xc5a0, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/3/4 */
    { 0x0e1b, 0xf761, 0xc5a0, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/3/6 */
    { 0x0e23, 0xf761, 0x4520, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/3/8 */
    { 0x0e2b, 0xf761, 0x4520, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/3/10 */
    { 0x0e33, 0xf761, 0x4520, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/3/12 */
    { 0x0e3b, 0xf761, 0x4520, RTFLOAT80U_INIT_C(0,0x80000e481da616bd,0), INT64_C(0) }, /* #27/3/14 */
    { 0x0202, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/0/0 */
    { 0x020a, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/0/2 */
    { 0x0212, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/0/4 */
    { 0x021a, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/0/6 */
    { 0x0222, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/0/8 */
    { 0x022a, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/0/10 */
    { 0x0232, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/0/12 */
    { 0x023a, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/0/14 */
    { 0x0602, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/1/0 */
    { 0x060a, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/1/2 */
    { 0x0612, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/1/4 */
    { 0x061a, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/1/6 */
    { 0x0622, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/1/8 */
    { 0x062a, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/1/10 */
    { 0x0632, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/1/12 */
    { 0x063a, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/1/14 */
    { 0x0a02, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/2/0 */
    { 0x0a0a, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/2/2 */
    { 0x0a12, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/2/4 */
    { 0x0a1a, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/2/6 */
    { 0x0a22, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/2/8 */
    { 0x0a2a, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/2/10 */
    { 0x0a32, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/2/12 */
    { 0x0a3a, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/2/14 */
    { 0x0e02, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/3/0 */
    { 0x0e0a, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/3/2 */
    { 0x0e12, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/3/4 */
    { 0x0e1a, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/3/6 */
    { 0x0e22, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/3/8 */
    { 0x0e2a, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/3/10 */
    { 0x0e32, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/3/12 */
    { 0x0e3a, 0x3d82, 0xbd81, RTFLOAT80U_INIT_C(1,0x653e0572cabc4fb2,19076), INT64_C(-3) }, /* #28/3/14 */
    { 0x0244, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/0/0 */
    { 0x024c, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/0/2 */
    { 0x0254, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/0/4 */
    { 0x025c, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/0/6 */
    { 0x0264, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/0/8 */
    { 0x026c, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/0/10 */
    { 0x0274, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/0/12 */
    { 0x027c, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/0/14 */
    { 0x0644, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/1/0 */
    { 0x064c, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/1/2 */
    { 0x0654, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/1/4 */
    { 0x065c, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/1/6 */
    { 0x0664, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/1/8 */
    { 0x066c, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/1/10 */
    { 0x0674, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/1/12 */
    { 0x067c, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/1/14 */
    { 0x0a44, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/2/0 */
    { 0x0a4c, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/2/2 */
    { 0x0a54, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/2/4 */
    { 0x0a5c, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/2/6 */
    { 0x0a64, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/2/8 */
    { 0x0a6c, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/2/10 */
    { 0x0a74, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/2/12 */
    { 0x0a7c, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/2/14 */
    { 0x0e44, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/3/0 */
    { 0x0e4c, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/3/2 */
    { 0x0e54, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/3/4 */
    { 0x0e5c, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/3/6 */
    { 0x0e64, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/3/8 */
    { 0x0e6c, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/3/10 */
    { 0x0e74, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/3/12 */
    { 0x0e7c, 0xe6e3, 0xfc81, RTFLOAT80U_INIT_C(1,0xee2,12017), INT64_C(-3) }, /* #29/3/14 */
    { 0x0305, 0x8cff, 0x84a0, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/0/0 */
    { 0x030d, 0x8cff, 0x84a0, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/0/2 */
    { 0x0315, 0x8cff, 0x84a0, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/0/4 */
    { 0x031d, 0x8cff, 0x84a0, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/0/6 */
    { 0x0325, 0x8cff, 0x0420, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/0/8 */
    { 0x032d, 0x8cff, 0x0420, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/0/10 */
    { 0x0335, 0x8cff, 0x0420, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/0/12 */
    { 0x033d, 0x8cff, 0x0420, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/0/14 */
    { 0x0705, 0x8cff, 0x86a0, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-2) }, /* #30/1/0 */
    { 0x070d, 0x8cff, 0x86a0, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-2) }, /* #30/1/2 */
    { 0x0715, 0x8cff, 0x86a0, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-2) }, /* #30/1/4 */
    { 0x071d, 0x8cff, 0x86a0, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-2) }, /* #30/1/6 */
    { 0x0725, 0x8cff, 0x0620, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-2) }, /* #30/1/8 */
    { 0x072d, 0x8cff, 0x0620, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-2) }, /* #30/1/10 */
    { 0x0735, 0x8cff, 0x0620, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-2) }, /* #30/1/12 */
    { 0x073d, 0x8cff, 0x0620, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-2) }, /* #30/1/14 */
    { 0x0b05, 0x8cff, 0x84a0, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/2/0 */
    { 0x0b0d, 0x8cff, 0x84a0, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/2/2 */
    { 0x0b15, 0x8cff, 0x84a0, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/2/4 */
    { 0x0b1d, 0x8cff, 0x84a0, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/2/6 */
    { 0x0b25, 0x8cff, 0x0420, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/2/8 */
    { 0x0b2d, 0x8cff, 0x0420, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/2/10 */
    { 0x0b35, 0x8cff, 0x0420, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/2/12 */
    { 0x0b3d, 0x8cff, 0x0420, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/2/14 */
    { 0x0f05, 0x8cff, 0x84a0, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/3/0 */
    { 0x0f0d, 0x8cff, 0x84a0, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/3/2 */
    { 0x0f15, 0x8cff, 0x84a0, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/3/4 */
    { 0x0f1d, 0x8cff, 0x84a0, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/3/6 */
    { 0x0f25, 0x8cff, 0x0420, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/3/8 */
    { 0x0f2d, 0x8cff, 0x0420, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/3/10 */
    { 0x0f35, 0x8cff, 0x0420, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/3/12 */
    { 0x0f3d, 0x8cff, 0x0420, RTFLOAT80U_INIT_C(1,0xa34a6339d530c561,16383), INT64_C(-1) }, /* #30/3/14 */
    { 0x0340, 0xcf25, 0xc5a0, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/0/0 */
    { 0x0348, 0xcf25, 0xc5a0, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/0/2 */
    { 0x0350, 0xcf25, 0xc5a0, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/0/4 */
    { 0x0358, 0xcf25, 0xc5a0, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/0/6 */
    { 0x0360, 0xcf25, 0x4520, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/0/8 */
    { 0x0368, 0xcf25, 0x4520, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/0/10 */
    { 0x0370, 0xcf25, 0x4520, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/0/12 */
    { 0x0378, 0xcf25, 0x4520, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/0/14 */
    { 0x0740, 0xcf25, 0xc5a0, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/1/0 */
    { 0x0748, 0xcf25, 0xc5a0, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/1/2 */
    { 0x0750, 0xcf25, 0xc5a0, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/1/4 */
    { 0x0758, 0xcf25, 0xc5a0, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/1/6 */
    { 0x0760, 0xcf25, 0x4520, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/1/8 */
    { 0x0768, 0xcf25, 0x4520, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/1/10 */
    { 0x0770, 0xcf25, 0x4520, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/1/12 */
    { 0x0778, 0xcf25, 0x4520, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/1/14 */
    { 0x0b40, 0xcf25, 0xc7a0, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(1) }, /* #31/2/0 */
    { 0x0b48, 0xcf25, 0xc7a0, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(1) }, /* #31/2/2 */
    { 0x0b50, 0xcf25, 0xc7a0, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(1) }, /* #31/2/4 */
    { 0x0b58, 0xcf25, 0xc7a0, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(1) }, /* #31/2/6 */
    { 0x0b60, 0xcf25, 0x4720, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(1) }, /* #31/2/8 */
    { 0x0b68, 0xcf25, 0x4720, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(1) }, /* #31/2/10 */
    { 0x0b70, 0xcf25, 0x4720, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(1) }, /* #31/2/12 */
    { 0x0b78, 0xcf25, 0x4720, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(1) }, /* #31/2/14 */
    { 0x0f40, 0xcf25, 0xc5a0, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/3/0 */
    { 0x0f48, 0xcf25, 0xc5a0, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/3/2 */
    { 0x0f50, 0xcf25, 0xc5a0, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/3/4 */
    { 0x0f58, 0xcf25, 0xc5a0, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/3/6 */
    { 0x0f60, 0xcf25, 0x4520, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/3/8 */
    { 0x0f68, 0xcf25, 0x4520, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/3/10 */
    { 0x0f70, 0xcf25, 0x4520, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/3/12 */
    { 0x0f78, 0xcf25, 0x4520, RTFLOAT80U_INIT_C(0,0x55b8f6dfd647fae9,0), INT64_C(0) }, /* #31/3/14 */
    { 0x0143, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/0/0 */
    { 0x014b, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/0/2 */
    { 0x0153, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/0/4 */
    { 0x015b, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/0/6 */
    { 0x0163, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/0/8 */
    { 0x016b, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/0/10 */
    { 0x0173, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/0/12 */
    { 0x017b, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/0/14 */
    { 0x0543, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/1/0 */
    { 0x054b, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/1/2 */
    { 0x0553, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/1/4 */
    { 0x055b, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/1/6 */
    { 0x0563, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/1/8 */
    { 0x056b, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/1/10 */
    { 0x0573, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/1/12 */
    { 0x057b, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/1/14 */
    { 0x0943, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/2/0 */
    { 0x094b, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/2/2 */
    { 0x0953, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/2/4 */
    { 0x095b, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/2/6 */
    { 0x0963, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/2/8 */
    { 0x096b, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/2/10 */
    { 0x0973, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/2/12 */
    { 0x097b, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/2/14 */
    { 0x0d43, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/3/0 */
    { 0x0d4b, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/3/2 */
    { 0x0d53, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/3/4 */
    { 0x0d5b, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/3/6 */
    { 0x0d63, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/3/8 */
    { 0x0d6b, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/3/10 */
    { 0x0d73, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/3/12 */
    { 0x0d7b, 0x68fa, 0x4001, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_MIN }, /* #32/3/14 */
    { 0x0104, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/0/0 */
    { 0x010c, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/0/2 */
    { 0x0114, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/0/4 */
    { 0x011c, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/0/6 */
    { 0x0124, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/0/8 */
    { 0x012c, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/0/10 */
    { 0x0134, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/0/12 */
    { 0x013c, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/0/14 */
    { 0x0504, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/1/0 */
    { 0x050c, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/1/2 */
    { 0x0514, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/1/4 */
    { 0x051c, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/1/6 */
    { 0x0524, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/1/8 */
    { 0x052c, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/1/10 */
    { 0x0534, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/1/12 */
    { 0x053c, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/1/14 */
    { 0x0904, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/2/0 */
    { 0x090c, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/2/2 */
    { 0x0914, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/2/4 */
    { 0x091c, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/2/6 */
    { 0x0924, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/2/8 */
    { 0x092c, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/2/10 */
    { 0x0934, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/2/12 */
    { 0x093c, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/2/14 */
    { 0x0d04, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/3/0 */
    { 0x0d0c, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/3/2 */
    { 0x0d14, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/3/4 */
    { 0x0d1c, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/3/6 */
    { 0x0d24, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/3/8 */
    { 0x0d2c, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/3/10 */
    { 0x0d34, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/3/12 */
    { 0x0d3c, 0x4e65, 0xfc81, RTFLOAT80U_INIT_C(0,0x3e539b9b3ac4ff01,32767), INT64_C(-3) }, /* #33/3/14 */
    { 0x0104, 0xd0bd, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/0/0 */
    { 0x010c, 0xd0bd, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/0/2 */
    { 0x0114, 0xd0bd, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/0/4 */
    { 0x011c, 0xd0bd, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/0/6 */
    { 0x0124, 0xd0bd, 0x4020, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/0/8 */
    { 0x012c, 0xd0bd, 0x4020, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/0/10 */
    { 0x0134, 0xd0bd, 0x4020, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/0/12 */
    { 0x013c, 0xd0bd, 0x4020, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/0/14 */
    { 0x0504, 0xd0bd, 0xc2a0, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(-1) }, /* #34/1/0 */
    { 0x050c, 0xd0bd, 0xc2a0, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(-1) }, /* #34/1/2 */
    { 0x0514, 0xd0bd, 0xc2a0, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(-1) }, /* #34/1/4 */
    { 0x051c, 0xd0bd, 0xc2a0, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(-1) }, /* #34/1/6 */
    { 0x0524, 0xd0bd, 0x4220, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(-1) }, /* #34/1/8 */
    { 0x052c, 0xd0bd, 0x4220, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(-1) }, /* #34/1/10 */
    { 0x0534, 0xd0bd, 0x4220, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(-1) }, /* #34/1/12 */
    { 0x053c, 0xd0bd, 0x4220, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(-1) }, /* #34/1/14 */
    { 0x0904, 0xd0bd, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/2/0 */
    { 0x090c, 0xd0bd, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/2/2 */
    { 0x0914, 0xd0bd, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/2/4 */
    { 0x091c, 0xd0bd, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/2/6 */
    { 0x0924, 0xd0bd, 0x4020, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/2/8 */
    { 0x092c, 0xd0bd, 0x4020, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/2/10 */
    { 0x0934, 0xd0bd, 0x4020, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/2/12 */
    { 0x093c, 0xd0bd, 0x4020, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/2/14 */
    { 0x0d04, 0xd0bd, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/3/0 */
    { 0x0d0c, 0xd0bd, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/3/2 */
    { 0x0d14, 0xd0bd, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/3/4 */
    { 0x0d1c, 0xd0bd, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/3/6 */
    { 0x0d24, 0xd0bd, 0x4020, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/3/8 */
    { 0x0d2c, 0xd0bd, 0x4020, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/3/10 */
    { 0x0d34, 0xd0bd, 0x4020, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/3/12 */
    { 0x0d3c, 0xd0bd, 0x4020, RTFLOAT80U_INIT_C(1,0x8034ed36df0319c8,0), INT64_C(0) }, /* #34/3/14 */
    { 0x0203, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/0/0 */
    { 0x020b, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/0/2 */
    { 0x0213, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/0/4 */
    { 0x021b, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/0/6 */
    { 0x0223, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/0/8 */
    { 0x022b, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/0/10 */
    { 0x0233, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/0/12 */
    { 0x023b, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/0/14 */
    { 0x0603, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/1/0 */
    { 0x060b, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/1/2 */
    { 0x0613, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/1/4 */
    { 0x061b, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/1/6 */
    { 0x0623, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/1/8 */
    { 0x062b, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/1/10 */
    { 0x0633, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/1/12 */
    { 0x063b, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/1/14 */
    { 0x0a03, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/2/0 */
    { 0x0a0b, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/2/2 */
    { 0x0a13, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/2/4 */
    { 0x0a1b, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/2/6 */
    { 0x0a23, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/2/8 */
    { 0x0a2b, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/2/10 */
    { 0x0a33, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/2/12 */
    { 0x0a3b, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/2/14 */
    { 0x0e03, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/3/0 */
    { 0x0e0b, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/3/2 */
    { 0x0e13, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/3/4 */
    { 0x0e1b, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/3/6 */
    { 0x0e23, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/3/8 */
    { 0x0e2b, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/3/10 */
    { 0x0e33, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/3/12 */
    { 0x0e3b, 0x666a, 0x4400, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #35/3/14 */
    { 0x0103, 0x1f5a, 0x0501, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #36/0/0 */
    { 0x010b, 0x1f5a, 0x0501, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #36/0/2 */
    { 0x0113, 0x1f5a, 0x0501, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #36/0/4 */
    { 0x011b, 0x1f5a, 0x0501, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #36/0/6 */
    { 0x0123, 0x1f5a, 0x0501, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #36/0/8 */
    { 0x012b, 0x1f5a, 0x0501, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #36/0/10 */
    { 0x0133, 0x1f5a, 0x0501, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #36/0/12 */
    { 0x013b, 0x1f5a, 0x0501, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #36/0/14 */
    { 0x0503, 0x1f5a, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #36/1/0 */
    { 0x050b, 0x1f5a, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #36/1/2 */
    { 0x0513, 0x1f5a, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #36/1/4 */
    { 0x051b, 0x1f5a, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #36/1/6 */
    { 0x0523, 0x1f5a, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #36/1/8 */
    { 0x052b, 0x1f5a, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #36/1/10 */
    { 0x0533, 0x1f5a, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #36/1/12 */
    { 0x053b, 0x1f5a, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #36/1/14 */
    { 0x0903, 0x1f5a, 0x0501, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #36/2/0 */
    { 0x090b, 0x1f5a, 0x0501, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #36/2/2 */
    { 0x0913, 0x1f5a, 0x0501, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #36/2/4 */
    { 0x091b, 0x1f5a, 0x0501, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #36/2/6 */
    { 0x0923, 0x1f5a, 0x0501, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #36/2/8 */
    { 0x092b, 0x1f5a, 0x0501, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #36/2/10 */
    { 0x0933, 0x1f5a, 0x0501, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #36/2/12 */
    { 0x093b, 0x1f5a, 0x0501, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #36/2/14 */
    { 0x0d03, 0x1f5a, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #36/3/0 */
    { 0x0d0b, 0x1f5a, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #36/3/2 */
    { 0x0d13, 0x1f5a, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #36/3/4 */
    { 0x0d1b, 0x1f5a, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #36/3/6 */
    { 0x0d23, 0x1f5a, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #36/3/8 */
    { 0x0d2b, 0x1f5a, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #36/3/10 */
    { 0x0d33, 0x1f5a, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #36/3/12 */
    { 0x0d3b, 0x1f5a, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #36/3/14 */
    { 0x0241, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/0/0 */
    { 0x0249, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/0/2 */
    { 0x0251, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/0/4 */
    { 0x0259, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/0/6 */
    { 0x0261, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/0/8 */
    { 0x0269, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/0/10 */
    { 0x0271, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/0/12 */
    { 0x0279, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/0/14 */
    { 0x0641, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/1/0 */
    { 0x0649, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/1/2 */
    { 0x0651, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/1/4 */
    { 0x0659, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/1/6 */
    { 0x0661, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/1/8 */
    { 0x0669, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/1/10 */
    { 0x0671, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/1/12 */
    { 0x0679, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/1/14 */
    { 0x0a41, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/2/0 */
    { 0x0a49, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/2/2 */
    { 0x0a51, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/2/4 */
    { 0x0a59, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/2/6 */
    { 0x0a61, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/2/8 */
    { 0x0a69, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/2/10 */
    { 0x0a71, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/2/12 */
    { 0x0a79, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/2/14 */
    { 0x0e41, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/3/0 */
    { 0x0e49, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/3/2 */
    { 0x0e51, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/3/4 */
    { 0x0e59, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/3/6 */
    { 0x0e61, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/3/8 */
    { 0x0e69, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/3/10 */
    { 0x0e71, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/3/12 */
    { 0x0e79, 0x02ac, 0x0001, RTFLOAT80U_INIT_C(0,0x4e497408823dc6d9,19194), INT64_MIN }, /* #37/3/14 */
    { 0x0340, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/0/0 */
    { 0x0348, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/0/2 */
    { 0x0350, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/0/4 */
    { 0x0358, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/0/6 */
    { 0x0360, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/0/8 */
    { 0x0368, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/0/10 */
    { 0x0370, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/0/12 */
    { 0x0378, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/0/14 */
    { 0x0740, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/1/0 */
    { 0x0748, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/1/2 */
    { 0x0750, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/1/4 */
    { 0x0758, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/1/6 */
    { 0x0760, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/1/8 */
    { 0x0768, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/1/10 */
    { 0x0770, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/1/12 */
    { 0x0778, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/1/14 */
    { 0x0b40, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/2/0 */
    { 0x0b48, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/2/2 */
    { 0x0b50, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/2/4 */
    { 0x0b58, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/2/6 */
    { 0x0b60, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/2/8 */
    { 0x0b68, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/2/10 */
    { 0x0b70, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/2/12 */
    { 0x0b78, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/2/14 */
    { 0x0f40, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/3/0 */
    { 0x0f48, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/3/2 */
    { 0x0f50, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/3/4 */
    { 0x0f58, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/3/6 */
    { 0x0f60, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/3/8 */
    { 0x0f68, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/3/10 */
    { 0x0f70, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/3/12 */
    { 0x0f78, 0xe302, 0xf981, RTFLOAT80U_INIT_C(1,0xd3b92350880cb519,32767), INT64_C(-3) }, /* #38/3/14 */
    { 0x0202, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/0/0 */
    { 0x020a, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/0/2 */
    { 0x0212, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/0/4 */
    { 0x021a, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/0/6 */
    { 0x0222, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/0/8 */
    { 0x022a, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/0/10 */
    { 0x0232, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/0/12 */
    { 0x023a, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/0/14 */
    { 0x0602, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/1/0 */
    { 0x060a, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/1/2 */
    { 0x0612, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/1/4 */
    { 0x061a, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/1/6 */
    { 0x0622, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/1/8 */
    { 0x062a, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/1/10 */
    { 0x0632, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/1/12 */
    { 0x063a, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/1/14 */
    { 0x0a02, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/2/0 */
    { 0x0a0a, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/2/2 */
    { 0x0a12, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/2/4 */
    { 0x0a1a, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/2/6 */
    { 0x0a22, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/2/8 */
    { 0x0a2a, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/2/10 */
    { 0x0a32, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/2/12 */
    { 0x0a3a, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/2/14 */
    { 0x0e02, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/3/0 */
    { 0x0e0a, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/3/2 */
    { 0x0e12, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/3/4 */
    { 0x0e1a, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/3/6 */
    { 0x0e22, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/3/8 */
    { 0x0e2a, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/3/10 */
    { 0x0e32, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/3/12 */
    { 0x0e3a, 0x1c8a, 0xbc81, RTFLOAT80U_INIT_C(0,0x27a930f6083e3c66,24904), INT64_C(-3) }, /* #39/3/14 */
    { 0x0006, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/0/0 */
    { 0x000e, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/0/2 */
    { 0x0016, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/0/4 */
    { 0x001e, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/0/6 */
    { 0x0026, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/0/8 */
    { 0x002e, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/0/10 */
    { 0x0036, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/0/12 */
    { 0x003e, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/0/14 */
    { 0x0406, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/1/0 */
    { 0x040e, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/1/2 */
    { 0x0416, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/1/4 */
    { 0x041e, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/1/6 */
    { 0x0426, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/1/8 */
    { 0x042e, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/1/10 */
    { 0x0436, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/1/12 */
    { 0x043e, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/1/14 */
    { 0x0806, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/2/0 */
    { 0x080e, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/2/2 */
    { 0x0816, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/2/4 */
    { 0x081e, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/2/6 */
    { 0x0826, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/2/8 */
    { 0x082e, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/2/10 */
    { 0x0836, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/2/12 */
    { 0x083e, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/2/14 */
    { 0x0c06, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/3/0 */
    { 0x0c0e, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/3/2 */
    { 0x0c16, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/3/4 */
    { 0x0c1e, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/3/6 */
    { 0x0c26, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/3/8 */
    { 0x0c2e, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/3/10 */
    { 0x0c36, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/3/12 */
    { 0x0c3e, 0xc9f5, 0x4100, RTFLOAT80U_INIT_C(0,0x9a1246c6f6c0e47c,16445), INT64_C(5551006925889499710) }, /* #40/3/14 */
    { 0x0043, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/0/0 */
    { 0x004b, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/0/2 */
    { 0x0053, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/0/4 */
    { 0x005b, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/0/6 */
    { 0x0063, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/0/8 */
    { 0x006b, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/0/10 */
    { 0x0073, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/0/12 */
    { 0x007b, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/0/14 */
    { 0x0443, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/1/0 */
    { 0x044b, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/1/2 */
    { 0x0453, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/1/4 */
    { 0x045b, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/1/6 */
    { 0x0463, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/1/8 */
    { 0x046b, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/1/10 */
    { 0x0473, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/1/12 */
    { 0x047b, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/1/14 */
    { 0x0843, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/2/0 */
    { 0x084b, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/2/2 */
    { 0x0853, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/2/4 */
    { 0x085b, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/2/6 */
    { 0x0863, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/2/8 */
    { 0x086b, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/2/10 */
    { 0x0873, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/2/12 */
    { 0x087b, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/2/14 */
    { 0x0c43, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/3/0 */
    { 0x0c4b, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/3/2 */
    { 0x0c53, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/3/4 */
    { 0x0c5b, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/3/6 */
    { 0x0c63, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/3/8 */
    { 0x0c6b, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/3/10 */
    { 0x0c73, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/3/12 */
    { 0x0c7b, 0xc6b8, 0x4401, RTFLOAT80U_INIT_C(1,0xa25106432dd96f6e,32767), INT64_MIN }, /* #41/3/14 */
    { 0x0242, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/0/0 */
    { 0x024a, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/0/2 */
    { 0x0252, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/0/4 */
    { 0x025a, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/0/6 */
    { 0x0262, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/0/8 */
    { 0x026a, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/0/10 */
    { 0x0272, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/0/12 */
    { 0x027a, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/0/14 */
    { 0x0642, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/1/0 */
    { 0x064a, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/1/2 */
    { 0x0652, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/1/4 */
    { 0x065a, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/1/6 */
    { 0x0662, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/1/8 */
    { 0x066a, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/1/10 */
    { 0x0672, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/1/12 */
    { 0x067a, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/1/14 */
    { 0x0a42, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/2/0 */
    { 0x0a4a, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/2/2 */
    { 0x0a52, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/2/4 */
    { 0x0a5a, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/2/6 */
    { 0x0a62, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/2/8 */
    { 0x0a6a, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/2/10 */
    { 0x0a72, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/2/12 */
    { 0x0a7a, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/2/14 */
    { 0x0e42, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/3/0 */
    { 0x0e4a, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/3/2 */
    { 0x0e52, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/3/4 */
    { 0x0e5a, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/3/6 */
    { 0x0e62, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/3/8 */
    { 0x0e6a, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/3/10 */
    { 0x0e72, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/3/12 */
    { 0x0e7a, 0xb3c5, 0xb981, RTFLOAT80U_INIT_C(1,0x3e22a901d43a78ab,953), INT64_C(-3) }, /* #42/3/14 */
    { 0x0340, 0xd055, 0xc0a0, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/0/0 */
    { 0x0348, 0xd055, 0xc0a0, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/0/2 */
    { 0x0350, 0xd055, 0xc0a0, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/0/4 */
    { 0x0358, 0xd055, 0xc0a0, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/0/6 */
    { 0x0360, 0xd055, 0x4020, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/0/8 */
    { 0x0368, 0xd055, 0x4020, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/0/10 */
    { 0x0370, 0xd055, 0x4020, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/0/12 */
    { 0x0378, 0xd055, 0x4020, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/0/14 */
    { 0x0740, 0xd055, 0xc0a0, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/1/0 */
    { 0x0748, 0xd055, 0xc0a0, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/1/2 */
    { 0x0750, 0xd055, 0xc0a0, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/1/4 */
    { 0x0758, 0xd055, 0xc0a0, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/1/6 */
    { 0x0760, 0xd055, 0x4020, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/1/8 */
    { 0x0768, 0xd055, 0x4020, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/1/10 */
    { 0x0770, 0xd055, 0x4020, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/1/12 */
    { 0x0778, 0xd055, 0x4020, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/1/14 */
    { 0x0b40, 0xd055, 0xc2a0, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(2) }, /* #43/2/0 */
    { 0x0b48, 0xd055, 0xc2a0, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(2) }, /* #43/2/2 */
    { 0x0b50, 0xd055, 0xc2a0, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(2) }, /* #43/2/4 */
    { 0x0b58, 0xd055, 0xc2a0, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(2) }, /* #43/2/6 */
    { 0x0b60, 0xd055, 0x4220, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(2) }, /* #43/2/8 */
    { 0x0b68, 0xd055, 0x4220, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(2) }, /* #43/2/10 */
    { 0x0b70, 0xd055, 0x4220, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(2) }, /* #43/2/12 */
    { 0x0b78, 0xd055, 0x4220, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(2) }, /* #43/2/14 */
    { 0x0f40, 0xd055, 0xc0a0, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/3/0 */
    { 0x0f48, 0xd055, 0xc0a0, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/3/2 */
    { 0x0f50, 0xd055, 0xc0a0, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/3/4 */
    { 0x0f58, 0xd055, 0xc0a0, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/3/6 */
    { 0x0f60, 0xd055, 0x4020, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/3/8 */
    { 0x0f68, 0xd055, 0x4020, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/3/10 */
    { 0x0f70, 0xd055, 0x4020, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/3/12 */
    { 0x0f78, 0xd055, 0x4020, RTFLOAT80U_INIT_C(0,0x9773bed7115b4d43,16383), INT64_C(1) }, /* #43/3/14 */
    { 0x0006, 0xd9ae, 0xc1a0, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/0/0 */
    { 0x000e, 0xd9ae, 0xc1a0, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/0/2 */
    { 0x0016, 0xd9ae, 0xc1a0, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/0/4 */
    { 0x001e, 0xd9ae, 0xc1a0, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/0/6 */
    { 0x0026, 0xd9ae, 0x4120, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/0/8 */
    { 0x002e, 0xd9ae, 0x4120, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/0/10 */
    { 0x0036, 0xd9ae, 0x4120, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/0/12 */
    { 0x003e, 0xd9ae, 0x4120, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/0/14 */
    { 0x0406, 0xd9ae, 0xc1a0, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/1/0 */
    { 0x040e, 0xd9ae, 0xc1a0, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/1/2 */
    { 0x0416, 0xd9ae, 0xc1a0, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/1/4 */
    { 0x041e, 0xd9ae, 0xc1a0, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/1/6 */
    { 0x0426, 0xd9ae, 0x4120, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/1/8 */
    { 0x042e, 0xd9ae, 0x4120, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/1/10 */
    { 0x0436, 0xd9ae, 0x4120, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/1/12 */
    { 0x043e, 0xd9ae, 0x4120, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/1/14 */
    { 0x0806, 0xd9ae, 0xc3a0, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(1) }, /* #44/2/0 */
    { 0x080e, 0xd9ae, 0xc3a0, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(1) }, /* #44/2/2 */
    { 0x0816, 0xd9ae, 0xc3a0, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(1) }, /* #44/2/4 */
    { 0x081e, 0xd9ae, 0xc3a0, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(1) }, /* #44/2/6 */
    { 0x0826, 0xd9ae, 0x4320, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(1) }, /* #44/2/8 */
    { 0x082e, 0xd9ae, 0x4320, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(1) }, /* #44/2/10 */
    { 0x0836, 0xd9ae, 0x4320, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(1) }, /* #44/2/12 */
    { 0x083e, 0xd9ae, 0x4320, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(1) }, /* #44/2/14 */
    { 0x0c06, 0xd9ae, 0xc1a0, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/3/0 */
    { 0x0c0e, 0xd9ae, 0xc1a0, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/3/2 */
    { 0x0c16, 0xd9ae, 0xc1a0, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/3/4 */
    { 0x0c1e, 0xd9ae, 0xc1a0, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/3/6 */
    { 0x0c26, 0xd9ae, 0x4120, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/3/8 */
    { 0x0c2e, 0xd9ae, 0x4120, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/3/10 */
    { 0x0c36, 0xd9ae, 0x4120, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/3/12 */
    { 0x0c3e, 0xd9ae, 0x4120, RTFLOAT80U_INIT_C(0,0xaa47a5b3a720c970,2297), INT64_C(0) }, /* #44/3/14 */
    { 0x0305, 0x3896, 0x80a0, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/0/0 */
    { 0x030d, 0x3896, 0x80a0, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/0/2 */
    { 0x0315, 0x3896, 0x80a0, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/0/4 */
    { 0x031d, 0x3896, 0x80a0, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/0/6 */
    { 0x0325, 0x3896, 0x0020, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/0/8 */
    { 0x032d, 0x3896, 0x0020, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/0/10 */
    { 0x0335, 0x3896, 0x0020, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/0/12 */
    { 0x033d, 0x3896, 0x0020, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/0/14 */
    { 0x0705, 0x3896, 0x80a0, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/1/0 */
    { 0x070d, 0x3896, 0x80a0, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/1/2 */
    { 0x0715, 0x3896, 0x80a0, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/1/4 */
    { 0x071d, 0x3896, 0x80a0, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/1/6 */
    { 0x0725, 0x3896, 0x0020, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/1/8 */
    { 0x072d, 0x3896, 0x0020, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/1/10 */
    { 0x0735, 0x3896, 0x0020, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/1/12 */
    { 0x073d, 0x3896, 0x0020, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/1/14 */
    { 0x0b05, 0x3896, 0x82a0, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(2) }, /* #45/2/0 */
    { 0x0b0d, 0x3896, 0x82a0, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(2) }, /* #45/2/2 */
    { 0x0b15, 0x3896, 0x82a0, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(2) }, /* #45/2/4 */
    { 0x0b1d, 0x3896, 0x82a0, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(2) }, /* #45/2/6 */
    { 0x0b25, 0x3896, 0x0220, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(2) }, /* #45/2/8 */
    { 0x0b2d, 0x3896, 0x0220, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(2) }, /* #45/2/10 */
    { 0x0b35, 0x3896, 0x0220, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(2) }, /* #45/2/12 */
    { 0x0b3d, 0x3896, 0x0220, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(2) }, /* #45/2/14 */
    { 0x0f05, 0x3896, 0x80a0, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/3/0 */
    { 0x0f0d, 0x3896, 0x80a0, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/3/2 */
    { 0x0f15, 0x3896, 0x80a0, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/3/4 */
    { 0x0f1d, 0x3896, 0x80a0, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/3/6 */
    { 0x0f25, 0x3896, 0x0020, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/3/8 */
    { 0x0f2d, 0x3896, 0x0020, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/3/10 */
    { 0x0f35, 0x3896, 0x0020, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/3/12 */
    { 0x0f3d, 0x3896, 0x0020, RTFLOAT80U_INIT_C(0,0xa7d7541aa4329f1e,16383), INT64_C(1) }, /* #45/3/14 */
    { 0x0002, 0xb4ce, 0x84a0, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/0/0 */
    { 0x000a, 0xb4ce, 0x84a0, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/0/2 */
    { 0x0012, 0xb4ce, 0x84a0, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/0/4 */
    { 0x001a, 0xb4ce, 0x84a0, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/0/6 */
    { 0x0022, 0xb4ce, 0x0420, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/0/8 */
    { 0x002a, 0xb4ce, 0x0420, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/0/10 */
    { 0x0032, 0xb4ce, 0x0420, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/0/12 */
    { 0x003a, 0xb4ce, 0x0420, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/0/14 */
    { 0x0402, 0xb4ce, 0x86a0, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058907) }, /* #46/1/0 */
    { 0x040a, 0xb4ce, 0x86a0, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058907) }, /* #46/1/2 */
    { 0x0412, 0xb4ce, 0x86a0, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058907) }, /* #46/1/4 */
    { 0x041a, 0xb4ce, 0x86a0, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058907) }, /* #46/1/6 */
    { 0x0422, 0xb4ce, 0x0620, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058907) }, /* #46/1/8 */
    { 0x042a, 0xb4ce, 0x0620, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058907) }, /* #46/1/10 */
    { 0x0432, 0xb4ce, 0x0620, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058907) }, /* #46/1/12 */
    { 0x043a, 0xb4ce, 0x0620, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058907) }, /* #46/1/14 */
    { 0x0802, 0xb4ce, 0x84a0, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/2/0 */
    { 0x080a, 0xb4ce, 0x84a0, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/2/2 */
    { 0x0812, 0xb4ce, 0x84a0, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/2/4 */
    { 0x081a, 0xb4ce, 0x84a0, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/2/6 */
    { 0x0822, 0xb4ce, 0x0420, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/2/8 */
    { 0x082a, 0xb4ce, 0x0420, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/2/10 */
    { 0x0832, 0xb4ce, 0x0420, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/2/12 */
    { 0x083a, 0xb4ce, 0x0420, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/2/14 */
    { 0x0c02, 0xb4ce, 0x84a0, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/3/0 */
    { 0x0c0a, 0xb4ce, 0x84a0, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/3/2 */
    { 0x0c12, 0xb4ce, 0x84a0, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/3/4 */
    { 0x0c1a, 0xb4ce, 0x84a0, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/3/6 */
    { 0x0c22, 0xb4ce, 0x0420, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/3/8 */
    { 0x0c2a, 0xb4ce, 0x0420, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/3/10 */
    { 0x0c32, 0xb4ce, 0x0420, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/3/12 */
    { 0x0c3a, 0xb4ce, 0x0420, RTFLOAT80U_INIT_C(1,0xae72edcf1f547635,16445), INT64_C(-6285185491892058906) }, /* #46/3/14 */
    { 0x0005, 0x5ed6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/0/0 */
    { 0x000d, 0x5ed6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/0/2 */
    { 0x0015, 0x5ed6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/0/4 */
    { 0x001d, 0x5ed6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/0/6 */
    { 0x0025, 0x5ed6, 0x4420, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/0/8 */
    { 0x002d, 0x5ed6, 0x4420, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/0/10 */
    { 0x0035, 0x5ed6, 0x4420, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/0/12 */
    { 0x003d, 0x5ed6, 0x4420, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/0/14 */
    { 0x0405, 0x5ed6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/1/0 */
    { 0x040d, 0x5ed6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/1/2 */
    { 0x0415, 0x5ed6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/1/4 */
    { 0x041d, 0x5ed6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/1/6 */
    { 0x0425, 0x5ed6, 0x4420, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/1/8 */
    { 0x042d, 0x5ed6, 0x4420, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/1/10 */
    { 0x0435, 0x5ed6, 0x4420, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/1/12 */
    { 0x043d, 0x5ed6, 0x4420, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/1/14 */
    { 0x0805, 0x5ed6, 0xc6a0, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(1) }, /* #47/2/0 */
    { 0x080d, 0x5ed6, 0xc6a0, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(1) }, /* #47/2/2 */
    { 0x0815, 0x5ed6, 0xc6a0, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(1) }, /* #47/2/4 */
    { 0x081d, 0x5ed6, 0xc6a0, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(1) }, /* #47/2/6 */
    { 0x0825, 0x5ed6, 0x4620, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(1) }, /* #47/2/8 */
    { 0x082d, 0x5ed6, 0x4620, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(1) }, /* #47/2/10 */
    { 0x0835, 0x5ed6, 0x4620, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(1) }, /* #47/2/12 */
    { 0x083d, 0x5ed6, 0x4620, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(1) }, /* #47/2/14 */
    { 0x0c05, 0x5ed6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/3/0 */
    { 0x0c0d, 0x5ed6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/3/2 */
    { 0x0c15, 0x5ed6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/3/4 */
    { 0x0c1d, 0x5ed6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/3/6 */
    { 0x0c25, 0x5ed6, 0x4420, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/3/8 */
    { 0x0c2d, 0x5ed6, 0x4420, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/3/10 */
    { 0x0c35, 0x5ed6, 0x4420, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/3/12 */
    { 0x0c3d, 0x5ed6, 0x4420, RTFLOAT80U_INIT_C(0,0x80000000035d620e,0), INT64_C(0) }, /* #47/3/14 */
    { 0x0105, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/0/0 */
    { 0x010d, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/0/2 */
    { 0x0115, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/0/4 */
    { 0x011d, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/0/6 */
    { 0x0125, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/0/8 */
    { 0x012d, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/0/10 */
    { 0x0135, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/0/12 */
    { 0x013d, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/0/14 */
    { 0x0505, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/1/0 */
    { 0x050d, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/1/2 */
    { 0x0515, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/1/4 */
    { 0x051d, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/1/6 */
    { 0x0525, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/1/8 */
    { 0x052d, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/1/10 */
    { 0x0535, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/1/12 */
    { 0x053d, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/1/14 */
    { 0x0905, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/2/0 */
    { 0x090d, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/2/2 */
    { 0x0915, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/2/4 */
    { 0x091d, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/2/6 */
    { 0x0925, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/2/8 */
    { 0x092d, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/2/10 */
    { 0x0935, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/2/12 */
    { 0x093d, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/2/14 */
    { 0x0d05, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/3/0 */
    { 0x0d0d, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/3/2 */
    { 0x0d15, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/3/4 */
    { 0x0d1d, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/3/6 */
    { 0x0d25, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/3/8 */
    { 0x0d2d, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/3/10 */
    { 0x0d35, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/3/12 */
    { 0x0d3d, 0x596b, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #48/3/14 */
    { 0x0003, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/0/0 */
    { 0x000b, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/0/2 */
    { 0x0013, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/0/4 */
    { 0x001b, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/0/6 */
    { 0x0023, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/0/8 */
    { 0x002b, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/0/10 */
    { 0x0033, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/0/12 */
    { 0x003b, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/0/14 */
    { 0x0403, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/1/0 */
    { 0x040b, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/1/2 */
    { 0x0413, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/1/4 */
    { 0x041b, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/1/6 */
    { 0x0423, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/1/8 */
    { 0x042b, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/1/10 */
    { 0x0433, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/1/12 */
    { 0x043b, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/1/14 */
    { 0x0803, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/2/0 */
    { 0x080b, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/2/2 */
    { 0x0813, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/2/4 */
    { 0x081b, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/2/6 */
    { 0x0823, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/2/8 */
    { 0x082b, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/2/10 */
    { 0x0833, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/2/12 */
    { 0x083b, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/2/14 */
    { 0x0c03, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/3/0 */
    { 0x0c0b, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/3/2 */
    { 0x0c13, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/3/4 */
    { 0x0c1b, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/3/6 */
    { 0x0c23, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/3/8 */
    { 0x0c2b, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/3/10 */
    { 0x0c33, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/3/12 */
    { 0x0c3b, 0xb231, 0x0000, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #49/3/14 */
    { 0x0041, 0xb9a8, 0x81a0, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/0/0 */
    { 0x0049, 0xb9a8, 0x81a0, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/0/2 */
    { 0x0051, 0xb9a8, 0x81a0, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/0/4 */
    { 0x0059, 0xb9a8, 0x81a0, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/0/6 */
    { 0x0061, 0xb9a8, 0x0120, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/0/8 */
    { 0x0069, 0xb9a8, 0x0120, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/0/10 */
    { 0x0071, 0xb9a8, 0x0120, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/0/12 */
    { 0x0079, 0xb9a8, 0x0120, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/0/14 */
    { 0x0441, 0xb9a8, 0x81a0, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/1/0 */
    { 0x0449, 0xb9a8, 0x81a0, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/1/2 */
    { 0x0451, 0xb9a8, 0x81a0, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/1/4 */
    { 0x0459, 0xb9a8, 0x81a0, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/1/6 */
    { 0x0461, 0xb9a8, 0x0120, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/1/8 */
    { 0x0469, 0xb9a8, 0x0120, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/1/10 */
    { 0x0471, 0xb9a8, 0x0120, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/1/12 */
    { 0x0479, 0xb9a8, 0x0120, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/1/14 */
    { 0x0841, 0xb9a8, 0x83a0, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(2) }, /* #50/2/0 */
    { 0x0849, 0xb9a8, 0x83a0, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(2) }, /* #50/2/2 */
    { 0x0851, 0xb9a8, 0x83a0, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(2) }, /* #50/2/4 */
    { 0x0859, 0xb9a8, 0x83a0, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(2) }, /* #50/2/6 */
    { 0x0861, 0xb9a8, 0x0320, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(2) }, /* #50/2/8 */
    { 0x0869, 0xb9a8, 0x0320, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(2) }, /* #50/2/10 */
    { 0x0871, 0xb9a8, 0x0320, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(2) }, /* #50/2/12 */
    { 0x0879, 0xb9a8, 0x0320, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(2) }, /* #50/2/14 */
    { 0x0c41, 0xb9a8, 0x81a0, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/3/0 */
    { 0x0c49, 0xb9a8, 0x81a0, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/3/2 */
    { 0x0c51, 0xb9a8, 0x81a0, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/3/4 */
    { 0x0c59, 0xb9a8, 0x81a0, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/3/6 */
    { 0x0c61, 0xb9a8, 0x0120, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/3/8 */
    { 0x0c69, 0xb9a8, 0x0120, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/3/10 */
    { 0x0c71, 0xb9a8, 0x0120, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/3/12 */
    { 0x0c79, 0xb9a8, 0x0120, RTFLOAT80U_INIT_C(0,0x9da81216131660ef,16383), INT64_C(1) }, /* #50/3/14 */
    { 0x0045, 0xe82e, 0xc2a0, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-2) }, /* #51/0/0 */
    { 0x004d, 0xe82e, 0xc2a0, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-2) }, /* #51/0/2 */
    { 0x0055, 0xe82e, 0xc2a0, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-2) }, /* #51/0/4 */
    { 0x005d, 0xe82e, 0xc2a0, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-2) }, /* #51/0/6 */
    { 0x0065, 0xe82e, 0x4220, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-2) }, /* #51/0/8 */
    { 0x006d, 0xe82e, 0x4220, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-2) }, /* #51/0/10 */
    { 0x0075, 0xe82e, 0x4220, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-2) }, /* #51/0/12 */
    { 0x007d, 0xe82e, 0x4220, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-2) }, /* #51/0/14 */
    { 0x0445, 0xe82e, 0xc2a0, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-2) }, /* #51/1/0 */
    { 0x044d, 0xe82e, 0xc2a0, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-2) }, /* #51/1/2 */
    { 0x0455, 0xe82e, 0xc2a0, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-2) }, /* #51/1/4 */
    { 0x045d, 0xe82e, 0xc2a0, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-2) }, /* #51/1/6 */
    { 0x0465, 0xe82e, 0x4220, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-2) }, /* #51/1/8 */
    { 0x046d, 0xe82e, 0x4220, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-2) }, /* #51/1/10 */
    { 0x0475, 0xe82e, 0x4220, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-2) }, /* #51/1/12 */
    { 0x047d, 0xe82e, 0x4220, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-2) }, /* #51/1/14 */
    { 0x0845, 0xe82e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-1) }, /* #51/2/0 */
    { 0x084d, 0xe82e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-1) }, /* #51/2/2 */
    { 0x0855, 0xe82e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-1) }, /* #51/2/4 */
    { 0x085d, 0xe82e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-1) }, /* #51/2/6 */
    { 0x0865, 0xe82e, 0x4020, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-1) }, /* #51/2/8 */
    { 0x086d, 0xe82e, 0x4020, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-1) }, /* #51/2/10 */
    { 0x0875, 0xe82e, 0x4020, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-1) }, /* #51/2/12 */
    { 0x087d, 0xe82e, 0x4020, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-1) }, /* #51/2/14 */
    { 0x0c45, 0xe82e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-1) }, /* #51/3/0 */
    { 0x0c4d, 0xe82e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-1) }, /* #51/3/2 */
    { 0x0c55, 0xe82e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-1) }, /* #51/3/4 */
    { 0x0c5d, 0xe82e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-1) }, /* #51/3/6 */
    { 0x0c65, 0xe82e, 0x4020, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-1) }, /* #51/3/8 */
    { 0x0c6d, 0xe82e, 0x4020, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-1) }, /* #51/3/10 */
    { 0x0c75, 0xe82e, 0x4020, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-1) }, /* #51/3/12 */
    { 0x0c7d, 0xe82e, 0x4020, RTFLOAT80U_INIT_C(1,0xf9ec688226613db8,16383), INT64_C(-1) }, /* #51/3/14 */
    { 0x0042, 0xc6e2, 0xc4a0, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/0/0 */
    { 0x004a, 0xc6e2, 0xc4a0, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/0/2 */
    { 0x0052, 0xc6e2, 0xc4a0, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/0/4 */
    { 0x005a, 0xc6e2, 0xc4a0, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/0/6 */
    { 0x0062, 0xc6e2, 0x4420, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/0/8 */
    { 0x006a, 0xc6e2, 0x4420, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/0/10 */
    { 0x0072, 0xc6e2, 0x4420, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/0/12 */
    { 0x007a, 0xc6e2, 0x4420, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/0/14 */
    { 0x0442, 0xc6e2, 0xc4a0, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/1/0 */
    { 0x044a, 0xc6e2, 0xc4a0, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/1/2 */
    { 0x0452, 0xc6e2, 0xc4a0, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/1/4 */
    { 0x045a, 0xc6e2, 0xc4a0, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/1/6 */
    { 0x0462, 0xc6e2, 0x4420, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/1/8 */
    { 0x046a, 0xc6e2, 0x4420, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/1/10 */
    { 0x0472, 0xc6e2, 0x4420, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/1/12 */
    { 0x047a, 0xc6e2, 0x4420, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/1/14 */
    { 0x0842, 0xc6e2, 0xc6a0, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(1) }, /* #52/2/0 */
    { 0x084a, 0xc6e2, 0xc6a0, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(1) }, /* #52/2/2 */
    { 0x0852, 0xc6e2, 0xc6a0, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(1) }, /* #52/2/4 */
    { 0x085a, 0xc6e2, 0xc6a0, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(1) }, /* #52/2/6 */
    { 0x0862, 0xc6e2, 0x4620, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(1) }, /* #52/2/8 */
    { 0x086a, 0xc6e2, 0x4620, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(1) }, /* #52/2/10 */
    { 0x0872, 0xc6e2, 0x4620, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(1) }, /* #52/2/12 */
    { 0x087a, 0xc6e2, 0x4620, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(1) }, /* #52/2/14 */
    { 0x0c42, 0xc6e2, 0xc4a0, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/3/0 */
    { 0x0c4a, 0xc6e2, 0xc4a0, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/3/2 */
    { 0x0c52, 0xc6e2, 0xc4a0, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/3/4 */
    { 0x0c5a, 0xc6e2, 0xc4a0, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/3/6 */
    { 0x0c62, 0xc6e2, 0x4420, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/3/8 */
    { 0x0c6a, 0xc6e2, 0x4420, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/3/10 */
    { 0x0c72, 0xc6e2, 0x4420, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/3/12 */
    { 0x0c7a, 0xc6e2, 0x4420, RTFLOAT80U_INIT_C(0,0xef11b273d8a6a933,0), INT64_C(0) }, /* #52/3/14 */
    { 0x0002, 0x1c57, 0x84a0, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/0/0 */
    { 0x000a, 0x1c57, 0x84a0, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/0/2 */
    { 0x0012, 0x1c57, 0x84a0, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/0/4 */
    { 0x001a, 0x1c57, 0x84a0, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/0/6 */
    { 0x0022, 0x1c57, 0x0420, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/0/8 */
    { 0x002a, 0x1c57, 0x0420, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/0/10 */
    { 0x0032, 0x1c57, 0x0420, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/0/12 */
    { 0x003a, 0x1c57, 0x0420, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/0/14 */
    { 0x0402, 0x1c57, 0x84a0, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/1/0 */
    { 0x040a, 0x1c57, 0x84a0, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/1/2 */
    { 0x0412, 0x1c57, 0x84a0, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/1/4 */
    { 0x041a, 0x1c57, 0x84a0, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/1/6 */
    { 0x0422, 0x1c57, 0x0420, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/1/8 */
    { 0x042a, 0x1c57, 0x0420, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/1/10 */
    { 0x0432, 0x1c57, 0x0420, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/1/12 */
    { 0x043a, 0x1c57, 0x0420, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/1/14 */
    { 0x0802, 0x1c57, 0x86a0, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(1) }, /* #53/2/0 */
    { 0x080a, 0x1c57, 0x86a0, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(1) }, /* #53/2/2 */
    { 0x0812, 0x1c57, 0x86a0, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(1) }, /* #53/2/4 */
    { 0x081a, 0x1c57, 0x86a0, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(1) }, /* #53/2/6 */
    { 0x0822, 0x1c57, 0x0620, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(1) }, /* #53/2/8 */
    { 0x082a, 0x1c57, 0x0620, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(1) }, /* #53/2/10 */
    { 0x0832, 0x1c57, 0x0620, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(1) }, /* #53/2/12 */
    { 0x083a, 0x1c57, 0x0620, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(1) }, /* #53/2/14 */
    { 0x0c02, 0x1c57, 0x84a0, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/3/0 */
    { 0x0c0a, 0x1c57, 0x84a0, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/3/2 */
    { 0x0c12, 0x1c57, 0x84a0, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/3/4 */
    { 0x0c1a, 0x1c57, 0x84a0, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/3/6 */
    { 0x0c22, 0x1c57, 0x0420, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/3/8 */
    { 0x0c2a, 0x1c57, 0x0420, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/3/10 */
    { 0x0c32, 0x1c57, 0x0420, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/3/12 */
    { 0x0c3a, 0x1c57, 0x0420, RTFLOAT80U_INIT_C(0,0x16a55699b,0), INT64_C(0) }, /* #53/3/14 */
    { 0x0302, 0x65ae, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/0/0 */
    { 0x030a, 0x65ae, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/0/2 */
    { 0x0312, 0x65ae, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/0/4 */
    { 0x031a, 0x65ae, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/0/6 */
    { 0x0322, 0x65ae, 0x4520, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/0/8 */
    { 0x032a, 0x65ae, 0x4520, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/0/10 */
    { 0x0332, 0x65ae, 0x4520, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/0/12 */
    { 0x033a, 0x65ae, 0x4520, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/0/14 */
    { 0x0702, 0x65ae, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/1/0 */
    { 0x070a, 0x65ae, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/1/2 */
    { 0x0712, 0x65ae, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/1/4 */
    { 0x071a, 0x65ae, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/1/6 */
    { 0x0722, 0x65ae, 0x4520, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/1/8 */
    { 0x072a, 0x65ae, 0x4520, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/1/10 */
    { 0x0732, 0x65ae, 0x4520, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/1/12 */
    { 0x073a, 0x65ae, 0x4520, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/1/14 */
    { 0x0b02, 0x65ae, 0xc7a0, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(1) }, /* #54/2/0 */
    { 0x0b0a, 0x65ae, 0xc7a0, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(1) }, /* #54/2/2 */
    { 0x0b12, 0x65ae, 0xc7a0, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(1) }, /* #54/2/4 */
    { 0x0b1a, 0x65ae, 0xc7a0, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(1) }, /* #54/2/6 */
    { 0x0b22, 0x65ae, 0x4720, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(1) }, /* #54/2/8 */
    { 0x0b2a, 0x65ae, 0x4720, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(1) }, /* #54/2/10 */
    { 0x0b32, 0x65ae, 0x4720, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(1) }, /* #54/2/12 */
    { 0x0b3a, 0x65ae, 0x4720, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(1) }, /* #54/2/14 */
    { 0x0f02, 0x65ae, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/3/0 */
    { 0x0f0a, 0x65ae, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/3/2 */
    { 0x0f12, 0x65ae, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/3/4 */
    { 0x0f1a, 0x65ae, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/3/6 */
    { 0x0f22, 0x65ae, 0x4520, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/3/8 */
    { 0x0f2a, 0x65ae, 0x4520, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/3/10 */
    { 0x0f32, 0x65ae, 0x4520, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/3/12 */
    { 0x0f3a, 0x65ae, 0x4520, RTFLOAT80U_INIT_C(0,0xf03f48a5c856990a,6104), INT64_C(0) }, /* #54/3/14 */
    { 0x0004, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/0/0 */
    { 0x000c, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/0/2 */
    { 0x0014, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/0/4 */
    { 0x001c, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/0/6 */
    { 0x0024, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/0/8 */
    { 0x002c, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/0/10 */
    { 0x0034, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/0/12 */
    { 0x003c, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/0/14 */
    { 0x0404, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/1/0 */
    { 0x040c, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/1/2 */
    { 0x0414, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/1/4 */
    { 0x041c, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/1/6 */
    { 0x0424, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/1/8 */
    { 0x042c, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/1/10 */
    { 0x0434, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/1/12 */
    { 0x043c, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/1/14 */
    { 0x0804, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/2/0 */
    { 0x080c, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/2/2 */
    { 0x0814, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/2/4 */
    { 0x081c, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/2/6 */
    { 0x0824, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/2/8 */
    { 0x082c, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/2/10 */
    { 0x0834, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/2/12 */
    { 0x083c, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/2/14 */
    { 0x0c04, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/3/0 */
    { 0x0c0c, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/3/2 */
    { 0x0c14, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/3/4 */
    { 0x0c1c, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/3/6 */
    { 0x0c24, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/3/8 */
    { 0x0c2c, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/3/10 */
    { 0x0c34, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/3/12 */
    { 0x0c3c, 0xa46c, 0x0400, RTFLOAT80U_INIT_C(0,0xd2fc26a078db15a6,16445), INT64_C(7601534456380099283) }, /* #55/3/14 */
    { 0x0006, 0xaf3f, 0x85a0, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/0/0 */
    { 0x000e, 0xaf3f, 0x85a0, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/0/2 */
    { 0x0016, 0xaf3f, 0x85a0, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/0/4 */
    { 0x001e, 0xaf3f, 0x85a0, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/0/6 */
    { 0x0026, 0xaf3f, 0x0520, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/0/8 */
    { 0x002e, 0xaf3f, 0x0520, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/0/10 */
    { 0x0036, 0xaf3f, 0x0520, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/0/12 */
    { 0x003e, 0xaf3f, 0x0520, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/0/14 */
    { 0x0406, 0xaf3f, 0x87a0, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-2) }, /* #56/1/0 */
    { 0x040e, 0xaf3f, 0x87a0, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-2) }, /* #56/1/2 */
    { 0x0416, 0xaf3f, 0x87a0, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-2) }, /* #56/1/4 */
    { 0x041e, 0xaf3f, 0x87a0, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-2) }, /* #56/1/6 */
    { 0x0426, 0xaf3f, 0x0720, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-2) }, /* #56/1/8 */
    { 0x042e, 0xaf3f, 0x0720, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-2) }, /* #56/1/10 */
    { 0x0436, 0xaf3f, 0x0720, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-2) }, /* #56/1/12 */
    { 0x043e, 0xaf3f, 0x0720, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-2) }, /* #56/1/14 */
    { 0x0806, 0xaf3f, 0x85a0, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/2/0 */
    { 0x080e, 0xaf3f, 0x85a0, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/2/2 */
    { 0x0816, 0xaf3f, 0x85a0, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/2/4 */
    { 0x081e, 0xaf3f, 0x85a0, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/2/6 */
    { 0x0826, 0xaf3f, 0x0520, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/2/8 */
    { 0x082e, 0xaf3f, 0x0520, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/2/10 */
    { 0x0836, 0xaf3f, 0x0520, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/2/12 */
    { 0x083e, 0xaf3f, 0x0520, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/2/14 */
    { 0x0c06, 0xaf3f, 0x85a0, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/3/0 */
    { 0x0c0e, 0xaf3f, 0x85a0, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/3/2 */
    { 0x0c16, 0xaf3f, 0x85a0, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/3/4 */
    { 0x0c1e, 0xaf3f, 0x85a0, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/3/6 */
    { 0x0c26, 0xaf3f, 0x0520, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/3/8 */
    { 0x0c2e, 0xaf3f, 0x0520, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/3/10 */
    { 0x0c36, 0xaf3f, 0x0520, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/3/12 */
    { 0x0c3e, 0xaf3f, 0x0520, RTFLOAT80U_INIT_C(1,0x814464a217f45fd1,16383), INT64_C(-1) }, /* #56/3/14 */
    { 0x0242, 0xd4a4, 0xc4a0, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/0/0 */
    { 0x024a, 0xd4a4, 0xc4a0, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/0/2 */
    { 0x0252, 0xd4a4, 0xc4a0, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/0/4 */
    { 0x025a, 0xd4a4, 0xc4a0, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/0/6 */
    { 0x0262, 0xd4a4, 0x4420, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/0/8 */
    { 0x026a, 0xd4a4, 0x4420, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/0/10 */
    { 0x0272, 0xd4a4, 0x4420, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/0/12 */
    { 0x027a, 0xd4a4, 0x4420, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/0/14 */
    { 0x0642, 0xd4a4, 0xc6a0, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-2) }, /* #57/1/0 */
    { 0x064a, 0xd4a4, 0xc6a0, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-2) }, /* #57/1/2 */
    { 0x0652, 0xd4a4, 0xc6a0, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-2) }, /* #57/1/4 */
    { 0x065a, 0xd4a4, 0xc6a0, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-2) }, /* #57/1/6 */
    { 0x0662, 0xd4a4, 0x4620, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-2) }, /* #57/1/8 */
    { 0x066a, 0xd4a4, 0x4620, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-2) }, /* #57/1/10 */
    { 0x0672, 0xd4a4, 0x4620, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-2) }, /* #57/1/12 */
    { 0x067a, 0xd4a4, 0x4620, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-2) }, /* #57/1/14 */
    { 0x0a42, 0xd4a4, 0xc4a0, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/2/0 */
    { 0x0a4a, 0xd4a4, 0xc4a0, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/2/2 */
    { 0x0a52, 0xd4a4, 0xc4a0, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/2/4 */
    { 0x0a5a, 0xd4a4, 0xc4a0, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/2/6 */
    { 0x0a62, 0xd4a4, 0x4420, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/2/8 */
    { 0x0a6a, 0xd4a4, 0x4420, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/2/10 */
    { 0x0a72, 0xd4a4, 0x4420, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/2/12 */
    { 0x0a7a, 0xd4a4, 0x4420, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/2/14 */
    { 0x0e42, 0xd4a4, 0xc4a0, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/3/0 */
    { 0x0e4a, 0xd4a4, 0xc4a0, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/3/2 */
    { 0x0e52, 0xd4a4, 0xc4a0, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/3/4 */
    { 0x0e5a, 0xd4a4, 0xc4a0, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/3/6 */
    { 0x0e62, 0xd4a4, 0x4420, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/3/8 */
    { 0x0e6a, 0xd4a4, 0x4420, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/3/10 */
    { 0x0e72, 0xd4a4, 0x4420, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/3/12 */
    { 0x0e7a, 0xd4a4, 0x4420, RTFLOAT80U_INIT_C(1,0x82fe4d346c056c4c,16383), INT64_C(-1) }, /* #57/3/14 */
    { 0x0144, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/0/0 */
    { 0x014c, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/0/2 */
    { 0x0154, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/0/4 */
    { 0x015c, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/0/6 */
    { 0x0164, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/0/8 */
    { 0x016c, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/0/10 */
    { 0x0174, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/0/12 */
    { 0x017c, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/0/14 */
    { 0x0544, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/1/0 */
    { 0x054c, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/1/2 */
    { 0x0554, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/1/4 */
    { 0x055c, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/1/6 */
    { 0x0564, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/1/8 */
    { 0x056c, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/1/10 */
    { 0x0574, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/1/12 */
    { 0x057c, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/1/14 */
    { 0x0944, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/2/0 */
    { 0x094c, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/2/2 */
    { 0x0954, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/2/4 */
    { 0x095c, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/2/6 */
    { 0x0964, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/2/8 */
    { 0x096c, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/2/10 */
    { 0x0974, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/2/12 */
    { 0x097c, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/2/14 */
    { 0x0d44, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/3/0 */
    { 0x0d4c, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/3/2 */
    { 0x0d54, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/3/4 */
    { 0x0d5c, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/3/6 */
    { 0x0d64, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/3/8 */
    { 0x0d6c, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/3/10 */
    { 0x0d74, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/3/12 */
    { 0x0d7c, 0xbbf5, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #58/3/14 */
    { 0x0146, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/0/0 */
    { 0x014e, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/0/2 */
    { 0x0156, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/0/4 */
    { 0x015e, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/0/6 */
    { 0x0166, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/0/8 */
    { 0x016e, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/0/10 */
    { 0x0176, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/0/12 */
    { 0x017e, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/0/14 */
    { 0x0546, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/1/0 */
    { 0x054e, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/1/2 */
    { 0x0556, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/1/4 */
    { 0x055e, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/1/6 */
    { 0x0566, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/1/8 */
    { 0x056e, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/1/10 */
    { 0x0576, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/1/12 */
    { 0x057e, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/1/14 */
    { 0x0946, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/2/0 */
    { 0x094e, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/2/2 */
    { 0x0956, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/2/4 */
    { 0x095e, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/2/6 */
    { 0x0966, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/2/8 */
    { 0x096e, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/2/10 */
    { 0x0976, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/2/12 */
    { 0x097e, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/2/14 */
    { 0x0d46, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/3/0 */
    { 0x0d4e, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/3/2 */
    { 0x0d56, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/3/4 */
    { 0x0d5e, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/3/6 */
    { 0x0d66, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/3/8 */
    { 0x0d6e, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/3/10 */
    { 0x0d76, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/3/12 */
    { 0x0d7e, 0xc535, 0xfd81, RTFLOAT80U_INIT_C(0,0x6c6ef5be48f09693,27800), INT64_C(-3) }, /* #59/3/14 */
    { 0x0307, 0x1247, 0x80a0, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/0/0 */
    { 0x030f, 0x1247, 0x80a0, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/0/2 */
    { 0x0317, 0x1247, 0x80a0, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/0/4 */
    { 0x031f, 0x1247, 0x80a0, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/0/6 */
    { 0x0327, 0x1247, 0x0020, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/0/8 */
    { 0x032f, 0x1247, 0x0020, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/0/10 */
    { 0x0337, 0x1247, 0x0020, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/0/12 */
    { 0x033f, 0x1247, 0x0020, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/0/14 */
    { 0x0707, 0x1247, 0x82a0, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(-1) }, /* #60/1/0 */
    { 0x070f, 0x1247, 0x82a0, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(-1) }, /* #60/1/2 */
    { 0x0717, 0x1247, 0x82a0, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(-1) }, /* #60/1/4 */
    { 0x071f, 0x1247, 0x82a0, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(-1) }, /* #60/1/6 */
    { 0x0727, 0x1247, 0x0220, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(-1) }, /* #60/1/8 */
    { 0x072f, 0x1247, 0x0220, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(-1) }, /* #60/1/10 */
    { 0x0737, 0x1247, 0x0220, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(-1) }, /* #60/1/12 */
    { 0x073f, 0x1247, 0x0220, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(-1) }, /* #60/1/14 */
    { 0x0b07, 0x1247, 0x80a0, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/2/0 */
    { 0x0b0f, 0x1247, 0x80a0, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/2/2 */
    { 0x0b17, 0x1247, 0x80a0, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/2/4 */
    { 0x0b1f, 0x1247, 0x80a0, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/2/6 */
    { 0x0b27, 0x1247, 0x0020, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/2/8 */
    { 0x0b2f, 0x1247, 0x0020, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/2/10 */
    { 0x0b37, 0x1247, 0x0020, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/2/12 */
    { 0x0b3f, 0x1247, 0x0020, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/2/14 */
    { 0x0f07, 0x1247, 0x80a0, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/3/0 */
    { 0x0f0f, 0x1247, 0x80a0, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/3/2 */
    { 0x0f17, 0x1247, 0x80a0, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/3/4 */
    { 0x0f1f, 0x1247, 0x80a0, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/3/6 */
    { 0x0f27, 0x1247, 0x0020, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/3/8 */
    { 0x0f2f, 0x1247, 0x0020, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/3/10 */
    { 0x0f37, 0x1247, 0x0020, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/3/12 */
    { 0x0f3f, 0x1247, 0x0020, RTFLOAT80U_INIT_C(1,0x8000001802ef3a43,0), INT64_C(0) }, /* #60/3/14 */
    { 0x0142, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/0/0 */
    { 0x014a, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/0/2 */
    { 0x0152, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/0/4 */
    { 0x015a, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/0/6 */
    { 0x0162, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/0/8 */
    { 0x016a, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/0/10 */
    { 0x0172, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/0/12 */
    { 0x017a, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/0/14 */
    { 0x0542, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/1/0 */
    { 0x054a, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/1/2 */
    { 0x0552, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/1/4 */
    { 0x055a, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/1/6 */
    { 0x0562, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/1/8 */
    { 0x056a, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/1/10 */
    { 0x0572, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/1/12 */
    { 0x057a, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/1/14 */
    { 0x0942, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/2/0 */
    { 0x094a, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/2/2 */
    { 0x0952, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/2/4 */
    { 0x095a, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/2/6 */
    { 0x0962, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/2/8 */
    { 0x096a, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/2/10 */
    { 0x0972, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/2/12 */
    { 0x097a, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/2/14 */
    { 0x0d42, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/3/0 */
    { 0x0d4a, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/3/2 */
    { 0x0d52, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/3/4 */
    { 0x0d5a, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/3/6 */
    { 0x0d62, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/3/8 */
    { 0x0d6a, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/3/10 */
    { 0x0d72, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/3/12 */
    { 0x0d7a, 0xe6df, 0xfc81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #61/3/14 */
    { 0x0102, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/0/0 */
    { 0x010a, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/0/2 */
    { 0x0112, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/0/4 */
    { 0x011a, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/0/6 */
    { 0x0122, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/0/8 */
    { 0x012a, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/0/10 */
    { 0x0132, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/0/12 */
    { 0x013a, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/0/14 */
    { 0x0502, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/1/0 */
    { 0x050a, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/1/2 */
    { 0x0512, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/1/4 */
    { 0x051a, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/1/6 */
    { 0x0522, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/1/8 */
    { 0x052a, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/1/10 */
    { 0x0532, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/1/12 */
    { 0x053a, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/1/14 */
    { 0x0902, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/2/0 */
    { 0x090a, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/2/2 */
    { 0x0912, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/2/4 */
    { 0x091a, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/2/6 */
    { 0x0922, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/2/8 */
    { 0x092a, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/2/10 */
    { 0x0932, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/2/12 */
    { 0x093a, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/2/14 */
    { 0x0d02, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/3/0 */
    { 0x0d0a, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/3/2 */
    { 0x0d12, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/3/4 */
    { 0x0d1a, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/3/6 */
    { 0x0d22, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/3/8 */
    { 0x0d2a, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/3/10 */
    { 0x0d32, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/3/12 */
    { 0x0d3a, 0xb5cf, 0xbd81, RTFLOAT80U_INIT_C(1,0xe97a191b7035babd,32767), INT64_C(-3) }, /* #62/3/14 */
    { 0x0104, 0x9ccc, 0x84a0, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/0/0 */
    { 0x010c, 0x9ccc, 0x84a0, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/0/2 */
    { 0x0114, 0x9ccc, 0x84a0, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/0/4 */
    { 0x011c, 0x9ccc, 0x84a0, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/0/6 */
    { 0x0124, 0x9ccc, 0x0420, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/0/8 */
    { 0x012c, 0x9ccc, 0x0420, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/0/10 */
    { 0x0134, 0x9ccc, 0x0420, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/0/12 */
    { 0x013c, 0x9ccc, 0x0420, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/0/14 */
    { 0x0504, 0x9ccc, 0x84a0, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/1/0 */
    { 0x050c, 0x9ccc, 0x84a0, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/1/2 */
    { 0x0514, 0x9ccc, 0x84a0, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/1/4 */
    { 0x051c, 0x9ccc, 0x84a0, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/1/6 */
    { 0x0524, 0x9ccc, 0x0420, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/1/8 */
    { 0x052c, 0x9ccc, 0x0420, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/1/10 */
    { 0x0534, 0x9ccc, 0x0420, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/1/12 */
    { 0x053c, 0x9ccc, 0x0420, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/1/14 */
    { 0x0904, 0x9ccc, 0x86a0, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(1) }, /* #63/2/0 */
    { 0x090c, 0x9ccc, 0x86a0, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(1) }, /* #63/2/2 */
    { 0x0914, 0x9ccc, 0x86a0, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(1) }, /* #63/2/4 */
    { 0x091c, 0x9ccc, 0x86a0, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(1) }, /* #63/2/6 */
    { 0x0924, 0x9ccc, 0x0620, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(1) }, /* #63/2/8 */
    { 0x092c, 0x9ccc, 0x0620, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(1) }, /* #63/2/10 */
    { 0x0934, 0x9ccc, 0x0620, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(1) }, /* #63/2/12 */
    { 0x093c, 0x9ccc, 0x0620, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(1) }, /* #63/2/14 */
    { 0x0d04, 0x9ccc, 0x84a0, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/3/0 */
    { 0x0d0c, 0x9ccc, 0x84a0, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/3/2 */
    { 0x0d14, 0x9ccc, 0x84a0, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/3/4 */
    { 0x0d1c, 0x9ccc, 0x84a0, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/3/6 */
    { 0x0d24, 0x9ccc, 0x0420, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/3/8 */
    { 0x0d2c, 0x9ccc, 0x0420, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/3/10 */
    { 0x0d34, 0x9ccc, 0x0420, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/3/12 */
    { 0x0d3c, 0x9ccc, 0x0420, RTFLOAT80U_INIT_C(0,0xfe5d670424c64106,0), INT64_C(0) }, /* #63/3/14 */
    { 0x0207, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/0/0 */
    { 0x020f, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/0/2 */
    { 0x0217, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/0/4 */
    { 0x021f, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/0/6 */
    { 0x0227, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/0/8 */
    { 0x022f, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/0/10 */
    { 0x0237, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/0/12 */
    { 0x023f, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/0/14 */
    { 0x0607, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/1/0 */
    { 0x060f, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/1/2 */
    { 0x0617, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/1/4 */
    { 0x061f, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/1/6 */
    { 0x0627, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/1/8 */
    { 0x062f, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/1/10 */
    { 0x0637, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/1/12 */
    { 0x063f, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/1/14 */
    { 0x0a07, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/2/0 */
    { 0x0a0f, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/2/2 */
    { 0x0a17, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/2/4 */
    { 0x0a1f, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/2/6 */
    { 0x0a27, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/2/8 */
    { 0x0a2f, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/2/10 */
    { 0x0a37, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/2/12 */
    { 0x0a3f, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/2/14 */
    { 0x0e07, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/3/0 */
    { 0x0e0f, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/3/2 */
    { 0x0e17, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/3/4 */
    { 0x0e1f, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/3/6 */
    { 0x0e27, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/3/8 */
    { 0x0e2f, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/3/10 */
    { 0x0e37, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/3/12 */
    { 0x0e3f, 0xc7a2, 0x4501, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_MIN }, /* #64/3/14 */
    { 0x0104, 0xa8cf, 0x80a0, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/0/0 */
    { 0x010c, 0xa8cf, 0x80a0, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/0/2 */
    { 0x0114, 0xa8cf, 0x80a0, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/0/4 */
    { 0x011c, 0xa8cf, 0x80a0, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/0/6 */
    { 0x0124, 0xa8cf, 0x0020, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/0/8 */
    { 0x012c, 0xa8cf, 0x0020, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/0/10 */
    { 0x0134, 0xa8cf, 0x0020, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/0/12 */
    { 0x013c, 0xa8cf, 0x0020, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/0/14 */
    { 0x0504, 0xa8cf, 0x82a0, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(-1) }, /* #65/1/0 */
    { 0x050c, 0xa8cf, 0x82a0, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(-1) }, /* #65/1/2 */
    { 0x0514, 0xa8cf, 0x82a0, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(-1) }, /* #65/1/4 */
    { 0x051c, 0xa8cf, 0x82a0, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(-1) }, /* #65/1/6 */
    { 0x0524, 0xa8cf, 0x0220, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(-1) }, /* #65/1/8 */
    { 0x052c, 0xa8cf, 0x0220, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(-1) }, /* #65/1/10 */
    { 0x0534, 0xa8cf, 0x0220, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(-1) }, /* #65/1/12 */
    { 0x053c, 0xa8cf, 0x0220, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(-1) }, /* #65/1/14 */
    { 0x0904, 0xa8cf, 0x80a0, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/2/0 */
    { 0x090c, 0xa8cf, 0x80a0, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/2/2 */
    { 0x0914, 0xa8cf, 0x80a0, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/2/4 */
    { 0x091c, 0xa8cf, 0x80a0, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/2/6 */
    { 0x0924, 0xa8cf, 0x0020, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/2/8 */
    { 0x092c, 0xa8cf, 0x0020, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/2/10 */
    { 0x0934, 0xa8cf, 0x0020, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/2/12 */
    { 0x093c, 0xa8cf, 0x0020, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/2/14 */
    { 0x0d04, 0xa8cf, 0x80a0, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/3/0 */
    { 0x0d0c, 0xa8cf, 0x80a0, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/3/2 */
    { 0x0d14, 0xa8cf, 0x80a0, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/3/4 */
    { 0x0d1c, 0xa8cf, 0x80a0, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/3/6 */
    { 0x0d24, 0xa8cf, 0x0020, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/3/8 */
    { 0x0d2c, 0xa8cf, 0x0020, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/3/10 */
    { 0x0d34, 0xa8cf, 0x0020, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/3/12 */
    { 0x0d3c, 0xa8cf, 0x0020, RTFLOAT80U_INIT_C(1,0xe490732c27,0), INT64_C(0) }, /* #65/3/14 */
    { 0x0100, 0x6910, 0xc1a0, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/0/0 */
    { 0x0108, 0x6910, 0xc1a0, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/0/2 */
    { 0x0110, 0x6910, 0xc1a0, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/0/4 */
    { 0x0118, 0x6910, 0xc1a0, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/0/6 */
    { 0x0120, 0x6910, 0x4120, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/0/8 */
    { 0x0128, 0x6910, 0x4120, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/0/10 */
    { 0x0130, 0x6910, 0x4120, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/0/12 */
    { 0x0138, 0x6910, 0x4120, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/0/14 */
    { 0x0500, 0x6910, 0xc3a0, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(-1) }, /* #66/1/0 */
    { 0x0508, 0x6910, 0xc3a0, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(-1) }, /* #66/1/2 */
    { 0x0510, 0x6910, 0xc3a0, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(-1) }, /* #66/1/4 */
    { 0x0518, 0x6910, 0xc3a0, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(-1) }, /* #66/1/6 */
    { 0x0520, 0x6910, 0x4320, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(-1) }, /* #66/1/8 */
    { 0x0528, 0x6910, 0x4320, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(-1) }, /* #66/1/10 */
    { 0x0530, 0x6910, 0x4320, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(-1) }, /* #66/1/12 */
    { 0x0538, 0x6910, 0x4320, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(-1) }, /* #66/1/14 */
    { 0x0900, 0x6910, 0xc1a0, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/2/0 */
    { 0x0908, 0x6910, 0xc1a0, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/2/2 */
    { 0x0910, 0x6910, 0xc1a0, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/2/4 */
    { 0x0918, 0x6910, 0xc1a0, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/2/6 */
    { 0x0920, 0x6910, 0x4120, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/2/8 */
    { 0x0928, 0x6910, 0x4120, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/2/10 */
    { 0x0930, 0x6910, 0x4120, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/2/12 */
    { 0x0938, 0x6910, 0x4120, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/2/14 */
    { 0x0d00, 0x6910, 0xc1a0, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/3/0 */
    { 0x0d08, 0x6910, 0xc1a0, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/3/2 */
    { 0x0d10, 0x6910, 0xc1a0, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/3/4 */
    { 0x0d18, 0x6910, 0xc1a0, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/3/6 */
    { 0x0d20, 0x6910, 0x4120, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/3/8 */
    { 0x0d28, 0x6910, 0x4120, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/3/10 */
    { 0x0d30, 0x6910, 0x4120, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/3/12 */
    { 0x0d38, 0x6910, 0x4120, RTFLOAT80U_INIT_C(1,0x81808b1e43713fac,0), INT64_C(0) }, /* #66/3/14 */
    { 0x0145, 0x32f0, 0x82a0, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(2) }, /* #67/0/0 */
    { 0x014d, 0x32f0, 0x82a0, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(2) }, /* #67/0/2 */
    { 0x0155, 0x32f0, 0x82a0, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(2) }, /* #67/0/4 */
    { 0x015d, 0x32f0, 0x82a0, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(2) }, /* #67/0/6 */
    { 0x0165, 0x32f0, 0x0220, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(2) }, /* #67/0/8 */
    { 0x016d, 0x32f0, 0x0220, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(2) }, /* #67/0/10 */
    { 0x0175, 0x32f0, 0x0220, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(2) }, /* #67/0/12 */
    { 0x017d, 0x32f0, 0x0220, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(2) }, /* #67/0/14 */
    { 0x0545, 0x32f0, 0x80a0, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(1) }, /* #67/1/0 */
    { 0x054d, 0x32f0, 0x80a0, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(1) }, /* #67/1/2 */
    { 0x0555, 0x32f0, 0x80a0, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(1) }, /* #67/1/4 */
    { 0x055d, 0x32f0, 0x80a0, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(1) }, /* #67/1/6 */
    { 0x0565, 0x32f0, 0x0020, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(1) }, /* #67/1/8 */
    { 0x056d, 0x32f0, 0x0020, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(1) }, /* #67/1/10 */
    { 0x0575, 0x32f0, 0x0020, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(1) }, /* #67/1/12 */
    { 0x057d, 0x32f0, 0x0020, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(1) }, /* #67/1/14 */
    { 0x0945, 0x32f0, 0x82a0, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(2) }, /* #67/2/0 */
    { 0x094d, 0x32f0, 0x82a0, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(2) }, /* #67/2/2 */
    { 0x0955, 0x32f0, 0x82a0, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(2) }, /* #67/2/4 */
    { 0x095d, 0x32f0, 0x82a0, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(2) }, /* #67/2/6 */
    { 0x0965, 0x32f0, 0x0220, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(2) }, /* #67/2/8 */
    { 0x096d, 0x32f0, 0x0220, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(2) }, /* #67/2/10 */
    { 0x0975, 0x32f0, 0x0220, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(2) }, /* #67/2/12 */
    { 0x097d, 0x32f0, 0x0220, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(2) }, /* #67/2/14 */
    { 0x0d45, 0x32f0, 0x80a0, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(1) }, /* #67/3/0 */
    { 0x0d4d, 0x32f0, 0x80a0, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(1) }, /* #67/3/2 */
    { 0x0d55, 0x32f0, 0x80a0, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(1) }, /* #67/3/4 */
    { 0x0d5d, 0x32f0, 0x80a0, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(1) }, /* #67/3/6 */
    { 0x0d65, 0x32f0, 0x0020, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(1) }, /* #67/3/8 */
    { 0x0d6d, 0x32f0, 0x0020, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(1) }, /* #67/3/10 */
    { 0x0d75, 0x32f0, 0x0020, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(1) }, /* #67/3/12 */
    { 0x0d7d, 0x32f0, 0x0020, RTFLOAT80U_INIT_C(0,0xe599fbe8600033bd,16383), INT64_C(1) }, /* #67/3/14 */
    { 0x0303, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/0/0 */
    { 0x030b, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/0/2 */
    { 0x0313, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/0/4 */
    { 0x031b, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/0/6 */
    { 0x0323, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/0/8 */
    { 0x032b, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/0/10 */
    { 0x0333, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/0/12 */
    { 0x033b, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/0/14 */
    { 0x0703, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/1/0 */
    { 0x070b, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/1/2 */
    { 0x0713, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/1/4 */
    { 0x071b, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/1/6 */
    { 0x0723, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/1/8 */
    { 0x072b, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/1/10 */
    { 0x0733, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/1/12 */
    { 0x073b, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/1/14 */
    { 0x0b03, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/2/0 */
    { 0x0b0b, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/2/2 */
    { 0x0b13, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/2/4 */
    { 0x0b1b, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/2/6 */
    { 0x0b23, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/2/8 */
    { 0x0b2b, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/2/10 */
    { 0x0b33, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/2/12 */
    { 0x0b3b, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/2/14 */
    { 0x0f03, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/3/0 */
    { 0x0f0b, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/3/2 */
    { 0x0f13, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/3/4 */
    { 0x0f1b, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/3/6 */
    { 0x0f23, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/3/8 */
    { 0x0f2b, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/3/10 */
    { 0x0f33, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/3/12 */
    { 0x0f3b, 0x3d91, 0x0501, RTFLOAT80U_INIT_C(1,0x45ad4f320c17587e,11214), INT64_MIN }, /* #68/3/14 */
    { 0x0306, 0x30c0, 0x80a0, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/0/0 */
    { 0x030e, 0x30c0, 0x80a0, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/0/2 */
    { 0x0316, 0x30c0, 0x80a0, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/0/4 */
    { 0x031e, 0x30c0, 0x80a0, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/0/6 */
    { 0x0326, 0x30c0, 0x0020, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/0/8 */
    { 0x032e, 0x30c0, 0x0020, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/0/10 */
    { 0x0336, 0x30c0, 0x0020, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/0/12 */
    { 0x033e, 0x30c0, 0x0020, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/0/14 */
    { 0x0706, 0x30c0, 0x80a0, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/1/0 */
    { 0x070e, 0x30c0, 0x80a0, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/1/2 */
    { 0x0716, 0x30c0, 0x80a0, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/1/4 */
    { 0x071e, 0x30c0, 0x80a0, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/1/6 */
    { 0x0726, 0x30c0, 0x0020, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/1/8 */
    { 0x072e, 0x30c0, 0x0020, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/1/10 */
    { 0x0736, 0x30c0, 0x0020, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/1/12 */
    { 0x073e, 0x30c0, 0x0020, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/1/14 */
    { 0x0b06, 0x30c0, 0x82a0, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(1) }, /* #69/2/0 */
    { 0x0b0e, 0x30c0, 0x82a0, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(1) }, /* #69/2/2 */
    { 0x0b16, 0x30c0, 0x82a0, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(1) }, /* #69/2/4 */
    { 0x0b1e, 0x30c0, 0x82a0, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(1) }, /* #69/2/6 */
    { 0x0b26, 0x30c0, 0x0220, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(1) }, /* #69/2/8 */
    { 0x0b2e, 0x30c0, 0x0220, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(1) }, /* #69/2/10 */
    { 0x0b36, 0x30c0, 0x0220, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(1) }, /* #69/2/12 */
    { 0x0b3e, 0x30c0, 0x0220, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(1) }, /* #69/2/14 */
    { 0x0f06, 0x30c0, 0x80a0, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/3/0 */
    { 0x0f0e, 0x30c0, 0x80a0, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/3/2 */
    { 0x0f16, 0x30c0, 0x80a0, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/3/4 */
    { 0x0f1e, 0x30c0, 0x80a0, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/3/6 */
    { 0x0f26, 0x30c0, 0x0020, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/3/8 */
    { 0x0f2e, 0x30c0, 0x0020, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/3/10 */
    { 0x0f36, 0x30c0, 0x0020, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/3/12 */
    { 0x0f3e, 0x30c0, 0x0020, RTFLOAT80U_INIT_C(0,0x80000027b5219c4a,0), INT64_C(0) }, /* #69/3/14 */
    { 0x0002, 0xf6d9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/0/0 */
    { 0x000a, 0xf6d9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/0/2 */
    { 0x0012, 0xf6d9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/0/4 */
    { 0x001a, 0xf6d9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/0/6 */
    { 0x0022, 0xf6d9, 0x4420, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/0/8 */
    { 0x002a, 0xf6d9, 0x4420, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/0/10 */
    { 0x0032, 0xf6d9, 0x4420, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/0/12 */
    { 0x003a, 0xf6d9, 0x4420, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/0/14 */
    { 0x0402, 0xf6d9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/1/0 */
    { 0x040a, 0xf6d9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/1/2 */
    { 0x0412, 0xf6d9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/1/4 */
    { 0x041a, 0xf6d9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/1/6 */
    { 0x0422, 0xf6d9, 0x4420, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/1/8 */
    { 0x042a, 0xf6d9, 0x4420, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/1/10 */
    { 0x0432, 0xf6d9, 0x4420, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/1/12 */
    { 0x043a, 0xf6d9, 0x4420, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/1/14 */
    { 0x0802, 0xf6d9, 0xc6a0, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(1) }, /* #70/2/0 */
    { 0x080a, 0xf6d9, 0xc6a0, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(1) }, /* #70/2/2 */
    { 0x0812, 0xf6d9, 0xc6a0, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(1) }, /* #70/2/4 */
    { 0x081a, 0xf6d9, 0xc6a0, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(1) }, /* #70/2/6 */
    { 0x0822, 0xf6d9, 0x4620, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(1) }, /* #70/2/8 */
    { 0x082a, 0xf6d9, 0x4620, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(1) }, /* #70/2/10 */
    { 0x0832, 0xf6d9, 0x4620, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(1) }, /* #70/2/12 */
    { 0x083a, 0xf6d9, 0x4620, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(1) }, /* #70/2/14 */
    { 0x0c02, 0xf6d9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/3/0 */
    { 0x0c0a, 0xf6d9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/3/2 */
    { 0x0c12, 0xf6d9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/3/4 */
    { 0x0c1a, 0xf6d9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/3/6 */
    { 0x0c22, 0xf6d9, 0x4420, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/3/8 */
    { 0x0c2a, 0xf6d9, 0x4420, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/3/10 */
    { 0x0c32, 0xf6d9, 0x4420, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/3/12 */
    { 0x0c3a, 0xf6d9, 0x4420, RTFLOAT80U_INIT_C(0,0x5f,0), INT64_C(0) }, /* #70/3/14 */
    { 0x0044, 0x355a, 0x85a0, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/0/0 */
    { 0x004c, 0x355a, 0x85a0, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/0/2 */
    { 0x0054, 0x355a, 0x85a0, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/0/4 */
    { 0x005c, 0x355a, 0x85a0, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/0/6 */
    { 0x0064, 0x355a, 0x0520, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/0/8 */
    { 0x006c, 0x355a, 0x0520, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/0/10 */
    { 0x0074, 0x355a, 0x0520, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/0/12 */
    { 0x007c, 0x355a, 0x0520, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/0/14 */
    { 0x0444, 0x355a, 0x85a0, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/1/0 */
    { 0x044c, 0x355a, 0x85a0, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/1/2 */
    { 0x0454, 0x355a, 0x85a0, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/1/4 */
    { 0x045c, 0x355a, 0x85a0, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/1/6 */
    { 0x0464, 0x355a, 0x0520, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/1/8 */
    { 0x046c, 0x355a, 0x0520, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/1/10 */
    { 0x0474, 0x355a, 0x0520, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/1/12 */
    { 0x047c, 0x355a, 0x0520, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/1/14 */
    { 0x0844, 0x355a, 0x87a0, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217595) }, /* #71/2/0 */
    { 0x084c, 0x355a, 0x87a0, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217595) }, /* #71/2/2 */
    { 0x0854, 0x355a, 0x87a0, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217595) }, /* #71/2/4 */
    { 0x085c, 0x355a, 0x87a0, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217595) }, /* #71/2/6 */
    { 0x0864, 0x355a, 0x0720, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217595) }, /* #71/2/8 */
    { 0x086c, 0x355a, 0x0720, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217595) }, /* #71/2/10 */
    { 0x0874, 0x355a, 0x0720, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217595) }, /* #71/2/12 */
    { 0x087c, 0x355a, 0x0720, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217595) }, /* #71/2/14 */
    { 0x0c44, 0x355a, 0x85a0, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/3/0 */
    { 0x0c4c, 0x355a, 0x85a0, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/3/2 */
    { 0x0c54, 0x355a, 0x85a0, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/3/4 */
    { 0x0c5c, 0x355a, 0x85a0, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/3/6 */
    { 0x0c64, 0x355a, 0x0520, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/3/8 */
    { 0x0c6c, 0x355a, 0x0520, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/3/10 */
    { 0x0c74, 0x355a, 0x0520, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/3/12 */
    { 0x0c7c, 0x355a, 0x0520, RTFLOAT80U_INIT_C(0,0x97ad95cb59bbb475,16445), INT64_C(5464778285657217594) }, /* #71/3/14 */
    { 0x0204, 0x3218, 0x80a0, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/0/0 */
    { 0x020c, 0x3218, 0x80a0, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/0/2 */
    { 0x0214, 0x3218, 0x80a0, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/0/4 */
    { 0x021c, 0x3218, 0x80a0, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/0/6 */
    { 0x0224, 0x3218, 0x0020, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/0/8 */
    { 0x022c, 0x3218, 0x0020, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/0/10 */
    { 0x0234, 0x3218, 0x0020, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/0/12 */
    { 0x023c, 0x3218, 0x0020, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/0/14 */
    { 0x0604, 0x3218, 0x80a0, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/1/0 */
    { 0x060c, 0x3218, 0x80a0, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/1/2 */
    { 0x0614, 0x3218, 0x80a0, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/1/4 */
    { 0x061c, 0x3218, 0x80a0, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/1/6 */
    { 0x0624, 0x3218, 0x0020, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/1/8 */
    { 0x062c, 0x3218, 0x0020, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/1/10 */
    { 0x0634, 0x3218, 0x0020, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/1/12 */
    { 0x063c, 0x3218, 0x0020, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/1/14 */
    { 0x0a04, 0x3218, 0x82a0, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(1) }, /* #72/2/0 */
    { 0x0a0c, 0x3218, 0x82a0, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(1) }, /* #72/2/2 */
    { 0x0a14, 0x3218, 0x82a0, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(1) }, /* #72/2/4 */
    { 0x0a1c, 0x3218, 0x82a0, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(1) }, /* #72/2/6 */
    { 0x0a24, 0x3218, 0x0220, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(1) }, /* #72/2/8 */
    { 0x0a2c, 0x3218, 0x0220, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(1) }, /* #72/2/10 */
    { 0x0a34, 0x3218, 0x0220, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(1) }, /* #72/2/12 */
    { 0x0a3c, 0x3218, 0x0220, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(1) }, /* #72/2/14 */
    { 0x0e04, 0x3218, 0x80a0, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/3/0 */
    { 0x0e0c, 0x3218, 0x80a0, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/3/2 */
    { 0x0e14, 0x3218, 0x80a0, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/3/4 */
    { 0x0e1c, 0x3218, 0x80a0, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/3/6 */
    { 0x0e24, 0x3218, 0x0020, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/3/8 */
    { 0x0e2c, 0x3218, 0x0020, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/3/10 */
    { 0x0e34, 0x3218, 0x0020, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/3/12 */
    { 0x0e3c, 0x3218, 0x0020, RTFLOAT80U_INIT_C(0,0x8370a4c31669a2c1,1775), INT64_C(0) }, /* #72/3/14 */
    { 0x0201, 0x54d6, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/0/0 */
    { 0x0209, 0x54d6, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/0/2 */
    { 0x0211, 0x54d6, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/0/4 */
    { 0x0219, 0x54d6, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/0/6 */
    { 0x0221, 0x54d6, 0x4420, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/0/8 */
    { 0x0229, 0x54d6, 0x4420, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/0/10 */
    { 0x0231, 0x54d6, 0x4420, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/0/12 */
    { 0x0239, 0x54d6, 0x4420, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/0/14 */
    { 0x0601, 0x54d6, 0xc6a0, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-2) }, /* #73/1/0 */
    { 0x0609, 0x54d6, 0xc6a0, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-2) }, /* #73/1/2 */
    { 0x0611, 0x54d6, 0xc6a0, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-2) }, /* #73/1/4 */
    { 0x0619, 0x54d6, 0xc6a0, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-2) }, /* #73/1/6 */
    { 0x0621, 0x54d6, 0x4620, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-2) }, /* #73/1/8 */
    { 0x0629, 0x54d6, 0x4620, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-2) }, /* #73/1/10 */
    { 0x0631, 0x54d6, 0x4620, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-2) }, /* #73/1/12 */
    { 0x0639, 0x54d6, 0x4620, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-2) }, /* #73/1/14 */
    { 0x0a01, 0x54d6, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/2/0 */
    { 0x0a09, 0x54d6, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/2/2 */
    { 0x0a11, 0x54d6, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/2/4 */
    { 0x0a19, 0x54d6, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/2/6 */
    { 0x0a21, 0x54d6, 0x4420, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/2/8 */
    { 0x0a29, 0x54d6, 0x4420, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/2/10 */
    { 0x0a31, 0x54d6, 0x4420, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/2/12 */
    { 0x0a39, 0x54d6, 0x4420, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/2/14 */
    { 0x0e01, 0x54d6, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/3/0 */
    { 0x0e09, 0x54d6, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/3/2 */
    { 0x0e11, 0x54d6, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/3/4 */
    { 0x0e19, 0x54d6, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/3/6 */
    { 0x0e21, 0x54d6, 0x4420, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/3/8 */
    { 0x0e29, 0x54d6, 0x4420, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/3/10 */
    { 0x0e31, 0x54d6, 0x4420, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/3/12 */
    { 0x0e39, 0x54d6, 0x4420, RTFLOAT80U_INIT_C(1,0x8fc0a2632cd42d81,16383), INT64_C(-1) }, /* #73/3/14 */
    { 0x0207, 0x3a0a, 0x82a0, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(2) }, /* #74/0/0 */
    { 0x020f, 0x3a0a, 0x82a0, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(2) }, /* #74/0/2 */
    { 0x0217, 0x3a0a, 0x82a0, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(2) }, /* #74/0/4 */
    { 0x021f, 0x3a0a, 0x82a0, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(2) }, /* #74/0/6 */
    { 0x0227, 0x3a0a, 0x0220, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(2) }, /* #74/0/8 */
    { 0x022f, 0x3a0a, 0x0220, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(2) }, /* #74/0/10 */
    { 0x0237, 0x3a0a, 0x0220, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(2) }, /* #74/0/12 */
    { 0x023f, 0x3a0a, 0x0220, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(2) }, /* #74/0/14 */
    { 0x0607, 0x3a0a, 0x80a0, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(1) }, /* #74/1/0 */
    { 0x060f, 0x3a0a, 0x80a0, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(1) }, /* #74/1/2 */
    { 0x0617, 0x3a0a, 0x80a0, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(1) }, /* #74/1/4 */
    { 0x061f, 0x3a0a, 0x80a0, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(1) }, /* #74/1/6 */
    { 0x0627, 0x3a0a, 0x0020, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(1) }, /* #74/1/8 */
    { 0x062f, 0x3a0a, 0x0020, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(1) }, /* #74/1/10 */
    { 0x0637, 0x3a0a, 0x0020, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(1) }, /* #74/1/12 */
    { 0x063f, 0x3a0a, 0x0020, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(1) }, /* #74/1/14 */
    { 0x0a07, 0x3a0a, 0x82a0, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(2) }, /* #74/2/0 */
    { 0x0a0f, 0x3a0a, 0x82a0, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(2) }, /* #74/2/2 */
    { 0x0a17, 0x3a0a, 0x82a0, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(2) }, /* #74/2/4 */
    { 0x0a1f, 0x3a0a, 0x82a0, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(2) }, /* #74/2/6 */
    { 0x0a27, 0x3a0a, 0x0220, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(2) }, /* #74/2/8 */
    { 0x0a2f, 0x3a0a, 0x0220, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(2) }, /* #74/2/10 */
    { 0x0a37, 0x3a0a, 0x0220, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(2) }, /* #74/2/12 */
    { 0x0a3f, 0x3a0a, 0x0220, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(2) }, /* #74/2/14 */
    { 0x0e07, 0x3a0a, 0x80a0, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(1) }, /* #74/3/0 */
    { 0x0e0f, 0x3a0a, 0x80a0, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(1) }, /* #74/3/2 */
    { 0x0e17, 0x3a0a, 0x80a0, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(1) }, /* #74/3/4 */
    { 0x0e1f, 0x3a0a, 0x80a0, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(1) }, /* #74/3/6 */
    { 0x0e27, 0x3a0a, 0x0020, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(1) }, /* #74/3/8 */
    { 0x0e2f, 0x3a0a, 0x0020, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(1) }, /* #74/3/10 */
    { 0x0e37, 0x3a0a, 0x0020, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(1) }, /* #74/3/12 */
    { 0x0e3f, 0x3a0a, 0x0020, RTFLOAT80U_INIT_C(0,0xe24ddca823f94b32,16383), INT64_C(1) }, /* #74/3/14 */
    { 0x0301, 0x1d95, 0x85a0, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/0/0 */
    { 0x0309, 0x1d95, 0x85a0, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/0/2 */
    { 0x0311, 0x1d95, 0x85a0, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/0/4 */
    { 0x0319, 0x1d95, 0x85a0, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/0/6 */
    { 0x0321, 0x1d95, 0x0520, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/0/8 */
    { 0x0329, 0x1d95, 0x0520, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/0/10 */
    { 0x0331, 0x1d95, 0x0520, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/0/12 */
    { 0x0339, 0x1d95, 0x0520, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/0/14 */
    { 0x0701, 0x1d95, 0x87a0, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-2) }, /* #75/1/0 */
    { 0x0709, 0x1d95, 0x87a0, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-2) }, /* #75/1/2 */
    { 0x0711, 0x1d95, 0x87a0, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-2) }, /* #75/1/4 */
    { 0x0719, 0x1d95, 0x87a0, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-2) }, /* #75/1/6 */
    { 0x0721, 0x1d95, 0x0720, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-2) }, /* #75/1/8 */
    { 0x0729, 0x1d95, 0x0720, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-2) }, /* #75/1/10 */
    { 0x0731, 0x1d95, 0x0720, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-2) }, /* #75/1/12 */
    { 0x0739, 0x1d95, 0x0720, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-2) }, /* #75/1/14 */
    { 0x0b01, 0x1d95, 0x85a0, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/2/0 */
    { 0x0b09, 0x1d95, 0x85a0, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/2/2 */
    { 0x0b11, 0x1d95, 0x85a0, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/2/4 */
    { 0x0b19, 0x1d95, 0x85a0, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/2/6 */
    { 0x0b21, 0x1d95, 0x0520, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/2/8 */
    { 0x0b29, 0x1d95, 0x0520, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/2/10 */
    { 0x0b31, 0x1d95, 0x0520, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/2/12 */
    { 0x0b39, 0x1d95, 0x0520, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/2/14 */
    { 0x0f01, 0x1d95, 0x85a0, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/3/0 */
    { 0x0f09, 0x1d95, 0x85a0, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/3/2 */
    { 0x0f11, 0x1d95, 0x85a0, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/3/4 */
    { 0x0f19, 0x1d95, 0x85a0, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/3/6 */
    { 0x0f21, 0x1d95, 0x0520, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/3/8 */
    { 0x0f29, 0x1d95, 0x0520, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/3/10 */
    { 0x0f31, 0x1d95, 0x0520, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/3/12 */
    { 0x0f39, 0x1d95, 0x0520, RTFLOAT80U_INIT_C(1,0x969a285550076850,16383), INT64_C(-1) }, /* #75/3/14 */
    { 0x0345, 0x89ac, 0x81a0, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/0/0 */
    { 0x034d, 0x89ac, 0x81a0, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/0/2 */
    { 0x0355, 0x89ac, 0x81a0, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/0/4 */
    { 0x035d, 0x89ac, 0x81a0, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/0/6 */
    { 0x0365, 0x89ac, 0x0120, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/0/8 */
    { 0x036d, 0x89ac, 0x0120, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/0/10 */
    { 0x0375, 0x89ac, 0x0120, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/0/12 */
    { 0x037d, 0x89ac, 0x0120, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/0/14 */
    { 0x0745, 0x89ac, 0x81a0, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/1/0 */
    { 0x074d, 0x89ac, 0x81a0, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/1/2 */
    { 0x0755, 0x89ac, 0x81a0, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/1/4 */
    { 0x075d, 0x89ac, 0x81a0, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/1/6 */
    { 0x0765, 0x89ac, 0x0120, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/1/8 */
    { 0x076d, 0x89ac, 0x0120, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/1/10 */
    { 0x0775, 0x89ac, 0x0120, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/1/12 */
    { 0x077d, 0x89ac, 0x0120, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/1/14 */
    { 0x0b45, 0x89ac, 0x83a0, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(2) }, /* #76/2/0 */
    { 0x0b4d, 0x89ac, 0x83a0, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(2) }, /* #76/2/2 */
    { 0x0b55, 0x89ac, 0x83a0, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(2) }, /* #76/2/4 */
    { 0x0b5d, 0x89ac, 0x83a0, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(2) }, /* #76/2/6 */
    { 0x0b65, 0x89ac, 0x0320, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(2) }, /* #76/2/8 */
    { 0x0b6d, 0x89ac, 0x0320, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(2) }, /* #76/2/10 */
    { 0x0b75, 0x89ac, 0x0320, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(2) }, /* #76/2/12 */
    { 0x0b7d, 0x89ac, 0x0320, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(2) }, /* #76/2/14 */
    { 0x0f45, 0x89ac, 0x81a0, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/3/0 */
    { 0x0f4d, 0x89ac, 0x81a0, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/3/2 */
    { 0x0f55, 0x89ac, 0x81a0, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/3/4 */
    { 0x0f5d, 0x89ac, 0x81a0, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/3/6 */
    { 0x0f65, 0x89ac, 0x0120, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/3/8 */
    { 0x0f6d, 0x89ac, 0x0120, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/3/10 */
    { 0x0f75, 0x89ac, 0x0120, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/3/12 */
    { 0x0f7d, 0x89ac, 0x0120, RTFLOAT80U_INIT_C(0,0xa72d6aa0231be2a1,16383), INT64_C(1) }, /* #76/3/14 */
    { 0x0140, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/0/0 */
    { 0x0148, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/0/2 */
    { 0x0150, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/0/4 */
    { 0x0158, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/0/6 */
    { 0x0160, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/0/8 */
    { 0x0168, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/0/10 */
    { 0x0170, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/0/12 */
    { 0x0178, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/0/14 */
    { 0x0540, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/1/0 */
    { 0x0548, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/1/2 */
    { 0x0550, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/1/4 */
    { 0x0558, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/1/6 */
    { 0x0560, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/1/8 */
    { 0x0568, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/1/10 */
    { 0x0570, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/1/12 */
    { 0x0578, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/1/14 */
    { 0x0940, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/2/0 */
    { 0x0948, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/2/2 */
    { 0x0950, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/2/4 */
    { 0x0958, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/2/6 */
    { 0x0960, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/2/8 */
    { 0x0968, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/2/10 */
    { 0x0970, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/2/12 */
    { 0x0978, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/2/14 */
    { 0x0d40, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/3/0 */
    { 0x0d48, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/3/2 */
    { 0x0d50, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/3/4 */
    { 0x0d58, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/3/6 */
    { 0x0d60, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/3/8 */
    { 0x0d68, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/3/10 */
    { 0x0d70, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/3/12 */
    { 0x0d78, 0x0812, 0xb881, RTFLOAT80U_INIT_C(1,0x238ca6898a754725,16331), INT64_C(-3) }, /* #77/3/14 */
    { 0x0201, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/0/0 */
    { 0x0209, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/0/2 */
    { 0x0211, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/0/4 */
    { 0x0219, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/0/6 */
    { 0x0221, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/0/8 */
    { 0x0229, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/0/10 */
    { 0x0231, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/0/12 */
    { 0x0239, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/0/14 */
    { 0x0601, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/1/0 */
    { 0x0609, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/1/2 */
    { 0x0611, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/1/4 */
    { 0x0619, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/1/6 */
    { 0x0621, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/1/8 */
    { 0x0629, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/1/10 */
    { 0x0631, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/1/12 */
    { 0x0639, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/1/14 */
    { 0x0a01, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/2/0 */
    { 0x0a09, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/2/2 */
    { 0x0a11, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/2/4 */
    { 0x0a19, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/2/6 */
    { 0x0a21, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/2/8 */
    { 0x0a29, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/2/10 */
    { 0x0a31, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/2/12 */
    { 0x0a39, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/2/14 */
    { 0x0e01, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/3/0 */
    { 0x0e09, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/3/2 */
    { 0x0e11, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/3/4 */
    { 0x0e19, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/3/6 */
    { 0x0e21, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/3/8 */
    { 0x0e29, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/3/10 */
    { 0x0e31, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/3/12 */
    { 0x0e39, 0xb964, 0x0101, RTFLOAT80U_INIT_C(0,0x5b,14640), INT64_MIN }, /* #78/3/14 */
    { 0x0201, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/0/0 */
    { 0x0209, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/0/2 */
    { 0x0211, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/0/4 */
    { 0x0219, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/0/6 */
    { 0x0221, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/0/8 */
    { 0x0229, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/0/10 */
    { 0x0231, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/0/12 */
    { 0x0239, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/0/14 */
    { 0x0601, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/1/0 */
    { 0x0609, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/1/2 */
    { 0x0611, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/1/4 */
    { 0x0619, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/1/6 */
    { 0x0621, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/1/8 */
    { 0x0629, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/1/10 */
    { 0x0631, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/1/12 */
    { 0x0639, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/1/14 */
    { 0x0a01, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/2/0 */
    { 0x0a09, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/2/2 */
    { 0x0a11, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/2/4 */
    { 0x0a19, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/2/6 */
    { 0x0a21, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/2/8 */
    { 0x0a29, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/2/10 */
    { 0x0a31, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/2/12 */
    { 0x0a39, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/2/14 */
    { 0x0e01, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/3/0 */
    { 0x0e09, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/3/2 */
    { 0x0e11, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/3/4 */
    { 0x0e19, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/3/6 */
    { 0x0e21, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/3/8 */
    { 0x0e29, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/3/10 */
    { 0x0e31, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/3/12 */
    { 0x0e39, 0x1652, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_MIN }, /* #79/3/14 */
    { 0x0044, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/0/0 */
    { 0x004c, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/0/2 */
    { 0x0054, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/0/4 */
    { 0x005c, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/0/6 */
    { 0x0064, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/0/8 */
    { 0x006c, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/0/10 */
    { 0x0074, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/0/12 */
    { 0x007c, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/0/14 */
    { 0x0444, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/1/0 */
    { 0x044c, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/1/2 */
    { 0x0454, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/1/4 */
    { 0x045c, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/1/6 */
    { 0x0464, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/1/8 */
    { 0x046c, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/1/10 */
    { 0x0474, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/1/12 */
    { 0x047c, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/1/14 */
    { 0x0844, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/2/0 */
    { 0x084c, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/2/2 */
    { 0x0854, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/2/4 */
    { 0x085c, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/2/6 */
    { 0x0864, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/2/8 */
    { 0x086c, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/2/10 */
    { 0x0874, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/2/12 */
    { 0x087c, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/2/14 */
    { 0x0c44, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/3/0 */
    { 0x0c4c, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/3/2 */
    { 0x0c54, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/3/4 */
    { 0x0c5c, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/3/6 */
    { 0x0c64, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/3/8 */
    { 0x0c6c, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/3/10 */
    { 0x0c74, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/3/12 */
    { 0x0c7c, 0x4d38, 0xfd81, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #80/3/14 */
    { 0x0341, 0x6d80, 0xc5a0, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/0/0 */
    { 0x0349, 0x6d80, 0xc5a0, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/0/2 */
    { 0x0351, 0x6d80, 0xc5a0, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/0/4 */
    { 0x0359, 0x6d80, 0xc5a0, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/0/6 */
    { 0x0361, 0x6d80, 0x4520, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/0/8 */
    { 0x0369, 0x6d80, 0x4520, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/0/10 */
    { 0x0371, 0x6d80, 0x4520, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/0/12 */
    { 0x0379, 0x6d80, 0x4520, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/0/14 */
    { 0x0741, 0x6d80, 0xc7a0, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(-1) }, /* #81/1/0 */
    { 0x0749, 0x6d80, 0xc7a0, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(-1) }, /* #81/1/2 */
    { 0x0751, 0x6d80, 0xc7a0, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(-1) }, /* #81/1/4 */
    { 0x0759, 0x6d80, 0xc7a0, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(-1) }, /* #81/1/6 */
    { 0x0761, 0x6d80, 0x4720, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(-1) }, /* #81/1/8 */
    { 0x0769, 0x6d80, 0x4720, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(-1) }, /* #81/1/10 */
    { 0x0771, 0x6d80, 0x4720, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(-1) }, /* #81/1/12 */
    { 0x0779, 0x6d80, 0x4720, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(-1) }, /* #81/1/14 */
    { 0x0b41, 0x6d80, 0xc5a0, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/2/0 */
    { 0x0b49, 0x6d80, 0xc5a0, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/2/2 */
    { 0x0b51, 0x6d80, 0xc5a0, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/2/4 */
    { 0x0b59, 0x6d80, 0xc5a0, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/2/6 */
    { 0x0b61, 0x6d80, 0x4520, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/2/8 */
    { 0x0b69, 0x6d80, 0x4520, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/2/10 */
    { 0x0b71, 0x6d80, 0x4520, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/2/12 */
    { 0x0b79, 0x6d80, 0x4520, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/2/14 */
    { 0x0f41, 0x6d80, 0xc5a0, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/3/0 */
    { 0x0f49, 0x6d80, 0xc5a0, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/3/2 */
    { 0x0f51, 0x6d80, 0xc5a0, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/3/4 */
    { 0x0f59, 0x6d80, 0xc5a0, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/3/6 */
    { 0x0f61, 0x6d80, 0x4520, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/3/8 */
    { 0x0f69, 0x6d80, 0x4520, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/3/10 */
    { 0x0f71, 0x6d80, 0x4520, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/3/12 */
    { 0x0f79, 0x6d80, 0x4520, RTFLOAT80U_INIT_C(1,0x949aec03e6e2c860,1600), INT64_C(0) }, /* #81/3/14 */
    { 0x0145, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/0/0 */
    { 0x014d, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/0/2 */
    { 0x0155, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/0/4 */
    { 0x015d, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/0/6 */
    { 0x0165, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/0/8 */
    { 0x016d, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/0/10 */
    { 0x0175, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/0/12 */
    { 0x017d, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/0/14 */
    { 0x0545, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/1/0 */
    { 0x054d, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/1/2 */
    { 0x0555, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/1/4 */
    { 0x055d, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/1/6 */
    { 0x0565, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/1/8 */
    { 0x056d, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/1/10 */
    { 0x0575, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/1/12 */
    { 0x057d, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/1/14 */
    { 0x0945, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/2/0 */
    { 0x094d, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/2/2 */
    { 0x0955, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/2/4 */
    { 0x095d, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/2/6 */
    { 0x0965, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/2/8 */
    { 0x096d, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/2/10 */
    { 0x0975, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/2/12 */
    { 0x097d, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/2/14 */
    { 0x0d45, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/3/0 */
    { 0x0d4d, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/3/2 */
    { 0x0d55, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/3/4 */
    { 0x0d5d, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/3/6 */
    { 0x0d65, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/3/8 */
    { 0x0d6d, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/3/10 */
    { 0x0d75, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/3/12 */
    { 0x0d7d, 0xe688, 0x4401, RTFLOAT80U_INIT_C(0,0x94e9547cc9e94dfa,32767), INT64_MIN }, /* #82/3/14 */
    { 0x0246, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/0/0 */
    { 0x024e, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/0/2 */
    { 0x0256, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/0/4 */
    { 0x025e, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/0/6 */
    { 0x0266, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/0/8 */
    { 0x026e, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/0/10 */
    { 0x0276, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/0/12 */
    { 0x027e, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/0/14 */
    { 0x0646, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/1/0 */
    { 0x064e, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/1/2 */
    { 0x0656, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/1/4 */
    { 0x065e, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/1/6 */
    { 0x0666, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/1/8 */
    { 0x066e, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/1/10 */
    { 0x0676, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/1/12 */
    { 0x067e, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/1/14 */
    { 0x0a46, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/2/0 */
    { 0x0a4e, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/2/2 */
    { 0x0a56, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/2/4 */
    { 0x0a5e, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/2/6 */
    { 0x0a66, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/2/8 */
    { 0x0a6e, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/2/10 */
    { 0x0a76, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/2/12 */
    { 0x0a7e, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/2/14 */
    { 0x0e46, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/3/0 */
    { 0x0e4e, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/3/2 */
    { 0x0e56, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/3/4 */
    { 0x0e5e, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/3/6 */
    { 0x0e66, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/3/8 */
    { 0x0e6e, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/3/10 */
    { 0x0e76, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/3/12 */
    { 0x0e7e, 0xc2f9, 0xf881, RTFLOAT80U_INIT_C(1,0x235c9cf20fe6220c,12225), INT64_C(-3) }, /* #83/3/14 */
    { 0x0004, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/0/0 */
    { 0x000c, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/0/2 */
    { 0x0014, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/0/4 */
    { 0x001c, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/0/6 */
    { 0x0024, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/0/8 */
    { 0x002c, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/0/10 */
    { 0x0034, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/0/12 */
    { 0x003c, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/0/14 */
    { 0x0404, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/1/0 */
    { 0x040c, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/1/2 */
    { 0x0414, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/1/4 */
    { 0x041c, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/1/6 */
    { 0x0424, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/1/8 */
    { 0x042c, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/1/10 */
    { 0x0434, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/1/12 */
    { 0x043c, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/1/14 */
    { 0x0804, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/2/0 */
    { 0x080c, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/2/2 */
    { 0x0814, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/2/4 */
    { 0x081c, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/2/6 */
    { 0x0824, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/2/8 */
    { 0x082c, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/2/10 */
    { 0x0834, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/2/12 */
    { 0x083c, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/2/14 */
    { 0x0c04, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/3/0 */
    { 0x0c0c, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/3/2 */
    { 0x0c14, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/3/4 */
    { 0x0c1c, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/3/6 */
    { 0x0c24, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/3/8 */
    { 0x0c2c, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/3/10 */
    { 0x0c34, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/3/12 */
    { 0x0c3c, 0x42b5, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT64_C(-3) }, /* #84/3/14 */
    { 0x0043, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/0/0 */
    { 0x004b, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/0/2 */
    { 0x0053, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/0/4 */
    { 0x005b, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/0/6 */
    { 0x0063, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/0/8 */
    { 0x006b, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/0/10 */
    { 0x0073, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/0/12 */
    { 0x007b, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/0/14 */
    { 0x0443, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/1/0 */
    { 0x044b, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/1/2 */
    { 0x0453, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/1/4 */
    { 0x045b, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/1/6 */
    { 0x0463, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/1/8 */
    { 0x046b, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/1/10 */
    { 0x0473, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/1/12 */
    { 0x047b, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/1/14 */
    { 0x0843, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/2/0 */
    { 0x084b, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/2/2 */
    { 0x0853, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/2/4 */
    { 0x085b, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/2/6 */
    { 0x0863, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/2/8 */
    { 0x086b, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/2/10 */
    { 0x0873, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/2/12 */
    { 0x087b, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/2/14 */
    { 0x0c43, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/3/0 */
    { 0x0c4b, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/3/2 */
    { 0x0c53, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/3/4 */
    { 0x0c5b, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/3/6 */
    { 0x0c63, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/3/8 */
    { 0x0c6b, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/3/10 */
    { 0x0c73, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/3/12 */
    { 0x0c7b, 0x493f, 0x4101, RTFLOAT80U_INIT_C(0,0x102bf5cc0632053e,32767), INT64_MIN }, /* #85/3/14 */
    { 0x0344, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/0/0 */
    { 0x034c, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/0/2 */
    { 0x0354, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/0/4 */
    { 0x035c, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/0/6 */
    { 0x0364, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/0/8 */
    { 0x036c, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/0/10 */
    { 0x0374, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/0/12 */
    { 0x037c, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/0/14 */
    { 0x0744, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/1/0 */
    { 0x074c, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/1/2 */
    { 0x0754, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/1/4 */
    { 0x075c, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/1/6 */
    { 0x0764, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/1/8 */
    { 0x076c, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/1/10 */
    { 0x0774, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/1/12 */
    { 0x077c, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/1/14 */
    { 0x0b44, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/2/0 */
    { 0x0b4c, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/2/2 */
    { 0x0b54, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/2/4 */
    { 0x0b5c, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/2/6 */
    { 0x0b64, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/2/8 */
    { 0x0b6c, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/2/10 */
    { 0x0b74, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/2/12 */
    { 0x0b7c, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/2/14 */
    { 0x0f44, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/3/0 */
    { 0x0f4c, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/3/2 */
    { 0x0f54, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/3/4 */
    { 0x0f5c, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/3/6 */
    { 0x0f64, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/3/8 */
    { 0x0f6c, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/3/10 */
    { 0x0f74, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/3/12 */
    { 0x0f7c, 0x9274, 0xb881, RTFLOAT80U_INIT_C(1,0x212e0df04dc8f4fe,14772), INT64_C(-3) }, /* #86/3/14 */
    { 0x0240, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/0/0 */
    { 0x0248, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/0/2 */
    { 0x0250, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/0/4 */
    { 0x0258, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/0/6 */
    { 0x0260, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/0/8 */
    { 0x0268, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/0/10 */
    { 0x0270, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/0/12 */
    { 0x0278, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/0/14 */
    { 0x0640, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/1/0 */
    { 0x0648, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/1/2 */
    { 0x0650, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/1/4 */
    { 0x0658, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/1/6 */
    { 0x0660, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/1/8 */
    { 0x0668, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/1/10 */
    { 0x0670, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/1/12 */
    { 0x0678, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/1/14 */
    { 0x0a40, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/2/0 */
    { 0x0a48, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/2/2 */
    { 0x0a50, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/2/4 */
    { 0x0a58, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/2/6 */
    { 0x0a60, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/2/8 */
    { 0x0a68, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/2/10 */
    { 0x0a70, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/2/12 */
    { 0x0a78, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/2/14 */
    { 0x0e40, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/3/0 */
    { 0x0e48, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/3/2 */
    { 0x0e50, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/3/4 */
    { 0x0e58, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/3/6 */
    { 0x0e60, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/3/8 */
    { 0x0e68, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/3/10 */
    { 0x0e70, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/3/12 */
    { 0x0e78, 0x56ae, 0xfc81, RTFLOAT80U_INIT_C(0,0x41abbcc7cfd346bf,4481), INT64_C(-3) }, /* #87/3/14 */
    { 0x0303, 0x512a, 0xc1a0, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/0/0 */
    { 0x030b, 0x512a, 0xc1a0, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/0/2 */
    { 0x0313, 0x512a, 0xc1a0, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/0/4 */
    { 0x031b, 0x512a, 0xc1a0, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/0/6 */
    { 0x0323, 0x512a, 0x4120, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/0/8 */
    { 0x032b, 0x512a, 0x4120, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/0/10 */
    { 0x0333, 0x512a, 0x4120, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/0/12 */
    { 0x033b, 0x512a, 0x4120, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/0/14 */
    { 0x0703, 0x512a, 0xc3a0, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(-1) }, /* #88/1/0 */
    { 0x070b, 0x512a, 0xc3a0, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(-1) }, /* #88/1/2 */
    { 0x0713, 0x512a, 0xc3a0, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(-1) }, /* #88/1/4 */
    { 0x071b, 0x512a, 0xc3a0, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(-1) }, /* #88/1/6 */
    { 0x0723, 0x512a, 0x4320, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(-1) }, /* #88/1/8 */
    { 0x072b, 0x512a, 0x4320, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(-1) }, /* #88/1/10 */
    { 0x0733, 0x512a, 0x4320, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(-1) }, /* #88/1/12 */
    { 0x073b, 0x512a, 0x4320, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(-1) }, /* #88/1/14 */
    { 0x0b03, 0x512a, 0xc1a0, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/2/0 */
    { 0x0b0b, 0x512a, 0xc1a0, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/2/2 */
    { 0x0b13, 0x512a, 0xc1a0, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/2/4 */
    { 0x0b1b, 0x512a, 0xc1a0, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/2/6 */
    { 0x0b23, 0x512a, 0x4120, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/2/8 */
    { 0x0b2b, 0x512a, 0x4120, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/2/10 */
    { 0x0b33, 0x512a, 0x4120, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/2/12 */
    { 0x0b3b, 0x512a, 0x4120, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/2/14 */
    { 0x0f03, 0x512a, 0xc1a0, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/3/0 */
    { 0x0f0b, 0x512a, 0xc1a0, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/3/2 */
    { 0x0f13, 0x512a, 0xc1a0, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/3/4 */
    { 0x0f1b, 0x512a, 0xc1a0, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/3/6 */
    { 0x0f23, 0x512a, 0x4120, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/3/8 */
    { 0x0f2b, 0x512a, 0x4120, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/3/10 */
    { 0x0f33, 0x512a, 0x4120, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/3/12 */
    { 0x0f3b, 0x512a, 0x4120, RTFLOAT80U_INIT_C(1,0x7260b69b,0), INT64_C(0) }, /* #88/3/14 */
    { 0x0201, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/0/0 */
    { 0x0209, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/0/2 */
    { 0x0211, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/0/4 */
    { 0x0219, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/0/6 */
    { 0x0221, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/0/8 */
    { 0x0229, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/0/10 */
    { 0x0231, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/0/12 */
    { 0x0239, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/0/14 */
    { 0x0601, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/1/0 */
    { 0x0609, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/1/2 */
    { 0x0611, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/1/4 */
    { 0x0619, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/1/6 */
    { 0x0621, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/1/8 */
    { 0x0629, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/1/10 */
    { 0x0631, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/1/12 */
    { 0x0639, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/1/14 */
    { 0x0a01, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/2/0 */
    { 0x0a09, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/2/2 */
    { 0x0a11, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/2/4 */
    { 0x0a19, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/2/6 */
    { 0x0a21, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/2/8 */
    { 0x0a29, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/2/10 */
    { 0x0a31, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/2/12 */
    { 0x0a39, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/2/14 */
    { 0x0e01, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/3/0 */
    { 0x0e09, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/3/2 */
    { 0x0e11, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/3/4 */
    { 0x0e19, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/3/6 */
    { 0x0e21, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/3/8 */
    { 0x0e29, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/3/10 */
    { 0x0e31, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/3/12 */
    { 0x0e39, 0x511d, 0x4100, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #89/3/14 */
    { 0x0107, 0xadde, 0x85a0, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/0/0 */
    { 0x010f, 0xadde, 0x85a0, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/0/2 */
    { 0x0117, 0xadde, 0x85a0, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/0/4 */
    { 0x011f, 0xadde, 0x85a0, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/0/6 */
    { 0x0127, 0xadde, 0x0520, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/0/8 */
    { 0x012f, 0xadde, 0x0520, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/0/10 */
    { 0x0137, 0xadde, 0x0520, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/0/12 */
    { 0x013f, 0xadde, 0x0520, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/0/14 */
    { 0x0507, 0xadde, 0x85a0, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/1/0 */
    { 0x050f, 0xadde, 0x85a0, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/1/2 */
    { 0x0517, 0xadde, 0x85a0, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/1/4 */
    { 0x051f, 0xadde, 0x85a0, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/1/6 */
    { 0x0527, 0xadde, 0x0520, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/1/8 */
    { 0x052f, 0xadde, 0x0520, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/1/10 */
    { 0x0537, 0xadde, 0x0520, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/1/12 */
    { 0x053f, 0xadde, 0x0520, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/1/14 */
    { 0x0907, 0xadde, 0x87a0, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(1) }, /* #90/2/0 */
    { 0x090f, 0xadde, 0x87a0, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(1) }, /* #90/2/2 */
    { 0x0917, 0xadde, 0x87a0, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(1) }, /* #90/2/4 */
    { 0x091f, 0xadde, 0x87a0, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(1) }, /* #90/2/6 */
    { 0x0927, 0xadde, 0x0720, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(1) }, /* #90/2/8 */
    { 0x092f, 0xadde, 0x0720, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(1) }, /* #90/2/10 */
    { 0x0937, 0xadde, 0x0720, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(1) }, /* #90/2/12 */
    { 0x093f, 0xadde, 0x0720, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(1) }, /* #90/2/14 */
    { 0x0d07, 0xadde, 0x85a0, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/3/0 */
    { 0x0d0f, 0xadde, 0x85a0, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/3/2 */
    { 0x0d17, 0xadde, 0x85a0, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/3/4 */
    { 0x0d1f, 0xadde, 0x85a0, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/3/6 */
    { 0x0d27, 0xadde, 0x0520, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/3/8 */
    { 0x0d2f, 0xadde, 0x0520, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/3/10 */
    { 0x0d37, 0xadde, 0x0520, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/3/12 */
    { 0x0d3f, 0xadde, 0x0520, RTFLOAT80U_INIT_C(0,0x80001721eb358ef0,0), INT64_C(0) }, /* #90/3/14 */
    { 0x0005, 0xd02a, 0xc0a0, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/0/0 */
    { 0x000d, 0xd02a, 0xc0a0, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/0/2 */
    { 0x0015, 0xd02a, 0xc0a0, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/0/4 */
    { 0x001d, 0xd02a, 0xc0a0, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/0/6 */
    { 0x0025, 0xd02a, 0x4020, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/0/8 */
    { 0x002d, 0xd02a, 0x4020, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/0/10 */
    { 0x0035, 0xd02a, 0x4020, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/0/12 */
    { 0x003d, 0xd02a, 0x4020, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/0/14 */
    { 0x0405, 0xd02a, 0xc0a0, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/1/0 */
    { 0x040d, 0xd02a, 0xc0a0, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/1/2 */
    { 0x0415, 0xd02a, 0xc0a0, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/1/4 */
    { 0x041d, 0xd02a, 0xc0a0, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/1/6 */
    { 0x0425, 0xd02a, 0x4020, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/1/8 */
    { 0x042d, 0xd02a, 0x4020, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/1/10 */
    { 0x0435, 0xd02a, 0x4020, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/1/12 */
    { 0x043d, 0xd02a, 0x4020, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/1/14 */
    { 0x0805, 0xd02a, 0xc2a0, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(1) }, /* #91/2/0 */
    { 0x080d, 0xd02a, 0xc2a0, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(1) }, /* #91/2/2 */
    { 0x0815, 0xd02a, 0xc2a0, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(1) }, /* #91/2/4 */
    { 0x081d, 0xd02a, 0xc2a0, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(1) }, /* #91/2/6 */
    { 0x0825, 0xd02a, 0x4220, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(1) }, /* #91/2/8 */
    { 0x082d, 0xd02a, 0x4220, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(1) }, /* #91/2/10 */
    { 0x0835, 0xd02a, 0x4220, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(1) }, /* #91/2/12 */
    { 0x083d, 0xd02a, 0x4220, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(1) }, /* #91/2/14 */
    { 0x0c05, 0xd02a, 0xc0a0, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/3/0 */
    { 0x0c0d, 0xd02a, 0xc0a0, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/3/2 */
    { 0x0c15, 0xd02a, 0xc0a0, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/3/4 */
    { 0x0c1d, 0xd02a, 0xc0a0, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/3/6 */
    { 0x0c25, 0xd02a, 0x4020, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/3/8 */
    { 0x0c2d, 0xd02a, 0x4020, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/3/10 */
    { 0x0c35, 0xd02a, 0x4020, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/3/12 */
    { 0x0c3d, 0xd02a, 0x4020, RTFLOAT80U_INIT_C(0,0x5ac84c459a534c50,0), INT64_C(0) }, /* #91/3/14 */
    { 0x0107, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/0/0 */
    { 0x010f, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/0/2 */
    { 0x0117, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/0/4 */
    { 0x011f, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/0/6 */
    { 0x0127, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/0/8 */
    { 0x012f, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/0/10 */
    { 0x0137, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/0/12 */
    { 0x013f, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/0/14 */
    { 0x0507, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/1/0 */
    { 0x050f, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/1/2 */
    { 0x0517, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/1/4 */
    { 0x051f, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/1/6 */
    { 0x0527, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/1/8 */
    { 0x052f, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/1/10 */
    { 0x0537, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/1/12 */
    { 0x053f, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/1/14 */
    { 0x0907, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/2/0 */
    { 0x090f, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/2/2 */
    { 0x0917, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/2/4 */
    { 0x091f, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/2/6 */
    { 0x0927, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/2/8 */
    { 0x092f, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/2/10 */
    { 0x0937, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/2/12 */
    { 0x093f, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/2/14 */
    { 0x0d07, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/3/0 */
    { 0x0d0f, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/3/2 */
    { 0x0d17, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/3/4 */
    { 0x0d1f, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/3/6 */
    { 0x0d27, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/3/8 */
    { 0x0d2f, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/3/10 */
    { 0x0d37, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/3/12 */
    { 0x0d3f, 0x143c, 0x0401, RTFLOAT80U_INIT_C(1,0x7b5a67fd9c0cd293,526), INT64_MIN }, /* #92/3/14 */
    { 0x0206, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/0/0 */
    { 0x020e, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/0/2 */
    { 0x0216, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/0/4 */
    { 0x021e, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/0/6 */
    { 0x0226, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/0/8 */
    { 0x022e, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/0/10 */
    { 0x0236, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/0/12 */
    { 0x023e, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/0/14 */
    { 0x0606, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/1/0 */
    { 0x060e, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/1/2 */
    { 0x0616, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/1/4 */
    { 0x061e, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/1/6 */
    { 0x0626, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/1/8 */
    { 0x062e, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/1/10 */
    { 0x0636, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/1/12 */
    { 0x063e, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/1/14 */
    { 0x0a06, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/2/0 */
    { 0x0a0e, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/2/2 */
    { 0x0a16, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/2/4 */
    { 0x0a1e, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/2/6 */
    { 0x0a26, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/2/8 */
    { 0x0a2e, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/2/10 */
    { 0x0a36, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/2/12 */
    { 0x0a3e, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/2/14 */
    { 0x0e06, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/3/0 */
    { 0x0e0e, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/3/2 */
    { 0x0e16, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/3/4 */
    { 0x0e1e, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/3/6 */
    { 0x0e26, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/3/8 */
    { 0x0e2e, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/3/10 */
    { 0x0e36, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/3/12 */
    { 0x0e3e, 0x7e19, 0x4400, RTFLOAT80U_INIT_C(1,0x0,0), INT64_C(0) }, /* #93/3/14 */
    { 0x0006, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/0/0 */
    { 0x000e, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/0/2 */
    { 0x0016, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/0/4 */
    { 0x001e, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/0/6 */
    { 0x0026, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/0/8 */
    { 0x002e, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/0/10 */
    { 0x0036, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/0/12 */
    { 0x003e, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/0/14 */
    { 0x0406, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/1/0 */
    { 0x040e, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/1/2 */
    { 0x0416, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/1/4 */
    { 0x041e, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/1/6 */
    { 0x0426, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/1/8 */
    { 0x042e, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/1/10 */
    { 0x0436, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/1/12 */
    { 0x043e, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/1/14 */
    { 0x0806, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/2/0 */
    { 0x080e, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/2/2 */
    { 0x0816, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/2/4 */
    { 0x081e, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/2/6 */
    { 0x0826, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/2/8 */
    { 0x082e, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/2/10 */
    { 0x0836, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/2/12 */
    { 0x083e, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/2/14 */
    { 0x0c06, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/3/0 */
    { 0x0c0e, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/3/2 */
    { 0x0c16, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/3/4 */
    { 0x0c1e, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/3/6 */
    { 0x0c26, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/3/8 */
    { 0x0c2e, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/3/10 */
    { 0x0c36, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/3/12 */
    { 0x0c3e, 0x0837, 0x0000, RTFLOAT80U_INIT_C(0,0xde5ecc9cd3e77d14,16445), INT64_C(8011734749086465674) }, /* #94/3/14 */
    { 0x0246, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/0/0 */
    { 0x024e, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/0/2 */
    { 0x0256, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/0/4 */
    { 0x025e, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/0/6 */
    { 0x0266, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/0/8 */
    { 0x026e, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/0/10 */
    { 0x0276, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/0/12 */
    { 0x027e, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/0/14 */
    { 0x0646, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/1/0 */
    { 0x064e, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/1/2 */
    { 0x0656, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/1/4 */
    { 0x065e, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/1/6 */
    { 0x0666, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/1/8 */
    { 0x066e, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/1/10 */
    { 0x0676, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/1/12 */
    { 0x067e, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/1/14 */
    { 0x0a46, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/2/0 */
    { 0x0a4e, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/2/2 */
    { 0x0a56, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/2/4 */
    { 0x0a5e, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/2/6 */
    { 0x0a66, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/2/8 */
    { 0x0a6e, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/2/10 */
    { 0x0a76, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/2/12 */
    { 0x0a7e, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/2/14 */
    { 0x0e46, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/3/0 */
    { 0x0e4e, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/3/2 */
    { 0x0e56, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/3/4 */
    { 0x0e5e, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/3/6 */
    { 0x0e66, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/3/8 */
    { 0x0e6e, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/3/10 */
    { 0x0e76, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/3/12 */
    { 0x0e7e, 0x49f3, 0x4100, RTFLOAT80U_INIT_C(0,0x0,0), INT64_C(0) }, /* #95/3/14 */
    { 0x0141, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/0/0 */
    { 0x0149, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/0/2 */
    { 0x0151, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/0/4 */
    { 0x0159, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/0/6 */
    { 0x0161, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/0/8 */
    { 0x0169, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/0/10 */
    { 0x0171, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/0/12 */
    { 0x0179, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/0/14 */
    { 0x0541, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/1/0 */
    { 0x0549, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/1/2 */
    { 0x0551, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/1/4 */
    { 0x0559, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/1/6 */
    { 0x0561, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/1/8 */
    { 0x0569, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/1/10 */
    { 0x0571, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/1/12 */
    { 0x0579, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/1/14 */
    { 0x0941, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/2/0 */
    { 0x0949, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/2/2 */
    { 0x0951, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/2/4 */
    { 0x0959, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/2/6 */
    { 0x0961, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/2/8 */
    { 0x0969, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/2/10 */
    { 0x0971, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/2/12 */
    { 0x0979, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/2/14 */
    { 0x0d41, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/3/0 */
    { 0x0d49, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/3/2 */
    { 0x0d51, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/3/4 */
    { 0x0d59, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/3/6 */
    { 0x0d61, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/3/8 */
    { 0x0d69, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/3/10 */
    { 0x0d71, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/3/12 */
    { 0x0d79, 0xe2af, 0x4000, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/3/14 */
    { 0x0205, 0xf69d, 0xc6a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387904) }, /* #97/0/0 */
    { 0x020d, 0xf69d, 0xc6a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387904) }, /* #97/0/2 */
    { 0x0215, 0xf69d, 0xc6a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387904) }, /* #97/0/4 */
    { 0x021d, 0xf69d, 0xc6a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387904) }, /* #97/0/6 */
    { 0x0225, 0xf69d, 0x4620, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387904) }, /* #97/0/8 */
    { 0x022d, 0xf69d, 0x4620, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387904) }, /* #97/0/10 */
    { 0x0235, 0xf69d, 0x4620, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387904) }, /* #97/0/12 */
    { 0x023d, 0xf69d, 0x4620, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387904) }, /* #97/0/14 */
    { 0x0605, 0xf69d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/1/0 */
    { 0x060d, 0xf69d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/1/2 */
    { 0x0615, 0xf69d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/1/4 */
    { 0x061d, 0xf69d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/1/6 */
    { 0x0625, 0xf69d, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/1/8 */
    { 0x062d, 0xf69d, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/1/10 */
    { 0x0635, 0xf69d, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/1/12 */
    { 0x063d, 0xf69d, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/1/14 */
    { 0x0a05, 0xf69d, 0xc6a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387904) }, /* #97/2/0 */
    { 0x0a0d, 0xf69d, 0xc6a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387904) }, /* #97/2/2 */
    { 0x0a15, 0xf69d, 0xc6a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387904) }, /* #97/2/4 */
    { 0x0a1d, 0xf69d, 0xc6a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387904) }, /* #97/2/6 */
    { 0x0a25, 0xf69d, 0x4620, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387904) }, /* #97/2/8 */
    { 0x0a2d, 0xf69d, 0x4620, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387904) }, /* #97/2/10 */
    { 0x0a35, 0xf69d, 0x4620, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387904) }, /* #97/2/12 */
    { 0x0a3d, 0xf69d, 0x4620, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387904) }, /* #97/2/14 */
    { 0x0e05, 0xf69d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/3/0 */
    { 0x0e0d, 0xf69d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/3/2 */
    { 0x0e15, 0xf69d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/3/4 */
    { 0x0e1d, 0xf69d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/3/6 */
    { 0x0e25, 0xf69d, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/3/8 */
    { 0x0e2d, 0xf69d, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/3/10 */
    { 0x0e35, 0xf69d, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/3/12 */
    { 0x0e3d, 0xf69d, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/3/14 */
    { 0x0344, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/0/0 */
    { 0x034c, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/0/2 */
    { 0x0354, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/0/4 */
    { 0x035c, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/0/6 */
    { 0x0364, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/0/8 */
    { 0x036c, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/0/10 */
    { 0x0374, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/0/12 */
    { 0x037c, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/0/14 */
    { 0x0744, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/1/0 */
    { 0x074c, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/1/2 */
    { 0x0754, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/1/4 */
    { 0x075c, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/1/6 */
    { 0x0764, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/1/8 */
    { 0x076c, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/1/10 */
    { 0x0774, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/1/12 */
    { 0x077c, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/1/14 */
    { 0x0b44, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/2/0 */
    { 0x0b4c, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/2/2 */
    { 0x0b54, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/2/4 */
    { 0x0b5c, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/2/6 */
    { 0x0b64, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/2/8 */
    { 0x0b6c, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/2/10 */
    { 0x0b74, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/2/12 */
    { 0x0b7c, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/2/14 */
    { 0x0f44, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/3/0 */
    { 0x0f4c, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/3/2 */
    { 0x0f54, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/3/4 */
    { 0x0f5c, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/3/6 */
    { 0x0f64, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/3/8 */
    { 0x0f6c, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/3/10 */
    { 0x0f74, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/3/12 */
    { 0x0f7c, 0x19f3, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/3/14 */
    { 0x0203, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/0/0 */
    { 0x020b, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/0/2 */
    { 0x0213, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/0/4 */
    { 0x021b, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/0/6 */
    { 0x0223, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/0/8 */
    { 0x022b, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/0/10 */
    { 0x0233, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/0/12 */
    { 0x023b, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/0/14 */
    { 0x0603, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/1/0 */
    { 0x060b, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/1/2 */
    { 0x0613, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/1/4 */
    { 0x061b, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/1/6 */
    { 0x0623, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/1/8 */
    { 0x062b, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/1/10 */
    { 0x0633, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/1/12 */
    { 0x063b, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/1/14 */
    { 0x0a03, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/2/0 */
    { 0x0a0b, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/2/2 */
    { 0x0a13, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/2/4 */
    { 0x0a1b, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/2/6 */
    { 0x0a23, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/2/8 */
    { 0x0a2b, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/2/10 */
    { 0x0a33, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/2/12 */
    { 0x0a3b, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/2/14 */
    { 0x0e03, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/3/0 */
    { 0x0e0b, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/3/2 */
    { 0x0e13, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/3/4 */
    { 0x0e1b, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/3/6 */
    { 0x0e23, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/3/8 */
    { 0x0e2b, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/3/10 */
    { 0x0e33, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/3/12 */
    { 0x0e3b, 0x4f2f, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/3/14 */
    { 0x0040, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/0/0 */
    { 0x0048, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/0/2 */
    { 0x0050, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/0/4 */
    { 0x0058, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/0/6 */
    { 0x0060, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/0/8 */
    { 0x0068, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/0/10 */
    { 0x0070, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/0/12 */
    { 0x0078, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/0/14 */
    { 0x0440, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/1/0 */
    { 0x0448, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/1/2 */
    { 0x0450, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/1/4 */
    { 0x0458, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/1/6 */
    { 0x0460, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/1/8 */
    { 0x0468, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/1/10 */
    { 0x0470, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/1/12 */
    { 0x0478, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/1/14 */
    { 0x0840, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/2/0 */
    { 0x0848, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/2/2 */
    { 0x0850, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/2/4 */
    { 0x0858, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/2/6 */
    { 0x0860, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/2/8 */
    { 0x0868, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/2/10 */
    { 0x0870, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/2/12 */
    { 0x0878, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/2/14 */
    { 0x0c40, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/3/0 */
    { 0x0c48, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/3/2 */
    { 0x0c50, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/3/4 */
    { 0x0c58, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/3/6 */
    { 0x0c60, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/3/8 */
    { 0x0c68, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/3/10 */
    { 0x0c70, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/3/12 */
    { 0x0c78, 0xb339, 0x0100, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/3/14 */
    { 0x0246, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/0/0 */
    { 0x024e, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/0/2 */
    { 0x0256, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/0/4 */
    { 0x025e, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/0/6 */
    { 0x0266, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/0/8 */
    { 0x026e, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/0/10 */
    { 0x0276, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/0/12 */
    { 0x027e, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/0/14 */
    { 0x0646, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/1/0 */
    { 0x064e, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/1/2 */
    { 0x0656, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/1/4 */
    { 0x065e, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/1/6 */
    { 0x0666, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/1/8 */
    { 0x066e, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/1/10 */
    { 0x0676, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/1/12 */
    { 0x067e, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/1/14 */
    { 0x0a46, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/2/0 */
    { 0x0a4e, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/2/2 */
    { 0x0a56, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/2/4 */
    { 0x0a5e, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/2/6 */
    { 0x0a66, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/2/8 */
    { 0x0a6e, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/2/10 */
    { 0x0a76, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/2/12 */
    { 0x0a7e, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/2/14 */
    { 0x0e46, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/3/0 */
    { 0x0e4e, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/3/2 */
    { 0x0e56, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/3/4 */
    { 0x0e5e, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/3/6 */
    { 0x0e66, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/3/8 */
    { 0x0e6e, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/3/10 */
    { 0x0e76, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/3/12 */
    { 0x0e7e, 0xd4a8, 0x4400, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/3/14 */
    { 0x0045, 0x14d6, 0x0401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #102/0/0 */
    { 0x004d, 0x14d6, 0x0401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #102/0/2 */
    { 0x0055, 0x14d6, 0x0401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #102/0/4 */
    { 0x005d, 0x14d6, 0x0401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #102/0/6 */
    { 0x0065, 0x14d6, 0x0401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #102/0/8 */
    { 0x006d, 0x14d6, 0x0401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #102/0/10 */
    { 0x0075, 0x14d6, 0x0401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #102/0/12 */
    { 0x007d, 0x14d6, 0x0401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #102/0/14 */
    { 0x0445, 0x14d6, 0x84a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/1/0 */
    { 0x044d, 0x14d6, 0x84a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/1/2 */
    { 0x0455, 0x14d6, 0x84a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/1/4 */
    { 0x045d, 0x14d6, 0x84a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/1/6 */
    { 0x0465, 0x14d6, 0x0420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/1/8 */
    { 0x046d, 0x14d6, 0x0420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/1/10 */
    { 0x0475, 0x14d6, 0x0420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/1/12 */
    { 0x047d, 0x14d6, 0x0420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/1/14 */
    { 0x0845, 0x14d6, 0x0401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #102/2/0 */
    { 0x084d, 0x14d6, 0x0401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #102/2/2 */
    { 0x0855, 0x14d6, 0x0401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #102/2/4 */
    { 0x085d, 0x14d6, 0x0401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #102/2/6 */
    { 0x0865, 0x14d6, 0x0401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #102/2/8 */
    { 0x086d, 0x14d6, 0x0401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #102/2/10 */
    { 0x0875, 0x14d6, 0x0401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #102/2/12 */
    { 0x087d, 0x14d6, 0x0401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MIN }, /* #102/2/14 */
    { 0x0c45, 0x14d6, 0x84a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/3/0 */
    { 0x0c4d, 0x14d6, 0x84a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/3/2 */
    { 0x0c55, 0x14d6, 0x84a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/3/4 */
    { 0x0c5d, 0x14d6, 0x84a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/3/6 */
    { 0x0c65, 0x14d6, 0x0420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/3/8 */
    { 0x0c6d, 0x14d6, 0x0420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/3/10 */
    { 0x0c75, 0x14d6, 0x0420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/3/12 */
    { 0x0c7d, 0x14d6, 0x0420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/3/14 */
    { 0x0347, 0x2c4b, 0x86a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #103/0/0 */
    { 0x034f, 0x2c4b, 0x86a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #103/0/2 */
    { 0x0357, 0x2c4b, 0x86a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #103/0/4 */
    { 0x035f, 0x2c4b, 0x86a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #103/0/6 */
    { 0x0367, 0x2c4b, 0x0620, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #103/0/8 */
    { 0x036f, 0x2c4b, 0x0620, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #103/0/10 */
    { 0x0377, 0x2c4b, 0x0620, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #103/0/12 */
    { 0x037f, 0x2c4b, 0x0620, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #103/0/14 */
    { 0x0747, 0x2c4b, 0x86a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #103/1/0 */
    { 0x074f, 0x2c4b, 0x86a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #103/1/2 */
    { 0x0757, 0x2c4b, 0x86a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #103/1/4 */
    { 0x075f, 0x2c4b, 0x86a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #103/1/6 */
    { 0x0767, 0x2c4b, 0x0620, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #103/1/8 */
    { 0x076f, 0x2c4b, 0x0620, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #103/1/10 */
    { 0x0777, 0x2c4b, 0x0620, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #103/1/12 */
    { 0x077f, 0x2c4b, 0x0620, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_MIN }, /* #103/1/14 */
    { 0x0b47, 0x2c4b, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/2/0 */
    { 0x0b4f, 0x2c4b, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/2/2 */
    { 0x0b57, 0x2c4b, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/2/4 */
    { 0x0b5f, 0x2c4b, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/2/6 */
    { 0x0b67, 0x2c4b, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/2/8 */
    { 0x0b6f, 0x2c4b, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/2/10 */
    { 0x0b77, 0x2c4b, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/2/12 */
    { 0x0b7f, 0x2c4b, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/2/14 */
    { 0x0f47, 0x2c4b, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/3/0 */
    { 0x0f4f, 0x2c4b, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/3/2 */
    { 0x0f57, 0x2c4b, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/3/4 */
    { 0x0f5f, 0x2c4b, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/3/6 */
    { 0x0f67, 0x2c4b, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/3/8 */
    { 0x0f6f, 0x2c4b, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/3/10 */
    { 0x0f77, 0x2c4b, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/3/12 */
    { 0x0f7f, 0x2c4b, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/3/14 */
    { 0x0300, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/0/0 */
    { 0x0308, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/0/2 */
    { 0x0310, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/0/4 */
    { 0x0318, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/0/6 */
    { 0x0320, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/0/8 */
    { 0x0328, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/0/10 */
    { 0x0330, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/0/12 */
    { 0x0338, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/0/14 */
    { 0x0700, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/1/0 */
    { 0x0708, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/1/2 */
    { 0x0710, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/1/4 */
    { 0x0718, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/1/6 */
    { 0x0720, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/1/8 */
    { 0x0728, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/1/10 */
    { 0x0730, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/1/12 */
    { 0x0738, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/1/14 */
    { 0x0b00, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/2/0 */
    { 0x0b08, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/2/2 */
    { 0x0b10, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/2/4 */
    { 0x0b18, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/2/6 */
    { 0x0b20, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/2/8 */
    { 0x0b28, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/2/10 */
    { 0x0b30, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/2/12 */
    { 0x0b38, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/2/14 */
    { 0x0f00, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/3/0 */
    { 0x0f08, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/3/2 */
    { 0x0f10, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/3/4 */
    { 0x0f18, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/3/6 */
    { 0x0f20, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/3/8 */
    { 0x0f28, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/3/10 */
    { 0x0f30, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/3/12 */
    { 0x0f38, 0x2230, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/3/14 */
    { 0x0007, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/0/0 */
    { 0x000f, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/0/2 */
    { 0x0017, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/0/4 */
    { 0x001f, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/0/6 */
    { 0x0027, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/0/8 */
    { 0x002f, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/0/10 */
    { 0x0037, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/0/12 */
    { 0x003f, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/0/14 */
    { 0x0407, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/1/0 */
    { 0x040f, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/1/2 */
    { 0x0417, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/1/4 */
    { 0x041f, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/1/6 */
    { 0x0427, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/1/8 */
    { 0x042f, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/1/10 */
    { 0x0437, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/1/12 */
    { 0x043f, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/1/14 */
    { 0x0807, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/2/0 */
    { 0x080f, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/2/2 */
    { 0x0817, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/2/4 */
    { 0x081f, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/2/6 */
    { 0x0827, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/2/8 */
    { 0x082f, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/2/10 */
    { 0x0837, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/2/12 */
    { 0x083f, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/2/14 */
    { 0x0c07, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/3/0 */
    { 0x0c0f, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/3/2 */
    { 0x0c17, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/3/4 */
    { 0x0c1f, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/3/6 */
    { 0x0c27, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/3/8 */
    { 0x0c2f, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/3/10 */
    { 0x0c37, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/3/12 */
    { 0x0c3f, 0x5159, 0x4100, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/3/14 */
    { 0x0000, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/0/0 */
    { 0x0008, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/0/2 */
    { 0x0010, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/0/4 */
    { 0x0018, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/0/6 */
    { 0x0020, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/0/8 */
    { 0x0028, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/0/10 */
    { 0x0030, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/0/12 */
    { 0x0038, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/0/14 */
    { 0x0400, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/1/0 */
    { 0x0408, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/1/2 */
    { 0x0410, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/1/4 */
    { 0x0418, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/1/6 */
    { 0x0420, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/1/8 */
    { 0x0428, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/1/10 */
    { 0x0430, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/1/12 */
    { 0x0438, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/1/14 */
    { 0x0800, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/2/0 */
    { 0x0808, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/2/2 */
    { 0x0810, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/2/4 */
    { 0x0818, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/2/6 */
    { 0x0820, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/2/8 */
    { 0x0828, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/2/10 */
    { 0x0830, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/2/12 */
    { 0x0838, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/2/14 */
    { 0x0c00, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/3/0 */
    { 0x0c08, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/3/2 */
    { 0x0c10, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/3/4 */
    { 0x0c18, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/3/6 */
    { 0x0c20, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/3/8 */
    { 0x0c28, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/3/10 */
    { 0x0c30, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/3/12 */
    { 0x0c38, 0x4a3c, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/3/14 */
    { 0x0004, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/0/0 */
    { 0x000c, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/0/2 */
    { 0x0014, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/0/4 */
    { 0x001c, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/0/6 */
    { 0x0024, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/0/8 */
    { 0x002c, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/0/10 */
    { 0x0034, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/0/12 */
    { 0x003c, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/0/14 */
    { 0x0404, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/1/0 */
    { 0x040c, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/1/2 */
    { 0x0414, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/1/4 */
    { 0x041c, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/1/6 */
    { 0x0424, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/1/8 */
    { 0x042c, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/1/10 */
    { 0x0434, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/1/12 */
    { 0x043c, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/1/14 */
    { 0x0804, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/2/0 */
    { 0x080c, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/2/2 */
    { 0x0814, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/2/4 */
    { 0x081c, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/2/6 */
    { 0x0824, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/2/8 */
    { 0x082c, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/2/10 */
    { 0x0834, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/2/12 */
    { 0x083c, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/2/14 */
    { 0x0c04, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/3/0 */
    { 0x0c0c, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/3/2 */
    { 0x0c14, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/3/4 */
    { 0x0c1c, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/3/6 */
    { 0x0c24, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/3/8 */
    { 0x0c2c, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/3/10 */
    { 0x0c34, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/3/12 */
    { 0x0c3c, 0x065d, 0x0400, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/3/14 */
    { 0x0040, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/0/0 */
    { 0x0048, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/0/2 */
    { 0x0050, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/0/4 */
    { 0x0058, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/0/6 */
    { 0x0060, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/0/8 */
    { 0x0068, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/0/10 */
    { 0x0070, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/0/12 */
    { 0x0078, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/0/14 */
    { 0x0440, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/1/0 */
    { 0x0448, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/1/2 */
    { 0x0450, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/1/4 */
    { 0x0458, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/1/6 */
    { 0x0460, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/1/8 */
    { 0x0468, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/1/10 */
    { 0x0470, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/1/12 */
    { 0x0478, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/1/14 */
    { 0x0840, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/2/0 */
    { 0x0848, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/2/2 */
    { 0x0850, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/2/4 */
    { 0x0858, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/2/6 */
    { 0x0860, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/2/8 */
    { 0x0868, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/2/10 */
    { 0x0870, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/2/12 */
    { 0x0878, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/2/14 */
    { 0x0c40, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/3/0 */
    { 0x0c48, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/3/2 */
    { 0x0c50, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/3/4 */
    { 0x0c58, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/3/6 */
    { 0x0c60, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/3/8 */
    { 0x0c68, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/3/10 */
    { 0x0c70, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/3/12 */
    { 0x0c78, 0x53d4, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/3/14 */
    { 0x0040, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/0/0 */
    { 0x0048, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/0/2 */
    { 0x0050, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/0/4 */
    { 0x0058, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/0/6 */
    { 0x0060, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/0/8 */
    { 0x0068, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/0/10 */
    { 0x0070, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/0/12 */
    { 0x0078, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/0/14 */
    { 0x0440, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/1/0 */
    { 0x0448, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/1/2 */
    { 0x0450, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/1/4 */
    { 0x0458, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/1/6 */
    { 0x0460, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/1/8 */
    { 0x0468, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/1/10 */
    { 0x0470, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/1/12 */
    { 0x0478, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/1/14 */
    { 0x0840, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/2/0 */
    { 0x0848, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/2/2 */
    { 0x0850, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/2/4 */
    { 0x0858, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/2/6 */
    { 0x0860, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/2/8 */
    { 0x0868, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/2/10 */
    { 0x0870, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/2/12 */
    { 0x0878, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/2/14 */
    { 0x0c40, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/3/0 */
    { 0x0c48, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/3/2 */
    { 0x0c50, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/3/4 */
    { 0x0c58, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/3/6 */
    { 0x0c60, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/3/8 */
    { 0x0c68, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/3/10 */
    { 0x0c70, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/3/12 */
    { 0x0c78, 0xea29, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/3/14 */
    { 0x0141, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/0/0 */
    { 0x0149, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/0/2 */
    { 0x0151, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/0/4 */
    { 0x0159, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/0/6 */
    { 0x0161, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/0/8 */
    { 0x0169, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/0/10 */
    { 0x0171, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/0/12 */
    { 0x0179, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/0/14 */
    { 0x0541, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/1/0 */
    { 0x0549, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/1/2 */
    { 0x0551, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/1/4 */
    { 0x0559, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/1/6 */
    { 0x0561, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/1/8 */
    { 0x0569, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/1/10 */
    { 0x0571, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/1/12 */
    { 0x0579, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/1/14 */
    { 0x0941, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/2/0 */
    { 0x0949, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/2/2 */
    { 0x0951, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/2/4 */
    { 0x0959, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/2/6 */
    { 0x0961, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/2/8 */
    { 0x0969, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/2/10 */
    { 0x0971, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/2/12 */
    { 0x0979, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/2/14 */
    { 0x0d41, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/3/0 */
    { 0x0d49, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/3/2 */
    { 0x0d51, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/3/4 */
    { 0x0d59, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/3/6 */
    { 0x0d61, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/3/8 */
    { 0x0d69, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/3/10 */
    { 0x0d71, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/3/12 */
    { 0x0d79, 0xa557, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/3/14 */
    { 0x0041, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/0/0 */
    { 0x0049, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/0/2 */
    { 0x0051, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/0/4 */
    { 0x0059, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/0/6 */
    { 0x0061, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/0/8 */
    { 0x0069, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/0/10 */
    { 0x0071, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/0/12 */
    { 0x0079, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/0/14 */
    { 0x0441, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/1/0 */
    { 0x0449, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/1/2 */
    { 0x0451, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/1/4 */
    { 0x0459, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/1/6 */
    { 0x0461, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/1/8 */
    { 0x0469, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/1/10 */
    { 0x0471, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/1/12 */
    { 0x0479, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/1/14 */
    { 0x0841, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/2/0 */
    { 0x0849, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/2/2 */
    { 0x0851, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/2/4 */
    { 0x0859, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/2/6 */
    { 0x0861, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/2/8 */
    { 0x0869, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/2/10 */
    { 0x0871, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/2/12 */
    { 0x0879, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/2/14 */
    { 0x0c41, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/3/0 */
    { 0x0c49, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/3/2 */
    { 0x0c51, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/3/4 */
    { 0x0c59, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/3/6 */
    { 0x0c61, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/3/8 */
    { 0x0c69, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/3/10 */
    { 0x0c71, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/3/12 */
    { 0x0c79, 0x6a62, 0x4001, RTFLOAT80U_INIT_C(1,0x8000000000000002,16446), INT64_MIN }, /* #111/3/14 */
    { 0x0307, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/0/0 */
    { 0x030f, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/0/2 */
    { 0x0317, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/0/4 */
    { 0x031f, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/0/6 */
    { 0x0327, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/0/8 */
    { 0x032f, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/0/10 */
    { 0x0337, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/0/12 */
    { 0x033f, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/0/14 */
    { 0x0707, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/1/0 */
    { 0x070f, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/1/2 */
    { 0x0717, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/1/4 */
    { 0x071f, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/1/6 */
    { 0x0727, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/1/8 */
    { 0x072f, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/1/10 */
    { 0x0737, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/1/12 */
    { 0x073f, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/1/14 */
    { 0x0b07, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/2/0 */
    { 0x0b0f, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/2/2 */
    { 0x0b17, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/2/4 */
    { 0x0b1f, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/2/6 */
    { 0x0b27, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/2/8 */
    { 0x0b2f, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/2/10 */
    { 0x0b37, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/2/12 */
    { 0x0b3f, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/2/14 */
    { 0x0f07, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/3/0 */
    { 0x0f0f, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/3/2 */
    { 0x0f17, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/3/4 */
    { 0x0f1f, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/3/6 */
    { 0x0f27, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/3/8 */
    { 0x0f2f, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/3/10 */
    { 0x0f37, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/3/12 */
    { 0x0f3f, 0x3090, 0x0001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16446), INT64_MIN }, /* #112/3/14 */
};
uint32_t const g_cTests_fist_r80_to_i64 = RT_ELEMENTS(g_aTests_fist_r80_to_i64);

FPU_ST_I64_TEST_T const g_aTests_fistt_r80_to_i64[] =
{
    { 0x0240, 0x468f, 0xc4a0, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/0/0 */
    { 0x0248, 0x468f, 0xc4a0, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/0/2 */
    { 0x0250, 0x468f, 0xc4a0, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/0/4 */
    { 0x0258, 0x468f, 0xc4a0, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/0/6 */
    { 0x0260, 0x468f, 0x4420, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/0/8 */
    { 0x0268, 0x468f, 0x4420, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/0/10 */
    { 0x0270, 0x468f, 0x4420, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/0/12 */
    { 0x0278, 0x468f, 0x4420, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/0/14 */
    { 0x0640, 0x468f, 0xc4a0, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/1/0 */
    { 0x0648, 0x468f, 0xc4a0, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/1/2 */
    { 0x0650, 0x468f, 0xc4a0, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/1/4 */
    { 0x0658, 0x468f, 0xc4a0, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/1/6 */
    { 0x0660, 0x468f, 0x4420, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/1/8 */
    { 0x0668, 0x468f, 0x4420, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/1/10 */
    { 0x0670, 0x468f, 0x4420, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/1/12 */
    { 0x0678, 0x468f, 0x4420, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/1/14 */
    { 0x0a40, 0x468f, 0xc4a0, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/2/0 */
    { 0x0a48, 0x468f, 0xc4a0, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/2/2 */
    { 0x0a50, 0x468f, 0xc4a0, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/2/4 */
    { 0x0a58, 0x468f, 0xc4a0, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/2/6 */
    { 0x0a60, 0x468f, 0x4420, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/2/8 */
    { 0x0a68, 0x468f, 0x4420, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/2/10 */
    { 0x0a70, 0x468f, 0x4420, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/2/12 */
    { 0x0a78, 0x468f, 0x4420, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/2/14 */
    { 0x0e40, 0x468f, 0xc4a0, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/3/0 */
    { 0x0e48, 0x468f, 0xc4a0, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/3/2 */
    { 0x0e50, 0x468f, 0xc4a0, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/3/4 */
    { 0x0e58, 0x468f, 0xc4a0, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/3/6 */
    { 0x0e60, 0x468f, 0x4420, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/3/8 */
    { 0x0e68, 0x468f, 0x4420, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/3/10 */
    { 0x0e70, 0x468f, 0x4420, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/3/12 */
    { 0x0e78, 0x468f, 0x4420, RTFLOAT80U_INIT_C(0,0x871e51ac2401c7bb,16383), INT64_C(1) }, /* #0/3/14 */
    { 0x0042, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/0/0 */
    { 0x004a, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/0/2 */
    { 0x0052, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/0/4 */
    { 0x005a, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/0/6 */
    { 0x0062, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/0/8 */
    { 0x006a, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/0/10 */
    { 0x0072, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/0/12 */
    { 0x007a, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/0/14 */
    { 0x0442, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/1/0 */
    { 0x044a, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/1/2 */
    { 0x0452, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/1/4 */
    { 0x045a, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/1/6 */
    { 0x0462, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/1/8 */
    { 0x046a, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/1/10 */
    { 0x0472, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/1/12 */
    { 0x047a, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/1/14 */
    { 0x0842, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/2/0 */
    { 0x084a, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/2/2 */
    { 0x0852, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/2/4 */
    { 0x085a, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/2/6 */
    { 0x0862, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/2/8 */
    { 0x086a, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/2/10 */
    { 0x0872, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/2/12 */
    { 0x087a, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/2/14 */
    { 0x0c42, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/3/0 */
    { 0x0c4a, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/3/2 */
    { 0x0c52, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/3/4 */
    { 0x0c5a, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/3/6 */
    { 0x0c62, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/3/8 */
    { 0x0c6a, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/3/10 */
    { 0x0c72, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/3/12 */
    { 0x0c7a, 0x7b70, 0xf981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #1/3/14 */
    { 0x0100, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/0/0 */
    { 0x0108, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/0/2 */
    { 0x0110, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/0/4 */
    { 0x0118, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/0/6 */
    { 0x0120, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/0/8 */
    { 0x0128, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/0/10 */
    { 0x0130, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/0/12 */
    { 0x0138, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/0/14 */
    { 0x0500, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/1/0 */
    { 0x0508, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/1/2 */
    { 0x0510, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/1/4 */
    { 0x0518, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/1/6 */
    { 0x0520, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/1/8 */
    { 0x0528, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/1/10 */
    { 0x0530, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/1/12 */
    { 0x0538, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/1/14 */
    { 0x0900, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/2/0 */
    { 0x0908, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/2/2 */
    { 0x0910, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/2/4 */
    { 0x0918, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/2/6 */
    { 0x0920, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/2/8 */
    { 0x0928, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/2/10 */
    { 0x0930, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/2/12 */
    { 0x0938, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/2/14 */
    { 0x0d00, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/3/0 */
    { 0x0d08, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/3/2 */
    { 0x0d10, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/3/4 */
    { 0x0d18, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/3/6 */
    { 0x0d20, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/3/8 */
    { 0x0d28, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/3/10 */
    { 0x0d30, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/3/12 */
    { 0x0d38, 0x07c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x12a4e7adafac69b9,1447), INT64_C(-3) }, /* #2/3/14 */
    { 0x0347, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/0/0 */
    { 0x034f, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/0/2 */
    { 0x0357, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/0/4 */
    { 0x035f, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/0/6 */
    { 0x0367, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/0/8 */
    { 0x036f, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/0/10 */
    { 0x0377, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/0/12 */
    { 0x037f, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/0/14 */
    { 0x0747, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/1/0 */
    { 0x074f, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/1/2 */
    { 0x0757, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/1/4 */
    { 0x075f, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/1/6 */
    { 0x0767, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/1/8 */
    { 0x076f, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/1/10 */
    { 0x0777, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/1/12 */
    { 0x077f, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/1/14 */
    { 0x0b47, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/2/0 */
    { 0x0b4f, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/2/2 */
    { 0x0b57, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/2/4 */
    { 0x0b5f, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/2/6 */
    { 0x0b67, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/2/8 */
    { 0x0b6f, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/2/10 */
    { 0x0b77, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/2/12 */
    { 0x0b7f, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/2/14 */
    { 0x0f47, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/3/0 */
    { 0x0f4f, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/3/2 */
    { 0x0f57, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/3/4 */
    { 0x0f5f, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/3/6 */
    { 0x0f67, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/3/8 */
    { 0x0f6f, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/3/10 */
    { 0x0f77, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/3/12 */
    { 0x0f7f, 0xbdc1, 0x0501, RTFLOAT80U_INIT_C(0,0x7b25fd371d6debf1,18954), INT64_MIN }, /* #3/3/14 */
    { 0x0241, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/0/0 */
    { 0x0249, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/0/2 */
    { 0x0251, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/0/4 */
    { 0x0259, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/0/6 */
    { 0x0261, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/0/8 */
    { 0x0269, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/0/10 */
    { 0x0271, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/0/12 */
    { 0x0279, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/0/14 */
    { 0x0641, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/1/0 */
    { 0x0649, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/1/2 */
    { 0x0651, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/1/4 */
    { 0x0659, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/1/6 */
    { 0x0661, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/1/8 */
    { 0x0669, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/1/10 */
    { 0x0671, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/1/12 */
    { 0x0679, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/1/14 */
    { 0x0a41, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/2/0 */
    { 0x0a49, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/2/2 */
    { 0x0a51, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/2/4 */
    { 0x0a59, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/2/6 */
    { 0x0a61, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/2/8 */
    { 0x0a69, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/2/10 */
    { 0x0a71, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/2/12 */
    { 0x0a79, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/2/14 */
    { 0x0e41, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/3/0 */
    { 0x0e49, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/3/2 */
    { 0x0e51, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/3/4 */
    { 0x0e59, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/3/6 */
    { 0x0e61, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/3/8 */
    { 0x0e69, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/3/10 */
    { 0x0e71, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/3/12 */
    { 0x0e79, 0x6696, 0x4401, RTFLOAT80U_INIT_C(1,0x1523,18085), INT64_MIN }, /* #4/3/14 */
    { 0x0146, 0x5f2d, 0xc5a0, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/0/0 */
    { 0x014e, 0x5f2d, 0xc5a0, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/0/2 */
    { 0x0156, 0x5f2d, 0xc5a0, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/0/4 */
    { 0x015e, 0x5f2d, 0xc5a0, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/0/6 */
    { 0x0166, 0x5f2d, 0x4520, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/0/8 */
    { 0x016e, 0x5f2d, 0x4520, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/0/10 */
    { 0x0176, 0x5f2d, 0x4520, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/0/12 */
    { 0x017e, 0x5f2d, 0x4520, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/0/14 */
    { 0x0546, 0x5f2d, 0xc5a0, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/1/0 */
    { 0x054e, 0x5f2d, 0xc5a0, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/1/2 */
    { 0x0556, 0x5f2d, 0xc5a0, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/1/4 */
    { 0x055e, 0x5f2d, 0xc5a0, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/1/6 */
    { 0x0566, 0x5f2d, 0x4520, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/1/8 */
    { 0x056e, 0x5f2d, 0x4520, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/1/10 */
    { 0x0576, 0x5f2d, 0x4520, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/1/12 */
    { 0x057e, 0x5f2d, 0x4520, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/1/14 */
    { 0x0946, 0x5f2d, 0xc5a0, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/2/0 */
    { 0x094e, 0x5f2d, 0xc5a0, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/2/2 */
    { 0x0956, 0x5f2d, 0xc5a0, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/2/4 */
    { 0x095e, 0x5f2d, 0xc5a0, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/2/6 */
    { 0x0966, 0x5f2d, 0x4520, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/2/8 */
    { 0x096e, 0x5f2d, 0x4520, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/2/10 */
    { 0x0976, 0x5f2d, 0x4520, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/2/12 */
    { 0x097e, 0x5f2d, 0x4520, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/2/14 */
    { 0x0d46, 0x5f2d, 0xc5a0, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/3/0 */
    { 0x0d4e, 0x5f2d, 0xc5a0, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/3/2 */
    { 0x0d56, 0x5f2d, 0xc5a0, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/3/4 */
    { 0x0d5e, 0x5f2d, 0xc5a0, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/3/6 */
    { 0x0d66, 0x5f2d, 0x4520, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/3/8 */
    { 0x0d6e, 0x5f2d, 0x4520, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/3/10 */
    { 0x0d76, 0x5f2d, 0x4520, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/3/12 */
    { 0x0d7e, 0x5f2d, 0x4520, RTFLOAT80U_INIT_C(1,0xd81e4f032c313022,16383), INT64_C(-1) }, /* #5/3/14 */
    { 0x0043, 0x511d, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/0/0 */
    { 0x004b, 0x511d, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/0/2 */
    { 0x0053, 0x511d, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/0/4 */
    { 0x005b, 0x511d, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/0/6 */
    { 0x0063, 0x511d, 0x4120, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/0/8 */
    { 0x006b, 0x511d, 0x4120, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/0/10 */
    { 0x0073, 0x511d, 0x4120, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/0/12 */
    { 0x007b, 0x511d, 0x4120, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/0/14 */
    { 0x0443, 0x511d, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/1/0 */
    { 0x044b, 0x511d, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/1/2 */
    { 0x0453, 0x511d, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/1/4 */
    { 0x045b, 0x511d, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/1/6 */
    { 0x0463, 0x511d, 0x4120, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/1/8 */
    { 0x046b, 0x511d, 0x4120, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/1/10 */
    { 0x0473, 0x511d, 0x4120, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/1/12 */
    { 0x047b, 0x511d, 0x4120, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/1/14 */
    { 0x0843, 0x511d, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/2/0 */
    { 0x084b, 0x511d, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/2/2 */
    { 0x0853, 0x511d, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/2/4 */
    { 0x085b, 0x511d, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/2/6 */
    { 0x0863, 0x511d, 0x4120, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/2/8 */
    { 0x086b, 0x511d, 0x4120, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/2/10 */
    { 0x0873, 0x511d, 0x4120, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/2/12 */
    { 0x087b, 0x511d, 0x4120, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/2/14 */
    { 0x0c43, 0x511d, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/3/0 */
    { 0x0c4b, 0x511d, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/3/2 */
    { 0x0c53, 0x511d, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/3/4 */
    { 0x0c5b, 0x511d, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/3/6 */
    { 0x0c63, 0x511d, 0x4120, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/3/8 */
    { 0x0c6b, 0x511d, 0x4120, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/3/10 */
    { 0x0c73, 0x511d, 0x4120, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/3/12 */
    { 0x0c7b, 0x511d, 0x4120, RTFLOAT80U_INIT_C(0,0xa961eab34cd7f933,16445), INT64_C(6102647260480011417) }, /* #6/3/14 */
    { 0x0303, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/0/0 */
    { 0x030b, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/0/2 */
    { 0x0313, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/0/4 */
    { 0x031b, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/0/6 */
    { 0x0323, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/0/8 */
    { 0x032b, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/0/10 */
    { 0x0333, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/0/12 */
    { 0x033b, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/0/14 */
    { 0x0703, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/1/0 */
    { 0x070b, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/1/2 */
    { 0x0713, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/1/4 */
    { 0x071b, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/1/6 */
    { 0x0723, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/1/8 */
    { 0x072b, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/1/10 */
    { 0x0733, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/1/12 */
    { 0x073b, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/1/14 */
    { 0x0b03, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/2/0 */
    { 0x0b0b, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/2/2 */
    { 0x0b13, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/2/4 */
    { 0x0b1b, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/2/6 */
    { 0x0b23, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/2/8 */
    { 0x0b2b, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/2/10 */
    { 0x0b33, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/2/12 */
    { 0x0b3b, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/2/14 */
    { 0x0f03, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/3/0 */
    { 0x0f0b, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/3/2 */
    { 0x0f13, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/3/4 */
    { 0x0f1b, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/3/6 */
    { 0x0f23, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/3/8 */
    { 0x0f2b, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/3/10 */
    { 0x0f33, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/3/12 */
    { 0x0f3b, 0x6253, 0x4000, RTFLOAT80U_INIT_C(0,0xa91a43357ce8ad6e,16445), INT64_C(6092562819406124727) }, /* #7/3/14 */
    { 0x0206, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/0/0 */
    { 0x020e, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/0/2 */
    { 0x0216, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/0/4 */
    { 0x021e, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/0/6 */
    { 0x0226, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/0/8 */
    { 0x022e, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/0/10 */
    { 0x0236, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/0/12 */
    { 0x023e, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/0/14 */
    { 0x0606, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/1/0 */
    { 0x060e, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/1/2 */
    { 0x0616, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/1/4 */
    { 0x061e, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/1/6 */
    { 0x0626, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/1/8 */
    { 0x062e, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/1/10 */
    { 0x0636, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/1/12 */
    { 0x063e, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/1/14 */
    { 0x0a06, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/2/0 */
    { 0x0a0e, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/2/2 */
    { 0x0a16, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/2/4 */
    { 0x0a1e, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/2/6 */
    { 0x0a26, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/2/8 */
    { 0x0a2e, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/2/10 */
    { 0x0a36, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/2/12 */
    { 0x0a3e, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/2/14 */
    { 0x0e06, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/3/0 */
    { 0x0e0e, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/3/2 */
    { 0x0e16, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/3/4 */
    { 0x0e1e, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/3/6 */
    { 0x0e26, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/3/8 */
    { 0x0e2e, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/3/10 */
    { 0x0e36, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/3/12 */
    { 0x0e3e, 0x3ab4, 0xb881, RTFLOAT80U_INIT_C(0,0x9aea1c18dfddc214,31514), INT64_C(-3) }, /* #8/3/14 */
    { 0x0301, 0xeca2, 0xc4a0, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/0/0 */
    { 0x0309, 0xeca2, 0xc4a0, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/0/2 */
    { 0x0311, 0xeca2, 0xc4a0, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/0/4 */
    { 0x0319, 0xeca2, 0xc4a0, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/0/6 */
    { 0x0321, 0xeca2, 0x4420, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/0/8 */
    { 0x0329, 0xeca2, 0x4420, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/0/10 */
    { 0x0331, 0xeca2, 0x4420, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/0/12 */
    { 0x0339, 0xeca2, 0x4420, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/0/14 */
    { 0x0701, 0xeca2, 0xc4a0, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/1/0 */
    { 0x0709, 0xeca2, 0xc4a0, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/1/2 */
    { 0x0711, 0xeca2, 0xc4a0, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/1/4 */
    { 0x0719, 0xeca2, 0xc4a0, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/1/6 */
    { 0x0721, 0xeca2, 0x4420, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/1/8 */
    { 0x0729, 0xeca2, 0x4420, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/1/10 */
    { 0x0731, 0xeca2, 0x4420, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/1/12 */
    { 0x0739, 0xeca2, 0x4420, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/1/14 */
    { 0x0b01, 0xeca2, 0xc4a0, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/2/0 */
    { 0x0b09, 0xeca2, 0xc4a0, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/2/2 */
    { 0x0b11, 0xeca2, 0xc4a0, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/2/4 */
    { 0x0b19, 0xeca2, 0xc4a0, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/2/6 */
    { 0x0b21, 0xeca2, 0x4420, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/2/8 */
    { 0x0b29, 0xeca2, 0x4420, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/2/10 */
    { 0x0b31, 0xeca2, 0x4420, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/2/12 */
    { 0x0b39, 0xeca2, 0x4420, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/2/14 */
    { 0x0f01, 0xeca2, 0xc4a0, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/3/0 */
    { 0x0f09, 0xeca2, 0xc4a0, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/3/2 */
    { 0x0f11, 0xeca2, 0xc4a0, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/3/4 */
    { 0x0f19, 0xeca2, 0xc4a0, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/3/6 */
    { 0x0f21, 0xeca2, 0x4420, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/3/8 */
    { 0x0f29, 0xeca2, 0x4420, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/3/10 */
    { 0x0f31, 0xeca2, 0x4420, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/3/12 */
    { 0x0f39, 0xeca2, 0x4420, RTFLOAT80U_INIT_C(0,0x578e9b29c2fe5647,0), INT64_C(0) }, /* #9/3/14 */
    { 0x0104, 0xd856, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/0/0 */
    { 0x010c, 0xd856, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/0/2 */
    { 0x0114, 0xd856, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/0/4 */
    { 0x011c, 0xd856, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/0/6 */
    { 0x0124, 0xd856, 0x4020, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/0/8 */
    { 0x012c, 0xd856, 0x4020, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/0/10 */
    { 0x0134, 0xd856, 0x4020, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/0/12 */
    { 0x013c, 0xd856, 0x4020, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/0/14 */
    { 0x0504, 0xd856, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/1/0 */
    { 0x050c, 0xd856, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/1/2 */
    { 0x0514, 0xd856, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/1/4 */
    { 0x051c, 0xd856, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/1/6 */
    { 0x0524, 0xd856, 0x4020, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/1/8 */
    { 0x052c, 0xd856, 0x4020, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/1/10 */
    { 0x0534, 0xd856, 0x4020, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/1/12 */
    { 0x053c, 0xd856, 0x4020, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/1/14 */
    { 0x0904, 0xd856, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/2/0 */
    { 0x090c, 0xd856, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/2/2 */
    { 0x0914, 0xd856, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/2/4 */
    { 0x091c, 0xd856, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/2/6 */
    { 0x0924, 0xd856, 0x4020, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/2/8 */
    { 0x092c, 0xd856, 0x4020, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/2/10 */
    { 0x0934, 0xd856, 0x4020, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/2/12 */
    { 0x093c, 0xd856, 0x4020, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/2/14 */
    { 0x0d04, 0xd856, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/3/0 */
    { 0x0d0c, 0xd856, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/3/2 */
    { 0x0d14, 0xd856, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/3/4 */
    { 0x0d1c, 0xd856, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/3/6 */
    { 0x0d24, 0xd856, 0x4020, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/3/8 */
    { 0x0d2c, 0xd856, 0x4020, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/3/10 */
    { 0x0d34, 0xd856, 0x4020, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/3/12 */
    { 0x0d3c, 0xd856, 0x4020, RTFLOAT80U_INIT_C(0,0xa9529fb0370307e1,16445), INT64_C(6100494959843050480) }, /* #10/3/14 */
    { 0x0343, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/0/0 */
    { 0x034b, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/0/2 */
    { 0x0353, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/0/4 */
    { 0x035b, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/0/6 */
    { 0x0363, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/0/8 */
    { 0x036b, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/0/10 */
    { 0x0373, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/0/12 */
    { 0x037b, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/0/14 */
    { 0x0743, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/1/0 */
    { 0x074b, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/1/2 */
    { 0x0753, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/1/4 */
    { 0x075b, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/1/6 */
    { 0x0763, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/1/8 */
    { 0x076b, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/1/10 */
    { 0x0773, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/1/12 */
    { 0x077b, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/1/14 */
    { 0x0b43, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/2/0 */
    { 0x0b4b, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/2/2 */
    { 0x0b53, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/2/4 */
    { 0x0b5b, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/2/6 */
    { 0x0b63, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/2/8 */
    { 0x0b6b, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/2/10 */
    { 0x0b73, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/2/12 */
    { 0x0b7b, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/2/14 */
    { 0x0f43, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/3/0 */
    { 0x0f4b, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/3/2 */
    { 0x0f53, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/3/4 */
    { 0x0f5b, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/3/6 */
    { 0x0f63, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/3/8 */
    { 0x0f6b, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/3/10 */
    { 0x0f73, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/3/12 */
    { 0x0f7b, 0x707b, 0x4001, RTFLOAT80U_INIT_C(0,0xf2768,32767), INT64_MIN }, /* #11/3/14 */
    { 0x0244, 0x7b21, 0xc1a0, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/0/0 */
    { 0x024c, 0x7b21, 0xc1a0, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/0/2 */
    { 0x0254, 0x7b21, 0xc1a0, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/0/4 */
    { 0x025c, 0x7b21, 0xc1a0, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/0/6 */
    { 0x0264, 0x7b21, 0x4120, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/0/8 */
    { 0x026c, 0x7b21, 0x4120, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/0/10 */
    { 0x0274, 0x7b21, 0x4120, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/0/12 */
    { 0x027c, 0x7b21, 0x4120, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/0/14 */
    { 0x0644, 0x7b21, 0xc1a0, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/1/0 */
    { 0x064c, 0x7b21, 0xc1a0, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/1/2 */
    { 0x0654, 0x7b21, 0xc1a0, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/1/4 */
    { 0x065c, 0x7b21, 0xc1a0, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/1/6 */
    { 0x0664, 0x7b21, 0x4120, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/1/8 */
    { 0x066c, 0x7b21, 0x4120, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/1/10 */
    { 0x0674, 0x7b21, 0x4120, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/1/12 */
    { 0x067c, 0x7b21, 0x4120, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/1/14 */
    { 0x0a44, 0x7b21, 0xc1a0, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/2/0 */
    { 0x0a4c, 0x7b21, 0xc1a0, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/2/2 */
    { 0x0a54, 0x7b21, 0xc1a0, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/2/4 */
    { 0x0a5c, 0x7b21, 0xc1a0, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/2/6 */
    { 0x0a64, 0x7b21, 0x4120, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/2/8 */
    { 0x0a6c, 0x7b21, 0x4120, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/2/10 */
    { 0x0a74, 0x7b21, 0x4120, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/2/12 */
    { 0x0a7c, 0x7b21, 0x4120, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/2/14 */
    { 0x0e44, 0x7b21, 0xc1a0, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/3/0 */
    { 0x0e4c, 0x7b21, 0xc1a0, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/3/2 */
    { 0x0e54, 0x7b21, 0xc1a0, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/3/4 */
    { 0x0e5c, 0x7b21, 0xc1a0, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/3/6 */
    { 0x0e64, 0x7b21, 0x4120, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/3/8 */
    { 0x0e6c, 0x7b21, 0x4120, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/3/10 */
    { 0x0e74, 0x7b21, 0x4120, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/3/12 */
    { 0x0e7c, 0x7b21, 0x4120, RTFLOAT80U_INIT_C(1,0x80000000000000c8,0), INT64_C(0) }, /* #12/3/14 */
    { 0x0242, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/0/0 */
    { 0x024a, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/0/2 */
    { 0x0252, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/0/4 */
    { 0x025a, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/0/6 */
    { 0x0262, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/0/8 */
    { 0x026a, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/0/10 */
    { 0x0272, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/0/12 */
    { 0x027a, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/0/14 */
    { 0x0642, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/1/0 */
    { 0x064a, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/1/2 */
    { 0x0652, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/1/4 */
    { 0x065a, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/1/6 */
    { 0x0662, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/1/8 */
    { 0x066a, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/1/10 */
    { 0x0672, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/1/12 */
    { 0x067a, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/1/14 */
    { 0x0a42, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/2/0 */
    { 0x0a4a, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/2/2 */
    { 0x0a52, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/2/4 */
    { 0x0a5a, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/2/6 */
    { 0x0a62, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/2/8 */
    { 0x0a6a, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/2/10 */
    { 0x0a72, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/2/12 */
    { 0x0a7a, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/2/14 */
    { 0x0e42, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/3/0 */
    { 0x0e4a, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/3/2 */
    { 0x0e52, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/3/4 */
    { 0x0e5a, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/3/6 */
    { 0x0e62, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/3/8 */
    { 0x0e6a, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/3/10 */
    { 0x0e72, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/3/12 */
    { 0x0e7a, 0xf620, 0xfc81, RTFLOAT80U_INIT_C(1,0x37ee20f79f30b2ac,32767), INT64_C(-3) }, /* #13/3/14 */
    { 0x0306, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/0/0 */
    { 0x030e, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/0/2 */
    { 0x0316, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/0/4 */
    { 0x031e, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/0/6 */
    { 0x0326, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/0/8 */
    { 0x032e, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/0/10 */
    { 0x0336, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/0/12 */
    { 0x033e, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/0/14 */
    { 0x0706, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/1/0 */
    { 0x070e, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/1/2 */
    { 0x0716, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/1/4 */
    { 0x071e, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/1/6 */
    { 0x0726, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/1/8 */
    { 0x072e, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/1/10 */
    { 0x0736, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/1/12 */
    { 0x073e, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/1/14 */
    { 0x0b06, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/2/0 */
    { 0x0b0e, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/2/2 */
    { 0x0b16, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/2/4 */
    { 0x0b1e, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/2/6 */
    { 0x0b26, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/2/8 */
    { 0x0b2e, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/2/10 */
    { 0x0b36, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/2/12 */
    { 0x0b3e, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/2/14 */
    { 0x0f06, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/3/0 */
    { 0x0f0e, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/3/2 */
    { 0x0f16, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/3/4 */
    { 0x0f1e, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/3/6 */
    { 0x0f26, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/3/8 */
    { 0x0f2e, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/3/10 */
    { 0x0f36, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/3/12 */
    { 0x0f3e, 0x0e60, 0xbc81, RTFLOAT80U_INIT_C(1,0xaa507ef8c2437113,19205), INT64_C(-3) }, /* #14/3/14 */
    { 0x0140, 0x2436, 0x84a0, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/0/0 */
    { 0x0148, 0x2436, 0x84a0, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/0/2 */
    { 0x0150, 0x2436, 0x84a0, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/0/4 */
    { 0x0158, 0x2436, 0x84a0, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/0/6 */
    { 0x0160, 0x2436, 0x0420, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/0/8 */
    { 0x0168, 0x2436, 0x0420, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/0/10 */
    { 0x0170, 0x2436, 0x0420, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/0/12 */
    { 0x0178, 0x2436, 0x0420, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/0/14 */
    { 0x0540, 0x2436, 0x84a0, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/1/0 */
    { 0x0548, 0x2436, 0x84a0, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/1/2 */
    { 0x0550, 0x2436, 0x84a0, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/1/4 */
    { 0x0558, 0x2436, 0x84a0, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/1/6 */
    { 0x0560, 0x2436, 0x0420, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/1/8 */
    { 0x0568, 0x2436, 0x0420, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/1/10 */
    { 0x0570, 0x2436, 0x0420, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/1/12 */
    { 0x0578, 0x2436, 0x0420, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/1/14 */
    { 0x0940, 0x2436, 0x84a0, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/2/0 */
    { 0x0948, 0x2436, 0x84a0, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/2/2 */
    { 0x0950, 0x2436, 0x84a0, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/2/4 */
    { 0x0958, 0x2436, 0x84a0, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/2/6 */
    { 0x0960, 0x2436, 0x0420, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/2/8 */
    { 0x0968, 0x2436, 0x0420, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/2/10 */
    { 0x0970, 0x2436, 0x0420, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/2/12 */
    { 0x0978, 0x2436, 0x0420, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/2/14 */
    { 0x0d40, 0x2436, 0x84a0, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/3/0 */
    { 0x0d48, 0x2436, 0x84a0, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/3/2 */
    { 0x0d50, 0x2436, 0x84a0, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/3/4 */
    { 0x0d58, 0x2436, 0x84a0, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/3/6 */
    { 0x0d60, 0x2436, 0x0420, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/3/8 */
    { 0x0d68, 0x2436, 0x0420, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/3/10 */
    { 0x0d70, 0x2436, 0x0420, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/3/12 */
    { 0x0d78, 0x2436, 0x0420, RTFLOAT80U_INIT_C(1,0xfacae73459cf9189,16445), INT64_C(-9035755333404313796) }, /* #15/3/14 */
    { 0x0204, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/0/0 */
    { 0x020c, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/0/2 */
    { 0x0214, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/0/4 */
    { 0x021c, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/0/6 */
    { 0x0224, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/0/8 */
    { 0x022c, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/0/10 */
    { 0x0234, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/0/12 */
    { 0x023c, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/0/14 */
    { 0x0604, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/1/0 */
    { 0x060c, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/1/2 */
    { 0x0614, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/1/4 */
    { 0x061c, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/1/6 */
    { 0x0624, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/1/8 */
    { 0x062c, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/1/10 */
    { 0x0634, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/1/12 */
    { 0x063c, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/1/14 */
    { 0x0a04, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/2/0 */
    { 0x0a0c, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/2/2 */
    { 0x0a14, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/2/4 */
    { 0x0a1c, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/2/6 */
    { 0x0a24, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/2/8 */
    { 0x0a2c, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/2/10 */
    { 0x0a34, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/2/12 */
    { 0x0a3c, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/2/14 */
    { 0x0e04, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/3/0 */
    { 0x0e0c, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/3/2 */
    { 0x0e14, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/3/4 */
    { 0x0e1c, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/3/6 */
    { 0x0e24, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/3/8 */
    { 0x0e2c, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/3/10 */
    { 0x0e34, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/3/12 */
    { 0x0e3c, 0x95d0, 0xbd81, RTFLOAT80U_INIT_C(0,0x7816b15c30854ebc,5110), INT64_C(-3) }, /* #16/3/14 */
    { 0x0343, 0xf0d7, 0xc0a0, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/0/0 */
    { 0x034b, 0xf0d7, 0xc0a0, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/0/2 */
    { 0x0353, 0xf0d7, 0xc0a0, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/0/4 */
    { 0x035b, 0xf0d7, 0xc0a0, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/0/6 */
    { 0x0363, 0xf0d7, 0x4020, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/0/8 */
    { 0x036b, 0xf0d7, 0x4020, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/0/10 */
    { 0x0373, 0xf0d7, 0x4020, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/0/12 */
    { 0x037b, 0xf0d7, 0x4020, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/0/14 */
    { 0x0743, 0xf0d7, 0xc0a0, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/1/0 */
    { 0x074b, 0xf0d7, 0xc0a0, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/1/2 */
    { 0x0753, 0xf0d7, 0xc0a0, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/1/4 */
    { 0x075b, 0xf0d7, 0xc0a0, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/1/6 */
    { 0x0763, 0xf0d7, 0x4020, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/1/8 */
    { 0x076b, 0xf0d7, 0x4020, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/1/10 */
    { 0x0773, 0xf0d7, 0x4020, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/1/12 */
    { 0x077b, 0xf0d7, 0x4020, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/1/14 */
    { 0x0b43, 0xf0d7, 0xc0a0, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/2/0 */
    { 0x0b4b, 0xf0d7, 0xc0a0, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/2/2 */
    { 0x0b53, 0xf0d7, 0xc0a0, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/2/4 */
    { 0x0b5b, 0xf0d7, 0xc0a0, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/2/6 */
    { 0x0b63, 0xf0d7, 0x4020, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/2/8 */
    { 0x0b6b, 0xf0d7, 0x4020, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/2/10 */
    { 0x0b73, 0xf0d7, 0x4020, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/2/12 */
    { 0x0b7b, 0xf0d7, 0x4020, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/2/14 */
    { 0x0f43, 0xf0d7, 0xc0a0, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/3/0 */
    { 0x0f4b, 0xf0d7, 0xc0a0, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/3/2 */
    { 0x0f53, 0xf0d7, 0xc0a0, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/3/4 */
    { 0x0f5b, 0xf0d7, 0xc0a0, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/3/6 */
    { 0x0f63, 0xf0d7, 0x4020, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/3/8 */
    { 0x0f6b, 0xf0d7, 0x4020, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/3/10 */
    { 0x0f73, 0xf0d7, 0x4020, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/3/12 */
    { 0x0f7b, 0xf0d7, 0x4020, RTFLOAT80U_INIT_C(0,0xfde2cdc6ec402ab2,16383), INT64_C(1) }, /* #17/3/14 */
    { 0x0241, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/0/0 */
    { 0x0249, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/0/2 */
    { 0x0251, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/0/4 */
    { 0x0259, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/0/6 */
    { 0x0261, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/0/8 */
    { 0x0269, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/0/10 */
    { 0x0271, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/0/12 */
    { 0x0279, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/0/14 */
    { 0x0641, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/1/0 */
    { 0x0649, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/1/2 */
    { 0x0651, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/1/4 */
    { 0x0659, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/1/6 */
    { 0x0661, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/1/8 */
    { 0x0669, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/1/10 */
    { 0x0671, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/1/12 */
    { 0x0679, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/1/14 */
    { 0x0a41, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/2/0 */
    { 0x0a49, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/2/2 */
    { 0x0a51, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/2/4 */
    { 0x0a59, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/2/6 */
    { 0x0a61, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/2/8 */
    { 0x0a69, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/2/10 */
    { 0x0a71, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/2/12 */
    { 0x0a79, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/2/14 */
    { 0x0e41, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/3/0 */
    { 0x0e49, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/3/2 */
    { 0x0e51, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/3/4 */
    { 0x0e59, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/3/6 */
    { 0x0e61, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/3/8 */
    { 0x0e69, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/3/10 */
    { 0x0e71, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/3/12 */
    { 0x0e79, 0x204c, 0x0001, RTFLOAT80U_INIT_C(1,0x11bebdf9a811b071,18126), INT64_MIN }, /* #18/3/14 */
    { 0x0207, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/0/0 */
    { 0x020f, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/0/2 */
    { 0x0217, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/0/4 */
    { 0x021f, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/0/6 */
    { 0x0227, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/0/8 */
    { 0x022f, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/0/10 */
    { 0x0237, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/0/12 */
    { 0x023f, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/0/14 */
    { 0x0607, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/1/0 */
    { 0x060f, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/1/2 */
    { 0x0617, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/1/4 */
    { 0x061f, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/1/6 */
    { 0x0627, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/1/8 */
    { 0x062f, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/1/10 */
    { 0x0637, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/1/12 */
    { 0x063f, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/1/14 */
    { 0x0a07, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/2/0 */
    { 0x0a0f, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/2/2 */
    { 0x0a17, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/2/4 */
    { 0x0a1f, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/2/6 */
    { 0x0a27, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/2/8 */
    { 0x0a2f, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/2/10 */
    { 0x0a37, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/2/12 */
    { 0x0a3f, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/2/14 */
    { 0x0e07, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/3/0 */
    { 0x0e0f, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/3/2 */
    { 0x0e17, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/3/4 */
    { 0x0e1f, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/3/6 */
    { 0x0e27, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/3/8 */
    { 0x0e2f, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/3/10 */
    { 0x0e37, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/3/12 */
    { 0x0e3f, 0x9a54, 0x0000, RTFLOAT80U_INIT_C(1,0x882f15f726b96a10,16445), INT64_C(-4906543132157195528) }, /* #19/3/14 */
    { 0x0143, 0x9d5e, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/0/0 */
    { 0x014b, 0x9d5e, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/0/2 */
    { 0x0153, 0x9d5e, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/0/4 */
    { 0x015b, 0x9d5e, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/0/6 */
    { 0x0163, 0x9d5e, 0x0520, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/0/8 */
    { 0x016b, 0x9d5e, 0x0520, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/0/10 */
    { 0x0173, 0x9d5e, 0x0520, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/0/12 */
    { 0x017b, 0x9d5e, 0x0520, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/0/14 */
    { 0x0543, 0x9d5e, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/1/0 */
    { 0x054b, 0x9d5e, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/1/2 */
    { 0x0553, 0x9d5e, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/1/4 */
    { 0x055b, 0x9d5e, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/1/6 */
    { 0x0563, 0x9d5e, 0x0520, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/1/8 */
    { 0x056b, 0x9d5e, 0x0520, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/1/10 */
    { 0x0573, 0x9d5e, 0x0520, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/1/12 */
    { 0x057b, 0x9d5e, 0x0520, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/1/14 */
    { 0x0943, 0x9d5e, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/2/0 */
    { 0x094b, 0x9d5e, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/2/2 */
    { 0x0953, 0x9d5e, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/2/4 */
    { 0x095b, 0x9d5e, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/2/6 */
    { 0x0963, 0x9d5e, 0x0520, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/2/8 */
    { 0x096b, 0x9d5e, 0x0520, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/2/10 */
    { 0x0973, 0x9d5e, 0x0520, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/2/12 */
    { 0x097b, 0x9d5e, 0x0520, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/2/14 */
    { 0x0d43, 0x9d5e, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/3/0 */
    { 0x0d4b, 0x9d5e, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/3/2 */
    { 0x0d53, 0x9d5e, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/3/4 */
    { 0x0d5b, 0x9d5e, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/3/6 */
    { 0x0d63, 0x9d5e, 0x0520, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/3/8 */
    { 0x0d6b, 0x9d5e, 0x0520, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/3/10 */
    { 0x0d73, 0x9d5e, 0x0520, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/3/12 */
    { 0x0d7b, 0x9d5e, 0x0520, RTFLOAT80U_INIT_C(1,0x8000000000000003,0), INT64_C(0) }, /* #20/3/14 */
    { 0x0141, 0x311c, 0x81a0, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/0/0 */
    { 0x0149, 0x311c, 0x81a0, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/0/2 */
    { 0x0151, 0x311c, 0x81a0, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/0/4 */
    { 0x0159, 0x311c, 0x81a0, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/0/6 */
    { 0x0161, 0x311c, 0x0120, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/0/8 */
    { 0x0169, 0x311c, 0x0120, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/0/10 */
    { 0x0171, 0x311c, 0x0120, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/0/12 */
    { 0x0179, 0x311c, 0x0120, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/0/14 */
    { 0x0541, 0x311c, 0x81a0, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/1/0 */
    { 0x0549, 0x311c, 0x81a0, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/1/2 */
    { 0x0551, 0x311c, 0x81a0, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/1/4 */
    { 0x0559, 0x311c, 0x81a0, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/1/6 */
    { 0x0561, 0x311c, 0x0120, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/1/8 */
    { 0x0569, 0x311c, 0x0120, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/1/10 */
    { 0x0571, 0x311c, 0x0120, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/1/12 */
    { 0x0579, 0x311c, 0x0120, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/1/14 */
    { 0x0941, 0x311c, 0x81a0, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/2/0 */
    { 0x0949, 0x311c, 0x81a0, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/2/2 */
    { 0x0951, 0x311c, 0x81a0, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/2/4 */
    { 0x0959, 0x311c, 0x81a0, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/2/6 */
    { 0x0961, 0x311c, 0x0120, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/2/8 */
    { 0x0969, 0x311c, 0x0120, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/2/10 */
    { 0x0971, 0x311c, 0x0120, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/2/12 */
    { 0x0979, 0x311c, 0x0120, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/2/14 */
    { 0x0d41, 0x311c, 0x81a0, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/3/0 */
    { 0x0d49, 0x311c, 0x81a0, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/3/2 */
    { 0x0d51, 0x311c, 0x81a0, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/3/4 */
    { 0x0d59, 0x311c, 0x81a0, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/3/6 */
    { 0x0d61, 0x311c, 0x0120, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/3/8 */
    { 0x0d69, 0x311c, 0x0120, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/3/10 */
    { 0x0d71, 0x311c, 0x0120, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/3/12 */
    { 0x0d79, 0x311c, 0x0120, RTFLOAT80U_INIT_C(1,0xf680ea0dfdb7537d,16383), INT64_C(-1) }, /* #21/3/14 */
    { 0x0200, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/0/0 */
    { 0x0208, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/0/2 */
    { 0x0210, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/0/4 */
    { 0x0218, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/0/6 */
    { 0x0220, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/0/8 */
    { 0x0228, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/0/10 */
    { 0x0230, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/0/12 */
    { 0x0238, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/0/14 */
    { 0x0600, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/1/0 */
    { 0x0608, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/1/2 */
    { 0x0610, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/1/4 */
    { 0x0618, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/1/6 */
    { 0x0620, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/1/8 */
    { 0x0628, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/1/10 */
    { 0x0630, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/1/12 */
    { 0x0638, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/1/14 */
    { 0x0a00, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/2/0 */
    { 0x0a08, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/2/2 */
    { 0x0a10, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/2/4 */
    { 0x0a18, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/2/6 */
    { 0x0a20, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/2/8 */
    { 0x0a28, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/2/10 */
    { 0x0a30, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/2/12 */
    { 0x0a38, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/2/14 */
    { 0x0e00, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/3/0 */
    { 0x0e08, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/3/2 */
    { 0x0e10, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/3/4 */
    { 0x0e18, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/3/6 */
    { 0x0e20, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/3/8 */
    { 0x0e28, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/3/10 */
    { 0x0e30, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/3/12 */
    { 0x0e38, 0xfb8f, 0xf981, RTFLOAT80U_INIT_C(0,0x4abb0b4a5ceee055,19287), INT64_C(-3) }, /* #22/3/14 */
    { 0x0147, 0xbd0a, 0x85a0, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/0/0 */
    { 0x014f, 0xbd0a, 0x85a0, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/0/2 */
    { 0x0157, 0xbd0a, 0x85a0, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/0/4 */
    { 0x015f, 0xbd0a, 0x85a0, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/0/6 */
    { 0x0167, 0xbd0a, 0x0520, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/0/8 */
    { 0x016f, 0xbd0a, 0x0520, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/0/10 */
    { 0x0177, 0xbd0a, 0x0520, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/0/12 */
    { 0x017f, 0xbd0a, 0x0520, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/0/14 */
    { 0x0547, 0xbd0a, 0x85a0, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/1/0 */
    { 0x054f, 0xbd0a, 0x85a0, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/1/2 */
    { 0x0557, 0xbd0a, 0x85a0, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/1/4 */
    { 0x055f, 0xbd0a, 0x85a0, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/1/6 */
    { 0x0567, 0xbd0a, 0x0520, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/1/8 */
    { 0x056f, 0xbd0a, 0x0520, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/1/10 */
    { 0x0577, 0xbd0a, 0x0520, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/1/12 */
    { 0x057f, 0xbd0a, 0x0520, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/1/14 */
    { 0x0947, 0xbd0a, 0x85a0, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/2/0 */
    { 0x094f, 0xbd0a, 0x85a0, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/2/2 */
    { 0x0957, 0xbd0a, 0x85a0, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/2/4 */
    { 0x095f, 0xbd0a, 0x85a0, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/2/6 */
    { 0x0967, 0xbd0a, 0x0520, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/2/8 */
    { 0x096f, 0xbd0a, 0x0520, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/2/10 */
    { 0x0977, 0xbd0a, 0x0520, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/2/12 */
    { 0x097f, 0xbd0a, 0x0520, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/2/14 */
    { 0x0d47, 0xbd0a, 0x85a0, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/3/0 */
    { 0x0d4f, 0xbd0a, 0x85a0, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/3/2 */
    { 0x0d57, 0xbd0a, 0x85a0, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/3/4 */
    { 0x0d5f, 0xbd0a, 0x85a0, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/3/6 */
    { 0x0d67, 0xbd0a, 0x0520, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/3/8 */
    { 0x0d6f, 0xbd0a, 0x0520, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/3/10 */
    { 0x0d77, 0xbd0a, 0x0520, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/3/12 */
    { 0x0d7f, 0xbd0a, 0x0520, RTFLOAT80U_INIT_C(0,0x94ef6fa951bb03ff,0), INT64_C(0) }, /* #23/3/14 */
    { 0x0040, 0x314d, 0x81a0, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/0/0 */
    { 0x0048, 0x314d, 0x81a0, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/0/2 */
    { 0x0050, 0x314d, 0x81a0, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/0/4 */
    { 0x0058, 0x314d, 0x81a0, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/0/6 */
    { 0x0060, 0x314d, 0x0120, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/0/8 */
    { 0x0068, 0x314d, 0x0120, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/0/10 */
    { 0x0070, 0x314d, 0x0120, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/0/12 */
    { 0x0078, 0x314d, 0x0120, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/0/14 */
    { 0x0440, 0x314d, 0x81a0, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/1/0 */
    { 0x0448, 0x314d, 0x81a0, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/1/2 */
    { 0x0450, 0x314d, 0x81a0, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/1/4 */
    { 0x0458, 0x314d, 0x81a0, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/1/6 */
    { 0x0460, 0x314d, 0x0120, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/1/8 */
    { 0x0468, 0x314d, 0x0120, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/1/10 */
    { 0x0470, 0x314d, 0x0120, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/1/12 */
    { 0x0478, 0x314d, 0x0120, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/1/14 */
    { 0x0840, 0x314d, 0x81a0, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/2/0 */
    { 0x0848, 0x314d, 0x81a0, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/2/2 */
    { 0x0850, 0x314d, 0x81a0, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/2/4 */
    { 0x0858, 0x314d, 0x81a0, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/2/6 */
    { 0x0860, 0x314d, 0x0120, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/2/8 */
    { 0x0868, 0x314d, 0x0120, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/2/10 */
    { 0x0870, 0x314d, 0x0120, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/2/12 */
    { 0x0878, 0x314d, 0x0120, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/2/14 */
    { 0x0c40, 0x314d, 0x81a0, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/3/0 */
    { 0x0c48, 0x314d, 0x81a0, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/3/2 */
    { 0x0c50, 0x314d, 0x81a0, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/3/4 */
    { 0x0c58, 0x314d, 0x81a0, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/3/6 */
    { 0x0c60, 0x314d, 0x0120, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/3/8 */
    { 0x0c68, 0x314d, 0x0120, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/3/10 */
    { 0x0c70, 0x314d, 0x0120, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/3/12 */
    { 0x0c78, 0x314d, 0x0120, RTFLOAT80U_INIT_C(0,0x5eb722e5acbcaefd,0), INT64_C(0) }, /* #24/3/14 */
    { 0x0241, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/0/0 */
    { 0x0249, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/0/2 */
    { 0x0251, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/0/4 */
    { 0x0259, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/0/6 */
    { 0x0261, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/0/8 */
    { 0x0269, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/0/10 */
    { 0x0271, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/0/12 */
    { 0x0279, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/0/14 */
    { 0x0641, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/1/0 */
    { 0x0649, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/1/2 */
    { 0x0651, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/1/4 */
    { 0x0659, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/1/6 */
    { 0x0661, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/1/8 */
    { 0x0669, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/1/10 */
    { 0x0671, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/1/12 */
    { 0x0679, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/1/14 */
    { 0x0a41, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/2/0 */
    { 0x0a49, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/2/2 */
    { 0x0a51, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/2/4 */
    { 0x0a59, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/2/6 */
    { 0x0a61, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/2/8 */
    { 0x0a69, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/2/10 */
    { 0x0a71, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/2/12 */
    { 0x0a79, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/2/14 */
    { 0x0e41, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/3/0 */
    { 0x0e49, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/3/2 */
    { 0x0e51, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/3/4 */
    { 0x0e59, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/3/6 */
    { 0x0e61, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/3/8 */
    { 0x0e69, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/3/10 */
    { 0x0e71, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/3/12 */
    { 0x0e79, 0xaa08, 0x0001, RTFLOAT80U_INIT_C(0,0x49e04ac2b76d7458,7244), INT64_MIN }, /* #25/3/14 */
    { 0x0006, 0xe111, 0xc1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/0/0 */
    { 0x000e, 0xe111, 0xc1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/0/2 */
    { 0x0016, 0xe111, 0xc1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/0/4 */
    { 0x001e, 0xe111, 0xc1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/0/6 */
    { 0x0026, 0xe111, 0x4120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/0/8 */
    { 0x002e, 0xe111, 0x4120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/0/10 */
    { 0x0036, 0xe111, 0x4120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/0/12 */
    { 0x003e, 0xe111, 0x4120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/0/14 */
    { 0x0406, 0xe111, 0xc1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/1/0 */
    { 0x040e, 0xe111, 0xc1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/1/2 */
    { 0x0416, 0xe111, 0xc1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/1/4 */
    { 0x041e, 0xe111, 0xc1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/1/6 */
    { 0x0426, 0xe111, 0x4120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/1/8 */
    { 0x042e, 0xe111, 0x4120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/1/10 */
    { 0x0436, 0xe111, 0x4120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/1/12 */
    { 0x043e, 0xe111, 0x4120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/1/14 */
    { 0x0806, 0xe111, 0xc1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/2/0 */
    { 0x080e, 0xe111, 0xc1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/2/2 */
    { 0x0816, 0xe111, 0xc1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/2/4 */
    { 0x081e, 0xe111, 0xc1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/2/6 */
    { 0x0826, 0xe111, 0x4120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/2/8 */
    { 0x082e, 0xe111, 0x4120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/2/10 */
    { 0x0836, 0xe111, 0x4120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/2/12 */
    { 0x083e, 0xe111, 0x4120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/2/14 */
    { 0x0c06, 0xe111, 0xc1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/3/0 */
    { 0x0c0e, 0xe111, 0xc1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/3/2 */
    { 0x0c16, 0xe111, 0xc1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/3/4 */
    { 0x0c1e, 0xe111, 0xc1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/3/6 */
    { 0x0c26, 0xe111, 0x4120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/3/8 */
    { 0x0c2e, 0xe111, 0x4120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/3/10 */
    { 0x0c36, 0xe111, 0x4120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/3/12 */
    { 0x0c3e, 0xe111, 0x4120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #26/3/14 */
    { 0x0245, 0xa874, 0x80a0, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/0/0 */
    { 0x024d, 0xa874, 0x80a0, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/0/2 */
    { 0x0255, 0xa874, 0x80a0, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/0/4 */
    { 0x025d, 0xa874, 0x80a0, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/0/6 */
    { 0x0265, 0xa874, 0x0020, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/0/8 */
    { 0x026d, 0xa874, 0x0020, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/0/10 */
    { 0x0275, 0xa874, 0x0020, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/0/12 */
    { 0x027d, 0xa874, 0x0020, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/0/14 */
    { 0x0645, 0xa874, 0x80a0, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/1/0 */
    { 0x064d, 0xa874, 0x80a0, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/1/2 */
    { 0x0655, 0xa874, 0x80a0, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/1/4 */
    { 0x065d, 0xa874, 0x80a0, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/1/6 */
    { 0x0665, 0xa874, 0x0020, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/1/8 */
    { 0x066d, 0xa874, 0x0020, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/1/10 */
    { 0x0675, 0xa874, 0x0020, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/1/12 */
    { 0x067d, 0xa874, 0x0020, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/1/14 */
    { 0x0a45, 0xa874, 0x80a0, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/2/0 */
    { 0x0a4d, 0xa874, 0x80a0, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/2/2 */
    { 0x0a55, 0xa874, 0x80a0, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/2/4 */
    { 0x0a5d, 0xa874, 0x80a0, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/2/6 */
    { 0x0a65, 0xa874, 0x0020, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/2/8 */
    { 0x0a6d, 0xa874, 0x0020, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/2/10 */
    { 0x0a75, 0xa874, 0x0020, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/2/12 */
    { 0x0a7d, 0xa874, 0x0020, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/2/14 */
    { 0x0e45, 0xa874, 0x80a0, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/3/0 */
    { 0x0e4d, 0xa874, 0x80a0, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/3/2 */
    { 0x0e55, 0xa874, 0x80a0, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/3/4 */
    { 0x0e5d, 0xa874, 0x80a0, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/3/6 */
    { 0x0e65, 0xa874, 0x0020, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/3/8 */
    { 0x0e6d, 0xa874, 0x0020, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/3/10 */
    { 0x0e75, 0xa874, 0x0020, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/3/12 */
    { 0x0e7d, 0xa874, 0x0020, RTFLOAT80U_INIT_C(0,0x91b48449f62d986a,128), INT64_C(0) }, /* #27/3/14 */
    { 0x0144, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/0/0 */
    { 0x014c, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/0/2 */
    { 0x0154, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/0/4 */
    { 0x015c, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/0/6 */
    { 0x0164, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/0/8 */
    { 0x016c, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/0/10 */
    { 0x0174, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/0/12 */
    { 0x017c, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/0/14 */
    { 0x0544, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/1/0 */
    { 0x054c, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/1/2 */
    { 0x0554, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/1/4 */
    { 0x055c, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/1/6 */
    { 0x0564, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/1/8 */
    { 0x056c, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/1/10 */
    { 0x0574, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/1/12 */
    { 0x057c, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/1/14 */
    { 0x0944, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/2/0 */
    { 0x094c, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/2/2 */
    { 0x0954, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/2/4 */
    { 0x095c, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/2/6 */
    { 0x0964, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/2/8 */
    { 0x096c, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/2/10 */
    { 0x0974, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/2/12 */
    { 0x097c, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/2/14 */
    { 0x0d44, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/3/0 */
    { 0x0d4c, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/3/2 */
    { 0x0d54, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/3/4 */
    { 0x0d5c, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/3/6 */
    { 0x0d64, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/3/8 */
    { 0x0d6c, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/3/10 */
    { 0x0d74, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/3/12 */
    { 0x0d7c, 0x988b, 0xb881, RTFLOAT80U_INIT_C(0,0x22ec4c6fb09ef6af,8593), INT64_C(-3) }, /* #28/3/14 */
    { 0x0206, 0x6a96, 0xc0a0, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/0/0 */
    { 0x020e, 0x6a96, 0xc0a0, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/0/2 */
    { 0x0216, 0x6a96, 0xc0a0, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/0/4 */
    { 0x021e, 0x6a96, 0xc0a0, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/0/6 */
    { 0x0226, 0x6a96, 0x4020, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/0/8 */
    { 0x022e, 0x6a96, 0x4020, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/0/10 */
    { 0x0236, 0x6a96, 0x4020, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/0/12 */
    { 0x023e, 0x6a96, 0x4020, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/0/14 */
    { 0x0606, 0x6a96, 0xc0a0, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/1/0 */
    { 0x060e, 0x6a96, 0xc0a0, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/1/2 */
    { 0x0616, 0x6a96, 0xc0a0, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/1/4 */
    { 0x061e, 0x6a96, 0xc0a0, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/1/6 */
    { 0x0626, 0x6a96, 0x4020, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/1/8 */
    { 0x062e, 0x6a96, 0x4020, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/1/10 */
    { 0x0636, 0x6a96, 0x4020, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/1/12 */
    { 0x063e, 0x6a96, 0x4020, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/1/14 */
    { 0x0a06, 0x6a96, 0xc0a0, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/2/0 */
    { 0x0a0e, 0x6a96, 0xc0a0, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/2/2 */
    { 0x0a16, 0x6a96, 0xc0a0, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/2/4 */
    { 0x0a1e, 0x6a96, 0xc0a0, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/2/6 */
    { 0x0a26, 0x6a96, 0x4020, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/2/8 */
    { 0x0a2e, 0x6a96, 0x4020, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/2/10 */
    { 0x0a36, 0x6a96, 0x4020, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/2/12 */
    { 0x0a3e, 0x6a96, 0x4020, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/2/14 */
    { 0x0e06, 0x6a96, 0xc0a0, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/3/0 */
    { 0x0e0e, 0x6a96, 0xc0a0, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/3/2 */
    { 0x0e16, 0x6a96, 0xc0a0, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/3/4 */
    { 0x0e1e, 0x6a96, 0xc0a0, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/3/6 */
    { 0x0e26, 0x6a96, 0x4020, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/3/8 */
    { 0x0e2e, 0x6a96, 0x4020, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/3/10 */
    { 0x0e36, 0x6a96, 0x4020, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/3/12 */
    { 0x0e3e, 0x6a96, 0x4020, RTFLOAT80U_INIT_C(0,0x93d17327def63c50,16383), INT64_C(1) }, /* #29/3/14 */
    { 0x0245, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/0/0 */
    { 0x024d, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/0/2 */
    { 0x0255, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/0/4 */
    { 0x025d, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/0/6 */
    { 0x0265, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/0/8 */
    { 0x026d, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/0/10 */
    { 0x0275, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/0/12 */
    { 0x027d, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/0/14 */
    { 0x0645, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/1/0 */
    { 0x064d, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/1/2 */
    { 0x0655, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/1/4 */
    { 0x065d, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/1/6 */
    { 0x0665, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/1/8 */
    { 0x066d, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/1/10 */
    { 0x0675, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/1/12 */
    { 0x067d, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/1/14 */
    { 0x0a45, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/2/0 */
    { 0x0a4d, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/2/2 */
    { 0x0a55, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/2/4 */
    { 0x0a5d, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/2/6 */
    { 0x0a65, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/2/8 */
    { 0x0a6d, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/2/10 */
    { 0x0a75, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/2/12 */
    { 0x0a7d, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/2/14 */
    { 0x0e45, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/3/0 */
    { 0x0e4d, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/3/2 */
    { 0x0e55, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/3/4 */
    { 0x0e5d, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/3/6 */
    { 0x0e65, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/3/8 */
    { 0x0e6d, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/3/10 */
    { 0x0e75, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/3/12 */
    { 0x0e7d, 0x1a07, 0x0000, RTFLOAT80U_INIT_C(1,0xcf013da4ffe514a2,16445), INT64_C(-7458135609852463697) }, /* #30/3/14 */
    { 0x0104, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/0/0 */
    { 0x010c, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/0/2 */
    { 0x0114, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/0/4 */
    { 0x011c, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/0/6 */
    { 0x0124, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/0/8 */
    { 0x012c, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/0/10 */
    { 0x0134, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/0/12 */
    { 0x013c, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/0/14 */
    { 0x0504, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/1/0 */
    { 0x050c, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/1/2 */
    { 0x0514, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/1/4 */
    { 0x051c, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/1/6 */
    { 0x0524, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/1/8 */
    { 0x052c, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/1/10 */
    { 0x0534, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/1/12 */
    { 0x053c, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/1/14 */
    { 0x0904, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/2/0 */
    { 0x090c, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/2/2 */
    { 0x0914, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/2/4 */
    { 0x091c, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/2/6 */
    { 0x0924, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/2/8 */
    { 0x092c, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/2/10 */
    { 0x0934, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/2/12 */
    { 0x093c, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/2/14 */
    { 0x0d04, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/3/0 */
    { 0x0d0c, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/3/2 */
    { 0x0d14, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/3/4 */
    { 0x0d1c, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/3/6 */
    { 0x0d24, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/3/8 */
    { 0x0d2c, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/3/10 */
    { 0x0d34, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/3/12 */
    { 0x0d3c, 0x331b, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT64_C(-3) }, /* #31/3/14 */
    { 0x0105, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/0/0 */
    { 0x010d, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/0/2 */
    { 0x0115, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/0/4 */
    { 0x011d, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/0/6 */
    { 0x0125, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/0/8 */
    { 0x012d, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/0/10 */
    { 0x0135, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/0/12 */
    { 0x013d, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/0/14 */
    { 0x0505, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/1/0 */
    { 0x050d, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/1/2 */
    { 0x0515, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/1/4 */
    { 0x051d, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/1/6 */
    { 0x0525, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/1/8 */
    { 0x052d, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/1/10 */
    { 0x0535, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/1/12 */
    { 0x053d, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/1/14 */
    { 0x0905, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/2/0 */
    { 0x090d, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/2/2 */
    { 0x0915, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/2/4 */
    { 0x091d, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/2/6 */
    { 0x0925, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/2/8 */
    { 0x092d, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/2/10 */
    { 0x0935, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/2/12 */
    { 0x093d, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/2/14 */
    { 0x0d05, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/3/0 */
    { 0x0d0d, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/3/2 */
    { 0x0d15, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/3/4 */
    { 0x0d1d, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/3/6 */
    { 0x0d25, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/3/8 */
    { 0x0d2d, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/3/10 */
    { 0x0d35, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/3/12 */
    { 0x0d3d, 0xf6a7, 0x4401, RTFLOAT80U_INIT_C(1,0x1ead8f2460421f5e,5327), INT64_MIN }, /* #32/3/14 */
    { 0x0045, 0xecb9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/0/0 */
    { 0x004d, 0xecb9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/0/2 */
    { 0x0055, 0xecb9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/0/4 */
    { 0x005d, 0xecb9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/0/6 */
    { 0x0065, 0xecb9, 0x4420, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/0/8 */
    { 0x006d, 0xecb9, 0x4420, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/0/10 */
    { 0x0075, 0xecb9, 0x4420, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/0/12 */
    { 0x007d, 0xecb9, 0x4420, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/0/14 */
    { 0x0445, 0xecb9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/1/0 */
    { 0x044d, 0xecb9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/1/2 */
    { 0x0455, 0xecb9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/1/4 */
    { 0x045d, 0xecb9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/1/6 */
    { 0x0465, 0xecb9, 0x4420, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/1/8 */
    { 0x046d, 0xecb9, 0x4420, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/1/10 */
    { 0x0475, 0xecb9, 0x4420, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/1/12 */
    { 0x047d, 0xecb9, 0x4420, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/1/14 */
    { 0x0845, 0xecb9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/2/0 */
    { 0x084d, 0xecb9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/2/2 */
    { 0x0855, 0xecb9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/2/4 */
    { 0x085d, 0xecb9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/2/6 */
    { 0x0865, 0xecb9, 0x4420, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/2/8 */
    { 0x086d, 0xecb9, 0x4420, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/2/10 */
    { 0x0875, 0xecb9, 0x4420, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/2/12 */
    { 0x087d, 0xecb9, 0x4420, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/2/14 */
    { 0x0c45, 0xecb9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/3/0 */
    { 0x0c4d, 0xecb9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/3/2 */
    { 0x0c55, 0xecb9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/3/4 */
    { 0x0c5d, 0xecb9, 0xc4a0, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/3/6 */
    { 0x0c65, 0xecb9, 0x4420, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/3/8 */
    { 0x0c6d, 0xecb9, 0x4420, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/3/10 */
    { 0x0c75, 0xecb9, 0x4420, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/3/12 */
    { 0x0c7d, 0xecb9, 0x4420, RTFLOAT80U_INIT_C(0,0x2d5a749f40717faa,0), INT64_C(0) }, /* #33/3/14 */
    { 0x0141, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/0/0 */
    { 0x0149, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/0/2 */
    { 0x0151, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/0/4 */
    { 0x0159, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/0/6 */
    { 0x0161, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/0/8 */
    { 0x0169, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/0/10 */
    { 0x0171, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/0/12 */
    { 0x0179, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/0/14 */
    { 0x0541, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/1/0 */
    { 0x0549, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/1/2 */
    { 0x0551, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/1/4 */
    { 0x0559, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/1/6 */
    { 0x0561, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/1/8 */
    { 0x0569, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/1/10 */
    { 0x0571, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/1/12 */
    { 0x0579, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/1/14 */
    { 0x0941, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/2/0 */
    { 0x0949, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/2/2 */
    { 0x0951, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/2/4 */
    { 0x0959, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/2/6 */
    { 0x0961, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/2/8 */
    { 0x0969, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/2/10 */
    { 0x0971, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/2/12 */
    { 0x0979, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/2/14 */
    { 0x0d41, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/3/0 */
    { 0x0d49, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/3/2 */
    { 0x0d51, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/3/4 */
    { 0x0d59, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/3/6 */
    { 0x0d61, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/3/8 */
    { 0x0d69, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/3/10 */
    { 0x0d71, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/3/12 */
    { 0x0d79, 0x9e2a, 0x0401, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #34/3/14 */
    { 0x0343, 0xa333, 0x81a0, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/0/0 */
    { 0x034b, 0xa333, 0x81a0, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/0/2 */
    { 0x0353, 0xa333, 0x81a0, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/0/4 */
    { 0x035b, 0xa333, 0x81a0, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/0/6 */
    { 0x0363, 0xa333, 0x0120, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/0/8 */
    { 0x036b, 0xa333, 0x0120, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/0/10 */
    { 0x0373, 0xa333, 0x0120, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/0/12 */
    { 0x037b, 0xa333, 0x0120, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/0/14 */
    { 0x0743, 0xa333, 0x81a0, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/1/0 */
    { 0x074b, 0xa333, 0x81a0, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/1/2 */
    { 0x0753, 0xa333, 0x81a0, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/1/4 */
    { 0x075b, 0xa333, 0x81a0, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/1/6 */
    { 0x0763, 0xa333, 0x0120, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/1/8 */
    { 0x076b, 0xa333, 0x0120, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/1/10 */
    { 0x0773, 0xa333, 0x0120, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/1/12 */
    { 0x077b, 0xa333, 0x0120, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/1/14 */
    { 0x0b43, 0xa333, 0x81a0, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/2/0 */
    { 0x0b4b, 0xa333, 0x81a0, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/2/2 */
    { 0x0b53, 0xa333, 0x81a0, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/2/4 */
    { 0x0b5b, 0xa333, 0x81a0, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/2/6 */
    { 0x0b63, 0xa333, 0x0120, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/2/8 */
    { 0x0b6b, 0xa333, 0x0120, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/2/10 */
    { 0x0b73, 0xa333, 0x0120, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/2/12 */
    { 0x0b7b, 0xa333, 0x0120, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/2/14 */
    { 0x0f43, 0xa333, 0x81a0, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/3/0 */
    { 0x0f4b, 0xa333, 0x81a0, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/3/2 */
    { 0x0f53, 0xa333, 0x81a0, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/3/4 */
    { 0x0f5b, 0xa333, 0x81a0, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/3/6 */
    { 0x0f63, 0xa333, 0x0120, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/3/8 */
    { 0x0f6b, 0xa333, 0x0120, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/3/10 */
    { 0x0f73, 0xa333, 0x0120, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/3/12 */
    { 0x0f7b, 0xa333, 0x0120, RTFLOAT80U_INIT_C(1,0x7770bb3d2c702a84,0), INT64_C(0) }, /* #35/3/14 */
    { 0x0046, 0xec68, 0xc4a0, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/0/0 */
    { 0x004e, 0xec68, 0xc4a0, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/0/2 */
    { 0x0056, 0xec68, 0xc4a0, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/0/4 */
    { 0x005e, 0xec68, 0xc4a0, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/0/6 */
    { 0x0066, 0xec68, 0x4420, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/0/8 */
    { 0x006e, 0xec68, 0x4420, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/0/10 */
    { 0x0076, 0xec68, 0x4420, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/0/12 */
    { 0x007e, 0xec68, 0x4420, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/0/14 */
    { 0x0446, 0xec68, 0xc4a0, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/1/0 */
    { 0x044e, 0xec68, 0xc4a0, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/1/2 */
    { 0x0456, 0xec68, 0xc4a0, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/1/4 */
    { 0x045e, 0xec68, 0xc4a0, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/1/6 */
    { 0x0466, 0xec68, 0x4420, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/1/8 */
    { 0x046e, 0xec68, 0x4420, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/1/10 */
    { 0x0476, 0xec68, 0x4420, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/1/12 */
    { 0x047e, 0xec68, 0x4420, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/1/14 */
    { 0x0846, 0xec68, 0xc4a0, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/2/0 */
    { 0x084e, 0xec68, 0xc4a0, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/2/2 */
    { 0x0856, 0xec68, 0xc4a0, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/2/4 */
    { 0x085e, 0xec68, 0xc4a0, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/2/6 */
    { 0x0866, 0xec68, 0x4420, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/2/8 */
    { 0x086e, 0xec68, 0x4420, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/2/10 */
    { 0x0876, 0xec68, 0x4420, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/2/12 */
    { 0x087e, 0xec68, 0x4420, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/2/14 */
    { 0x0c46, 0xec68, 0xc4a0, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/3/0 */
    { 0x0c4e, 0xec68, 0xc4a0, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/3/2 */
    { 0x0c56, 0xec68, 0xc4a0, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/3/4 */
    { 0x0c5e, 0xec68, 0xc4a0, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/3/6 */
    { 0x0c66, 0xec68, 0x4420, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/3/8 */
    { 0x0c6e, 0xec68, 0x4420, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/3/10 */
    { 0x0c76, 0xec68, 0x4420, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/3/12 */
    { 0x0c7e, 0xec68, 0x4420, RTFLOAT80U_INIT_C(1,0x9aaba5863bed8152,16383), INT64_C(-1) }, /* #36/3/14 */
    { 0x0001, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/0/0 */
    { 0x0009, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/0/2 */
    { 0x0011, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/0/4 */
    { 0x0019, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/0/6 */
    { 0x0021, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/0/8 */
    { 0x0029, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/0/10 */
    { 0x0031, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/0/12 */
    { 0x0039, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/0/14 */
    { 0x0401, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/1/0 */
    { 0x0409, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/1/2 */
    { 0x0411, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/1/4 */
    { 0x0419, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/1/6 */
    { 0x0421, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/1/8 */
    { 0x0429, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/1/10 */
    { 0x0431, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/1/12 */
    { 0x0439, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/1/14 */
    { 0x0801, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/2/0 */
    { 0x0809, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/2/2 */
    { 0x0811, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/2/4 */
    { 0x0819, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/2/6 */
    { 0x0821, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/2/8 */
    { 0x0829, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/2/10 */
    { 0x0831, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/2/12 */
    { 0x0839, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/2/14 */
    { 0x0c01, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/3/0 */
    { 0x0c09, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/3/2 */
    { 0x0c11, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/3/4 */
    { 0x0c19, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/3/6 */
    { 0x0c21, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/3/8 */
    { 0x0c29, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/3/10 */
    { 0x0c31, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/3/12 */
    { 0x0c39, 0xbe0c, 0x0400, RTFLOAT80U_INIT_C(0,0xd7cbdfc6dd6a993a,16445), INT64_C(7774884091819019421) }, /* #37/3/14 */
    { 0x0107, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/0/0 */
    { 0x010f, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/0/2 */
    { 0x0117, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/0/4 */
    { 0x011f, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/0/6 */
    { 0x0127, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/0/8 */
    { 0x012f, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/0/10 */
    { 0x0137, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/0/12 */
    { 0x013f, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/0/14 */
    { 0x0507, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/1/0 */
    { 0x050f, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/1/2 */
    { 0x0517, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/1/4 */
    { 0x051f, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/1/6 */
    { 0x0527, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/1/8 */
    { 0x052f, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/1/10 */
    { 0x0537, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/1/12 */
    { 0x053f, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/1/14 */
    { 0x0907, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/2/0 */
    { 0x090f, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/2/2 */
    { 0x0917, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/2/4 */
    { 0x091f, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/2/6 */
    { 0x0927, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/2/8 */
    { 0x092f, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/2/10 */
    { 0x0937, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/2/12 */
    { 0x093f, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/2/14 */
    { 0x0d07, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/3/0 */
    { 0x0d0f, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/3/2 */
    { 0x0d17, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/3/4 */
    { 0x0d1f, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/3/6 */
    { 0x0d27, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/3/8 */
    { 0x0d2f, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/3/10 */
    { 0x0d37, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/3/12 */
    { 0x0d3f, 0xf823, 0x4001, RTFLOAT80U_INIT_C(0,0x3a799a20fc837386,11506), INT64_MIN }, /* #38/3/14 */
    { 0x0344, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/0/0 */
    { 0x034c, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/0/2 */
    { 0x0354, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/0/4 */
    { 0x035c, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/0/6 */
    { 0x0364, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/0/8 */
    { 0x036c, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/0/10 */
    { 0x0374, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/0/12 */
    { 0x037c, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/0/14 */
    { 0x0744, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/1/0 */
    { 0x074c, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/1/2 */
    { 0x0754, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/1/4 */
    { 0x075c, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/1/6 */
    { 0x0764, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/1/8 */
    { 0x076c, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/1/10 */
    { 0x0774, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/1/12 */
    { 0x077c, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/1/14 */
    { 0x0b44, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/2/0 */
    { 0x0b4c, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/2/2 */
    { 0x0b54, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/2/4 */
    { 0x0b5c, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/2/6 */
    { 0x0b64, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/2/8 */
    { 0x0b6c, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/2/10 */
    { 0x0b74, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/2/12 */
    { 0x0b7c, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/2/14 */
    { 0x0f44, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/3/0 */
    { 0x0f4c, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/3/2 */
    { 0x0f54, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/3/4 */
    { 0x0f5c, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/3/6 */
    { 0x0f64, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/3/8 */
    { 0x0f6c, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/3/10 */
    { 0x0f74, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/3/12 */
    { 0x0f7c, 0x8447, 0xbc81, RTFLOAT80U_INIT_C(1,0xe66435f46c57ceed,23264), INT64_C(-3) }, /* #39/3/14 */
    { 0x0304, 0xbdaa, 0x85a0, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/0/0 */
    { 0x030c, 0xbdaa, 0x85a0, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/0/2 */
    { 0x0314, 0xbdaa, 0x85a0, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/0/4 */
    { 0x031c, 0xbdaa, 0x85a0, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/0/6 */
    { 0x0324, 0xbdaa, 0x0520, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/0/8 */
    { 0x032c, 0xbdaa, 0x0520, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/0/10 */
    { 0x0334, 0xbdaa, 0x0520, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/0/12 */
    { 0x033c, 0xbdaa, 0x0520, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/0/14 */
    { 0x0704, 0xbdaa, 0x85a0, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/1/0 */
    { 0x070c, 0xbdaa, 0x85a0, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/1/2 */
    { 0x0714, 0xbdaa, 0x85a0, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/1/4 */
    { 0x071c, 0xbdaa, 0x85a0, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/1/6 */
    { 0x0724, 0xbdaa, 0x0520, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/1/8 */
    { 0x072c, 0xbdaa, 0x0520, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/1/10 */
    { 0x0734, 0xbdaa, 0x0520, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/1/12 */
    { 0x073c, 0xbdaa, 0x0520, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/1/14 */
    { 0x0b04, 0xbdaa, 0x85a0, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/2/0 */
    { 0x0b0c, 0xbdaa, 0x85a0, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/2/2 */
    { 0x0b14, 0xbdaa, 0x85a0, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/2/4 */
    { 0x0b1c, 0xbdaa, 0x85a0, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/2/6 */
    { 0x0b24, 0xbdaa, 0x0520, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/2/8 */
    { 0x0b2c, 0xbdaa, 0x0520, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/2/10 */
    { 0x0b34, 0xbdaa, 0x0520, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/2/12 */
    { 0x0b3c, 0xbdaa, 0x0520, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/2/14 */
    { 0x0f04, 0xbdaa, 0x85a0, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/3/0 */
    { 0x0f0c, 0xbdaa, 0x85a0, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/3/2 */
    { 0x0f14, 0xbdaa, 0x85a0, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/3/4 */
    { 0x0f1c, 0xbdaa, 0x85a0, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/3/6 */
    { 0x0f24, 0xbdaa, 0x0520, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/3/8 */
    { 0x0f2c, 0xbdaa, 0x0520, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/3/10 */
    { 0x0f34, 0xbdaa, 0x0520, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/3/12 */
    { 0x0f3c, 0xbdaa, 0x0520, RTFLOAT80U_INIT_C(1,0x225ca6,0), INT64_C(0) }, /* #40/3/14 */
    { 0x0203, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/0/0 */
    { 0x020b, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/0/2 */
    { 0x0213, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/0/4 */
    { 0x021b, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/0/6 */
    { 0x0223, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/0/8 */
    { 0x022b, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/0/10 */
    { 0x0233, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/0/12 */
    { 0x023b, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/0/14 */
    { 0x0603, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/1/0 */
    { 0x060b, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/1/2 */
    { 0x0613, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/1/4 */
    { 0x061b, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/1/6 */
    { 0x0623, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/1/8 */
    { 0x062b, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/1/10 */
    { 0x0633, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/1/12 */
    { 0x063b, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/1/14 */
    { 0x0a03, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/2/0 */
    { 0x0a0b, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/2/2 */
    { 0x0a13, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/2/4 */
    { 0x0a1b, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/2/6 */
    { 0x0a23, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/2/8 */
    { 0x0a2b, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/2/10 */
    { 0x0a33, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/2/12 */
    { 0x0a3b, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/2/14 */
    { 0x0e03, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/3/0 */
    { 0x0e0b, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/3/2 */
    { 0x0e13, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/3/4 */
    { 0x0e1b, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/3/6 */
    { 0x0e23, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/3/8 */
    { 0x0e2b, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/3/10 */
    { 0x0e33, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/3/12 */
    { 0x0e3b, 0x6943, 0x4101, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_MIN }, /* #41/3/14 */
    { 0x0104, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/0/0 */
    { 0x010c, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/0/2 */
    { 0x0114, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/0/4 */
    { 0x011c, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/0/6 */
    { 0x0124, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/0/8 */
    { 0x012c, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/0/10 */
    { 0x0134, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/0/12 */
    { 0x013c, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/0/14 */
    { 0x0504, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/1/0 */
    { 0x050c, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/1/2 */
    { 0x0514, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/1/4 */
    { 0x051c, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/1/6 */
    { 0x0524, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/1/8 */
    { 0x052c, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/1/10 */
    { 0x0534, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/1/12 */
    { 0x053c, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/1/14 */
    { 0x0904, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/2/0 */
    { 0x090c, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/2/2 */
    { 0x0914, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/2/4 */
    { 0x091c, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/2/6 */
    { 0x0924, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/2/8 */
    { 0x092c, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/2/10 */
    { 0x0934, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/2/12 */
    { 0x093c, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/2/14 */
    { 0x0d04, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/3/0 */
    { 0x0d0c, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/3/2 */
    { 0x0d14, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/3/4 */
    { 0x0d1c, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/3/6 */
    { 0x0d24, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/3/8 */
    { 0x0d2c, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/3/10 */
    { 0x0d34, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/3/12 */
    { 0x0d3c, 0x6952, 0xf981, RTFLOAT80U_INIT_C(1,0xa1e2397f4588e2b2,32767), INT64_C(-3) }, /* #42/3/14 */
    { 0x0305, 0xbe9c, 0x84a0, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/0/0 */
    { 0x030d, 0xbe9c, 0x84a0, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/0/2 */
    { 0x0315, 0xbe9c, 0x84a0, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/0/4 */
    { 0x031d, 0xbe9c, 0x84a0, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/0/6 */
    { 0x0325, 0xbe9c, 0x0420, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/0/8 */
    { 0x032d, 0xbe9c, 0x0420, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/0/10 */
    { 0x0335, 0xbe9c, 0x0420, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/0/12 */
    { 0x033d, 0xbe9c, 0x0420, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/0/14 */
    { 0x0705, 0xbe9c, 0x84a0, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/1/0 */
    { 0x070d, 0xbe9c, 0x84a0, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/1/2 */
    { 0x0715, 0xbe9c, 0x84a0, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/1/4 */
    { 0x071d, 0xbe9c, 0x84a0, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/1/6 */
    { 0x0725, 0xbe9c, 0x0420, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/1/8 */
    { 0x072d, 0xbe9c, 0x0420, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/1/10 */
    { 0x0735, 0xbe9c, 0x0420, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/1/12 */
    { 0x073d, 0xbe9c, 0x0420, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/1/14 */
    { 0x0b05, 0xbe9c, 0x84a0, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/2/0 */
    { 0x0b0d, 0xbe9c, 0x84a0, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/2/2 */
    { 0x0b15, 0xbe9c, 0x84a0, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/2/4 */
    { 0x0b1d, 0xbe9c, 0x84a0, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/2/6 */
    { 0x0b25, 0xbe9c, 0x0420, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/2/8 */
    { 0x0b2d, 0xbe9c, 0x0420, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/2/10 */
    { 0x0b35, 0xbe9c, 0x0420, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/2/12 */
    { 0x0b3d, 0xbe9c, 0x0420, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/2/14 */
    { 0x0f05, 0xbe9c, 0x84a0, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/3/0 */
    { 0x0f0d, 0xbe9c, 0x84a0, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/3/2 */
    { 0x0f15, 0xbe9c, 0x84a0, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/3/4 */
    { 0x0f1d, 0xbe9c, 0x84a0, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/3/6 */
    { 0x0f25, 0xbe9c, 0x0420, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/3/8 */
    { 0x0f2d, 0xbe9c, 0x0420, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/3/10 */
    { 0x0f35, 0xbe9c, 0x0420, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/3/12 */
    { 0x0f3d, 0xbe9c, 0x0420, RTFLOAT80U_INIT_C(1,0xabca8cf2f3436c29,16383), INT64_C(-1) }, /* #43/3/14 */
    { 0x0347, 0xe62a, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/0/0 */
    { 0x034f, 0xe62a, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/0/2 */
    { 0x0357, 0xe62a, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/0/4 */
    { 0x035f, 0xe62a, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/0/6 */
    { 0x0367, 0xe62a, 0x4420, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/0/8 */
    { 0x036f, 0xe62a, 0x4420, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/0/10 */
    { 0x0377, 0xe62a, 0x4420, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/0/12 */
    { 0x037f, 0xe62a, 0x4420, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/0/14 */
    { 0x0747, 0xe62a, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/1/0 */
    { 0x074f, 0xe62a, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/1/2 */
    { 0x0757, 0xe62a, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/1/4 */
    { 0x075f, 0xe62a, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/1/6 */
    { 0x0767, 0xe62a, 0x4420, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/1/8 */
    { 0x076f, 0xe62a, 0x4420, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/1/10 */
    { 0x0777, 0xe62a, 0x4420, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/1/12 */
    { 0x077f, 0xe62a, 0x4420, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/1/14 */
    { 0x0b47, 0xe62a, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/2/0 */
    { 0x0b4f, 0xe62a, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/2/2 */
    { 0x0b57, 0xe62a, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/2/4 */
    { 0x0b5f, 0xe62a, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/2/6 */
    { 0x0b67, 0xe62a, 0x4420, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/2/8 */
    { 0x0b6f, 0xe62a, 0x4420, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/2/10 */
    { 0x0b77, 0xe62a, 0x4420, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/2/12 */
    { 0x0b7f, 0xe62a, 0x4420, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/2/14 */
    { 0x0f47, 0xe62a, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/3/0 */
    { 0x0f4f, 0xe62a, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/3/2 */
    { 0x0f57, 0xe62a, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/3/4 */
    { 0x0f5f, 0xe62a, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/3/6 */
    { 0x0f67, 0xe62a, 0x4420, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/3/8 */
    { 0x0f6f, 0xe62a, 0x4420, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/3/10 */
    { 0x0f77, 0xe62a, 0x4420, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/3/12 */
    { 0x0f7f, 0xe62a, 0x4420, RTFLOAT80U_INIT_C(0,0xb7275f667d656137,16445), INT64_C(6598811063413813403) }, /* #44/3/14 */
    { 0x0145, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/0/0 */
    { 0x014d, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/0/2 */
    { 0x0155, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/0/4 */
    { 0x015d, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/0/6 */
    { 0x0165, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/0/8 */
    { 0x016d, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/0/10 */
    { 0x0175, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/0/12 */
    { 0x017d, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/0/14 */
    { 0x0545, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/1/0 */
    { 0x054d, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/1/2 */
    { 0x0555, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/1/4 */
    { 0x055d, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/1/6 */
    { 0x0565, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/1/8 */
    { 0x056d, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/1/10 */
    { 0x0575, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/1/12 */
    { 0x057d, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/1/14 */
    { 0x0945, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/2/0 */
    { 0x094d, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/2/2 */
    { 0x0955, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/2/4 */
    { 0x095d, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/2/6 */
    { 0x0965, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/2/8 */
    { 0x096d, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/2/10 */
    { 0x0975, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/2/12 */
    { 0x097d, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/2/14 */
    { 0x0d45, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/3/0 */
    { 0x0d4d, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/3/2 */
    { 0x0d55, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/3/4 */
    { 0x0d5d, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/3/6 */
    { 0x0d65, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/3/8 */
    { 0x0d6d, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/3/10 */
    { 0x0d75, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/3/12 */
    { 0x0d7d, 0xa069, 0x0000, RTFLOAT80U_INIT_C(0,0xe15d4232a0b61c2a,16445), INT64_C(8119604308289981973) }, /* #45/3/14 */
    { 0x0304, 0xdcc4, 0xc4a0, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/0/0 */
    { 0x030c, 0xdcc4, 0xc4a0, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/0/2 */
    { 0x0314, 0xdcc4, 0xc4a0, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/0/4 */
    { 0x031c, 0xdcc4, 0xc4a0, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/0/6 */
    { 0x0324, 0xdcc4, 0x4420, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/0/8 */
    { 0x032c, 0xdcc4, 0x4420, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/0/10 */
    { 0x0334, 0xdcc4, 0x4420, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/0/12 */
    { 0x033c, 0xdcc4, 0x4420, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/0/14 */
    { 0x0704, 0xdcc4, 0xc4a0, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/1/0 */
    { 0x070c, 0xdcc4, 0xc4a0, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/1/2 */
    { 0x0714, 0xdcc4, 0xc4a0, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/1/4 */
    { 0x071c, 0xdcc4, 0xc4a0, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/1/6 */
    { 0x0724, 0xdcc4, 0x4420, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/1/8 */
    { 0x072c, 0xdcc4, 0x4420, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/1/10 */
    { 0x0734, 0xdcc4, 0x4420, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/1/12 */
    { 0x073c, 0xdcc4, 0x4420, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/1/14 */
    { 0x0b04, 0xdcc4, 0xc4a0, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/2/0 */
    { 0x0b0c, 0xdcc4, 0xc4a0, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/2/2 */
    { 0x0b14, 0xdcc4, 0xc4a0, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/2/4 */
    { 0x0b1c, 0xdcc4, 0xc4a0, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/2/6 */
    { 0x0b24, 0xdcc4, 0x4420, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/2/8 */
    { 0x0b2c, 0xdcc4, 0x4420, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/2/10 */
    { 0x0b34, 0xdcc4, 0x4420, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/2/12 */
    { 0x0b3c, 0xdcc4, 0x4420, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/2/14 */
    { 0x0f04, 0xdcc4, 0xc4a0, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/3/0 */
    { 0x0f0c, 0xdcc4, 0xc4a0, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/3/2 */
    { 0x0f14, 0xdcc4, 0xc4a0, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/3/4 */
    { 0x0f1c, 0xdcc4, 0xc4a0, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/3/6 */
    { 0x0f24, 0xdcc4, 0x4420, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/3/8 */
    { 0x0f2c, 0xdcc4, 0x4420, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/3/10 */
    { 0x0f34, 0xdcc4, 0x4420, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/3/12 */
    { 0x0f3c, 0xdcc4, 0x4420, RTFLOAT80U_INIT_C(0,0xbe8af9286f6f1cef,16445), INT64_C(6865030183027969655) }, /* #46/3/14 */
    { 0x0206, 0xa28f, 0x80a0, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/0/0 */
    { 0x020e, 0xa28f, 0x80a0, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/0/2 */
    { 0x0216, 0xa28f, 0x80a0, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/0/4 */
    { 0x021e, 0xa28f, 0x80a0, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/0/6 */
    { 0x0226, 0xa28f, 0x0020, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/0/8 */
    { 0x022e, 0xa28f, 0x0020, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/0/10 */
    { 0x0236, 0xa28f, 0x0020, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/0/12 */
    { 0x023e, 0xa28f, 0x0020, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/0/14 */
    { 0x0606, 0xa28f, 0x80a0, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/1/0 */
    { 0x060e, 0xa28f, 0x80a0, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/1/2 */
    { 0x0616, 0xa28f, 0x80a0, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/1/4 */
    { 0x061e, 0xa28f, 0x80a0, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/1/6 */
    { 0x0626, 0xa28f, 0x0020, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/1/8 */
    { 0x062e, 0xa28f, 0x0020, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/1/10 */
    { 0x0636, 0xa28f, 0x0020, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/1/12 */
    { 0x063e, 0xa28f, 0x0020, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/1/14 */
    { 0x0a06, 0xa28f, 0x80a0, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/2/0 */
    { 0x0a0e, 0xa28f, 0x80a0, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/2/2 */
    { 0x0a16, 0xa28f, 0x80a0, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/2/4 */
    { 0x0a1e, 0xa28f, 0x80a0, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/2/6 */
    { 0x0a26, 0xa28f, 0x0020, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/2/8 */
    { 0x0a2e, 0xa28f, 0x0020, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/2/10 */
    { 0x0a36, 0xa28f, 0x0020, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/2/12 */
    { 0x0a3e, 0xa28f, 0x0020, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/2/14 */
    { 0x0e06, 0xa28f, 0x80a0, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/3/0 */
    { 0x0e0e, 0xa28f, 0x80a0, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/3/2 */
    { 0x0e16, 0xa28f, 0x80a0, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/3/4 */
    { 0x0e1e, 0xa28f, 0x80a0, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/3/6 */
    { 0x0e26, 0xa28f, 0x0020, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/3/8 */
    { 0x0e2e, 0xa28f, 0x0020, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/3/10 */
    { 0x0e36, 0xa28f, 0x0020, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/3/12 */
    { 0x0e3e, 0xa28f, 0x0020, RTFLOAT80U_INIT_C(0,0xf100924e1d5b,0), INT64_C(0) }, /* #47/3/14 */
    { 0x0306, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/0/0 */
    { 0x030e, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/0/2 */
    { 0x0316, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/0/4 */
    { 0x031e, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/0/6 */
    { 0x0326, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/0/8 */
    { 0x032e, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/0/10 */
    { 0x0336, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/0/12 */
    { 0x033e, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/0/14 */
    { 0x0706, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/1/0 */
    { 0x070e, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/1/2 */
    { 0x0716, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/1/4 */
    { 0x071e, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/1/6 */
    { 0x0726, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/1/8 */
    { 0x072e, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/1/10 */
    { 0x0736, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/1/12 */
    { 0x073e, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/1/14 */
    { 0x0b06, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/2/0 */
    { 0x0b0e, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/2/2 */
    { 0x0b16, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/2/4 */
    { 0x0b1e, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/2/6 */
    { 0x0b26, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/2/8 */
    { 0x0b2e, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/2/10 */
    { 0x0b36, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/2/12 */
    { 0x0b3e, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/2/14 */
    { 0x0f06, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/3/0 */
    { 0x0f0e, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/3/2 */
    { 0x0f16, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/3/4 */
    { 0x0f1e, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/3/6 */
    { 0x0f26, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/3/8 */
    { 0x0f2e, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/3/10 */
    { 0x0f36, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/3/12 */
    { 0x0f3e, 0x3e0a, 0xbc81, RTFLOAT80U_INIT_C(1,0xd0e39bcfb8d4b58,32767), INT64_C(-3) }, /* #48/3/14 */
    { 0x0006, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/0/0 */
    { 0x000e, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/0/2 */
    { 0x0016, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/0/4 */
    { 0x001e, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/0/6 */
    { 0x0026, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/0/8 */
    { 0x002e, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/0/10 */
    { 0x0036, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/0/12 */
    { 0x003e, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/0/14 */
    { 0x0406, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/1/0 */
    { 0x040e, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/1/2 */
    { 0x0416, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/1/4 */
    { 0x041e, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/1/6 */
    { 0x0426, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/1/8 */
    { 0x042e, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/1/10 */
    { 0x0436, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/1/12 */
    { 0x043e, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/1/14 */
    { 0x0806, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/2/0 */
    { 0x080e, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/2/2 */
    { 0x0816, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/2/4 */
    { 0x081e, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/2/6 */
    { 0x0826, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/2/8 */
    { 0x082e, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/2/10 */
    { 0x0836, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/2/12 */
    { 0x083e, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/2/14 */
    { 0x0c06, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/3/0 */
    { 0x0c0e, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/3/2 */
    { 0x0c16, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/3/4 */
    { 0x0c1e, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/3/6 */
    { 0x0c26, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/3/8 */
    { 0x0c2e, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/3/10 */
    { 0x0c36, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/3/12 */
    { 0x0c3e, 0xae41, 0xbc81, RTFLOAT80U_INIT_C(0,0x5ea7106610e79,9025), INT64_C(-3) }, /* #49/3/14 */
    { 0x0347, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/0/0 */
    { 0x034f, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/0/2 */
    { 0x0357, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/0/4 */
    { 0x035f, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/0/6 */
    { 0x0367, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/0/8 */
    { 0x036f, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/0/10 */
    { 0x0377, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/0/12 */
    { 0x037f, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/0/14 */
    { 0x0747, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/1/0 */
    { 0x074f, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/1/2 */
    { 0x0757, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/1/4 */
    { 0x075f, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/1/6 */
    { 0x0767, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/1/8 */
    { 0x076f, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/1/10 */
    { 0x0777, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/1/12 */
    { 0x077f, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/1/14 */
    { 0x0b47, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/2/0 */
    { 0x0b4f, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/2/2 */
    { 0x0b57, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/2/4 */
    { 0x0b5f, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/2/6 */
    { 0x0b67, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/2/8 */
    { 0x0b6f, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/2/10 */
    { 0x0b77, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/2/12 */
    { 0x0b7f, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/2/14 */
    { 0x0f47, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/3/0 */
    { 0x0f4f, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/3/2 */
    { 0x0f57, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/3/4 */
    { 0x0f5f, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/3/6 */
    { 0x0f67, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/3/8 */
    { 0x0f6f, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/3/10 */
    { 0x0f77, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/3/12 */
    { 0x0f7f, 0x215e, 0x0101, RTFLOAT80U_INIT_C(1,0x861e573154aa34a1,19948), INT64_MIN }, /* #50/3/14 */
    { 0x0142, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/0/0 */
    { 0x014a, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/0/2 */
    { 0x0152, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/0/4 */
    { 0x015a, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/0/6 */
    { 0x0162, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/0/8 */
    { 0x016a, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/0/10 */
    { 0x0172, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/0/12 */
    { 0x017a, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/0/14 */
    { 0x0542, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/1/0 */
    { 0x054a, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/1/2 */
    { 0x0552, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/1/4 */
    { 0x055a, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/1/6 */
    { 0x0562, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/1/8 */
    { 0x056a, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/1/10 */
    { 0x0572, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/1/12 */
    { 0x057a, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/1/14 */
    { 0x0942, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/2/0 */
    { 0x094a, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/2/2 */
    { 0x0952, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/2/4 */
    { 0x095a, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/2/6 */
    { 0x0962, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/2/8 */
    { 0x096a, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/2/10 */
    { 0x0972, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/2/12 */
    { 0x097a, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/2/14 */
    { 0x0d42, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/3/0 */
    { 0x0d4a, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/3/2 */
    { 0x0d52, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/3/4 */
    { 0x0d5a, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/3/6 */
    { 0x0d62, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/3/8 */
    { 0x0d6a, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/3/10 */
    { 0x0d72, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/3/12 */
    { 0x0d7a, 0x3b84, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #51/3/14 */
    { 0x0100, 0xe687, 0xc4a0, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/0/0 */
    { 0x0108, 0xe687, 0xc4a0, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/0/2 */
    { 0x0110, 0xe687, 0xc4a0, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/0/4 */
    { 0x0118, 0xe687, 0xc4a0, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/0/6 */
    { 0x0120, 0xe687, 0x4420, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/0/8 */
    { 0x0128, 0xe687, 0x4420, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/0/10 */
    { 0x0130, 0xe687, 0x4420, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/0/12 */
    { 0x0138, 0xe687, 0x4420, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/0/14 */
    { 0x0500, 0xe687, 0xc4a0, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/1/0 */
    { 0x0508, 0xe687, 0xc4a0, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/1/2 */
    { 0x0510, 0xe687, 0xc4a0, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/1/4 */
    { 0x0518, 0xe687, 0xc4a0, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/1/6 */
    { 0x0520, 0xe687, 0x4420, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/1/8 */
    { 0x0528, 0xe687, 0x4420, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/1/10 */
    { 0x0530, 0xe687, 0x4420, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/1/12 */
    { 0x0538, 0xe687, 0x4420, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/1/14 */
    { 0x0900, 0xe687, 0xc4a0, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/2/0 */
    { 0x0908, 0xe687, 0xc4a0, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/2/2 */
    { 0x0910, 0xe687, 0xc4a0, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/2/4 */
    { 0x0918, 0xe687, 0xc4a0, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/2/6 */
    { 0x0920, 0xe687, 0x4420, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/2/8 */
    { 0x0928, 0xe687, 0x4420, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/2/10 */
    { 0x0930, 0xe687, 0x4420, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/2/12 */
    { 0x0938, 0xe687, 0x4420, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/2/14 */
    { 0x0d00, 0xe687, 0xc4a0, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/3/0 */
    { 0x0d08, 0xe687, 0xc4a0, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/3/2 */
    { 0x0d10, 0xe687, 0xc4a0, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/3/4 */
    { 0x0d18, 0xe687, 0xc4a0, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/3/6 */
    { 0x0d20, 0xe687, 0x4420, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/3/8 */
    { 0x0d28, 0xe687, 0x4420, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/3/10 */
    { 0x0d30, 0xe687, 0x4420, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/3/12 */
    { 0x0d38, 0xe687, 0x4420, RTFLOAT80U_INIT_C(1,0x64c74964bf1be323,0), INT64_C(0) }, /* #52/3/14 */
    { 0x0206, 0x5f23, 0xc5a0, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/0/0 */
    { 0x020e, 0x5f23, 0xc5a0, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/0/2 */
    { 0x0216, 0x5f23, 0xc5a0, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/0/4 */
    { 0x021e, 0x5f23, 0xc5a0, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/0/6 */
    { 0x0226, 0x5f23, 0x4520, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/0/8 */
    { 0x022e, 0x5f23, 0x4520, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/0/10 */
    { 0x0236, 0x5f23, 0x4520, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/0/12 */
    { 0x023e, 0x5f23, 0x4520, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/0/14 */
    { 0x0606, 0x5f23, 0xc5a0, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/1/0 */
    { 0x060e, 0x5f23, 0xc5a0, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/1/2 */
    { 0x0616, 0x5f23, 0xc5a0, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/1/4 */
    { 0x061e, 0x5f23, 0xc5a0, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/1/6 */
    { 0x0626, 0x5f23, 0x4520, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/1/8 */
    { 0x062e, 0x5f23, 0x4520, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/1/10 */
    { 0x0636, 0x5f23, 0x4520, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/1/12 */
    { 0x063e, 0x5f23, 0x4520, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/1/14 */
    { 0x0a06, 0x5f23, 0xc5a0, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/2/0 */
    { 0x0a0e, 0x5f23, 0xc5a0, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/2/2 */
    { 0x0a16, 0x5f23, 0xc5a0, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/2/4 */
    { 0x0a1e, 0x5f23, 0xc5a0, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/2/6 */
    { 0x0a26, 0x5f23, 0x4520, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/2/8 */
    { 0x0a2e, 0x5f23, 0x4520, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/2/10 */
    { 0x0a36, 0x5f23, 0x4520, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/2/12 */
    { 0x0a3e, 0x5f23, 0x4520, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/2/14 */
    { 0x0e06, 0x5f23, 0xc5a0, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/3/0 */
    { 0x0e0e, 0x5f23, 0xc5a0, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/3/2 */
    { 0x0e16, 0x5f23, 0xc5a0, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/3/4 */
    { 0x0e1e, 0x5f23, 0xc5a0, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/3/6 */
    { 0x0e26, 0x5f23, 0x4520, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/3/8 */
    { 0x0e2e, 0x5f23, 0x4520, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/3/10 */
    { 0x0e36, 0x5f23, 0x4520, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/3/12 */
    { 0x0e3e, 0x5f23, 0x4520, RTFLOAT80U_INIT_C(1,0x892097ce2a671358,0), INT64_C(0) }, /* #53/3/14 */
    { 0x0140, 0x0a12, 0x80a0, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/0/0 */
    { 0x0148, 0x0a12, 0x80a0, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/0/2 */
    { 0x0150, 0x0a12, 0x80a0, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/0/4 */
    { 0x0158, 0x0a12, 0x80a0, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/0/6 */
    { 0x0160, 0x0a12, 0x0020, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/0/8 */
    { 0x0168, 0x0a12, 0x0020, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/0/10 */
    { 0x0170, 0x0a12, 0x0020, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/0/12 */
    { 0x0178, 0x0a12, 0x0020, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/0/14 */
    { 0x0540, 0x0a12, 0x80a0, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/1/0 */
    { 0x0548, 0x0a12, 0x80a0, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/1/2 */
    { 0x0550, 0x0a12, 0x80a0, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/1/4 */
    { 0x0558, 0x0a12, 0x80a0, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/1/6 */
    { 0x0560, 0x0a12, 0x0020, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/1/8 */
    { 0x0568, 0x0a12, 0x0020, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/1/10 */
    { 0x0570, 0x0a12, 0x0020, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/1/12 */
    { 0x0578, 0x0a12, 0x0020, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/1/14 */
    { 0x0940, 0x0a12, 0x80a0, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/2/0 */
    { 0x0948, 0x0a12, 0x80a0, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/2/2 */
    { 0x0950, 0x0a12, 0x80a0, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/2/4 */
    { 0x0958, 0x0a12, 0x80a0, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/2/6 */
    { 0x0960, 0x0a12, 0x0020, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/2/8 */
    { 0x0968, 0x0a12, 0x0020, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/2/10 */
    { 0x0970, 0x0a12, 0x0020, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/2/12 */
    { 0x0978, 0x0a12, 0x0020, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/2/14 */
    { 0x0d40, 0x0a12, 0x80a0, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/3/0 */
    { 0x0d48, 0x0a12, 0x80a0, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/3/2 */
    { 0x0d50, 0x0a12, 0x80a0, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/3/4 */
    { 0x0d58, 0x0a12, 0x80a0, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/3/6 */
    { 0x0d60, 0x0a12, 0x0020, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/3/8 */
    { 0x0d68, 0x0a12, 0x0020, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/3/10 */
    { 0x0d70, 0x0a12, 0x0020, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/3/12 */
    { 0x0d78, 0x0a12, 0x0020, RTFLOAT80U_INIT_C(1,0xed7ad572a6c672cc,16383), INT64_C(-1) }, /* #54/3/14 */
    { 0x0304, 0xd603, 0xc4a0, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/0/0 */
    { 0x030c, 0xd603, 0xc4a0, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/0/2 */
    { 0x0314, 0xd603, 0xc4a0, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/0/4 */
    { 0x031c, 0xd603, 0xc4a0, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/0/6 */
    { 0x0324, 0xd603, 0x4420, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/0/8 */
    { 0x032c, 0xd603, 0x4420, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/0/10 */
    { 0x0334, 0xd603, 0x4420, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/0/12 */
    { 0x033c, 0xd603, 0x4420, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/0/14 */
    { 0x0704, 0xd603, 0xc4a0, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/1/0 */
    { 0x070c, 0xd603, 0xc4a0, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/1/2 */
    { 0x0714, 0xd603, 0xc4a0, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/1/4 */
    { 0x071c, 0xd603, 0xc4a0, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/1/6 */
    { 0x0724, 0xd603, 0x4420, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/1/8 */
    { 0x072c, 0xd603, 0x4420, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/1/10 */
    { 0x0734, 0xd603, 0x4420, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/1/12 */
    { 0x073c, 0xd603, 0x4420, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/1/14 */
    { 0x0b04, 0xd603, 0xc4a0, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/2/0 */
    { 0x0b0c, 0xd603, 0xc4a0, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/2/2 */
    { 0x0b14, 0xd603, 0xc4a0, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/2/4 */
    { 0x0b1c, 0xd603, 0xc4a0, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/2/6 */
    { 0x0b24, 0xd603, 0x4420, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/2/8 */
    { 0x0b2c, 0xd603, 0x4420, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/2/10 */
    { 0x0b34, 0xd603, 0x4420, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/2/12 */
    { 0x0b3c, 0xd603, 0x4420, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/2/14 */
    { 0x0f04, 0xd603, 0xc4a0, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/3/0 */
    { 0x0f0c, 0xd603, 0xc4a0, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/3/2 */
    { 0x0f14, 0xd603, 0xc4a0, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/3/4 */
    { 0x0f1c, 0xd603, 0xc4a0, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/3/6 */
    { 0x0f24, 0xd603, 0x4420, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/3/8 */
    { 0x0f2c, 0xd603, 0x4420, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/3/10 */
    { 0x0f34, 0xd603, 0x4420, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/3/12 */
    { 0x0f3c, 0xd603, 0x4420, RTFLOAT80U_INIT_C(1,0x69f766ca2f2d6909,0), INT64_C(0) }, /* #55/3/14 */
    { 0x0244, 0xa9b9, 0x81a0, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/0/0 */
    { 0x024c, 0xa9b9, 0x81a0, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/0/2 */
    { 0x0254, 0xa9b9, 0x81a0, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/0/4 */
    { 0x025c, 0xa9b9, 0x81a0, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/0/6 */
    { 0x0264, 0xa9b9, 0x0120, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/0/8 */
    { 0x026c, 0xa9b9, 0x0120, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/0/10 */
    { 0x0274, 0xa9b9, 0x0120, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/0/12 */
    { 0x027c, 0xa9b9, 0x0120, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/0/14 */
    { 0x0644, 0xa9b9, 0x81a0, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/1/0 */
    { 0x064c, 0xa9b9, 0x81a0, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/1/2 */
    { 0x0654, 0xa9b9, 0x81a0, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/1/4 */
    { 0x065c, 0xa9b9, 0x81a0, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/1/6 */
    { 0x0664, 0xa9b9, 0x0120, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/1/8 */
    { 0x066c, 0xa9b9, 0x0120, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/1/10 */
    { 0x0674, 0xa9b9, 0x0120, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/1/12 */
    { 0x067c, 0xa9b9, 0x0120, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/1/14 */
    { 0x0a44, 0xa9b9, 0x81a0, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/2/0 */
    { 0x0a4c, 0xa9b9, 0x81a0, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/2/2 */
    { 0x0a54, 0xa9b9, 0x81a0, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/2/4 */
    { 0x0a5c, 0xa9b9, 0x81a0, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/2/6 */
    { 0x0a64, 0xa9b9, 0x0120, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/2/8 */
    { 0x0a6c, 0xa9b9, 0x0120, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/2/10 */
    { 0x0a74, 0xa9b9, 0x0120, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/2/12 */
    { 0x0a7c, 0xa9b9, 0x0120, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/2/14 */
    { 0x0e44, 0xa9b9, 0x81a0, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/3/0 */
    { 0x0e4c, 0xa9b9, 0x81a0, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/3/2 */
    { 0x0e54, 0xa9b9, 0x81a0, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/3/4 */
    { 0x0e5c, 0xa9b9, 0x81a0, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/3/6 */
    { 0x0e64, 0xa9b9, 0x0120, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/3/8 */
    { 0x0e6c, 0xa9b9, 0x0120, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/3/10 */
    { 0x0e74, 0xa9b9, 0x0120, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/3/12 */
    { 0x0e7c, 0xa9b9, 0x0120, RTFLOAT80U_INIT_C(1,0xac1e60e256f0241d,16445), INT64_C(-6201228474531189262) }, /* #56/3/14 */
    { 0x0043, 0x4b15, 0xc1a0, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/0/0 */
    { 0x004b, 0x4b15, 0xc1a0, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/0/2 */
    { 0x0053, 0x4b15, 0xc1a0, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/0/4 */
    { 0x005b, 0x4b15, 0xc1a0, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/0/6 */
    { 0x0063, 0x4b15, 0x4120, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/0/8 */
    { 0x006b, 0x4b15, 0x4120, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/0/10 */
    { 0x0073, 0x4b15, 0x4120, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/0/12 */
    { 0x007b, 0x4b15, 0x4120, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/0/14 */
    { 0x0443, 0x4b15, 0xc1a0, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/1/0 */
    { 0x044b, 0x4b15, 0xc1a0, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/1/2 */
    { 0x0453, 0x4b15, 0xc1a0, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/1/4 */
    { 0x045b, 0x4b15, 0xc1a0, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/1/6 */
    { 0x0463, 0x4b15, 0x4120, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/1/8 */
    { 0x046b, 0x4b15, 0x4120, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/1/10 */
    { 0x0473, 0x4b15, 0x4120, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/1/12 */
    { 0x047b, 0x4b15, 0x4120, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/1/14 */
    { 0x0843, 0x4b15, 0xc1a0, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/2/0 */
    { 0x084b, 0x4b15, 0xc1a0, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/2/2 */
    { 0x0853, 0x4b15, 0xc1a0, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/2/4 */
    { 0x085b, 0x4b15, 0xc1a0, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/2/6 */
    { 0x0863, 0x4b15, 0x4120, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/2/8 */
    { 0x086b, 0x4b15, 0x4120, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/2/10 */
    { 0x0873, 0x4b15, 0x4120, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/2/12 */
    { 0x087b, 0x4b15, 0x4120, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/2/14 */
    { 0x0c43, 0x4b15, 0xc1a0, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/3/0 */
    { 0x0c4b, 0x4b15, 0xc1a0, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/3/2 */
    { 0x0c53, 0x4b15, 0xc1a0, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/3/4 */
    { 0x0c5b, 0x4b15, 0xc1a0, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/3/6 */
    { 0x0c63, 0x4b15, 0x4120, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/3/8 */
    { 0x0c6b, 0x4b15, 0x4120, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/3/10 */
    { 0x0c73, 0x4b15, 0x4120, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/3/12 */
    { 0x0c7b, 0x4b15, 0x4120, RTFLOAT80U_INIT_C(0,0x296c0e0fe8c5f487,0), INT64_C(0) }, /* #57/3/14 */
    { 0x0046, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/0/0 */
    { 0x004e, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/0/2 */
    { 0x0056, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/0/4 */
    { 0x005e, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/0/6 */
    { 0x0066, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/0/8 */
    { 0x006e, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/0/10 */
    { 0x0076, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/0/12 */
    { 0x007e, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/0/14 */
    { 0x0446, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/1/0 */
    { 0x044e, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/1/2 */
    { 0x0456, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/1/4 */
    { 0x045e, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/1/6 */
    { 0x0466, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/1/8 */
    { 0x046e, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/1/10 */
    { 0x0476, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/1/12 */
    { 0x047e, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/1/14 */
    { 0x0846, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/2/0 */
    { 0x084e, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/2/2 */
    { 0x0856, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/2/4 */
    { 0x085e, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/2/6 */
    { 0x0866, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/2/8 */
    { 0x086e, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/2/10 */
    { 0x0876, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/2/12 */
    { 0x087e, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/2/14 */
    { 0x0c46, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/3/0 */
    { 0x0c4e, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/3/2 */
    { 0x0c56, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/3/4 */
    { 0x0c5e, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/3/6 */
    { 0x0c66, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/3/8 */
    { 0x0c6e, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/3/10 */
    { 0x0c76, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/3/12 */
    { 0x0c7e, 0x5073, 0xf881, RTFLOAT80U_INIT_C(1,0x47f1363a4534c330,6673), INT64_C(-3) }, /* #58/3/14 */
    { 0x0105, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/0/0 */
    { 0x010d, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/0/2 */
    { 0x0115, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/0/4 */
    { 0x011d, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/0/6 */
    { 0x0125, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/0/8 */
    { 0x012d, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/0/10 */
    { 0x0135, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/0/12 */
    { 0x013d, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/0/14 */
    { 0x0505, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/1/0 */
    { 0x050d, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/1/2 */
    { 0x0515, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/1/4 */
    { 0x051d, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/1/6 */
    { 0x0525, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/1/8 */
    { 0x052d, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/1/10 */
    { 0x0535, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/1/12 */
    { 0x053d, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/1/14 */
    { 0x0905, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/2/0 */
    { 0x090d, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/2/2 */
    { 0x0915, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/2/4 */
    { 0x091d, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/2/6 */
    { 0x0925, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/2/8 */
    { 0x092d, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/2/10 */
    { 0x0935, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/2/12 */
    { 0x093d, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/2/14 */
    { 0x0d05, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/3/0 */
    { 0x0d0d, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/3/2 */
    { 0x0d15, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/3/4 */
    { 0x0d1d, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/3/6 */
    { 0x0d25, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/3/8 */
    { 0x0d2d, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/3/10 */
    { 0x0d35, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/3/12 */
    { 0x0d3d, 0xdcb2, 0x4401, RTFLOAT80U_INIT_C(0,0x5a80d329db02ac92,25784), INT64_MIN }, /* #59/3/14 */
    { 0x0005, 0x6e9d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/0/0 */
    { 0x000d, 0x6e9d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/0/2 */
    { 0x0015, 0x6e9d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/0/4 */
    { 0x001d, 0x6e9d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/0/6 */
    { 0x0025, 0x6e9d, 0x4420, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/0/8 */
    { 0x002d, 0x6e9d, 0x4420, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/0/10 */
    { 0x0035, 0x6e9d, 0x4420, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/0/12 */
    { 0x003d, 0x6e9d, 0x4420, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/0/14 */
    { 0x0405, 0x6e9d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/1/0 */
    { 0x040d, 0x6e9d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/1/2 */
    { 0x0415, 0x6e9d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/1/4 */
    { 0x041d, 0x6e9d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/1/6 */
    { 0x0425, 0x6e9d, 0x4420, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/1/8 */
    { 0x042d, 0x6e9d, 0x4420, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/1/10 */
    { 0x0435, 0x6e9d, 0x4420, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/1/12 */
    { 0x043d, 0x6e9d, 0x4420, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/1/14 */
    { 0x0805, 0x6e9d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/2/0 */
    { 0x080d, 0x6e9d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/2/2 */
    { 0x0815, 0x6e9d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/2/4 */
    { 0x081d, 0x6e9d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/2/6 */
    { 0x0825, 0x6e9d, 0x4420, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/2/8 */
    { 0x082d, 0x6e9d, 0x4420, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/2/10 */
    { 0x0835, 0x6e9d, 0x4420, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/2/12 */
    { 0x083d, 0x6e9d, 0x4420, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/2/14 */
    { 0x0c05, 0x6e9d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/3/0 */
    { 0x0c0d, 0x6e9d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/3/2 */
    { 0x0c15, 0x6e9d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/3/4 */
    { 0x0c1d, 0x6e9d, 0xc4a0, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/3/6 */
    { 0x0c25, 0x6e9d, 0x4420, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/3/8 */
    { 0x0c2d, 0x6e9d, 0x4420, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/3/10 */
    { 0x0c35, 0x6e9d, 0x4420, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/3/12 */
    { 0x0c3d, 0x6e9d, 0x4420, RTFLOAT80U_INIT_C(0,0xcfcae7cbab53bb7d,16383), INT64_C(1) }, /* #60/3/14 */
    { 0x0045, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/0/0 */
    { 0x004d, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/0/2 */
    { 0x0055, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/0/4 */
    { 0x005d, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/0/6 */
    { 0x0065, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/0/8 */
    { 0x006d, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/0/10 */
    { 0x0075, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/0/12 */
    { 0x007d, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/0/14 */
    { 0x0445, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/1/0 */
    { 0x044d, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/1/2 */
    { 0x0455, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/1/4 */
    { 0x045d, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/1/6 */
    { 0x0465, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/1/8 */
    { 0x046d, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/1/10 */
    { 0x0475, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/1/12 */
    { 0x047d, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/1/14 */
    { 0x0845, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/2/0 */
    { 0x084d, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/2/2 */
    { 0x0855, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/2/4 */
    { 0x085d, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/2/6 */
    { 0x0865, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/2/8 */
    { 0x086d, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/2/10 */
    { 0x0875, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/2/12 */
    { 0x087d, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/2/14 */
    { 0x0c45, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/3/0 */
    { 0x0c4d, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/3/2 */
    { 0x0c55, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/3/4 */
    { 0x0c5d, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/3/6 */
    { 0x0c65, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/3/8 */
    { 0x0c6d, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/3/10 */
    { 0x0c75, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/3/12 */
    { 0x0c7d, 0xcac3, 0x4001, RTFLOAT80U_INIT_C(1,0xc00000059a79e090,32767), INT64_MIN }, /* #61/3/14 */
    { 0x0144, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/0/0 */
    { 0x014c, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/0/2 */
    { 0x0154, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/0/4 */
    { 0x015c, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/0/6 */
    { 0x0164, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/0/8 */
    { 0x016c, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/0/10 */
    { 0x0174, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/0/12 */
    { 0x017c, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/0/14 */
    { 0x0544, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/1/0 */
    { 0x054c, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/1/2 */
    { 0x0554, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/1/4 */
    { 0x055c, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/1/6 */
    { 0x0564, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/1/8 */
    { 0x056c, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/1/10 */
    { 0x0574, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/1/12 */
    { 0x057c, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/1/14 */
    { 0x0944, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/2/0 */
    { 0x094c, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/2/2 */
    { 0x0954, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/2/4 */
    { 0x095c, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/2/6 */
    { 0x0964, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/2/8 */
    { 0x096c, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/2/10 */
    { 0x0974, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/2/12 */
    { 0x097c, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/2/14 */
    { 0x0d44, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/3/0 */
    { 0x0d4c, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/3/2 */
    { 0x0d54, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/3/4 */
    { 0x0d5c, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/3/6 */
    { 0x0d64, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/3/8 */
    { 0x0d6c, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/3/10 */
    { 0x0d74, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/3/12 */
    { 0x0d7c, 0xfb4d, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT64_C(-3) }, /* #62/3/14 */
    { 0x0301, 0x37ec, 0x85a0, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/0/0 */
    { 0x0309, 0x37ec, 0x85a0, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/0/2 */
    { 0x0311, 0x37ec, 0x85a0, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/0/4 */
    { 0x0319, 0x37ec, 0x85a0, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/0/6 */
    { 0x0321, 0x37ec, 0x0520, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/0/8 */
    { 0x0329, 0x37ec, 0x0520, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/0/10 */
    { 0x0331, 0x37ec, 0x0520, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/0/12 */
    { 0x0339, 0x37ec, 0x0520, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/0/14 */
    { 0x0701, 0x37ec, 0x85a0, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/1/0 */
    { 0x0709, 0x37ec, 0x85a0, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/1/2 */
    { 0x0711, 0x37ec, 0x85a0, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/1/4 */
    { 0x0719, 0x37ec, 0x85a0, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/1/6 */
    { 0x0721, 0x37ec, 0x0520, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/1/8 */
    { 0x0729, 0x37ec, 0x0520, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/1/10 */
    { 0x0731, 0x37ec, 0x0520, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/1/12 */
    { 0x0739, 0x37ec, 0x0520, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/1/14 */
    { 0x0b01, 0x37ec, 0x85a0, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/2/0 */
    { 0x0b09, 0x37ec, 0x85a0, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/2/2 */
    { 0x0b11, 0x37ec, 0x85a0, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/2/4 */
    { 0x0b19, 0x37ec, 0x85a0, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/2/6 */
    { 0x0b21, 0x37ec, 0x0520, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/2/8 */
    { 0x0b29, 0x37ec, 0x0520, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/2/10 */
    { 0x0b31, 0x37ec, 0x0520, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/2/12 */
    { 0x0b39, 0x37ec, 0x0520, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/2/14 */
    { 0x0f01, 0x37ec, 0x85a0, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/3/0 */
    { 0x0f09, 0x37ec, 0x85a0, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/3/2 */
    { 0x0f11, 0x37ec, 0x85a0, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/3/4 */
    { 0x0f19, 0x37ec, 0x85a0, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/3/6 */
    { 0x0f21, 0x37ec, 0x0520, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/3/8 */
    { 0x0f29, 0x37ec, 0x0520, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/3/10 */
    { 0x0f31, 0x37ec, 0x0520, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/3/12 */
    { 0x0f39, 0x37ec, 0x0520, RTFLOAT80U_INIT_C(0,0xb79cab850eef7a79,16445), INT64_C(6615319196638625084) }, /* #63/3/14 */
    { 0x0206, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/0/0 */
    { 0x020e, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/0/2 */
    { 0x0216, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/0/4 */
    { 0x021e, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/0/6 */
    { 0x0226, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/0/8 */
    { 0x022e, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/0/10 */
    { 0x0236, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/0/12 */
    { 0x023e, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/0/14 */
    { 0x0606, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/1/0 */
    { 0x060e, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/1/2 */
    { 0x0616, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/1/4 */
    { 0x061e, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/1/6 */
    { 0x0626, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/1/8 */
    { 0x062e, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/1/10 */
    { 0x0636, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/1/12 */
    { 0x063e, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/1/14 */
    { 0x0a06, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/2/0 */
    { 0x0a0e, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/2/2 */
    { 0x0a16, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/2/4 */
    { 0x0a1e, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/2/6 */
    { 0x0a26, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/2/8 */
    { 0x0a2e, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/2/10 */
    { 0x0a36, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/2/12 */
    { 0x0a3e, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/2/14 */
    { 0x0e06, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/3/0 */
    { 0x0e0e, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/3/2 */
    { 0x0e16, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/3/4 */
    { 0x0e1e, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/3/6 */
    { 0x0e26, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/3/8 */
    { 0x0e2e, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/3/10 */
    { 0x0e36, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/3/12 */
    { 0x0e3e, 0x5215, 0xf881, RTFLOAT80U_INIT_C(1,0x18f07bf87dd39e7a,13639), INT64_C(-3) }, /* #64/3/14 */
    { 0x0347, 0xaca8, 0x84a0, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/0/0 */
    { 0x034f, 0xaca8, 0x84a0, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/0/2 */
    { 0x0357, 0xaca8, 0x84a0, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/0/4 */
    { 0x035f, 0xaca8, 0x84a0, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/0/6 */
    { 0x0367, 0xaca8, 0x0420, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/0/8 */
    { 0x036f, 0xaca8, 0x0420, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/0/10 */
    { 0x0377, 0xaca8, 0x0420, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/0/12 */
    { 0x037f, 0xaca8, 0x0420, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/0/14 */
    { 0x0747, 0xaca8, 0x84a0, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/1/0 */
    { 0x074f, 0xaca8, 0x84a0, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/1/2 */
    { 0x0757, 0xaca8, 0x84a0, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/1/4 */
    { 0x075f, 0xaca8, 0x84a0, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/1/6 */
    { 0x0767, 0xaca8, 0x0420, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/1/8 */
    { 0x076f, 0xaca8, 0x0420, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/1/10 */
    { 0x0777, 0xaca8, 0x0420, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/1/12 */
    { 0x077f, 0xaca8, 0x0420, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/1/14 */
    { 0x0b47, 0xaca8, 0x84a0, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/2/0 */
    { 0x0b4f, 0xaca8, 0x84a0, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/2/2 */
    { 0x0b57, 0xaca8, 0x84a0, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/2/4 */
    { 0x0b5f, 0xaca8, 0x84a0, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/2/6 */
    { 0x0b67, 0xaca8, 0x0420, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/2/8 */
    { 0x0b6f, 0xaca8, 0x0420, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/2/10 */
    { 0x0b77, 0xaca8, 0x0420, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/2/12 */
    { 0x0b7f, 0xaca8, 0x0420, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/2/14 */
    { 0x0f47, 0xaca8, 0x84a0, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/3/0 */
    { 0x0f4f, 0xaca8, 0x84a0, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/3/2 */
    { 0x0f57, 0xaca8, 0x84a0, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/3/4 */
    { 0x0f5f, 0xaca8, 0x84a0, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/3/6 */
    { 0x0f67, 0xaca8, 0x0420, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/3/8 */
    { 0x0f6f, 0xaca8, 0x0420, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/3/10 */
    { 0x0f77, 0xaca8, 0x0420, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/3/12 */
    { 0x0f7f, 0xaca8, 0x0420, RTFLOAT80U_INIT_C(1,0x8e34a7c497747904,16383), INT64_C(-1) }, /* #65/3/14 */
    { 0x0344, 0x8599, 0x85a0, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/0/0 */
    { 0x034c, 0x8599, 0x85a0, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/0/2 */
    { 0x0354, 0x8599, 0x85a0, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/0/4 */
    { 0x035c, 0x8599, 0x85a0, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/0/6 */
    { 0x0364, 0x8599, 0x0520, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/0/8 */
    { 0x036c, 0x8599, 0x0520, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/0/10 */
    { 0x0374, 0x8599, 0x0520, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/0/12 */
    { 0x037c, 0x8599, 0x0520, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/0/14 */
    { 0x0744, 0x8599, 0x85a0, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/1/0 */
    { 0x074c, 0x8599, 0x85a0, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/1/2 */
    { 0x0754, 0x8599, 0x85a0, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/1/4 */
    { 0x075c, 0x8599, 0x85a0, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/1/6 */
    { 0x0764, 0x8599, 0x0520, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/1/8 */
    { 0x076c, 0x8599, 0x0520, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/1/10 */
    { 0x0774, 0x8599, 0x0520, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/1/12 */
    { 0x077c, 0x8599, 0x0520, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/1/14 */
    { 0x0b44, 0x8599, 0x85a0, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/2/0 */
    { 0x0b4c, 0x8599, 0x85a0, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/2/2 */
    { 0x0b54, 0x8599, 0x85a0, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/2/4 */
    { 0x0b5c, 0x8599, 0x85a0, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/2/6 */
    { 0x0b64, 0x8599, 0x0520, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/2/8 */
    { 0x0b6c, 0x8599, 0x0520, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/2/10 */
    { 0x0b74, 0x8599, 0x0520, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/2/12 */
    { 0x0b7c, 0x8599, 0x0520, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/2/14 */
    { 0x0f44, 0x8599, 0x85a0, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/3/0 */
    { 0x0f4c, 0x8599, 0x85a0, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/3/2 */
    { 0x0f54, 0x8599, 0x85a0, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/3/4 */
    { 0x0f5c, 0x8599, 0x85a0, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/3/6 */
    { 0x0f64, 0x8599, 0x0520, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/3/8 */
    { 0x0f6c, 0x8599, 0x0520, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/3/10 */
    { 0x0f74, 0x8599, 0x0520, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/3/12 */
    { 0x0f7c, 0x8599, 0x0520, RTFLOAT80U_INIT_C(0,0x66cf736bedb8679d,0), INT64_C(0) }, /* #66/3/14 */
    { 0x0042, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/0/0 */
    { 0x004a, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/0/2 */
    { 0x0052, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/0/4 */
    { 0x005a, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/0/6 */
    { 0x0062, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/0/8 */
    { 0x006a, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/0/10 */
    { 0x0072, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/0/12 */
    { 0x007a, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/0/14 */
    { 0x0442, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/1/0 */
    { 0x044a, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/1/2 */
    { 0x0452, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/1/4 */
    { 0x045a, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/1/6 */
    { 0x0462, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/1/8 */
    { 0x046a, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/1/10 */
    { 0x0472, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/1/12 */
    { 0x047a, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/1/14 */
    { 0x0842, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/2/0 */
    { 0x084a, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/2/2 */
    { 0x0852, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/2/4 */
    { 0x085a, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/2/6 */
    { 0x0862, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/2/8 */
    { 0x086a, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/2/10 */
    { 0x0872, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/2/12 */
    { 0x087a, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/2/14 */
    { 0x0c42, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/3/0 */
    { 0x0c4a, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/3/2 */
    { 0x0c52, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/3/4 */
    { 0x0c5a, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/3/6 */
    { 0x0c62, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/3/8 */
    { 0x0c6a, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/3/10 */
    { 0x0c72, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/3/12 */
    { 0x0c7a, 0x89b3, 0xb981, RTFLOAT80U_INIT_C(0,0x760e3431adde36bf,7190), INT64_C(-3) }, /* #67/3/14 */
    { 0x0341, 0xb9b7, 0x81a0, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/0/0 */
    { 0x0349, 0xb9b7, 0x81a0, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/0/2 */
    { 0x0351, 0xb9b7, 0x81a0, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/0/4 */
    { 0x0359, 0xb9b7, 0x81a0, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/0/6 */
    { 0x0361, 0xb9b7, 0x0120, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/0/8 */
    { 0x0369, 0xb9b7, 0x0120, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/0/10 */
    { 0x0371, 0xb9b7, 0x0120, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/0/12 */
    { 0x0379, 0xb9b7, 0x0120, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/0/14 */
    { 0x0741, 0xb9b7, 0x81a0, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/1/0 */
    { 0x0749, 0xb9b7, 0x81a0, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/1/2 */
    { 0x0751, 0xb9b7, 0x81a0, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/1/4 */
    { 0x0759, 0xb9b7, 0x81a0, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/1/6 */
    { 0x0761, 0xb9b7, 0x0120, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/1/8 */
    { 0x0769, 0xb9b7, 0x0120, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/1/10 */
    { 0x0771, 0xb9b7, 0x0120, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/1/12 */
    { 0x0779, 0xb9b7, 0x0120, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/1/14 */
    { 0x0b41, 0xb9b7, 0x81a0, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/2/0 */
    { 0x0b49, 0xb9b7, 0x81a0, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/2/2 */
    { 0x0b51, 0xb9b7, 0x81a0, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/2/4 */
    { 0x0b59, 0xb9b7, 0x81a0, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/2/6 */
    { 0x0b61, 0xb9b7, 0x0120, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/2/8 */
    { 0x0b69, 0xb9b7, 0x0120, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/2/10 */
    { 0x0b71, 0xb9b7, 0x0120, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/2/12 */
    { 0x0b79, 0xb9b7, 0x0120, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/2/14 */
    { 0x0f41, 0xb9b7, 0x81a0, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/3/0 */
    { 0x0f49, 0xb9b7, 0x81a0, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/3/2 */
    { 0x0f51, 0xb9b7, 0x81a0, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/3/4 */
    { 0x0f59, 0xb9b7, 0x81a0, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/3/6 */
    { 0x0f61, 0xb9b7, 0x0120, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/3/8 */
    { 0x0f69, 0xb9b7, 0x0120, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/3/10 */
    { 0x0f71, 0xb9b7, 0x0120, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/3/12 */
    { 0x0f79, 0xb9b7, 0x0120, RTFLOAT80U_INIT_C(1,0xebe9756da6bf8cd8,0), INT64_C(0) }, /* #68/3/14 */
    { 0x0003, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/0/0 */
    { 0x000b, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/0/2 */
    { 0x0013, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/0/4 */
    { 0x001b, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/0/6 */
    { 0x0023, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/0/8 */
    { 0x002b, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/0/10 */
    { 0x0033, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/0/12 */
    { 0x003b, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/0/14 */
    { 0x0403, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/1/0 */
    { 0x040b, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/1/2 */
    { 0x0413, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/1/4 */
    { 0x041b, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/1/6 */
    { 0x0423, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/1/8 */
    { 0x042b, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/1/10 */
    { 0x0433, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/1/12 */
    { 0x043b, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/1/14 */
    { 0x0803, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/2/0 */
    { 0x080b, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/2/2 */
    { 0x0813, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/2/4 */
    { 0x081b, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/2/6 */
    { 0x0823, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/2/8 */
    { 0x082b, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/2/10 */
    { 0x0833, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/2/12 */
    { 0x083b, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/2/14 */
    { 0x0c03, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/3/0 */
    { 0x0c0b, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/3/2 */
    { 0x0c13, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/3/4 */
    { 0x0c1b, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/3/6 */
    { 0x0c23, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/3/8 */
    { 0x0c2b, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/3/10 */
    { 0x0c33, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/3/12 */
    { 0x0c3b, 0x69e3, 0x4101, RTFLOAT80U_INIT_C(0,0xed580790874314d4,23072), INT64_MIN }, /* #69/3/14 */
    { 0x0343, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/0/0 */
    { 0x034b, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/0/2 */
    { 0x0353, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/0/4 */
    { 0x035b, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/0/6 */
    { 0x0363, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/0/8 */
    { 0x036b, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/0/10 */
    { 0x0373, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/0/12 */
    { 0x037b, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/0/14 */
    { 0x0743, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/1/0 */
    { 0x074b, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/1/2 */
    { 0x0753, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/1/4 */
    { 0x075b, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/1/6 */
    { 0x0763, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/1/8 */
    { 0x076b, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/1/10 */
    { 0x0773, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/1/12 */
    { 0x077b, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/1/14 */
    { 0x0b43, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/2/0 */
    { 0x0b4b, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/2/2 */
    { 0x0b53, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/2/4 */
    { 0x0b5b, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/2/6 */
    { 0x0b63, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/2/8 */
    { 0x0b6b, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/2/10 */
    { 0x0b73, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/2/12 */
    { 0x0b7b, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/2/14 */
    { 0x0f43, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/3/0 */
    { 0x0f4b, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/3/2 */
    { 0x0f53, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/3/4 */
    { 0x0f5b, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/3/6 */
    { 0x0f63, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/3/8 */
    { 0x0f6b, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/3/10 */
    { 0x0f73, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/3/12 */
    { 0x0f7b, 0xca23, 0x4001, RTFLOAT80U_INIT_C(1,0x12d21,32767), INT64_MIN }, /* #70/3/14 */
    { 0x0106, 0xcefc, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/0/0 */
    { 0x010e, 0xcefc, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/0/2 */
    { 0x0116, 0xcefc, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/0/4 */
    { 0x011e, 0xcefc, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/0/6 */
    { 0x0126, 0xcefc, 0x4420, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/0/8 */
    { 0x012e, 0xcefc, 0x4420, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/0/10 */
    { 0x0136, 0xcefc, 0x4420, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/0/12 */
    { 0x013e, 0xcefc, 0x4420, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/0/14 */
    { 0x0506, 0xcefc, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/1/0 */
    { 0x050e, 0xcefc, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/1/2 */
    { 0x0516, 0xcefc, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/1/4 */
    { 0x051e, 0xcefc, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/1/6 */
    { 0x0526, 0xcefc, 0x4420, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/1/8 */
    { 0x052e, 0xcefc, 0x4420, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/1/10 */
    { 0x0536, 0xcefc, 0x4420, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/1/12 */
    { 0x053e, 0xcefc, 0x4420, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/1/14 */
    { 0x0906, 0xcefc, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/2/0 */
    { 0x090e, 0xcefc, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/2/2 */
    { 0x0916, 0xcefc, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/2/4 */
    { 0x091e, 0xcefc, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/2/6 */
    { 0x0926, 0xcefc, 0x4420, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/2/8 */
    { 0x092e, 0xcefc, 0x4420, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/2/10 */
    { 0x0936, 0xcefc, 0x4420, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/2/12 */
    { 0x093e, 0xcefc, 0x4420, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/2/14 */
    { 0x0d06, 0xcefc, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/3/0 */
    { 0x0d0e, 0xcefc, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/3/2 */
    { 0x0d16, 0xcefc, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/3/4 */
    { 0x0d1e, 0xcefc, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/3/6 */
    { 0x0d26, 0xcefc, 0x4420, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/3/8 */
    { 0x0d2e, 0xcefc, 0x4420, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/3/10 */
    { 0x0d36, 0xcefc, 0x4420, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/3/12 */
    { 0x0d3e, 0xcefc, 0x4420, RTFLOAT80U_INIT_C(1,0xd40835e1d26f3a90,8408), INT64_C(0) }, /* #71/3/14 */
    { 0x0203, 0x0199, 0x81a0, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/0/0 */
    { 0x020b, 0x0199, 0x81a0, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/0/2 */
    { 0x0213, 0x0199, 0x81a0, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/0/4 */
    { 0x021b, 0x0199, 0x81a0, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/0/6 */
    { 0x0223, 0x0199, 0x0120, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/0/8 */
    { 0x022b, 0x0199, 0x0120, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/0/10 */
    { 0x0233, 0x0199, 0x0120, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/0/12 */
    { 0x023b, 0x0199, 0x0120, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/0/14 */
    { 0x0603, 0x0199, 0x81a0, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/1/0 */
    { 0x060b, 0x0199, 0x81a0, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/1/2 */
    { 0x0613, 0x0199, 0x81a0, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/1/4 */
    { 0x061b, 0x0199, 0x81a0, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/1/6 */
    { 0x0623, 0x0199, 0x0120, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/1/8 */
    { 0x062b, 0x0199, 0x0120, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/1/10 */
    { 0x0633, 0x0199, 0x0120, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/1/12 */
    { 0x063b, 0x0199, 0x0120, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/1/14 */
    { 0x0a03, 0x0199, 0x81a0, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/2/0 */
    { 0x0a0b, 0x0199, 0x81a0, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/2/2 */
    { 0x0a13, 0x0199, 0x81a0, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/2/4 */
    { 0x0a1b, 0x0199, 0x81a0, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/2/6 */
    { 0x0a23, 0x0199, 0x0120, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/2/8 */
    { 0x0a2b, 0x0199, 0x0120, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/2/10 */
    { 0x0a33, 0x0199, 0x0120, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/2/12 */
    { 0x0a3b, 0x0199, 0x0120, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/2/14 */
    { 0x0e03, 0x0199, 0x81a0, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/3/0 */
    { 0x0e0b, 0x0199, 0x81a0, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/3/2 */
    { 0x0e13, 0x0199, 0x81a0, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/3/4 */
    { 0x0e1b, 0x0199, 0x81a0, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/3/6 */
    { 0x0e23, 0x0199, 0x0120, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/3/8 */
    { 0x0e2b, 0x0199, 0x0120, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/3/10 */
    { 0x0e33, 0x0199, 0x0120, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/3/12 */
    { 0x0e3b, 0x0199, 0x0120, RTFLOAT80U_INIT_C(1,0xbbc62f8b26da229e,16383), INT64_C(-1) }, /* #72/3/14 */
    { 0x0002, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/0/0 */
    { 0x000a, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/0/2 */
    { 0x0012, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/0/4 */
    { 0x001a, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/0/6 */
    { 0x0022, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/0/8 */
    { 0x002a, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/0/10 */
    { 0x0032, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/0/12 */
    { 0x003a, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/0/14 */
    { 0x0402, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/1/0 */
    { 0x040a, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/1/2 */
    { 0x0412, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/1/4 */
    { 0x041a, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/1/6 */
    { 0x0422, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/1/8 */
    { 0x042a, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/1/10 */
    { 0x0432, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/1/12 */
    { 0x043a, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/1/14 */
    { 0x0802, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/2/0 */
    { 0x080a, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/2/2 */
    { 0x0812, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/2/4 */
    { 0x081a, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/2/6 */
    { 0x0822, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/2/8 */
    { 0x082a, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/2/10 */
    { 0x0832, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/2/12 */
    { 0x083a, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/2/14 */
    { 0x0c02, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/3/0 */
    { 0x0c0a, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/3/2 */
    { 0x0c12, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/3/4 */
    { 0x0c1a, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/3/6 */
    { 0x0c22, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/3/8 */
    { 0x0c2a, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/3/10 */
    { 0x0c32, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/3/12 */
    { 0x0c3a, 0x3e98, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT64_C(-3) }, /* #73/3/14 */
    { 0x0301, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/0/0 */
    { 0x0309, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/0/2 */
    { 0x0311, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/0/4 */
    { 0x0319, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/0/6 */
    { 0x0321, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/0/8 */
    { 0x0329, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/0/10 */
    { 0x0331, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/0/12 */
    { 0x0339, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/0/14 */
    { 0x0701, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/1/0 */
    { 0x0709, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/1/2 */
    { 0x0711, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/1/4 */
    { 0x0719, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/1/6 */
    { 0x0721, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/1/8 */
    { 0x0729, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/1/10 */
    { 0x0731, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/1/12 */
    { 0x0739, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/1/14 */
    { 0x0b01, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/2/0 */
    { 0x0b09, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/2/2 */
    { 0x0b11, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/2/4 */
    { 0x0b19, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/2/6 */
    { 0x0b21, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/2/8 */
    { 0x0b29, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/2/10 */
    { 0x0b31, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/2/12 */
    { 0x0b39, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/2/14 */
    { 0x0f01, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/3/0 */
    { 0x0f09, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/3/2 */
    { 0x0f11, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/3/4 */
    { 0x0f19, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/3/6 */
    { 0x0f21, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/3/8 */
    { 0x0f29, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/3/10 */
    { 0x0f31, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/3/12 */
    { 0x0f39, 0xdc09, 0x4401, RTFLOAT80U_INIT_C(1,0x59ba07df1c4ded9,21978), INT64_MIN }, /* #74/3/14 */
    { 0x0143, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/0/0 */
    { 0x014b, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/0/2 */
    { 0x0153, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/0/4 */
    { 0x015b, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/0/6 */
    { 0x0163, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/0/8 */
    { 0x016b, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/0/10 */
    { 0x0173, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/0/12 */
    { 0x017b, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/0/14 */
    { 0x0543, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/1/0 */
    { 0x054b, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/1/2 */
    { 0x0553, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/1/4 */
    { 0x055b, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/1/6 */
    { 0x0563, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/1/8 */
    { 0x056b, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/1/10 */
    { 0x0573, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/1/12 */
    { 0x057b, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/1/14 */
    { 0x0943, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/2/0 */
    { 0x094b, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/2/2 */
    { 0x0953, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/2/4 */
    { 0x095b, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/2/6 */
    { 0x0963, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/2/8 */
    { 0x096b, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/2/10 */
    { 0x0973, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/2/12 */
    { 0x097b, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/2/14 */
    { 0x0d43, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/3/0 */
    { 0x0d4b, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/3/2 */
    { 0x0d53, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/3/4 */
    { 0x0d5b, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/3/6 */
    { 0x0d63, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/3/8 */
    { 0x0d6b, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/3/10 */
    { 0x0d73, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/3/12 */
    { 0x0d7b, 0xb5ec, 0x0501, RTFLOAT80U_INIT_C(1,0x60aabc837d881e4d,6495), INT64_MIN }, /* #75/3/14 */
    { 0x0102, 0x7463, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/0/0 */
    { 0x010a, 0x7463, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/0/2 */
    { 0x0112, 0x7463, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/0/4 */
    { 0x011a, 0x7463, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/0/6 */
    { 0x0122, 0x7463, 0x4420, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/0/8 */
    { 0x012a, 0x7463, 0x4420, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/0/10 */
    { 0x0132, 0x7463, 0x4420, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/0/12 */
    { 0x013a, 0x7463, 0x4420, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/0/14 */
    { 0x0502, 0x7463, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/1/0 */
    { 0x050a, 0x7463, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/1/2 */
    { 0x0512, 0x7463, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/1/4 */
    { 0x051a, 0x7463, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/1/6 */
    { 0x0522, 0x7463, 0x4420, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/1/8 */
    { 0x052a, 0x7463, 0x4420, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/1/10 */
    { 0x0532, 0x7463, 0x4420, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/1/12 */
    { 0x053a, 0x7463, 0x4420, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/1/14 */
    { 0x0902, 0x7463, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/2/0 */
    { 0x090a, 0x7463, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/2/2 */
    { 0x0912, 0x7463, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/2/4 */
    { 0x091a, 0x7463, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/2/6 */
    { 0x0922, 0x7463, 0x4420, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/2/8 */
    { 0x092a, 0x7463, 0x4420, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/2/10 */
    { 0x0932, 0x7463, 0x4420, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/2/12 */
    { 0x093a, 0x7463, 0x4420, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/2/14 */
    { 0x0d02, 0x7463, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/3/0 */
    { 0x0d0a, 0x7463, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/3/2 */
    { 0x0d12, 0x7463, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/3/4 */
    { 0x0d1a, 0x7463, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/3/6 */
    { 0x0d22, 0x7463, 0x4420, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/3/8 */
    { 0x0d2a, 0x7463, 0x4420, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/3/10 */
    { 0x0d32, 0x7463, 0x4420, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/3/12 */
    { 0x0d3a, 0x7463, 0x4420, RTFLOAT80U_INIT_C(1,0xc81245e3bd89566b,16445), INT64_C(-7208331100803083061) }, /* #76/3/14 */
    { 0x0101, 0x80be, 0x80a0, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/0/0 */
    { 0x0109, 0x80be, 0x80a0, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/0/2 */
    { 0x0111, 0x80be, 0x80a0, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/0/4 */
    { 0x0119, 0x80be, 0x80a0, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/0/6 */
    { 0x0121, 0x80be, 0x0020, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/0/8 */
    { 0x0129, 0x80be, 0x0020, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/0/10 */
    { 0x0131, 0x80be, 0x0020, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/0/12 */
    { 0x0139, 0x80be, 0x0020, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/0/14 */
    { 0x0501, 0x80be, 0x80a0, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/1/0 */
    { 0x0509, 0x80be, 0x80a0, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/1/2 */
    { 0x0511, 0x80be, 0x80a0, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/1/4 */
    { 0x0519, 0x80be, 0x80a0, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/1/6 */
    { 0x0521, 0x80be, 0x0020, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/1/8 */
    { 0x0529, 0x80be, 0x0020, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/1/10 */
    { 0x0531, 0x80be, 0x0020, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/1/12 */
    { 0x0539, 0x80be, 0x0020, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/1/14 */
    { 0x0901, 0x80be, 0x80a0, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/2/0 */
    { 0x0909, 0x80be, 0x80a0, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/2/2 */
    { 0x0911, 0x80be, 0x80a0, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/2/4 */
    { 0x0919, 0x80be, 0x80a0, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/2/6 */
    { 0x0921, 0x80be, 0x0020, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/2/8 */
    { 0x0929, 0x80be, 0x0020, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/2/10 */
    { 0x0931, 0x80be, 0x0020, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/2/12 */
    { 0x0939, 0x80be, 0x0020, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/2/14 */
    { 0x0d01, 0x80be, 0x80a0, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/3/0 */
    { 0x0d09, 0x80be, 0x80a0, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/3/2 */
    { 0x0d11, 0x80be, 0x80a0, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/3/4 */
    { 0x0d19, 0x80be, 0x80a0, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/3/6 */
    { 0x0d21, 0x80be, 0x0020, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/3/8 */
    { 0x0d29, 0x80be, 0x0020, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/3/10 */
    { 0x0d31, 0x80be, 0x0020, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/3/12 */
    { 0x0d39, 0x80be, 0x0020, RTFLOAT80U_INIT_C(1,0x98c041eaa487b56d,16445), INT64_C(-5503434982666001078) }, /* #77/3/14 */
    { 0x0105, 0x1450, 0x84a0, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/0/0 */
    { 0x010d, 0x1450, 0x84a0, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/0/2 */
    { 0x0115, 0x1450, 0x84a0, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/0/4 */
    { 0x011d, 0x1450, 0x84a0, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/0/6 */
    { 0x0125, 0x1450, 0x0420, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/0/8 */
    { 0x012d, 0x1450, 0x0420, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/0/10 */
    { 0x0135, 0x1450, 0x0420, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/0/12 */
    { 0x013d, 0x1450, 0x0420, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/0/14 */
    { 0x0505, 0x1450, 0x84a0, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/1/0 */
    { 0x050d, 0x1450, 0x84a0, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/1/2 */
    { 0x0515, 0x1450, 0x84a0, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/1/4 */
    { 0x051d, 0x1450, 0x84a0, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/1/6 */
    { 0x0525, 0x1450, 0x0420, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/1/8 */
    { 0x052d, 0x1450, 0x0420, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/1/10 */
    { 0x0535, 0x1450, 0x0420, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/1/12 */
    { 0x053d, 0x1450, 0x0420, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/1/14 */
    { 0x0905, 0x1450, 0x84a0, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/2/0 */
    { 0x090d, 0x1450, 0x84a0, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/2/2 */
    { 0x0915, 0x1450, 0x84a0, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/2/4 */
    { 0x091d, 0x1450, 0x84a0, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/2/6 */
    { 0x0925, 0x1450, 0x0420, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/2/8 */
    { 0x092d, 0x1450, 0x0420, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/2/10 */
    { 0x0935, 0x1450, 0x0420, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/2/12 */
    { 0x093d, 0x1450, 0x0420, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/2/14 */
    { 0x0d05, 0x1450, 0x84a0, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/3/0 */
    { 0x0d0d, 0x1450, 0x84a0, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/3/2 */
    { 0x0d15, 0x1450, 0x84a0, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/3/4 */
    { 0x0d1d, 0x1450, 0x84a0, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/3/6 */
    { 0x0d25, 0x1450, 0x0420, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/3/8 */
    { 0x0d2d, 0x1450, 0x0420, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/3/10 */
    { 0x0d35, 0x1450, 0x0420, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/3/12 */
    { 0x0d3d, 0x1450, 0x0420, RTFLOAT80U_INIT_C(1,0xb6379805ef947a02,5999), INT64_C(0) }, /* #78/3/14 */
    { 0x0244, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/0/0 */
    { 0x024c, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/0/2 */
    { 0x0254, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/0/4 */
    { 0x025c, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/0/6 */
    { 0x0264, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/0/8 */
    { 0x026c, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/0/10 */
    { 0x0274, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/0/12 */
    { 0x027c, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/0/14 */
    { 0x0644, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/1/0 */
    { 0x064c, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/1/2 */
    { 0x0654, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/1/4 */
    { 0x065c, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/1/6 */
    { 0x0664, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/1/8 */
    { 0x066c, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/1/10 */
    { 0x0674, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/1/12 */
    { 0x067c, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/1/14 */
    { 0x0a44, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/2/0 */
    { 0x0a4c, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/2/2 */
    { 0x0a54, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/2/4 */
    { 0x0a5c, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/2/6 */
    { 0x0a64, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/2/8 */
    { 0x0a6c, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/2/10 */
    { 0x0a74, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/2/12 */
    { 0x0a7c, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/2/14 */
    { 0x0e44, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/3/0 */
    { 0x0e4c, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/3/2 */
    { 0x0e54, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/3/4 */
    { 0x0e5c, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/3/6 */
    { 0x0e64, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/3/8 */
    { 0x0e6c, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/3/10 */
    { 0x0e74, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/3/12 */
    { 0x0e7c, 0x2895, 0xb881, RTFLOAT80U_INIT_C(0,0x5689a4cfe9ffc692,2681), INT64_C(-3) }, /* #79/3/14 */
    { 0x0243, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/0/0 */
    { 0x024b, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/0/2 */
    { 0x0253, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/0/4 */
    { 0x025b, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/0/6 */
    { 0x0263, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/0/8 */
    { 0x026b, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/0/10 */
    { 0x0273, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/0/12 */
    { 0x027b, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/0/14 */
    { 0x0643, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/1/0 */
    { 0x064b, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/1/2 */
    { 0x0653, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/1/4 */
    { 0x065b, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/1/6 */
    { 0x0663, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/1/8 */
    { 0x066b, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/1/10 */
    { 0x0673, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/1/12 */
    { 0x067b, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/1/14 */
    { 0x0a43, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/2/0 */
    { 0x0a4b, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/2/2 */
    { 0x0a53, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/2/4 */
    { 0x0a5b, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/2/6 */
    { 0x0a63, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/2/8 */
    { 0x0a6b, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/2/10 */
    { 0x0a73, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/2/12 */
    { 0x0a7b, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/2/14 */
    { 0x0e43, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/3/0 */
    { 0x0e4b, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/3/2 */
    { 0x0e53, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/3/4 */
    { 0x0e5b, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/3/6 */
    { 0x0e63, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/3/8 */
    { 0x0e6b, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/3/10 */
    { 0x0e73, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/3/12 */
    { 0x0e7b, 0x0143, 0x0101, RTFLOAT80U_INIT_C(1,0x8000000000000003,32767), INT64_MIN }, /* #80/3/14 */
    { 0x0245, 0xb276, 0x80a0, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/0/0 */
    { 0x024d, 0xb276, 0x80a0, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/0/2 */
    { 0x0255, 0xb276, 0x80a0, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/0/4 */
    { 0x025d, 0xb276, 0x80a0, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/0/6 */
    { 0x0265, 0xb276, 0x0020, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/0/8 */
    { 0x026d, 0xb276, 0x0020, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/0/10 */
    { 0x0275, 0xb276, 0x0020, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/0/12 */
    { 0x027d, 0xb276, 0x0020, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/0/14 */
    { 0x0645, 0xb276, 0x80a0, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/1/0 */
    { 0x064d, 0xb276, 0x80a0, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/1/2 */
    { 0x0655, 0xb276, 0x80a0, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/1/4 */
    { 0x065d, 0xb276, 0x80a0, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/1/6 */
    { 0x0665, 0xb276, 0x0020, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/1/8 */
    { 0x066d, 0xb276, 0x0020, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/1/10 */
    { 0x0675, 0xb276, 0x0020, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/1/12 */
    { 0x067d, 0xb276, 0x0020, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/1/14 */
    { 0x0a45, 0xb276, 0x80a0, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/2/0 */
    { 0x0a4d, 0xb276, 0x80a0, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/2/2 */
    { 0x0a55, 0xb276, 0x80a0, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/2/4 */
    { 0x0a5d, 0xb276, 0x80a0, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/2/6 */
    { 0x0a65, 0xb276, 0x0020, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/2/8 */
    { 0x0a6d, 0xb276, 0x0020, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/2/10 */
    { 0x0a75, 0xb276, 0x0020, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/2/12 */
    { 0x0a7d, 0xb276, 0x0020, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/2/14 */
    { 0x0e45, 0xb276, 0x80a0, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/3/0 */
    { 0x0e4d, 0xb276, 0x80a0, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/3/2 */
    { 0x0e55, 0xb276, 0x80a0, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/3/4 */
    { 0x0e5d, 0xb276, 0x80a0, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/3/6 */
    { 0x0e65, 0xb276, 0x0020, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/3/8 */
    { 0x0e6d, 0xb276, 0x0020, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/3/10 */
    { 0x0e75, 0xb276, 0x0020, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/3/12 */
    { 0x0e7d, 0xb276, 0x0020, RTFLOAT80U_INIT_C(0,0xa0b0095eee5e1af5,16383), INT64_C(1) }, /* #81/3/14 */
    { 0x0041, 0x8030, 0x80a0, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/0/0 */
    { 0x0049, 0x8030, 0x80a0, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/0/2 */
    { 0x0051, 0x8030, 0x80a0, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/0/4 */
    { 0x0059, 0x8030, 0x80a0, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/0/6 */
    { 0x0061, 0x8030, 0x0020, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/0/8 */
    { 0x0069, 0x8030, 0x0020, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/0/10 */
    { 0x0071, 0x8030, 0x0020, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/0/12 */
    { 0x0079, 0x8030, 0x0020, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/0/14 */
    { 0x0441, 0x8030, 0x80a0, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/1/0 */
    { 0x0449, 0x8030, 0x80a0, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/1/2 */
    { 0x0451, 0x8030, 0x80a0, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/1/4 */
    { 0x0459, 0x8030, 0x80a0, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/1/6 */
    { 0x0461, 0x8030, 0x0020, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/1/8 */
    { 0x0469, 0x8030, 0x0020, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/1/10 */
    { 0x0471, 0x8030, 0x0020, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/1/12 */
    { 0x0479, 0x8030, 0x0020, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/1/14 */
    { 0x0841, 0x8030, 0x80a0, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/2/0 */
    { 0x0849, 0x8030, 0x80a0, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/2/2 */
    { 0x0851, 0x8030, 0x80a0, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/2/4 */
    { 0x0859, 0x8030, 0x80a0, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/2/6 */
    { 0x0861, 0x8030, 0x0020, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/2/8 */
    { 0x0869, 0x8030, 0x0020, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/2/10 */
    { 0x0871, 0x8030, 0x0020, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/2/12 */
    { 0x0879, 0x8030, 0x0020, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/2/14 */
    { 0x0c41, 0x8030, 0x80a0, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/3/0 */
    { 0x0c49, 0x8030, 0x80a0, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/3/2 */
    { 0x0c51, 0x8030, 0x80a0, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/3/4 */
    { 0x0c59, 0x8030, 0x80a0, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/3/6 */
    { 0x0c61, 0x8030, 0x0020, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/3/8 */
    { 0x0c69, 0x8030, 0x0020, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/3/10 */
    { 0x0c71, 0x8030, 0x0020, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/3/12 */
    { 0x0c79, 0x8030, 0x0020, RTFLOAT80U_INIT_C(1,0xb98dc89d3192510a,10327), INT64_C(0) }, /* #82/3/14 */
    { 0x0005, 0x004f, 0x80a0, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/0/0 */
    { 0x000d, 0x004f, 0x80a0, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/0/2 */
    { 0x0015, 0x004f, 0x80a0, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/0/4 */
    { 0x001d, 0x004f, 0x80a0, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/0/6 */
    { 0x0025, 0x004f, 0x0020, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/0/8 */
    { 0x002d, 0x004f, 0x0020, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/0/10 */
    { 0x0035, 0x004f, 0x0020, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/0/12 */
    { 0x003d, 0x004f, 0x0020, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/0/14 */
    { 0x0405, 0x004f, 0x80a0, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/1/0 */
    { 0x040d, 0x004f, 0x80a0, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/1/2 */
    { 0x0415, 0x004f, 0x80a0, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/1/4 */
    { 0x041d, 0x004f, 0x80a0, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/1/6 */
    { 0x0425, 0x004f, 0x0020, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/1/8 */
    { 0x042d, 0x004f, 0x0020, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/1/10 */
    { 0x0435, 0x004f, 0x0020, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/1/12 */
    { 0x043d, 0x004f, 0x0020, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/1/14 */
    { 0x0805, 0x004f, 0x80a0, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/2/0 */
    { 0x080d, 0x004f, 0x80a0, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/2/2 */
    { 0x0815, 0x004f, 0x80a0, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/2/4 */
    { 0x081d, 0x004f, 0x80a0, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/2/6 */
    { 0x0825, 0x004f, 0x0020, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/2/8 */
    { 0x082d, 0x004f, 0x0020, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/2/10 */
    { 0x0835, 0x004f, 0x0020, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/2/12 */
    { 0x083d, 0x004f, 0x0020, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/2/14 */
    { 0x0c05, 0x004f, 0x80a0, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/3/0 */
    { 0x0c0d, 0x004f, 0x80a0, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/3/2 */
    { 0x0c15, 0x004f, 0x80a0, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/3/4 */
    { 0x0c1d, 0x004f, 0x80a0, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/3/6 */
    { 0x0c25, 0x004f, 0x0020, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/3/8 */
    { 0x0c2d, 0x004f, 0x0020, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/3/10 */
    { 0x0c35, 0x004f, 0x0020, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/3/12 */
    { 0x0c3d, 0x004f, 0x0020, RTFLOAT80U_INIT_C(1,0xc792192b0760a95d,16383), INT64_C(-1) }, /* #83/3/14 */
    { 0x0145, 0xde37, 0xc4a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/0/0 */
    { 0x014d, 0xde37, 0xc4a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/0/2 */
    { 0x0155, 0xde37, 0xc4a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/0/4 */
    { 0x015d, 0xde37, 0xc4a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/0/6 */
    { 0x0165, 0xde37, 0x4420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/0/8 */
    { 0x016d, 0xde37, 0x4420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/0/10 */
    { 0x0175, 0xde37, 0x4420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/0/12 */
    { 0x017d, 0xde37, 0x4420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/0/14 */
    { 0x0545, 0xde37, 0xc4a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/1/0 */
    { 0x054d, 0xde37, 0xc4a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/1/2 */
    { 0x0555, 0xde37, 0xc4a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/1/4 */
    { 0x055d, 0xde37, 0xc4a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/1/6 */
    { 0x0565, 0xde37, 0x4420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/1/8 */
    { 0x056d, 0xde37, 0x4420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/1/10 */
    { 0x0575, 0xde37, 0x4420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/1/12 */
    { 0x057d, 0xde37, 0x4420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/1/14 */
    { 0x0945, 0xde37, 0xc4a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/2/0 */
    { 0x094d, 0xde37, 0xc4a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/2/2 */
    { 0x0955, 0xde37, 0xc4a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/2/4 */
    { 0x095d, 0xde37, 0xc4a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/2/6 */
    { 0x0965, 0xde37, 0x4420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/2/8 */
    { 0x096d, 0xde37, 0x4420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/2/10 */
    { 0x0975, 0xde37, 0x4420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/2/12 */
    { 0x097d, 0xde37, 0x4420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/2/14 */
    { 0x0d45, 0xde37, 0xc4a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/3/0 */
    { 0x0d4d, 0xde37, 0xc4a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/3/2 */
    { 0x0d55, 0xde37, 0xc4a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/3/4 */
    { 0x0d5d, 0xde37, 0xc4a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/3/6 */
    { 0x0d65, 0xde37, 0x4420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/3/8 */
    { 0x0d6d, 0xde37, 0x4420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/3/10 */
    { 0x0d75, 0xde37, 0x4420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/3/12 */
    { 0x0d7d, 0xde37, 0x4420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #84/3/14 */
    { 0x0203, 0x6106, 0xc1a0, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/0/0 */
    { 0x020b, 0x6106, 0xc1a0, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/0/2 */
    { 0x0213, 0x6106, 0xc1a0, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/0/4 */
    { 0x021b, 0x6106, 0xc1a0, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/0/6 */
    { 0x0223, 0x6106, 0x4120, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/0/8 */
    { 0x022b, 0x6106, 0x4120, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/0/10 */
    { 0x0233, 0x6106, 0x4120, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/0/12 */
    { 0x023b, 0x6106, 0x4120, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/0/14 */
    { 0x0603, 0x6106, 0xc1a0, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/1/0 */
    { 0x060b, 0x6106, 0xc1a0, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/1/2 */
    { 0x0613, 0x6106, 0xc1a0, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/1/4 */
    { 0x061b, 0x6106, 0xc1a0, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/1/6 */
    { 0x0623, 0x6106, 0x4120, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/1/8 */
    { 0x062b, 0x6106, 0x4120, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/1/10 */
    { 0x0633, 0x6106, 0x4120, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/1/12 */
    { 0x063b, 0x6106, 0x4120, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/1/14 */
    { 0x0a03, 0x6106, 0xc1a0, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/2/0 */
    { 0x0a0b, 0x6106, 0xc1a0, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/2/2 */
    { 0x0a13, 0x6106, 0xc1a0, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/2/4 */
    { 0x0a1b, 0x6106, 0xc1a0, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/2/6 */
    { 0x0a23, 0x6106, 0x4120, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/2/8 */
    { 0x0a2b, 0x6106, 0x4120, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/2/10 */
    { 0x0a33, 0x6106, 0x4120, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/2/12 */
    { 0x0a3b, 0x6106, 0x4120, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/2/14 */
    { 0x0e03, 0x6106, 0xc1a0, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/3/0 */
    { 0x0e0b, 0x6106, 0xc1a0, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/3/2 */
    { 0x0e13, 0x6106, 0xc1a0, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/3/4 */
    { 0x0e1b, 0x6106, 0xc1a0, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/3/6 */
    { 0x0e23, 0x6106, 0x4120, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/3/8 */
    { 0x0e2b, 0x6106, 0x4120, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/3/10 */
    { 0x0e33, 0x6106, 0x4120, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/3/12 */
    { 0x0e3b, 0x6106, 0x4120, RTFLOAT80U_INIT_C(1,0x9a463db965383558,16419), INT64_C(-82825426732) }, /* #85/3/14 */
    { 0x0246, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/0/0 */
    { 0x024e, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/0/2 */
    { 0x0256, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/0/4 */
    { 0x025e, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/0/6 */
    { 0x0266, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/0/8 */
    { 0x026e, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/0/10 */
    { 0x0276, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/0/12 */
    { 0x027e, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/0/14 */
    { 0x0646, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/1/0 */
    { 0x064e, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/1/2 */
    { 0x0656, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/1/4 */
    { 0x065e, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/1/6 */
    { 0x0666, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/1/8 */
    { 0x066e, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/1/10 */
    { 0x0676, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/1/12 */
    { 0x067e, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/1/14 */
    { 0x0a46, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/2/0 */
    { 0x0a4e, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/2/2 */
    { 0x0a56, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/2/4 */
    { 0x0a5e, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/2/6 */
    { 0x0a66, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/2/8 */
    { 0x0a6e, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/2/10 */
    { 0x0a76, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/2/12 */
    { 0x0a7e, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/2/14 */
    { 0x0e46, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/3/0 */
    { 0x0e4e, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/3/2 */
    { 0x0e56, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/3/4 */
    { 0x0e5e, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/3/6 */
    { 0x0e66, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/3/8 */
    { 0x0e6e, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/3/10 */
    { 0x0e76, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/3/12 */
    { 0x0e7e, 0x8d99, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), INT64_C(-3) }, /* #86/3/14 */
    { 0x0242, 0x75e9, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/0/0 */
    { 0x024a, 0x75e9, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/0/2 */
    { 0x0252, 0x75e9, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/0/4 */
    { 0x025a, 0x75e9, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/0/6 */
    { 0x0262, 0x75e9, 0x4520, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/0/8 */
    { 0x026a, 0x75e9, 0x4520, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/0/10 */
    { 0x0272, 0x75e9, 0x4520, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/0/12 */
    { 0x027a, 0x75e9, 0x4520, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/0/14 */
    { 0x0642, 0x75e9, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/1/0 */
    { 0x064a, 0x75e9, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/1/2 */
    { 0x0652, 0x75e9, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/1/4 */
    { 0x065a, 0x75e9, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/1/6 */
    { 0x0662, 0x75e9, 0x4520, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/1/8 */
    { 0x066a, 0x75e9, 0x4520, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/1/10 */
    { 0x0672, 0x75e9, 0x4520, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/1/12 */
    { 0x067a, 0x75e9, 0x4520, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/1/14 */
    { 0x0a42, 0x75e9, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/2/0 */
    { 0x0a4a, 0x75e9, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/2/2 */
    { 0x0a52, 0x75e9, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/2/4 */
    { 0x0a5a, 0x75e9, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/2/6 */
    { 0x0a62, 0x75e9, 0x4520, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/2/8 */
    { 0x0a6a, 0x75e9, 0x4520, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/2/10 */
    { 0x0a72, 0x75e9, 0x4520, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/2/12 */
    { 0x0a7a, 0x75e9, 0x4520, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/2/14 */
    { 0x0e42, 0x75e9, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/3/0 */
    { 0x0e4a, 0x75e9, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/3/2 */
    { 0x0e52, 0x75e9, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/3/4 */
    { 0x0e5a, 0x75e9, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/3/6 */
    { 0x0e62, 0x75e9, 0x4520, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/3/8 */
    { 0x0e6a, 0x75e9, 0x4520, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/3/10 */
    { 0x0e72, 0x75e9, 0x4520, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/3/12 */
    { 0x0e7a, 0x75e9, 0x4520, RTFLOAT80U_INIT_C(1,0xe2f0c25fb55d386d,16445), INT64_C(-8176391981651369014) }, /* #87/3/14 */
    { 0x0046, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/0/0 */
    { 0x004e, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/0/2 */
    { 0x0056, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/0/4 */
    { 0x005e, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/0/6 */
    { 0x0066, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/0/8 */
    { 0x006e, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/0/10 */
    { 0x0076, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/0/12 */
    { 0x007e, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/0/14 */
    { 0x0446, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/1/0 */
    { 0x044e, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/1/2 */
    { 0x0456, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/1/4 */
    { 0x045e, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/1/6 */
    { 0x0466, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/1/8 */
    { 0x046e, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/1/10 */
    { 0x0476, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/1/12 */
    { 0x047e, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/1/14 */
    { 0x0846, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/2/0 */
    { 0x084e, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/2/2 */
    { 0x0856, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/2/4 */
    { 0x085e, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/2/6 */
    { 0x0866, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/2/8 */
    { 0x086e, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/2/10 */
    { 0x0876, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/2/12 */
    { 0x087e, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/2/14 */
    { 0x0c46, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/3/0 */
    { 0x0c4e, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/3/2 */
    { 0x0c56, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/3/4 */
    { 0x0c5e, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/3/6 */
    { 0x0c66, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/3/8 */
    { 0x0c6e, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/3/10 */
    { 0x0c76, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/3/12 */
    { 0x0c7e, 0x9fa2, 0xbd81, RTFLOAT80U_INIT_C(0,0x1ae71,32767), INT64_C(-3) }, /* #88/3/14 */
    { 0x0046, 0x9c81, 0x84a0, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/0/0 */
    { 0x004e, 0x9c81, 0x84a0, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/0/2 */
    { 0x0056, 0x9c81, 0x84a0, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/0/4 */
    { 0x005e, 0x9c81, 0x84a0, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/0/6 */
    { 0x0066, 0x9c81, 0x0420, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/0/8 */
    { 0x006e, 0x9c81, 0x0420, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/0/10 */
    { 0x0076, 0x9c81, 0x0420, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/0/12 */
    { 0x007e, 0x9c81, 0x0420, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/0/14 */
    { 0x0446, 0x9c81, 0x84a0, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/1/0 */
    { 0x044e, 0x9c81, 0x84a0, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/1/2 */
    { 0x0456, 0x9c81, 0x84a0, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/1/4 */
    { 0x045e, 0x9c81, 0x84a0, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/1/6 */
    { 0x0466, 0x9c81, 0x0420, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/1/8 */
    { 0x046e, 0x9c81, 0x0420, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/1/10 */
    { 0x0476, 0x9c81, 0x0420, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/1/12 */
    { 0x047e, 0x9c81, 0x0420, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/1/14 */
    { 0x0846, 0x9c81, 0x84a0, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/2/0 */
    { 0x084e, 0x9c81, 0x84a0, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/2/2 */
    { 0x0856, 0x9c81, 0x84a0, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/2/4 */
    { 0x085e, 0x9c81, 0x84a0, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/2/6 */
    { 0x0866, 0x9c81, 0x0420, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/2/8 */
    { 0x086e, 0x9c81, 0x0420, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/2/10 */
    { 0x0876, 0x9c81, 0x0420, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/2/12 */
    { 0x087e, 0x9c81, 0x0420, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/2/14 */
    { 0x0c46, 0x9c81, 0x84a0, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/3/0 */
    { 0x0c4e, 0x9c81, 0x84a0, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/3/2 */
    { 0x0c56, 0x9c81, 0x84a0, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/3/4 */
    { 0x0c5e, 0x9c81, 0x84a0, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/3/6 */
    { 0x0c66, 0x9c81, 0x0420, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/3/8 */
    { 0x0c6e, 0x9c81, 0x0420, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/3/10 */
    { 0x0c76, 0x9c81, 0x0420, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/3/12 */
    { 0x0c7e, 0x9c81, 0x0420, RTFLOAT80U_INIT_C(1,0xae07af3b92463ff0,0), INT64_C(0) }, /* #89/3/14 */
    { 0x0145, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/0/0 */
    { 0x014d, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/0/2 */
    { 0x0155, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/0/4 */
    { 0x015d, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/0/6 */
    { 0x0165, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/0/8 */
    { 0x016d, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/0/10 */
    { 0x0175, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/0/12 */
    { 0x017d, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/0/14 */
    { 0x0545, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/1/0 */
    { 0x054d, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/1/2 */
    { 0x0555, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/1/4 */
    { 0x055d, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/1/6 */
    { 0x0565, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/1/8 */
    { 0x056d, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/1/10 */
    { 0x0575, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/1/12 */
    { 0x057d, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/1/14 */
    { 0x0945, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/2/0 */
    { 0x094d, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/2/2 */
    { 0x0955, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/2/4 */
    { 0x095d, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/2/6 */
    { 0x0965, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/2/8 */
    { 0x096d, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/2/10 */
    { 0x0975, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/2/12 */
    { 0x097d, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/2/14 */
    { 0x0d45, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/3/0 */
    { 0x0d4d, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/3/2 */
    { 0x0d55, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/3/4 */
    { 0x0d5d, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/3/6 */
    { 0x0d65, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/3/8 */
    { 0x0d6d, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/3/10 */
    { 0x0d75, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/3/12 */
    { 0x0d7d, 0x36d7, 0x0401, RTFLOAT80U_INIT_C(1,0xcadf8f6bf4960ee,32073), INT64_MIN }, /* #90/3/14 */
    { 0x0042, 0xa2f7, 0x80a0, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/0/0 */
    { 0x004a, 0xa2f7, 0x80a0, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/0/2 */
    { 0x0052, 0xa2f7, 0x80a0, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/0/4 */
    { 0x005a, 0xa2f7, 0x80a0, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/0/6 */
    { 0x0062, 0xa2f7, 0x0020, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/0/8 */
    { 0x006a, 0xa2f7, 0x0020, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/0/10 */
    { 0x0072, 0xa2f7, 0x0020, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/0/12 */
    { 0x007a, 0xa2f7, 0x0020, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/0/14 */
    { 0x0442, 0xa2f7, 0x80a0, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/1/0 */
    { 0x044a, 0xa2f7, 0x80a0, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/1/2 */
    { 0x0452, 0xa2f7, 0x80a0, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/1/4 */
    { 0x045a, 0xa2f7, 0x80a0, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/1/6 */
    { 0x0462, 0xa2f7, 0x0020, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/1/8 */
    { 0x046a, 0xa2f7, 0x0020, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/1/10 */
    { 0x0472, 0xa2f7, 0x0020, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/1/12 */
    { 0x047a, 0xa2f7, 0x0020, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/1/14 */
    { 0x0842, 0xa2f7, 0x80a0, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/2/0 */
    { 0x084a, 0xa2f7, 0x80a0, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/2/2 */
    { 0x0852, 0xa2f7, 0x80a0, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/2/4 */
    { 0x085a, 0xa2f7, 0x80a0, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/2/6 */
    { 0x0862, 0xa2f7, 0x0020, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/2/8 */
    { 0x086a, 0xa2f7, 0x0020, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/2/10 */
    { 0x0872, 0xa2f7, 0x0020, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/2/12 */
    { 0x087a, 0xa2f7, 0x0020, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/2/14 */
    { 0x0c42, 0xa2f7, 0x80a0, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/3/0 */
    { 0x0c4a, 0xa2f7, 0x80a0, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/3/2 */
    { 0x0c52, 0xa2f7, 0x80a0, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/3/4 */
    { 0x0c5a, 0xa2f7, 0x80a0, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/3/6 */
    { 0x0c62, 0xa2f7, 0x0020, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/3/8 */
    { 0x0c6a, 0xa2f7, 0x0020, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/3/10 */
    { 0x0c72, 0xa2f7, 0x0020, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/3/12 */
    { 0x0c7a, 0xa2f7, 0x0020, RTFLOAT80U_INIT_C(0,0xc4f9d7f14567aa5d,0), INT64_C(0) }, /* #91/3/14 */
    { 0x0305, 0xfc20, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/0/0 */
    { 0x030d, 0xfc20, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/0/2 */
    { 0x0315, 0xfc20, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/0/4 */
    { 0x031d, 0xfc20, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/0/6 */
    { 0x0325, 0xfc20, 0x4420, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/0/8 */
    { 0x032d, 0xfc20, 0x4420, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/0/10 */
    { 0x0335, 0xfc20, 0x4420, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/0/12 */
    { 0x033d, 0xfc20, 0x4420, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/0/14 */
    { 0x0705, 0xfc20, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/1/0 */
    { 0x070d, 0xfc20, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/1/2 */
    { 0x0715, 0xfc20, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/1/4 */
    { 0x071d, 0xfc20, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/1/6 */
    { 0x0725, 0xfc20, 0x4420, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/1/8 */
    { 0x072d, 0xfc20, 0x4420, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/1/10 */
    { 0x0735, 0xfc20, 0x4420, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/1/12 */
    { 0x073d, 0xfc20, 0x4420, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/1/14 */
    { 0x0b05, 0xfc20, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/2/0 */
    { 0x0b0d, 0xfc20, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/2/2 */
    { 0x0b15, 0xfc20, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/2/4 */
    { 0x0b1d, 0xfc20, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/2/6 */
    { 0x0b25, 0xfc20, 0x4420, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/2/8 */
    { 0x0b2d, 0xfc20, 0x4420, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/2/10 */
    { 0x0b35, 0xfc20, 0x4420, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/2/12 */
    { 0x0b3d, 0xfc20, 0x4420, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/2/14 */
    { 0x0f05, 0xfc20, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/3/0 */
    { 0x0f0d, 0xfc20, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/3/2 */
    { 0x0f15, 0xfc20, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/3/4 */
    { 0x0f1d, 0xfc20, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/3/6 */
    { 0x0f25, 0xfc20, 0x4420, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/3/8 */
    { 0x0f2d, 0xfc20, 0x4420, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/3/10 */
    { 0x0f35, 0xfc20, 0x4420, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/3/12 */
    { 0x0f3d, 0xfc20, 0x4420, RTFLOAT80U_INIT_C(0,0xfb3d564112c1cd1b,16383), INT64_C(1) }, /* #92/3/14 */
    { 0x0244, 0x5309, 0xc1a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/0/0 */
    { 0x024c, 0x5309, 0xc1a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/0/2 */
    { 0x0254, 0x5309, 0xc1a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/0/4 */
    { 0x025c, 0x5309, 0xc1a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/0/6 */
    { 0x0264, 0x5309, 0x4120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/0/8 */
    { 0x026c, 0x5309, 0x4120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/0/10 */
    { 0x0274, 0x5309, 0x4120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/0/12 */
    { 0x027c, 0x5309, 0x4120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/0/14 */
    { 0x0644, 0x5309, 0xc1a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/1/0 */
    { 0x064c, 0x5309, 0xc1a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/1/2 */
    { 0x0654, 0x5309, 0xc1a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/1/4 */
    { 0x065c, 0x5309, 0xc1a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/1/6 */
    { 0x0664, 0x5309, 0x4120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/1/8 */
    { 0x066c, 0x5309, 0x4120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/1/10 */
    { 0x0674, 0x5309, 0x4120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/1/12 */
    { 0x067c, 0x5309, 0x4120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/1/14 */
    { 0x0a44, 0x5309, 0xc1a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/2/0 */
    { 0x0a4c, 0x5309, 0xc1a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/2/2 */
    { 0x0a54, 0x5309, 0xc1a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/2/4 */
    { 0x0a5c, 0x5309, 0xc1a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/2/6 */
    { 0x0a64, 0x5309, 0x4120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/2/8 */
    { 0x0a6c, 0x5309, 0x4120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/2/10 */
    { 0x0a74, 0x5309, 0x4120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/2/12 */
    { 0x0a7c, 0x5309, 0x4120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/2/14 */
    { 0x0e44, 0x5309, 0xc1a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/3/0 */
    { 0x0e4c, 0x5309, 0xc1a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/3/2 */
    { 0x0e54, 0x5309, 0xc1a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/3/4 */
    { 0x0e5c, 0x5309, 0xc1a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/3/6 */
    { 0x0e64, 0x5309, 0x4120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/3/8 */
    { 0x0e6c, 0x5309, 0x4120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/3/10 */
    { 0x0e74, 0x5309, 0x4120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/3/12 */
    { 0x0e7c, 0x5309, 0x4120, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT64_C(-1) }, /* #93/3/14 */
    { 0x0103, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/0/0 */
    { 0x010b, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/0/2 */
    { 0x0113, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/0/4 */
    { 0x011b, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/0/6 */
    { 0x0123, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/0/8 */
    { 0x012b, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/0/10 */
    { 0x0133, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/0/12 */
    { 0x013b, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/0/14 */
    { 0x0503, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/1/0 */
    { 0x050b, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/1/2 */
    { 0x0513, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/1/4 */
    { 0x051b, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/1/6 */
    { 0x0523, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/1/8 */
    { 0x052b, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/1/10 */
    { 0x0533, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/1/12 */
    { 0x053b, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/1/14 */
    { 0x0903, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/2/0 */
    { 0x090b, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/2/2 */
    { 0x0913, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/2/4 */
    { 0x091b, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/2/6 */
    { 0x0923, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/2/8 */
    { 0x092b, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/2/10 */
    { 0x0933, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/2/12 */
    { 0x093b, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/2/14 */
    { 0x0d03, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/3/0 */
    { 0x0d0b, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/3/2 */
    { 0x0d13, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/3/4 */
    { 0x0d1b, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/3/6 */
    { 0x0d23, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/3/8 */
    { 0x0d2b, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/3/10 */
    { 0x0d33, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/3/12 */
    { 0x0d3b, 0xac7a, 0x0401, RTFLOAT80U_INIT_C(1,0x2520dcd389c2e612,32767), INT64_MIN }, /* #94/3/14 */
    { 0x0302, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/0/0 */
    { 0x030a, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/0/2 */
    { 0x0312, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/0/4 */
    { 0x031a, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/0/6 */
    { 0x0322, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/0/8 */
    { 0x032a, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/0/10 */
    { 0x0332, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/0/12 */
    { 0x033a, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/0/14 */
    { 0x0702, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/1/0 */
    { 0x070a, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/1/2 */
    { 0x0712, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/1/4 */
    { 0x071a, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/1/6 */
    { 0x0722, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/1/8 */
    { 0x072a, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/1/10 */
    { 0x0732, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/1/12 */
    { 0x073a, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/1/14 */
    { 0x0b02, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/2/0 */
    { 0x0b0a, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/2/2 */
    { 0x0b12, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/2/4 */
    { 0x0b1a, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/2/6 */
    { 0x0b22, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/2/8 */
    { 0x0b2a, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/2/10 */
    { 0x0b32, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/2/12 */
    { 0x0b3a, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/2/14 */
    { 0x0f02, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/3/0 */
    { 0x0f0a, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/3/2 */
    { 0x0f12, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/3/4 */
    { 0x0f1a, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/3/6 */
    { 0x0f22, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/3/8 */
    { 0x0f2a, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/3/10 */
    { 0x0f32, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/3/12 */
    { 0x0f3a, 0xec69, 0xfc81, RTFLOAT80U_INIT_C(0,0x93d030bde799649e,17425), INT64_C(-3) }, /* #95/3/14 */
    { 0x0200, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/0/0 */
    { 0x0208, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/0/2 */
    { 0x0210, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/0/4 */
    { 0x0218, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/0/6 */
    { 0x0220, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/0/8 */
    { 0x0228, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/0/10 */
    { 0x0230, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/0/12 */
    { 0x0238, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/0/14 */
    { 0x0600, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/1/0 */
    { 0x0608, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/1/2 */
    { 0x0610, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/1/4 */
    { 0x0618, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/1/6 */
    { 0x0620, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/1/8 */
    { 0x0628, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/1/10 */
    { 0x0630, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/1/12 */
    { 0x0638, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/1/14 */
    { 0x0a00, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/2/0 */
    { 0x0a08, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/2/2 */
    { 0x0a10, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/2/4 */
    { 0x0a18, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/2/6 */
    { 0x0a20, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/2/8 */
    { 0x0a28, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/2/10 */
    { 0x0a30, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/2/12 */
    { 0x0a38, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/2/14 */
    { 0x0e00, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/3/0 */
    { 0x0e08, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/3/2 */
    { 0x0e10, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/3/4 */
    { 0x0e18, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/3/6 */
    { 0x0e20, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/3/8 */
    { 0x0e28, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/3/10 */
    { 0x0e30, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/3/12 */
    { 0x0e38, 0xc503, 0x4500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16444), INT64_C(2305843009213693952) }, /* #96/3/14 */
    { 0x0245, 0xd59b, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/0/0 */
    { 0x024d, 0xd59b, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/0/2 */
    { 0x0255, 0xd59b, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/0/4 */
    { 0x025d, 0xd59b, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/0/6 */
    { 0x0265, 0xd59b, 0x4520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/0/8 */
    { 0x026d, 0xd59b, 0x4520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/0/10 */
    { 0x0275, 0xd59b, 0x4520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/0/12 */
    { 0x027d, 0xd59b, 0x4520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/0/14 */
    { 0x0645, 0xd59b, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/1/0 */
    { 0x064d, 0xd59b, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/1/2 */
    { 0x0655, 0xd59b, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/1/4 */
    { 0x065d, 0xd59b, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/1/6 */
    { 0x0665, 0xd59b, 0x4520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/1/8 */
    { 0x066d, 0xd59b, 0x4520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/1/10 */
    { 0x0675, 0xd59b, 0x4520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/1/12 */
    { 0x067d, 0xd59b, 0x4520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/1/14 */
    { 0x0a45, 0xd59b, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/2/0 */
    { 0x0a4d, 0xd59b, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/2/2 */
    { 0x0a55, 0xd59b, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/2/4 */
    { 0x0a5d, 0xd59b, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/2/6 */
    { 0x0a65, 0xd59b, 0x4520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/2/8 */
    { 0x0a6d, 0xd59b, 0x4520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/2/10 */
    { 0x0a75, 0xd59b, 0x4520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/2/12 */
    { 0x0a7d, 0xd59b, 0x4520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/2/14 */
    { 0x0e45, 0xd59b, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/3/0 */
    { 0x0e4d, 0xd59b, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/3/2 */
    { 0x0e55, 0xd59b, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/3/4 */
    { 0x0e5d, 0xd59b, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/3/6 */
    { 0x0e65, 0xd59b, 0x4520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/3/8 */
    { 0x0e6d, 0xd59b, 0x4520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/3/10 */
    { 0x0e75, 0xd59b, 0x4520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/3/12 */
    { 0x0e7d, 0xd59b, 0x4520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16444), INT64_C(4611686018427387903) }, /* #97/3/14 */
    { 0x0344, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/0/0 */
    { 0x034c, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/0/2 */
    { 0x0354, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/0/4 */
    { 0x035c, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/0/6 */
    { 0x0364, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/0/8 */
    { 0x036c, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/0/10 */
    { 0x0374, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/0/12 */
    { 0x037c, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/0/14 */
    { 0x0744, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/1/0 */
    { 0x074c, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/1/2 */
    { 0x0754, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/1/4 */
    { 0x075c, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/1/6 */
    { 0x0764, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/1/8 */
    { 0x076c, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/1/10 */
    { 0x0774, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/1/12 */
    { 0x077c, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/1/14 */
    { 0x0b44, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/2/0 */
    { 0x0b4c, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/2/2 */
    { 0x0b54, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/2/4 */
    { 0x0b5c, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/2/6 */
    { 0x0b64, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/2/8 */
    { 0x0b6c, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/2/10 */
    { 0x0b74, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/2/12 */
    { 0x0b7c, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/2/14 */
    { 0x0f44, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/3/0 */
    { 0x0f4c, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/3/2 */
    { 0x0f54, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/3/4 */
    { 0x0f5c, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/3/6 */
    { 0x0f64, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/3/8 */
    { 0x0f6c, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/3/10 */
    { 0x0f74, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/3/12 */
    { 0x0f7c, 0x37a6, 0x0500, RTFLOAT80U_INIT_C(0,0x8000000000000000,16445), INT64_C(4611686018427387904) }, /* #98/3/14 */
    { 0x0101, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/0/0 */
    { 0x0109, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/0/2 */
    { 0x0111, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/0/4 */
    { 0x0119, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/0/6 */
    { 0x0121, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/0/8 */
    { 0x0129, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/0/10 */
    { 0x0131, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/0/12 */
    { 0x0139, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/0/14 */
    { 0x0501, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/1/0 */
    { 0x0509, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/1/2 */
    { 0x0511, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/1/4 */
    { 0x0519, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/1/6 */
    { 0x0521, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/1/8 */
    { 0x0529, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/1/10 */
    { 0x0531, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/1/12 */
    { 0x0539, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/1/14 */
    { 0x0901, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/2/0 */
    { 0x0909, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/2/2 */
    { 0x0911, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/2/4 */
    { 0x0919, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/2/6 */
    { 0x0921, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/2/8 */
    { 0x0929, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/2/10 */
    { 0x0931, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/2/12 */
    { 0x0939, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/2/14 */
    { 0x0d01, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/3/0 */
    { 0x0d09, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/3/2 */
    { 0x0d11, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/3/4 */
    { 0x0d19, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/3/6 */
    { 0x0d21, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/3/8 */
    { 0x0d29, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/3/10 */
    { 0x0d31, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/3/12 */
    { 0x0d39, 0xaf4b, 0x0500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16445), INT64_C(-4611686018427387904) }, /* #99/3/14 */
    { 0x0145, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/0/0 */
    { 0x014d, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/0/2 */
    { 0x0155, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/0/4 */
    { 0x015d, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/0/6 */
    { 0x0165, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/0/8 */
    { 0x016d, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/0/10 */
    { 0x0175, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/0/12 */
    { 0x017d, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/0/14 */
    { 0x0545, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/1/0 */
    { 0x054d, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/1/2 */
    { 0x0555, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/1/4 */
    { 0x055d, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/1/6 */
    { 0x0565, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/1/8 */
    { 0x056d, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/1/10 */
    { 0x0575, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/1/12 */
    { 0x057d, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/1/14 */
    { 0x0945, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/2/0 */
    { 0x094d, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/2/2 */
    { 0x0955, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/2/4 */
    { 0x095d, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/2/6 */
    { 0x0965, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/2/8 */
    { 0x096d, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/2/10 */
    { 0x0975, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/2/12 */
    { 0x097d, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/2/14 */
    { 0x0d45, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/3/0 */
    { 0x0d4d, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/3/2 */
    { 0x0d55, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/3/4 */
    { 0x0d5d, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/3/6 */
    { 0x0d65, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/3/8 */
    { 0x0d6d, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/3/10 */
    { 0x0d75, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/3/12 */
    { 0x0d7d, 0x0891, 0x0000, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16445), INT64_C(9223372036854775800) }, /* #100/3/14 */
    { 0x0001, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/0/0 */
    { 0x0009, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/0/2 */
    { 0x0011, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/0/4 */
    { 0x0019, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/0/6 */
    { 0x0021, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/0/8 */
    { 0x0029, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/0/10 */
    { 0x0031, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/0/12 */
    { 0x0039, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/0/14 */
    { 0x0401, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/1/0 */
    { 0x0409, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/1/2 */
    { 0x0411, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/1/4 */
    { 0x0419, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/1/6 */
    { 0x0421, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/1/8 */
    { 0x0429, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/1/10 */
    { 0x0431, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/1/12 */
    { 0x0439, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/1/14 */
    { 0x0801, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/2/0 */
    { 0x0809, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/2/2 */
    { 0x0811, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/2/4 */
    { 0x0819, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/2/6 */
    { 0x0821, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/2/8 */
    { 0x0829, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/2/10 */
    { 0x0831, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/2/12 */
    { 0x0839, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/2/14 */
    { 0x0c01, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/3/0 */
    { 0x0c09, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/3/2 */
    { 0x0c11, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/3/4 */
    { 0x0c19, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/3/6 */
    { 0x0c21, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/3/8 */
    { 0x0c29, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/3/10 */
    { 0x0c31, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/3/12 */
    { 0x0c39, 0x0a5f, 0x0000, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16445), INT64_C(-9223372036854775800) }, /* #101/3/14 */
    { 0x0105, 0x6ce6, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/0/0 */
    { 0x010d, 0x6ce6, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/0/2 */
    { 0x0115, 0x6ce6, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/0/4 */
    { 0x011d, 0x6ce6, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/0/6 */
    { 0x0125, 0x6ce6, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/0/8 */
    { 0x012d, 0x6ce6, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/0/10 */
    { 0x0135, 0x6ce6, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/0/12 */
    { 0x013d, 0x6ce6, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/0/14 */
    { 0x0505, 0x6ce6, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/1/0 */
    { 0x050d, 0x6ce6, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/1/2 */
    { 0x0515, 0x6ce6, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/1/4 */
    { 0x051d, 0x6ce6, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/1/6 */
    { 0x0525, 0x6ce6, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/1/8 */
    { 0x052d, 0x6ce6, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/1/10 */
    { 0x0535, 0x6ce6, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/1/12 */
    { 0x053d, 0x6ce6, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/1/14 */
    { 0x0905, 0x6ce6, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/2/0 */
    { 0x090d, 0x6ce6, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/2/2 */
    { 0x0915, 0x6ce6, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/2/4 */
    { 0x091d, 0x6ce6, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/2/6 */
    { 0x0925, 0x6ce6, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/2/8 */
    { 0x092d, 0x6ce6, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/2/10 */
    { 0x0935, 0x6ce6, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/2/12 */
    { 0x093d, 0x6ce6, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/2/14 */
    { 0x0d05, 0x6ce6, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/3/0 */
    { 0x0d0d, 0x6ce6, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/3/2 */
    { 0x0d15, 0x6ce6, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/3/4 */
    { 0x0d1d, 0x6ce6, 0xc4a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/3/6 */
    { 0x0d25, 0x6ce6, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/3/8 */
    { 0x0d2d, 0x6ce6, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/3/10 */
    { 0x0d35, 0x6ce6, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/3/12 */
    { 0x0d3d, 0x6ce6, 0x4420, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16445), INT64_MAX }, /* #102/3/14 */
    { 0x0206, 0x605b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/0/0 */
    { 0x020e, 0x605b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/0/2 */
    { 0x0216, 0x605b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/0/4 */
    { 0x021e, 0x605b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/0/6 */
    { 0x0226, 0x605b, 0x4020, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/0/8 */
    { 0x022e, 0x605b, 0x4020, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/0/10 */
    { 0x0236, 0x605b, 0x4020, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/0/12 */
    { 0x023e, 0x605b, 0x4020, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/0/14 */
    { 0x0606, 0x605b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/1/0 */
    { 0x060e, 0x605b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/1/2 */
    { 0x0616, 0x605b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/1/4 */
    { 0x061e, 0x605b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/1/6 */
    { 0x0626, 0x605b, 0x4020, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/1/8 */
    { 0x062e, 0x605b, 0x4020, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/1/10 */
    { 0x0636, 0x605b, 0x4020, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/1/12 */
    { 0x063e, 0x605b, 0x4020, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/1/14 */
    { 0x0a06, 0x605b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/2/0 */
    { 0x0a0e, 0x605b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/2/2 */
    { 0x0a16, 0x605b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/2/4 */
    { 0x0a1e, 0x605b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/2/6 */
    { 0x0a26, 0x605b, 0x4020, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/2/8 */
    { 0x0a2e, 0x605b, 0x4020, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/2/10 */
    { 0x0a36, 0x605b, 0x4020, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/2/12 */
    { 0x0a3e, 0x605b, 0x4020, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/2/14 */
    { 0x0e06, 0x605b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/3/0 */
    { 0x0e0e, 0x605b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/3/2 */
    { 0x0e16, 0x605b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/3/4 */
    { 0x0e1e, 0x605b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/3/6 */
    { 0x0e26, 0x605b, 0x4020, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/3/8 */
    { 0x0e2e, 0x605b, 0x4020, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/3/10 */
    { 0x0e36, 0x605b, 0x4020, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/3/12 */
    { 0x0e3e, 0x605b, 0x4020, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16445), INT64_C(-9223372036854775807) }, /* #103/3/14 */
    { 0x0342, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/0/0 */
    { 0x034a, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/0/2 */
    { 0x0352, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/0/4 */
    { 0x035a, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/0/6 */
    { 0x0362, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/0/8 */
    { 0x036a, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/0/10 */
    { 0x0372, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/0/12 */
    { 0x037a, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/0/14 */
    { 0x0742, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/1/0 */
    { 0x074a, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/1/2 */
    { 0x0752, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/1/4 */
    { 0x075a, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/1/6 */
    { 0x0762, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/1/8 */
    { 0x076a, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/1/10 */
    { 0x0772, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/1/12 */
    { 0x077a, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/1/14 */
    { 0x0b42, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/2/0 */
    { 0x0b4a, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/2/2 */
    { 0x0b52, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/2/4 */
    { 0x0b5a, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/2/6 */
    { 0x0b62, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/2/8 */
    { 0x0b6a, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/2/10 */
    { 0x0b72, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/2/12 */
    { 0x0b7a, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/2/14 */
    { 0x0f42, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/3/0 */
    { 0x0f4a, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/3/2 */
    { 0x0f52, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/3/4 */
    { 0x0f5a, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/3/6 */
    { 0x0f62, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/3/8 */
    { 0x0f6a, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/3/10 */
    { 0x0f72, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/3/12 */
    { 0x0f7a, 0x60cd, 0x4000, RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,16445), INT64_MAX }, /* #104/3/14 */
    { 0x0303, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/0/0 */
    { 0x030b, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/0/2 */
    { 0x0313, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/0/4 */
    { 0x031b, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/0/6 */
    { 0x0323, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/0/8 */
    { 0x032b, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/0/10 */
    { 0x0333, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/0/12 */
    { 0x033b, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/0/14 */
    { 0x0703, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/1/0 */
    { 0x070b, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/1/2 */
    { 0x0713, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/1/4 */
    { 0x071b, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/1/6 */
    { 0x0723, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/1/8 */
    { 0x072b, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/1/10 */
    { 0x0733, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/1/12 */
    { 0x073b, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/1/14 */
    { 0x0b03, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/2/0 */
    { 0x0b0b, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/2/2 */
    { 0x0b13, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/2/4 */
    { 0x0b1b, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/2/6 */
    { 0x0b23, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/2/8 */
    { 0x0b2b, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/2/10 */
    { 0x0b33, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/2/12 */
    { 0x0b3b, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/2/14 */
    { 0x0f03, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/3/0 */
    { 0x0f0b, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/3/2 */
    { 0x0f13, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/3/4 */
    { 0x0f1b, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/3/6 */
    { 0x0f23, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/3/8 */
    { 0x0f2b, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/3/10 */
    { 0x0f33, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/3/12 */
    { 0x0f3b, 0xbf5e, 0x0500, RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,16445), INT64_C(-9223372036854775807) }, /* #105/3/14 */
    { 0x0344, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/0/0 */
    { 0x034c, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/0/2 */
    { 0x0354, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/0/4 */
    { 0x035c, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/0/6 */
    { 0x0364, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/0/8 */
    { 0x036c, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/0/10 */
    { 0x0374, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/0/12 */
    { 0x037c, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/0/14 */
    { 0x0744, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/1/0 */
    { 0x074c, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/1/2 */
    { 0x0754, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/1/4 */
    { 0x075c, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/1/6 */
    { 0x0764, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/1/8 */
    { 0x076c, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/1/10 */
    { 0x0774, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/1/12 */
    { 0x077c, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/1/14 */
    { 0x0b44, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/2/0 */
    { 0x0b4c, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/2/2 */
    { 0x0b54, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/2/4 */
    { 0x0b5c, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/2/6 */
    { 0x0b64, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/2/8 */
    { 0x0b6c, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/2/10 */
    { 0x0b74, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/2/12 */
    { 0x0b7c, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/2/14 */
    { 0x0f44, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/3/0 */
    { 0x0f4c, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/3/2 */
    { 0x0f54, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/3/4 */
    { 0x0f5c, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/3/6 */
    { 0x0f64, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/3/8 */
    { 0x0f6c, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/3/10 */
    { 0x0f74, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/3/12 */
    { 0x0f7c, 0xcb15, 0xf981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16446), INT64_C(-3) }, /* #106/3/14 */
    { 0x0106, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/0/0 */
    { 0x010e, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/0/2 */
    { 0x0116, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/0/4 */
    { 0x011e, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/0/6 */
    { 0x0126, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/0/8 */
    { 0x012e, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/0/10 */
    { 0x0136, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/0/12 */
    { 0x013e, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/0/14 */
    { 0x0506, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/1/0 */
    { 0x050e, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/1/2 */
    { 0x0516, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/1/4 */
    { 0x051e, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/1/6 */
    { 0x0526, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/1/8 */
    { 0x052e, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/1/10 */
    { 0x0536, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/1/12 */
    { 0x053e, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/1/14 */
    { 0x0906, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/2/0 */
    { 0x090e, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/2/2 */
    { 0x0916, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/2/4 */
    { 0x091e, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/2/6 */
    { 0x0926, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/2/8 */
    { 0x092e, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/2/10 */
    { 0x0936, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/2/12 */
    { 0x093e, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/2/14 */
    { 0x0d06, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/3/0 */
    { 0x0d0e, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/3/2 */
    { 0x0d16, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/3/4 */
    { 0x0d1e, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/3/6 */
    { 0x0d26, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/3/8 */
    { 0x0d2e, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/3/10 */
    { 0x0d36, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/3/12 */
    { 0x0d3e, 0x75d4, 0x4500, RTFLOAT80U_INIT_C(1,0x8000000000000000,16446), INT64_MIN }, /* #107/3/14 */
    { 0x0106, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/0/0 */
    { 0x010e, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/0/2 */
    { 0x0116, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/0/4 */
    { 0x011e, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/0/6 */
    { 0x0126, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/0/8 */
    { 0x012e, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/0/10 */
    { 0x0136, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/0/12 */
    { 0x013e, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/0/14 */
    { 0x0506, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/1/0 */
    { 0x050e, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/1/2 */
    { 0x0516, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/1/4 */
    { 0x051e, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/1/6 */
    { 0x0526, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/1/8 */
    { 0x052e, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/1/10 */
    { 0x0536, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/1/12 */
    { 0x053e, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/1/14 */
    { 0x0906, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/2/0 */
    { 0x090e, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/2/2 */
    { 0x0916, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/2/4 */
    { 0x091e, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/2/6 */
    { 0x0926, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/2/8 */
    { 0x092e, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/2/10 */
    { 0x0936, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/2/12 */
    { 0x093e, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/2/14 */
    { 0x0d06, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/3/0 */
    { 0x0d0e, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/3/2 */
    { 0x0d16, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/3/4 */
    { 0x0d1e, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/3/6 */
    { 0x0d26, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/3/8 */
    { 0x0d2e, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/3/10 */
    { 0x0d36, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/3/12 */
    { 0x0d3e, 0x0962, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000001,16446), INT64_C(-3) }, /* #108/3/14 */
    { 0x0306, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/0/0 */
    { 0x030e, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/0/2 */
    { 0x0316, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/0/4 */
    { 0x031e, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/0/6 */
    { 0x0326, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/0/8 */
    { 0x032e, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/0/10 */
    { 0x0336, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/0/12 */
    { 0x033e, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/0/14 */
    { 0x0706, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/1/0 */
    { 0x070e, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/1/2 */
    { 0x0716, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/1/4 */
    { 0x071e, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/1/6 */
    { 0x0726, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/1/8 */
    { 0x072e, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/1/10 */
    { 0x0736, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/1/12 */
    { 0x073e, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/1/14 */
    { 0x0b06, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/2/0 */
    { 0x0b0e, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/2/2 */
    { 0x0b16, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/2/4 */
    { 0x0b1e, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/2/6 */
    { 0x0b26, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/2/8 */
    { 0x0b2e, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/2/10 */
    { 0x0b36, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/2/12 */
    { 0x0b3e, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/2/14 */
    { 0x0f06, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/3/0 */
    { 0x0f0e, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/3/2 */
    { 0x0f16, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/3/4 */
    { 0x0f1e, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/3/6 */
    { 0x0f26, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/3/8 */
    { 0x0f2e, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/3/10 */
    { 0x0f36, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/3/12 */
    { 0x0f3e, 0xbce7, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16446), INT64_C(-3) }, /* #109/3/14 */
    { 0x0303, 0xec70, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/0/0 */
    { 0x030b, 0xec70, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/0/2 */
    { 0x0313, 0xec70, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/0/4 */
    { 0x031b, 0xec70, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/0/6 */
    { 0x0323, 0xec70, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/0/8 */
    { 0x032b, 0xec70, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/0/10 */
    { 0x0333, 0xec70, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/0/12 */
    { 0x033b, 0xec70, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/0/14 */
    { 0x0703, 0xec70, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/1/0 */
    { 0x070b, 0xec70, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/1/2 */
    { 0x0713, 0xec70, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/1/4 */
    { 0x071b, 0xec70, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/1/6 */
    { 0x0723, 0xec70, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/1/8 */
    { 0x072b, 0xec70, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/1/10 */
    { 0x0733, 0xec70, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/1/12 */
    { 0x073b, 0xec70, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/1/14 */
    { 0x0b03, 0xec70, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/2/0 */
    { 0x0b0b, 0xec70, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/2/2 */
    { 0x0b13, 0xec70, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000002,16446), INT64_MIN }, /* #110/2/4 */
    { 0x0b1b, 0xec70, 0x4401, RTFLOAT8