/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.PriceScheduleRequestDescription;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class CreateReservedInstancesListing
extends BaseCmd {
    private static final String CURRENCY_CODE = "currency-code";
    private static final String CURRENCY_CODE_ARG = "CURRENCY-CODE";
    private static final String[] CURRENCY_CODE_DESC = new String[]{"Specify the 3 character CURRENCY-CODE that the PRICES are specified in.", "Can only be specified with LIMIT-PRICE.", "Defaults to USD if not specified."};
    private static final String RESERVED_INSTANCE = "reserved-instance";
    private static final String RESERVED_INSTANCE_ARG = "RESERVED-INSTANCE";
    private static final String[] RESERVED_INSTANCE_DESC = new String[]{"The ID of the active Reserved Instance with which the instances you want", "to list is associated."};
    private static final String INSTANCE_COUNT = "instance-count";
    private static final String INSTANCE_COUNT_ARG = "INSTANCE-COUNT";
    private static final String[] INSTANCE_COUNT_DESC = new String[]{"The number of instances that are a part of a Reserved Instance that will be", "listed in the Reserved Instance Marketplace. This number should be less or", "equal to the instance count associated with the Reserved Instance ID", "specified in this command."};
    private static final Pattern PRICE_SCHEDULE_PATTERN = Pattern.compile("^([0-9]{1,2}):([0-9]*(.[0-9]{1,2})?)");
    private static final String[] CLIENT_TOKEN_DESC = new String[]{"The client token for this request to make the call idempotent.", "A random client token will be generated if this is not provided."};

    public CreateReservedInstancesListing(String[] args) {
        super("ec2crril", "ec2-create-reserved-instances-listing");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return String.format("-r %s -i %s [--client-token %s] MONTH:PRICE [MONTH:PRICE [...]] ", RESERVED_INSTANCE_ARG, INSTANCE_COUNT_ARG, "TOKEN");
    }

    @Override
    public void printSynopsis() {
        super.printSynopsis();
        System.out.println("       MONTH:PRICE is a price schedule entry, where MONTH is the number of");
        System.out.println("       the months remaining and PRICE is the nominal part of the price you");
        System.out.println("       want for this many months, e.g, 14:12.34 means you want to sell 14");
        System.out.println("       months at the price of $12.34.");
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)RESERVED_INSTANCE);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)RESERVED_INSTANCE_ARG);
        OptionBuilder.withDescription((String)CreateReservedInstancesListing.joinDescription(RESERVED_INSTANCE_DESC));
        options.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.withLongOpt((String)INSTANCE_COUNT);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)INSTANCE_COUNT_ARG);
        OptionBuilder.withDescription((String)CreateReservedInstancesListing.joinDescription(INSTANCE_COUNT_DESC));
        options.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.withLongOpt((String)CURRENCY_CODE);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)CURRENCY_CODE_ARG);
        OptionBuilder.withDescription((String)CreateReservedInstancesListing.joinDescription(CURRENCY_CODE_DESC));
        options.addOption(OptionBuilder.create(null));
        OptionBuilder.withLongOpt((String)"client-token");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"TOKEN");
        OptionBuilder.withDescription((String)CreateReservedInstancesListing.joinDescription(CLIENT_TOKEN_DESC));
        options.addOption(OptionBuilder.create(null));
        return options;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("    Creates a listing for your Reserved Instances to be sold in the");
        System.out.println("    Reserved Instance Marketplace. You can submit one Reserved Instance");
        System.out.println("    listing at a time.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption(RESERVED_INSTANCE);
        this.printOption(INSTANCE_COUNT);
        this.printOption(CURRENCY_CODE);
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertOptionSet(RESERVED_INSTANCE);
        ArrayList<PriceScheduleRequestDescription> schedules = new ArrayList<PriceScheduleRequestDescription>();
        String currency = null;
        if (this.isOptionSet(CURRENCY_CODE)) {
            currency = this.getOptionValue(CURRENCY_CODE);
        }
        for (String input : this.getNonOptions()) {
            try {
                Matcher m = PRICE_SCHEDULE_PATTERN.matcher(input);
                if (!m.matches()) {
                    throw new Exception();
                }
                long term = Long.parseLong(m.group(1));
                double price = Double.parseDouble(m.group(2));
                schedules.add(new PriceScheduleRequestDescription(term, price, currency));
            }
            catch (Exception e) {
                throw new InvalidArgument("TERM:PRICE", input);
            }
        }
        Integer instanceCount = null;
        if (this.isOptionSet(INSTANCE_COUNT)) {
            try {
                instanceCount = Integer.parseInt(this.getOptionValue(INSTANCE_COUNT));
            }
            catch (NumberFormatException e) {
                throw new InvalidArgument(INSTANCE_COUNT, this.getOptionValue(INSTANCE_COUNT));
            }
        }
        String clientToken = this.isOptionSet("client-token") ? this.getOptionValue("client-token") : UUID.randomUUID() + Long.toString(System.currentTimeMillis());
        RequestResultPair rsp = jec2.createReservedInstancesListing(this.getOptionValue(RESERVED_INSTANCE), instanceCount, schedules, clientToken);
        out.outputReservedInstancesListings(System.out, (List)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new CreateReservedInstancesListing(args).invoke();
    }
}

