/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGIGVT.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgGetValType(const char * const name);

	Return the type of the data of the value of the specified name.
	If name == NULL, the currently scanned value is processed.

	Return:
		CFG_TERROR: on error
		CFG_T*: else

ob(ject): cfgGetValType
su(bsystem): inifile/2
sh(ort description): Return the type of a value
lo(ng description): Return the type of the data of the specified value.
	 If \para{name} == NULL, the current value is used.
va: CFG_TERROR: on failure
	\item CFG_T*: else <<see CFG.H>>
re(lated to): 
fi(le): cfgigvt.c
in(itialized by): cfgInitINI

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGIGVT.C 1.3 1999/12/13 02:22:23 ska Exp ska $";
#endif

int cfgGetValType(const char * const name)
{	DBG_ENTER("cfgGetValType", Suppl_inifile2)
	DBG_ARGUMENTS( ("name=\"%s\"", name) )

	chkHeap
	DBG_RETURN_BI( cfgHasValue(name) == 0	/* fetch the specified value */
		?	I(type)				/* success */
		:	CFG_TERROR)			/* failure */
}
