/* ExportDialog.c generated by valac 0.40.4, the Vala compiler
 * generated from ExportDialog.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2017 Jens Georg <mail@jensge.org>
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define TYPE_EXPORT_DIALOG (export_dialog_get_type ())
#define EXPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT_DIALOG, ExportDialog))
#define EXPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT_DIALOG, ExportDialogClass))
#define IS_EXPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT_DIALOG))
#define IS_EXPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT_DIALOG))
#define EXPORT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT_DIALOG, ExportDialogClass))

typedef struct _ExportDialog ExportDialog;
typedef struct _ExportDialogClass ExportDialogClass;
typedef struct _ExportDialogPrivate ExportDialogPrivate;
enum  {
	EXPORT_DIALOG_0_PROPERTY,
	EXPORT_DIALOG_NUM_PROPERTIES
};
static GParamSpec* export_dialog_properties[EXPORT_DIALOG_NUM_PROPERTIES];

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_EXPORT_FORMAT_PARAMETERS (export_format_parameters_get_type ())

#define TYPE_EXPORT_FORMAT_MODE (export_format_mode_get_type ())

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())
typedef struct _ExportFormatParameters ExportFormatParameters;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PHOTO_FILE_FORMAT_PROPERTIES (photo_file_format_properties_get_type ())
#define PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatProperties))
#define PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))

typedef struct _PhotoFileFormatProperties PhotoFileFormatProperties;
typedef struct _PhotoFileFormatPropertiesClass PhotoFileFormatPropertiesClass;
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ExportDialog {
	GtkDialog parent_instance;
	ExportDialogPrivate * priv;
};

struct _ExportDialogClass {
	GtkDialogClass parent_class;
};

struct _ExportDialogPrivate {
	GtkGrid* table;
	GtkComboBoxText* quality_combo;
	GtkComboBoxText* constraint_combo;
	GtkComboBoxText* format_combo;
	GtkSwitch* export_metadata;
	GeeArrayList* format_options;
	GtkEntry* pixels_entry;
	GtkWidget* ok_button;
	gboolean in_insert;
};

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

typedef enum  {
	EXPORT_FORMAT_MODE_UNMODIFIED,
	EXPORT_FORMAT_MODE_CURRENT,
	EXPORT_FORMAT_MODE_SPECIFIED,
	EXPORT_FORMAT_MODE_LAST
} ExportFormatMode;

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

struct _ExportFormatParameters {
	ExportFormatMode mode;
	PhotoFileFormat specified_format;
	JpegQuality quality;
	gboolean export_metadata;
};


static gpointer export_dialog_parent_class = NULL;
static ScaleConstraint export_dialog_current_constraint;
static ScaleConstraint export_dialog_current_constraint = SCALE_CONSTRAINT_ORIGINAL;
static ExportFormatParameters export_dialog_current_parameters;
static ExportFormatParameters export_dialog_current_parameters = {0};
static gint export_dialog_current_scale;
static gint export_dialog_current_scale = 0;

GType export_dialog_get_type (void) G_GNUC_CONST;
#define EXPORT_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EXPORT_DIALOG, ExportDialogPrivate))
GType scale_constraint_get_type (void) G_GNUC_CONST;
GType export_format_parameters_get_type (void) G_GNUC_CONST;
GType export_format_mode_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
GType jpeg_quality_get_type (void) G_GNUC_CONST;
ExportFormatParameters* export_format_parameters_dup (const ExportFormatParameters* self);
void export_format_parameters_free (ExportFormatParameters* self);
void export_format_parameters_current (ExportFormatParameters* result);
#define EXPORT_DIALOG_DEFAULT_SCALE 1200
#define EXPORT_DIALOG_NUM_SPECIAL_FORMATS 2
#define EXPORT_DIALOG_UNMODIFIED_FORMAT_LABEL _ ("Unmodified")
#define EXPORT_DIALOG_CURRENT_FORMAT_LABEL _ ("Current")
ExportDialog* export_dialog_new (const gchar* title);
ExportDialog* export_dialog_construct (GType object_type,
                                       const gchar* title);
gint resources_use_header_bar (void);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
ExportFormatMode configuration_facade_get_export_export_format_mode (ConfigurationFacade* self);
PhotoFileFormat configuration_facade_get_export_photo_file_format (ConfigurationFacade* self);
JpegQuality configuration_facade_get_export_quality (ConfigurationFacade* self);
gboolean configuration_facade_get_export_export_metadata (ConfigurationFacade* self);
ScaleConstraint configuration_facade_get_export_constraint (ConfigurationFacade* self);
gint configuration_facade_get_export_scale (ConfigurationFacade* self);
gchar* jpeg_quality_to_string (JpegQuality self);
gchar* scale_constraint_to_string (ScaleConstraint self);
static void export_dialog_format_add_option (ExportDialog* self,
                                      const gchar* format_name);
PhotoFileFormat* photo_file_format_get_writeable (int* result_length1);
gpointer photo_file_format_properties_ref (gpointer instance);
void photo_file_format_properties_unref (gpointer instance);
GParamSpec* param_spec_photo_file_format_properties (const gchar* name,
                                                     const gchar* nick,
                                                     const gchar* blurb,
                                                     GType object_type,
                                                     GParamFlags flags);
void value_set_photo_file_format_properties (GValue* value,
                                             gpointer v_object);
void value_take_photo_file_format_properties (GValue* value,
                                              gpointer v_object);
gpointer value_get_photo_file_format_properties (const GValue* value);
GType photo_file_format_properties_get_type (void) G_GNUC_CONST;
PhotoFileFormatProperties* photo_file_format_get_properties (PhotoFileFormat self);
gchar* photo_file_format_properties_get_user_visible_name (PhotoFileFormatProperties* self);
static void export_dialog_on_constraint_changed (ExportDialog* self);
static void _export_dialog_on_constraint_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                 gpointer self);
static void export_dialog_on_format_changed (ExportDialog* self);
static void _export_dialog_on_format_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                             gpointer self);
static void export_dialog_on_pixels_changed (ExportDialog* self);
static void _export_dialog_on_pixels_changed_gtk_editable_changed (GtkEditable* _sender,
                                                            gpointer self);
static void export_dialog_on_pixels_insert_text (ExportDialog* self,
                                          const gchar* text,
                                          gint length,
                                          gint* position);
static void _export_dialog_on_pixels_insert_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                                    const gchar* new_text,
                                                                    gint new_text_length,
                                                                    gint* position,
                                                                    gpointer self);
static void export_dialog_on_activate (ExportDialog* self);
static void _export_dialog_on_activate_gtk_entry_activate (GtkEntry* _sender,
                                                    gpointer self);
static void export_dialog_add_label (ExportDialog* self,
                              const gchar* text,
                              gint x,
                              gint y,
                              GtkWidget* widget);
static void export_dialog_add_control (ExportDialog* self,
                                GtkWidget* widget,
                                gint x,
                                gint y);
#define RESOURCES_CANCEL_LABEL _ ("_Cancel")
#define RESOURCES_OK_LABEL _ ("_OK")
static void export_dialog_format_set_active_text (ExportDialog* self,
                                           const gchar* text);
static PhotoFileFormat export_dialog_get_specified_format (ExportDialog* self);
static gchar* export_dialog_get_label_for_parameters (ExportDialog* self,
                                               ExportFormatParameters* params);
gboolean export_dialog_execute (ExportDialog* self,
                                gint* scale,
                                ScaleConstraint* constraint,
                                ExportFormatParameters* parameters);
gboolean photo_file_format_can_write (PhotoFileFormat self);
PhotoFileFormat photo_file_format_get_system_default_format (void);
void configuration_facade_set_export_export_format_mode (ConfigurationFacade* self,
                                                         ExportFormatMode export_format_mode);
void configuration_facade_set_export_photo_file_format (ConfigurationFacade* self,
                                                        PhotoFileFormat photo_file_format);
void configuration_facade_set_export_quality (ConfigurationFacade* self,
                                              JpegQuality quality);
void configuration_facade_set_export_export_metadata (ConfigurationFacade* self,
                                                      gboolean export_metadata);
void configuration_facade_set_export_constraint (ConfigurationFacade* self,
                                                 ScaleConstraint constraint);
void configuration_facade_set_export_scale (ConfigurationFacade* self,
                                            gint scale);
static void export_dialog_finalize (GObject * obj);

const ScaleConstraint EXPORT_DIALOG_CONSTRAINT_ARRAY[4] = {SCALE_CONSTRAINT_ORIGINAL, SCALE_CONSTRAINT_DIMENSIONS, SCALE_CONSTRAINT_WIDTH, SCALE_CONSTRAINT_HEIGHT};
const JpegQuality EXPORT_DIALOG_QUALITY_ARRAY[4] = {JPEG_QUALITY_LOW, JPEG_QUALITY_MEDIUM, JPEG_QUALITY_HIGH, JPEG_QUALITY_MAXIMUM};

static void
_export_dialog_on_constraint_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                            gpointer self)
{
#line 83 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_on_constraint_changed ((ExportDialog*) self);
#line 267 "ExportDialog.c"
}


static void
_export_dialog_on_format_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                        gpointer self)
{
#line 84 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_on_format_changed ((ExportDialog*) self);
#line 277 "ExportDialog.c"
}


static void
_export_dialog_on_pixels_changed_gtk_editable_changed (GtkEditable* _sender,
                                                       gpointer self)
{
#line 85 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_on_pixels_changed ((ExportDialog*) self);
#line 287 "ExportDialog.c"
}


static void
_export_dialog_on_pixels_insert_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                               const gchar* new_text,
                                                               gint new_text_length,
                                                               gint* position,
                                                               gpointer self)
{
#line 86 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_on_pixels_insert_text ((ExportDialog*) self, new_text, new_text_length, position);
#line 300 "ExportDialog.c"
}


static void
_export_dialog_on_activate_gtk_entry_activate (GtkEntry* _sender,
                                               gpointer self)
{
#line 87 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_on_activate ((ExportDialog*) self);
#line 310 "ExportDialog.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 116 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	return self ? g_object_ref (self) : NULL;
#line 319 "ExportDialog.c"
}


ExportDialog*
export_dialog_construct (GType object_type,
                         const gchar* title)
{
	ExportDialog * self = NULL;
	ConfigFacade* config = NULL;
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	ConfigFacade* _tmp2_;
	ConfigFacade* _tmp3_;
	ConfigFacade* _tmp4_;
	ConfigFacade* _tmp5_;
	ConfigFacade* _tmp6_;
	GtkComboBoxText* _tmp7_;
	gint ctr = 0;
	GtkComboBoxText* _tmp18_;
	GtkComboBoxText* _tmp28_;
	gint _tmp29_;
	PhotoFileFormat* _tmp30_;
	GtkEntry* _tmp36_;
	GtkEntry* _tmp37_;
	GtkEntry* _tmp38_;
	gint _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GtkComboBoxText* _tmp42_;
	GtkComboBoxText* _tmp43_;
	GtkEntry* _tmp44_;
	GtkEntry* _tmp45_;
	GtkEntry* _tmp46_;
	GtkComboBoxText* _tmp47_;
	GtkComboBoxText* _tmp48_;
	GtkComboBoxText* _tmp49_;
	GtkComboBoxText* _tmp50_;
	GtkComboBoxText* _tmp51_;
	GtkComboBoxText* _tmp52_;
	GtkEntry* _tmp53_;
	GtkEntry* _tmp54_;
	GtkSwitch* _tmp55_;
	GtkSwitch* _tmp56_;
	GtkSwitch* _tmp57_;
	GtkSwitch* _tmp58_;
	GtkSwitch* _tmp59_;
	GtkGrid* _tmp60_;
	GtkGrid* _tmp61_;
	GtkGrid* _tmp62_;
	GtkBox* _tmp63_;
	GtkGrid* _tmp64_;
	GtkWidget* _tmp65_;
	GtkWidget* _tmp66_;
	GtkWidget* _tmp67_;
	GtkWidget* _tmp68_;
	GtkWidget* _tmp69_;
	ScaleConstraint _tmp70_;
	GtkWidget* _tmp73_;
#line 38 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 39 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	self = (ExportDialog*) g_object_new (object_type, "use-header-bar", resources_use_header_bar (), NULL);
#line 41 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), title);
#line 42 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_window_set_resizable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), FALSE);
#line 45 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp0_ = config_facade_get_instance ();
#line 45 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	config = _tmp0_;
#line 46 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp1_ = config;
#line 46 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_current_parameters.mode = configuration_facade_get_export_export_format_mode (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 47 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp2_ = config;
#line 47 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_current_parameters.specified_format = configuration_facade_get_export_photo_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 48 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp3_ = config;
#line 48 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_current_parameters.quality = configuration_facade_get_export_quality (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 49 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp4_ = config;
#line 49 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_current_parameters.export_metadata = configuration_facade_get_export_export_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 50 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp5_ = config;
#line 50 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_current_constraint = configuration_facade_get_export_constraint (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 51 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp6_ = config;
#line 51 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_current_scale = configuration_facade_get_export_scale (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 53 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp7_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
#line 53 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_object_ref_sink (_tmp7_);
#line 53 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_g_object_unref0 (self->priv->quality_combo);
#line 53 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	self->priv->quality_combo = _tmp7_;
#line 54 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	ctr = 0;
#line 424 "ExportDialog.c"
	{
		JpegQuality* quality_collection = NULL;
		gint quality_collection_length1 = 0;
		gint _quality_collection_size_ = 0;
		gint quality_it = 0;
#line 55 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		quality_collection = EXPORT_DIALOG_QUALITY_ARRAY;
#line 55 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		quality_collection_length1 = G_N_ELEMENTS (EXPORT_DIALOG_QUALITY_ARRAY);
#line 55 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		for (quality_it = 0; quality_it < G_N_ELEMENTS (EXPORT_DIALOG_QUALITY_ARRAY); quality_it = quality_it + 1) {
#line 436 "ExportDialog.c"
			JpegQuality quality = 0;
#line 55 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			quality = quality_collection[quality_it];
#line 440 "ExportDialog.c"
			{
				GtkComboBoxText* _tmp8_;
				JpegQuality _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				JpegQuality _tmp12_;
				ExportFormatParameters _tmp13_;
				JpegQuality _tmp14_;
				gint _tmp17_;
#line 56 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp8_ = self->priv->quality_combo;
#line 56 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp9_ = quality;
#line 56 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp10_ = jpeg_quality_to_string (_tmp9_);
#line 56 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp11_ = _tmp10_;
#line 56 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				gtk_combo_box_text_append_text (_tmp8_, _tmp11_);
#line 56 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_g_free0 (_tmp11_);
#line 57 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp12_ = quality;
#line 57 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp13_ = export_dialog_current_parameters;
#line 57 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp14_ = _tmp13_.quality;
#line 57 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				if (_tmp12_ == _tmp14_) {
#line 470 "ExportDialog.c"
					GtkComboBoxText* _tmp15_;
					gint _tmp16_;
#line 58 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
					_tmp15_ = self->priv->quality_combo;
#line 58 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
					_tmp16_ = ctr;
#line 58 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
					gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_combo_box_get_type (), GtkComboBox), _tmp16_);
#line 479 "ExportDialog.c"
				}
#line 59 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp17_ = ctr;
#line 59 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				ctr = _tmp17_ + 1;
#line 485 "ExportDialog.c"
			}
		}
	}
#line 62 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp18_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
#line 62 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_object_ref_sink (_tmp18_);
#line 62 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_g_object_unref0 (self->priv->constraint_combo);
#line 62 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	self->priv->constraint_combo = _tmp18_;
#line 63 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	ctr = 0;
#line 499 "ExportDialog.c"
	{
		ScaleConstraint* constraint_collection = NULL;
		gint constraint_collection_length1 = 0;
		gint _constraint_collection_size_ = 0;
		gint constraint_it = 0;
#line 64 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		constraint_collection = EXPORT_DIALOG_CONSTRAINT_ARRAY;
#line 64 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		constraint_collection_length1 = G_N_ELEMENTS (EXPORT_DIALOG_CONSTRAINT_ARRAY);
#line 64 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		for (constraint_it = 0; constraint_it < G_N_ELEMENTS (EXPORT_DIALOG_CONSTRAINT_ARRAY); constraint_it = constraint_it + 1) {
#line 511 "ExportDialog.c"
			ScaleConstraint constraint = 0;
#line 64 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			constraint = constraint_collection[constraint_it];
#line 515 "ExportDialog.c"
			{
				GtkComboBoxText* _tmp19_;
				ScaleConstraint _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				ScaleConstraint _tmp23_;
				ScaleConstraint _tmp24_;
				gint _tmp27_;
#line 65 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp19_ = self->priv->constraint_combo;
#line 65 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp20_ = constraint;
#line 65 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp21_ = scale_constraint_to_string (_tmp20_);
#line 65 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp22_ = _tmp21_;
#line 65 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				gtk_combo_box_text_append_text (_tmp19_, _tmp22_);
#line 65 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_g_free0 (_tmp22_);
#line 66 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp23_ = constraint;
#line 66 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp24_ = export_dialog_current_constraint;
#line 66 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				if (_tmp23_ == _tmp24_) {
#line 542 "ExportDialog.c"
					GtkComboBoxText* _tmp25_;
					gint _tmp26_;
#line 67 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
					_tmp25_ = self->priv->constraint_combo;
#line 67 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
					_tmp26_ = ctr;
#line 67 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
					gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_combo_box_get_type (), GtkComboBox), _tmp26_);
#line 551 "ExportDialog.c"
				}
#line 68 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp27_ = ctr;
#line 68 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				ctr = _tmp27_ + 1;
#line 557 "ExportDialog.c"
			}
		}
	}
#line 71 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp28_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
#line 71 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_object_ref_sink (_tmp28_);
#line 71 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_g_object_unref0 (self->priv->format_combo);
#line 71 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	self->priv->format_combo = _tmp28_;
#line 72 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_format_add_option (self, EXPORT_DIALOG_UNMODIFIED_FORMAT_LABEL);
#line 73 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_format_add_option (self, EXPORT_DIALOG_CURRENT_FORMAT_LABEL);
#line 74 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp30_ = photo_file_format_get_writeable (&_tmp29_);
#line 575 "ExportDialog.c"
	{
		PhotoFileFormat* format_collection = NULL;
		gint format_collection_length1 = 0;
		gint _format_collection_size_ = 0;
		gint format_it = 0;
#line 74 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		format_collection = _tmp30_;
#line 74 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		format_collection_length1 = _tmp29_;
#line 74 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		for (format_it = 0; format_it < _tmp29_; format_it = format_it + 1) {
#line 587 "ExportDialog.c"
			PhotoFileFormat format = 0;
#line 74 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			format = format_collection[format_it];
#line 591 "ExportDialog.c"
			{
				PhotoFileFormat _tmp31_;
				PhotoFileFormatProperties* _tmp32_;
				PhotoFileFormatProperties* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
#line 75 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp31_ = format;
#line 75 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp32_ = photo_file_format_get_properties (_tmp31_);
#line 75 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp33_ = _tmp32_;
#line 75 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp34_ = photo_file_format_properties_get_user_visible_name (_tmp33_);
#line 75 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp35_ = _tmp34_;
#line 75 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				export_dialog_format_add_option (self, _tmp35_);
#line 75 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_g_free0 (_tmp35_);
#line 75 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_photo_file_format_properties_unref0 (_tmp33_);
#line 614 "ExportDialog.c"
			}
		}
#line 74 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		format_collection = (g_free (format_collection), NULL);
#line 619 "ExportDialog.c"
	}
#line 78 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp36_ = (GtkEntry*) gtk_entry_new ();
#line 78 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_object_ref_sink (_tmp36_);
#line 78 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_g_object_unref0 (self->priv->pixels_entry);
#line 78 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	self->priv->pixels_entry = _tmp36_;
#line 79 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp37_ = self->priv->pixels_entry;
#line 79 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_entry_set_max_length (_tmp37_, 6);
#line 80 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp38_ = self->priv->pixels_entry;
#line 80 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp39_ = export_dialog_current_scale;
#line 80 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp40_ = g_strdup_printf ("%d", _tmp39_);
#line 80 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp41_ = _tmp40_;
#line 80 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_entry_set_text (_tmp38_, _tmp41_);
#line 80 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_g_free0 (_tmp41_);
#line 83 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp42_ = self->priv->constraint_combo;
#line 83 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_combo_box_get_type (), GtkComboBox), "changed", (GCallback) _export_dialog_on_constraint_changed_gtk_combo_box_changed, self, 0);
#line 84 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp43_ = self->priv->format_combo;
#line 84 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_combo_box_get_type (), GtkComboBox), "changed", (GCallback) _export_dialog_on_format_changed_gtk_combo_box_changed, self, 0);
#line 85 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp44_ = self->priv->pixels_entry;
#line 85 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, gtk_editable_get_type (), GtkEditable), "changed", (GCallback) _export_dialog_on_pixels_changed_gtk_editable_changed, self, 0);
#line 86 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp45_ = self->priv->pixels_entry;
#line 86 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, gtk_editable_get_type (), GtkEditable), "insert-text", (GCallback) _export_dialog_on_pixels_insert_text_gtk_editable_insert_text, self, 0);
#line 87 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp46_ = self->priv->pixels_entry;
#line 87 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_signal_connect_object (_tmp46_, "activate", (GCallback) _export_dialog_on_activate_gtk_entry_activate, self, 0);
#line 90 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp47_ = self->priv->format_combo;
#line 90 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_add_label (self, _ ("_Format:"), 0, 0, G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gtk_widget_get_type (), GtkWidget));
#line 91 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp48_ = self->priv->format_combo;
#line 91 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_add_control (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, gtk_widget_get_type (), GtkWidget), 1, 0);
#line 93 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp49_ = self->priv->quality_combo;
#line 93 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_add_label (self, _ ("_Quality:"), 0, 1, G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, gtk_widget_get_type (), GtkWidget));
#line 94 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp50_ = self->priv->quality_combo;
#line 94 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_add_control (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, gtk_widget_get_type (), GtkWidget), 1, 1);
#line 96 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp51_ = self->priv->constraint_combo;
#line 96 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_add_label (self, _ ("_Scaling constraint:"), 0, 2, G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, gtk_widget_get_type (), GtkWidget));
#line 97 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp52_ = self->priv->constraint_combo;
#line 97 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_add_control (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, gtk_widget_get_type (), GtkWidget), 1, 2);
#line 99 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp53_ = self->priv->pixels_entry;
#line 99 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_add_label (self, _ ("_Pixels:"), 0, 3, G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_widget_get_type (), GtkWidget));
#line 100 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp54_ = self->priv->pixels_entry;
#line 100 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_add_control (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, gtk_widget_get_type (), GtkWidget), 1, 3);
#line 102 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp55_ = (GtkSwitch*) gtk_switch_new ();
#line 102 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_object_ref_sink (_tmp55_);
#line 102 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_g_object_unref0 (self->priv->export_metadata);
#line 102 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	self->priv->export_metadata = _tmp55_;
#line 103 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp56_ = self->priv->export_metadata;
#line 103 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_add_label (self, _ ("Export _metadata:"), 0, 4, G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, gtk_widget_get_type (), GtkWidget));
#line 104 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp57_ = self->priv->export_metadata;
#line 104 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_add_control (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, gtk_widget_get_type (), GtkWidget), 1, 4);
#line 105 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp58_ = self->priv->export_metadata;
#line 105 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_switch_set_active (_tmp58_, TRUE);
#line 106 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp59_ = self->priv->export_metadata;
#line 106 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
#line 108 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp60_ = self->priv->table;
#line 108 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_grid_set_row_spacing (_tmp60_, (guint) 6);
#line 109 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp61_ = self->priv->table;
#line 109 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_grid_set_column_spacing (_tmp61_, (guint) 12);
#line 110 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp62_ = self->priv->table;
#line 110 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_container_set_border_width (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, gtk_container_get_type (), GtkContainer), (guint) 18);
#line 112 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp63_ = gtk_dialog_get_content_area (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog));
#line 112 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp64_ = self->priv->table;
#line 112 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, gtk_box_get_type (), GtkBox), gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, gtk_widget_get_type (), GtkWidget));
#line 115 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), RESOURCES_CANCEL_LABEL, (gint) GTK_RESPONSE_CANCEL);
#line 116 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp65_ = gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), RESOURCES_OK_LABEL, (gint) GTK_RESPONSE_OK);
#line 116 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp66_ = _g_object_ref0 (_tmp65_);
#line 116 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_g_object_unref0 (self->priv->ok_button);
#line 116 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	self->priv->ok_button = _tmp66_;
#line 117 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_dialog_set_default_response (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), (gint) GTK_RESPONSE_OK);
#line 119 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp67_ = self->priv->ok_button;
#line 119 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_widget_set_can_default (_tmp67_, TRUE);
#line 120 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp68_ = self->priv->ok_button;
#line 120 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_object_set (_tmp68_, "has-default", TRUE, NULL);
#line 121 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp69_ = self->priv->ok_button;
#line 121 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_window_set_default (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp69_);
#line 123 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp70_ = export_dialog_current_constraint;
#line 123 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	if (_tmp70_ == SCALE_CONSTRAINT_ORIGINAL) {
#line 767 "ExportDialog.c"
		GtkEntry* _tmp71_;
		GtkComboBoxText* _tmp72_;
#line 124 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp71_ = self->priv->pixels_entry;
#line 124 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 125 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp72_ = self->priv->quality_combo;
#line 125 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 778 "ExportDialog.c"
	}
#line 128 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp73_ = self->priv->ok_button;
#line 128 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_widget_grab_focus (_tmp73_);
#line 38 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_g_object_unref0 (config);
#line 38 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	return self;
#line 788 "ExportDialog.c"
}


ExportDialog*
export_dialog_new (const gchar* title)
{
#line 38 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	return export_dialog_construct (TYPE_EXPORT_DIALOG, title);
#line 797 "ExportDialog.c"
}


static void
export_dialog_format_add_option (ExportDialog* self,
                                 const gchar* format_name)
{
	GeeArrayList* _tmp0_;
	GtkComboBoxText* _tmp1_;
#line 131 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_return_if_fail (IS_EXPORT_DIALOG (self));
#line 131 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_return_if_fail (format_name != NULL);
#line 132 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp0_ = self->priv->format_options;
#line 132 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), format_name);
#line 133 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp1_ = self->priv->format_combo;
#line 133 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_combo_box_text_append_text (_tmp1_, format_name);
#line 819 "ExportDialog.c"
}


static void
export_dialog_format_set_active_text (ExportDialog* self,
                                      const gchar* text)
{
	gint selection_ticker = 0;
#line 136 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_return_if_fail (IS_EXPORT_DIALOG (self));
#line 136 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_return_if_fail (text != NULL);
#line 137 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	selection_ticker = 0;
#line 834 "ExportDialog.c"
	{
		GeeArrayList* _current_text_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _current_text_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _current_text_index = 0;
#line 139 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp0_ = self->priv->format_options;
#line 139 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 139 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_current_text_list = _tmp1_;
#line 139 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp2_ = _current_text_list;
#line 139 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp3_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 139 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp4_ = _tmp3_;
#line 139 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_current_text_size = _tmp4_;
#line 139 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_current_text_index = -1;
#line 139 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		while (TRUE) {
#line 862 "ExportDialog.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gchar* current_text = NULL;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			const gchar* _tmp11_;
			gint _tmp14_;
#line 139 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp5_ = _current_text_index;
#line 139 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_current_text_index = _tmp5_ + 1;
#line 139 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp6_ = _current_text_index;
#line 139 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp7_ = _current_text_size;
#line 139 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 139 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				break;
#line 884 "ExportDialog.c"
			}
#line 139 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp8_ = _current_text_list;
#line 139 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp9_ = _current_text_index;
#line 139 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp10_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp9_);
#line 139 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			current_text = (gchar*) _tmp10_;
#line 140 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp11_ = current_text;
#line 140 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			if (g_strcmp0 (_tmp11_, text) == 0) {
#line 898 "ExportDialog.c"
				GtkComboBoxText* _tmp12_;
				gint _tmp13_;
#line 141 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp12_ = self->priv->format_combo;
#line 141 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp13_ = selection_ticker;
#line 141 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_combo_box_get_type (), GtkComboBox), _tmp13_);
#line 142 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_g_free0 (current_text);
#line 142 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_g_object_unref0 (_current_text_list);
#line 142 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				return;
#line 913 "ExportDialog.c"
			}
#line 144 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp14_ = selection_ticker;
#line 144 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			selection_ticker = _tmp14_ + 1;
#line 139 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_g_free0 (current_text);
#line 921 "ExportDialog.c"
		}
#line 139 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_g_object_unref0 (_current_text_list);
#line 925 "ExportDialog.c"
	}
#line 147 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_error ("ExportDialog.vala:147: format_set_active_text: text '%s' isn't in comb" \
"o box", text);
#line 929 "ExportDialog.c"
}


static PhotoFileFormat
export_dialog_get_specified_format (ExportDialog* self)
{
	PhotoFileFormat result = 0;
	gint index = 0;
	GtkComboBoxText* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	PhotoFileFormat* writeable_formats = NULL;
	gint _tmp3_;
	PhotoFileFormat* _tmp4_;
	gint writeable_formats_length1;
	gint _writeable_formats_size_;
	gint _tmp5_;
	PhotoFileFormat _tmp6_;
#line 150 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_return_val_if_fail (IS_EXPORT_DIALOG (self), 0);
#line 151 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp0_ = self->priv->format_combo;
#line 151 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	index = gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox));
#line 152 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp1_ = index;
#line 152 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	if (_tmp1_ < EXPORT_DIALOG_NUM_SPECIAL_FORMATS) {
#line 153 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		index = EXPORT_DIALOG_NUM_SPECIAL_FORMATS;
#line 960 "ExportDialog.c"
	}
#line 155 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp2_ = index;
#line 155 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	index = _tmp2_ - EXPORT_DIALOG_NUM_SPECIAL_FORMATS;
#line 156 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp4_ = photo_file_format_get_writeable (&_tmp3_);
#line 156 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	writeable_formats = _tmp4_;
#line 156 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	writeable_formats_length1 = _tmp3_;
#line 156 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_writeable_formats_size_ = writeable_formats_length1;
#line 157 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp5_ = index;
#line 157 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp6_ = writeable_formats[_tmp5_];
#line 157 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	result = _tmp6_;
#line 157 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	writeable_formats = (g_free (writeable_formats), NULL);
#line 157 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	return result;
#line 984 "ExportDialog.c"
}


static gchar*
export_dialog_get_label_for_parameters (ExportDialog* self,
                                        ExportFormatParameters* params)
{
	gchar* result = NULL;
	ExportFormatParameters _tmp0_;
	ExportFormatMode _tmp1_;
#line 160 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_return_val_if_fail (IS_EXPORT_DIALOG (self), NULL);
#line 160 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_return_val_if_fail (params != NULL, NULL);
#line 161 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp0_ = *params;
#line 161 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp1_ = _tmp0_.mode;
#line 161 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	switch (_tmp1_) {
#line 161 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		case EXPORT_FORMAT_MODE_UNMODIFIED:
#line 1007 "ExportDialog.c"
		{
			gchar* _tmp2_;
#line 163 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp2_ = g_strdup (EXPORT_DIALOG_UNMODIFIED_FORMAT_LABEL);
#line 163 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			result = _tmp2_;
#line 163 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			return result;
#line 1016 "ExportDialog.c"
		}
#line 161 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		case EXPORT_FORMAT_MODE_CURRENT:
#line 1020 "ExportDialog.c"
		{
			gchar* _tmp3_;
#line 166 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp3_ = g_strdup (EXPORT_DIALOG_CURRENT_FORMAT_LABEL);
#line 166 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			result = _tmp3_;
#line 166 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			return result;
#line 1029 "ExportDialog.c"
		}
#line 161 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		case EXPORT_FORMAT_MODE_SPECIFIED:
#line 1033 "ExportDialog.c"
		{
			ExportFormatParameters _tmp4_;
			PhotoFileFormat _tmp5_;
			PhotoFileFormatProperties* _tmp6_;
			PhotoFileFormatProperties* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
#line 169 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp4_ = *params;
#line 169 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp5_ = _tmp4_.specified_format;
#line 169 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp6_ = photo_file_format_get_properties (_tmp5_);
#line 169 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp7_ = _tmp6_;
#line 169 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp8_ = photo_file_format_properties_get_user_visible_name (_tmp7_);
#line 169 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp9_ = _tmp8_;
#line 169 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_photo_file_format_properties_unref0 (_tmp7_);
#line 169 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			result = _tmp9_;
#line 169 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			return result;
#line 1059 "ExportDialog.c"
		}
		default:
		{
#line 172 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			g_error ("ExportDialog.vala:172: get_label_for_parameters: unrecognized export f" \
"ormat mode");
#line 1065 "ExportDialog.c"
		}
	}
}


gboolean
export_dialog_execute (ExportDialog* self,
                       gint* scale,
                       ScaleConstraint* constraint,
                       ExportFormatParameters* parameters)
{
	gint _vala_scale = 0;
	ScaleConstraint _vala_constraint = 0;
	gboolean result = FALSE;
	ExportFormatParameters _tmp0_;
	ExportFormatMode _tmp1_;
	ExportFormatParameters _tmp4_;
	ExportFormatMode _tmp5_;
	ExportFormatParameters _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean ok = FALSE;
	gboolean _tmp15_;
#line 179 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_return_val_if_fail (IS_EXPORT_DIALOG (self), FALSE);
#line 179 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_return_val_if_fail (parameters != NULL, FALSE);
#line 181 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 185 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp0_ = *parameters;
#line 185 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp1_ = _tmp0_.mode;
#line 185 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	if (_tmp1_ != EXPORT_FORMAT_MODE_LAST) {
#line 1101 "ExportDialog.c"
		ScaleConstraint _tmp2_;
		GtkComboBoxText* _tmp3_;
#line 186 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_vala_constraint = SCALE_CONSTRAINT_ORIGINAL;
#line 186 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp2_ = _vala_constraint;
#line 186 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		export_dialog_current_constraint = _tmp2_;
#line 187 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp3_ = self->priv->constraint_combo;
#line 187 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_combo_box_get_type (), GtkComboBox), 0);
#line 1114 "ExportDialog.c"
	}
#line 190 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp4_ = *parameters;
#line 190 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp5_ = _tmp4_.mode;
#line 190 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	if (_tmp5_ == EXPORT_FORMAT_MODE_LAST) {
#line 1122 "ExportDialog.c"
		ExportFormatParameters _tmp6_;
#line 191 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp6_ = export_dialog_current_parameters;
#line 191 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		*parameters = _tmp6_;
#line 1128 "ExportDialog.c"
	} else {
		gboolean _tmp7_ = FALSE;
		ExportFormatParameters _tmp8_;
		ExportFormatMode _tmp9_;
#line 192 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp8_ = *parameters;
#line 192 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp9_ = _tmp8_.mode;
#line 192 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		if (_tmp9_ == EXPORT_FORMAT_MODE_SPECIFIED) {
#line 1139 "ExportDialog.c"
			ExportFormatParameters _tmp10_;
			PhotoFileFormat _tmp11_;
#line 192 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp10_ = *parameters;
#line 192 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp11_ = _tmp10_.specified_format;
#line 192 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp7_ = !photo_file_format_can_write (_tmp11_);
#line 1148 "ExportDialog.c"
		} else {
#line 192 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp7_ = FALSE;
#line 1152 "ExportDialog.c"
		}
#line 192 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		if (_tmp7_) {
#line 193 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			(*parameters).specified_format = photo_file_format_get_system_default_format ();
#line 1158 "ExportDialog.c"
		}
	}
#line 195 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp12_ = *parameters;
#line 195 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp13_ = export_dialog_get_label_for_parameters (self, &_tmp12_);
#line 195 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp14_ = _tmp13_;
#line 195 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_format_set_active_text (self, _tmp14_);
#line 195 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_g_free0 (_tmp14_);
#line 196 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_on_format_changed (self);
#line 198 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	ok = gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog)) == ((gint) GTK_RESPONSE_OK);
#line 199 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp15_ = ok;
#line 199 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	if (_tmp15_) {
#line 1179 "ExportDialog.c"
		gint index = 0;
		GtkComboBoxText* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		ScaleConstraint _tmp19_;
		ScaleConstraint _tmp20_;
		GtkEntry* _tmp21_;
		const gchar* _tmp22_;
		ScaleConstraint _tmp23_;
		gint _tmp25_;
		gboolean _tmp26_ = FALSE;
		GtkSwitch* _tmp27_;
		gboolean _tmp28_;
		gboolean _tmp29_;
		GtkComboBoxText* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gboolean _tmp36_;
		ConfigFacade* config = NULL;
		ConfigFacade* _tmp50_;
		ConfigFacade* _tmp51_;
		ExportFormatParameters _tmp52_;
		ExportFormatMode _tmp53_;
		ConfigFacade* _tmp54_;
		ExportFormatParameters _tmp55_;
		PhotoFileFormat _tmp56_;
		ConfigFacade* _tmp57_;
		ExportFormatParameters _tmp58_;
		JpegQuality _tmp59_;
		ConfigFacade* _tmp60_;
		ExportFormatParameters _tmp61_;
		gboolean _tmp62_;
		ConfigFacade* _tmp63_;
		ScaleConstraint _tmp64_;
		ConfigFacade* _tmp65_;
		gint _tmp66_;
#line 200 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp16_ = self->priv->constraint_combo;
#line 200 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		index = gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_combo_box_get_type (), GtkComboBox));
#line 201 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp17_ = index;
#line 201 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_vala_assert (_tmp17_ >= 0, "index >= 0");
#line 202 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp18_ = index;
#line 202 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp19_ = EXPORT_DIALOG_CONSTRAINT_ARRAY[_tmp18_];
#line 202 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_vala_constraint = _tmp19_;
#line 203 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp20_ = _vala_constraint;
#line 203 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		export_dialog_current_constraint = _tmp20_;
#line 205 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp21_ = self->priv->pixels_entry;
#line 205 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp22_ = gtk_entry_get_text (_tmp21_);
#line 205 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_vala_scale = atoi (_tmp22_);
#line 206 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp23_ = _vala_constraint;
#line 206 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		if (_tmp23_ != SCALE_CONSTRAINT_ORIGINAL) {
#line 1244 "ExportDialog.c"
			gint _tmp24_;
#line 207 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp24_ = _vala_scale;
#line 207 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_vala_assert (_tmp24_ > 0, "scale > 0");
#line 1250 "ExportDialog.c"
		}
#line 208 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp25_ = _vala_scale;
#line 208 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		export_dialog_current_scale = _tmp25_;
#line 210 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp27_ = self->priv->export_metadata;
#line 210 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp28_ = gtk_widget_get_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget));
#line 210 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp29_ = _tmp28_;
#line 210 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		if (_tmp29_) {
#line 1264 "ExportDialog.c"
			GtkSwitch* _tmp30_;
			gboolean _tmp31_;
			gboolean _tmp32_;
#line 210 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp30_ = self->priv->export_metadata;
#line 210 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp31_ = gtk_switch_get_active (_tmp30_);
#line 210 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp32_ = _tmp31_;
#line 210 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp26_ = _tmp32_;
#line 1276 "ExportDialog.c"
		} else {
#line 210 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp26_ = FALSE;
#line 1280 "ExportDialog.c"
		}
#line 210 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		(*parameters).export_metadata = _tmp26_;
#line 212 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp33_ = self->priv->format_combo;
#line 212 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp34_ = gtk_combo_box_text_get_active_text (_tmp33_);
#line 212 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp35_ = _tmp34_;
#line 212 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp36_ = g_strcmp0 (_tmp35_, EXPORT_DIALOG_UNMODIFIED_FORMAT_LABEL) == 0;
#line 212 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_g_free0 (_tmp35_);
#line 212 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		if (_tmp36_) {
#line 1296 "ExportDialog.c"
			ExportFormatMode _tmp37_;
#line 213 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			export_dialog_current_parameters.mode = EXPORT_FORMAT_MODE_UNMODIFIED;
#line 213 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp37_ = export_dialog_current_parameters.mode;
#line 213 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			(*parameters).mode = _tmp37_;
#line 1304 "ExportDialog.c"
		} else {
			GtkComboBoxText* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gboolean _tmp41_;
#line 214 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp38_ = self->priv->format_combo;
#line 214 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp39_ = gtk_combo_box_text_get_active_text (_tmp38_);
#line 214 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp40_ = _tmp39_;
#line 214 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp41_ = g_strcmp0 (_tmp40_, EXPORT_DIALOG_CURRENT_FORMAT_LABEL) == 0;
#line 214 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_g_free0 (_tmp40_);
#line 214 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			if (_tmp41_) {
#line 1322 "ExportDialog.c"
				ExportFormatMode _tmp42_;
#line 215 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				export_dialog_current_parameters.mode = EXPORT_FORMAT_MODE_CURRENT;
#line 215 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp42_ = export_dialog_current_parameters.mode;
#line 215 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				(*parameters).mode = _tmp42_;
#line 1330 "ExportDialog.c"
			} else {
				ExportFormatMode _tmp43_;
				PhotoFileFormat _tmp44_;
				ExportFormatParameters _tmp45_;
				PhotoFileFormat _tmp46_;
#line 217 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				export_dialog_current_parameters.mode = EXPORT_FORMAT_MODE_SPECIFIED;
#line 217 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp43_ = export_dialog_current_parameters.mode;
#line 217 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				(*parameters).mode = _tmp43_;
#line 218 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				export_dialog_current_parameters.specified_format = export_dialog_get_specified_format (self);
#line 218 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp44_ = export_dialog_current_parameters.specified_format;
#line 218 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				(*parameters).specified_format = _tmp44_;
#line 219 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp45_ = export_dialog_current_parameters;
#line 219 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp46_ = _tmp45_.specified_format;
#line 219 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				if (_tmp46_ == PHOTO_FILE_FORMAT_JFIF) {
#line 1354 "ExportDialog.c"
					GtkComboBoxText* _tmp47_;
					JpegQuality _tmp48_;
					JpegQuality _tmp49_;
#line 220 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
					_tmp47_ = self->priv->quality_combo;
#line 220 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
					_tmp48_ = EXPORT_DIALOG_QUALITY_ARRAY[gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gtk_combo_box_get_type (), GtkComboBox))];
#line 220 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
					export_dialog_current_parameters.quality = _tmp48_;
#line 220 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
					_tmp49_ = export_dialog_current_parameters.quality;
#line 220 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
					(*parameters).quality = _tmp49_;
#line 1368 "ExportDialog.c"
				}
			}
		}
#line 224 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp50_ = config_facade_get_instance ();
#line 224 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		config = _tmp50_;
#line 225 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp51_ = config;
#line 225 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp52_ = export_dialog_current_parameters;
#line 225 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp53_ = _tmp52_.mode;
#line 225 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		configuration_facade_set_export_export_format_mode (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp53_);
#line 226 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp54_ = config;
#line 226 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp55_ = export_dialog_current_parameters;
#line 226 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp56_ = _tmp55_.specified_format;
#line 226 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		configuration_facade_set_export_photo_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp56_);
#line 227 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp57_ = config;
#line 227 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp58_ = export_dialog_current_parameters;
#line 227 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp59_ = _tmp58_.quality;
#line 227 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		configuration_facade_set_export_quality (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp59_);
#line 228 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp60_ = config;
#line 228 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp61_ = export_dialog_current_parameters;
#line 228 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp62_ = _tmp61_.export_metadata;
#line 228 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		configuration_facade_set_export_export_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp62_);
#line 229 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp63_ = config;
#line 229 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp64_ = export_dialog_current_constraint;
#line 229 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		configuration_facade_set_export_constraint (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp64_);
#line 230 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp65_ = config;
#line 230 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp66_ = export_dialog_current_scale;
#line 230 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		configuration_facade_set_export_scale (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp66_);
#line 199 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_g_object_unref0 (config);
#line 1422 "ExportDialog.c"
	} else {
#line 232 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_vala_scale = 0;
#line 233 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_vala_constraint = SCALE_CONSTRAINT_ORIGINAL;
#line 1428 "ExportDialog.c"
	}
#line 236 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 238 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	result = ok;
#line 238 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	if (scale) {
#line 238 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		*scale = _vala_scale;
#line 1438 "ExportDialog.c"
	}
#line 238 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	if (constraint) {
#line 238 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		*constraint = _vala_constraint;
#line 1444 "ExportDialog.c"
	}
#line 238 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	return result;
#line 1448 "ExportDialog.c"
}


static void
export_dialog_add_label (ExportDialog* self,
                         const gchar* text,
                         gint x,
                         gint y,
                         GtkWidget* widget)
{
	GtkLabel* new_label = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkGrid* _tmp5_;
	GtkLabel* _tmp6_;
#line 241 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_return_if_fail (IS_EXPORT_DIALOG (self));
#line 241 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_return_if_fail (text != NULL);
#line 241 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_return_if_fail ((widget == NULL) || GTK_IS_WIDGET (widget));
#line 242 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp0_ = (GtkLabel*) gtk_label_new_with_mnemonic (text);
#line 242 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_object_ref_sink (_tmp0_);
#line 242 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	new_label = _tmp0_;
#line 243 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp1_ = new_label;
#line 243 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_END);
#line 244 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp2_ = new_label;
#line 244 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
#line 245 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp3_ = new_label;
#line 245 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_label_set_use_underline (_tmp3_, TRUE);
#line 247 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	if (widget != NULL) {
#line 1492 "ExportDialog.c"
		GtkLabel* _tmp4_;
#line 248 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp4_ = new_label;
#line 248 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		gtk_label_set_mnemonic_widget (_tmp4_, widget);
#line 1498 "ExportDialog.c"
	}
#line 250 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp5_ = self->priv->table;
#line 250 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp6_ = new_label;
#line 250 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_grid_attach (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), x, y, 1, 1);
#line 241 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_g_object_unref0 (new_label);
#line 1508 "ExportDialog.c"
}


static void
export_dialog_add_control (ExportDialog* self,
                           GtkWidget* widget,
                           gint x,
                           gint y)
{
	GtkGrid* _tmp0_;
#line 253 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_return_if_fail (IS_EXPORT_DIALOG (self));
#line 253 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_return_if_fail (GTK_IS_WIDGET (widget));
#line 254 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_widget_set_halign (widget, GTK_ALIGN_FILL);
#line 255 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_widget_set_valign (widget, GTK_ALIGN_CENTER);
#line 256 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_widget_set_hexpand (widget, TRUE);
#line 257 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_widget_set_vexpand (widget, TRUE);
#line 259 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp0_ = self->priv->table;
#line 259 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_grid_attach (_tmp0_, widget, x, y, 1, 1);
#line 1535 "ExportDialog.c"
}


static void
export_dialog_on_constraint_changed (ExportDialog* self)
{
	gboolean original = FALSE;
	GtkComboBoxText* _tmp0_;
	ScaleConstraint _tmp1_;
	gboolean jpeg = FALSE;
	GtkComboBoxText* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	PhotoFileFormatProperties* _tmp5_;
	PhotoFileFormatProperties* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	GtkEntry* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_;
	GtkComboBoxText* _tmp15_;
	gboolean _tmp16_;
#line 262 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_return_if_fail (IS_EXPORT_DIALOG (self));
#line 263 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp0_ = self->priv->constraint_combo;
#line 263 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp1_ = EXPORT_DIALOG_CONSTRAINT_ARRAY[gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox))];
#line 263 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	original = _tmp1_ == SCALE_CONSTRAINT_ORIGINAL;
#line 264 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp2_ = self->priv->format_combo;
#line 264 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp3_ = gtk_combo_box_text_get_active_text (_tmp2_);
#line 264 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp4_ = _tmp3_;
#line 264 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp5_ = photo_file_format_get_properties (PHOTO_FILE_FORMAT_JFIF);
#line 264 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp6_ = _tmp5_;
#line 264 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp7_ = photo_file_format_properties_get_user_visible_name (_tmp6_);
#line 264 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp8_ = _tmp7_;
#line 264 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp9_ = g_strcmp0 (_tmp4_, _tmp8_) == 0;
#line 264 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_g_free0 (_tmp8_);
#line 264 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_photo_file_format_properties_unref0 (_tmp6_);
#line 264 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_g_free0 (_tmp4_);
#line 264 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	jpeg = _tmp9_;
#line 266 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp10_ = self->priv->pixels_entry;
#line 266 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp11_ = original;
#line 266 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), !_tmp11_);
#line 267 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp13_ = original;
#line 267 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	if (!_tmp13_) {
#line 1602 "ExportDialog.c"
		gboolean _tmp14_;
#line 267 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp14_ = jpeg;
#line 267 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp12_ = _tmp14_;
#line 1608 "ExportDialog.c"
	} else {
#line 267 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp12_ = FALSE;
#line 1612 "ExportDialog.c"
	}
#line 267 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp15_ = self->priv->quality_combo;
#line 267 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget), _tmp12_);
#line 268 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp16_ = original;
#line 268 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	if (_tmp16_) {
#line 1622 "ExportDialog.c"
		GtkWidget* _tmp17_;
#line 269 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp17_ = self->priv->ok_button;
#line 269 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		gtk_widget_set_sensitive (_tmp17_, TRUE);
#line 1628 "ExportDialog.c"
	} else {
#line 271 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		export_dialog_on_pixels_changed (self);
#line 1632 "ExportDialog.c"
	}
}


static void
export_dialog_on_format_changed (ExportDialog* self)
{
	gboolean original = FALSE;
	GtkComboBoxText* _tmp0_;
	ScaleConstraint _tmp1_;
	GtkComboBoxText* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
#line 274 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_return_if_fail (IS_EXPORT_DIALOG (self));
#line 275 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp0_ = self->priv->constraint_combo;
#line 275 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp1_ = EXPORT_DIALOG_CONSTRAINT_ARRAY[gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox))];
#line 275 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	original = _tmp1_ == SCALE_CONSTRAINT_ORIGINAL;
#line 277 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp2_ = self->priv->format_combo;
#line 277 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp3_ = gtk_combo_box_text_get_active_text (_tmp2_);
#line 277 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp4_ = _tmp3_;
#line 277 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp5_ = g_strcmp0 (_tmp4_, EXPORT_DIALOG_UNMODIFIED_FORMAT_LABEL) == 0;
#line 277 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_g_free0 (_tmp4_);
#line 277 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	if (_tmp5_) {
#line 1667 "ExportDialog.c"
		GtkComboBoxText* _tmp6_;
		GtkComboBoxText* _tmp7_;
		GtkComboBoxText* _tmp8_;
		GtkEntry* _tmp9_;
		GtkSwitch* _tmp10_;
		GtkSwitch* _tmp11_;
#line 282 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp6_ = self->priv->constraint_combo;
#line 282 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_combo_box_get_type (), GtkComboBox), 0);
#line 283 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp7_ = self->priv->constraint_combo;
#line 283 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 284 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp8_ = self->priv->quality_combo;
#line 284 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 285 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp9_ = self->priv->pixels_entry;
#line 285 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 286 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp10_ = self->priv->export_metadata;
#line 286 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		gtk_switch_set_active (_tmp10_, FALSE);
#line 287 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp11_ = self->priv->export_metadata;
#line 287 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 1698 "ExportDialog.c"
	} else {
		GtkComboBoxText* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gboolean _tmp15_;
#line 288 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp12_ = self->priv->format_combo;
#line 288 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp13_ = gtk_combo_box_text_get_active_text (_tmp12_);
#line 288 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp14_ = _tmp13_;
#line 288 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp15_ = g_strcmp0 (_tmp14_, EXPORT_DIALOG_CURRENT_FORMAT_LABEL) == 0;
#line 288 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_g_free0 (_tmp14_);
#line 288 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		if (_tmp15_) {
#line 1716 "ExportDialog.c"
			GtkComboBoxText* _tmp16_;
			GtkComboBoxText* _tmp17_;
			GtkEntry* _tmp18_;
			gboolean _tmp19_;
			GtkSwitch* _tmp20_;
#line 295 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp16_ = self->priv->constraint_combo;
#line 295 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 296 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp17_ = self->priv->quality_combo;
#line 296 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 297 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp18_ = self->priv->pixels_entry;
#line 297 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp19_ = original;
#line 297 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget), !_tmp19_);
#line 298 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp20_ = self->priv->export_metadata;
#line 298 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 1740 "ExportDialog.c"
		} else {
			GtkComboBoxText* _tmp21_;
			gboolean jpeg = FALSE;
			gboolean _tmp22_ = FALSE;
			gboolean _tmp23_;
			GtkComboBoxText* _tmp25_;
			GtkSwitch* _tmp26_;
#line 303 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp21_ = self->priv->constraint_combo;
#line 303 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 304 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			jpeg = export_dialog_get_specified_format (self) == PHOTO_FILE_FORMAT_JFIF;
#line 305 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp23_ = original;
#line 305 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			if (!_tmp23_) {
#line 1758 "ExportDialog.c"
				gboolean _tmp24_;
#line 305 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp24_ = jpeg;
#line 305 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp22_ = _tmp24_;
#line 1764 "ExportDialog.c"
			} else {
#line 305 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp22_ = FALSE;
#line 1768 "ExportDialog.c"
			}
#line 305 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp25_ = self->priv->quality_combo;
#line 305 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget), _tmp22_);
#line 306 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp26_ = self->priv->export_metadata;
#line 306 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 1778 "ExportDialog.c"
		}
	}
}


static void
export_dialog_on_activate (ExportDialog* self)
{
#line 310 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_return_if_fail (IS_EXPORT_DIALOG (self));
#line 311 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_dialog_response (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), (gint) GTK_RESPONSE_OK);
#line 1791 "ExportDialog.c"
}


static void
export_dialog_on_pixels_changed (ExportDialog* self)
{
	gboolean _tmp0_ = FALSE;
	GtkEntry* _tmp1_;
	GtkWidget* _tmp4_;
#line 314 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_return_if_fail (IS_EXPORT_DIALOG (self));
#line 315 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp1_ = self->priv->pixels_entry;
#line 315 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	if (((gint) gtk_entry_get_text_length (_tmp1_)) > 0) {
#line 1807 "ExportDialog.c"
		GtkEntry* _tmp2_;
		const gchar* _tmp3_;
#line 315 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp2_ = self->priv->pixels_entry;
#line 315 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp3_ = gtk_entry_get_text (_tmp2_);
#line 315 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp0_ = atoi (_tmp3_) > 0;
#line 1816 "ExportDialog.c"
	} else {
#line 315 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp0_ = FALSE;
#line 1820 "ExportDialog.c"
	}
#line 315 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp4_ = self->priv->ok_button;
#line 315 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	gtk_widget_set_sensitive (_tmp4_, _tmp0_);
#line 1826 "ExportDialog.c"
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
#line 1124 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp0_;
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 1844 "ExportDialog.c"
}


static void
export_dialog_on_pixels_insert_text (ExportDialog* self,
                                     const gchar* text,
                                     gint length,
                                     gint* position)
{
	gboolean _tmp0_;
	gchar* new_text = NULL;
	gchar* _tmp3_;
	const gchar* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GtkEntry* _tmp21_;
#line 318 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_return_if_fail (IS_EXPORT_DIALOG (self));
#line 318 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_return_if_fail (text != NULL);
#line 320 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp0_ = self->priv->in_insert;
#line 320 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	if (_tmp0_) {
#line 321 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		return;
#line 1871 "ExportDialog.c"
	}
#line 323 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	self->priv->in_insert = TRUE;
#line 325 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	if (length == -1) {
#line 1877 "ExportDialog.c"
		gint _tmp1_;
		gint _tmp2_;
#line 326 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp1_ = strlen (text);
#line 326 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp2_ = _tmp1_;
#line 326 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		length = (gint) _tmp2_;
#line 1886 "ExportDialog.c"
	}
#line 329 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp3_ = g_strdup ("");
#line 329 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	new_text = _tmp3_;
#line 1892 "ExportDialog.c"
	{
		gint ctr = 0;
#line 330 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		ctr = 0;
#line 1897 "ExportDialog.c"
		{
			gboolean _tmp4_ = FALSE;
#line 330 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			_tmp4_ = TRUE;
#line 330 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
			while (TRUE) {
#line 1904 "ExportDialog.c"
				gint _tmp6_;
				gint _tmp7_;
#line 330 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				if (!_tmp4_) {
#line 1909 "ExportDialog.c"
					gint _tmp5_;
#line 330 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
					_tmp5_ = ctr;
#line 330 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
					ctr = _tmp5_ + 1;
#line 1915 "ExportDialog.c"
				}
#line 330 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp4_ = FALSE;
#line 330 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp6_ = ctr;
#line 330 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				if (!(_tmp6_ < length)) {
#line 330 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
					break;
#line 1925 "ExportDialog.c"
				}
#line 331 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				_tmp7_ = ctr;
#line 331 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
				if (g_ascii_isdigit (string_get (text, (glong) _tmp7_))) {
#line 1931 "ExportDialog.c"
					const gchar* _tmp8_;
					gint _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
#line 332 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
					_tmp8_ = new_text;
#line 332 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
					_tmp9_ = ctr;
#line 332 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
					_tmp10_ = g_strdup_printf ("%c", (gchar) string_get (text, (glong) _tmp9_));
#line 332 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
					_tmp11_ = _tmp10_;
#line 332 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
					_tmp12_ = g_strconcat (_tmp8_, _tmp11_, NULL);
#line 332 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
					_g_free0 (new_text);
#line 332 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
					new_text = _tmp12_;
#line 332 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
					_g_free0 (_tmp11_);
#line 1953 "ExportDialog.c"
				}
			}
		}
	}
#line 336 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp13_ = new_text;
#line 336 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp14_ = strlen (_tmp13_);
#line 336 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp15_ = _tmp14_;
#line 336 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	if (_tmp15_ > 0) {
#line 1966 "ExportDialog.c"
		GtkEntry* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
#line 337 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp16_ = self->priv->pixels_entry;
#line 337 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp17_ = new_text;
#line 337 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp18_ = new_text;
#line 337 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp19_ = strlen (_tmp18_);
#line 337 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		_tmp20_ = _tmp19_;
#line 337 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
		g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_editable_get_type (), GtkEditable), "insert-text", _tmp17_, (gint) _tmp20_, position);
#line 1984 "ExportDialog.c"
	}
#line 339 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp21_ = self->priv->pixels_entry;
#line 339 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_signal_stop_emission_by_name (_tmp21_, "insert-text");
#line 341 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	self->priv->in_insert = FALSE;
#line 318 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_g_free0 (new_text);
#line 1994 "ExportDialog.c"
}


static void
export_dialog_class_init (ExportDialogClass * klass)
{
	ExportFormatParameters _tmp0_ = {0};
#line 8 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_parent_class = g_type_class_peek_parent (klass);
#line 8 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_type_class_add_private (klass, sizeof (ExportDialogPrivate));
#line 8 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	G_OBJECT_CLASS (klass)->finalize = export_dialog_finalize;
#line 25 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_format_parameters_current (&_tmp0_);
#line 25 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_current_parameters = _tmp0_;
#line 26 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	export_dialog_current_scale = EXPORT_DIALOG_DEFAULT_SCALE;
#line 2014 "ExportDialog.c"
}


static void
export_dialog_instance_init (ExportDialog * self)
{
	GtkGrid* _tmp0_;
	GeeArrayList* _tmp1_;
#line 8 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	self->priv = EXPORT_DIALOG_GET_PRIVATE (self);
#line 28 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
#line 28 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	g_object_ref_sink (_tmp0_);
#line 28 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	self->priv->table = _tmp0_;
#line 33 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 33 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	self->priv->format_options = _tmp1_;
#line 36 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	self->priv->in_insert = FALSE;
#line 2037 "ExportDialog.c"
}


static void
export_dialog_finalize (GObject * obj)
{
	ExportDialog * self;
#line 8 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPORT_DIALOG, ExportDialog);
#line 28 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_g_object_unref0 (self->priv->table);
#line 29 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_g_object_unref0 (self->priv->quality_combo);
#line 30 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_g_object_unref0 (self->priv->constraint_combo);
#line 31 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_g_object_unref0 (self->priv->format_combo);
#line 32 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_g_object_unref0 (self->priv->export_metadata);
#line 33 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_g_object_unref0 (self->priv->format_options);
#line 34 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_g_object_unref0 (self->priv->pixels_entry);
#line 35 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	_g_object_unref0 (self->priv->ok_button);
#line 8 "/home/jens/Source/shotwell/src/dialogs/ExportDialog.vala"
	G_OBJECT_CLASS (export_dialog_parent_class)->finalize (obj);
#line 2065 "ExportDialog.c"
}


GType
export_dialog_get_type (void)
{
	static volatile gsize export_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&export_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ExportDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) export_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExportDialog), 0, (GInstanceInitFunc) export_dialog_instance_init, NULL };
		GType export_dialog_type_id;
		export_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "ExportDialog", &g_define_type_info, 0);
		g_once_init_leave (&export_dialog_type_id__volatile, export_dialog_type_id);
	}
	return export_dialog_type_id__volatile;
}



