/* CameraTable.c generated by valac 0.40.4, the Vala compiler
 * generated from CameraTable.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <gphoto2/gphoto2-camera.h>
#include <gphoto.h>
#include <stdlib.h>
#include <string.h>
#include <gudev/gudev.h>
#include <gphoto2/gphoto2-context.h>
#include <gphoto2/gphoto2-abilities-list.h>
#include <gio/gio.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <gphoto2/gphoto2-result.h>
#include <gphoto2/gphoto2-port-result.h>
#include <gphoto2/gphoto2-port-info-list.h>
#include <gphoto2/gphoto2-list.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define TYPE_DISCOVERED_CAMERA (discovered_camera_get_type ())
#define DISCOVERED_CAMERA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DISCOVERED_CAMERA, DiscoveredCamera))
#define DISCOVERED_CAMERA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DISCOVERED_CAMERA, DiscoveredCameraClass))
#define IS_DISCOVERED_CAMERA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DISCOVERED_CAMERA))
#define IS_DISCOVERED_CAMERA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DISCOVERED_CAMERA))
#define DISCOVERED_CAMERA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DISCOVERED_CAMERA, DiscoveredCameraClass))

typedef struct _DiscoveredCamera DiscoveredCamera;
typedef struct _DiscoveredCameraClass DiscoveredCameraClass;
typedef struct _DiscoveredCameraPrivate DiscoveredCameraPrivate;
#define _gp_camera_unref0(var) ((var == NULL) ? NULL : (var = (gp_camera_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecDiscoveredCamera ParamSpecDiscoveredCamera;

#define TYPE_CAMERA_TABLE (camera_table_get_type ())
#define CAMERA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CAMERA_TABLE, CameraTable))
#define CAMERA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CAMERA_TABLE, CameraTableClass))
#define IS_CAMERA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CAMERA_TABLE))
#define IS_CAMERA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CAMERA_TABLE))
#define CAMERA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CAMERA_TABLE, CameraTableClass))

typedef struct _CameraTable CameraTable;
typedef struct _CameraTableClass CameraTableClass;
typedef struct _CameraTablePrivate CameraTablePrivate;

#define TYPE_ONE_SHOT_SCHEDULER (one_shot_scheduler_get_type ())
#define ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotScheduler))
#define ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))
#define IS_ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ONE_SHOT_SCHEDULER))
#define IS_ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ONE_SHOT_SCHEDULER))
#define ONE_SHOT_SCHEDULER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))

typedef struct _OneShotScheduler OneShotScheduler;
typedef struct _OneShotSchedulerClass OneShotSchedulerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _one_shot_scheduler_unref0(var) ((var == NULL) ? NULL : (var = (one_shot_scheduler_unref (var), NULL)))
#define _gp_context_unref0(var) ((var == NULL) ? NULL : (var = (gp_context_unref (var), NULL)))
#define _gp_abilities_list_free0(var) ((var == NULL) ? NULL : (var = (gp_abilities_list_free (var), NULL)))

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;

#define TYPE_LIBRARY_WINDOW (library_window_get_type ())
#define LIBRARY_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_WINDOW, LibraryWindow))
#define LIBRARY_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_WINDOW, LibraryWindowClass))
#define IS_LIBRARY_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_WINDOW))
#define IS_LIBRARY_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_WINDOW))
#define LIBRARY_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_WINDOW, LibraryWindowClass))

typedef struct _LibraryWindow LibraryWindow;
typedef struct _LibraryWindowClass LibraryWindowClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _camera_table_unref0(var) ((var == NULL) ? NULL : (var = (camera_table_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _gp_port_info_list_free0(var) ((var == NULL) ? NULL : (var = (gp_port_info_list_free (var), NULL)))
#define _gp_list_unref0(var) ((var == NULL) ? NULL : (var = (gp_list_unref (var), NULL)))
#define _discovered_camera_unref0(var) ((var == NULL) ? NULL : (var = (discovered_camera_unref (var), NULL)))
typedef struct _ParamSpecCameraTable ParamSpecCameraTable;
enum  {
	CAMERA_TABLE_CAMERA_ADDED_SIGNAL,
	CAMERA_TABLE_CAMERA_REMOVED_SIGNAL,
	CAMERA_TABLE_NUM_SIGNALS
};
static guint camera_table_signals[CAMERA_TABLE_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DiscoveredCamera {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DiscoveredCameraPrivate * priv;
	Camera* gcamera;
	gchar* uri;
	gchar* display_name;
	gchar* icon;
};

struct _DiscoveredCameraClass {
	GTypeClass parent_class;
	void (*finalize) (DiscoveredCamera *self);
};

struct _ParamSpecDiscoveredCamera {
	GParamSpec parent_instance;
};

struct _CameraTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CameraTablePrivate * priv;
};

struct _CameraTableClass {
	GTypeClass parent_class;
	void (*finalize) (CameraTable *self);
};

struct _CameraTablePrivate {
	GUdevClient* client;
	OneShotScheduler* camera_update_scheduler;
	GPContext* null_context;
	CameraAbilitiesList* abilities_list;
	GVolumeMonitor* volume_monitor;
	GeeHashMap* camera_map;
};

typedef void (*OneShotCallback) (void* user_data);
typedef enum  {
	GPHOTO_ERROR_LIBRARY
} GPhotoError;
#define GPHOTO_ERROR gphoto_error_quark ()
struct _ParamSpecCameraTable {
	GParamSpec parent_instance;
};


static gpointer discovered_camera_parent_class = NULL;
static gpointer camera_table_parent_class = NULL;
static CameraTable* camera_table_instance;
static CameraTable* camera_table_instance = NULL;

gpointer discovered_camera_ref (gpointer instance);
void discovered_camera_unref (gpointer instance);
GParamSpec* param_spec_discovered_camera (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
void value_set_discovered_camera (GValue* value,
                                  gpointer v_object);
void value_take_discovered_camera (GValue* value,
                                   gpointer v_object);
gpointer value_get_discovered_camera (const GValue* value);
GType discovered_camera_get_type (void) G_GNUC_CONST;
DiscoveredCamera* discovered_camera_new (Camera* gcamera,
                                         const gchar* uri,
                                         const gchar* display_name,
                                         const gchar* icon);
DiscoveredCamera* discovered_camera_construct (GType object_type,
                                               Camera* gcamera,
                                               const gchar* uri,
                                               const gchar* display_name,
                                               const gchar* icon);
static void discovered_camera_finalize (DiscoveredCamera * obj);
gpointer camera_table_ref (gpointer instance);
void camera_table_unref (gpointer instance);
GParamSpec* param_spec_camera_table (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
void value_set_camera_table (GValue* value,
                             gpointer v_object);
void value_take_camera_table (GValue* value,
                              gpointer v_object);
gpointer value_get_camera_table (const GValue* value);
GType camera_table_get_type (void) G_GNUC_CONST;
gpointer one_shot_scheduler_ref (gpointer instance);
void one_shot_scheduler_unref (gpointer instance);
GParamSpec* param_spec_one_shot_scheduler (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void value_set_one_shot_scheduler (GValue* value,
                                   gpointer v_object);
void value_take_one_shot_scheduler (GValue* value,
                                    gpointer v_object);
gpointer value_get_one_shot_scheduler (const GValue* value);
GType one_shot_scheduler_get_type (void) G_GNUC_CONST;
#define CAMERA_TABLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CAMERA_TABLE, CameraTablePrivate))
#define CAMERA_TABLE_UPDATE_DELAY_MSEC 1000
static CameraTable* camera_table_new (void);
static CameraTable* camera_table_construct (GType object_type);
static void camera_table_on_update_cameras (CameraTable* self);
static void _camera_table_on_update_cameras_one_shot_callback (gpointer self);
OneShotScheduler* one_shot_scheduler_new (const gchar* name,
                                          OneShotCallback callback,
                                          void* callback_target);
OneShotScheduler* one_shot_scheduler_construct (GType object_type,
                                                const gchar* name,
                                                OneShotCallback callback,
                                                void* callback_target);
static void camera_table_on_udev_event (CameraTable* self,
                                 const gchar* action,
                                 GUdevDevice* device);
static void _camera_table_on_udev_event_g_udev_client_uevent (GUdevClient* _sender,
                                                       const gchar* action,
                                                       GUdevDevice* device,
                                                       gpointer self);
void camera_table_on_volume_changed (CameraTable* self,
                                     GVolume* volume);
static void _camera_table_on_volume_changed_g_volume_monitor_volume_changed (GVolumeMonitor* _sender,
                                                                      GVolume* volume,
                                                                      gpointer self);
static void _camera_table_on_volume_changed_g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                                    GVolume* volume,
                                                                    gpointer self);
static gboolean camera_table_delayed_init (CameraTable* self);
static gboolean _camera_table_delayed_init_gsource_func (gpointer self);
GType page_window_get_type (void) G_GNUC_CONST;
GType app_window_get_type (void) G_GNUC_CONST;
AppWindow* app_window_get_instance (void);
GType library_window_get_type (void) G_GNUC_CONST;
void library_window_set_page_switching_enabled (LibraryWindow* self,
                                                gboolean should_enable);
GQuark gphoto_error_quark (void);
static void camera_table_init_camera_table (CameraTable* self,
                                     GError** error);
static void camera_table_update_camera_table (CameraTable* self,
                                       GError** error);
CameraTable* camera_table_get_instance (void);
GeeIterable* camera_table_get_cameras (CameraTable* self);
gint camera_table_get_count (CameraTable* self);
DiscoveredCamera* camera_table_get_for_uri (CameraTable* self,
                                            const gchar* uri);
static void camera_table_do_op (CameraTable* self,
                         int res,
                         const gchar* op,
                         GError** error);
gchar* camera_table_get_port_uri (const gchar* port);
gchar* camera_table_get_port_path (const gchar* port);
static gchar* camera_table_get_name_for_uuid (CameraTable* self,
                                       const gchar* uuid);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gchar* camera_table_get_icon_for_uuid (CameraTable* self,
                                       const gchar* uuid);
static void _vala_array_add69 (DiscoveredCamera** * array,
                        int* length,
                        int* size,
                        DiscoveredCamera* value);
void one_shot_scheduler_after_timeout (OneShotScheduler* self,
                                       guint msec,
                                       gboolean reschedule);
static void g_cclosure_user_marshal_VOID__DISCOVERED_CAMERA (GClosure * closure,
                                                      GValue * return_value,
                                                      guint n_param_values,
                                                      const GValue * param_values,
                                                      gpointer invocation_hint,
                                                      gpointer marshal_data);
static void camera_table_finalize (CameraTable * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static const gchar* CAMERA_TABLE_SUBSYSTEMS[3] = {"usb", "block", NULL};

static gpointer
_GPHOTO_REF_CAMERA0 (gpointer self)
{
#line 14 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return self ? GPHOTO_REF_CAMERA (self) : NULL;
#line 308 "CameraTable.c"
}


DiscoveredCamera*
discovered_camera_construct (GType object_type,
                             Camera* gcamera,
                             const gchar* uri,
                             const gchar* display_name,
                             const gchar* icon)
{
	DiscoveredCamera* self = NULL;
	Camera* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 13 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_val_if_fail (gcamera != NULL, NULL);
#line 13 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 13 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_val_if_fail (display_name != NULL, NULL);
#line 13 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	self = (DiscoveredCamera*) g_type_create_instance (object_type);
#line 14 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp0_ = _GPHOTO_REF_CAMERA0 (gcamera);
#line 14 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_gp_camera_unref0 (self->gcamera);
#line 14 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	self->gcamera = _tmp0_;
#line 15 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp1_ = g_strdup (uri);
#line 15 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_g_free0 (self->uri);
#line 15 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	self->uri = _tmp1_;
#line 16 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp2_ = g_strdup (display_name);
#line 16 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_g_free0 (self->display_name);
#line 16 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	self->display_name = _tmp2_;
#line 17 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp3_ = g_strdup (icon);
#line 17 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_g_free0 (self->icon);
#line 17 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	self->icon = _tmp3_;
#line 13 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return self;
#line 358 "CameraTable.c"
}


DiscoveredCamera*
discovered_camera_new (Camera* gcamera,
                       const gchar* uri,
                       const gchar* display_name,
                       const gchar* icon)
{
#line 13 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return discovered_camera_construct (TYPE_DISCOVERED_CAMERA, gcamera, uri, display_name, icon);
#line 370 "CameraTable.c"
}


static void
value_discovered_camera_init (GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	value->data[0].v_pointer = NULL;
#line 379 "CameraTable.c"
}


static void
value_discovered_camera_free_value (GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		discovered_camera_unref (value->data[0].v_pointer);
#line 390 "CameraTable.c"
	}
}


static void
value_discovered_camera_copy_value (const GValue* src_value,
                                    GValue* dest_value)
{
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (src_value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		dest_value->data[0].v_pointer = discovered_camera_ref (src_value->data[0].v_pointer);
#line 403 "CameraTable.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		dest_value->data[0].v_pointer = NULL;
#line 407 "CameraTable.c"
	}
}


static gpointer
value_discovered_camera_peek_pointer (const GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return value->data[0].v_pointer;
#line 417 "CameraTable.c"
}


static gchar*
value_discovered_camera_collect_value (GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (collect_values[0].v_pointer) {
#line 429 "CameraTable.c"
		DiscoveredCamera * object;
		object = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		if (object->parent_instance.g_class == NULL) {
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 436 "CameraTable.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 440 "CameraTable.c"
		}
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		value->data[0].v_pointer = discovered_camera_ref (object);
#line 444 "CameraTable.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		value->data[0].v_pointer = NULL;
#line 448 "CameraTable.c"
	}
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return NULL;
#line 452 "CameraTable.c"
}


static gchar*
value_discovered_camera_lcopy_value (const GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	DiscoveredCamera ** object_p;
	object_p = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (!object_p) {
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 468 "CameraTable.c"
	}
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (!value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		*object_p = NULL;
#line 474 "CameraTable.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		*object_p = value->data[0].v_pointer;
#line 478 "CameraTable.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		*object_p = discovered_camera_ref (value->data[0].v_pointer);
#line 482 "CameraTable.c"
	}
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return NULL;
#line 486 "CameraTable.c"
}


GParamSpec*
param_spec_discovered_camera (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags)
{
	ParamSpecDiscoveredCamera* spec;
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DISCOVERED_CAMERA), NULL);
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return G_PARAM_SPEC (spec);
#line 506 "CameraTable.c"
}


gpointer
value_get_discovered_camera (const GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DISCOVERED_CAMERA), NULL);
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return value->data[0].v_pointer;
#line 517 "CameraTable.c"
}


void
value_set_discovered_camera (GValue* value,
                             gpointer v_object)
{
	DiscoveredCamera * old;
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DISCOVERED_CAMERA));
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DISCOVERED_CAMERA));
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		value->data[0].v_pointer = v_object;
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		discovered_camera_ref (value->data[0].v_pointer);
#line 540 "CameraTable.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		value->data[0].v_pointer = NULL;
#line 544 "CameraTable.c"
	}
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		discovered_camera_unref (old);
#line 550 "CameraTable.c"
	}
}


void
value_take_discovered_camera (GValue* value,
                              gpointer v_object)
{
	DiscoveredCamera * old;
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DISCOVERED_CAMERA));
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DISCOVERED_CAMERA));
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		value->data[0].v_pointer = v_object;
#line 572 "CameraTable.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		value->data[0].v_pointer = NULL;
#line 576 "CameraTable.c"
	}
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		discovered_camera_unref (old);
#line 582 "CameraTable.c"
	}
}


static void
discovered_camera_class_init (DiscoveredCameraClass * klass)
{
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	discovered_camera_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	((DiscoveredCameraClass *) klass)->finalize = discovered_camera_finalize;
#line 594 "CameraTable.c"
}


static void
discovered_camera_instance_init (DiscoveredCamera * self)
{
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	self->ref_count = 1;
#line 603 "CameraTable.c"
}


static void
discovered_camera_finalize (DiscoveredCamera * obj)
{
	DiscoveredCamera * self;
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DISCOVERED_CAMERA, DiscoveredCamera);
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_signal_handlers_destroy (self);
#line 8 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_gp_camera_unref0 (self->gcamera);
#line 9 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_g_free0 (self->uri);
#line 10 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_g_free0 (self->display_name);
#line 11 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_g_free0 (self->icon);
#line 623 "CameraTable.c"
}


GType
discovered_camera_get_type (void)
{
	static volatile gsize discovered_camera_type_id__volatile = 0;
	if (g_once_init_enter (&discovered_camera_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_discovered_camera_init, value_discovered_camera_free_value, value_discovered_camera_copy_value, value_discovered_camera_peek_pointer, "p", value_discovered_camera_collect_value, "p", value_discovered_camera_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DiscoveredCameraClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) discovered_camera_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DiscoveredCamera), 0, (GInstanceInitFunc) discovered_camera_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType discovered_camera_type_id;
		discovered_camera_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DiscoveredCamera", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&discovered_camera_type_id__volatile, discovered_camera_type_id);
	}
	return discovered_camera_type_id__volatile;
}


gpointer
discovered_camera_ref (gpointer instance)
{
	DiscoveredCamera * self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_atomic_int_inc (&self->ref_count);
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return instance;
#line 652 "CameraTable.c"
}


void
discovered_camera_unref (gpointer instance)
{
	DiscoveredCamera * self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		DISCOVERED_CAMERA_GET_CLASS (self)->finalize (self);
#line 7 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 667 "CameraTable.c"
	}
}


static void
_camera_table_on_update_cameras_one_shot_callback (gpointer self)
{
#line 42 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	camera_table_on_update_cameras ((CameraTable*) self);
#line 677 "CameraTable.c"
}


static void
_camera_table_on_udev_event_g_udev_client_uevent (GUdevClient* _sender,
                                                  const gchar* action,
                                                  GUdevDevice* device,
                                                  gpointer self)
{
#line 46 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	camera_table_on_udev_event ((CameraTable*) self, action, device);
#line 689 "CameraTable.c"
}


static void
_camera_table_on_volume_changed_g_volume_monitor_volume_changed (GVolumeMonitor* _sender,
                                                                 GVolume* volume,
                                                                 gpointer self)
{
#line 48 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	camera_table_on_volume_changed ((CameraTable*) self, volume);
#line 700 "CameraTable.c"
}


static void
_camera_table_on_volume_changed_g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                               GVolume* volume,
                                                               gpointer self)
{
#line 49 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	camera_table_on_volume_changed ((CameraTable*) self, volume);
#line 711 "CameraTable.c"
}


static gboolean
_camera_table_delayed_init_gsource_func (gpointer self)
{
	gboolean result;
	result = camera_table_delayed_init ((CameraTable*) self);
#line 54 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return result;
#line 722 "CameraTable.c"
}


static CameraTable*
camera_table_construct (GType object_type)
{
	CameraTable* self = NULL;
	OneShotScheduler* _tmp0_;
	GUdevClient* _tmp1_;
	GVolumeMonitor* _tmp2_;
	GVolumeMonitor* _tmp3_;
	GVolumeMonitor* _tmp4_;
#line 41 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	self = (CameraTable*) g_type_create_instance (object_type);
#line 42 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp0_ = one_shot_scheduler_new ("CameraTable update scheduler", _camera_table_on_update_cameras_one_shot_callback, self);
#line 42 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_one_shot_scheduler_unref0 (self->priv->camera_update_scheduler);
#line 42 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	self->priv->camera_update_scheduler = _tmp0_;
#line 46 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp1_ = self->priv->client;
#line 46 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_signal_connect (_tmp1_, "uevent", (GCallback) _camera_table_on_udev_event_g_udev_client_uevent, self);
#line 47 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp2_ = g_volume_monitor_get ();
#line 47 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_g_object_unref0 (self->priv->volume_monitor);
#line 47 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	self->priv->volume_monitor = _tmp2_;
#line 48 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp3_ = self->priv->volume_monitor;
#line 48 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_signal_connect (_tmp3_, "volume-changed", (GCallback) _camera_table_on_volume_changed_g_volume_monitor_volume_changed, self);
#line 49 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp4_ = self->priv->volume_monitor;
#line 49 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_signal_connect (_tmp4_, "volume-added", (GCallback) _camera_table_on_volume_changed_g_volume_monitor_volume_added, self);
#line 54 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, _camera_table_delayed_init_gsource_func, camera_table_ref (self), camera_table_unref);
#line 41 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return self;
#line 765 "CameraTable.c"
}


static CameraTable*
camera_table_new (void)
{
#line 41 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return camera_table_construct (TYPE_CAMERA_TABLE);
#line 774 "CameraTable.c"
}


static gboolean
camera_table_delayed_init (CameraTable* self)
{
	gboolean result = FALSE;
	AppWindow* _tmp0_;
	LibraryWindow* _tmp1_;
	AppWindow* _tmp10_;
	LibraryWindow* _tmp11_;
	GError * _inner_error_ = NULL;
#line 57 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_val_if_fail (IS_CAMERA_TABLE (self), FALSE);
#line 60 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp0_ = app_window_get_instance ();
#line 60 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_LIBRARY_WINDOW, LibraryWindow);
#line 60 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	library_window_set_page_switching_enabled (_tmp1_, FALSE);
#line 60 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_g_object_unref0 (_tmp1_);
#line 797 "CameraTable.c"
	{
#line 63 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		camera_table_init_camera_table (self, &_inner_error_);
#line 63 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 803 "CameraTable.c"
			gboolean _tmp2_ = FALSE;
#line 63 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			if (_inner_error_->domain == GPHOTO_ERROR) {
#line 807 "CameraTable.c"
				goto __catch64_gphoto_error;
			}
#line 63 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 63 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_clear_error (&_inner_error_);
#line 63 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			return _tmp2_;
#line 816 "CameraTable.c"
		}
	}
	goto __finally64;
	__catch64_gphoto_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
#line 62 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		err = _inner_error_;
#line 62 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_inner_error_ = NULL;
#line 65 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp3_ = err;
#line 65 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp4_ = _tmp3_->message;
#line 65 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		g_warning ("CameraTable.vala:65: Unable to initialize camera table: %s", _tmp4_);
#line 67 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		result = FALSE;
#line 67 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_g_error_free0 (err);
#line 67 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		return result;
#line 841 "CameraTable.c"
	}
	__finally64:
#line 62 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 846 "CameraTable.c"
		gboolean _tmp5_ = FALSE;
#line 62 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 62 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		g_clear_error (&_inner_error_);
#line 62 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		return _tmp5_;
#line 854 "CameraTable.c"
	}
	{
#line 71 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		camera_table_update_camera_table (self, &_inner_error_);
#line 71 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 861 "CameraTable.c"
			gboolean _tmp6_ = FALSE;
#line 71 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			if (_inner_error_->domain == GPHOTO_ERROR) {
#line 865 "CameraTable.c"
				goto __catch65_gphoto_error;
			}
#line 71 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 71 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_clear_error (&_inner_error_);
#line 71 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			return _tmp6_;
#line 874 "CameraTable.c"
		}
	}
	goto __finally65;
	__catch65_gphoto_error:
	{
		GError* err = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 70 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		err = _inner_error_;
#line 70 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_inner_error_ = NULL;
#line 73 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp7_ = err;
#line 73 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp8_ = _tmp7_->message;
#line 73 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		g_warning ("CameraTable.vala:73: Unable to update camera table: %s", _tmp8_);
#line 70 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_g_error_free0 (err);
#line 895 "CameraTable.c"
	}
	__finally65:
#line 70 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 900 "CameraTable.c"
		gboolean _tmp9_ = FALSE;
#line 70 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 70 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		g_clear_error (&_inner_error_);
#line 70 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		return _tmp9_;
#line 908 "CameraTable.c"
	}
#line 78 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp10_ = app_window_get_instance ();
#line 78 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp11_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_LIBRARY_WINDOW, LibraryWindow);
#line 78 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	library_window_set_page_switching_enabled (_tmp11_, TRUE);
#line 78 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_g_object_unref0 (_tmp11_);
#line 79 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	result = FALSE;
#line 79 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return result;
#line 922 "CameraTable.c"
}


static gpointer
_camera_table_ref0 (gpointer self)
{
#line 86 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return self ? camera_table_ref (self) : NULL;
#line 931 "CameraTable.c"
}


CameraTable*
camera_table_get_instance (void)
{
	CameraTable* result = NULL;
	CameraTable* _tmp0_;
	CameraTable* _tmp2_;
	CameraTable* _tmp3_;
#line 83 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp0_ = camera_table_instance;
#line 83 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (_tmp0_ == NULL) {
#line 946 "CameraTable.c"
		CameraTable* _tmp1_;
#line 84 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp1_ = camera_table_new ();
#line 84 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_camera_table_unref0 (camera_table_instance);
#line 84 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		camera_table_instance = _tmp1_;
#line 954 "CameraTable.c"
	}
#line 86 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp2_ = camera_table_instance;
#line 86 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp3_ = _camera_table_ref0 (_tmp2_);
#line 86 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	result = _tmp3_;
#line 86 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return result;
#line 964 "CameraTable.c"
}


GeeIterable*
camera_table_get_cameras (CameraTable* self)
{
	GeeIterable* result = NULL;
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
#line 89 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_val_if_fail (IS_CAMERA_TABLE (self), NULL);
#line 90 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp0_ = self->priv->camera_map;
#line 90 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp1_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 90 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp2_ = _tmp1_;
#line 90 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable);
#line 90 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return result;
#line 987 "CameraTable.c"
}


gint
camera_table_get_count (CameraTable* self)
{
	gint result = 0;
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 93 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_val_if_fail (IS_CAMERA_TABLE (self), 0);
#line 94 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp0_ = self->priv->camera_map;
#line 94 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp1_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 94 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp2_ = _tmp1_;
#line 94 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	result = _tmp2_;
#line 94 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return result;
#line 1010 "CameraTable.c"
}


DiscoveredCamera*
camera_table_get_for_uri (CameraTable* self,
                          const gchar* uri)
{
	DiscoveredCamera* result = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
#line 97 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_val_if_fail (IS_CAMERA_TABLE (self), NULL);
#line 97 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 98 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp0_ = self->priv->camera_map;
#line 98 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), uri);
#line 98 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	result = (DiscoveredCamera*) _tmp1_;
#line 98 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return result;
#line 1033 "CameraTable.c"
}


static void
camera_table_do_op (CameraTable* self,
                    int res,
                    const gchar* op,
                    GError** error)
{
	GError * _inner_error_ = NULL;
#line 101 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_if_fail (IS_CAMERA_TABLE (self));
#line 101 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_if_fail (op != NULL);
#line 102 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (res != GP_OK) {
#line 1050 "CameraTable.c"
		const gchar* _tmp0_;
		GError* _tmp1_;
#line 103 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp0_ = gp_port_result_as_string (res);
#line 103 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp1_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Unable to %s: %s", (gint) res, op, _tmp0_);
#line 103 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_inner_error_ = _tmp1_;
#line 103 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		if (_inner_error_->domain == GPHOTO_ERROR) {
#line 103 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_propagate_error (error, _inner_error_);
#line 103 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			return;
#line 1065 "CameraTable.c"
		} else {
#line 103 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 103 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_clear_error (&_inner_error_);
#line 103 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			return;
#line 1073 "CameraTable.c"
		}
	}
}


static void
camera_table_init_camera_table (CameraTable* self,
                                GError** error)
{
	CameraAbilitiesList* _tmp0_ = NULL;
	int _tmp1_;
	CameraAbilitiesList* _tmp2_;
	GPContext* _tmp3_;
	GError * _inner_error_ = NULL;
#line 106 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_if_fail (IS_CAMERA_TABLE (self));
#line 107 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp1_ = gp_abilities_list_new (&_tmp0_);
#line 107 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_gp_abilities_list_free0 (self->priv->abilities_list);
#line 107 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	self->priv->abilities_list = _tmp0_;
#line 107 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	camera_table_do_op (self, _tmp1_, "create camera abilities list", &_inner_error_);
#line 107 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 107 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		if (_inner_error_->domain == GPHOTO_ERROR) {
#line 107 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_propagate_error (error, _inner_error_);
#line 107 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			return;
#line 1106 "CameraTable.c"
		} else {
#line 107 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 107 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_clear_error (&_inner_error_);
#line 107 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			return;
#line 1114 "CameraTable.c"
		}
	}
#line 108 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp2_ = self->priv->abilities_list;
#line 108 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp3_ = self->priv->null_context;
#line 108 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	camera_table_do_op (self, gp_abilities_list_load (_tmp2_, _tmp3_), "load camera abilities list", &_inner_error_);
#line 108 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 108 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		if (_inner_error_->domain == GPHOTO_ERROR) {
#line 108 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_propagate_error (error, _inner_error_);
#line 108 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			return;
#line 1131 "CameraTable.c"
		} else {
#line 108 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 108 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_clear_error (&_inner_error_);
#line 108 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			return;
#line 1139 "CameraTable.c"
		}
	}
}


gchar*
camera_table_get_port_uri (const gchar* port)
{
	gchar* result = NULL;
	gchar* _tmp0_;
#line 111 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_val_if_fail (port != NULL, NULL);
#line 112 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp0_ = g_strdup_printf ("gphoto2://[%s]/", port);
#line 112 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	result = _tmp0_;
#line 112 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return result;
#line 1158 "CameraTable.c"
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 1336 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1336 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	end = _tmp0_;
#line 1337 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = end;
#line 1337 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1338 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = maxlen;
#line 1338 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1182 "CameraTable.c"
	} else {
		gchar* _tmp2_;
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = end;
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1191 "CameraTable.c"
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
#line 1347 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 1212 "CameraTable.c"
	} else {
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1216 "CameraTable.c"
	}
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 1351 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 1222 "CameraTable.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 1232 "CameraTable.c"
	}
#line 1356 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1236 "CameraTable.c"
		glong _tmp3_;
#line 1357 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1357 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		offset = _tmp3_ + offset;
#line 1358 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 1244 "CameraTable.c"
	} else {
		glong _tmp4_;
#line 1360 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = string_length;
#line 1360 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_return_val_if_fail (offset <= _tmp4_, NULL);
#line 1251 "CameraTable.c"
	}
#line 1362 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1255 "CameraTable.c"
		glong _tmp5_;
#line 1363 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = string_length;
#line 1363 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		len = _tmp5_ - offset;
#line 1261 "CameraTable.c"
	}
#line 1365 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp6_ = string_length;
#line 1365 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 1273 "CameraTable.c"
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1421 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1421 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1421 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 1296 "CameraTable.c"
	} else {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 1300 "CameraTable.c"
	}
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 1306 "CameraTable.c"
	} else {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 1310 "CameraTable.c"
	}
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 1314 "CameraTable.c"
		gchar* _tmp2_;
#line 1423 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1423 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = _tmp2_;
#line 1423 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1322 "CameraTable.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		regex = _tmp6_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1350 "CameraTable.c"
				goto __catch66_g_regex_error;
			}
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			return NULL;
#line 1359 "CameraTable.c"
		}
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp8_ = regex;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1373 "CameraTable.c"
				goto __catch66_g_regex_error;
			}
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			return NULL;
#line 1384 "CameraTable.c"
		}
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = _tmp10_;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1398 "CameraTable.c"
	}
	goto __finally66;
	__catch66_g_regex_error:
	{
		GError* e = NULL;
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1429 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 1412 "CameraTable.c"
	}
	__finally66:
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return NULL;
#line 1423 "CameraTable.c"
	}
}


gchar*
camera_table_get_port_path (const gchar* port)
{
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 115 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_val_if_fail (port != NULL, NULL);
#line 117 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (g_str_has_prefix (port, "usb:")) {
#line 1437 "CameraTable.c"
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 118 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp1_ = string_substring (port, (glong) 4, (glong) -1);
#line 118 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp2_ = _tmp1_;
#line 118 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp3_ = string_replace (_tmp2_, ",", "/");
#line 118 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp4_ = _tmp3_;
#line 118 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp5_ = g_strdup_printf ("/dev/bus/usb/%s", _tmp4_);
#line 118 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_g_free0 (_tmp0_);
#line 118 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp0_ = _tmp5_;
#line 118 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_g_free0 (_tmp4_);
#line 118 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_g_free0 (_tmp2_);
#line 1461 "CameraTable.c"
	} else {
#line 118 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_g_free0 (_tmp0_);
#line 118 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp0_ = NULL;
#line 1467 "CameraTable.c"
	}
#line 117 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	result = _tmp0_;
#line 117 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return result;
#line 1473 "CameraTable.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 122 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return self ? g_object_ref (self) : NULL;
#line 1482 "CameraTable.c"
}


static void
_g_object_unref0_ (gpointer var)
{
#line 124 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1491 "CameraTable.c"
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 124 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 1500 "CameraTable.c"
}


static gchar*
camera_table_get_name_for_uuid (CameraTable* self,
                                const gchar* uuid)
{
	gchar* result = NULL;
	GVolumeMonitor* _tmp0_;
	GList* _tmp1_;
#line 121 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_val_if_fail (IS_CAMERA_TABLE (self), NULL);
#line 121 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_val_if_fail (uuid != NULL, NULL);
#line 122 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp0_ = self->priv->volume_monitor;
#line 122 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp1_ = g_volume_monitor_get_volumes (_tmp0_);
#line 1519 "CameraTable.c"
	{
		GList* volume_collection = NULL;
		GList* volume_it = NULL;
#line 122 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		volume_collection = _tmp1_;
#line 122 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		for (volume_it = volume_collection; volume_it != NULL; volume_it = volume_it->next) {
#line 1527 "CameraTable.c"
			GVolume* _tmp2_;
			GVolume* volume = NULL;
#line 122 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp2_ = _g_object_ref0 ((GVolume*) volume_it->data);
#line 122 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			volume = _tmp2_;
#line 1534 "CameraTable.c"
			{
				GVolume* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gboolean _tmp6_;
#line 123 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp3_ = volume;
#line 123 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp4_ = g_volume_get_identifier (_tmp3_, G_VOLUME_IDENTIFIER_KIND_UUID);
#line 123 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp5_ = _tmp4_;
#line 123 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp6_ = g_strcmp0 (_tmp5_, uuid) == 0;
#line 123 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_g_free0 (_tmp5_);
#line 123 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				if (_tmp6_) {
#line 1552 "CameraTable.c"
					GVolume* _tmp7_;
					gchar* _tmp8_;
#line 124 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp7_ = volume;
#line 124 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp8_ = g_volume_get_name (_tmp7_);
#line 124 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					result = _tmp8_;
#line 124 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (volume);
#line 124 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					__g_list_free__g_object_unref0_0 (volume_collection);
#line 124 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					return result;
#line 1567 "CameraTable.c"
				}
#line 122 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_g_object_unref0 (volume);
#line 1571 "CameraTable.c"
			}
		}
#line 122 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		__g_list_free__g_object_unref0_0 (volume_collection);
#line 1576 "CameraTable.c"
	}
#line 127 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	result = NULL;
#line 127 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return result;
#line 1582 "CameraTable.c"
}


static gchar*
camera_table_get_icon_for_uuid (CameraTable* self,
                                const gchar* uuid)
{
	gchar* result = NULL;
	GVolumeMonitor* _tmp0_;
	GList* _tmp1_;
#line 130 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_val_if_fail (IS_CAMERA_TABLE (self), NULL);
#line 130 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_val_if_fail (uuid != NULL, NULL);
#line 131 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp0_ = self->priv->volume_monitor;
#line 131 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp1_ = g_volume_monitor_get_volumes (_tmp0_);
#line 1601 "CameraTable.c"
	{
		GList* volume_collection = NULL;
		GList* volume_it = NULL;
#line 131 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		volume_collection = _tmp1_;
#line 131 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		for (volume_it = volume_collection; volume_it != NULL; volume_it = volume_it->next) {
#line 1609 "CameraTable.c"
			GVolume* _tmp2_;
			GVolume* volume = NULL;
#line 131 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp2_ = _g_object_ref0 ((GVolume*) volume_it->data);
#line 131 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			volume = _tmp2_;
#line 1616 "CameraTable.c"
			{
				GVolume* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gboolean _tmp6_;
#line 132 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp3_ = volume;
#line 132 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp4_ = g_volume_get_identifier (_tmp3_, G_VOLUME_IDENTIFIER_KIND_UUID);
#line 132 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp5_ = _tmp4_;
#line 132 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp6_ = g_strcmp0 (_tmp5_, uuid) == 0;
#line 132 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_g_free0 (_tmp5_);
#line 132 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				if (_tmp6_) {
#line 1634 "CameraTable.c"
					GVolume* _tmp7_;
					GIcon* _tmp8_;
					GIcon* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
#line 133 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp7_ = volume;
#line 133 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp8_ = g_volume_get_icon (_tmp7_);
#line 133 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp9_ = _tmp8_;
#line 133 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp10_ = g_icon_to_string (_tmp9_);
#line 133 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp11_ = _tmp10_;
#line 133 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (_tmp9_);
#line 133 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					result = _tmp11_;
#line 133 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (volume);
#line 133 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					__g_list_free__g_object_unref0_0 (volume_collection);
#line 133 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					return result;
#line 1660 "CameraTable.c"
				}
#line 131 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_g_object_unref0 (volume);
#line 1664 "CameraTable.c"
			}
		}
#line 131 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		__g_list_free__g_object_unref0_0 (volume_collection);
#line 1669 "CameraTable.c"
	}
#line 136 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	result = NULL;
#line 136 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return result;
#line 1675 "CameraTable.c"
}


static gpointer
_discovered_camera_ref0 (gpointer self)
{
#line 187 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return self ? discovered_camera_ref (self) : NULL;
#line 1684 "CameraTable.c"
}


static void
_vala_array_add69 (DiscoveredCamera** * array,
                   int* length,
                   int* size,
                   DiscoveredCamera* value)
{
#line 187 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if ((*length) == (*size)) {
#line 187 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 187 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		*array = g_renew (DiscoveredCamera*, *array, (*size) + 1);
#line 1700 "CameraTable.c"
	}
#line 187 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	(*array)[(*length)++] = value;
#line 187 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	(*array)[*length] = NULL;
#line 1706 "CameraTable.c"
}


static void
camera_table_update_camera_table (CameraTable* self,
                                  GError** error)
{
	GPPortInfoList* port_info_list = NULL;
	GPPortInfoList* _tmp0_ = NULL;
	int _tmp1_;
	GPPortInfoList* _tmp2_;
	CameraList* camera_list = NULL;
	CameraList* _tmp3_ = NULL;
	int _tmp4_;
	CameraAbilitiesList* _tmp5_;
	GPPortInfoList* _tmp6_;
	CameraList* _tmp7_;
	GPContext* _tmp8_;
	GeeHashMap* detected_map = NULL;
	GeeHashMap* _tmp9_;
	DiscoveredCamera** missing = NULL;
	DiscoveredCamera** _tmp31_;
	gint missing_length1;
	gint _missing_size_;
	DiscoveredCamera** _tmp62_;
	gint _tmp62__length1;
	GError * _inner_error_ = NULL;
#line 139 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_if_fail (IS_CAMERA_TABLE (self));
#line 142 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp1_ = gp_port_info_list_new (&_tmp0_);
#line 142 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_gp_port_info_list_free0 (port_info_list);
#line 142 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	port_info_list = _tmp0_;
#line 142 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	camera_table_do_op (self, _tmp1_, "create port list", &_inner_error_);
#line 142 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 142 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		if (_inner_error_->domain == GPHOTO_ERROR) {
#line 142 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_propagate_error (error, _inner_error_);
#line 142 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_gp_port_info_list_free0 (port_info_list);
#line 142 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			return;
#line 1754 "CameraTable.c"
		} else {
#line 142 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_gp_port_info_list_free0 (port_info_list);
#line 142 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 142 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_clear_error (&_inner_error_);
#line 142 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			return;
#line 1764 "CameraTable.c"
		}
	}
#line 143 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp2_ = port_info_list;
#line 143 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	camera_table_do_op (self, gp_port_info_list_load (_tmp2_), "load port list", &_inner_error_);
#line 143 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 143 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		if (_inner_error_->domain == GPHOTO_ERROR) {
#line 143 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_propagate_error (error, _inner_error_);
#line 143 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_gp_port_info_list_free0 (port_info_list);
#line 143 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			return;
#line 1781 "CameraTable.c"
		} else {
#line 143 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_gp_port_info_list_free0 (port_info_list);
#line 143 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 143 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_clear_error (&_inner_error_);
#line 143 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			return;
#line 1791 "CameraTable.c"
		}
	}
#line 146 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp4_ = gp_list_new (&_tmp3_);
#line 146 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_gp_list_unref0 (camera_list);
#line 146 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	camera_list = _tmp3_;
#line 146 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	camera_table_do_op (self, _tmp4_, "create camera list", &_inner_error_);
#line 146 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 146 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		if (_inner_error_->domain == GPHOTO_ERROR) {
#line 146 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_propagate_error (error, _inner_error_);
#line 146 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_gp_list_unref0 (camera_list);
#line 146 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_gp_port_info_list_free0 (port_info_list);
#line 146 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			return;
#line 1814 "CameraTable.c"
		} else {
#line 146 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_gp_list_unref0 (camera_list);
#line 146 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_gp_port_info_list_free0 (port_info_list);
#line 146 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 146 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_clear_error (&_inner_error_);
#line 146 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			return;
#line 1826 "CameraTable.c"
		}
	}
#line 147 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp5_ = self->priv->abilities_list;
#line 147 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp6_ = port_info_list;
#line 147 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp7_ = camera_list;
#line 147 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp8_ = self->priv->null_context;
#line 147 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	camera_table_do_op (self, gp_abilities_list_detect (_tmp5_, _tmp6_, _tmp7_, _tmp8_), "detect cameras", &_inner_error_);
#line 147 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 147 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		if (_inner_error_->domain == GPHOTO_ERROR) {
#line 147 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_propagate_error (error, _inner_error_);
#line 147 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_gp_list_unref0 (camera_list);
#line 147 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_gp_port_info_list_free0 (port_info_list);
#line 147 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			return;
#line 1851 "CameraTable.c"
		} else {
#line 147 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_gp_list_unref0 (camera_list);
#line 147 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_gp_port_info_list_free0 (port_info_list);
#line 147 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 147 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_clear_error (&_inner_error_);
#line 147 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			return;
#line 1863 "CameraTable.c"
		}
	}
#line 149 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp9_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 149 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	detected_map = _tmp9_;
#line 1870 "CameraTable.c"
	{
		gint ctr = 0;
#line 152 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		ctr = 0;
#line 1875 "CameraTable.c"
		{
			gboolean _tmp10_ = FALSE;
#line 152 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp10_ = TRUE;
#line 152 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			while (TRUE) {
#line 1882 "CameraTable.c"
				gint _tmp12_;
				CameraList* _tmp13_;
				gchar* name = NULL;
				CameraList* _tmp14_;
				gint _tmp15_;
				const gchar* _tmp16_ = NULL;
				int _tmp17_;
				gchar* _tmp18_;
				gchar* port = NULL;
				CameraList* _tmp19_;
				gint _tmp20_;
				const gchar* _tmp21_ = NULL;
				int _tmp22_;
				gchar* _tmp23_;
				gint _tmp24_;
				CameraList* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				GeeHashMap* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
#line 152 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				if (!_tmp10_) {
#line 1906 "CameraTable.c"
					gint _tmp11_;
#line 152 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp11_ = ctr;
#line 152 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					ctr = _tmp11_ + 1;
#line 1912 "CameraTable.c"
				}
#line 152 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp10_ = FALSE;
#line 152 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp12_ = ctr;
#line 152 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp13_ = camera_list;
#line 152 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				if (!(_tmp12_ < gp_list_count (_tmp13_))) {
#line 152 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					break;
#line 1924 "CameraTable.c"
				}
#line 154 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp14_ = camera_list;
#line 154 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp15_ = ctr;
#line 154 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp17_ = gp_list_get_name (_tmp14_, _tmp15_, &_tmp16_);
#line 154 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_g_free0 (name);
#line 154 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp18_ = g_strdup (_tmp16_);
#line 154 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				name = _tmp18_;
#line 154 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				camera_table_do_op (self, _tmp17_, "get detected camera name", &_inner_error_);
#line 154 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 154 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					if (_inner_error_->domain == GPHOTO_ERROR) {
#line 154 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						g_propagate_error (error, _inner_error_);
#line 154 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (name);
#line 154 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_object_unref0 (detected_map);
#line 154 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_list_unref0 (camera_list);
#line 154 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_port_info_list_free0 (port_info_list);
#line 154 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						return;
#line 1956 "CameraTable.c"
					} else {
#line 154 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (name);
#line 154 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_object_unref0 (detected_map);
#line 154 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_list_unref0 (camera_list);
#line 154 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_port_info_list_free0 (port_info_list);
#line 154 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 154 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						g_clear_error (&_inner_error_);
#line 154 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						return;
#line 1972 "CameraTable.c"
					}
				}
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp19_ = camera_list;
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp20_ = ctr;
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp22_ = gp_list_get_value (_tmp19_, _tmp20_, &_tmp21_);
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_g_free0 (port);
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp23_ = g_strdup (_tmp21_);
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				port = _tmp23_;
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				camera_table_do_op (self, _tmp22_, "get detected camera port", &_inner_error_);
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					if (_inner_error_->domain == GPHOTO_ERROR) {
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						g_propagate_error (error, _inner_error_);
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (port);
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (name);
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_object_unref0 (detected_map);
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_list_unref0 (camera_list);
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_port_info_list_free0 (port_info_list);
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						return;
#line 2007 "CameraTable.c"
					} else {
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (port);
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (name);
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_object_unref0 (detected_map);
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_list_unref0 (camera_list);
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_port_info_list_free0 (port_info_list);
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						g_clear_error (&_inner_error_);
#line 157 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						return;
#line 2025 "CameraTable.c"
					}
				}
#line 159 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp24_ = ctr;
#line 159 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp25_ = camera_list;
#line 159 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp26_ = name;
#line 159 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp27_ = port;
#line 159 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				g_debug ("CameraTable.vala:159: Detected %d/%d %s @ %s", _tmp24_ + 1, gp_list_count (_tmp25_), _tmp26_, _tmp27_);
#line 162 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp28_ = detected_map;
#line 162 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp29_ = port;
#line 162 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp30_ = name;
#line 162 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp29_, _tmp30_);
#line 152 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_g_free0 (port);
#line 152 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_g_free0 (name);
#line 2050 "CameraTable.c"
			}
		}
	}
#line 166 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp31_ = g_new0 (DiscoveredCamera*, 0 + 1);
#line 166 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	missing = _tmp31_;
#line 166 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	missing_length1 = 0;
#line 166 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_missing_size_ = missing_length1;
#line 2062 "CameraTable.c"
	{
		GeeIterator* _camera_it = NULL;
		GeeHashMap* _tmp32_;
		GeeCollection* _tmp33_;
		GeeCollection* _tmp34_;
		GeeCollection* _tmp35_;
		GeeIterator* _tmp36_;
		GeeIterator* _tmp37_;
#line 167 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp32_ = self->priv->camera_map;
#line 167 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp33_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 167 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp34_ = _tmp33_;
#line 167 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp35_ = _tmp34_;
#line 167 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp36_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, GEE_TYPE_ITERABLE, GeeIterable));
#line 167 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp37_ = _tmp36_;
#line 167 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_g_object_unref0 (_tmp35_);
#line 167 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_camera_it = _tmp37_;
#line 167 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		while (TRUE) {
#line 2089 "CameraTable.c"
			GeeIterator* _tmp38_;
			DiscoveredCamera* camera = NULL;
			GeeIterator* _tmp39_;
			gpointer _tmp40_;
			GPPortInfo port_info = {0};
			gchar* tmp_path = NULL;
			DiscoveredCamera* _tmp41_;
			Camera* _tmp42_;
			GPPortInfo _tmp43_ = {0};
			int _tmp44_;
			const gchar* _tmp45_ = NULL;
			gchar* _tmp46_;
			CameraAbilities abilities = {0};
			DiscoveredCamera* _tmp47_;
			Camera* _tmp48_;
			CameraAbilities _tmp49_ = {0};
			int _tmp50_;
			GeeHashMap* _tmp51_;
			const gchar* _tmp52_;
			CameraAbilities _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			DiscoveredCamera** _tmp59_;
			gint _tmp59__length1;
			DiscoveredCamera* _tmp60_;
			DiscoveredCamera* _tmp61_;
#line 167 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp38_ = _camera_it;
#line 167 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			if (!gee_iterator_next (_tmp38_)) {
#line 167 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				break;
#line 2122 "CameraTable.c"
			}
#line 167 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp39_ = _camera_it;
#line 167 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp40_ = gee_iterator_get (_tmp39_);
#line 167 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			camera = (DiscoveredCamera*) _tmp40_;
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp41_ = camera;
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp42_ = _tmp41_->gcamera;
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp44_ = gp_camera_get_port_info (_tmp42_, &_tmp43_);
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			 (port_info);
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			port_info = _tmp43_;
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			camera_table_do_op (self, _tmp44_, "retrieve missing camera port information", &_inner_error_);
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				if (_inner_error_->domain == GPHOTO_ERROR) {
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					g_propagate_error (error, _inner_error_);
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (tmp_path);
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (port_info);
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_discovered_camera_unref0 (camera);
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (_camera_it);
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (detected_map);
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_list_unref0 (camera_list);
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_port_info_list_free0 (port_info_list);
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					return;
#line 2166 "CameraTable.c"
				} else {
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (tmp_path);
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (port_info);
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_discovered_camera_unref0 (camera);
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (_camera_it);
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (detected_map);
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_list_unref0 (camera_list);
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_port_info_list_free0 (port_info_list);
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					g_clear_error (&_inner_error_);
#line 171 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					return;
#line 2190 "CameraTable.c"
				}
			}
#line 174 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			gp_port_info_get_path (port_info, &_tmp45_);
#line 174 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_g_free0 (tmp_path);
#line 174 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp46_ = g_strdup (_tmp45_);
#line 174 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			tmp_path = _tmp46_;
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp47_ = camera;
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp48_ = _tmp47_->gcamera;
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp50_ = gp_camera_get_abilities (_tmp48_, &_tmp49_);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			 (abilities);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			abilities = _tmp49_;
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			camera_table_do_op (self, _tmp50_, "retrieve camera abilities", &_inner_error_);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				if (_inner_error_->domain == GPHOTO_ERROR) {
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					g_propagate_error (error, _inner_error_);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (abilities);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (tmp_path);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (port_info);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_discovered_camera_unref0 (camera);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (_camera_it);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (detected_map);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_list_unref0 (camera_list);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_port_info_list_free0 (port_info_list);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					return;
#line 2239 "CameraTable.c"
				} else {
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (abilities);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (tmp_path);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (port_info);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_discovered_camera_unref0 (camera);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (_camera_it);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (detected_map);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_list_unref0 (camera_list);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_port_info_list_free0 (port_info_list);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					g_clear_error (&_inner_error_);
#line 177 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					return;
#line 2265 "CameraTable.c"
				}
			}
#line 179 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp51_ = detected_map;
#line 179 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp52_ = tmp_path;
#line 179 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp52_)) {
#line 2274 "CameraTable.c"
				CameraAbilities _tmp53_;
				const gchar* _tmp54_;
				const gchar* _tmp55_;
#line 180 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp53_ = abilities;
#line 180 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp54_ = _tmp53_.model;
#line 180 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp55_ = tmp_path;
#line 180 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				g_debug ("CameraTable.vala:180: Found camera for %s @ %s in detected map", _tmp54_, _tmp55_);
#line 182 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				 (abilities);
#line 182 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_g_free0 (tmp_path);
#line 182 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				 (port_info);
#line 182 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_discovered_camera_unref0 (camera);
#line 182 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				continue;
#line 2296 "CameraTable.c"
			}
#line 185 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp56_ = abilities;
#line 185 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp57_ = _tmp56_.model;
#line 185 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp58_ = tmp_path;
#line 185 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_debug ("CameraTable.vala:185: %s @ %s missing", _tmp57_, _tmp58_);
#line 187 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp59_ = missing;
#line 187 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp59__length1 = missing_length1;
#line 187 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp60_ = camera;
#line 187 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp61_ = _discovered_camera_ref0 (_tmp60_);
#line 187 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_vala_array_add69 (&missing, &missing_length1, &_missing_size_, _tmp61_);
#line 167 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			 (abilities);
#line 167 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_g_free0 (tmp_path);
#line 167 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			 (port_info);
#line 167 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_discovered_camera_unref0 (camera);
#line 2324 "CameraTable.c"
		}
#line 167 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_g_object_unref0 (_camera_it);
#line 2328 "CameraTable.c"
	}
#line 191 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp62_ = missing;
#line 191 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp62__length1 = missing_length1;
#line 2334 "CameraTable.c"
	{
		DiscoveredCamera** camera_collection = NULL;
		gint camera_collection_length1 = 0;
		gint _camera_collection_size_ = 0;
		gint camera_it = 0;
#line 191 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		camera_collection = _tmp62_;
#line 191 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		camera_collection_length1 = _tmp62__length1;
#line 191 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		for (camera_it = 0; camera_it < _tmp62__length1; camera_it = camera_it + 1) {
#line 2346 "CameraTable.c"
			DiscoveredCamera* _tmp63_;
			DiscoveredCamera* camera = NULL;
#line 191 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp63_ = _discovered_camera_ref0 (camera_collection[camera_it]);
#line 191 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			camera = _tmp63_;
#line 2353 "CameraTable.c"
			{
				GPPortInfo port_info = {0};
				gchar* tmp_path = NULL;
				DiscoveredCamera* _tmp64_;
				Camera* _tmp65_;
				GPPortInfo _tmp66_ = {0};
				int _tmp67_;
				const gchar* _tmp68_ = NULL;
				gchar* _tmp69_;
				CameraAbilities abilities = {0};
				DiscoveredCamera* _tmp70_;
				Camera* _tmp71_;
				CameraAbilities _tmp72_ = {0};
				int _tmp73_;
				CameraAbilities _tmp74_;
				const gchar* _tmp75_;
				const gchar* _tmp76_;
				GeeHashMap* _tmp77_;
				const gchar* _tmp78_;
				gchar* _tmp79_;
				gchar* _tmp80_;
				DiscoveredCamera* _tmp81_;
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp64_ = camera;
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp65_ = _tmp64_->gcamera;
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp67_ = gp_camera_get_port_info (_tmp65_, &_tmp66_);
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				 (port_info);
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				port_info = _tmp66_;
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				camera_table_do_op (self, _tmp67_, "retrieve missing camera port information", &_inner_error_);
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					if (_inner_error_->domain == GPHOTO_ERROR) {
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						g_propagate_error (error, _inner_error_);
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (tmp_path);
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						 (port_info);
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_discovered_camera_unref0 (camera);
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_object_unref0 (detected_map);
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_list_unref0 (camera_list);
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_port_info_list_free0 (port_info_list);
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						return;
#line 2410 "CameraTable.c"
					} else {
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (tmp_path);
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						 (port_info);
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_discovered_camera_unref0 (camera);
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_object_unref0 (detected_map);
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_list_unref0 (camera_list);
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_port_info_list_free0 (port_info_list);
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						g_clear_error (&_inner_error_);
#line 195 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						return;
#line 2432 "CameraTable.c"
					}
				}
#line 197 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				gp_port_info_get_path (port_info, &_tmp68_);
#line 197 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_g_free0 (tmp_path);
#line 197 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp69_ = g_strdup (_tmp68_);
#line 197 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				tmp_path = _tmp69_;
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp70_ = camera;
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp71_ = _tmp70_->gcamera;
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp73_ = gp_camera_get_abilities (_tmp71_, &_tmp72_);
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				 (abilities);
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				abilities = _tmp72_;
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				camera_table_do_op (self, _tmp73_, "retrieve missing camera abilities", &_inner_error_);
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					if (_inner_error_->domain == GPHOTO_ERROR) {
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						g_propagate_error (error, _inner_error_);
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						 (abilities);
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (tmp_path);
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						 (port_info);
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_discovered_camera_unref0 (camera);
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_object_unref0 (detected_map);
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_list_unref0 (camera_list);
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_port_info_list_free0 (port_info_list);
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						return;
#line 2479 "CameraTable.c"
					} else {
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						 (abilities);
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (tmp_path);
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						 (port_info);
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_discovered_camera_unref0 (camera);
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_object_unref0 (detected_map);
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_list_unref0 (camera_list);
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_port_info_list_free0 (port_info_list);
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						g_clear_error (&_inner_error_);
#line 200 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						return;
#line 2503 "CameraTable.c"
					}
				}
#line 202 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp74_ = abilities;
#line 202 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp75_ = _tmp74_.model;
#line 202 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp76_ = tmp_path;
#line 202 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				g_debug ("CameraTable.vala:202: Removing from camera table: %s @ %s", _tmp75_, _tmp76_);
#line 204 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp77_ = self->priv->camera_map;
#line 204 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp78_ = tmp_path;
#line 204 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp79_ = camera_table_get_port_uri (_tmp78_);
#line 204 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp80_ = _tmp79_;
#line 204 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp80_, NULL);
#line 204 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_g_free0 (_tmp80_);
#line 206 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp81_ = camera;
#line 206 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				g_signal_emit (self, camera_table_signals[CAMERA_TABLE_CAMERA_REMOVED_SIGNAL], 0, _tmp81_);
#line 191 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				 (abilities);
#line 191 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_g_free0 (tmp_path);
#line 191 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				 (port_info);
#line 191 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_discovered_camera_unref0 (camera);
#line 2538 "CameraTable.c"
			}
		}
	}
	{
		GeeIterator* _port_it = NULL;
		GeeHashMap* _tmp82_;
		GeeSet* _tmp83_;
		GeeSet* _tmp84_;
		GeeSet* _tmp85_;
		GeeIterator* _tmp86_;
		GeeIterator* _tmp87_;
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp82_ = detected_map;
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp83_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp84_ = _tmp83_;
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp85_ = _tmp84_;
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp86_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, GEE_TYPE_ITERABLE, GeeIterable));
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp87_ = _tmp86_;
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_g_object_unref0 (_tmp85_);
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_port_it = _tmp87_;
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		while (TRUE) {
#line 2568 "CameraTable.c"
			GeeIterator* _tmp88_;
			gchar* port = NULL;
			GeeIterator* _tmp89_;
			gpointer _tmp90_;
			gchar* name = NULL;
			GeeHashMap* _tmp91_;
			const gchar* _tmp92_;
			gpointer _tmp93_;
			gchar* display_name = NULL;
			gchar* icon = NULL;
			gchar* uri = NULL;
			const gchar* _tmp94_;
			gchar* _tmp95_;
			GeeHashMap* _tmp96_;
			const gchar* _tmp97_;
			gchar* path = NULL;
			const gchar* _tmp100_;
			gchar* _tmp101_;
			const gchar* _tmp102_;
			const gchar* _tmp122_;
			const gchar* _tmp141_;
			gint index = 0;
			GPPortInfoList* _tmp144_;
			const gchar* _tmp145_;
			gint _tmp146_;
			GPPortInfo port_info = {0};
			gchar* tmp_path = NULL;
			GPPortInfoList* _tmp151_;
			gint _tmp152_;
			GPPortInfo _tmp153_ = {0};
			int _tmp154_;
			const gchar* _tmp155_;
			gchar* _tmp156_;
			gchar* _tmp157_;
			const gchar* _tmp158_ = NULL;
			gchar* _tmp159_;
			const gchar* _tmp160_;
			const gchar* _tmp161_;
			CameraAbilitiesList* _tmp162_;
			const gchar* _tmp163_;
			gint _tmp164_;
			CameraAbilities camera_abilities = {0};
			CameraAbilitiesList* _tmp169_;
			gint _tmp170_;
			CameraAbilities _tmp171_ = {0};
			int _tmp172_;
			const gchar* _tmp173_;
			gchar* _tmp174_;
			gchar* _tmp175_;
			Camera* gcamera = NULL;
			Camera* _tmp176_ = NULL;
			int _tmp177_;
			const gchar* _tmp178_;
			gchar* _tmp179_;
			gchar* _tmp180_;
			Camera* _tmp181_;
			CameraAbilities _tmp182_;
			const gchar* _tmp183_;
			gchar* _tmp184_;
			gchar* _tmp185_;
			Camera* _tmp186_;
			GPPortInfo _tmp187_;
			const gchar* _tmp188_;
			const gchar* _tmp189_;
			gchar* _tmp190_;
			gchar* _tmp191_;
			const gchar* _tmp192_;
			const gchar* _tmp193_;
			DiscoveredCamera* camera = NULL;
			Camera* _tmp194_;
			const gchar* _tmp195_;
			const gchar* _tmp196_;
			const gchar* _tmp197_;
			DiscoveredCamera* _tmp198_;
			GeeHashMap* _tmp199_;
			const gchar* _tmp200_;
			DiscoveredCamera* _tmp201_;
			DiscoveredCamera* _tmp202_;
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp88_ = _port_it;
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			if (!gee_iterator_next (_tmp88_)) {
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				break;
#line 2653 "CameraTable.c"
			}
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp89_ = _port_it;
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp90_ = gee_iterator_get (_tmp89_);
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			port = (gchar*) _tmp90_;
#line 211 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp91_ = detected_map;
#line 211 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp92_ = port;
#line 211 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp93_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp92_);
#line 211 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			name = (gchar*) _tmp93_;
#line 212 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			display_name = NULL;
#line 213 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			icon = NULL;
#line 214 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp94_ = port;
#line 214 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp95_ = camera_table_get_port_uri (_tmp94_);
#line 214 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			uri = _tmp95_;
#line 216 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp96_ = self->priv->camera_map;
#line 216 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp97_ = uri;
#line 216 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp97_)) {
#line 2685 "CameraTable.c"
				const gchar* _tmp98_;
				const gchar* _tmp99_;
#line 218 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp98_ = name;
#line 218 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp99_ = port;
#line 218 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				g_debug ("CameraTable.vala:218: %s @ %s already registered, skipping", _tmp98_, _tmp99_);
#line 220 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_g_free0 (uri);
#line 220 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_g_free0 (icon);
#line 220 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_g_free0 (display_name);
#line 220 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_g_free0 (name);
#line 220 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_g_free0 (port);
#line 220 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				continue;
#line 2706 "CameraTable.c"
			}
#line 224 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp100_ = port;
#line 224 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp101_ = camera_table_get_port_path (_tmp100_);
#line 224 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			path = _tmp101_;
#line 225 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp102_ = path;
#line 225 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			if (NULL != _tmp102_) {
#line 2718 "CameraTable.c"
				GUdevDevice* device = NULL;
				GUdevClient* _tmp103_;
				const gchar* _tmp104_;
				GUdevDevice* _tmp105_;
				gchar* serial = NULL;
				GUdevDevice* _tmp106_;
				const gchar* _tmp107_;
				gchar* _tmp108_;
				const gchar* _tmp109_;
				const gchar* _tmp114_;
				const gchar* _tmp118_;
#line 226 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp103_ = self->priv->client;
#line 226 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp104_ = path;
#line 226 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp105_ = g_udev_client_query_by_device_file (_tmp103_, _tmp104_);
#line 226 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				device = _tmp105_;
#line 227 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp106_ = device;
#line 227 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp107_ = g_udev_device_get_property (_tmp106_, "ID_SERIAL_SHORT");
#line 227 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp108_ = g_strdup (_tmp107_);
#line 227 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				serial = _tmp108_;
#line 228 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp109_ = serial;
#line 228 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				if (NULL != _tmp109_) {
#line 2750 "CameraTable.c"
					const gchar* _tmp110_;
					gchar* _tmp111_;
					const gchar* _tmp112_;
					gchar* _tmp113_;
#line 230 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp110_ = serial;
#line 230 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp111_ = camera_table_get_name_for_uuid (self, _tmp110_);
#line 230 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (display_name);
#line 230 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					display_name = _tmp111_;
#line 231 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp112_ = serial;
#line 231 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp113_ = camera_table_get_icon_for_uuid (self, _tmp112_);
#line 231 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (icon);
#line 231 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					icon = _tmp113_;
#line 2771 "CameraTable.c"
				}
#line 233 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp114_ = display_name;
#line 233 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				if (NULL == _tmp114_) {
#line 2777 "CameraTable.c"
					GUdevDevice* _tmp115_;
					const gchar* _tmp116_;
					gchar* _tmp117_;
#line 234 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp115_ = device;
#line 234 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp116_ = g_udev_device_get_sysfs_attr (_tmp115_, "product");
#line 234 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp117_ = g_strdup (_tmp116_);
#line 234 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (display_name);
#line 234 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					display_name = _tmp117_;
#line 2791 "CameraTable.c"
				}
#line 236 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp118_ = display_name;
#line 236 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				if (NULL == _tmp118_) {
#line 2797 "CameraTable.c"
					GUdevDevice* _tmp119_;
					const gchar* _tmp120_;
					gchar* _tmp121_;
#line 237 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp119_ = device;
#line 237 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp120_ = g_udev_device_get_property (_tmp119_, "ID_MODEL");
#line 237 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp121_ = g_strdup (_tmp120_);
#line 237 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (display_name);
#line 237 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					display_name = _tmp121_;
#line 2811 "CameraTable.c"
				}
#line 225 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_g_free0 (serial);
#line 225 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_g_object_unref0 (device);
#line 2817 "CameraTable.c"
			}
#line 241 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp122_ = port;
#line 241 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			if (g_str_has_prefix (_tmp122_, "disk:")) {
#line 2823 "CameraTable.c"
				{
					GMount* mount = NULL;
					const gchar* _tmp123_;
					gchar* _tmp124_;
					gchar* _tmp125_;
					GFile* _tmp126_;
					GFile* _tmp127_;
					GMount* _tmp128_;
					GMount* _tmp129_;
					GVolume* volume = NULL;
					GMount* _tmp130_;
					GVolume* _tmp131_;
					const gchar* _tmp132_;
					GVolume* _tmp133_;
					gchar* _tmp134_;
					gchar* _tmp135_;
					gchar* _tmp136_;
					GVolume* _tmp137_;
					GIcon* _tmp138_;
					GIcon* _tmp139_;
					gchar* _tmp140_;
#line 243 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp123_ = port;
#line 243 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp124_ = string_substring (_tmp123_, (glong) 5, (glong) -1);
#line 243 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp125_ = _tmp124_;
#line 243 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp126_ = g_file_new_for_path (_tmp125_);
#line 243 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp127_ = _tmp126_;
#line 243 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp128_ = g_file_find_enclosing_mount (_tmp127_, NULL, &_inner_error_);
#line 243 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp129_ = _tmp128_;
#line 243 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (_tmp127_);
#line 243 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (_tmp125_);
#line 243 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					mount = _tmp129_;
#line 243 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2867 "CameraTable.c"
						goto __catch67_g_error;
					}
#line 244 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp130_ = mount;
#line 244 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp131_ = g_mount_get_volume (_tmp130_);
#line 244 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					volume = _tmp131_;
#line 246 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp132_ = name;
#line 246 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp133_ = volume;
#line 246 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp134_ = g_volume_get_name (_tmp133_);
#line 246 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp135_ = _tmp134_;
#line 246 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp136_ = g_strdup_printf (_ ("%s (%s)"), _tmp132_, _tmp135_);
#line 246 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (display_name);
#line 246 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					display_name = _tmp136_;
#line 246 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (_tmp135_);
#line 247 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp137_ = volume;
#line 247 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp138_ = g_volume_get_icon (_tmp137_);
#line 247 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp139_ = _tmp138_;
#line 247 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_tmp140_ = g_icon_to_string (_tmp139_);
#line 247 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (icon);
#line 247 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					icon = _tmp140_;
#line 247 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (_tmp139_);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (volume);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (mount);
#line 2910 "CameraTable.c"
				}
				goto __finally67;
				__catch67_g_error:
				{
					GError* e = NULL;
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					e = _inner_error_;
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_inner_error_ = NULL;
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_error_free0 (e);
#line 2922 "CameraTable.c"
				}
				__finally67:
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					if (_inner_error_->domain == GPHOTO_ERROR) {
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						g_propagate_error (error, _inner_error_);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (path);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (uri);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (icon);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (display_name);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (name);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (port);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_object_unref0 (_port_it);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_object_unref0 (detected_map);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_list_unref0 (camera_list);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_port_info_list_free0 (port_info_list);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						return;
#line 2955 "CameraTable.c"
					} else {
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (path);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (uri);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (icon);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (display_name);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (name);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (port);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_object_unref0 (_port_it);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_object_unref0 (detected_map);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_list_unref0 (camera_list);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_port_info_list_free0 (port_info_list);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						g_clear_error (&_inner_error_);
#line 242 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						return;
#line 2985 "CameraTable.c"
					}
				}
			}
#line 251 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp141_ = display_name;
#line 251 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			if (NULL == _tmp141_) {
#line 2993 "CameraTable.c"
				const gchar* _tmp142_;
				gchar* _tmp143_;
#line 253 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp142_ = name;
#line 253 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp143_ = g_strdup (_tmp142_);
#line 253 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_g_free0 (display_name);
#line 253 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				display_name = _tmp143_;
#line 3004 "CameraTable.c"
			}
#line 255 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp144_ = port_info_list;
#line 255 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp145_ = port;
#line 255 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			index = gp_port_info_list_lookup_path (_tmp144_, _tmp145_);
#line 256 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp146_ = index;
#line 256 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			if (_tmp146_ < 0) {
#line 3016 "CameraTable.c"
				gint _tmp147_;
				const gchar* _tmp148_;
				gchar* _tmp149_;
				gchar* _tmp150_;
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp147_ = index;
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp148_ = port;
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp149_ = g_strdup_printf ("lookup port %s", _tmp148_);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp150_ = _tmp149_;
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				camera_table_do_op (self, (int) _tmp147_, _tmp150_, &_inner_error_);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_g_free0 (_tmp150_);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					if (_inner_error_->domain == GPHOTO_ERROR) {
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						g_propagate_error (error, _inner_error_);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (path);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (uri);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (icon);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (display_name);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (name);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (port);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_object_unref0 (_port_it);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_object_unref0 (detected_map);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_list_unref0 (camera_list);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_port_info_list_free0 (port_info_list);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						return;
#line 3063 "CameraTable.c"
					} else {
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (path);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (uri);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (icon);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (display_name);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (name);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (port);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_object_unref0 (_port_it);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_object_unref0 (detected_map);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_list_unref0 (camera_list);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_port_info_list_free0 (port_info_list);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						g_clear_error (&_inner_error_);
#line 257 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						return;
#line 3093 "CameraTable.c"
					}
				}
			}
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp151_ = port_info_list;
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp152_ = index;
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp154_ = gp_port_info_list_get_info (_tmp151_, _tmp152_, &_tmp153_);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			 (port_info);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			port_info = _tmp153_;
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp155_ = port;
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp156_ = g_strdup_printf ("get port info for %s", _tmp155_);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp157_ = _tmp156_;
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			camera_table_do_op (self, _tmp154_, _tmp157_, &_inner_error_);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_g_free0 (_tmp157_);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				if (_inner_error_->domain == GPHOTO_ERROR) {
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					g_propagate_error (error, _inner_error_);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (tmp_path);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (port_info);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (path);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (uri);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (icon);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (display_name);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (name);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (port);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (_port_it);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (detected_map);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_list_unref0 (camera_list);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_port_info_list_free0 (port_info_list);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					return;
#line 3151 "CameraTable.c"
				} else {
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (tmp_path);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (port_info);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (path);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (uri);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (icon);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (display_name);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (name);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (port);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (_port_it);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (detected_map);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_list_unref0 (camera_list);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_port_info_list_free0 (port_info_list);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					g_clear_error (&_inner_error_);
#line 262 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					return;
#line 3185 "CameraTable.c"
				}
			}
#line 263 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			gp_port_info_get_path (port_info, &_tmp158_);
#line 263 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_g_free0 (tmp_path);
#line 263 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp159_ = g_strdup (_tmp158_);
#line 263 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			tmp_path = _tmp159_;
#line 266 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp160_ = port;
#line 266 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp161_ = tmp_path;
#line 266 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_vala_assert (g_strcmp0 (_tmp160_, _tmp161_) == 0, "port == tmp_path");
#line 268 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp162_ = self->priv->abilities_list;
#line 268 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp163_ = name;
#line 268 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			index = gp_abilities_list_lookup_model (_tmp162_, _tmp163_);
#line 269 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp164_ = index;
#line 269 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			if (_tmp164_ < 0) {
#line 3212 "CameraTable.c"
				gint _tmp165_;
				const gchar* _tmp166_;
				gchar* _tmp167_;
				gchar* _tmp168_;
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp165_ = index;
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp166_ = name;
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp167_ = g_strdup_printf ("lookup camera model %s", _tmp166_);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_tmp168_ = _tmp167_;
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				camera_table_do_op (self, (int) _tmp165_, _tmp168_, &_inner_error_);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				_g_free0 (_tmp168_);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					if (_inner_error_->domain == GPHOTO_ERROR) {
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						g_propagate_error (error, _inner_error_);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (tmp_path);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						 (port_info);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (path);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (uri);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (icon);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (display_name);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (name);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (port);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_object_unref0 (_port_it);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_object_unref0 (detected_map);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_list_unref0 (camera_list);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_port_info_list_free0 (port_info_list);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						return;
#line 3263 "CameraTable.c"
					} else {
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (tmp_path);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						 (port_info);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (path);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (uri);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (icon);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (display_name);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (name);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_free0 (port);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_object_unref0 (_port_it);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_g_object_unref0 (detected_map);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_list_unref0 (camera_list);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						_gp_port_info_list_free0 (port_info_list);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						g_clear_error (&_inner_error_);
#line 270 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
						return;
#line 3297 "CameraTable.c"
					}
				}
			}
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp169_ = self->priv->abilities_list;
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp170_ = index;
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp172_ = gp_abilities_list_get_abilities (_tmp169_, _tmp170_, &_tmp171_);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			 (camera_abilities);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			camera_abilities = _tmp171_;
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp173_ = name;
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp174_ = g_strdup_printf ("lookup camera abilities for %s", _tmp173_);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp175_ = _tmp174_;
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			camera_table_do_op (self, _tmp172_, _tmp175_, &_inner_error_);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_g_free0 (_tmp175_);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				if (_inner_error_->domain == GPHOTO_ERROR) {
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					g_propagate_error (error, _inner_error_);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (camera_abilities);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (tmp_path);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (port_info);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (path);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (uri);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (icon);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (display_name);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (name);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (port);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (_port_it);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (detected_map);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_list_unref0 (camera_list);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_port_info_list_free0 (port_info_list);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					return;
#line 3357 "CameraTable.c"
				} else {
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (camera_abilities);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (tmp_path);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (port_info);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (path);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (uri);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (icon);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (display_name);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (name);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (port);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (_port_it);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (detected_map);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_list_unref0 (camera_list);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_port_info_list_free0 (port_info_list);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					g_clear_error (&_inner_error_);
#line 273 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					return;
#line 3393 "CameraTable.c"
				}
			}
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp177_ = gp_camera_new (&_tmp176_);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_gp_camera_unref0 (gcamera);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			gcamera = _tmp176_;
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp178_ = name;
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp179_ = g_strdup_printf ("create camera object for %s", _tmp178_);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp180_ = _tmp179_;
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			camera_table_do_op (self, _tmp177_, _tmp180_, &_inner_error_);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_g_free0 (_tmp180_);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				if (_inner_error_->domain == GPHOTO_ERROR) {
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					g_propagate_error (error, _inner_error_);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_camera_unref0 (gcamera);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (camera_abilities);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (tmp_path);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (port_info);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (path);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (uri);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (icon);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (display_name);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (name);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (port);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (_port_it);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (detected_map);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_list_unref0 (camera_list);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_port_info_list_free0 (port_info_list);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					return;
#line 3450 "CameraTable.c"
				} else {
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_camera_unref0 (gcamera);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (camera_abilities);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (tmp_path);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (port_info);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (path);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (uri);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (icon);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (display_name);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (name);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (port);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (_port_it);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (detected_map);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_list_unref0 (camera_list);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_port_info_list_free0 (port_info_list);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					g_clear_error (&_inner_error_);
#line 277 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					return;
#line 3488 "CameraTable.c"
				}
			}
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp181_ = gcamera;
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp182_ = camera_abilities;
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp183_ = name;
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp184_ = g_strdup_printf ("set camera abilities for %s", _tmp183_);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp185_ = _tmp184_;
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			camera_table_do_op (self, gp_camera_set_abilities (_tmp181_, _tmp182_), _tmp185_, &_inner_error_);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_g_free0 (_tmp185_);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				if (_inner_error_->domain == GPHOTO_ERROR) {
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					g_propagate_error (error, _inner_error_);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_camera_unref0 (gcamera);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (camera_abilities);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (tmp_path);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (port_info);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (path);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (uri);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (icon);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (display_name);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (name);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (port);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (_port_it);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (detected_map);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_list_unref0 (camera_list);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_port_info_list_free0 (port_info_list);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					return;
#line 3543 "CameraTable.c"
				} else {
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_camera_unref0 (gcamera);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (camera_abilities);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (tmp_path);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (port_info);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (path);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (uri);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (icon);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (display_name);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (name);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (port);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (_port_it);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (detected_map);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_list_unref0 (camera_list);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_port_info_list_free0 (port_info_list);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					g_clear_error (&_inner_error_);
#line 278 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					return;
#line 3581 "CameraTable.c"
				}
			}
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp186_ = gcamera;
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp187_ = port_info;
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp188_ = name;
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp189_ = port;
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp190_ = g_strdup_printf ("set port info for %s on %s", _tmp188_, _tmp189_);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp191_ = _tmp190_;
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			camera_table_do_op (self, gp_camera_set_port_info (_tmp186_, _tmp187_), _tmp191_, &_inner_error_);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_g_free0 (_tmp191_);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
				if (_inner_error_->domain == GPHOTO_ERROR) {
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					g_propagate_error (error, _inner_error_);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_camera_unref0 (gcamera);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (camera_abilities);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (tmp_path);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (port_info);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (path);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (uri);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (icon);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (display_name);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (name);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (port);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (_port_it);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (detected_map);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_list_unref0 (camera_list);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_port_info_list_free0 (port_info_list);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					return;
#line 3638 "CameraTable.c"
				} else {
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_camera_unref0 (gcamera);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (camera_abilities);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (tmp_path);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					 (port_info);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (path);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (uri);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (icon);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (display_name);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (name);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_free0 (port);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (_port_it);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_g_object_unref0 (detected_map);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_list_unref0 (camera_list);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					_gp_port_info_list_free0 (port_info_list);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					g_clear_error (&_inner_error_);
#line 279 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
					return;
#line 3676 "CameraTable.c"
				}
			}
#line 281 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp192_ = name;
#line 281 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp193_ = port;
#line 281 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_debug ("CameraTable.vala:281: Adding to camera table: %s @ %s", _tmp192_, _tmp193_);
#line 283 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp194_ = gcamera;
#line 283 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp195_ = uri;
#line 283 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp196_ = display_name;
#line 283 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp197_ = icon;
#line 283 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp198_ = discovered_camera_new (_tmp194_, _tmp195_, _tmp196_, _tmp197_);
#line 283 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			camera = _tmp198_;
#line 284 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp199_ = self->priv->camera_map;
#line 284 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp200_ = uri;
#line 284 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp201_ = camera;
#line 284 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp199_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp200_, _tmp201_);
#line 286 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_tmp202_ = camera;
#line 286 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_signal_emit (self, camera_table_signals[CAMERA_TABLE_CAMERA_ADDED_SIGNAL], 0, _tmp202_);
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_discovered_camera_unref0 (camera);
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_gp_camera_unref0 (gcamera);
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			 (camera_abilities);
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_g_free0 (tmp_path);
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			 (port_info);
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_g_free0 (path);
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_g_free0 (uri);
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_g_free0 (icon);
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_g_free0 (display_name);
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_g_free0 (name);
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			_g_free0 (port);
#line 3731 "CameraTable.c"
		}
#line 210 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_g_object_unref0 (_port_it);
#line 3735 "CameraTable.c"
	}
#line 139 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
#line 139 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_g_object_unref0 (detected_map);
#line 139 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_gp_list_unref0 (camera_list);
#line 139 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_gp_port_info_list_free0 (port_info_list);
#line 3745 "CameraTable.c"
}


static void
camera_table_on_udev_event (CameraTable* self,
                            const gchar* action,
                            GUdevDevice* device)
{
	const gchar* _tmp0_;
	OneShotScheduler* _tmp1_;
#line 290 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_if_fail (IS_CAMERA_TABLE (self));
#line 290 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_if_fail (action != NULL);
#line 290 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_if_fail (G_UDEV_IS_DEVICE (device));
#line 291 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp0_ = g_udev_device_get_name (device);
#line 291 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_debug ("CameraTable.vala:291: udev event: %s on %s", action, _tmp0_);
#line 295 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp1_ = self->priv->camera_update_scheduler;
#line 295 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	one_shot_scheduler_after_timeout (_tmp1_, (guint) CAMERA_TABLE_UPDATE_DELAY_MSEC, TRUE);
#line 3770 "CameraTable.c"
}


void
camera_table_on_volume_changed (CameraTable* self,
                                GVolume* volume)
{
	OneShotScheduler* _tmp0_;
#line 298 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_if_fail (IS_CAMERA_TABLE (self));
#line 298 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_if_fail (G_IS_VOLUME (volume));
#line 299 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp0_ = self->priv->camera_update_scheduler;
#line 299 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	one_shot_scheduler_after_timeout (_tmp0_, (guint) CAMERA_TABLE_UPDATE_DELAY_MSEC, TRUE);
#line 3787 "CameraTable.c"
}


static void
camera_table_on_update_cameras (CameraTable* self)
{
	GError * _inner_error_ = NULL;
#line 302 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_if_fail (IS_CAMERA_TABLE (self));
#line 3797 "CameraTable.c"
	{
		CameraTable* _tmp0_;
		CameraTable* _tmp1_;
#line 304 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp0_ = camera_table_get_instance ();
#line 304 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp1_ = _tmp0_;
#line 304 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		camera_table_update_camera_table (_tmp1_, &_inner_error_);
#line 304 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_camera_table_unref0 (_tmp1_);
#line 304 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 304 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			if (_inner_error_->domain == GPHOTO_ERROR) {
#line 3813 "CameraTable.c"
				goto __catch68_gphoto_error;
			}
#line 304 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 304 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			g_clear_error (&_inner_error_);
#line 304 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			return;
#line 3822 "CameraTable.c"
		}
	}
	goto __finally68;
	__catch68_gphoto_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 303 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		err = _inner_error_;
#line 303 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_inner_error_ = NULL;
#line 306 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp2_ = err;
#line 306 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_tmp3_ = _tmp2_->message;
#line 306 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		g_warning ("CameraTable.vala:306: Error updating camera table: %s", _tmp3_);
#line 303 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		_g_error_free0 (err);
#line 3843 "CameraTable.c"
	}
	__finally68:
#line 303 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 303 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 303 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		g_clear_error (&_inner_error_);
#line 303 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		return;
#line 3854 "CameraTable.c"
	}
}


static void
g_cclosure_user_marshal_VOID__DISCOVERED_CAMERA (GClosure * closure,
                                                 GValue * return_value,
                                                 guint n_param_values,
                                                 const GValue * param_values,
                                                 gpointer invocation_hint,
                                                 gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__DISCOVERED_CAMERA) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__DISCOVERED_CAMERA callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_if_fail (n_param_values == 2);
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		data1 = closure->data;
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		data2 = param_values->data[0].v_pointer;
#line 3881 "CameraTable.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		data1 = param_values->data[0].v_pointer;
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		data2 = closure->data;
#line 3887 "CameraTable.c"
	}
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	callback = (GMarshalFunc_VOID__DISCOVERED_CAMERA) (marshal_data ? marshal_data : cc->callback);
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	callback (data1, value_get_discovered_camera (param_values + 1), data2);
#line 3893 "CameraTable.c"
}


static void
value_camera_table_init (GValue* value)
{
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	value->data[0].v_pointer = NULL;
#line 3902 "CameraTable.c"
}


static void
value_camera_table_free_value (GValue* value)
{
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (value->data[0].v_pointer) {
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		camera_table_unref (value->data[0].v_pointer);
#line 3913 "CameraTable.c"
	}
}


static void
value_camera_table_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (src_value->data[0].v_pointer) {
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		dest_value->data[0].v_pointer = camera_table_ref (src_value->data[0].v_pointer);
#line 3926 "CameraTable.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3930 "CameraTable.c"
	}
}


static gpointer
value_camera_table_peek_pointer (const GValue* value)
{
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return value->data[0].v_pointer;
#line 3940 "CameraTable.c"
}


static gchar*
value_camera_table_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (collect_values[0].v_pointer) {
#line 3952 "CameraTable.c"
		CameraTable * object;
		object = collect_values[0].v_pointer;
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		if (object->parent_instance.g_class == NULL) {
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3959 "CameraTable.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3963 "CameraTable.c"
		}
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		value->data[0].v_pointer = camera_table_ref (object);
#line 3967 "CameraTable.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		value->data[0].v_pointer = NULL;
#line 3971 "CameraTable.c"
	}
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return NULL;
#line 3975 "CameraTable.c"
}


static gchar*
value_camera_table_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	CameraTable ** object_p;
	object_p = collect_values[0].v_pointer;
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (!object_p) {
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3991 "CameraTable.c"
	}
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (!value->data[0].v_pointer) {
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		*object_p = NULL;
#line 3997 "CameraTable.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		*object_p = value->data[0].v_pointer;
#line 4001 "CameraTable.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		*object_p = camera_table_ref (value->data[0].v_pointer);
#line 4005 "CameraTable.c"
	}
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return NULL;
#line 4009 "CameraTable.c"
}


GParamSpec*
param_spec_camera_table (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	ParamSpecCameraTable* spec;
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CAMERA_TABLE), NULL);
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return G_PARAM_SPEC (spec);
#line 4029 "CameraTable.c"
}


gpointer
value_get_camera_table (const GValue* value)
{
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CAMERA_TABLE), NULL);
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return value->data[0].v_pointer;
#line 4040 "CameraTable.c"
}


void
value_set_camera_table (GValue* value,
                        gpointer v_object)
{
	CameraTable * old;
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CAMERA_TABLE));
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	old = value->data[0].v_pointer;
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (v_object) {
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CAMERA_TABLE));
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		value->data[0].v_pointer = v_object;
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		camera_table_ref (value->data[0].v_pointer);
#line 4063 "CameraTable.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		value->data[0].v_pointer = NULL;
#line 4067 "CameraTable.c"
	}
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (old) {
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		camera_table_unref (old);
#line 4073 "CameraTable.c"
	}
}


void
value_take_camera_table (GValue* value,
                         gpointer v_object)
{
	CameraTable * old;
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CAMERA_TABLE));
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	old = value->data[0].v_pointer;
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (v_object) {
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CAMERA_TABLE));
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		value->data[0].v_pointer = v_object;
#line 4095 "CameraTable.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		value->data[0].v_pointer = NULL;
#line 4099 "CameraTable.c"
	}
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (old) {
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		camera_table_unref (old);
#line 4105 "CameraTable.c"
	}
}


static void
camera_table_class_init (CameraTableClass * klass)
{
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	camera_table_parent_class = g_type_class_peek_parent (klass);
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	((CameraTableClass *) klass)->finalize = camera_table_finalize;
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_type_class_add_private (klass, sizeof (CameraTablePrivate));
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	camera_table_signals[CAMERA_TABLE_CAMERA_ADDED_SIGNAL] = g_signal_new ("camera-added", TYPE_CAMERA_TABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__DISCOVERED_CAMERA, G_TYPE_NONE, 1, TYPE_DISCOVERED_CAMERA);
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	camera_table_signals[CAMERA_TABLE_CAMERA_REMOVED_SIGNAL] = g_signal_new ("camera-removed", TYPE_CAMERA_TABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__DISCOVERED_CAMERA, G_TYPE_NONE, 1, TYPE_DISCOVERED_CAMERA);
#line 4123 "CameraTable.c"
}


static void
camera_table_instance_init (CameraTable * self)
{
	GUdevClient* _tmp0_;
	GPContext* _tmp1_;
	GeeHashMap* _tmp2_;
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	self->priv = CAMERA_TABLE_GET_PRIVATE (self);
#line 29 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp0_ = g_udev_client_new (CAMERA_TABLE_SUBSYSTEMS);
#line 29 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	self->priv->client = _tmp0_;
#line 30 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	self->priv->camera_update_scheduler = NULL;
#line 31 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp1_ = gp_context_new ();
#line 31 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	self->priv->null_context = _tmp1_;
#line 35 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_DISCOVERED_CAMERA, (GBoxedCopyFunc) discovered_camera_ref, (GDestroyNotify) discovered_camera_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 35 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	self->priv->camera_map = _tmp2_;
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	self->ref_count = 1;
#line 4151 "CameraTable.c"
}


static void
camera_table_finalize (CameraTable * obj)
{
	CameraTable * self;
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CAMERA_TABLE, CameraTable);
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_signal_handlers_destroy (self);
#line 29 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_g_object_unref0 (self->priv->client);
#line 30 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_one_shot_scheduler_unref0 (self->priv->camera_update_scheduler);
#line 31 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_gp_context_unref0 (self->priv->null_context);
#line 32 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_gp_abilities_list_free0 (self->priv->abilities_list);
#line 33 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_g_object_unref0 (self->priv->volume_monitor);
#line 35 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	_g_object_unref0 (self->priv->camera_map);
#line 4175 "CameraTable.c"
}


GType
camera_table_get_type (void)
{
	static volatile gsize camera_table_type_id__volatile = 0;
	if (g_once_init_enter (&camera_table_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_camera_table_init, value_camera_table_free_value, value_camera_table_copy_value, value_camera_table_peek_pointer, "p", value_camera_table_collect_value, "p", value_camera_table_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (CameraTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) camera_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CameraTable), 0, (GInstanceInitFunc) camera_table_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType camera_table_type_id;
		camera_table_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CameraTable", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&camera_table_type_id__volatile, camera_table_type_id);
	}
	return camera_table_type_id__volatile;
}


gpointer
camera_table_ref (gpointer instance)
{
	CameraTable * self;
	self = instance;
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	g_atomic_int_inc (&self->ref_count);
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	return instance;
#line 4204 "CameraTable.c"
}


void
camera_table_unref (gpointer instance)
{
	CameraTable * self;
	self = instance;
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		CAMERA_TABLE_GET_CLASS (self)->finalize (self);
#line 21 "/home/jens/Source/shotwell/src/camera/CameraTable.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4219 "CameraTable.c"
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



