/**
 * \file config-no-entropy.h
 *
 * \brief Minimal configuration of features that do not require an entropy source
 */
/*
 *  Copyright (C) 2016, ARM Limited, All Rights Reserved
 *  SPDX-License-Identifier: Apache-2.0
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"); you may
 *  not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 *  WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  This file is part of mbed TLS (https://tls.mbed.org)
 */
/*
 * Minimal configuration of features that do not require an entropy source
 * Distinguishing reatures:
 * - no entropy module
 * - no TLS protocol implementation available due to absence of an entropy
 *   source
 *
 * See README.txt for usage instructions.
 */

#ifndef MBEDTLS_CONFIG_H
#define MBEDTLS_CONFIG_H

/* System support */
#define MBEDTLS_HAVE_ASM
#define MBEDTLS_HAVE_TIME

/* mbed TLS feature support */
//#define MBEDTLS_CIPHER_MODE_CFB
//#define MBEDTLS_CIPHER_MODE_CBC
//#define MBEDTLS_CIPHER_PADDING_PKCS7
//#define MBEDTLS_REMOVE_ARC4_CIPHERSUITES
//#define MBEDTLS_ECP_DP_SECP256R1_ENABLED
//#define MBEDTLS_ECP_DP_SECP384R1_ENABLED
//#define MBEDTLS_ECP_DP_CURVE25519_ENABLED
//#define MBEDTLS_ECP_NIST_OPTIM
//#define MBEDTLS_ECDSA_DETERMINISTIC
//#define MBEDTLS_PK_RSA_ALT_SUPPORT
#define MBEDTLS_PKCS1_V15
//#define MBEDTLS_PKCS1_V21
//#define MBEDTLS_SELF_TEST
#define MBEDTLS_VERSION_FEATURES
#define MBEDTLS_X509_CHECK_KEY_USAGE
#define MBEDTLS_X509_CHECK_EXTENDED_KEY_USAGE

/* mbed TLS modules */
//#define MBEDTLS_AES_C
#define MBEDTLS_ASN1_PARSE_C
#define MBEDTLS_BASE64_C
#define MBEDTLS_BIGNUM_C
//#define MBEDTLS_CCM_C
//#define MBEDTLS_CIPHER_C
//#define MBEDTLS_ECDSA_C
//#define MBEDTLS_ECP_C
#define MBEDTLS_ERROR_C
//#define MBEDTLS_GCM_C
#define MBEDTLS_MD_C
#define MBEDTLS_OID_C
//#define MBEDTLS_PEM_PARSE_C
#define MBEDTLS_PK_C
#define MBEDTLS_PK_PARSE_C
#define MBEDTLS_PKCS7_C
//#define MBEDTLS_PK_WRITE_C
#define MBEDTLS_PLATFORM_C
#define MBEDTLS_RSA_C
#define MBEDTLS_SHA256_C
#define MBEDTLS_SHA512_C
#define MBEDTLS_X509_USE_C
#define MBEDTLS_X509_CRT_PARSE_C
#define MBEDTLS_X509_CRL_PARSE_C
//#define MBEDTLS_CMAC_C

/* Settings to reduce/remove warnings */
#define MBEDTLS_MPI_WINDOW_SIZE	3	// (max/default is 6) Increase for speed, may introduce warnings
#define MBEDTLS_MPI_MAX_SIZE	512	// (default is 1024) increase for more bits in user-MPIs
#ifndef SIZE_MAX
#define SIZE_MAX		65535	// this might need to be in libc?
#endif

/* Disableable to mitigate warnings */
//#define MBEDTLS_ASN1_WRITE_C  // Expects SIZE_MAX
#define MBEDTLS_VERSION_C     // Possible 'const' function
#define MBEDTLS_HMAC_DRBG_C

/* Miscellaneous options and fixes*/
//#define MBEDTLS_AES_ROM_TABLES
#define MBEDTLS_NO_UDBL_DIVISION	// Disabled due to unsupported operation

#endif /* MBEDTLS_CONFIG_H */
