.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XSetClipOrigin __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XSetClipOrigin, XSetClipMask, XSetClipRectangles \- GC convenience routines
.SH SYNTAX
.HP
int XSetClipOrigin\^(\^Display *\fIdisplay\fP\^, GC \fIgc\fP\^, int
\fIclip_x_origin\fP\^, int \fIclip_y_origin\fP\^);
.HP
int XSetClipMask\^(\^Display *\fIdisplay\fP\^, GC \fIgc\fP\^, Pixmap
\fIpixmap\fP\^);
.HP
int XSetClipRectangles\^(\^Display *\fIdisplay\fP\^, GC \fIgc\fP\^, int
\fIclip_x_origin\fP\^, int \fIclip_y_origin\fP\^, XRectangle
\fIrectangles\fP[]\^, int \fIn\fP\^, int \fIordering\fP\^);
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIclip_x_origin\fP 1i
.br
.ns
.IP \fIclip_y_origin\fP 1i
Specify the x and y coordinates of the clip-mask origin.
.IP \fIgc\fP 1i
Specifies the GC.
.IP \fIn\fP 1i
Specifies the number of rectangles.
.IP \fIordering\fP 1i
Specifies the ordering relations on the rectangles.
You can pass
.BR Unsorted ,
.BR YSorted ,
.BR YXSorted ,
or
.BR YXBanded .
.IP \fIpixmap\fP 1i
Specifies the pixmap or
.BR None .
.IP \fIrectangles\fP 1i
Specifies an array of rectangles that define the clip-mask.
.SH DESCRIPTION
The
.B XSetClipOrigin
function sets the clip origin in the specified GC.
The clip-mask origin is interpreted relative to the origin of whatever
destination drawable is specified in the graphics request.
.LP
.B XSetClipOrigin
can generate
.B BadAlloc
and
.B BadGC
errors.
.LP
The
.B XSetClipMask
function sets the clip-mask in the specified GC to the specified pixmap.
If the clip-mask is set to
.BR None ,
the pixels are are always drawn (regardless of the clip-origin).
.LP
.B XSetClipMask
can generate
.BR BadAlloc ,
.BR BadGC ,
.BR BadMatch ,
and
.B BadValue
errors.
.LP
The
.B XSetClipRectangles
function changes the clip-mask in the specified GC
to the specified list of rectangles and sets the clip origin.
The output is clipped to remain contained within the
rectangles.
The clip-origin is interpreted relative to the origin of
whatever destination drawable is specified in a graphics request.
The rectangle coordinates are interpreted relative to the clip-origin.
The rectangles should be nonintersecting, or the graphics results will be
undefined.
Note that the list of rectangles can be empty,
which effectively disables output.
This is the opposite of passing
.B None
as the clip-mask in
.BR XCreateGC ,
.BR XChangeGC ,
and
.BR XSetClipMask .
.LP
If known by the client, ordering relations on the rectangles can be
specified with the ordering argument.
This may provide faster operation
by the server.
If an incorrect ordering is specified, the X server may generate a
.B BadMatch
error, but it is not required to do so.
If no error is generated, the graphics
results are undefined.
.B Unsorted
means the rectangles are in arbitrary order.
.B YSorted
means that the rectangles are nondecreasing in their Y origin.
.B YXSorted
additionally constrains
.B YSorted
order in that all
rectangles with an equal Y origin are nondecreasing in their X
origin.
.B YXBanded
additionally constrains
.B YXSorted
by requiring that,
for every possible Y scanline, all rectangles that include that
scanline have an identical Y origins and Y extents.
.LP
.B XSetClipRectangles
can generate
.BR BadAlloc ,
.BR BadGC ,
.BR BadMatch ,
and
.B BadValue
errors.
.SH DIAGNOSTICS
.TP 1i
.B BadAlloc
The server failed to allocate the requested resource or server memory.
.TP 1i
.B BadGC
A value for a GContext argument does not name a defined GContext.
.TP 1i
.B BadMatch
Some argument or pair of arguments has the correct type and range but fails
to match in some other way required by the request.
.TP 1i
.B BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.
Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
XCreateGC(__libmansuffix__),
XDrawRectangle(__libmansuffix__),
XQueryBestSize(__libmansuffix__),
XSetArcMode(__libmansuffix__),
XSetFillStyle(__libmansuffix__),
XSetFont(__libmansuffix__),
XSetLineAttributes(__libmansuffix__),
XSetState(__libmansuffix__),
XSetTile(__libmansuffix__)
.br
\fI\*(xL\fP
