/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/*
 * GData Client
 * Copyright (C) Holger Berndt 2011 <hb@gnome.org>
 *
 * GData Client is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * GData Client is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GData Client.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GDATA_VERSION_H
#define GDATA_VERSION_H

/**
 * SECTION:gdata-version
 * @Short_description: Macros to check the libgdata version
 * @Title: Version Information
 *
 * libgdata provides compile-time version information.
 *
 * Since: 0.11.0
 */

/**
 * GDATA_MAJOR_VERSION:
 *
 * Evaluates to the major version of the GData headers at compile time.
 * (e.g. in libgdata version 1.2.3 this is 1).
 *
 * Since: 0.11.0
 */
#define GDATA_MAJOR_VERSION (0)

/**
 * GDATA_MINOR_VERSION:
 *
 * Evaluates to the minor version of the GData headers at compile time.
 * (e.g. in libgdata version 1.2.3 this is 2).
 *
 * Since: 0.11.0
 */
#define GDATA_MINOR_VERSION (14)

/**
 * GDATA_MICRO_VERSION:
 *
 * Evaluates to the micro version of the GData headers at compile time.
 * (e.g. in libgdata version 1.2.3 this is 3).
 *
 * Since: 0.11.0
 */
#define GDATA_MICRO_VERSION (1)

/**
 * GDATA_CHECK_VERSION:
 * @major: major version (e.g. 1 for version 1.2.3)
 * @minor: minor version (e.g. 2 for version 1.2.3)
 * @micro: micro version (e.g. 3 for version 1.2.3)
 *
 * Evaluates to %TRUE if the version of the GData header files
 * is the same as or newer than the passed-in version.
 *
 * Since: 0.11.0
 */
#define GDATA_CHECK_VERSION(major,minor,micro)                          \
    (GDATA_MAJOR_VERSION > (major) ||                                   \
     (GDATA_MAJOR_VERSION == (major) && GDATA_MINOR_VERSION > (minor)) || \
     (GDATA_MAJOR_VERSION == (major) && GDATA_MINOR_VERSION == (minor) && \
      GDATA_MICRO_VERSION >= (micro)))

#endif /* !GDATA_VERSION_H */
