/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.ClassCP;
import jas.ClassEnv;
import jas.CodeAttr;
import jas.Label;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;

public class VerificationTypeInfo {
    private int tag;
    private ClassCP cls;
    private int index;
    private Label un_label;

    public VerificationTypeInfo(String item) throws jasError {
        this(item, null);
    }

    public VerificationTypeInfo(String item, String val) throws jasError {
        if (item.equals("Top")) {
            this.tag = 0;
        } else if (item.equals("Integer")) {
            this.tag = 1;
        } else if (item.equals("Float")) {
            this.tag = 2;
        } else if (item.equals("Long")) {
            this.tag = 4;
        } else if (item.equals("Double")) {
            this.tag = 3;
        } else if (item.equals("Null")) {
            this.tag = 5;
        } else if (item.equals("UninitializedThis")) {
            this.tag = 6;
        } else if (item.equals("Object")) {
            if (val == null) {
                throw new jasError("Object requires a class name");
            }
            this.cls = new ClassCP(val);
            this.tag = 7;
        } else if (item.equals("Uninitialized")) {
            if (val == null) {
                throw new jasError("Uninitialized requires an integer or label");
            }
            try {
                this.index = Integer.parseInt(val);
            }
            catch (Exception e) {
                this.un_label = new Label(val);
            }
            this.tag = 8;
        } else {
            throw new jasError("Unknown item verification type : " + item);
        }
    }

    void resolve(ClassEnv e) {
        if (this.tag == 7) {
            this.cls.resolve(e);
            e.addCPItem(this.cls);
        }
    }

    void write(ClassEnv e, CodeAttr ce, DataOutputStream out) throws IOException, jasError {
        out.writeByte(this.tag);
        if (this.tag == 7) {
            out.writeShort(e.getCPIndex(this.cls));
        } else if (this.tag == 8) {
            if (this.un_label != null) {
                this.un_label.writeOffset(ce, null, out);
            } else if ((this.index & 0xFFFF) == this.index) {
                out.writeShort(this.index);
            } else {
                out.writeInt(this.index);
            }
        }
    }

    private int getOffset(CodeAttr ce) throws jasError {
        if (this.un_label != null) {
            return this.un_label.getOffset(ce);
        }
        return this.index;
    }

    boolean isEqual(ClassEnv e, CodeAttr ce, VerificationTypeInfo cmp) throws jasError {
        if (this.tag != cmp.tag) {
            return false;
        }
        if (this.tag == 7) {
            return e.getCPIndex(this.cls) == e.getCPIndex(cmp.cls);
        }
        if (this.tag == 8) {
            return this.getOffset(ce) == cmp.getOffset(ce);
        }
        return true;
    }
}

