; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=instcombine -S -disable-i2p-p2i-opt < %s | FileCheck %s

target datalayout = "e-p:64:64-p1:16:16-p2:32:32:32-p3:64:64:64"
target triple = "x86_64-unknown-linux-gnu"

; convert ptrtoint [ phi[ inttoptr (ptrtoint (x) ) ] ---> ptrtoint (phi[x])

define i64 @func(ptr %X, ptr %Y, i1 %cond) {
; CHECK-LABEL: @func(
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       bb2:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[PHI_IN_IN:%.*]] = phi ptr [ [[X:%.*]], [[BB1]] ], [ [[Y:%.*]], [[BB2]] ]
; CHECK-NEXT:    [[PHI_IN:%.*]] = ptrtoint ptr [[PHI_IN_IN]] to i64
; CHECK-NEXT:    ret i64 [[PHI_IN]]
;
  br i1 %cond, label %bb1, label %bb2

bb1:
  %X.i = ptrtoint ptr %X to i64
  %X.p = inttoptr i64 %X.i to ptr
  br label %exit

bb2:
  %Y.i = ptrtoint ptr %Y to i64
  %Y.p = inttoptr i64 %Y.i to ptr
  br label %exit

exit:
  %phi = phi ptr [%X.p, %bb1], [%Y.p, %bb2]
  %X.p.i = ptrtoint ptr %phi to i64
  ret i64 %X.p.i
}

define i64 @func_single_operand(ptr %X, ptr %Y, i1 %cond) {
; CHECK-LABEL: @func_single_operand(
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[BB1:%.*]], label [[EXIT:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[PHI_IN:%.*]] = phi ptr [ [[X:%.*]], [[BB1]] ], [ [[Y:%.*]], [[TMP0:%.*]] ]
; CHECK-NEXT:    [[X_P_I:%.*]] = ptrtoint ptr [[PHI_IN]] to i64
; CHECK-NEXT:    ret i64 [[X_P_I]]
;
  br i1 %cond, label %bb1, label %exit

bb1:
  %X.i = ptrtoint ptr %X to i64
  %X.p = inttoptr i64 %X.i to ptr
  br label %exit

exit:
  %phi = phi ptr [%X.p, %bb1], [%Y, %0]
  %X.p.i = ptrtoint ptr %phi to i64
  ret i64 %X.p.i
}

define i64 @func_pointer_different_types(ptr %X, ptr %Y, i1 %cond) {
; CHECK-LABEL: @func_pointer_different_types(
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[BB1:%.*]], label [[EXIT:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[PHI:%.*]] = phi ptr [ [[X:%.*]], [[BB1]] ], [ [[Y:%.*]], [[TMP0:%.*]] ]
; CHECK-NEXT:    [[X_P_I:%.*]] = ptrtoint ptr [[PHI]] to i64
; CHECK-NEXT:    ret i64 [[X_P_I]]
;
  br i1 %cond, label %bb1, label %exit

bb1:
  %X.i = ptrtoint ptr %X to i64
  %X.p = inttoptr i64 %X.i to ptr
  br label %exit

exit:
  %phi = phi ptr [%X.p, %bb1], [%Y, %0]
  %X.p.i = ptrtoint ptr %phi to i64
  ret i64 %X.p.i
}

; Negative test - Wrong Integer type

define i64 @func_integer_type_too_small(ptr %X, ptr %Y, i1 %cond) {
; CHECK-LABEL: @func_integer_type_too_small(
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[BB1:%.*]], label [[EXIT:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[X:%.*]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = and i64 [[TMP1]], 4294967295
; CHECK-NEXT:    [[X_P:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[PHI:%.*]] = phi ptr [ [[X_P]], [[BB1]] ], [ [[Y:%.*]], [[TMP0:%.*]] ]
; CHECK-NEXT:    [[X_P_I:%.*]] = ptrtoint ptr [[PHI]] to i64
; CHECK-NEXT:    ret i64 [[X_P_I]]
;
  br i1 %cond, label %bb1, label %exit

bb1:
  %X.i = ptrtoint ptr %X to i32
  %X.p = inttoptr i32 %X.i to ptr
  br label %exit

exit:
  %phi = phi ptr [%X.p, %bb1], [%Y, %0]
  %X.p.i = ptrtoint ptr %phi to i64
  ret i64 %X.p.i
}

; Negative test - phi not used in ptrtoint

define ptr @func_phi_not_use_in_ptr2int(ptr %X, ptr %Y, i1 %cond) {
; CHECK-LABEL: @func_phi_not_use_in_ptr2int(
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[BB1:%.*]], label [[EXIT:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[X:%.*]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = and i64 [[TMP1]], 4294967295
; CHECK-NEXT:    [[X_P:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[PHI:%.*]] = phi ptr [ [[X_P]], [[BB1]] ], [ [[Y:%.*]], [[TMP0:%.*]] ]
; CHECK-NEXT:    ret ptr [[PHI]]
;
  br i1 %cond, label %bb1, label %exit

bb1:
  %X.i = ptrtoint ptr %X to i32
  %X.p = inttoptr i32 %X.i to ptr
  br label %exit

exit:
  %phi = phi ptr [%X.p, %bb1], [%Y, %0]
  ret ptr %phi
}

; Negative test - Pointers in different address spaces

define i64 @func_ptr_different_addrspace(ptr addrspace(2) %X, ptr %Y, i1 %cond) {
; CHECK-LABEL: @func_ptr_different_addrspace(
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[BB1:%.*]], label [[EXIT:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr addrspace(2) [[X:%.*]] to i32
; CHECK-NEXT:    [[X_I:%.*]] = zext i32 [[TMP1]] to i64
; CHECK-NEXT:    [[X_P:%.*]] = inttoptr i64 [[X_I]] to ptr
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[PHI:%.*]] = phi ptr [ [[X_P]], [[BB1]] ], [ [[Y:%.*]], [[TMP0:%.*]] ]
; CHECK-NEXT:    [[X_P_I:%.*]] = ptrtoint ptr [[PHI]] to i64
; CHECK-NEXT:    ret i64 [[X_P_I]]
;
  br i1 %cond, label %bb1, label %exit

bb1:
  %X.i = ptrtoint ptr addrspace(2) %X to i64
  %X.p = inttoptr i64 %X.i to ptr
  br label %exit

exit:
  %phi = phi ptr [%X.p, %bb1], [%Y, %0]
  %X.p.i = ptrtoint ptr %phi to i64
  ret i64 %X.p.i
}
