; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu -O0 -global-isel -stop-after=irtranslator -o - %s | FileCheck %s

define <1 x float> @ret_v1f32(<1 x float> %v) {
  ; CHECK-LABEL: name: ret_v1f32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $d0
  ; CHECK:   [[COPY:%[0-9]+]]:_(<2 x s32>) = COPY $d0
  ; CHECK:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[COPY]](<2 x s32>)
  ; CHECK:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[UV]](s32), [[DEF]](s32)
  ; CHECK:   $d0 = COPY [[BUILD_VECTOR]](<2 x s32>)
  ; CHECK:   RET_ReallyLR implicit $d0
  ret <1 x float> %v
}

define <1 x ptr> @ret_v1p0(<1 x ptr> %v) {
  ; CHECK-LABEL: name: ret_v1p0
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $d0
  ; CHECK:   [[COPY:%[0-9]+]]:_(p0) = COPY $d0
  ; CHECK:   $d0 = COPY [[COPY]](p0)
  ; CHECK:   RET_ReallyLR implicit $d0
  ret <1 x ptr> %v
}

define <1 x ptr addrspace(1)> @ret_v1p1(<1 x ptr addrspace(1)> %v) {
  ; CHECK-LABEL: name: ret_v1p1
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $d0
  ; CHECK:   [[COPY:%[0-9]+]]:_(p1) = COPY $d0
  ; CHECK:   $d0 = COPY [[COPY]](p1)
  ; CHECK:   RET_ReallyLR implicit $d0
  ret <1 x ptr addrspace(1)> %v
}
